!--
!----------------------------------------------------------------------
! Copyright(c) 2002-2013 SPMODEL Development Group. All rights reserved.
!----------------------------------------------------------------------
!ɽ  lumatrix :  LU ʬˤϢΩβ
!
!      spml/lumatrix ⥸塼, LU ʬˡˤϢΩ 1 򤯤
!      Fortran90 ؿ󶡤.
!
!      ¾Υڥȥ׻ѥ⥸塼о줹붭򤯤
!      ѤƤ.
!
!      ٥ȥ׻ռ, ƱʣĤϢΩ1 
!
!          A[ij]^(n) X [j]^(n) = B[i]^(n)
!
!      βƱʣĤαե٥ȥ B[i]^(n)b ФƵ뤳Ȥ
!      Ǥ褦ˤʤäƤ.
!
!
!  2002/01/20  ݹ
!      2002/06/10  ݹ  ٥ȥĹΤ lusol2 
!      2005/01/10  ݹ  msgdmp -> MessageNotify ѹ
!      2006/03/04  ݹ  Ȥ RDoc Ѥ˽
!      2009/01/29  ʿ  Ȥ RDoc Ѥ˽
!      2009/08/06  ݹ    ludecomp21 ѥ롼 OMP ѹ
!      2013/12/14  ʿ interface 
!
!++

module lumatrix
  !
  != lumatrix
  !
  ! Authors:: Shin-ichi Takehiro, Youhei SASAKI
  ! Version:: $Id: lumatrix.f90 625 2014-01-28 05:39:15Z uwabami $
  ! Copyright&License:: See COPYRIGHT[link:../COPYRIGHT]
  !
  !== 
  !
  ! spml/lumatrix ⥸塼, LU ʬˡˤϢΩ 1 򤯤
  ! Fortran90 ؿ󶡤.
  !
  ! ¾Υڥȥ׻ѥ⥸塼о줹붭򤯤
  ! ѤƤ.
  !
  ! ٥ȥ׻ռ, ƱʣĤϢΩ1 
  !
  !     A[ij]^(n) X [j]^(n) = B[i]^(n)
  !
  ! βƱʣĤαե٥ȥ B[i]^(n)b ФƵ뤳Ȥ
  ! Ǥ褦ˤʤäƤ.
  !
  !== ѿ³
  !
  ! LUDecomp    ::  LU ʬԤ
  ! LUSolve     :: ϢΩ 1 β
  !
  private
  public LUDecomp, LUSolve

  interface LUDecomp
     !
     !=== Ϳ줿 LU ʬԤ, ԥܥåȤǼ.
     !
     ! * LU ʬ򤵤줿̤ Alu ˾񤭤.
     !   ΥԥܥåȾ kp ˳Ǽ.
     !
     ! * LUSolve ѤˤΥ֥롼Ƥ Alu  kp 
     !   ׻Ƥ.
     !
     ! * Ϥȥԥܥåμˤäǥ֥롼
     !   ȤʬƤ. 桼󥿡ե϶̤ǤΤ
     !   롼Ǥ ludecomp21, ludecomp32 ƤɬפϤʤ.
     !
     !=== ȷ̤η
     !
     ! * Alu  2 (Ϳ뷸 1 )ξ
     !
     !     ! ALU(NDIM,NDIM), KP(NDIM)
     !     ! NDIM x NDIM ι LU ʬ.
     !     ! LU  Ϲ˾񤭤.
     !
     !     real(8), intent(inout) :: alu(:,: )         ! ϡLU 
     !     integer, intent(out)   :: kp(size(alu,1))   ! ԥܥå
     !
     !
     ! * Alu  3 (Ϳ뷸ʣ)ξ
     !
     !     ! ALU(JDIM,NDIM,NDIM), KP(JDIM,NDIM)
     !     ! NDIM x NDIM ι JDIM Ĥ٤ LU ʬ.
     !     ! LU  Ϲ˾񤭤.
     !
     !     real(8), intent(inout) :: alu(:,:,:)      ! ϡLU 
     !     integer, intent(out)   :: kp(size(alu,1),size(alu,2)) ! ԥܥå
     !
     !
    module procedure ludecomp21, ludecomp32
  end interface

  interface LUSolve
     !
     ! ϢΩ 1 β
     !
     !  * LUSolve Ѥ LUDecompƤ Alu  LU ʬ,
     !    ԥܥåȾ kp ׻ƤͤФʤʤ.
     !
     !  * Ϥȥԥܥåμˤäǥ֥롼
     !    ȤʬƤ. 桼󥿡ե϶̤ǤΤ
     !    롼Ǥ lusolve??? ƤɬפϤʤ.
     !
     ! ȷ̤η
     !
     !  *  Alu  2 (Ϳ뷸 1 ),
     !     b  1 (Ϳ뱦ե٥ȥ뤬 1 )ξ
     !
     !     ! ALU(NDIM,NDIM), KP(NDIM), B(NDIM)
     !     ! NDIM x NDIM ϢΩ
     !     ! A X = B  1 Ĥ B ФƷ׻.
     !
     !     real(8), intent(in)  :: alu(:,:)              ! ϡLU 
     !     integer, intent(in)  :: kp(:)                 ! ԥܥå
     !     real(8), intent(in)  :: b(:)                  ! ե٥ȥ
     !
     !     real(8) :: lusolve(size(b))                   ! 
     !
     !  * Alu  2 (Ϳ뷸 1 ),
     !    b  2 (Ϳ뱦ե٥ȥ뤬ʣ)ξ
     !
     !     ! ALU(NDIM,NDIM), KP(NDIM), B(JDIM,NDIM)
     !     ! NDIM x NDIM ϢΩ
     !     ! A X = B  JDIM Ĥ B ФƷ׻.
     !
     !     real(8), intent(in)  :: alu(:,:)              ! ϡLU 
     !     integer, intent(in)  :: kp(:)                 ! ԥܥå
     !     real(8), intent(in)  :: b(:,:)                ! ե٥ȥ
     !
     !     real(8) :: lusolve(size(b,1),size(b,2))       ! 
     !
     !
     !  * Alu  3 (Ϳ뷸ʣ),
     !    b  2 (Ϳ뱦ե٥ȥ뤬 1 )ξ
     !
     !     ! ALU(JDIM,NDIM,NDIM), KP(JDIM,NDIM), B(JDIM,NDIM)
     !     ! NDIM x NDIM  JDIM ¤٤ϢΩ
     !     ! A X = B ҤȤĤ B ¤ӤФƷ׻.
     !
     !     real(8), intent(in)  :: alu(:,:,:)            ! ϡLU 
     !     integer, intent(in)  :: kp(:,:)               ! ԥܥå
     !     real(8), intent(in)  :: b(:,:)                ! ե٥ȥ
     !
     !     real(8) :: lusolve(size(b,1),size(b,2))             ! 
     !
     !
     !  * Alu  3 (Ϳ뷸ʣ),
     !    b  3 (Ϳ뱦ե٥ȥ뤬ʣ)ξ
     !
     !     ! ALU(JDIM,NDIM,NDIM), KP(JDIM,NDIM), B(IDIM,JDIM,NDIM)
     !     ! NDIM x NDIM  JDIM ¤٤ϢΩ
     !     ! A X = B  IDIM Ĥ B ФƷ׻.
     !
     !     real(8), intent(in)  :: alu(:,:,:)                ! ϡLU 
     !     integer, intent(in)  :: kp(:,:)                   ! ԥܥå
     !     real(8), intent(in)  :: b(:,:,:)                  ! ե٥ȥ
     !
     !     real(8) :: lusolve(size(b,1),size(b,2),size(b,3)) ! 
     !
     !
    module procedure lusolve211, lusolve212, lusolve322, lusolve323
  end interface LUSolve

contains

  subroutine ludecomp21(alu,kp)
    !
    ! ALU(NDIM,NDIM), KP(NDIM)
    ! NDIM x NDIM ι LU ʬ.
    ! LU  Ϲ˾񤭤.
    !
    use dc_message

    real(8), intent(inout) :: alu(:,:)                  ! ϡLU 
    integer, intent(out)   :: kp(size(alu,1))           ! ԥܥå

    if ( size(alu,1) > size(alu,2) ) then
      call MessageNotify('E','ludecomp',&
        'The third dimension is less than the second')
    elseif( size(alu,1) < size(alu,2) ) then
      call MessageNotify('W','ludecomp',&
        'The third dimension is grater than the second')
    endif

    !" LU ʬʬԥܥå
    call LUMAK1( alu, kp, size(alu,1) )

  end subroutine ludecomp21

  subroutine ludecomp32(alu,kp)
    !
    ! ALU(JDIM,NDIM,NDIM), KP(JDIM,NDIM)
    ! NDIM x NDIM ι JDIM Ĥ٤ LU ʬ.
    ! LU  Ϲ˾񤭤.
    !
    use dc_message

    real(8), intent(inout) :: alu(:,:,:)                  ! ϡLU 
    integer, intent(out)   :: kp(size(alu,1),size(alu,2)) ! ԥܥå

    if ( size(alu,2) > size(alu,3) ) then
      call MessageNotify('E','ludecomp',&
        'The third dimension is less than the second')
    elseif( size(alu,2) < size(alu,3) ) then
      call MessageNotify('W','ludecomp',&
        'The third dimension is grater than the second')
    endif

    !" LU ʬʬԥܥå
    call LUMAKE( alu, kp, size(alu,1), size(alu,2) )

  end subroutine ludecomp32

  function lusolve211(alu,kp,b)
    !
    ! ALU(NDIM,NDIM), KP(NDIM), B(NDIM)
    ! NDIM x NDIM ϢΩ
    ! A X = B  1 Ĥ B ФƷ׻.
    !
    use dc_message

    real(8), intent(in)  :: alu(:,:)              ! ϡLU 
    integer, intent(in)  :: kp(:)                 ! ԥܥå
    real(8), intent(in)  :: b(:)                  ! ե٥ȥ

    real(8) :: lusolve211(size(b))                   ! 

    lusolve211 = b
    call LUSOL2( lusolve211, alu , kp, &             !" LU ʬˤη׻
      1, size(b) )

  end function lusolve211

  function lusolve212(alu,kp,b)
    !
    ! ALU(NDIM,NDIM), KP(NDIM), B(JDIM,NDIM)
    ! NDIM x NDIM ϢΩ
    ! A X = B  JDIM Ĥ B ФƷ׻.
    !
    use dc_message

    real(8), intent(in)  :: alu(:,:)              ! ϡLU 
    integer, intent(in)  :: kp(:)                 ! ԥܥå
    real(8), intent(in)  :: b(:,:)                ! ե٥ȥ

    real(8) :: lusolve212(size(b,1),size(b,2))       ! 

    lusolve212 = b
    call LUSOL2( lusolve212, alu , kp, &             !" LU ʬˤη׻
      size(b,1), size(b,2) )

  end function lusolve212

  function lusolve322(alu,kp,b)
    !
    ! ALU(JDIM,NDIM,NDIM), KP(JDIM,NDIM), B(JDIM,NDIM)
    ! NDIM x NDIM  JDIM ¤٤ϢΩ
    ! A X = B ҤȤĤ B ¤ӤФƷ׻.
    !
    use dc_message

    real(8), intent(in)  :: alu(:,:,:)                   ! ϡLU 
    integer, intent(in)  :: kp(:,:)                      ! ԥܥå
    real(8), intent(in)  :: b(:,:)                       ! ե٥ȥ

    real(8) :: lusolve322(size(b,1),size(b,2))             ! 

    lusolve322 = b
    call LUSOLV( lusolve322, alu , kp, &           !" LU ʬˤη׻
      1, size(b,1), size(b,2) )

  end function lusolve322

  function lusolve323(alu,kp,b)
    !
    ! ALU(JDIM,NDIM,NDIM), KP(JDIM,NDIM), B(IDIM,JDIM,NDIM)
    ! NDIM x NDIM  JDIM ¤٤ϢΩ
    ! A X = B  IDIM Ĥ B ФƷ׻.
    !
    use dc_message

    real(8), intent(in)  :: alu(:,:,:)                   ! ϡLU 
    integer, intent(in)  :: kp(:,:)                      ! ԥܥå
    real(8), intent(in)  :: b(:,:,:)                     ! ե٥ȥ

    real(8) :: lusolve323(size(b,1),size(b,2),size(b,3)) ! 

    lusolve323 = b
    call LUSOLV( lusolve323, alu , kp, &           !" LU ʬˤη׻
      size(b,1), size(b,2), size(b,3) )

  end function lusolve323
end module lumatrix
