!----------------------------------------------------------------------
!     Copyright (c) 2010--2012 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  wtq_module_sjpack ƥȥץ
!
!      ȥݥƥ󥷥ζ
!
!  2010/04/18  ݹ   wt_module_sjpack_test_tormagbc.f90 ¤
!      2011/09/14  ݹ   MPI 
!      2011/09/14  ݹ   wtq_mpi_module Ѥ˲¤
!      2012/04/02  ݹ   wtq_mpi_module_sjpack Ѥ˲¤
!      2012/04/03  ݹ   wtq_module_sjpack Ѥ˲¤
!
program wtq_module_sjpack_tormagbc_wt

  use dc_message, only : MessageNotify
  use dc_test, only : AssertEqual
  use wtq_module_sjpack

  implicit none

  integer,parameter  :: im=32, jm=16         ! ʻ(, , ư)
  integer,parameter  :: kmo=16, kmi=10       ! ʻ(ư, ư)
  integer,parameter  :: nm=10                ! ȿ(ʿ)
  integer,parameter  :: lmo=16, lmi=16       ! ȿ(ư, ư)
  real(8),parameter  :: ri=0.5, ro=1.5       ! ⳰Ⱦ

  real(8), dimension(0:im-1,1:jm,0:kmo)     :: xyz_TORMAG
  real(8), dimension((nm+1)*(nm+1),0:lmo)   :: wt_TORMAG

  real(8), dimension(0:im-1,1:jm,0:kmo)     :: xyz_Zero = 0.0D0

  ! Ƚ
  integer, parameter :: check_digits = 9
  integer, parameter :: ignore = -10

  real(8), parameter  :: pi=3.1415926535897932385D0

  call MessageNotify('M','wt_module_sjpack_tormagbc_test', &
       'wt_module_sjpack wt_TormagBoundaries subroutine test')

  call wtq_Initial(im,jm,kmi,kmo,nm,lmi,lmo,ri,ro)

 !==================== wt_TormagBoundaries =========================
  ! P_10
  xyz_TORMAG = sin(xyz_lat) * cos( pi*(xyz_rad-ri)/(ro-ri) )
  ! P_1_1
  !xyz_TORMAG = cos(xyz_lat)*cos(xyz_lon)* cos( pi*(xyz_rad-ri)/(ro-ri) )
  !xyz_TORMAG = 2*sin(xyz_lat)**2 * cos( pi*(xyz_rad-ri)/(ro-ri) )

  wt_TORMAG = wt_xyz(xyz_TORMAG)
  call wt_TormagBoundaries(wt_TORMAG)
  xyz_TORMAG = xyz_wt(wt_TORMAG)

  call AssertEqual(&
       message='wt_TormagBoundaries (Top B.C.)',                     &
       answer = xyz_Zero(:,:,0),                                     &
       check = xyz_TORMAG(:,:,0),                                    &
       significant_digits = check_digits, ignore_digits = ignore     &
       )
  call AssertEqual(&
       message='wt_TormagBoundaries (Bottom B.C.)',                  &
       answer = xyz_Zero(:,:,kmo),                                    &
       check = xyz_TORMAG(:,:,kmo),                                   &
       significant_digits = check_digits, ignore_digits = ignore     &
       )

 !==================== wt_TormagBoundariesGrid =========================
  ! P_10
  !xyz_TORMAG = sin(xyz_lat) * cos( pi*(xyz_rad-ri)/(ro-ri) )
  ! P_1_1
  xyz_TORMAG = cos(xyz_lat)*cos(xyz_lon)* cos( pi*(xyz_rad-ri)/(ro-ri) )
  !xyz_TORMAG = 2*sin(xyz_lat)**2 * cos( pi*(xyz_rad-ri)/(ro-ri) )

  wt_TORMAG = wt_xyz(xyz_TORMAG)
  call wt_TormagBoundariesGrid(wt_TORMAG)
  xyz_TORMAG = xyz_wt(wt_TORMAG)


  call AssertEqual(&
       message='wt_TormagBoundariesGrid (Top B.C.)',                 &
       answer = xyz_Zero(:,:,0),                                     &
       check = xyz_TORMAG(:,:,0),                                    &
       significant_digits = check_digits, ignore_digits = ignore     &
       )
  call AssertEqual(&
       message='wt_TormagBoundariesGrid (Bottom B.C.)',              &
       answer = xyz_Zero(:,:,kmo),                                    &
       check = xyz_TORMAG(:,:,kmo),                                   &
       significant_digits = check_digits, ignore_digits = ignore     &
       )

  call MessageNotify('M','wtq_module_sjpack_tormagbc_wt_test', &
       'wtq_module_sjpack wt_TormagBoundaries subroutine test succeeded!')

end program wtq_module_sjpack_tormagbc_wt
