#!/bin/sh
#
# Copyright (C) GFD Dennou Club, 2002-2013.  All rights reserved.
#
prefix=$PREFIX
version=$VERSION
out=${1:-spmfrt}

cat > $out <<EOF
#!/bin/sh
#=begin
#== NAME
#((* $out *)) -- script for fortran usin spml
#
#Wrapper shell script for fortran compiler using spml
#
#== SYNTAX
#
# % $out [fortran_compiler_option] fortran_program.f90
#
#== DESCRIPTION
#
#((* $out *)) is simple shell script.
#This script set environment variables for using spml library.
#
#== OPTION
#
#:fortran_compiler_option
#  commonly used fortran compiler option, see your fortran compiler manual
#
#== BUGS
#
#If you find a bug, please report it at SPMODEL Development Group
#<dcstaff_(at)_gfd-dennou.org>
#=end

EOF


cat >> $out <<EOF
prefix="$prefix"
exec_prefix=${prefix}
bindir=${prefix}/bin
spmconfig=${prefix}/bin/spmconfig
version="$version"

fc=\`\$spmconfig --fc\`
mpifc=\`\$spmconfig --mpifc\`
fcflags=\`\$spmconfig --fcflags\`
ldflags=\`\$spmconfig --ldflags\`
ldlibs=\`\$spmconfig --ldlibs\`
version="$version"

EOF

if test x"$out" = x"mpispmfrt" ; then
cat >> $out <<EOF

echo \$mpifc \$fcflags "\$@" \$ldlibs \$ldflags
exec \$mpifc \$fcflags "\$@" \$ldlibs \$ldflags
EOF
else
cat >> $out <<EOF

echo \$fc \$fcflags "\$@" \$ldlibs \$ldflags
exec \$fc \$fcflags "\$@" \$ldlibs \$ldflags
EOF
fi
