!----------------------------------------------------------------------
!     Copyright (c) 2012 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  wa_base_module ƥȥץ :: ѴؿΥƥ
!
!  2012/04/03  ݹ
!
program wa_base_mpi_module_test

  use dc_message, only : MessageNotify
  use dc_test, only : AssertEqual
  use wa_mpi_module
  use mpi
  implicit none

  integer, parameter :: im=32, jm=16, nm=10, km=3

  real(8), allocatable ::  wa_data(:,:)
  real(8), allocatable ::  xva_data(:,:,:)
  real(8), allocatable ::  xya_data(:,:,:)

  ! Ƚ
  integer, parameter :: check_digits = 10
  integer, parameter :: ignore = -11

  real(8) :: pi
  integer :: iproc, np, ierr

  integer :: n, k

 !---------------- MPI  ---------------------
  call MPI_INIT(IERR)
  call MPI_COMM_RANK(MPI_COMM_WORLD,IPROC,IERR)
  call MPI_COMM_SIZE(MPI_COMM_WORLD,NP,IERR)

  pi = atan(1.0D0)*4.0D0

  call MessageNotify('M','wa_base_mpi_module_test', &
                         'wa_base_mpi_module functions tests') 

  call wa_mpi_Initial( nm, im, jm, km )

  allocate(wa_data((nm+1)**2,km))
  allocate(xva_data(0:im-1,jc,km))
  allocate(xya_data(0:im-1,jm,km))

  !========================= xva_wa, wa_xva Υƥ===========================

  !---- Y_1^* Υƥ ----
  xva_data(:,:,1) = sqrt(3.0D0)*sin(xv_Lat)                   ! Y_1^0
  wa_data= 0.0D0 ; wa_data(l_nm(1,0),1)=1.0D0
  xva_data(:,:,2) = sqrt(3.0D0/2)*cos(xv_Lat)*cos(xv_Lon)     ! Y_1^1
  wa_data(l_nm(1,1),2)=1.0D0/sqrt(2.0D0)
  xva_data(:,:,3) = -sqrt(3.0D0/2)*cos(xv_Lat)*sin(xv_Lon)    ! Y_1^{-1}
  wa_data(l_nm(1,-1),3)=1.0D0/sqrt(2.0D0)

  call AssertEqual(&
    message='wa_xva with Y_1^*',                                  &
    answer = wa_xva(xva_data),                                    &
    check = wa_data,                                              &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='xva_wa with Y_1^*',                                  &
    answer = xva_wa(wa_xva(xva_data)),                            &
    check = xva_data,                                             &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !---- Y_2^* Υƥ ----
  xva_data(:,:,1) = sqrt(5.0D0)*(3.0/2*sin(xv_Lat)**2-1/2.0)           ! Y_2^0
  wa_data= 0.0D0 ; wa_data(l_nm(2,0),1)=1.0D0
  xva_data(:,:,2) = sqrt(5.0D0/6)*3.0*sin(xv_Lat)*cos(xv_Lat)*cos(xv_Lon)!Y_2^1
  wa_data(l_nm(2,1),2)=1.0D0/sqrt(2.0D0)
  xva_data(:,:,3) = -sqrt(5.0D0/24)*3.0*cos(xv_Lat)**2*sin(2*xv_Lon)   ! Y_2^-2
  wa_data(l_nm(2,-2),3)=1.0D0/sqrt(2.0D0)

  call AssertEqual(&
    message='wa_xva with Y_2^*',                                  &
    answer = wa_xva(xva_data),                                    &
    check = wa_data,                                              &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='xva_wa with Y_2^*',                                  &
    answer = xva_wa(wa_xva(xva_data)),                            &
    check = xva_data,                                             &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !---- ŪؿΥƥ ----
  xva_data(:,:,1) = cos(2*xv_Lon-pi/3) &
       *(sin(xv_Lat)-1)**2*(sin(xv_Lat)-0.5)*(sin(xv_Lat)+1)
  xva_data(:,:,2) = sin(2*xv_Lon+pi/2) &
       *(sin(xv_Lat)-1)**2*(sin(xv_Lat)+1)**2
  xva_data(:,:,3) = cos(2*xv_Lon+pi/3) &
       *(sin(xv_Lat)-1)*(sin(xv_Lat)-0.5)**2*(sin(xv_Lat)+1)

  call AssertEqual(&
    message='wa_xva, xva_wa with a general function',             &
    answer = xva_wa(wa_xva(xva_data)),                            &
    check = xva_data,                                             &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !========================= xya_wa, wa_xya Υƥ===========================

  !---- Y_1^* Υƥ ----
  xya_data(:,:,1) = sqrt(3.0D0)*sin(xy_Lat)                   ! Y_1^0
  wa_data= 0.0D0 ; wa_data(l_nm(1,0),1)=1.0D0
  xya_data(:,:,2) = sqrt(3.0D0/2)*cos(xy_Lat)*cos(xy_Lon)     ! Y_1^1
  wa_data(l_nm(1,1),2)=1.0D0/sqrt(2.0D0)
  xya_data(:,:,3) = -sqrt(3.0D0/2)*cos(xy_Lat)*sin(xy_Lon)    ! Y_1^{-1}
  wa_data(l_nm(1,-1),3)=1.0D0/sqrt(2.0D0)

  call AssertEqual(&
    message='wa_xya with Y_1^*',                                  &
    answer = wa_xya(xya_data),                                    &
    check = wa_data,                                              &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='xya_wa with Y_1^*',                                  &
    answer = xya_wa(wa_xya(xya_data)),                            &
    check = xya_data,                                             &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !---- Y_2^* Υƥ ----
  xya_data(:,:,1) = sqrt(5.0D0)*(3.0/2*sin(xy_Lat)**2-1/2.0)           ! Y_2^0
  wa_data= 0.0D0 ; wa_data(l_nm(2,0),1)=1.0D0
  xya_data(:,:,2) = sqrt(5.0D0/6)*3.0*sin(xy_Lat)*cos(xy_Lat)*cos(xy_Lon)!Y_2^1
  wa_data(l_nm(2,1),2)=1.0D0/sqrt(2.0D0)
  xya_data(:,:,3) = -sqrt(5.0D0/24)*3.0*cos(xy_Lat)**2*sin(2*xy_Lon)   ! Y_2^-2
  wa_data(l_nm(2,-2),3)=1.0D0/sqrt(2.0D0)

  call AssertEqual(&
    message='wa_xya with Y_2^*',                                  &
    answer = wa_xya(xya_data),                                    &
    check = wa_data,                                              &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='xya_wa with Y_2^*',                                  &
    answer = xya_wa(wa_xya(xya_data)),                            &
    check = xya_data,                                             &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !---- ŪؿΥƥ ----
  xya_data(:,:,1) = cos(2*xy_Lon-pi/3) &
       *(sin(xy_Lat)-1)**2*(sin(xy_Lat)-0.5)*(sin(xy_Lat)+1)
  xya_data(:,:,2) = sin(2*xy_Lon+pi/2) &
       *(sin(xy_Lat)-1)**2*(sin(xy_Lat)+1)**2
  xya_data(:,:,3) = cos(2*xy_Lon+pi/3) &
       *(sin(xy_Lat)-1)*(sin(xy_Lat)-0.5)**2*(sin(xy_Lat)+1)

  call AssertEqual(&
    message='wa_xya, xya_wa with a general function',             &
    answer = xya_wa(wa_xya(xya_data)),                            &
    check = xya_data,                                             &
    significant_digits = check_digits, ignore_digits = ignore     &
    )


  call MessageNotify('M','wa_base_mpi_module_test', &
                         'wa_base_mpi_module functions tests succeeded!') 

 !------ MPIνλ ------

  call MPI_FINALIZE(IERR)

end program wa_base_mpi_module_test
