require "rubygems" unless defined?(Gem)

require "mkmf"
require "rbconfig"
so = RbConfig::CONFIG["DLEXT"]

raise("Your gem is too old") unless Gem.respond_to?(:find_files) 

env = ENV['NARRAY_TYPE']
if env == "NArray" || env == "narray"
  na_type = "narray"
elsif env == "NumRu::NArray" || env == "numru-narray"
  na_type = "numru-narray"
elsif !env.nil?
  raise "Unsupported value for the environment variable NARRAY_TYPE: #{env}"
else
  if Gem.find_files("narray.h").length > 0
    na_type = "narray"
  elsif Gem.find_files("numru/narray/narray.h").length > 0
    na_type = "numru-narray"
  end
end

case na_type
when "narray"
  narray_include = File.expand_path(File.dirname(Gem.find_files("narray.h")[0]))
  narray_lib = File.expand_path(File.dirname(Gem.find_files("narray." + so)[0]))
  File.open("../../lib/numru/dcl/narray_type.rb","w"){|f| f.puts <<EOS
module NumRu
  module DCL
    SUPPORT_BIGMEM = false
  end
end
EOS
  }
when "numru-narray"
  narray_include = File.expand_path(File.dirname(Gem.find_files("numru/narray/narray.h")[0]))
  narray_lib = File.expand_path(File.dirname(Gem.find_files("numru/narray/narray." + so)[0]))
  File.open("../../lib/numru/dcl/narray_type.rb","w"){|f| f.puts <<EOS
module NumRu
  module DCL
    SUPPORT_BIGMEM = true
  end
end
EOS
  }
end

### disabled (for very old gem, perhaps <= 1.2) -->
#  gem_home=(`gem environment GEM_HOME`).chomp
#  narray_dir = Dir.glob("#{gem_home}/gems/narray-*/ext/narray").sort[-1]
#  if narray_dir
#    narray_include = narray_lib = narray_dir
#  else
#    narray_include = narray_lib = [ $sitearchdir, $vendorarchdir]
#  end
### <-- disabled

dir_config('narray', narray_include, narray_lib)
if ( ! ( have_header("narray.h") && have_header("narray_config.h") ) ) then
   print <<-EOS
   ** configure error **  
   Header narray.h or narray_config.h is not found. If you have these files in 
   /narraydir/include, try the following:

   % ruby extconf.rb --with-narray-include=/narraydir/include

   EOS
   exit(-1)
end

initcfile_default = $srcdir+"/init.c.default"
initcfile = $srcdir+"/init.c"

if(xsystem("which cdclconfig"))
  cflags = `cdclconfig --cflags`.gsub(/\n/, " ")
  ldflags = `cdclconfig --ldflags`.gsub(/\n/, " ")
  ldlibs = `cdclconfig --ldlibs`.gsub(/-R.*?\s/, " ").gsub(/\n/, " ")
  print "checking DCL version... "
  dclversion = `cdclconfig --dclversion`.strip
  print "DCL Version: #{dclversion}\n"
  dclver = dclversion.gsub(/\./,'')
  dclver = dclver+'0' if dclver.length <= 2   # 53 --> 530 etc
  if dclversion < "5.2"
    raise "Supported DCL version is 5.2 or later, while you have #{dclversion}"
  end
  dclversionmacro = ' -DDCLVER='+dclver

  $CFLAGS += ' '+cflags  + dclversionmacro
  $LOCAL_LIBS += ' ' + ldflags
  $LOCAL_LIBS += ldlibs

  fin = File.open(initcfile_default)
  fout = File.open(initcfile,'w')
  while(line = fin.gets)
    fout.puts(line.sub(/DCLVersion/,'"'+dclversion+'"'))
  end
  fout.close
  fin.close

else
  raise "cdclconfig is not found."
end

create_makefile("numru/dcl_raw")
