!----------------------------------------------------------------------
!     Copyright (c) 2012 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  wq_mpi_module_sjpack ƥȥץ :: ѴؿΥƥ
!
!  2012/04/02  ݹ
!
program wq_mpi_module_sjpack_base_test

  use dc_message, only : MessageNotify
  use dc_test, only : AssertEqual
  use wq_mpi_module_sjpack
  use mpi
  implicit none

  integer,parameter  :: im=32, jm=16, km=16  ! ʻ(, , ư)
  integer,parameter  :: nm=10, lm=24         ! ȿ(ʿ, ư)
  real(8),parameter  :: ra=1.0               ! Ⱦ

  ! Ƚ
  integer, parameter :: check_digits = 10
  integer, parameter :: ignore = -11

  real(8), allocatable ::  xvr_data(:,:,:)
  real(8) :: pi
  integer :: iproc, np, ierr

 !---------------- MPI  ---------------------
  call MPI_INIT(IERR)
  call MPI_COMM_RANK(MPI_COMM_WORLD,IPROC,IERR)
  call MPI_COMM_SIZE(MPI_COMM_WORLD,NP,IERR)

  pi = atan(1.0D0)*4.0D0

  call MessageNotify('M','wq_mpi_module_sjapck_base_test', &
                         'wq_mpi_module_sjpack basic transformation functions tests') 

  call wq_mpi_Initial(im,jm,km,nm,lm,ra)

  allocate(xvr_data(0:im-1,jc,km))

  !---- Y_1^* Υƥ ----
  xvr_data = sqrt(3.0D0)*sin(xvr_Lat)*xvr_Rad        ! r Y_1^0 
  call AssertEqual(&
    message='xvr_wq with r Y_1^0',                                &
    answer = xvr_data,                                            &
    check = xvr_wq(wq_xvr(xvr_data)),                             &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  xvr_data = sqrt(3.0D0/2)*cos(xvr_Lat)*cos(xvr_Lon)*xvr_Rad**3   ! r^3Y_1^1 
  call AssertEqual(&
    message='xvr_wq with r^3 Y_1^1',                              &
    answer = xvr_data,                                            &
    check = xvr_wq(wq_xvr(xvr_data)),                             &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  xvr_data = -sqrt(3.0D0/2)*cos(xvr_Lat)*sin(xvr_Lon) * xvr_Rad**5  !r^5Y_1^{-1}
  call AssertEqual(&
    message='xvr_wq with r^5 Y_1^-1',                             &
    answer = xvr_data,                                            &
    check = xvr_wq(wq_xvr(xvr_data)),                             &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !---- Y_2^* Υƥ ----
  !r^2 Y_2^0
  xvr_data = sqrt(5.0D0)*(3.0/2*sin(xvr_Lat)**2-1/2.0) * xvr_Rad**2
  call AssertEqual(&
    message='xvr_wq with r^2 Y_2^0',                              &
    answer = xvr_data,                                            &
    check = xvr_wq(wq_xvr(xvr_data)),                             &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !r^4 Y_2^1 
  xvr_data = sqrt(5.0D0/6)*3.0*sin(xvr_Lat)*cos(xvr_Lat)*cos(xvr_Lon) &
            * xvr_Rad**4
  call AssertEqual(&
    message='xvr_wq with r^4 Y_2^1',                              &
    answer = xvr_data,                                            &
    check = xvr_wq(wq_xvr(xvr_data)),                             &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !r^6 Y_2^-2
  xvr_data = -sqrt(5.0D0/24)*3.0*cos(xvr_Lat)**2*sin(2*xvr_Lon)* xvr_Rad**6
  call AssertEqual(&
    message='xvr_wq with r^6 Y_2^-2',                             &
    answer = xvr_data,                                            &
    check = xvr_wq(wq_xvr(xvr_data)),                             &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  call MessageNotify('M','wq_mpi_module_sjpack_base_test', &
                         'wq_mpi_base_module_sjpack functions tests succeeded!') 


 !------ MPIνλ ------

  call MPI_FINALIZE(IERR)

end program wq_mpi_module_sjpack_base_test

