# How to Contribute

Thank you for your interest in contributing to our open-source project!
By contributing, you help us improve the project and make it better for everyone. Here are some guidelines to help you get started.

## Reporting Issues

If you encounter a bug, have a feature request, or have a question about the project, please open an issue on our GitHub repository.
When reporting an issue, please provide as much detail as possible, including:

1. A clear description of the problem or request
2. Steps to reproduce the problem, if applicable
2. Any error messages or screenshots that may help diagnose the issue

## Contributing Code

If you would like to contribute code to the project, please follow these steps:

1. Fork the project on GitHub
2. Clone your forked repository to your local machine
3. Test your code
4. Push your changes to your forked repository
5. Create a pull request from your branch into the `main` branch of the Baler project repository
6. Wait for your pull request to be reviewed and merged


## Commit Messages

Please follow these guidelines when writing commit messages:

- Use the present tense (e.g. "Add feature" instead of "Added feature")
- Start the commit message with a capital letter
- Keep the subject line short (less than 50 characters)
- Use the body of the commit message to explain what you changed and why

Here's an example commit message:

```
Add feature for user login

This feature adds the ability for users to log in to the site using their email and password.
```

## Pull Request Review

When reviewing a pull request, please keep the following in mind:

- The code should follow our style guide [black](https://github.com/psf/black)
- The code should be well-tested, with passing unit tests
- The commit messages should be clear and expressive
- The code should not introduce any new bugs or regressions

## Conclusion

We appreciate your contributions to our project! By following these guidelines, you can help ensure that your contributions are high-quality and easy to review. If you have any questions or need help with anything, please don't hesitate to reach out to us.
