{-# OPTIONS_GHC -fno-warn-missing-methods #-}
{-# LANGUAGE EmptyDataDecls #-}
module Darcs.Patch.Dummy ( DummyPatch ) where

import Darcs.Patch.Annotate ( Annotate )
import Darcs.Patch.Conflict ( Conflict, CommuteNoConflicts )
import Darcs.Patch.Debug ( PatchDebug(..) )
import Darcs.Patch.Effect ( Effect )
import Darcs.Patch.FileHunk ( IsHunk )
import Darcs.Patch.Format ( PatchListFormat )
import Darcs.Patch.Matchable ( Matchable )
import Darcs.Patch.Apply ( Apply(..) )
import Darcs.Patch.Commute ( Commute )
import Darcs.Patch.Invert ( Invert )
import Darcs.Patch.Inspect ( PatchInspect )
import Darcs.Patch.Read ( ReadPatch )
import Darcs.Patch.Show ( ShowPatch )
import Darcs.Patch.Prim ( FromPrim, PrimPatchCommon, PrimPatch, PrimPatchBase(..) )
import Darcs.Patch.Prim.Class
        ( PrimConstruct, PrimCanonize, PrimClassify
        , PrimDetails, PrimShow, PrimRead, PrimApply )
import Darcs.Patch.Merge ( Merge)
import Darcs.Patch.Repair ( Check, RepairToFL )
import Darcs.Patch.RepoPatch ( RepoPatch )
import Darcs.Patch.Show ( ShowPatchBasic, ShowContextPatch )
import Darcs.Patch.Witnesses.Eq ( Eq2 )
import Darcs.Patch.Witnesses.Show ( Show2 )
import Darcs.Util.Tree( Tree )


data DummyPrim wX wY
data DummyPatch wX wY

instance IsHunk DummyPrim
instance PatchListFormat DummyPrim
instance Eq2 DummyPrim
instance Invert DummyPrim
instance PatchInspect DummyPrim
instance ReadPatch DummyPrim
instance ShowPatchBasic DummyPrim
instance ShowPatch DummyPrim
instance ShowContextPatch DummyPrim
instance Commute DummyPrim
instance Apply DummyPrim where
  type ApplyState DummyPrim = Tree

instance RepairToFL DummyPrim
instance PrimConstruct DummyPrim
instance PrimCanonize DummyPrim
instance PrimClassify DummyPrim
instance PrimDetails DummyPrim
instance PrimShow DummyPrim
instance PrimRead DummyPrim
instance PrimApply DummyPrim
instance PrimPatch DummyPrim
instance Show2 DummyPrim

instance PatchDebug DummyPrim

instance PrimPatchCommon DummyPrim

instance IsHunk DummyPatch
instance PatchListFormat DummyPatch
instance Eq2 DummyPatch
instance Invert DummyPatch
instance PatchInspect DummyPatch
instance ReadPatch DummyPatch
instance ShowPatchBasic DummyPatch
instance ShowPatch DummyPatch
instance ShowContextPatch DummyPatch
instance Show2 DummyPatch
instance Commute DummyPatch
instance Apply DummyPatch where
  type ApplyState DummyPatch = Tree
instance Matchable DummyPatch
instance Annotate DummyPatch

instance Effect DummyPatch
instance Merge DummyPatch
instance Conflict DummyPatch
instance FromPrim DummyPatch
instance CommuteNoConflicts DummyPatch
instance Check DummyPatch
instance RepairToFL DummyPatch
instance PrimPatchBase DummyPatch where
   type PrimOf DummyPatch = DummyPrim
instance RepoPatch DummyPatch

instance PatchDebug DummyPatch
