// File/ImageLoader.h - This file is part of NotedELN

/* NotedELN is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   NotedELN is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with NotedELN.  If not, see <http://www.gnu.org/licenses/>.
*/

// ImageLoader.h

#ifndef IMAGELOADER_H

#define IMAGELOADER_H

#include <QObject>
#include <QImage>

class ImageLoader: public QObject {
  Q_OBJECT;
public:
  ImageLoader();
  // ImageLoaders must be constructed using NEW; never as a local object
  // on the stack.
  // Do not reparent the ImageLoader---otherwise, Qt might try to delete it.
  virtual ~ImageLoader();
  // Do not manually delete the ImageLoader after calling loadThenDelete.
  bool loadThenDelete(QString fn);
  // LOADTHENDELETE may be called only once.
  // Returns true, except if already called before.
signals:
  void loaded(QImage img);
private slots:
  void complete();
private:
  class ILThread *thr;
};

#endif
