//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armanalysisservices

// CheckServerNameAvailabilityParameters - Details of server name request body.
type CheckServerNameAvailabilityParameters struct {
	// Name for checking availability.
	Name *string `json:"name,omitempty"`

	// The resource type of azure analysis services.
	Type *string `json:"type,omitempty"`
}

// CheckServerNameAvailabilityResult - The checking result of server name availability.
type CheckServerNameAvailabilityResult struct {
	// The detailed message of the request unavailability.
	Message *string `json:"message,omitempty"`

	// Indicator of available of the server name.
	NameAvailable *bool `json:"nameAvailable,omitempty"`

	// The reason of unavailability.
	Reason *string `json:"reason,omitempty"`
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty" azure:"ro"`

	// READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ErrorDetail - The error detail.
type ErrorDetail struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo `json:"additionalInfo,omitempty" azure:"ro"`

	// READ-ONLY; The error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; The error details.
	Details []*ErrorDetail `json:"details,omitempty" azure:"ro"`

	// READ-ONLY; The http status code
	HTTPStatusCode *int32 `json:"httpStatusCode,omitempty" azure:"ro"`

	// READ-ONLY; The error message.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The error sub code
	SubCode *int32 `json:"subCode,omitempty" azure:"ro"`

	// READ-ONLY; The error target.
	Target *string `json:"target,omitempty" azure:"ro"`

	// READ-ONLY; the timestamp for the error.
	TimeStamp *string `json:"timeStamp,omitempty" azure:"ro"`
}

// ErrorResponse - Describes the format of Error response.
type ErrorResponse struct {
	// The error object
	Error *ErrorDetail `json:"error,omitempty"`
}

// GatewayDetails - The gateway details.
type GatewayDetails struct {
	// Gateway resource to be associated with the server.
	GatewayResourceID *string `json:"gatewayResourceId,omitempty"`

	// READ-ONLY; Uri of the DMTS cluster.
	DmtsClusterURI *string `json:"dmtsClusterUri,omitempty" azure:"ro"`

	// READ-ONLY; Gateway object id from in the DMTS cluster for the gateway resource.
	GatewayObjectID *string `json:"gatewayObjectId,omitempty" azure:"ro"`
}

// GatewayListStatusError - Status of gateway is error.
type GatewayListStatusError struct {
	// Error of the list gateway status.
	Error *ErrorDetail `json:"error,omitempty"`
}

// GatewayListStatusLive - Status of gateway is live.
type GatewayListStatusLive struct {
	// Live message of list gateway. Status: 0 - Live
	Status *int32 `json:"status,omitempty"`
}

// IPv4FirewallRule - The detail of firewall rule.
type IPv4FirewallRule struct {
	// The rule name.
	FirewallRuleName *string `json:"firewallRuleName,omitempty"`

	// The end range of IPv4.
	RangeEnd *string `json:"rangeEnd,omitempty"`

	// The start range of IPv4.
	RangeStart *string `json:"rangeStart,omitempty"`
}

// IPv4FirewallSettings - An array of firewall rules.
type IPv4FirewallSettings struct {
	// The indicator of enabling PBI service.
	EnablePowerBIService *bool `json:"enablePowerBIService,omitempty"`

	// An array of firewall rules.
	FirewallRules []*IPv4FirewallRule `json:"firewallRules,omitempty"`
}

// LogSpecifications - The log metric specification for exposing performance metrics to shoebox.
type LogSpecifications struct {
	// READ-ONLY; The blob duration for the log.
	BlobDuration *string `json:"blobDuration,omitempty" azure:"ro"`

	// READ-ONLY; The displayed name of log.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`

	// READ-ONLY; The name of metric.
	Name *string `json:"name,omitempty" azure:"ro"`
}

// MetricDimensions - Metric dimension.
type MetricDimensions struct {
	// READ-ONLY; Dimension display name.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`

	// READ-ONLY; Dimension name.
	Name *string `json:"name,omitempty" azure:"ro"`
}

// MetricSpecifications - Available operation metric specification for exposing performance metrics to shoebox.
type MetricSpecifications struct {
	// READ-ONLY; The aggregation type of metric.
	AggregationType *string `json:"aggregationType,omitempty" azure:"ro"`

	// READ-ONLY; The dimensions of metric.
	Dimensions []*MetricDimensions `json:"dimensions,omitempty" azure:"ro"`

	// READ-ONLY; The displayed description of metric.
	DisplayDescription *string `json:"displayDescription,omitempty" azure:"ro"`

	// READ-ONLY; The displayed name of metric.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`

	// READ-ONLY; The name of metric.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The unit of the metric.
	Unit *string `json:"unit,omitempty" azure:"ro"`
}

// Operation - A Consumption REST API operation.
type Operation struct {
	// The object that represents the operation.
	Display *OperationDisplay `json:"display,omitempty"`

	// Additional properties to expose performance metrics to shoebox.
	Properties *OperationProperties `json:"properties,omitempty"`

	// READ-ONLY; Operation name: {provider}/{resource}/{operation}.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The origin
	Origin *string `json:"origin,omitempty" azure:"ro"`
}

// OperationDisplay - The object that represents the operation.
type OperationDisplay struct {
	// READ-ONLY; Description of the operation object.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; Operation type: Read, write, delete, etc.
	Operation *string `json:"operation,omitempty" azure:"ro"`

	// READ-ONLY; Service provider: Microsoft.Consumption.
	Provider *string `json:"provider,omitempty" azure:"ro"`

	// READ-ONLY; Resource on which the operation is performed: UsageDetail, etc.
	Resource *string `json:"resource,omitempty" azure:"ro"`
}

// OperationListResult - Result of listing consumption operations. It contains a list of operations and a URL link to get
// the next set of results.
type OperationListResult struct {
	// READ-ONLY; URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; List of analysis services operations supported by the Microsoft.AnalysisServices resource provider.
	Value []*Operation `json:"value,omitempty" azure:"ro"`
}

// OperationProperties - Additional properties to expose performance metrics to shoebox.
type OperationProperties struct {
	// Performance metrics to shoebox.
	ServiceSpecification *OperationPropertiesServiceSpecification `json:"serviceSpecification,omitempty"`
}

// OperationPropertiesServiceSpecification - Performance metrics to shoebox.
type OperationPropertiesServiceSpecification struct {
	// READ-ONLY; The log specifications.
	LogSpecifications []*LogSpecifications `json:"logSpecifications,omitempty" azure:"ro"`

	// READ-ONLY; The metric specifications.
	MetricSpecifications []*MetricSpecifications `json:"metricSpecifications,omitempty" azure:"ro"`
}

// OperationStatus - The status of operation.
type OperationStatus struct {
	// The end time of the operation.
	EndTime *string `json:"endTime,omitempty"`

	// The error detail of the operation if any.
	Error *ErrorDetail `json:"error,omitempty"`

	// The operation Id.
	ID *string `json:"id,omitempty"`

	// The operation name.
	Name *string `json:"name,omitempty"`

	// The start time of the operation.
	StartTime *string `json:"startTime,omitempty"`

	// The status of the operation.
	Status *string `json:"status,omitempty"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// Resource - Represents an instance of an Analysis Services resource.
type Resource struct {
	// REQUIRED; Location of the Analysis Services resource.
	Location *string `json:"location,omitempty"`

	// REQUIRED; The SKU of the Analysis Services resource.
	SKU *ResourceSKU `json:"sku,omitempty"`

	// Key-value pairs of additional resource provisioning properties.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; An identifier that represents the Analysis Services resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the Analysis Services resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the Analysis Services resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ResourceSKU - Represents the SKU name and Azure pricing tier for Analysis Services resource.
type ResourceSKU struct {
	// REQUIRED; Name of the SKU level.
	Name *string `json:"name,omitempty"`

	// The number of instances in the read only query pool.
	Capacity *int32 `json:"capacity,omitempty"`

	// The name of the Azure pricing tier to which the SKU applies.
	Tier *SKUTier `json:"tier,omitempty"`
}

// SKUDetailsForExistingResource - An object that represents SKU details for existing resources.
type SKUDetailsForExistingResource struct {
	// The resource type.
	ResourceType *string `json:"resourceType,omitempty"`

	// The SKU in SKU details for existing resources.
	SKU *ResourceSKU `json:"sku,omitempty"`
}

// SKUEnumerationForExistingResourceResult - An object that represents enumerating SKUs for existing resources.
type SKUEnumerationForExistingResourceResult struct {
	// The collection of available SKUs for existing resources.
	Value []*SKUDetailsForExistingResource `json:"value,omitempty"`
}

// SKUEnumerationForNewResourceResult - An object that represents enumerating SKUs for new resources.
type SKUEnumerationForNewResourceResult struct {
	// The collection of available SKUs for new resources.
	Value []*ResourceSKU `json:"value,omitempty"`
}

// Server - Represents an instance of an Analysis Services resource.
type Server struct {
	// REQUIRED; Location of the Analysis Services resource.
	Location *string `json:"location,omitempty"`

	// REQUIRED; The SKU of the Analysis Services resource.
	SKU *ResourceSKU `json:"sku,omitempty"`

	// Properties of the provision operation request.
	Properties *ServerProperties `json:"properties,omitempty"`

	// Key-value pairs of additional resource provisioning properties.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; An identifier that represents the Analysis Services resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the Analysis Services resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the Analysis Services resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ServerAdministrators - An array of administrator user identities.
type ServerAdministrators struct {
	// An array of administrator user identities.
	Members []*string `json:"members,omitempty"`
}

// ServerMutableProperties - An object that represents a set of mutable Analysis Services resource properties.
type ServerMutableProperties struct {
	// A collection of AS server administrators
	AsAdministrators *ServerAdministrators `json:"asAdministrators,omitempty"`

	// The SAS container URI to the backup container.
	BackupBlobContainerURI *string `json:"backupBlobContainerUri,omitempty"`

	// The gateway details configured for the AS server.
	GatewayDetails *GatewayDetails `json:"gatewayDetails,omitempty"`

	// The firewall settings for the AS server.
	IPV4FirewallSettings *IPv4FirewallSettings `json:"ipV4FirewallSettings,omitempty"`

	// The managed mode of the server (0 = not managed, 1 = managed).
	ManagedMode *ManagedMode `json:"managedMode,omitempty"`

	// How the read-write server's participation in the query pool is controlled.
	// It can have the following values: * readOnly - indicates that the read-write server is intended not to participate in query
	// operations
	// * all - indicates that the read-write server can participate in query operations
	// Specifying readOnly when capacity is 1 results in error.
	QuerypoolConnectionMode *ConnectionMode `json:"querypoolConnectionMode,omitempty"`

	// The server monitor mode for AS server
	ServerMonitorMode *ServerMonitorMode `json:"serverMonitorMode,omitempty"`
}

// ServerProperties - Properties of Analysis Services resource.
type ServerProperties struct {
	// A collection of AS server administrators
	AsAdministrators *ServerAdministrators `json:"asAdministrators,omitempty"`

	// The SAS container URI to the backup container.
	BackupBlobContainerURI *string `json:"backupBlobContainerUri,omitempty"`

	// The gateway details configured for the AS server.
	GatewayDetails *GatewayDetails `json:"gatewayDetails,omitempty"`

	// The firewall settings for the AS server.
	IPV4FirewallSettings *IPv4FirewallSettings `json:"ipV4FirewallSettings,omitempty"`

	// The managed mode of the server (0 = not managed, 1 = managed).
	ManagedMode *ManagedMode `json:"managedMode,omitempty"`

	// How the read-write server's participation in the query pool is controlled.
	// It can have the following values: * readOnly - indicates that the read-write server is intended not to participate in query
	// operations
	// * all - indicates that the read-write server can participate in query operations
	// Specifying readOnly when capacity is 1 results in error.
	QuerypoolConnectionMode *ConnectionMode `json:"querypoolConnectionMode,omitempty"`

	// The SKU of the Analysis Services resource.
	SKU *ResourceSKU `json:"sku,omitempty"`

	// The server monitor mode for AS server
	ServerMonitorMode *ServerMonitorMode `json:"serverMonitorMode,omitempty"`

	// READ-ONLY; The current deployment state of Analysis Services resource. The provisioningState is to indicate states for
	// resource provisioning.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The full name of the Analysis Services resource.
	ServerFullName *string `json:"serverFullName,omitempty" azure:"ro"`

	// READ-ONLY; The current state of Analysis Services resource. The state is to indicate more states outside of resource provisioning.
	State *State `json:"state,omitempty" azure:"ro"`
}

// ServerUpdateParameters - Provision request specification
type ServerUpdateParameters struct {
	// Properties of the provision operation request.
	Properties *ServerMutableProperties `json:"properties,omitempty"`

	// The SKU of the Analysis Services resource.
	SKU *ResourceSKU `json:"sku,omitempty"`

	// Key-value pairs of additional provisioning properties.
	Tags map[string]*string `json:"tags,omitempty"`
}

// Servers - An array of Analysis Services resources.
type Servers struct {
	// REQUIRED; An array of Analysis Services resources.
	Value []*Server `json:"value,omitempty"`
}

// ServersClientBeginCreateOptions contains the optional parameters for the ServersClient.BeginCreate method.
type ServersClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServersClientBeginDeleteOptions contains the optional parameters for the ServersClient.BeginDelete method.
type ServersClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServersClientBeginResumeOptions contains the optional parameters for the ServersClient.BeginResume method.
type ServersClientBeginResumeOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServersClientBeginSuspendOptions contains the optional parameters for the ServersClient.BeginSuspend method.
type ServersClientBeginSuspendOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServersClientBeginUpdateOptions contains the optional parameters for the ServersClient.BeginUpdate method.
type ServersClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServersClientCheckNameAvailabilityOptions contains the optional parameters for the ServersClient.CheckNameAvailability
// method.
type ServersClientCheckNameAvailabilityOptions struct {
	// placeholder for future optional parameters
}

// ServersClientDissociateGatewayOptions contains the optional parameters for the ServersClient.DissociateGateway method.
type ServersClientDissociateGatewayOptions struct {
	// placeholder for future optional parameters
}

// ServersClientGetDetailsOptions contains the optional parameters for the ServersClient.GetDetails method.
type ServersClientGetDetailsOptions struct {
	// placeholder for future optional parameters
}

// ServersClientListByResourceGroupOptions contains the optional parameters for the ServersClient.ListByResourceGroup method.
type ServersClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// ServersClientListGatewayStatusOptions contains the optional parameters for the ServersClient.ListGatewayStatus method.
type ServersClientListGatewayStatusOptions struct {
	// placeholder for future optional parameters
}

// ServersClientListOperationResultsOptions contains the optional parameters for the ServersClient.ListOperationResults method.
type ServersClientListOperationResultsOptions struct {
	// placeholder for future optional parameters
}

// ServersClientListOperationStatusesOptions contains the optional parameters for the ServersClient.ListOperationStatuses
// method.
type ServersClientListOperationStatusesOptions struct {
	// placeholder for future optional parameters
}

// ServersClientListOptions contains the optional parameters for the ServersClient.List method.
type ServersClientListOptions struct {
	// placeholder for future optional parameters
}

// ServersClientListSKUsForExistingOptions contains the optional parameters for the ServersClient.ListSKUsForExisting method.
type ServersClientListSKUsForExistingOptions struct {
	// placeholder for future optional parameters
}

// ServersClientListSKUsForNewOptions contains the optional parameters for the ServersClient.ListSKUsForNew method.
type ServersClientListSKUsForNewOptions struct {
	// placeholder for future optional parameters
}
