// Code generated by smithy-go-codegen DO NOT EDIT.

package inspector

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/inspector/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpAddAttributesToFindings struct {
}

func (*validateOpAddAttributesToFindings) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpAddAttributesToFindings) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*AddAttributesToFindingsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpAddAttributesToFindingsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateAssessmentTarget struct {
}

func (*validateOpCreateAssessmentTarget) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateAssessmentTarget) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateAssessmentTargetInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateAssessmentTargetInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateAssessmentTemplate struct {
}

func (*validateOpCreateAssessmentTemplate) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateAssessmentTemplate) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateAssessmentTemplateInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateAssessmentTemplateInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateExclusionsPreview struct {
}

func (*validateOpCreateExclusionsPreview) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateExclusionsPreview) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateExclusionsPreviewInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateExclusionsPreviewInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateResourceGroup struct {
}

func (*validateOpCreateResourceGroup) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateResourceGroup) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateResourceGroupInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateResourceGroupInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteAssessmentRun struct {
}

func (*validateOpDeleteAssessmentRun) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteAssessmentRun) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteAssessmentRunInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteAssessmentRunInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteAssessmentTarget struct {
}

func (*validateOpDeleteAssessmentTarget) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteAssessmentTarget) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteAssessmentTargetInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteAssessmentTargetInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteAssessmentTemplate struct {
}

func (*validateOpDeleteAssessmentTemplate) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteAssessmentTemplate) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteAssessmentTemplateInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteAssessmentTemplateInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeAssessmentRuns struct {
}

func (*validateOpDescribeAssessmentRuns) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeAssessmentRuns) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeAssessmentRunsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeAssessmentRunsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeAssessmentTargets struct {
}

func (*validateOpDescribeAssessmentTargets) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeAssessmentTargets) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeAssessmentTargetsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeAssessmentTargetsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeAssessmentTemplates struct {
}

func (*validateOpDescribeAssessmentTemplates) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeAssessmentTemplates) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeAssessmentTemplatesInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeAssessmentTemplatesInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeExclusions struct {
}

func (*validateOpDescribeExclusions) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeExclusions) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeExclusionsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeExclusionsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeFindings struct {
}

func (*validateOpDescribeFindings) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeFindings) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeFindingsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeFindingsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeResourceGroups struct {
}

func (*validateOpDescribeResourceGroups) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeResourceGroups) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeResourceGroupsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeResourceGroupsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeRulesPackages struct {
}

func (*validateOpDescribeRulesPackages) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeRulesPackages) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeRulesPackagesInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeRulesPackagesInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetAssessmentReport struct {
}

func (*validateOpGetAssessmentReport) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetAssessmentReport) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetAssessmentReportInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetAssessmentReportInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetExclusionsPreview struct {
}

func (*validateOpGetExclusionsPreview) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetExclusionsPreview) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetExclusionsPreviewInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetExclusionsPreviewInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetTelemetryMetadata struct {
}

func (*validateOpGetTelemetryMetadata) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetTelemetryMetadata) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetTelemetryMetadataInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetTelemetryMetadataInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListAssessmentRunAgents struct {
}

func (*validateOpListAssessmentRunAgents) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListAssessmentRunAgents) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListAssessmentRunAgentsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListAssessmentRunAgentsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListExclusions struct {
}

func (*validateOpListExclusions) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListExclusions) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListExclusionsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListExclusionsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListFindings struct {
}

func (*validateOpListFindings) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListFindings) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListFindingsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListFindingsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListTagsForResource struct {
}

func (*validateOpListTagsForResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListTagsForResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListTagsForResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListTagsForResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPreviewAgents struct {
}

func (*validateOpPreviewAgents) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPreviewAgents) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PreviewAgentsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPreviewAgentsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpRegisterCrossAccountAccessRole struct {
}

func (*validateOpRegisterCrossAccountAccessRole) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpRegisterCrossAccountAccessRole) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*RegisterCrossAccountAccessRoleInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpRegisterCrossAccountAccessRoleInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpRemoveAttributesFromFindings struct {
}

func (*validateOpRemoveAttributesFromFindings) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpRemoveAttributesFromFindings) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*RemoveAttributesFromFindingsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpRemoveAttributesFromFindingsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpSetTagsForResource struct {
}

func (*validateOpSetTagsForResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpSetTagsForResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*SetTagsForResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpSetTagsForResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpStartAssessmentRun struct {
}

func (*validateOpStartAssessmentRun) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpStartAssessmentRun) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*StartAssessmentRunInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpStartAssessmentRunInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpStopAssessmentRun struct {
}

func (*validateOpStopAssessmentRun) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpStopAssessmentRun) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*StopAssessmentRunInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpStopAssessmentRunInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpSubscribeToEvent struct {
}

func (*validateOpSubscribeToEvent) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpSubscribeToEvent) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*SubscribeToEventInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpSubscribeToEventInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUnsubscribeFromEvent struct {
}

func (*validateOpUnsubscribeFromEvent) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUnsubscribeFromEvent) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UnsubscribeFromEventInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUnsubscribeFromEventInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateAssessmentTarget struct {
}

func (*validateOpUpdateAssessmentTarget) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateAssessmentTarget) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateAssessmentTargetInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateAssessmentTargetInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpAddAttributesToFindingsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpAddAttributesToFindings{}, middleware.After)
}

func addOpCreateAssessmentTargetValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateAssessmentTarget{}, middleware.After)
}

func addOpCreateAssessmentTemplateValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateAssessmentTemplate{}, middleware.After)
}

func addOpCreateExclusionsPreviewValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateExclusionsPreview{}, middleware.After)
}

func addOpCreateResourceGroupValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateResourceGroup{}, middleware.After)
}

func addOpDeleteAssessmentRunValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteAssessmentRun{}, middleware.After)
}

func addOpDeleteAssessmentTargetValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteAssessmentTarget{}, middleware.After)
}

func addOpDeleteAssessmentTemplateValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteAssessmentTemplate{}, middleware.After)
}

func addOpDescribeAssessmentRunsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeAssessmentRuns{}, middleware.After)
}

func addOpDescribeAssessmentTargetsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeAssessmentTargets{}, middleware.After)
}

func addOpDescribeAssessmentTemplatesValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeAssessmentTemplates{}, middleware.After)
}

func addOpDescribeExclusionsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeExclusions{}, middleware.After)
}

func addOpDescribeFindingsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeFindings{}, middleware.After)
}

func addOpDescribeResourceGroupsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeResourceGroups{}, middleware.After)
}

func addOpDescribeRulesPackagesValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeRulesPackages{}, middleware.After)
}

func addOpGetAssessmentReportValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetAssessmentReport{}, middleware.After)
}

func addOpGetExclusionsPreviewValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetExclusionsPreview{}, middleware.After)
}

func addOpGetTelemetryMetadataValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetTelemetryMetadata{}, middleware.After)
}

func addOpListAssessmentRunAgentsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListAssessmentRunAgents{}, middleware.After)
}

func addOpListExclusionsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListExclusions{}, middleware.After)
}

func addOpListFindingsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListFindings{}, middleware.After)
}

func addOpListTagsForResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListTagsForResource{}, middleware.After)
}

func addOpPreviewAgentsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPreviewAgents{}, middleware.After)
}

func addOpRegisterCrossAccountAccessRoleValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpRegisterCrossAccountAccessRole{}, middleware.After)
}

func addOpRemoveAttributesFromFindingsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpRemoveAttributesFromFindings{}, middleware.After)
}

func addOpSetTagsForResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpSetTagsForResource{}, middleware.After)
}

func addOpStartAssessmentRunValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpStartAssessmentRun{}, middleware.After)
}

func addOpStopAssessmentRunValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpStopAssessmentRun{}, middleware.After)
}

func addOpSubscribeToEventValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpSubscribeToEvent{}, middleware.After)
}

func addOpUnsubscribeFromEventValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUnsubscribeFromEvent{}, middleware.After)
}

func addOpUpdateAssessmentTargetValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateAssessmentTarget{}, middleware.After)
}

func validateAgentFilter(v *types.AgentFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AgentFilter"}
	if v.AgentHealths == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AgentHealths"))
	}
	if v.AgentHealthCodes == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AgentHealthCodes"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateAttribute(v *types.Attribute) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Attribute"}
	if v.Key == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Key"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateAttributeList(v []types.Attribute) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AttributeList"}
	for i := range v {
		if err := validateAttribute(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateFindingFilter(v *types.FindingFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "FindingFilter"}
	if v.Attributes != nil {
		if err := validateAttributeList(v.Attributes); err != nil {
			invalidParams.AddNested("Attributes", err.(smithy.InvalidParamsError))
		}
	}
	if v.UserAttributes != nil {
		if err := validateAttributeList(v.UserAttributes); err != nil {
			invalidParams.AddNested("UserAttributes", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateResourceGroupTag(v *types.ResourceGroupTag) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ResourceGroupTag"}
	if v.Key == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Key"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateResourceGroupTags(v []types.ResourceGroupTag) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ResourceGroupTags"}
	for i := range v {
		if err := validateResourceGroupTag(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTag(v *types.Tag) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Tag"}
	if v.Key == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Key"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTagList(v []types.Tag) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TagList"}
	for i := range v {
		if err := validateTag(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateUserAttributeList(v []types.Attribute) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UserAttributeList"}
	for i := range v {
		if err := validateAttribute(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpAddAttributesToFindingsInput(v *AddAttributesToFindingsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AddAttributesToFindingsInput"}
	if v.FindingArns == nil {
		invalidParams.Add(smithy.NewErrParamRequired("FindingArns"))
	}
	if v.Attributes == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Attributes"))
	} else if v.Attributes != nil {
		if err := validateUserAttributeList(v.Attributes); err != nil {
			invalidParams.AddNested("Attributes", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateAssessmentTargetInput(v *CreateAssessmentTargetInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateAssessmentTargetInput"}
	if v.AssessmentTargetName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AssessmentTargetName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateAssessmentTemplateInput(v *CreateAssessmentTemplateInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateAssessmentTemplateInput"}
	if v.AssessmentTargetArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AssessmentTargetArn"))
	}
	if v.AssessmentTemplateName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AssessmentTemplateName"))
	}
	if v.DurationInSeconds == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DurationInSeconds"))
	}
	if v.RulesPackageArns == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RulesPackageArns"))
	}
	if v.UserAttributesForFindings != nil {
		if err := validateUserAttributeList(v.UserAttributesForFindings); err != nil {
			invalidParams.AddNested("UserAttributesForFindings", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateExclusionsPreviewInput(v *CreateExclusionsPreviewInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateExclusionsPreviewInput"}
	if v.AssessmentTemplateArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AssessmentTemplateArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateResourceGroupInput(v *CreateResourceGroupInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateResourceGroupInput"}
	if v.ResourceGroupTags == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceGroupTags"))
	} else if v.ResourceGroupTags != nil {
		if err := validateResourceGroupTags(v.ResourceGroupTags); err != nil {
			invalidParams.AddNested("ResourceGroupTags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteAssessmentRunInput(v *DeleteAssessmentRunInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteAssessmentRunInput"}
	if v.AssessmentRunArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AssessmentRunArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteAssessmentTargetInput(v *DeleteAssessmentTargetInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteAssessmentTargetInput"}
	if v.AssessmentTargetArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AssessmentTargetArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteAssessmentTemplateInput(v *DeleteAssessmentTemplateInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteAssessmentTemplateInput"}
	if v.AssessmentTemplateArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AssessmentTemplateArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeAssessmentRunsInput(v *DescribeAssessmentRunsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeAssessmentRunsInput"}
	if v.AssessmentRunArns == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AssessmentRunArns"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeAssessmentTargetsInput(v *DescribeAssessmentTargetsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeAssessmentTargetsInput"}
	if v.AssessmentTargetArns == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AssessmentTargetArns"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeAssessmentTemplatesInput(v *DescribeAssessmentTemplatesInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeAssessmentTemplatesInput"}
	if v.AssessmentTemplateArns == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AssessmentTemplateArns"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeExclusionsInput(v *DescribeExclusionsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeExclusionsInput"}
	if v.ExclusionArns == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ExclusionArns"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeFindingsInput(v *DescribeFindingsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeFindingsInput"}
	if v.FindingArns == nil {
		invalidParams.Add(smithy.NewErrParamRequired("FindingArns"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeResourceGroupsInput(v *DescribeResourceGroupsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeResourceGroupsInput"}
	if v.ResourceGroupArns == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceGroupArns"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeRulesPackagesInput(v *DescribeRulesPackagesInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeRulesPackagesInput"}
	if v.RulesPackageArns == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RulesPackageArns"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetAssessmentReportInput(v *GetAssessmentReportInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetAssessmentReportInput"}
	if v.AssessmentRunArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AssessmentRunArn"))
	}
	if len(v.ReportFileFormat) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("ReportFileFormat"))
	}
	if len(v.ReportType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("ReportType"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetExclusionsPreviewInput(v *GetExclusionsPreviewInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetExclusionsPreviewInput"}
	if v.AssessmentTemplateArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AssessmentTemplateArn"))
	}
	if v.PreviewToken == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PreviewToken"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetTelemetryMetadataInput(v *GetTelemetryMetadataInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetTelemetryMetadataInput"}
	if v.AssessmentRunArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AssessmentRunArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListAssessmentRunAgentsInput(v *ListAssessmentRunAgentsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListAssessmentRunAgentsInput"}
	if v.AssessmentRunArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AssessmentRunArn"))
	}
	if v.Filter != nil {
		if err := validateAgentFilter(v.Filter); err != nil {
			invalidParams.AddNested("Filter", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListExclusionsInput(v *ListExclusionsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListExclusionsInput"}
	if v.AssessmentRunArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AssessmentRunArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListFindingsInput(v *ListFindingsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListFindingsInput"}
	if v.Filter != nil {
		if err := validateFindingFilter(v.Filter); err != nil {
			invalidParams.AddNested("Filter", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListTagsForResourceInput(v *ListTagsForResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListTagsForResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPreviewAgentsInput(v *PreviewAgentsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PreviewAgentsInput"}
	if v.PreviewAgentsArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PreviewAgentsArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpRegisterCrossAccountAccessRoleInput(v *RegisterCrossAccountAccessRoleInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RegisterCrossAccountAccessRoleInput"}
	if v.RoleArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RoleArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpRemoveAttributesFromFindingsInput(v *RemoveAttributesFromFindingsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RemoveAttributesFromFindingsInput"}
	if v.FindingArns == nil {
		invalidParams.Add(smithy.NewErrParamRequired("FindingArns"))
	}
	if v.AttributeKeys == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AttributeKeys"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpSetTagsForResourceInput(v *SetTagsForResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SetTagsForResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.Tags != nil {
		if err := validateTagList(v.Tags); err != nil {
			invalidParams.AddNested("Tags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpStartAssessmentRunInput(v *StartAssessmentRunInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StartAssessmentRunInput"}
	if v.AssessmentTemplateArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AssessmentTemplateArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpStopAssessmentRunInput(v *StopAssessmentRunInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StopAssessmentRunInput"}
	if v.AssessmentRunArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AssessmentRunArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpSubscribeToEventInput(v *SubscribeToEventInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SubscribeToEventInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if len(v.Event) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Event"))
	}
	if v.TopicArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TopicArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUnsubscribeFromEventInput(v *UnsubscribeFromEventInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UnsubscribeFromEventInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if len(v.Event) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Event"))
	}
	if v.TopicArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TopicArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateAssessmentTargetInput(v *UpdateAssessmentTargetInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateAssessmentTargetInput"}
	if v.AssessmentTargetArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AssessmentTargetArn"))
	}
	if v.AssessmentTargetName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AssessmentTargetName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
