#!/bin/bash

set -x
set -e # Exit on error

[ -x tools/release.sh ]
PACKAGE=$(basename "$PWD")
mkdir dist
TEMPDIR="$(mktemp -d)"
read VERSION < NEWS
echo "$PACKAGE-$VERSION: $TEMPDIR"
svn export "$(svn info|awk '/^URL/ { print $3 }')" "$TEMPDIR/$PACKAGE-$VERSION"
DIR="$PWD"
cd "$TEMPDIR"
rm "$PACKAGE-$VERSION/tools/release.sh"
touch "$PACKAGE-$VERSION"/{aclocal.m4,config.h.in,configure}
find "$PACKAGE-$VERSION" -type f -name "Makefile.*" -exec touch {} \;
(cd "$PACKAGE-$VERSION/src" && touch $(cat autogenerated))
tar czf "$DIR/dist/$PACKAGE-$VERSION.tar.gz" "$PACKAGE-$VERSION"
tar cjf "$DIR/dist/$PACKAGE-$VERSION.tar.bz2" "$PACKAGE-$VERSION"
sed 's#/usr/local#/usr#' < "$DIR/gliv.spec" > "$PACKAGE-$VERSION/gliv.spec"
mkdir -p SOURCES SPECS BUILD SRPMS RPMS/i386
ln "$DIR/dist/$PACKAGE-$VERSION.tar.bz2" SOURCES/
unset LINGUAS CFLAGS
rpmbuild -ba "$PACKAGE-$VERSION/gliv.spec"
mv "SRPMS/$PACKAGE-$VERSION-1.src.rpm" "$DIR/dist"
mv "RPMS/i386/$PACKAGE-"{,debuginfo-}"$VERSION-1.i386.rpm" "$DIR/dist"
rm -fr "$TEMPDIR"
