// Code generated by smithy-go-codegen DO NOT EDIT.

package pinpointsmsvoicev2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/pinpointsmsvoicev2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Use the verification code that was received by the verified destination phone
// number to opt-in the verified destination phone number to receive more messages.
func (c *Client) VerifyDestinationNumber(ctx context.Context, params *VerifyDestinationNumberInput, optFns ...func(*Options)) (*VerifyDestinationNumberOutput, error) {
	if params == nil {
		params = &VerifyDestinationNumberInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "VerifyDestinationNumber", params, optFns, c.addOperationVerifyDestinationNumberMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*VerifyDestinationNumberOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type VerifyDestinationNumberInput struct {

	// The verification code that was received by the verified destination phone
	// number.
	//
	// This member is required.
	VerificationCode *string

	// The unique identifier for the verififed destination phone number.
	//
	// This member is required.
	VerifiedDestinationNumberId *string

	noSmithyDocumentSerde
}

type VerifyDestinationNumberOutput struct {

	// The time when the destination phone number was created, in UNIX epoch time (https://www.epochconverter.com/)
	// format.
	//
	// This member is required.
	CreatedTimestamp *time.Time

	// The phone number in E.164 format.
	//
	// This member is required.
	DestinationPhoneNumber *string

	// The status for being able to send messages to the phone number.
	//
	// This member is required.
	Status types.VerificationStatus

	// The Amazon Resource Name (ARN) for the verified destination phone number.
	//
	// This member is required.
	VerifiedDestinationNumberArn *string

	// The unique identifier for the verified destination phone number.
	//
	// This member is required.
	VerifiedDestinationNumberId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationVerifyDestinationNumberMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpVerifyDestinationNumber{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpVerifyDestinationNumber{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "VerifyDestinationNumber"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpVerifyDestinationNumberValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opVerifyDestinationNumber(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opVerifyDestinationNumber(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "VerifyDestinationNumber",
	}
}
