# Open-Source iOS Apps

<!-- 
⚠️ This README is generated, please do not update. To contribute, make changes to contents.json ⚠️ 
 https://github.com/dkhamsing/open-source-ios-apps -->

A collaborative list of open-source `iOS`, `watchOS` and `tvOS` apps, your [contribution](https://github.com/dkhamsing/open-source-ios-apps/blob/master/.github/CONTRIBUTING.md) is welcome :smile:

![](https://img.shields.io/badge/Projects-776-green.svg) [![](https://img.shields.io/badge/Twitter-@opensourceios-blue.svg)](https://twitter.com/opensourceios) ![](https://img.shields.io/badge/Updated-February%20%206,%202018-lightgrey.svg)

Jump to

- [Apple TV](#apple-tv) 
- [Apple Watch](#apple-watch) 
- [Browser](#browser) 
- [Calculator](#calculator) 
- [Calendar](#calendar) 
- [Color](#color) 
- [Clock](#clock) 
- [Clone](#clone) 
- [Communication](#communication) 
- [Developer](#developer) 
  - [GitHub](#github) 
- [Education](#education) 
- [Emulator](#emulator) 
- [Event](#event) 
- [Extension](#extension) 
  - [Content Blocking](#content-blocking) 
  - [Today](#today) 
- [Finance](#finance) 
  - [Bitcoin](#bitcoin) 
- [Game](#game) 
  - [Cocos2d](#cocos2d) 
  - [SpriteKit](#spritekit) 
- [Health](#health) 
  - [Fitness](#fitness) 
  - [ResearchKit](#researchkit) 
- [Keyboard](#keyboard) 
- [Location](#location) 
- [Media](#media) 
  - [Animoji](#animoji) 
  - [Audio](#audio) 
  - [Content](#content) 
  - [GIF](#gif) 
  - [Photo](#photo) 
  - [Video](#video) 
- [News](#news) 
  - [Hacker News](#hacker-news) 
  - [News API](#news-api) 
  - [RSS](#rss) 
- [Official](#official) 
- [Reactive Programming](#reactive-programming) 
  - [ReactiveCocoa](#reactivecocoa) 
  - [RxSwift](#rxswift) 
- [Sample](#sample) 
- [Scan](#scan) 
- [Security](#security) 
  - [Password](#password) 
- [Social](#social) 
  - [Mastodon](#mastodon) 
- [Tasks](#tasks) 
- [Text](#text) 
  - [Notes](#notes) 
- [Timer](#timer) 
- [Travel](#travel) 
- [Weather](#weather) 
- [Misc](#misc) 
  - [3D Touch](#3d-touch) 
  - [Appcelerator](#appcelerator) 
  - [Core Data](#core-data) 
  - [Firebase](#firebase) 
  - [Ionic](#ionic) 
  - [Parse](#parse) 
  - [React Native](#react-native) 
  - [Realm](#realm) 
  - [VIPER](#viper) 
  - [Xamarin](#xamarin) 
- [Bonus](#bonus) 
- [Thanks](#thanks)
- [Contact](#contact)

```
 100+ Stars: 🔥
 200+ Stars: 🔥🔥
 500+ Stars: 🔥🔥🔥
1000+ Stars: 🔥🔥🔥🔥
2000+ Stars: 🔥🔥🔥🔥🔥

Projects are in English unless indicated by flags 
🇨🇳 Project is in Chinese
🇪🇸 Project is in Spanish
... 

Click ► to show more details
```

## Apple TV 
 
[back to top](#readme) 
 
- Artsy Shows: Art shows [` App Store`](https://itunes.apple.com/by/app/artsy-shows/id1044690553)  
  <details><summary><code>swift</code> <code>cocoapodskeys</code> 🔥🔥</summary>

  https://github.com/artsy/Emergence<br>  Added November  6, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Artsy Shows image 1' src='https://raw.githubusercontent.com/artsy/emergence/master/docs/screenshots/featured.png'> <img height='300' alt='Artsy Shows image 2' src='https://raw.githubusercontent.com/artsy/emergence/master/docs/screenshots/show.png'> 
</div>
  </details>

- EX Player: Watch videos from EX.UA file sharing  
  <details><summary><code>objc</code> </summary>

  https://github.com/IGRSoft/exTVPlayer<br>  Added February  9, 2016<br>  License: [`lgpl-2.1`](http://choosealicense.com/licenses/lgpl-2.1/)
  <div><img height='300' alt='EX Player image 1' src='https://raw.githubusercontent.com/IGRSoft/exTVPlayer/master/Screenshots/4.png'> 
</div>
  </details>

- GrandCentralBoard: Hang a TV in your open space / team room to show everyone what's up & get them up to speed  
  <details><summary><code>swift</code> <code>alamofire</code> <code>rxswift</code> 🔥🔥</summary>

  https://github.com/macoscope/GrandCentralBoard<br>  Added April 29, 2016<br>  License: [`gpl-3.0`](http://choosealicense.com/licenses/gpl-3.0/)
  <div><img height='300' alt='GrandCentralBoard image 1' src='http://cdn.macoscope.com/blog/wp-content/uploads/2016/03/zegar_anim_1.gif'> 
</div>
  </details>

- hexclock: Minimal hexadecimal clock [` App Store`](https://itunes.apple.com/app/hex-color-clock/id1207660670)  
  <details><summary><code>swift</code> </summary>

  https://github.com/cfdrake/hexclock<br>  Added June 14, 2017<br>  License: `other`
  <div><img height='300' alt='hexclock image 1' src='http://a1.mzstatic.com/us/r30/Purple122/v4/7b/e9/dd/7be9dd53-fe6b-00f7-57e6-a19e27b103de/sc720x405.jpeg'> 
</div>
  </details>

- iCook TV: Taiwanese cuisine cooking videos  
  <details><summary><code>swift</code> 🇨🇳 </summary>

  https://github.com/polydice/iCook-tvOS<br>  Added May 25, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='iCook TV image 1' src='http://polydice.com/iCook-tvOS/images/Screenshot.png'> 
</div>
  </details>

- Provenance: Emulators frontend for Sega Genesis, SNES, NES, GB/GBC & more  
  <details><summary><code>realm</code> 🔥🔥🔥🔥🔥</summary>

  https://github.com/jasarien/Provenance<br>  Added April 27, 2015<br>  License: [`bsd-3-clause`](http://choosealicense.com/licenses/bsd-3-clause/)
  <div><img height='300' alt='Provenance image 1' src='http://jamesaddyman.com/provenance/screenshots/provenance1.png'> <img height='300' alt='Provenance image 2' src='http://jamesaddyman.com/provenance/screenshots/provenance6.png'> 
</div>
  </details>

- RailsCasts: Ruby on Rails screencasts from http://railscasts.com/  
  <details><summary><code>objc</code> </summary>

  https://github.com/spritlesoftware/railscasts-on-appletv<br>  Added May 12, 2016<br>  License: `other`
  <div><img height='300' alt='RailsCasts image 1' src='https://raw.githubusercontent.com/spritlesoftware/railscasts-on-appletv/master/TVOSExample/image/apple-tv-railscast.png'> 
</div>
  </details>

- Retro Skate  
  <details><summary><code>swift</code> </summary>

  https://github.com/intere/retro-skate-tvOS<br>  Added April 13, 2017<br>  License: `other`
  <div><img height='300' alt='Retro Skate image 1' src='https://github.com/intere/retro-skate-tvOS/raw/master/assets/screenshot2.png'> 
</div>
  </details>

- Telemat-tvOS: Stream the German Public Broadcast TV  
  <details><summary><code>objc</code> 🇩🇪 </summary>

  https://github.com/omichde/Telemat-tvOS<br>  Added May 31, 2016<br>  License: [`gpl-2.0`](http://choosealicense.com/licenses/gpl-2.0/)
  <div><img height='300' alt='Telemat-tvOS image 1' src='https://github.com/omichde/Telemat-tvOS/raw/master/telemat.jpg'> 
</div>
  </details>

- UitzendingGemist by 4np: Uitgebreide UitzendingGemist app voor Nederland  
  <details><summary><code>swift</code> 🇳🇱 </summary>

  https://github.com/4np/UitzendingGemist<br>  Added November 10, 2015<br>  License: [`apache-2.0`](http://choosealicense.com/licenses/apache-2.0/)
  <div><img height='300' alt='UitzendingGemist by 4np image 1' src='https://cloud.githubusercontent.com/assets/1049693/18724167/ba26d9ba-803b-11e6-9c76-2f44c47d2dee.png'> 
</div>
  </details>

- UitzendingGemist by jeffkreeftmeijer: Dutch Public Broadcasting video on demand  
  <details><summary><code>swift</code> 🇳🇱 </summary>

  https://github.com/jeffkreeftmeijer/UitzendingGemist<br>  Added November 10, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='UitzendingGemist by jeffkreeftmeijer image 1' src='https://raw.githubusercontent.com/jeffkreeftmeijer/UitzendingGemist/master/Screenshots/recent.png'> 
</div>
  </details>

- Upcoming Movies  
  <details><summary><code>swift</code> <code>themoviedb api</code> </summary>

  https://github.com/vanyaland/UpcomingMovies<br>  Added July 16, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Upcoming Movies image 1' src='https://github.com/vanyaland/UpcomingMovies/raw/master/Screenshots/movies.png'> 
</div>
  </details>

- WWDCTV: Watch WWDC Videos  
  <details><summary><code>objc</code> 🔥🔥</summary>

  https://github.com/azzoor/WWDCTV<br>  Added November 19, 2015<br>  License: `other`
  <div><img height='300' alt='WWDCTV image 1' src='https://github.com/azzoor/WWDCTV/blob/master/WWDC/screen01.png?raw=true'> 
</div>
  </details>


## Apple Watch 
 
[back to top](#readme) 
 
- 420! Alarm [` App Store`](https://itunes.apple.com/app/420/id1194325430)  
  <details><summary><code>swift</code> </summary>

  https://github.com/efremidze/Alarm<br>  Added April 11, 2017<br>  License: [`apache-2.0`](http://choosealicense.com/licenses/apache-2.0/)
  <div><img height='300' alt='420! Alarm image 1' src='https://raw.githubusercontent.com/efremidze/Alarm/master/screenshots/en-US/iPhone7-0-d41d8cd98f00b204e9800998ecf8427e.png'> 
</div>
  </details>

- BaiduFM: A Baidu Music app  
  <details><summary><code>swift</code> 🇨🇳 🔥🔥🔥</summary>

  https://github.com/belm/BaiduFM-Swift<br>  Added August  6, 2015<br>  License: `other`
  <div><img height='300' alt='BaiduFM image 1' src='https://github.com/belm/BaiduFM-Swift/raw/master/ScreenShot/BaiduFM-Swift_AppleWatch_00.png?raw=true'> 
</div>
  </details>

- Bither: Simple & secure Bitcoin wallet  
  <details><summary><code>objc</code> 🔥</summary>

  https://github.com/bither/bither-ios<br>  Added April  3, 2015<br>  License: [`apache-2.0`](http://choosealicense.com/licenses/apache-2.0/)
  <div><img height='300' alt='Bither image 1' src='http://a1.mzstatic.com/us/r30/Purple7/v4/f9/f8/d4/f9f8d401-2a9a-fb50-fe24-76a1158600b2/screen696x696.jpeg'> 
</div>
  </details>

- Bus Today: Track bus line on your wrist, includes Today Extension [` App Store`](https://itunes.apple.com/app/jin-ri-gong-jiao-tong-zhi/id975022341)  
  <details><summary><code>objc</code> 🇨🇳 </summary>

  https://github.com/JohnWong/bus-today<br>  Added February 17, 2016<br>  License: `other`
  <div><img height='300' alt='Bus Today image 1' src='http://a4.mzstatic.com/us/r30/Purple69/v4/94/5e/05/945e0506-9e18-749a-1ed9-e018949bfbad/screen696x696.jpeg'> <img height='300' alt='Bus Today image 2' src='http://a1.mzstatic.com/us/r30/Purple69/v4/8f/6c/74/8f6c7422-fdc8-89e4-3514-0ea044e7fd50/screen696x696.jpeg'> <img height='300' alt='Bus Today image 3' src='http://a4.mzstatic.com/us/r30/Purple69/v4/39/03/e1/3903e1cf-d614-5d26-e3b1-3f9180aa162e/screen696x696.jpeg'> <img height='300' alt='Bus Today image 4' src='http://a5.mzstatic.com/us/r30/Purple69/v4/7b/9a/d2/7b9ad2f6-0438-c850-f8e0-268b712873a0/screen696x696.jpeg'> <img height='300' alt='Bus Today image 5' src='http://a2.mzstatic.com/us/r30/Purple69/v4/ce/6f/fc/ce6ffc7a-7f95-0c08-f05b-77f15612d0c7/screen696x696.jpeg'> 
</div>
  </details>

- Calculator by BalestraPatrick  
  <details><summary><code>objc</code> 🔥</summary>

  https://github.com/BalestraPatrick/AppleWatchCalculator<br>  Added March 24, 2017<br>  License: `other`
  <div><img height='300' alt='Calculator by BalestraPatrick image 1' src='https://github.com/BalestraPatrick/AppleWatchCalculator/blob/master/Screenshot1.png?raw=true'> 
</div>
  </details>

- Calculator by mukeshthawani  
  <details><summary><code>swift</code> </summary>

  https://github.com/mukeshthawani/Calculator<br>  Added December 18, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Calculator by mukeshthawani image 1' src='https://raw.githubusercontent.com/mukeshthawani/Calculator/master/graphics/scr1.png'> 
</div>
  </details>

- Cortado: Track your caffeine consumption habits [` App Store`](https://itunes.apple.com/app/cortado/id969899327)  
  <details><summary><code>objc</code> 🔥</summary>

  https://github.com/lazerwalker/cortado<br>  Added June 25, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Cortado image 1' src='http://a3.mzstatic.com/us/r30/Purple7/v4/a8/8e/ef/a88eef8f-dedc-6877-cd28-ae88f461129f/screen696x696.jpeg'> <img height='300' alt='Cortado image 2' src='http://a2.mzstatic.com/us/r30/Purple5/v4/e7/0c/f3/e70cf340-a630-2d04-b6a3-84cc127e3eee/screen696x696.jpeg'> <img height='300' alt='Cortado image 3' src='http://a4.mzstatic.com/us/r30/Purple7/v4/16/df/d1/16dfd184-5bea-1fef-d15a-227cd8e4503d/screen696x696.jpeg'> <img height='300' alt='Cortado image 4' src='http://a5.mzstatic.com/us/r30/Purple7/v4/e4/b7/ae/e4b7ae1c-9d36-dfa9-b27f-679676b4366f/screen696x696.jpeg'> <img height='300' alt='Cortado image 5' src='http://a2.mzstatic.com/us/r30/Purple7/v4/e1/77/52/e17752e3-03e8-f340-abb9-ed6c9bd04a65/screen696x696.jpeg'> 
</div>
  </details>

- Count It: Dead simple way to you count anything  
  <details><summary><code>swift</code> </summary>

  https://github.com/PiXeL16/CountItApp<br>  Added July 11, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Count It image 1' src='http://a4.mzstatic.com/us/r30/Purple49/v4/d9/07/8b/d9078bba-fcf6-8de1-c674-d69b895f17c6/screen696x696.jpeg'> <img height='300' alt='Count It image 2' src='http://a3.mzstatic.com/us/r30/Purple49/v4/85/9b/94/859b94ea-b37e-6f77-fe7b-afc9f76934e7/screen696x696.jpeg'> <img height='300' alt='Count It image 3' src='http://a5.mzstatic.com/us/r30/Purple49/v4/19/de/08/19de08b9-4688-556e-c544-bfcc2d8154fb/screen696x696.jpeg'> <img height='300' alt='Count It image 4' src='http://a1.mzstatic.com/us/r30/Purple49/v4/83/71/1c/83711c7a-0119-cc7f-5f86-9e1da4d210c6/screen696x696.jpeg'> 
</div>
  </details>

- Done: To-do list data sharing between extension & main app  
  <details><summary><code>swift</code> <code>realm</code> <code>watchkit</code> 🔥</summary>

  https://github.com/FancyPixel/done-swift<br>  Added May  1, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Done image 1' src='https://raw.githubusercontent.com/FancyPixel/done-swift/master/assets/screenshot.gif'> 
</div>
  </details>

- Giovanni: Gameboy emulator for the Apple Watch  
  <details><summary><code>swift</code> 🔥🔥🔥</summary>

  https://github.com/gabrieloc/GIOVANNI<br>  Added March 20, 2017<br>  License: `other`
  <div><img height='300' alt='Giovanni image 1' src='https://github.com/gabrieloc/GIOVANNI/blob/master/gameplay.gif?raw=true'> 
</div>
  </details>

- GitHub Contributions: Track your GitHub contributions  
  <details><summary><code>swift</code> </summary>

  https://github.com/remirobert/Github-contributions<br>  Added April 20, 2017<br>  License: [`gpl-3.0`](http://choosealicense.com/licenses/gpl-3.0/)
  <div><img height='300' alt='GitHub Contributions image 1' src='https://cloud.githubusercontent.com/assets/3276768/19214602/f39af4c0-8d87-11e6-8b3d-3d9c7b94d57c.png'> 
</div>
  </details>

- Gulps: Track your daily water consumption [` App Store`](https://itunes.apple.com/app/gulps/id979057304)  
  <details><summary><code>swift</code> 🔥🔥🔥</summary>

  https://github.com/FancyPixel/gulps<br>  Added April 22, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Gulps image 1' src='https://cdn-images-1.medium.com/max/800/1*5sA3rvpUw5bdecwbDx7cYA.png'> 
</div>
  </details>

- HeartControl: Continuous heart rate measurement during workouts  
  <details><summary><code>swift</code> <code>watchos3</code> 🔥</summary>

  https://github.com/thomaspaulmann/HeartControl<br>  Added August 16, 2016<br>  License: `other`
  <div><img height='300' alt='HeartControl image 1' src='https://i.imgur.com/AggsuxA.png'> <img height='300' alt='HeartControl image 2' src='https://i.imgur.com/r8El1FE.png'> <img height='300' alt='HeartControl image 3' src='https://i.imgur.com/zCkknWc.png'> 
</div>
  </details>

- heartrate: Show streaming heart rate from the watch  
  <details><summary><code>swift</code> <code>watchos2</code> 🔥🔥</summary>

  https://github.com/coolioxlr/watchOS-2-heartrate<br>  https://imgur.com/a/xVqqj<br>  Added July 29, 2015<br>  License: `other`
  <div><img height='300' alt='heartrate image 1' src='https://i.imgur.com/hOfxCBx.png'> 
</div>
  </details>

- HN Reader: Hacker News Reader [` App Store`](https://itunes.apple.com/app/hn-reader-hacker-news-reader/id919243741)  
  <details><summary><code>swift</code> 🔥🔥🔥🔥</summary>

  https://github.com/Dimillian/SwiftHN<br>  Added January 26, 2015<br>  License: [`gpl-2.0`](http://choosealicense.com/licenses/gpl-2.0/)
  <div><img height='300' alt='HN Reader image 1' src='https://cdn-images-1.medium.com/max/800/1*6Bey3OUZ2Xhuk-ZXCB-gOg.png'> 
</div>
  </details>

- KTPomodoro: Mini Pomodoro Timer  
  <details><summary><code>objc</code> </summary>

  https://github.com/kenshin03/KTPomodoro<br>  Added February 26, 2015<br>  License: `other`
  <div><img height='300' alt='KTPomodoro image 1' src='https://raw.githubusercontent.com/kenshin03/Cherry/master/screenshot_1.png'> 
</div>
  </details>

- MyWeight History: Body mass tracker with easy data input & access to history [` App Store`](https://itunes.apple.com/app/myweight-history/id1098061879)  
  <details><summary><code>swift</code> </summary>

  https://github.com/diogot/MyWeight<br>  Added June 12, 2017<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='MyWeight History image 1' src='http://a1.mzstatic.com/us/r30/Purple122/v4/2d/28/8c/2d288c05-33f0-1f18-b06a-4e3a24e1d608/screen696x696.jpeg'> 
</div>
  </details>

- Natural Language Clock: Display the time as you would speak it  
  <details><summary><code>swift</code> <code>watchos2</code> </summary>

  https://github.com/chadkeck/Natural-Language-Clock<br>  Added April 20, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Natural Language Clock image 1' src='https://github.com/chadkeck/Natural-Language-Clock/raw/master/assets/iPhone-and-Apple-Watch.png?raw=true'> 
</div>
  </details>

- Parties for WWDC  
  <details><summary><code>cloudkit</code> 🔥🔥</summary>

  https://github.com/genadyo/WWDC<br>  Added January 26, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Parties for WWDC image 1' src='http://a3.mzstatic.com/us/r30/Purple20/v4/5f/9e/6a/5f9e6a9a-db21-1e8a-c45a-aef6ba65956b/screen696x696.jpeg'> <img height='300' alt='Parties for WWDC image 2' src='http://a3.mzstatic.com/us/r30/Purple30/v4/7e/6f/12/7e6f12a7-8d4b-0416-4d7a-f4745a2d7538/screen696x696.jpeg'> <img height='300' alt='Parties for WWDC image 3' src='http://a3.mzstatic.com/us/r30/Purple60/v4/4c/0f/cf/4c0fcf21-8713-0d61-c0df-0dafdbe525e8/screen696x696.jpeg'> <img height='300' alt='Parties for WWDC image 4' src='http://a5.mzstatic.com/us/r30/Purple30/v4/c0/21/e4/c021e48b-fa87-a873-1c8b-95e58aba71e7/screen696x696.jpeg'> <img height='300' alt='Parties for WWDC image 5' src='http://a3.mzstatic.com/us/r30/Purple18/v4/e0/69/9c/e0699c09-6cb4-c1a5-4fa1-9cd7117eaa86/screen696x696.jpeg'> 
</div>
  </details>

- PhotoWatch: Uses the SwiftyDropbox SDK  
  <details><summary><code>swift</code> </summary>

  https://github.com/dropbox/PhotoWatch<br>  Added February 25, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='PhotoWatch image 1' src='https://github.com/dropbox/PhotoWatch/raw/master/Screenshots/watch.png'> 
</div>
  </details>

- try! Swift  
  <details><summary><code>swift</code> 🔥🔥</summary>

  https://github.com/tryswift/trySwiftApp<br>  Added February 16, 2016<br>  License: `other`
  <div><img height='300' alt='try! Swift image 1' src='http://a2.mzstatic.com/us/r30/Purple49/v4/18/81/9f/18819f2d-1bb8-feeb-bb22-89bbe85d6516/screen696x696.jpeg'> 
</div>
  </details>

- try! Swift NYC  
  <details><summary><code>swift</code> <code>toucan</code> <code>realm</code> 🔥</summary>

  https://github.com/tryswift/trySwiftNYC<br>  Added November  8, 2016<br>  License: `other`
  <div><img height='300' alt='try! Swift NYC image 1' src='https://i.imgur.com/xyu7t89.png'> <img height='300' alt='try! Swift NYC image 2' src='https://i.imgur.com/Jes7vLF.png'> 
</div>
  </details>

- WatchKit-Apps: Tutorials app  
  <details><summary><code>swift</code> 🔥🔥🔥🔥</summary>

  https://github.com/kostiakoval/WatchKit-Apps<br>  Added March 23, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='WatchKit-Apps image 1' src='https://raw.githubusercontent.com/kostiakoval/WatchKit-Apps/master/images/AppsInWatck/Counter.gif'> 
</div>
  </details>

- WatchNote: Control your Keynote using Apple Watch  
  <details><summary><code>swift</code> 🔥</summary>

  https://github.com/ezefranca/WatchNote<br>  Added March 28, 2017<br>  License: [`apache-2.0`](http://choosealicense.com/licenses/apache-2.0/)
  <div><img height='300' alt='WatchNote image 1' src='https://github.com/ezefranca/WatchNote/blob/master/print.png?raw=true'> 
</div>
  </details>

- watchOS-2-Sampler: watchOS 2 new features example code  
  <details><summary><code>swift</code> <code>watchos2</code> 🔥🔥🔥🔥</summary>

  https://github.com/shu223/watchOS-2-Sampler<br>  Added June 23, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='watchOS-2-Sampler image 1' src='https://github.com/shu223/watchOS-2-Sampler/raw/master/ResourcesForREADME/animation.gif'> 
</div>
  </details>

- WatchPics: Instagram app  
  <details><summary><code>objc</code> </summary>

  https://github.com/D-32/WatchPics<br>  Added April 10, 2015<br>  License: [`apache-2.0`](http://choosealicense.com/licenses/apache-2.0/)
  <div><img height='300' alt='WatchPics image 1' src='https://i.imgur.com/pEIRuzr.jpg'> 
</div>
  </details>


## Browser 
 
[back to top](#readme) 
 
- Brave: Firefox-based browser with ad block & tracking pixel/cookie block built in [` App Store`](https://itunes.apple.com/app/brave-web-browser/id1052879175)  
  <details><summary><code>swift</code> 🔥🔥🔥</summary>

  https://github.com/brave/browser-ios<br>  Added May 24, 2016<br>  License: [`mpl-2.0`](http://choosealicense.com/licenses/mpl-2.0/)
  <div><img height='300' alt='Brave image 1' src='http://a5.mzstatic.com/us/r30/Purple18/v4/ed/6c/07/ed6c07f4-c9cd-0daa-a331-a39a85ba1c08/screen696x696.jpeg'> 
</div>
  </details>

- Chrome  
  <details><summary><code>objective-c++</code> </summary>

  https://chromium.googlesource.com/chromium/src.git/+/master/ios/<br>  https://blog.chromium.org/2017/01/open-sourcing-chrome-on-ios.html<br>  Added February  1, 2017<br>  License: [`bsd-2-clause`](http://choosealicense.com/licenses/bsd-2-clause/)
  <div><img height='300' alt='Chrome image 1' src='http://a5.mzstatic.com/us/r30/Purple71/v4/4b/d8/9a/4bd89a0d-d1f8-ea48-492a-2cec600c453c/screen696x696.jpeg'> <img height='300' alt='Chrome image 2' src='http://a3.mzstatic.com/us/r30/Purple62/v4/20/f2/6e/20f26eb0-e862-358f-8252-0e299bc89d94/screen696x696.jpeg'> <img height='300' alt='Chrome image 3' src='http://a3.mzstatic.com/us/r30/Purple71/v4/53/5b/b4/535bb49d-d1ec-7edc-4195-ba0359de2779/screen696x696.jpeg'> <img height='300' alt='Chrome image 4' src='http://a5.mzstatic.com/us/r30/Purple62/v4/56/ee/b0/56eeb0f0-0e39-cb27-d389-511e2d9964c4/screen696x696.jpeg'> <img height='300' alt='Chrome image 5' src='http://a5.mzstatic.com/us/r30/Purple62/v4/e8/a1/ab/e8a1ab12-b616-f9d0-7f1b-2e1764b0e872/screen696x696.jpeg'> 
</div>
  </details>

- Endless Browser: Web browser built with privacy & security in mind [` App Store`](https://itunes.apple.com/app/endless-browser/id974745755)  
  <details><summary><code>objc</code> 🔥</summary>

  https://github.com/jcs/endless<br>  Added December 22, 2015<br>  License: `other`
  <div><img height='300' alt='Endless Browser image 1' src='http://a3.mzstatic.com/us/r30/Purple7/v4/4a/22/70/4a22706f-6fe0-0e71-ad4c-178a83a062ad/screen696x696.jpeg'> <img height='300' alt='Endless Browser image 2' src='http://a4.mzstatic.com/us/r30/Purple7/v4/cb/d1/06/cbd1063b-c086-9e3b-caff-34e938b6433c/screen696x696.jpeg'> <img height='300' alt='Endless Browser image 3' src='http://a3.mzstatic.com/us/r30/Purple5/v4/e3/b4/ae/e3b4ae59-3f2e-2784-93aa-fae83a3aa6f1/screen696x696.jpeg'> 
</div>
  </details>

- Firefox: Official Firefox app [` App Store`](https://itunes.apple.com/app/firefox-web-browser/id989804926)  
  <details><summary><code>swift</code> <code>carthage</code> <code>alamofire</code> <code>snapkit</code> <code>libphonenumber</code> 🔥🔥🔥🔥🔥</summary>

  https://github.com/mozilla-mobile/firefox-ios<br>  Added January 26, 2015<br>  License: [`mpl-2.0`](http://choosealicense.com/licenses/mpl-2.0/)
  <div><img height='300' alt='Firefox image 1' src='http://a4.mzstatic.com/us/r30/Purple49/v4/53/81/08/53810869-af7c-31ff-c2bd-43b2a7ec5f56/screen322x572.jpeg'> 
</div>
  </details>

- Firefox Focus: Browse the web privately [` App Store`](https://itunes.apple.com/app/id1055677337)  
  <details><summary><code>swift</code> 🔥🔥🔥</summary>

  https://github.com/mozilla-mobile/focus-ios<br>  Added December  8, 2015<br>  License: [`mpl-2.0`](http://choosealicense.com/licenses/mpl-2.0/)
  <div><img height='300' alt='Firefox Focus image 1' src='http://a2.mzstatic.com/us/r30/Purple71/v4/32/81/20/328120a1-29c2-4dd8-fec8-8024eb5bb5ee/screen696x696.jpeg'> 
</div>
  </details>

- Frameless: A full-screen web browser  
  <details><summary><code>swift</code> 🔥🔥🔥</summary>

  https://github.com/stakes/Frameless<br>  Added July 31, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div>
</div>
  </details>

- Onion Browser: A Tor-powered web browser that improves your privacy [` App Store`](https://itunes.apple.com/app/id519296448)  
  <details><summary><code>tor</code> 🔥🔥🔥</summary>

  https://github.com/mtigas/OnionBrowser<br>  https://mike.tig.as/onionbrowser/<br>  Added June  2, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Onion Browser image 1' src='http://a4.mzstatic.com/us/r30/Purple42/v4/7c/3c/cc/7c3ccc4e-77c8-799a-9058-4b8672c71a08/screen696x696.jpeg'> 
</div>
  </details>

- Radium Web Browser: Tabbed web browser extendible using JavaScript extensions [` App Store`](https://itunes.apple.com/app/radium-web-browser/id1274491203)  
  <details><summary><code>swift</code> <code>browser</code> <code>extensible</code> <code>webkit</code> </summary>

  https://github.com/SlayterDev/RadiumBrowser<br>  Added September 27, 2017<br>  License: `other`
  <div><img height='300' alt='Radium Web Browser image 1' src='https://camo.githubusercontent.com/1b9c730305d6004b9abba19bf743527794f2c664/687474703a2f2f692e696d6775722e636f6d2f624d51757741452e706e67'> <img height='300' alt='Radium Web Browser image 2' src='https://camo.githubusercontent.com/41dd4dcd8b7fdbf5a8dcef923fcd4716bbd0c2e6/687474703a2f2f692e696d6775722e636f6d2f576a726f3336412e706e67'> 
</div>
  </details>

- Tob: A beautiful Tor browser to protect your anonymity [` App Store`](https://itunes.apple.com/app/id1063151782)  
  <details><summary><code>tor</code> </summary>

  https://github.com/JRock007/Tob<br>  Added July 11, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Tob image 1' src='http://a3.mzstatic.com/us/r30/Purple20/v4/cb/fa/27/cbfa272c-7787-ed8a-3fc4-dc6926f3932e/screen696x696.jpeg'> <img height='300' alt='Tob image 2' src='http://a5.mzstatic.com/us/r30/Purple60/v4/36/1c/99/361c9989-1abe-90e1-c1b6-b6cfebaeda56/screen696x696.jpeg'> <img height='300' alt='Tob image 3' src='http://a3.mzstatic.com/us/r30/Purple30/v4/9c/c6/87/9cc68726-80a3-1289-0848-de0b745a31aa/screen696x696.jpeg'> <img height='300' alt='Tob image 4' src='http://a1.mzstatic.com/us/r30/Purple20/v4/b5/22/48/b52248a7-2d0b-7f68-3985-cbac5d7bcd3e/screen696x696.jpeg'> 
</div>
  </details>


## Calculator 
 
[back to top](#readme) 
 
- Calculator: React Native calculator  
  <details><summary><code>react native</code> 🔥🔥🔥🔥🔥</summary>

  https://github.com/benoitvallon/react-native-nw-react-calculator<br>  Added March 23, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Calculator image 1' src='https://i.imgur.com/8OKDHjU.png'> 
</div>
  </details>

- Coffee Ratio: Calculates grams of water needed given grams of coffee based off ratio chosen  
  <details><summary><code>swift</code> <code>swift3</code> </summary>

  https://github.com/jmp9c/Coffee-Ratio<br>  Added September  9, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Coffee Ratio image 1' src='https://i.imgur.com/rQxOsqO.png'> 
</div>
  </details>

- Currency Converter: Live foreign exchange rates & currency calculator [` App Store`](https://itunes.apple.com/app/currency-converter-free-quick/id1163490933)  
  <details><summary><code>swift</code> <code>viper</code> 🔥</summary>

  https://github.com/tirupati17/currency-converter-swift3.0-viper<br>  Added October 24, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Currency Converter image 1' src='https://raw.githubusercontent.com/tirupati17/currency-converter-swift3.0-viper/master/CurrencyConverter/Resources/iphone_5s.png'> 
</div>
  </details>

- Free42: A re-implementation of the HP-42S Calculator & the HP-82240 printer [` App Store`](https://itunes.apple.com/app/id337692629)  
  <details><summary><code>objc</code> </summary>

  http://thomasokken.com/free42/download/free42.tgz<br>  http://thomasokken.com/free42/<br>  Added June  2, 2016<br>  License: [`gpl-2.0`](http://choosealicense.com/licenses/gpl-2.0/)
  <div><img height='300' alt='Free42 image 1' src='http://a1.mzstatic.com/us/r30/Purple3/v4/a4/bd/1e/a4bd1e5c-a158-7669-76c9-915c3b41ecec/screen568x568.jpeg'> 
</div>
  </details>

- IBCalculator  
  <details><summary><code>swift</code> <code>ibinspectable</code> <code>ibdesignable</code> </summary>

  https://github.com/JakeLin/IBCalculator<br>  Added March 23, 2017<br>  License: `other`
  <div><img height='300' alt='IBCalculator image 1' src='https://raw.githubusercontent.com/JakeLin/IBCalculator/master/screenshots/IBCalcalator-iPhone.png'> 
</div>
  </details>

- NumberPad: An experimental prototype calculator  
  <details><summary><code>swift</code> </summary>

  https://github.com/bridger/NumberPad<br>  http://bridgermaxwell.com/blog/numberpad-notation/<br>  Added May 31, 2016<br>  License: [`apache-2.0`](http://choosealicense.com/licenses/apache-2.0/)
  <div><img height='300' alt='NumberPad image 1' src='https://i.imgur.com/5o7MaMll.png'> 
</div>
  </details>

- Round & Split: Tip Calculator [` App Store`](https://itunes.apple.com/app/round-split/id912288737)  
  <details><summary><code>swift</code> </summary>

  https://github.com/lukhnos/roundandsplit<br>  Added January 27, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Round & Split image 1' src='http://a5.mzstatic.com/us/r30/Purple22/v4/f1/a9/2e/f1a92e42-0507-06a1-d5c0-fd41f26e144b/screen696x696.jpeg'> <img height='300' alt='Round & Split image 2' src='http://a4.mzstatic.com/us/r30/Purple42/v4/60/ae/41/60ae411b-62ed-25b0-3136-80f64250aa60/screen696x696.jpeg'> 
</div>
  </details>

- SIP Calculator: Calculate the future value of SIP (Systematic Investment Plan) payments [` App Store`](https://itunes.apple.com/app/id1092822415)  
  <details><summary><code>swift</code> </summary>

  https://github.com/tirupati17/sip-calculator-swift<br>  Added July 17, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='SIP Calculator image 1' src='http://a5.mzstatic.com/us/r30/Purple69/v4/dc/cc/2c/dccc2c04-f147-30b4-0a9e-9bff2a857476/screen696x696.jpeg'> 
</div>
  </details>


## Calendar 
 
[back to top](#readme) 
 
- LunarCore: Small lunar calendar with Today Extension [` App Store`](https://itunes.apple.com/app/id1031088612)  
  <details><summary><code>objc</code> 🇨🇳 🔥🔥🔥</summary>

  https://github.com/cyanzhong/LunarCore<br>  Added October 31, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='LunarCore image 1' src='https://github.com/cyanzhong/LunarCore/raw/master/iOS.png'> 
</div>
  </details>

- Malendar: A redesigned calendar  
  <details><summary><code>swift</code> 🔥</summary>

  https://github.com/croossin/Malendar<br>  Added October 30, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Malendar image 1' src='https://github.com/croossin/Malendar/raw/master/Images/MalendarStockPhoto.png'> 
</div>
  </details>


## Color 
 
[back to top](#readme) 
 
- Colo: Color themes hunter  
  <details><summary><code>objc</code> </summary>

  https://github.com/wongzigii/Colo<br>  Added March 16, 2015<br>  License: [`apache-2.0`](http://choosealicense.com/licenses/apache-2.0/)
  <div><img height='300' alt='Colo image 1' src='https://github.com/wongzigii/Colo/raw/master/Assets/screenshot1.png'> 
</div>
  </details>

- GammaThingy: Change screen gamma dynamically  
  <details><summary><code>objc</code> 🔥🔥🔥</summary>

  https://github.com/thomasfinch/GammaThingy<br>  Added November 21, 2015<br>  License: `other`
  </details>

- GoodNight: Change screen gamma dynamically  
  <details><summary><code>objc</code> 🔥🔥🔥</summary>

  https://github.com/anthonya1999/GoodNight<br>  Added December 23, 2015<br>  License: `other`
  <div><img height='300' alt='GoodNight image 1' src='https://i.imgur.com/QEAE4B3.jpg'> 
</div>
  </details>


## Clock 
 
[back to top](#readme) 
 
- 4clock: Multiplayer chess clock [` App Store`](https://itunes.apple.com/app/4clock-chronometre-jeu-multijoueur/id1163604465)  
  <details><summary><code>javascript</code> <code>cordova</code> 🇫🇷 </summary>

  https://github.com/nicolapps/4clock<br>  Added February  9, 2017
  <div><img height='300' alt='4clock image 1' src='https://cdn-images-1.medium.com/max/600/1*wGpCIUaprr1viJ8JIJe9Hw.png'> 
</div>
  </details>

- Fibonacc iClock: A clock based off the famous Fibonacci sequence  
  <details><summary><code>objc</code> </summary>

  https://github.com/scribblemaniac/Fibonacc-iClock<br>  Added May 23, 2016<br>  License: [`gpl-2.0`](http://choosealicense.com/licenses/gpl-2.0/)
  <div><img height='300' alt='Fibonacc iClock image 1' src='https://raw.githubusercontent.com/scribblemaniac/Fibonnac-iClock/master/Screenshot.png'> 
</div>
  </details>

- Natural Language Clock: Display the time as you would speak it  
  <details><summary><code>swift</code> <code>watchos2</code> </summary>

  https://github.com/chadkeck/Natural-Language-Clock<br>  Added April 20, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Natural Language Clock image 1' src='https://github.com/chadkeck/Natural-Language-Clock/raw/master/assets/iPhone-and-Apple-Watch.png?raw=true'> 
</div>
  </details>


## Clone 
 
[back to top](#readme) 
 
- 2048  
  <details><summary><code>objc</code> 🔥🔥</summary>

  https://github.com/austinzheng/iOS-2048<br>  Added March 24, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='2048 image 1' src='https://github.com/austinzheng/iOS-2048/raw/master/screenshots/ss1.png?raw=true'> 
</div>
  </details>

- 2048  
  <details><summary><code>swift</code> 🔥🔥🔥🔥🔥</summary>

  https://github.com/austinzheng/swift-2048<br>  Added March 18, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='2048 image 1' src='https://cdn-images-1.medium.com/max/800/1*Lzt_Wm8hbVUEptBW-vhhMg.png'> 
</div>
  </details>

- 2048  
  <details><summary><code>spritekit</code> <code>objc</code> 🔥🔥🔥</summary>

  https://github.com/danqing/2048<br>  Added July 11, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='2048 image 1' src='https://camo.githubusercontent.com/ff3c4e76617a7af782d9670f1438801c7603c700/687474703a2f2f61342e6d7a7374617469632e636f6d2f75732f7233302f507572706c65342f76342f61342f66382f61662f61346638616631642d333837382d303831372d383539642d6465373662616531363963372f73637265656e353638783536382e6a706567'> 
</div>
  </details>

- Finance: The system Stocks app written in React Native  
  <details><summary><code>react native</code> 🔥🔥🔥🔥</summary>

  https://github.com/7kfpun/FinanceReactNative<br>  Added July  8, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Finance image 1' src='https://github.com/7kfpun/FinanceReactNative/blob/master/previewIOS.gif?raw=true'> 
</div>
  </details>

- FlappySwift: Flappy Bird clone  
  <details><summary><code>swift</code> 🔥🔥🔥🔥🔥</summary>

  https://github.com/fullstackio/FlappySwift<br>  Added March 18, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='FlappySwift image 1' src='https://camo.githubusercontent.com/867dfad61329bd77258f00d586b16476c7bc405a/687474703a2f2f692e696d6775722e636f6d2f314e4c6f546f552e676966'> 
</div>
  </details>

- graygram: Instagram clone  
  <details><summary><code>swift</code> <code>alamofire</code> <code>kingfisher</code> 🔥</summary>

  https://github.com/devxoul/graygram-ios<br>  Added March 10, 2017<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='graygram image 1' src='https://cloud.githubusercontent.com/assets/931655/23171892/4d3fd606-f897-11e6-87e0-7230d3010c7b.png'> 
</div>
  </details>

- Pinterest  
  <details><summary><code>swift</code> </summary>

  https://github.com/ivsall2012/AHPinterest<br>  Added May 11, 2017<br>  License: `other`
  <div><img height='300' alt='Pinterest image 1' src='https://github.com/ivsall2012/AHPinterest/blob/master/AHPinterset.png?raw=true'> 
</div>
  </details>

- Snake Classic: A snake engine for all Apple devices  
  <details><summary><code>swift</code> </summary>

  https://github.com/PiXeL16/SnakeClassic<br>  Added August 31, 2017<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Snake Classic image 1' src='https://raw.githubusercontent.com/PiXeL16/SnakeClassic/master/Art/SnakeWatch.png'> 
</div>
  </details>

- SwiftSnake: Snake clone  
  <details><summary><code>swift</code> </summary>

  https://github.com/caleb0/SwiftSnake<br>  Added August 19, 2016<br>  License: `other`
  <div><img height='300' alt='SwiftSnake image 1' src='https://i.imgur.com/mBi9Jfj.png'> 
</div>
  </details>

- youtube-iOS: YouTube app template  
  <details><summary><code>swift</code> <code>swift3</code> 🔥🔥🔥🔥</summary>

  https://github.com/aslanyanhaik/youtube-iOS<br>  Added August 15, 2016<br>  License: `other`
  <div><img height='300' alt='youtube-iOS image 1' src='https://i.giphy.com/hwCahHAD1tNHa.gif'> 
</div>
  </details>


## Communication 
 
[back to top](#readme) 
 
- Actor: Cross-platform instant message app  
  <details><summary><code>swift</code> <code>yyimage</code> 🔥🔥🔥🔥🔥</summary>

  https://github.com/actorapp/actor-platform<br>  Added April 11, 2016<br>  License: [`agpl-3.0`](http://choosealicense.com/licenses/agpl-3.0/)
  <div><img height='300' alt='Actor image 1' src='http://a2.mzstatic.com/us/r30/Purple18/v4/90/4f/79/904f794e-c2b3-363e-4c5c-4118dd6e7ee0/screen696x696.jpeg'> <img height='300' alt='Actor image 2' src='http://a3.mzstatic.com/us/r30/Purple60/v4/cd/67/d3/cd67d381-6a18-34cf-4e75-390075d426f3/screen696x696.jpeg'> <img height='300' alt='Actor image 3' src='http://a4.mzstatic.com/us/r30/Purple20/v4/a7/09/81/a70981f7-305d-cef5-c9ec-39c7aed6249e/screen696x696.jpeg'> <img height='300' alt='Actor image 4' src='http://a5.mzstatic.com/us/r30/Purple20/v4/f9/7c/af/f97caf76-fab8-31bc-2956-1dd0654064a9/screen696x696.jpeg'> <img height='300' alt='Actor image 5' src='http://a3.mzstatic.com/us/r30/Purple60/v4/a7/2c/57/a72c57e4-0bef-5009-1c98-c5395823d1ca/screen696x696.jpeg'> 
</div>
  </details>

- Antidote: A client for https://tox.chat/ [` App Store`](https://itunes.apple.com/app/apple-store/id933117605)  
  <details><summary><code>swift</code> <code>iphone</code> <code>ipad</code> 🔥🔥</summary>

  https://github.com/Antidote-for-Tox/Antidote<br>  https://antidote.im/<br>  Added June  1, 2016<br>  License: [`mpl-2.0`](http://choosealicense.com/licenses/mpl-2.0/)
  <div><img height='300' alt='Antidote image 1' src='https://tox.chat/theme/img/client/antidote_1.png'> 
</div>
  </details>

- AppRTC: A native video chat app  
  <details><summary><code>webrtc</code> <code>google</code> 🔥🔥🔥</summary>

  https://github.com/ISBX/apprtc-ios<br>  Added September  6, 2016<br>  License: [`bsd-3-clause`](http://choosealicense.com/licenses/bsd-3-clause/)
  <div><img height='300' alt='AppRTC image 1' src='https://github.com/ISBX/apprtc-ios/raw/master/screenshots/screenshots.jpg'> 
</div>
  </details>

- BLEMeshChat: Chat using Bluetooth 4.0 Low Energy API (Bluetooth LE)  
  <details><summary><code>yapdatabase</code> <code>purelayout</code> <code>mantle</code> <code>bluetooth</code> 🔥🔥</summary>

  https://github.com/chrisballinger/BLEMeshChat<br>  Added January 11, 2016<br>  License: [`mpl-2.0`](http://choosealicense.com/licenses/mpl-2.0/)
  <div><img height='300' alt='BLEMeshChat image 1' src='https://camo.githubusercontent.com/71c9718ca94505f7135024802d145148e90ae605/68747470733a2f2f692e696d6775722e636f6d2f7a386c4564504d6d2e706e67'> 
</div>
  </details>

- Chats  
  <details><summary><code>swift</code> 🔥🔥🔥🔥🔥</summary>

  https://github.com/acani/Chats<br>  Added March 18, 2015<br>  License: [`unlicense`](http://choosealicense.com/licenses/unlicense/)
  <div><img height='300' alt='Chats image 1' src='https://github.com/acani/Chats/raw/master/Documents/iPhone-Client-Screenshots/iPhone-Client-Screenshots.gif'> 
</div>
  </details>

- ChatSecure: Send messages with OTR encryption [` App Store`](https://itunes.apple.com/app/chatsecure-encrypted-messenger/id464200063)  
  <details><summary><code>xmpp</code> 🔥🔥🔥🔥🔥</summary>

  https://github.com/ChatSecure/ChatSecure-iOS<br>  Added March 26, 2015<br>  License: [`gpl-3.0`](http://choosealicense.com/licenses/gpl-3.0/)
  <div><img height='300' alt='ChatSecure image 1' src='http://a4.mzstatic.com/us/r30/Purple5/v4/bf/67/25/bf672587-f1ff-3ea8-6ba2-d2b51007cfd7/screen696x696.jpeg'> <img height='300' alt='ChatSecure image 2' src='http://a3.mzstatic.com/us/r30/Purple7/v4/9c/45/6e/9c456e12-a029-b900-3f74-a84e313932bd/screen696x696.jpeg'> <img height='300' alt='ChatSecure image 3' src='http://a4.mzstatic.com/us/r30/Purple7/v4/2f/ea/0e/2fea0ee9-ea64-a2eb-6546-5f0fd0a2f577/screen696x696.jpeg'> <img height='300' alt='ChatSecure image 4' src='http://a4.mzstatic.com/us/r30/Purple7/v4/4e/d7/91/4ed791e3-0915-64a3-6aea-64f4319019ab/screen696x696.jpeg'> 
</div>
  </details>

- Chaty: Anonymous messaging with real time data sync  
  <details><summary><code>firebase</code> <code>websocket</code> <code>nosql</code> 🔥🔥</summary>

  https://github.com/LunarFlash/Chaty<br>  Added May 25, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Chaty image 1' src='https://github.com/LunarFlash/Chaty/raw/master/ChatChat/screen1.png'> 
</div>
  </details>

- Colloquy: IRC client [` App Store`](https://itunes.apple.com/app/colloquy-irc-client/id302000478)  
  <details><summary><code>objc</code> </summary>

  https://github.com/colloquy/colloquy<br>  Added January 27, 2016<br>  License: `other`
  <div><img height='300' alt='Colloquy image 1' src='http://a2.mzstatic.com/us/r30/Purple3/v4/1c/6b/1f/1c6b1f4b-d464-9faf-47ba-aab606d62dff/screen696x696.jpeg'> <img height='300' alt='Colloquy image 2' src='http://a5.mzstatic.com/us/r30/Purple3/v4/af/54/c7/af54c763-96f6-7d4f-0813-1a19d06fb3dc/screen696x696.jpeg'> <img height='300' alt='Colloquy image 3' src='http://a2.mzstatic.com/us/r30/Purple3/v4/29/12/80/291280a9-87f0-41ad-121d-54ee39ec45df/screen696x696.jpeg'> <img height='300' alt='Colloquy image 4' src='http://a2.mzstatic.com/us/r30/Purple5/v4/7c/ef/78/7cef78fb-56e1-52e2-d5b4-6fbc833ca32b/screen696x696.jpeg'> <img height='300' alt='Colloquy image 5' src='http://a3.mzstatic.com/us/r30/Purple5/v4/18/55/21/185521ba-035e-6b2d-362f-0e50b767f5b7/screen696x696.jpeg'> 
</div>
  </details>

- IRCCloud: IRC client/service [` App Store`](https://itunes.apple.com/app/irccloud/id672699103)  
  <details><summary><code>fastlane</code> 🔥🔥</summary>

  https://github.com/irccloud/ios<br>  Added January 29, 2015<br>  License: [`apache-2.0`](http://choosealicense.com/licenses/apache-2.0/)
  <div><img height='300' alt='IRCCloud image 1' src='http://a2.mzstatic.com/us/r30/Purple20/v4/f5/c3/f3/f5c3f37e-17b6-e613-aff3-7d66b31a34b0/screen696x696.jpeg'> <img height='300' alt='IRCCloud image 2' src='http://a2.mzstatic.com/us/r30/Purple60/v4/87/49/ae/8749ae35-924b-5354-12f7-698113ad3fe4/screen696x696.jpeg'> <img height='300' alt='IRCCloud image 3' src='http://a2.mzstatic.com/us/r30/Purple30/v4/83/3a/02/833a024e-5d9e-4802-2c33-212662d4600c/screen696x696.jpeg'> <img height='300' alt='IRCCloud image 4' src='http://a3.mzstatic.com/us/r30/Purple18/v4/11/d2/0b/11d20b28-5f21-5718-298f-61a2af7b97e8/screen696x696.jpeg'> 
</div>
  </details>

- Linphone: Free audio/video calls & text messages [` App Store`](https://itunes.apple.com/app/linphone/id360065638)  
  <details><summary><code>objc</code> </summary>

  https://www.linphone.org/technical-corner/linphone/downloads<br>  https://www.linphone.org/<br>  Added May 31, 2016<br>  License: [`gpl-2.0`](http://choosealicense.com/licenses/gpl-2.0/)
  <div><img height='300' alt='Linphone image 1' src='http://a3.mzstatic.com/us/r30/Purple49/v4/77/1d/68/771d68c6-cd00-ee32-ffe7-33a6bdcd26d6/screen696x696.jpeg'> <img height='300' alt='Linphone image 2' src='http://a4.mzstatic.com/us/r30/Purple49/v4/0c/0c/ad/0c0cad7f-7fec-a217-7d31-af50dfecdb8b/screen696x696.jpeg'> 
</div>
  </details>

- M: Email with device-to-device encryption for messages sent between M users [` App Store`](https://itunes.apple.com/app/m-safe-email-made-simple/id818498595)  
  <details><summary><code>objc</code> </summary>

  https://github.com/Mynigma/M<br>  Added January 26, 2015<br>  License: [`gpl-3.0`](http://choosealicense.com/licenses/gpl-3.0/)
  <div><img height='300' alt='M image 1' src='http://a1.mzstatic.com/us/r30/Purple41/v4/39/79/63/39796337-2166-4778-9a89-1a1059b0c05a/screen800x500.jpeg'> 
</div>
  </details>

- Messenger: Audio/video calls, realtime chat & full offline support  
  <details><summary><code>firebase</code> <code>onesignal</code> <code>realm</code> 🔥🔥🔥🔥🔥</summary>

  https://github.com/relatedcode/Messenger<br>  Added July 19, 2017<br>  License: `other`
  <div><img height='300' alt='Messenger image 1' src='http://relatedcode.com/screen/chat01.png'> <img height='300' alt='Messenger image 2' src='http://relatedcode.com/screen/call1.png'> 
</div>
  </details>

- Monal: Connect to your chat server without having to give a third party access to your password or messages [` App Store`](https://itunes.apple.com/app/monal-free-xmpp-chat/id317711500)  
  <details><summary><code>xmpp</code> 🔥</summary>

  https://github.com/anurodhp/Monal<br>  Added November  7, 2016<br>  License: `other`
  <div><img height='300' alt='Monal image 1' src='http://a3.mzstatic.com/us/r30/Purple69/v4/ca/27/98/ca279896-a860-e33f-ef2c-cfdc1c62dbdc/screen696x696.jpeg'> <img height='300' alt='Monal image 2' src='http://a5.mzstatic.com/us/r30/Purple49/v4/24/53/b6/2453b64c-0c67-1e71-86f8-d96482ae992a/screen696x696.jpeg'> <img height='300' alt='Monal image 3' src='http://a2.mzstatic.com/us/r30/Purple69/v4/b2/e8/b2/b2e8b2f2-160e-19d2-1e38-94c9ab629b78/screen696x696.jpeg'> <img height='300' alt='Monal image 4' src='http://a4.mzstatic.com/us/r30/Purple69/v4/68/4c/ec/684cecd3-4d00-b658-9395-57ea1dafef47/screen696x696.jpeg'> <img height='300' alt='Monal image 5' src='http://a3.mzstatic.com/us/r30/Purple69/v4/c4/58/60/c458604e-d368-eb11-c315-7631bece7485/screen696x696.jpeg'> 
</div>
  </details>

- Mumble: Gaming-focused social voice chat utility [` App Store`](https://itunes.apple.com/app/mumble/id443472808)  
  <details><summary><code>fmdb</code> 🔥</summary>

  https://github.com/mumble-voip/mumble-iphoneos<br>  Added September 10, 2015<br>  License: [`bsd-3-clause`](http://choosealicense.com/licenses/bsd-3-clause/)
  <div><img height='300' alt='Mumble image 1' src='http://a3.mzstatic.com/us/r30/Purple19/v4/cd/72/30/cd723067-64a5-ba1c-bacf-7d3ac967fcf6/screen696x696.jpeg'> <img height='300' alt='Mumble image 2' src='http://a1.mzstatic.com/us/r30/Purple71/v4/85/8f/07/858f0765-90e5-7924-a856-c69debad6822/screen696x696.jpeg'> <img height='300' alt='Mumble image 3' src='http://a1.mzstatic.com/us/r30/Purple19/v4/ac/a7/5c/aca75cef-caa0-417e-9542-6e819ad02c2b/screen696x696.jpeg'> <img height='300' alt='Mumble image 4' src='http://a4.mzstatic.com/us/r30/Purple71/v4/41/1a/5b/411a5be1-031f-ff95-b981-f93da80c0f9c/screen696x696.jpeg'> 
</div>
  </details>

- Quick Chat: Real time chat app  
  <details><summary><code>swift</code> <code>swift3</code> <code>firebase</code> 🔥🔥🔥🔥</summary>

  https://github.com/aslanyanhaik/Quick-Chat<br>  Added January  6, 2017<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Quick Chat image 1' src='https://raw.githubusercontent.com/aslanyanhaik/Quick-Chat/master/screenshot.gif'> 
</div>
  </details>

- Real-time Chat  
  <details><summary><code>firebase</code> </summary>

  https://www.raywenderlich.com/140836/firebase-tutorial-real-time-chat-2<br>  Added November 11, 2016<br>  License: `other`
  <div><img height='300' alt='Real-time Chat image 1' src='https://koenig-media.raywenderlich.com/uploads/2016/08/RoadCyclingChatThread.jpg'> 
</div>
  </details>

- Riot: Collaboration for teams, chat & share with https://matrix.org/ [` App Store`](https://itunes.apple.com/us/app/vector-open-source-collaboration/id1083446067)  
  <details><summary><code>webrtc</code> <code>realm</code> 🔥🔥</summary>

  https://github.com/vector-im/riot-ios<br>  https://vector.im/<br>  Added July 21, 2016<br>  License: [`apache-2.0`](http://choosealicense.com/licenses/apache-2.0/)
  <div><img height='300' alt='Riot image 1' src='http://a2.mzstatic.com/us/r30/Purple18/v4/7a/22/48/7a224810-475c-cb4e-a165-02761701831d/screen696x696.jpeg'> 
</div>
  </details>

- Rocket.Chat: Meteor chat platform app [` App Store`](https://itunes.apple.com/app/rocket-chat/id1148741252)  
  <details><summary><code>swift</code> 🔥🔥</summary>

  https://github.com/RocketChat/Rocket.Chat.iOS<br>  Added January 29, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Rocket.Chat image 1' src='http://a2.mzstatic.com/us/r30/Purple49/v4/6b/67/2d/6b672d4d-1d88-382c-aa02-db66dfc97421/screen696x696.jpeg'> <img height='300' alt='Rocket.Chat image 2' src='http://a5.mzstatic.com/us/r30/Purple49/v4/27/b5/b3/27b5b3e0-102e-605f-d086-def467181dcb/screen696x696.jpeg'> <img height='300' alt='Rocket.Chat image 3' src='http://a1.mzstatic.com/us/r30/Purple49/v4/71/f0/6f/71f06f5d-07af-96b9-016a-cd27f006d211/screen696x696.jpeg'> <img height='300' alt='Rocket.Chat image 4' src='http://a3.mzstatic.com/us/r30/Purple49/v4/ef/88/2b/ef882bb0-e6ca-882a-f355-b9b298c2412d/screen696x696.jpeg'> <img height='300' alt='Rocket.Chat image 5' src='http://a2.mzstatic.com/us/r30/Purple49/v4/88/f6/58/88f65868-21eb-d01a-61e9-20481d3852c1/screen696x696.jpeg'> 
</div>
  </details>

- Signal: Free, world-wide, private messaging & phone calls [` App Store`](https://itunes.apple.com/app/id874139669)  
  <details><summary><code>iphone</code> <code>carthage</code> <code>socketrocket</code> <code>purelayout</code> <code>openssl</code> 🔥🔥🔥🔥🔥</summary>

  https://github.com/signalapp/Signal-iOS<br>  Added February 27, 2015<br>  License: [`gpl-3.0`](http://choosealicense.com/licenses/gpl-3.0/)
  <div><img height='300' alt='Signal image 1' src='http://a1.mzstatic.com/us/r30/Purple30/v4/54/bb/ac/54bbacd8-9a2d-4317-0cdf-ed35aff86770/screen696x696.jpeg'> <img height='300' alt='Signal image 2' src='http://a5.mzstatic.com/us/r30/Purple30/v4/77/21/be/7721be1e-3df8-15cd-ee6e-9549a24106c5/screen696x696.jpeg'> <img height='300' alt='Signal image 3' src='http://a3.mzstatic.com/us/r30/Purple18/v4/89/9a/c9/899ac960-f241-d65b-0041-9351f6eabda3/screen696x696.jpeg'> <img height='300' alt='Signal image 4' src='http://a2.mzstatic.com/us/r30/Purple20/v4/ee/bc/c0/eebcc086-5ddf-8073-af83-ac2709cb6b3d/screen696x696.jpeg'> 
</div>
  </details>

- Spika: Cross-platform messenger module  
  <details><summary><code>afnetworking</code> <code>sdwebimage</code> 🔥🔥</summary>

  https://github.com/cloverstudio/Spika<br>  https://spika.business/<br>  Added June  2, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Spika image 1' src='https://github.com/cloverstudio/Spika/raw/master/spika_demo_new.gif'> 
</div>
  </details>

- surespot: Secures all messages with end-to-end encryption [` App Store`](https://itunes.apple.com/app/surespot/id790314865)  
  <details><summary><code>objc</code> </summary>

  https://github.com/surespot/surespot-ios<br>  Added March  3, 2016<br>  License: [`gpl-3.0`](http://choosealicense.com/licenses/gpl-3.0/)
  <div><img height='300' alt='surespot image 1' src='http://a1.mzstatic.com/us/r30/Purple6/v4/7d/3e/79/7d3e79c8-93f3-856d-76fd-f9db990ffd1b/screen696x696.jpeg'> <img height='300' alt='surespot image 2' src='http://a4.mzstatic.com/us/r30/Purple4/v4/8f/01/7a/8f017a28-6e99-be29-9486-d3ec83b991ae/screen696x696.jpeg'> <img height='300' alt='surespot image 3' src='http://a3.mzstatic.com/us/r30/Purple/v4/ee/18/74/ee1874ae-b815-9556-f2cb-aa1481180c46/screen696x696.jpeg'> 
</div>
  </details>

- Telegram: Send messages with a focus on speed & security [` App Store`](https://itunes.apple.com/app/telegram-messenger/id686449807)  
  <details><summary><code>objc</code> 🔥🔥🔥🔥</summary>

  https://github.com/peter-iakovlev/Telegram<br>  Added April  6, 2015<br>  License: `other`
  <div><img height='300' alt='Telegram image 1' src='http://a5.mzstatic.com/us/r30/Purple62/v4/d1/90/fd/d190fd61-005a-a5b7-0bf4-91b5c588b970/screen696x696.jpeg'> <img height='300' alt='Telegram image 2' src='http://a2.mzstatic.com/us/r30/Purple71/v4/95/f3/2e/95f32efb-5e42-841e-f142-b25b14f62f25/screen696x696.jpeg'> <img height='300' alt='Telegram image 3' src='http://a3.mzstatic.com/us/r30/Purple71/v4/ad/4c/76/ad4c768a-31c3-8fb2-daf4-effd9914e46c/screen696x696.jpeg'> <img height='300' alt='Telegram image 4' src='http://a2.mzstatic.com/us/r30/Purple71/v4/92/80/a3/9280a32a-66b6-15b9-b8fb-866ea1e13bfa/screen696x696.jpeg'> <img height='300' alt='Telegram image 5' src='http://a2.mzstatic.com/us/r30/Purple62/v4/be/00/19/be00193f-ee7e-9886-09d5-86ca9dfa2faf/screen696x696.jpeg'> 
</div>
  </details>

- Toshi: Private & secure messaging, Ethereum wallet and browser  
  <details><summary><code>swift</code> </summary>

  https://github.com/toshiapp/toshi-ios-client<br>  Added April 21, 2017<br>  License: [`gpl-3.0`](http://choosealicense.com/licenses/gpl-3.0/)
  <div><img height='300' alt='Toshi image 1' src='http://a1.mzstatic.com/us/r30/Purple122/v4/45/e5/da/45e5daf2-6dd5-ae2c-da9f-35f60f9cdaca/screen696x696.jpeg'> 
</div>
  </details>

- TrollDrop: Send trollfaces to everyone  
  <details><summary><code>airdrop</code> </summary>

  https://github.com/a2/TrollDrop<br>  Added May  2, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='TrollDrop image 1' src='https://i.imgur.com/gb1G8di.png'> 
</div>
  </details>

- TSWeChat: A WeChat alternative  
  <details><summary><code>swift</code> 🔥🔥🔥🔥🔥</summary>

  https://github.com/hilen/TSWeChat<br>  Added May 18, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='TSWeChat image 1' src='https://github.com/hilen/TSWeChat/raw/master/images/preview1.gif'> 
</div>
  </details>

- Tutanota: End-to-end encrypted email [` App Store`](https://itunes.apple.com/app/id922429609)  
  <details><summary><code>javascript</code> <code>cordova</code> <code>iphone</code> <code>ipad</code> 🔥🔥🔥🔥</summary>

  https://github.com/tutao/tutanota<br>  https://tutanota.com/<br>  Added June  1, 2016<br>  License: [`gpl-3.0`](http://choosealicense.com/licenses/gpl-3.0/)
  <div><img height='300' alt='Tutanota image 1' src='http://a2.mzstatic.com/us/r30/Purple71/v4/7e/80/e2/7e80e291-ee1e-ffb4-9449-c0431136832c/screen696x696.jpeg'> <img height='300' alt='Tutanota image 2' src='http://a1.mzstatic.com/us/r30/Purple62/v4/d3/37/fd/d337fd23-a7e0-a903-3249-6b793974df2d/screen696x696.jpeg'> <img height='300' alt='Tutanota image 3' src='http://a2.mzstatic.com/us/r30/Purple71/v4/7b/09/a2/7b09a205-22f4-addf-6641-c1462c1d0c98/screen696x696.jpeg'> <img height='300' alt='Tutanota image 4' src='http://a5.mzstatic.com/us/r30/Purple22/v4/9e/c9/8f/9ec98f0b-b5a8-1aa4-98ba-b3c748ed8e18/screen696x696.jpeg'> 
</div>
  </details>

- Vapor Chat: Basic realtime chat project using Vapor on the server  
  <details><summary><code>swift</code> <code>starscream</code> </summary>

  https://github.com/vapor-community/chat-ios-example<br>  Added September 30, 2016<br>  License: `other`
  <div><img height='300' alt='Vapor Chat image 1' src='https://i.imgur.com/DuQSjpY.png'> 
</div>
  </details>

- Wire: Modern, private communications with crystal clear voice, video, group chats. Always encrypted. [` App Store`](https://itunes.apple.com/app/wire/id930944768)  
  <details><summary><code>swift</code> <code>carthage</code> <code>afnetworking</code> <code>purelayout</code> 🔥🔥🔥🔥🔥</summary>

  https://github.com/wireapp/wire-ios<br>  Added July 22, 2016<br>  License: [`gpl-3.0`](http://choosealicense.com/licenses/gpl-3.0/)
  <div><img height='300' alt='Wire image 1' src='https://cdn-images-1.medium.com/max/800/1*CEtofzY1rIOKuGT7JO3VkA.png'> 
</div>
  </details>


## Developer 
 
[back to top](#readme) 
 
- AppLove: View app reviews for all territories (countries)  
  <details><summary><code>swift</code> </summary>

  https://github.com/snowpunch/AppLove<br>  Added May  7, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div>
</div>
  </details>

- Blink: Mobile shell terminal based on Mosh [` App Store`](https://itunes.apple.com/app/id1156707581)  
  <details><summary><code>uickeychainstore</code> <code>passcodelock</code> 🔥🔥🔥🔥</summary>

  https://github.com/blinksh/blink<br>  Added July 12, 2016<br>  License: [`gpl-3.0`](http://choosealicense.com/licenses/gpl-3.0/)
  <div><img height='300' alt='Blink image 1' src='http://a3.mzstatic.com/us/r30/Purple71/v4/a4/c1/40/a4c1408f-f463-823e-7bb3-fd21b8ccc770/screen696x696.jpeg'> <img height='300' alt='Blink image 2' src='http://a5.mzstatic.com/us/r30/Purple71/v4/32/7f/26/327f2687-8f48-cad8-f1d6-bddb50e64353/screen696x696.jpeg'> <img height='300' alt='Blink image 3' src='http://a3.mzstatic.com/us/r30/Purple62/v4/c0/d2/d8/c0d2d869-6136-2969-8310-d72781769b39/screen696x696.jpeg'> <img height='300' alt='Blink image 4' src='http://a5.mzstatic.com/us/r30/Purple62/v4/b3/7d/9b/b37d9b69-7242-44fb-2059-8fb1e42663e8/screen696x696.jpeg'> 
</div>
  </details>

- Buglife: Awesome bug reporting SDK & web platform  
  <details><summary><code>objc</code> 🔥🔥</summary>

  https://github.com/Buglife/Buglife-iOS<br>  Added January 13, 2018<br>  License: [`apache-2.0`](http://choosealicense.com/licenses/apache-2.0/)
  <div><img height='300' alt='Buglife image 1' src='https://camo.githubusercontent.com/55591e6221b916eb92a96395a03ccd1f81c5b36a/68747470733a2f2f692e696d6775722e636f6d2f6d647767447a642e706e67'> 
</div>
  </details>

- Charter: Mailing list app  
  <details><summary><code>swift</code> <code>iphone</code> <code>ipad</code> 🔥🔥</summary>

  https://github.com/matthewpalmer/Charter<br>  Added February 22, 2016<br>  License: `other`
  <div><img height='300' alt='Charter image 1' src='https://cdn-images-1.medium.com/max/800/1*3igvNkkU0qmS0lox6epnSQ.png'> 
</div>
  </details>

- CI2Go: An app for https://circleci.com/ [` App Store`](https://itunes.apple.com/app/ci2go-the-circleci-client/id940028427)  
  <details><summary><code>swift</code> </summary>

  https://github.com/ngs/ci2go<br>  Added March 21, 2016<br>  License: `other`
  <div><img height='300' alt='CI2Go image 1' src='http://a2.mzstatic.com/us/r30/Purple49/v4/66/36/e5/6636e56d-931e-be79-97b5-ee3f4d83a73d/screen696x696.jpeg'> <img height='300' alt='CI2Go image 2' src='http://a3.mzstatic.com/us/r30/Purple69/v4/d4/ed/ba/d4edba4e-36b3-0f5e-6e04-ca3d9e572464/screen696x696.jpeg'> <img height='300' alt='CI2Go image 3' src='http://a2.mzstatic.com/us/r30/Purple69/v4/ce/70/57/ce705779-25a3-6b5b-c02c-2e13d6268c1c/screen696x696.jpeg'> <img height='300' alt='CI2Go image 4' src='http://a5.mzstatic.com/us/r30/Purple69/v4/b4/96/83/b49683ea-62bc-e9a5-9480-bd75e529d259/screen696x696.jpeg'> <img height='300' alt='CI2Go image 5' src='http://a5.mzstatic.com/us/r30/Purple49/v4/12/ad/b0/12adb0a2-d960-ddbe-5d48-58a51fa3703c/screen696x696.jpeg'> 
</div>
  </details>

- CodeBucket: Browse & maintain your Bitbucket repositories  
  <details><summary><code>objc</code> 🔥</summary>

  https://github.com/thedillonb/CodeBucket<br>  Added June  3, 2016<br>  License: `other`
  <div><img height='300' alt='CodeBucket image 1' src='https://raw.githubusercontent.com/thedillonb/CodeBucket/master/Screenshots/RepositoryView.png'> <img height='300' alt='CodeBucket image 2' src='https://raw.githubusercontent.com/thedillonb/CodeBucket/master/Screenshots/Slideout.png'> <img height='300' alt='CodeBucket image 3' src='https://raw.githubusercontent.com/thedillonb/CodeBucket/master/Screenshots/Repositories.png'> <img height='300' alt='CodeBucket image 4' src='https://raw.githubusercontent.com/thedillonb/CodeBucket/master/Screenshots/ChangeSets.png'> <img height='300' alt='CodeBucket image 5' src='https://raw.githubusercontent.com/thedillonb/CodeBucket/master/Screenshots/Issues.png'> 
</div>
  </details>

- CodeSprint: Real-time SCRUM management tool for teams  
  <details><summary><code>objc</code> </summary>

  https://github.com/chauvincent/CodeSprint-iOS<br>  Added November 23, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='CodeSprint image 1' src='http://a1.mzstatic.com/us/r30/Purple62/v4/95/15/ad/9515add9-5322-a96e-5ab6-bbd258d524d5/screen696x696.jpeg'> <img height='300' alt='CodeSprint image 2' src='http://a1.mzstatic.com/us/r30/Purple71/v4/3e/95/f0/3e95f062-ed08-1a9f-b64a-f7cc05930e42/screen696x696.jpeg'> <img height='300' alt='CodeSprint image 3' src='http://a4.mzstatic.com/us/r30/Purple62/v4/88/94/25/88942500-f5ea-c03f-41d6-81477f9b78f9/screen696x696.jpeg'> <img height='300' alt='CodeSprint image 4' src='http://a3.mzstatic.com/us/r30/Purple62/v4/36/1c/42/361c4270-a061-f7fc-19fa-91e4321aecc4/screen696x696.jpeg'> <img height='300' alt='CodeSprint image 5' src='http://a5.mzstatic.com/us/r30/Purple62/v4/5a/47/90/5a47904c-a86c-336d-c105-9dd20dac1872/screen696x696.jpeg'> 
</div>
  </details>

- Codinator: Code editor  
  <details><summary><code>iphone</code> <code>ipad</code> </summary>

  https://github.com/DanilaVladi/codinator<br>  Added April 11, 2016<br>  License: `other`
  <div><img height='300' alt='Codinator image 1' src='http://a1.mzstatic.com/us/r30/Purple20/v4/a6/14/16/a61416a0-e5cb-1166-0358-c680f2f2f42e/screen696x696.jpeg'> <img height='300' alt='Codinator image 2' src='http://a2.mzstatic.com/us/r30/Purple60/v4/bc/e1/11/bce111fb-5d80-a414-fc6d-6117ecc6bc5d/screen696x696.jpeg'> <img height='300' alt='Codinator image 3' src='http://a5.mzstatic.com/us/r30/Purple60/v4/c0/b8/6a/c0b86aa4-1d6e-1e86-6871-c975daa505da/screen696x696.jpeg'> <img height='300' alt='Codinator image 4' src='http://a5.mzstatic.com/us/r30/Purple18/v4/24/5f/b2/245fb21c-e2e1-7c71-4d62-7cfa8134b7ea/screen696x696.jpeg'> <img height='300' alt='Codinator image 5' src='http://a4.mzstatic.com/us/r30/Purple60/v4/b2/86/1a/b2861a3d-ec5d-5888-7331-c73d5c5c2859/screen696x696.jpeg'> 
</div>
  </details>

- Dash: Instant offline access to 150+ API documentation sets [` App Store`](https://itunes.apple.com/app/dash-offline-api-docs/id1239167694)  
  <details><summary><code>iphone</code> <code>ipad</code> <code>kissxml</code> <code>dznemptydataset</code> <code>dtbonjour</code> <code>samkeychain</code> 🔥🔥🔥🔥🔥</summary>

  https://github.com/Kapeli/Dash-iOS<br>  https://kapeli.com/dash_ios<br>  Added November 14, 2016<br>  License: [`gpl-3.0`](http://choosealicense.com/licenses/gpl-3.0/)
  <div><img height='300' alt='Dash image 1' src='https://kapeli.com/img/dash_ios-s1.png'> <img height='300' alt='Dash image 2' src='https://kapeli.com/img/dash_ios-s2.png'> 
</div>
  </details>

- ESCapey: macOS server & iOS client app pair that allow you to turn any iOS device into the escape key you've come to know and love  
  <details><summary><code>swift</code> 🔥🔥</summary>

  https://github.com/brianmichel/ESCapey<br>  Added October 26, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='ESCapey image 1' src='https://github.com/brianmichel/ESCapey/raw/master/images/ios-screenshot-2.png'> <img height='300' alt='ESCapey image 2' src='https://github.com/brianmichel/ESCapey/raw/master/images/ios-screenshot-1.png'> 
</div>
  </details>

- Expo Client: Developer tool for creating experiences with interactive gestures & graphics [` App Store`](https://itunes.apple.com/app/expo-client/id982107779)  
  <details><summary><code>react-native</code> <code>javascript</code> 🔥🔥🔥🔥🔥</summary>

  https://github.com/expo/expo<br>  https://expo.io/<br>  Added April 28, 2017<br>  License: [`bsd-3-clause`](http://choosealicense.com/licenses/bsd-3-clause/)
  <div><img height='300' alt='Expo Client image 1' src='http://a4.mzstatic.com/us/r30/Purple111/v4/42/1e/6e/421e6e4d-2524-5e1a-93aa-b8159d48a8fa/screen696x696.jpeg'> 
</div>
  </details>

- iOSAppsInfo: List installed apps & URL schemes  
  <details><summary><code>objc</code> 🔥</summary>

  https://github.com/wujianguo/iOSAppsInfo<br>  Added October 11, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='iOSAppsInfo image 1' src='https://github.com/wujianguo/iOSAppsInfo/raw/master/SampleImages/1.PNG'> <img height='300' alt='iOSAppsInfo image 2' src='https://github.com/wujianguo/iOSAppsInfo/raw/master/SampleImages/3.PNG'> 
</div>
  </details>

- iperf: Run an iperf3 client, including reverse mode & multiple streams selection  
  <details><summary><code>objc</code> </summary>

  https://github.com/ndfred/iperf-ios<br>  Added November 14, 2016<br>  License: `other`
  <div><img height='300' alt='iperf image 1' src='https://github.com/ndfred/iperf-ios/raw/master/Screenshot.png'> 
</div>
  </details>

- Jasonette: Create a native app over HTTP  
  <details><summary><code>json</code> <code>javascript</code> 🔥🔥🔥🔥🔥</summary>

  https://github.com/Jasonette/JASONETTE-iOS<br>  http://jasonette.com/<br>  Added November 10, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Jasonette image 1' src='https://github.com/Jasonette/Instagram-UI-example/raw/master/images/instagram.gif'> 
</div>
  </details>

- Knuff: The debug app for Apple Push Notification service [` App Store`](https://itunes.apple.com/app/knuff-the-apns-debug-tool/id993435856)  
  <details><summary><code>swift</code> <code>pop</code> <code>apns</code> </summary>

  https://github.com/KnuffApp/Knuff-iOS<br>  Added October 25, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Knuff image 1' src='http://a4.mzstatic.com/us/r30/Purple49/v4/f9/21/14/f9211459-6b65-ed7c-ec75-c58c4de7f497/screen696x696.jpeg'> 
</div>
  </details>

- Major Input: Read WWDC session transcripts synced with the video  
  <details><summary><code>swift</code> <code>ipad</code> <code>haneke</code> <code>quick</code> <code>nimble</code> <code>carthage</code> <code>swiftyjson</code> </summary>

  https://github.com/rlwimi/major-input<br>  Added May 31, 2017<br>  License: `other`
  <div><img height='300' alt='Major Input image 1' src='https://github.com/rlwimi/major-input/raw/master/Resources/screenshots/tour.gif'> 
</div>
  </details>

- Matomo: Access analytics on the go (formerly Piwik) [` App Store`](https://itunes.apple.com/app/id737216887)  
  <details><summary><code>objc</code> </summary>

  https://github.com/matomo-org/matomo-mobile-2<br>  Added June  1, 2016<br>  License: [`gpl-3.0`](http://choosealicense.com/licenses/gpl-3.0/)
  <div><img height='300' alt='Matomo image 1' src='http://a5.mzstatic.com/us/r30/Purple5/v4/04/76/42/04764246-03ec-4c04-0b2b-710805357b74/screen696x696.jpeg'> <img height='300' alt='Matomo image 2' src='http://a4.mzstatic.com/us/r30/Purple3/v4/6e/bf/79/6ebf7979-44a1-2d00-6b5c-eb7c9c723955/screen696x696.jpeg'> <img height='300' alt='Matomo image 3' src='http://a4.mzstatic.com/us/r30/Purple3/v4/db/b1/e7/dbb1e7d3-6e59-3e98-8be9-197b25e99c86/screen696x696.jpeg'> <img height='300' alt='Matomo image 4' src='http://a2.mzstatic.com/us/r30/Purple3/v4/62/10/b0/6210b03c-5d0c-45fd-c23d-f85f5de25b4b/screen696x696.jpeg'> <img height='300' alt='Matomo image 5' src='http://a4.mzstatic.com/us/r30/Purple3/v4/d1/14/5f/d1145fb7-5cf2-f5b9-e53c-4ad68f748190/screen696x696.jpeg'> 
</div>
  </details>

- MobileTerminal: Proof-of-concept for sandboxed Terminal environment  
  <details><summary><code>c</code> <code>dlopen</code> 🔥</summary>

  https://github.com/steventroughtonsmith/MobileTerminal<br>  Added February  6, 2017<br>  License: `other`
  <div><img height='300' alt='MobileTerminal image 1' src='http://hccdata.s3.amazonaws.com/gh_mobileterm_1.jpg'> 
</div>
  </details>

- NWPusher: Play with the Apple Push Notification service  
  <details><summary><code>apns</code> 🔥🔥🔥🔥🔥</summary>

  https://github.com/noodlewerk/NWPusher<br>  Added November 28, 2016<br>  License: [`bsd-2-clause`](http://choosealicense.com/licenses/bsd-2-clause/)
  <div><img height='300' alt='NWPusher image 1' src='https://github.com/noodlewerk/NWPusher/raw/master/Docs/osx2.png'> <img height='300' alt='NWPusher image 2' src='https://github.com/noodlewerk/NWPusher/raw/master/Docs/ios.png'> 
</div>
  </details>

- OpenTerm: Sandboxed command line interface [` App Store`](https://itunes.apple.com/app/terminal/id1323205755)  
  <details><summary><code>swift</code> <code>panelkit</code> 🔥🔥🔥</summary>

  https://github.com/louisdh/terminal<br>  Added January  8, 2018<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='OpenTerm image 1' src='http://is3.mzstatic.com/image/thumb/Purple128/v4/0e/5a/9c/0e5a9c66-67f4-d369-a701-f295e84cd959/source/392x696bb.jpg'> 
</div>
  </details>

- Pisth: SSH and SFTP client [` App Store`](https://itunes.apple.com/app/pisth/id1331070425)  
  <details><summary><code>objc</code> </summary>

  https://github.com/ColdGrub1384/Pisth<br>  https://pisth.github.io<br>  Added January 12, 2018<br>  License: [`apache-2.0`](http://choosealicense.com/licenses/apache-2.0/)
  <div><img height='300' alt='Pisth image 1' src='https://pisth.github.io/screenshots/1.PNG'> <img height='300' alt='Pisth image 2' src='https://pisth.github.io/screenshots/2.PNG'> <img height='300' alt='Pisth image 3' src='https://pisth.github.io/screenshots/3.jpeg'> <img height='300' alt='Pisth image 4' src='https://pisth.github.io/screenshots/4.PNG'> <img height='300' alt='Pisth image 5' src='https://pisth.github.io/screenshots/5.PNG'> 
</div>
  </details>

- RealmVideo: Watch Realm videos & slides  
  <details><summary><code>swift</code> <code>iphone</code> 🔥🔥</summary>

  https://github.com/BalestraPatrick/RealmVideo<br>  Added May 11, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='RealmVideo image 1' src='https://github.com/BalestraPatrick/RealmVideo/raw/master/Resources/demo.gif'> 
</div>
  </details>

- Retriever: Get InfoPlist without jailbreak  
  <details><summary><code>objc</code> 🔥🔥🔥</summary>

  https://github.com/cyanzhong/Retriever<br>  Added October 27, 2016<br>  License: `other`
  <div><img height='300' alt='Retriever image 1' src='https://github.com/cyanzhong/retriever/raw/master/Screenshots/1.PNG'> <img height='300' alt='Retriever image 2' src='https://github.com/cyanzhong/retriever/raw/master/Screenshots/2.PNG'> 
</div>
  </details>

- Review Time: Shows average review times for iOS & Mac apps  
  <details><summary><code>swift</code> 🔥</summary>

  https://github.com/nthegedus/ReviewTime<br>  Added October  8, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Review Time image 1' src='https://github.com/nthegedus/ReviewTime/raw/master/Design/ReviewTime.png'> 
</div>
  </details>

- ReviewMonitor: iTunes Connect app which is actually useful  
  <details><summary><code>swift</code> </summary>

  https://github.com/RishabhTayal/ReviewMonitor<br>  Added December 27, 2017
  <div><img height='300' alt='ReviewMonitor image 1' src='https://github.com/RishabhTayal/ReviewMonitor/blob/master/public-screenshots/screenshot1.png?raw=true'> <img height='300' alt='ReviewMonitor image 2' src='https://github.com/RishabhTayal/ReviewMonitor/blob/master/public-screenshots/screenshot2.png?raw=true'> 
</div>
  </details>

- Shadertweak: An iPad app that allows you to rapidly prototype fragment shaders in the Metal shading language  
  <details><summary><code>objc</code> <code>metal</code> 🔥🔥</summary>

  https://github.com/warrenm/Shadertweak<br>  Added January 13, 2018<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Shadertweak image 1' src='https://github.com/warrenm/Shadertweak/blob/master/screenshot.png?raw=true'> 
</div>
  </details>

- Terrarium: UI prototyping for coders  
  <details><summary><code>c++</code> 🔥</summary>

  https://github.com/penk/terrarium-app<br>  Added February 23, 2017<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Terrarium image 1' src='http://a1.mzstatic.com/us/r30/Purple3/v4/80/7a/9f/807a9f8a-3ec4-087d-e50e-050eb813747a/screen696x696.jpeg'> <img height='300' alt='Terrarium image 2' src='http://a4.mzstatic.com/us/r30/Purple1/v4/6c/42/12/6c4212ff-1e96-e68c-d3bc-cb4c4d0bd281/screen696x696.jpeg'> <img height='300' alt='Terrarium image 3' src='http://a3.mzstatic.com/us/r30/Purple3/v4/cf/1e/7a/cf1e7a68-e703-45fc-5e24-8f01f2a5b6c9/screen696x696.jpeg'> 
</div>
  </details>

- TLDR Man Page: Reference dictionary for computer manual commands, but in tl;dr (too long; didn't read) mode  
  <details><summary><code>swift</code> </summary>

  https://github.com/freesuraj/TLDR<br>  Added May  3, 2016<br>  License: `other`
  <div>
</div>
  </details>

- WWDC Family iOS: Easily connect with fellow developers during WWDC  
  <details><summary><code>swift</code> </summary>

  https://github.com/3lvis/ios<br>  Added February 21, 2017<br>  License: `other`
  <div><img height='300' alt='WWDC Family iOS image 1' src='https://raw.githubusercontent.com/wwdc-family/design/master/Images/1.png'> 
</div>
  </details>

- 花灰: How to prounounce programming terms in English  
  <details><summary><code>swift</code> 🇨🇳 🔥</summary>

  https://github.com/lexrus/Huahui<br>  https://twitter.com/lexrus/status/836928202912063491<br>  Added March  2, 2017<br>  License: `other`
  <div><img height='300' alt='花灰 image 1' src='https://media.giphy.com/media/3oKIPvvaugnP88DdOE/source.gif'> 
</div>
  </details>


### GitHub 
 
[back to top](#readme) 
 
- CodeHub: Browse & maintain GitHub repositories [` App Store`](https://itunes.apple.com/app/id707173885)  
  <details><summary><code>csharp</code> 🔥🔥🔥🔥🔥</summary>

  https://github.com/CodeHubApp/CodeHub<br>  http://codehub-app.com/<br>  Added June  1, 2016<br>  License: `other`
  <div><img height='300' alt='CodeHub image 1' src='http://a1.mzstatic.com/us/r30/Purple49/v4/34/47/f7/3447f73d-7c25-0ace-719c-d8a286521ed7/screen696x696.jpeg'> <img height='300' alt='CodeHub image 2' src='http://a4.mzstatic.com/us/r30/Purple69/v4/4c/e1/5b/4ce15b73-3010-47c4-2c94-569b1898aebb/screen696x696.jpeg'> <img height='300' alt='CodeHub image 3' src='http://a1.mzstatic.com/us/r30/Purple49/v4/28/8b/0d/288b0d9b-d596-4128-de57-d51310d63cff/screen696x696.jpeg'> <img height='300' alt='CodeHub image 4' src='http://a4.mzstatic.com/us/r30/Purple49/v4/e7/eb/f0/e7ebf020-0ad7-f61a-e702-e6507e8c1925/screen696x696.jpeg'> <img height='300' alt='CodeHub image 5' src='http://a4.mzstatic.com/us/r30/Purple49/v4/fc/94/aa/fc94aaa7-bddf-5c48-9727-09ee45595194/screen696x696.jpeg'> 
</div>
  </details>

- Contributions for GitHub: Look at your GitHub contributions graph in a Today Extension [` App Store`](https://itunes.apple.com/app/contributions-for-github/id1153432612)  
  <details><summary><code>objc</code> 🔥🔥</summary>

  https://github.com/JustinFincher/GitHubContributionsiOS<br>  Added October  6, 2016<br>  License: `other`
  <div><img height='300' alt='Contributions for GitHub image 1' src='https://github.com/JustinFincher/GitHubContributionsiOS/raw/master/Sketch/GitHub-Contributions.jpg'> 
</div>
  </details>

- GitBucket: GitHub app [` App Store`](https://itunes.apple.com/app/id961330940)  
  <details><summary><code>reactivecocoa</code> <code>mvvm</code> <code>mantle</code> 🔥🔥🔥🔥🔥</summary>

  https://github.com/leichunfeng/MVVMReactiveCocoa<br>  Added October 12, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='GitBucket image 1' src='http://a4.mzstatic.com/us/r30/Purple20/v4/ba/37/a3/ba37a3d1-622f-866f-f9eb-e2d21173cc93/screen696x696.jpeg'> <img height='300' alt='GitBucket image 2' src='http://a5.mzstatic.com/us/r30/Purple20/v4/8e/06/d7/8e06d79a-ede3-284c-df34-9702c835a382/screen696x696.jpeg'> <img height='300' alt='GitBucket image 3' src='http://a5.mzstatic.com/us/r30/Purple60/v4/24/11/37/2411374d-175b-7290-1f36-8190f4ee7740/screen696x696.jpeg'> <img height='300' alt='GitBucket image 4' src='http://a3.mzstatic.com/us/r30/Purple20/v4/cb/ab/b6/cbabb6b4-854f-9b86-ddaa-d9455dc272cc/screen696x696.jpeg'> <img height='300' alt='GitBucket image 5' src='http://a5.mzstatic.com/us/r30/Purple60/v4/a2/64/07/a2640705-ccef-163c-56e5-87a7874d9483/screen696x696.jpeg'> 
</div>
  </details>

- GitHawk: GitHub project manager [` App Store`](https://itunes.apple.com/app/githawk-for-github/id1252320249)  
  <details><summary><code>swift</code> <code>iglistkit</code> <code>snapkit</code> <code>alamofire</code> 🔥🔥🔥</summary>

  https://github.com/rnystrom/GitHawk<br>  Added July  5, 2017<br>  License: `other`
  <div><img height='300' alt='GitHawk image 1' src='http://i.imgur.com/XwW4MI2.png'> <img height='300' alt='GitHawk image 2' src='http://i.imgur.com/sFgTFJX.png'> 
</div>
  </details>

- GitHub-Swift  
  <details><summary><code>swift</code> </summary>

  https://github.com/acmacalister/Github-Swift<br>  Added May  3, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  </details>

- Gitify: Brings your GitHub notifications in your pocket [` App Store`](https://itunes.apple.com/app/gitify/id1123311036)  
  <details><summary><code>react-native</code> </summary>

  https://github.com/manosim/gitify-mobile<br>  Added July  8, 2017<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Gitify image 1' src='http://a1.mzstatic.com/us/r30/Purple18/v4/88/b6/8a/88b68a7f-d3d8-e51b-9918-cb886b7a4a24/screen696x696.jpeg'> 
</div>
  </details>

- GitPoint: GitHub app with a minimal & beautiful UI [` App Store`](https://itunes.apple.com/app/gitpoint/id1251245162)  
  <details><summary><code>react-native</code> 🔥🔥🔥🔥🔥</summary>

  https://github.com/gitpoint/git-point<br>  Added July 14, 2017<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='GitPoint image 1' src='http://a3.mzstatic.com/us/r30/Purple127/v4/6d/82/6b/6d826be2-2f68-495c-0ba1-86d3da548287/screen696x696.jpeg'> <img height='300' alt='GitPoint image 2' src='http://a4.mzstatic.com/us/r30/Purple117/v4/1c/14/83/1c148311-bbee-ff46-6b97-1d109a0213b4/screen696x696.jpeg'> 
</div>
  </details>

- Monkey: Browse top GitHub coders & repositories [` App Store`](https://itunes.apple.com/app/monkey-for-github/id1003765407)  
  <details><summary><code>objc</code> 🔥🔥🔥🔥</summary>

  https://github.com/coderyi/Monkey<br>  Added August 28, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Monkey image 1' src='http://a1.mzstatic.com/us/r30/Purple71/v4/77/4f/b6/774fb6df-5f9a-2218-0e53-5e9bd35e50e3/screen696x696.jpeg'> <img height='300' alt='Monkey image 2' src='http://a5.mzstatic.com/us/r30/Purple71/v4/3f/25/c4/3f25c4b0-2de6-42ae-d33a-dbfefc1f1378/screen696x696.jpeg'> <img height='300' alt='Monkey image 3' src='http://a2.mzstatic.com/us/r30/Purple22/v4/27/d0/fc/27d0fcb4-485b-d7d4-3bdb-472859cc7166/screen696x696.jpeg'> <img height='300' alt='Monkey image 4' src='http://a2.mzstatic.com/us/r30/Purple71/v4/88/a2/d0/88a2d013-04a5-732d-ae05-e477b0becf9e/screen696x696.jpeg'> <img height='300' alt='Monkey image 5' src='http://a4.mzstatic.com/us/r30/Purple62/v4/99/e9/49/99e9499e-ab0f-ed2b-b54d-70a819166c11/screen696x696.jpeg'> 
</div>
  </details>

- MrCode: GitHub app that can cache Markdown content  
  <details><summary><code>iphone</code> 🇨🇳 🔥🔥</summary>

  https://github.com/haolloyin/MrCode<br>  Added November  5, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='MrCode image 1' src='https://raw.githubusercontent.com/haolloyin/MrCode/master/Screenshots/screenshots_1.jpg'> 
</div>
  </details>

- OctoPodium: List users ranked by GitHub repository star count [` App Store`](https://itunes.apple.com/app/octopodium/id1077519133)  
  <details><summary><code>swift</code> 🔥</summary>

  https://github.com/nunogoncalves/iOS-OctoPodium<br>  Added February 18, 2016<br>  License: `other`
  <div><img height='300' alt='OctoPodium image 1' src='http://a2.mzstatic.com/us/r30/Purple60/v4/1b/54/e0/1b54e0e9-fc86-b8ea-01dd-f13c63507bad/screen696x696.jpeg'> <img height='300' alt='OctoPodium image 2' src='http://a5.mzstatic.com/us/r30/Purple30/v4/11/43/09/114309a8-6399-011d-ee34-3e2b59d01d6a/screen696x696.jpeg'> <img height='300' alt='OctoPodium image 3' src='http://a3.mzstatic.com/us/r30/Purple30/v4/c2/31/70/c2317036-b9ed-3d18-35b7-beb733f8e074/screen696x696.jpeg'> <img height='300' alt='OctoPodium image 4' src='http://a2.mzstatic.com/us/r30/Purple60/v4/d3/a1/84/d3a18462-d036-304a-72af-d283e51fed39/screen696x696.jpeg'> <img height='300' alt='OctoPodium image 5' src='http://a3.mzstatic.com/us/r30/Purple20/v4/58/03/34/5803343a-be95-66c7-27ea-ebb648ca3436/screen696x696.jpeg'> 
</div>
  </details>

- Pocket Trailer: Manage pull requests & issues for GitHub / GitHub Enterprise [` App Store`](https://itunes.apple.com/app/id806104975)  
  <details><summary><code>swift</code> 🔥🔥🔥</summary>

  https://github.com/ptsochantaris/trailer<br>  Added October  4, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Pocket Trailer image 1' src='http://a5.mzstatic.com/us/r30/Purple60/v4/9a/a4/9a/9aa49a25-e999-4f3d-e059-89025713cf69/screen696x696.jpeg'> <img height='300' alt='Pocket Trailer image 2' src='http://a5.mzstatic.com/us/r30/Purple20/v4/13/59/b0/1359b0e6-22c4-09ab-6212-e8190f8c3894/screen696x696.jpeg'> <img height='300' alt='Pocket Trailer image 3' src='http://a4.mzstatic.com/us/r30/Purple30/v4/a8/42/13/a8421320-3def-b527-0b12-10a418ce0088/screen696x696.jpeg'> <img height='300' alt='Pocket Trailer image 4' src='http://a1.mzstatic.com/us/r30/Purple18/v4/32/df/45/32df45e3-9e47-1d30-0596-e1888ae6cd3b/screen696x696.jpeg'> <img height='300' alt='Pocket Trailer image 5' src='http://a1.mzstatic.com/us/r30/Purple20/v4/ff/7a/f0/ff7af006-4f67-d158-bda2-c7f461686d73/screen696x696.jpeg'> 
</div>
  </details>

- RKGist: GitHub Gists  
  <details><summary><code>restkit</code> </summary>

  https://github.com/RestKit/RKGist<br>  Added April  9, 2015<br>  License: [`apache-2.0`](http://choosealicense.com/licenses/apache-2.0/)
  <div><img height='300' alt='RKGist image 1' src='https://i.imgur.com/3yKeZP7.png'> <img height='300' alt='RKGist image 2' src='https://i.imgur.com/cPwvXZa.png'> 
</div>
  </details>

- Siesta GitHub Browser: Browse & star GitHub repositories  
  <details><summary><code>swift</code> <code>rest</code> 🔥🔥🔥</summary>

  https://github.com/bustoutsolutions/siesta/tree/master/Examples/GithubBrowser<br>  Added July 26, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Siesta GitHub Browser image 1' src='https://i.imgur.com/OBGvFKw.png'> <img height='300' alt='Siesta GitHub Browser image 2' src='https://i.imgur.com/50eCbeX.png'> 
</div>
  </details>

- SwiftHub: View Swift repositories on GitHub  
  <details><summary><code>objc</code> </summary>

  https://github.com/sahandnayebaziz/StateView-Samples-SwiftHub<br>  Added May 15, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='SwiftHub image 1' src='https://i.imgur.com/NjqYq02.png'> 
</div>
  </details>


## Education 
 
[back to top](#readme) 
 
- iGrades: Track your class grades [` App Store`](https://itunes.apple.com/app/id816987574)  
  <details><summary><code>objc</code> </summary>

  https://github.com/maurovc/iGrades<br>  Added March 16, 2015<br>  License: `other`
  <div><img height='300' alt='iGrades image 1' src='http://a3.mzstatic.com/us/r30/Purple3/v4/8d/22/e0/8d22e0df-5cea-5fa5-c18e-779b335099ec/screen696x696.jpeg'> <img height='300' alt='iGrades image 2' src='http://a5.mzstatic.com/us/r30/Purple3/v4/8c/be/5f/8cbe5f3c-4a89-726b-eb30-037944e756be/screen696x696.jpeg'> <img height='300' alt='iGrades image 3' src='http://a3.mzstatic.com/us/r30/Purple5/v4/c8/77/fd/c877fd32-1c98-0268-5164-0cb95b48ce27/screen696x696.jpeg'> <img height='300' alt='iGrades image 4' src='http://a1.mzstatic.com/us/r30/Purple1/v4/ce/5f/28/ce5f2856-901f-d130-1173-9c4f869c9fc3/screen696x696.jpeg'> <img height='300' alt='iGrades image 5' src='http://a5.mzstatic.com/us/r30/Purple5/v4/2a/df/94/2adf9489-96da-4974-db83-5f119d58b11b/screen696x696.jpeg'> 
</div>
  </details>

- My First Memory: Memory game, includes introduction to iOS & Swift  
  <details><summary><code>swift</code> <code>instagram api</code> </summary>

  https://github.com/Sajjon/SwiftIntro<br>  Added July  6, 2016<br>  License: [`gpl-3.0`](http://choosealicense.com/licenses/gpl-3.0/)
  <div><img height='300' alt='My First Memory image 1' src='https://i.imgur.com/8u73w5u.png'> <img height='300' alt='My First Memory image 2' src='https://i.imgur.com/MShIfCe.png'> 
</div>
  </details>

- Population Clock: Learn about geography & demographics [` App Store`](https://itunes.apple.com/app/population-clock-hd/id590689957)  
  <details><summary><code>objc</code> </summary>

  https://github.com/Netfilter-Com/PopulationClock<br>  Added March  2, 2016<br>  License: `other`
  <div><img height='300' alt='Population Clock image 1' src='http://a2.mzstatic.com/us/r30/Purple2/v4/23/ff/89/23ff89c0-a1ac-f9aa-faae-1a2b9180d88a/screen520x924.jpeg'> 
</div>
  </details>

- Prayer in English: Help understand the spoken text in Islamic prayers [` App Store`](https://itunes.apple.com/app/prayer-in-english/id1217136884)  
  <details><summary><code>swift</code> </summary>

  https://github.com/Flinesoft/Prayer<br>  Added April  3, 2017<br>  License: [`gpl-3.0`](http://choosealicense.com/licenses/gpl-3.0/)
  <div><img height='300' alt='Prayer in English image 1' src='http://a2.mzstatic.com/us/r30/Purple122/v4/f0/3d/8e/f03d8e27-3e94-a07a-255c-2c56afdf9256/screen696x696.jpeg'> <img height='300' alt='Prayer in English image 2' src='http://a5.mzstatic.com/us/r30/Purple111/v4/fd/17/ca/fd17cab3-a3e2-165c-2b0e-d8ff8faeed13/screen696x696.jpeg'> <img height='300' alt='Prayer in English image 3' src='http://a1.mzstatic.com/us/r30/Purple111/v4/d1/d2/98/d1d29891-952b-88ad-e865-759ac918ec1f/screen696x696.jpeg'> 
</div>
  </details>

- WaniKani: Learn kanji with https://www.wanikani.com/ [` App Store`](https://itunes.apple.com/app/wanikani/id1034355141)  
  <details><summary><code>swift</code> </summary>

  https://github.com/haawa799/WaniKani-iOS<br>  Added May  3, 2016<br>  License: [`gpl-3.0`](http://choosealicense.com/licenses/gpl-3.0/)
  <div><img height='300' alt='WaniKani image 1' src='http://a3.mzstatic.com/us/r30/Purple49/v4/da/d8/8e/dad88eec-4269-1521-fb4e-78286ef6d949/screen696x696.jpeg'> <img height='300' alt='WaniKani image 2' src='http://a1.mzstatic.com/us/r30/Purple49/v4/e3/70/13/e37013b8-d618-1cfb-c84b-7a19bebabba6/screen696x696.jpeg'> <img height='300' alt='WaniKani image 3' src='http://a5.mzstatic.com/us/r30/Purple69/v4/63/55/69/63556904-f2dc-0c4a-8b7e-8feef7baf592/screen696x696.jpeg'> <img height='300' alt='WaniKani image 4' src='http://a1.mzstatic.com/us/r30/Purple49/v4/77/1d/b3/771db3a9-91d8-26fd-99fb-a86f61bc6b54/screen696x696.jpeg'> <img height='300' alt='WaniKani image 5' src='http://a2.mzstatic.com/us/r30/Purple49/v4/eb/ad/97/ebad97c8-c4d8-c0b3-0cde-c462f8a9441b/screen696x696.jpeg'> 
</div>
  </details>


## Emulator 
 
[back to top](#readme) 
 
- ActiveGS: Apple II/IIGS Emulator with in-app game browser, MFi & iCade controller support  
  <details><summary><code>objc</code> </summary>

  https://github.com/ogoguel/activegs-ios<br>  Added May 13, 2016<br>  License: `other`
  <div><img height='300' alt='ActiveGS image 1' src='https://raw.githubusercontent.com/ogoguel/activegs-ios/master/README.images/screen5.png'> 
</div>
  </details>

- DOSPad: DOSBox  
  <details><summary><code>objc</code> 🔥</summary>

  https://github.com/litchie/dospad<br>  Added May 13, 2016<br>  License: [`gpl-2.0`](http://choosealicense.com/licenses/gpl-2.0/)
  <div><img height='300' alt='DOSPad image 1' src='https://github.com/litchie/dospad/blob/master/screenshots/portrait.png?raw=true'> 
</div>
  </details>

- GBA4iOS: Gameboy, Gameboy Color & Gameboy Advance emulator  
  <details><summary><code>objc</code> </summary>

  https://bitbucket.org/rileytestut/gba4ios/<br>  Added November 21, 2015<br>  License: `other`
  <div><img height='300' alt='GBA4iOS image 1' src='http://www.wtfgamersonly.com/wp-content/uploads/2014/08/gba4ios.jpg'> 
</div>
  </details>

- iAmiga (iUAE): Commodore Amiga emulator, based on UAE  
  <details><summary><code>objc</code> </summary>

  https://github.com/emufreak/iAmiga<br>  Added May 14, 2016<br>  License: [`gpl-2.0`](http://choosealicense.com/licenses/gpl-2.0/)
  <div><img height='300' alt='iAmiga (iUAE) image 1' src='http://moreinfo.thebigboss.org/moreinfo/iuae1.jpg'> <img height='300' alt='iAmiga (iUAE) image 2' src='http://moreinfo.thebigboss.org/moreinfo/iuae4.jpg'> 
</div>
  </details>

- MAME4iOS: MAME frontend  
  <details><summary><code>objc</code> </summary>

  https://github.com/yoshisuga/MAME4iOS<br>  Added May 13, 2016<br>  License: [`gpl-2.0`](http://choosealicense.com/licenses/gpl-2.0/)
  <div><img height='300' alt='MAME4iOS image 1' src='https://i.ytimg.com/vi/Gj5LQN5iing/hqdefault.jpg'> 
</div>
  </details>

- Mini vMac: Early 68K Macintosh emulator  
  <details><summary><code>objc</code> 🔥</summary>

  https://github.com/zydeco/minivmac4ios<br>  https://namedfork.net/minivmac/<br>  Added July 11, 2016<br>  License: [`gpl-2.0`](http://choosealicense.com/licenses/gpl-2.0/)
  <div><img height='300' alt='Mini vMac image 1' src='https://namedfork.net/images/minivmac4ios/keyboard.png'> 
</div>
  </details>

- nds4ios: Nintendo DS emulator, port of DeSmuME  
  <details><summary><code>objc</code> 🔥</summary>

  https://github.com/raaxis/nds4ios<br>  Added May 14, 2016<br>  License: `other`
  <div><img height='300' alt='nds4ios image 1' src='http://cdn.redmondpie.com/wp-content/uploads/2015/11/ROM-List_.jpg'> 
</div>
  </details>

- PPSSPP: PSP emulator  
  <details><summary><code>c++</code> 🔥🔥🔥🔥🔥</summary>

  https://github.com/hrydgard/ppsspp<br>  Added May 13, 2016<br>  License: [`gpl-2.0`](http://choosealicense.com/licenses/gpl-2.0/)
  <div><img height='300' alt='PPSSPP image 1' src='http://www.ppsspp.org/img/screens/small/finalfantasycrisiscore.jpg'> <img height='300' alt='PPSSPP image 2' src='http://www.ppsspp.org/img/screens/small/burnoutdominator.jpg'> <img height='300' alt='PPSSPP image 3' src='http://www.ppsspp.org/img/screens/small/littlebigplanet.jpg'> 
</div>
  </details>

- Provenance: Emulators frontend for Sega Genesis, SNES, NES, GB/GBC & more  
  <details><summary><code>realm</code> 🔥🔥🔥🔥🔥</summary>

  https://github.com/jasarien/Provenance<br>  Added April 27, 2015<br>  License: [`bsd-3-clause`](http://choosealicense.com/licenses/bsd-3-clause/)
  <div><img height='300' alt='Provenance image 1' src='http://jamesaddyman.com/provenance/screenshots/provenance1.png'> <img height='300' alt='Provenance image 2' src='http://jamesaddyman.com/provenance/screenshots/provenance6.png'> 
</div>
  </details>

- RetroArch: The most comprehensive emulator frontend with support for systems such as NES, SNES, Gameboy, Sega Master System, Genesis, Playstation, N64, Atari Lynx & more  
  <details><summary><code>c</code> 🔥🔥🔥🔥🔥</summary>

  https://github.com/libretro/RetroArch<br>  Added May 13, 2016<br>  License: [`gpl-3.0`](http://choosealicense.com/licenses/gpl-3.0/)
  <div><img height='300' alt='RetroArch image 1' src='https://i.imgur.com/MUNX0Mq.jpg'> 
</div>
  </details>


## Event 
 
[back to top](#readme) 
 
- EventBlankApp: Template event / conference app  
  <details><summary><code>swift</code> <code>iphone</code> 🔥🔥</summary>

  https://github.com/icanzilb/EventBlankApp<br>  Added April 13, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='EventBlankApp image 1' src='https://i.imgur.com/FfNizrW.png'> 
</div>
  </details>

- F8 2016: Official F8 app  
  <details><summary><code>react native</code> 🔥🔥🔥🔥🔥</summary>

  https://github.com/fbsamples/f8app<br>  Added April 14, 2016<br>  License: `other`
  <div><img height='300' alt='F8 2016 image 1' src='https://github.com/fbsamples/f8app/raw/master/.github/screenshot-app@2x.png'> 
</div>
  </details>

- MeetupOrganizer: Extends the Meetup app's functionality  
  <details><summary><code>swift</code> <code>alamofire</code> <code>oauthswift</code> </summary>

  https://github.com/ayunav/MeetupOrganizer<br>  Added January 20, 2017<br>  License: `other`
  <div><img height='300' alt='MeetupOrganizer image 1' src='https://github.com/ayunav/MeetupOrganizer/blob/master/MeetupOrganizerAppDemo.gif'> 
</div>
  </details>

- Nortal TechDay 2015  
  <details><summary><code>react native</code> 🔥🔥</summary>

  https://github.com/mikkoj/NortalTechDay<br>  Added May  3, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Nortal TechDay 2015 image 1' src='http://res.cloudinary.com/mikkoj/image/upload/v1467119333/nortal-techday-1.mov_triupn.gif'> <img height='300' alt='Nortal TechDay 2015 image 2' src='http://res.cloudinary.com/mikkoj/image/upload/v1467119489/nortal-techday-2.mov_lcvqqx.gif'> 
</div>
  </details>

- Northern California Cherry Blossom Festival [` App Store`](https://itunes.apple.com/app/northern-california-cherry-blossom-festival/id981016442)  
  <details><summary><code>swift</code> </summary>

  https://github.com/keitaito/NCCBF-iOS<br>  https://sfcherryblossom.org/<br>  Added May  4, 2017<br>  License: `other`
  <div><img height='300' alt='Northern California Cherry Blossom Festival image 1' src='http://a5.mzstatic.com/us/r30/Purple122/v4/85/60/0d/85600dea-3b85-bb34-07c0-a66db27d11e3/screen696x696.jpeg'> <img height='300' alt='Northern California Cherry Blossom Festival image 2' src='http://a5.mzstatic.com/us/r30/Purple111/v4/5d/00/d6/5d00d698-9537-6216-575f-b9dd327d3219/screen696x696.jpeg'> <img height='300' alt='Northern California Cherry Blossom Festival image 3' src='http://a3.mzstatic.com/us/r30/Purple111/v4/e5/97/e2/e597e2e9-2d30-f341-72b9-fe1a1227b8c4/screen696x696.jpeg'> 
</div>
  </details>

- Parties for WWDC  
  <details><summary><code>cloudkit</code> 🔥🔥</summary>

  https://github.com/genadyo/WWDC<br>  Added January 26, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Parties for WWDC image 1' src='http://a3.mzstatic.com/us/r30/Purple20/v4/5f/9e/6a/5f9e6a9a-db21-1e8a-c45a-aef6ba65956b/screen696x696.jpeg'> <img height='300' alt='Parties for WWDC image 2' src='http://a3.mzstatic.com/us/r30/Purple30/v4/7e/6f/12/7e6f12a7-8d4b-0416-4d7a-f4745a2d7538/screen696x696.jpeg'> <img height='300' alt='Parties for WWDC image 3' src='http://a3.mzstatic.com/us/r30/Purple60/v4/4c/0f/cf/4c0fcf21-8713-0d61-c0df-0dafdbe525e8/screen696x696.jpeg'> <img height='300' alt='Parties for WWDC image 4' src='http://a5.mzstatic.com/us/r30/Purple30/v4/c0/21/e4/c021e48b-fa87-a873-1c8b-95e58aba71e7/screen696x696.jpeg'> <img height='300' alt='Parties for WWDC image 5' src='http://a3.mzstatic.com/us/r30/Purple18/v4/e0/69/9c/e0699c09-6cb4-c1a5-4fa1-9cd7117eaa86/screen696x696.jpeg'> 
</div>
  </details>

- RWDevCon [` App Store`](https://itunes.apple.com/app/rwdevcon-tutorial-conference/id958625272)  
  <details><summary><code>swift</code> </summary>

  https://github.com/raywenderlich/RWDevCon-App<br>  Added March 13, 2016<br>  License: `other`
  <div><img height='300' alt='RWDevCon image 1' src='http://a5.mzstatic.com/us/r30/Purple49/v4/6b/d2/d0/6bd2d030-51a6-c61f-4529-ab7993fb8f11/screen696x696.jpeg'> <img height='300' alt='RWDevCon image 2' src='http://a1.mzstatic.com/us/r30/Purple49/v4/7a/80/6b/7a806b7a-d456-7f45-7ccf-dcca3ef0e834/screen696x696.jpeg'> <img height='300' alt='RWDevCon image 3' src='http://a1.mzstatic.com/us/r30/Purple49/v4/a3/58/9a/a3589ae2-9a46-8310-d6d3-85847005cfd8/screen696x696.jpeg'> <img height='300' alt='RWDevCon image 4' src='http://a2.mzstatic.com/us/r30/Purple49/v4/76/4a/fa/764afab7-1f22-d358-169b-6f7e16db0420/screen696x696.jpeg'> <img height='300' alt='RWDevCon image 5' src='http://a5.mzstatic.com/us/r30/Purple49/v4/18/67/8d/18678d85-125a-8686-4b6f-8b6661b56a96/screen696x696.jpeg'> 
</div>
  </details>

- TechTavta: Keep track of all events for Techtatva 2015 [` App Store`](https://itunes.apple.com/app/techtatva15/id922178880)  
  <details><summary><code>objc</code> </summary>

  https://github.com/LUGM/TechTatva-15<br>  Added April 19, 2016<br>  License: `other`
  <div><img height='300' alt='TechTavta image 1' src='http://a3.mzstatic.com/us/r30/Purple3/v4/b8/c5/a4/b8c5a466-4466-404a-0c8d-2b82d4b633f3/screen696x696.jpeg'> <img height='300' alt='TechTavta image 2' src='http://a3.mzstatic.com/us/r30/Purple3/v4/79/d7/52/79d7520a-4d52-c801-0c6d-9f2a35644608/screen696x696.jpeg'> <img height='300' alt='TechTavta image 3' src='http://a3.mzstatic.com/us/r30/Purple3/v4/2b/6b/5d/2b6b5d04-aa10-6532-05ef-d189d5d28626/screen696x696.jpeg'> <img height='300' alt='TechTavta image 4' src='http://a4.mzstatic.com/us/r30/Purple3/v4/43/be/fd/43befdba-e3f2-d0d4-9d0b-8acacf57b8c2/screen696x696.jpeg'> <img height='300' alt='TechTavta image 5' src='http://a4.mzstatic.com/us/r30/Purple62/v4/e4/6b/03/e46b0382-cd97-607e-de99-2800694d927f/screen696x696.jpeg'> 
</div>
  </details>

- try! Swift  
  <details><summary><code>swift</code> 🔥🔥</summary>

  https://github.com/tryswift/trySwiftApp<br>  Added February 16, 2016<br>  License: `other`
  <div><img height='300' alt='try! Swift image 1' src='http://a2.mzstatic.com/us/r30/Purple49/v4/18/81/9f/18819f2d-1bb8-feeb-bb22-89bbe85d6516/screen696x696.jpeg'> 
</div>
  </details>

- try! Swift NYC  
  <details><summary><code>swift</code> <code>toucan</code> <code>realm</code> 🔥</summary>

  https://github.com/tryswift/trySwiftNYC<br>  Added November  8, 2016<br>  License: `other`
  <div><img height='300' alt='try! Swift NYC image 1' src='https://i.imgur.com/xyu7t89.png'> <img height='300' alt='try! Swift NYC image 2' src='https://i.imgur.com/Jes7vLF.png'> 
</div>
  </details>

- try! Swift Tokyo  
  <details><summary><code>swift</code> <code>timepiece</code> <code>realm</code> <code>kingfisher</code> <code>acknowlist</code> 🔥</summary>

  https://github.com/tryswift/trySwiftAppFinal<br>  Added February 22, 2017<br>  License: `other`
  <div><img height='300' alt='try! Swift Tokyo image 1' src='https://cloud.githubusercontent.com/assets/4190298/23140345/534ae20c-f7b1-11e6-8584-b65aded1f59e.png'> <img height='300' alt='try! Swift Tokyo image 2' src='https://cloud.githubusercontent.com/assets/4190298/23140344/53463e82-f7b1-11e6-8d84-c0cedcc930b1.png'> 
</div>
  </details>


## Extension 
 
[back to top](#readme) 
 
- Celluloid Photo Editing extension [` App Store`](https://itunes.apple.com/app/celluloid/id1124966798)  
  <details><summary><code>swift</code> <code>snapkit</code> 🇨🇳 🔥🔥🔥</summary>

  https://github.com/100mango/Celluloid<br>  Added July 24, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Celluloid Photo Editing extension image 1' src='http://a3.mzstatic.com/us/r30/Purple60/v4/81/ee/c1/81eec17b-96c0-6b5c-de9b-da1515ffc3f9/screen696x696.jpeg'> 
</div>
  </details>

- Post Manager: Post/schedule Twitter posts like Buffer, includes a Share Extension  
  <details><summary><code>swift</code> <code>node</code> </summary>

  https://github.com/TomekB/PostManager<br>  Added July 15, 2016<br>  License: `other`
  <div><img height='300' alt='Post Manager image 1' src='https://github.com/TomekB/PostManager/raw/master/IMG/Simulator%20Screen%20Shot%2015%20Jul%202016%2007.52.18.png?raw=true'> <img height='300' alt='Post Manager image 2' src='https://github.com/TomekB/PostManager/raw/master/IMG/Simulator%20Screen%20Shot%2015%20Jul%202016%2007.52.54.png?raw=true'> <img height='300' alt='Post Manager image 3' src='https://github.com/TomekB/PostManager/raw/master/IMG/Simulator%20Screen%20Shot%2015%20Jul%202016%2007.54.47.png?raw=true'> 
</div>
  </details>

- Send To Me: Share content to your email with a single tap  
  <details><summary><code>swift</code> </summary>

  https://github.com/PiXeL16/SendToMe<br>  Added July 11, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Send To Me image 1' src='http://a4.mzstatic.com/us/r30/Purple49/v4/8a/a1/9d/8aa19d98-cde0-1260-9391-8cc9d27019f6/screen696x696.jpeg'> <img height='300' alt='Send To Me image 2' src='http://a3.mzstatic.com/us/r30/Purple49/v4/55/17/3e/55173edb-4240-952f-6a4c-a7d39b8db7b7/screen696x696.jpeg'> <img height='300' alt='Send To Me image 3' src='http://a1.mzstatic.com/us/r30/Purple49/v4/51/2a/79/512a7981-d796-8dae-ac21-68a8b02ea85f/screen696x696.jpeg'> <img height='300' alt='Send To Me image 4' src='http://a2.mzstatic.com/us/r30/Purple49/v4/30/e5/2f/30e52ff8-8f01-870e-fb16-b5a6d16e9ad3/screen696x696.jpeg'> 
</div>
  </details>


### Content Blocking 
 
[back to top](#readme) 
 
- Adblock Fast [` App Store`](https://itunes.apple.com/app/adblock-fast/id1032930802)  
  <details><summary><code>objc</code> 🔥🔥</summary>

  https://github.com/rocketshipapps/adblockfast<br>  Added September 25, 2015<br>  License: [`gpl-3.0`](http://choosealicense.com/licenses/gpl-3.0/)
  <div><img height='300' alt='Adblock Fast image 1' src='http://a5.mzstatic.com/us/r30/Purple71/v4/95/67/fb/9567fb02-2fe7-f4b1-ffd6-aa4892a82c65/screen696x696.jpeg'> <img height='300' alt='Adblock Fast image 2' src='http://a1.mzstatic.com/us/r30/Purple62/v4/d8/d0/99/d8d0998b-4b1d-87bb-82d3-174e89d3c14d/screen696x696.jpeg'> <img height='300' alt='Adblock Fast image 3' src='http://a1.mzstatic.com/us/r30/Purple71/v4/38/a8/18/38a818c9-7579-a57c-fe5b-506c4f0beff8/screen696x696.jpeg'> 
</div>
  </details>

- Adblock Plus [` App Store`](https://itunes.apple.com/app/adblock-plus-abp/id1028871868)  
  <details><summary><code>objc</code> </summary>

  https://github.com/adblockplus/adblockplussafariios<br>  Added December 14, 2015<br>  License: [`gpl-3.0`](http://choosealicense.com/licenses/gpl-3.0/)
  <div><img height='300' alt='Adblock Plus image 1' src='http://a4.mzstatic.com/us/r30/Purple69/v4/dd/f6/8d/ddf68dbd-400f-91c1-75a0-ba0140db96ae/screen696x696.jpeg'> <img height='300' alt='Adblock Plus image 2' src='http://a3.mzstatic.com/us/r30/Purple20/v4/4b/80/3f/4b803f04-4a47-c851-8d80-03db7a35ac20/screen696x696.jpeg'> <img height='300' alt='Adblock Plus image 3' src='http://a2.mzstatic.com/us/r30/Purple3/v4/77/77/85/7777857c-fe75-6919-69cb-52d1af3b8422/screen696x696.jpeg'> <img height='300' alt='Adblock Plus image 4' src='http://a3.mzstatic.com/us/r30/Purple3/v4/d7/4d/fd/d74dfd93-8898-b4a6-8ac4-aa5c2d3436e6/screen696x696.jpeg'> <img height='300' alt='Adblock Plus image 5' src='http://a3.mzstatic.com/us/r30/Purple3/v4/1e/74/81/1e748193-bd49-1837-3bab-3a8f80fa516b/screen696x696.jpeg'> 
</div>
  </details>

- BlockParty  
  <details><summary><code>objc</code> 🔥🔥🔥</summary>

  https://github.com/krishkumar/BlockParty<br>  Added June 29, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='BlockParty image 1' src='https://github.com/krishkumar/BlockParty/raw/master/Screenshot01.png'> <img height='300' alt='BlockParty image 2' src='https://github.com/krishkumar/BlockParty/raw/master/Screenshot02.png'> 
</div>
  </details>

- Firefox Focus: Browse the web privately [` App Store`](https://itunes.apple.com/app/id1055677337)  
  <details><summary><code>swift</code> 🔥🔥🔥</summary>

  https://github.com/mozilla-mobile/focus-ios<br>  Added December  8, 2015<br>  License: [`mpl-2.0`](http://choosealicense.com/licenses/mpl-2.0/)
  <div><img height='300' alt='Firefox Focus image 1' src='http://a2.mzstatic.com/us/r30/Purple71/v4/32/81/20/328120a1-29c2-4dd8-fec8-8024eb5bb5ee/screen696x696.jpeg'> 
</div>
  </details>

- Swab: Ad blocker for creative, web & design ads [` App Store`](https://itunes.apple.com/app/swab-content-blocker-creative/id1042086002)  
  <details><summary><code>swift</code> </summary>

  https://github.com/pkamb/swab<br>  http://swabthe.com/<br>  Added July 12, 2016<br>  License: [`bsd-3-clause`](http://choosealicense.com/licenses/bsd-3-clause/)
  <div><img height='300' alt='Swab image 1' src='http://a3.mzstatic.com/us/r30/Purple3/v4/be/ea/39/beea3978-efb6-07ef-aefb-3d01e09531d9/screen696x696.jpeg'> 
</div>
  </details>


### Today 
 
[back to top](#readme) 
 
- Bus Today: Track bus line on your wrist, includes Today Extension [` App Store`](https://itunes.apple.com/app/jin-ri-gong-jiao-tong-zhi/id975022341)  
  <details><summary><code>objc</code> 🇨🇳 </summary>

  https://github.com/JohnWong/bus-today<br>  Added February 17, 2016<br>  License: `other`
  <div><img height='300' alt='Bus Today image 1' src='http://a4.mzstatic.com/us/r30/Purple69/v4/94/5e/05/945e0506-9e18-749a-1ed9-e018949bfbad/screen696x696.jpeg'> <img height='300' alt='Bus Today image 2' src='http://a1.mzstatic.com/us/r30/Purple69/v4/8f/6c/74/8f6c7422-fdc8-89e4-3514-0ea044e7fd50/screen696x696.jpeg'> <img height='300' alt='Bus Today image 3' src='http://a4.mzstatic.com/us/r30/Purple69/v4/39/03/e1/3903e1cf-d614-5d26-e3b1-3f9180aa162e/screen696x696.jpeg'> <img height='300' alt='Bus Today image 4' src='http://a5.mzstatic.com/us/r30/Purple69/v4/7b/9a/d2/7b9ad2f6-0438-c850-f8e0-268b712873a0/screen696x696.jpeg'> <img height='300' alt='Bus Today image 5' src='http://a2.mzstatic.com/us/r30/Purple69/v4/ce/6f/fc/ce6ffc7a-7f95-0c08-f05b-77f15612d0c7/screen696x696.jpeg'> 
</div>
  </details>

- Contributions for GitHub: Look at your GitHub contributions graph in a Today Extension [` App Store`](https://itunes.apple.com/app/contributions-for-github/id1153432612)  
  <details><summary><code>objc</code> 🔥🔥</summary>

  https://github.com/JustinFincher/GitHubContributionsiOS<br>  Added October  6, 2016<br>  License: `other`
  <div><img height='300' alt='Contributions for GitHub image 1' src='https://github.com/JustinFincher/GitHubContributionsiOS/raw/master/Sketch/GitHub-Contributions.jpg'> 
</div>
  </details>

- Fojusi: Work timer with Today Extension [` App Store`](https://itunes.apple.com/app/fojusi/id923044693)  
  <details><summary><code>swift</code> 🔥🔥</summary>

  https://github.com/dasdom/Tomate<br>  Added June 21, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Fojusi image 1' src='http://a4.mzstatic.com/us/r30/Purple32/v4/cd/ac/98/cdac9892-c5e1-9389-6efe-ef31a90daaf4/screen696x696.jpeg'> <img height='300' alt='Fojusi image 2' src='http://a5.mzstatic.com/us/r30/Purple6/v4/6c/c1/1b/6cc11bb2-5f1e-693c-f05c-313034b0194a/screen696x696.jpeg'> <img height='300' alt='Fojusi image 3' src='http://a4.mzstatic.com/us/r30/Purple3/v4/05/67/17/05671722-b9e9-0698-7725-59ff117e377d/screen696x696.jpeg'> <img height='300' alt='Fojusi image 4' src='http://a4.mzstatic.com/us/r30/Purple3/v4/8c/2c/a0/8c2ca0be-628e-4daa-0911-bdf0b58318e1/screen696x696.jpeg'> 
</div>
  </details>

- LunarCore: Small lunar calendar with Today Extension [` App Store`](https://itunes.apple.com/app/id1031088612)  
  <details><summary><code>objc</code> 🇨🇳 🔥🔥🔥</summary>

  https://github.com/cyanzhong/LunarCore<br>  Added October 31, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='LunarCore image 1' src='https://github.com/cyanzhong/LunarCore/raw/master/iOS.png'> 
</div>
  </details>

- OpenIt: Launch other apps  
  <details><summary>🔥</summary>

  https://github.com/BalestraPatrick/OpenIt<br>  Added June  7, 2016<br>  License: `other`
  <div><img height='300' alt='OpenIt image 1' src='https://github.com/BalestraPatrick/OpenIt/raw/master/OpenItDemo.gif'> 
</div>
  </details>

- TodayMind: Manage Reminders directly in a Today Extension [` App Store`](https://itunes.apple.com/app/id1207158665)  
  <details><summary><code>swift</code> 🇨🇳 🔥🔥🔥</summary>

  https://github.com/cyanzhong/TodayMind<br>  Added February 28, 2017<br>  License: [`gpl-3.0`](http://choosealicense.com/licenses/gpl-3.0/)
  <div><img height='300' alt='TodayMind image 1' src='http://a1.mzstatic.com/us/r30/Purple122/v4/09/1e/87/091e87a0-cf27-3546-b8ab-f18e300f028e/screen696x696.jpeg'> <img height='300' alt='TodayMind image 2' src='http://a1.mzstatic.com/us/r30/Purple111/v4/ca/1d/37/ca1d3780-fb6f-e350-43fa-cae7997598a4/screen696x696.jpeg'> <img height='300' alt='TodayMind image 3' src='http://a1.mzstatic.com/us/r30/Purple111/v4/da/ce/55/dace5554-786a-71c5-e943-ee413d64ec71/screen696x696.jpeg'> <img height='300' alt='TodayMind image 4' src='http://a2.mzstatic.com/us/r30/Purple122/v4/7b/84/c8/7b84c8b5-1304-ea84-1dc7-92c5a3867034/screen696x696.jpeg'> <img height='300' alt='TodayMind image 5' src='http://a1.mzstatic.com/us/r30/Purple111/v4/65/89/cc/6589cce3-df56-7e9a-7f7b-23945bd1724a/screen696x696.jpeg'> 
</div>
  </details>

- TodayStocks: Show portfolio in a minimalist Today Extension  
  <details><summary><code>objc</code> </summary>

  https://github.com/premnirmal/TodayStocks<br>  Added June 29, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='TodayStocks image 1' src='http://a4.mzstatic.com/us/r30/Purple1/v4/81/de/d6/81ded63c-8a48-dff9-062f-92ac2c5299ee/screen696x696.jpeg'> <img height='300' alt='TodayStocks image 2' src='http://a4.mzstatic.com/us/r30/Purple5/v4/d2/ca/dd/d2cadd24-5d85-f613-aba2-9931cb785b65/screen696x696.jpeg'> <img height='300' alt='TodayStocks image 3' src='http://a1.mzstatic.com/us/r30/Purple1/v4/82/5a/ff/825affaf-cc4a-6d24-99e0-f3197f769f58/screen696x696.jpeg'> <img height='300' alt='TodayStocks image 4' src='http://a2.mzstatic.com/us/r30/Purple7/v4/6e/03/d6/6e03d609-2cb7-4095-cc24-a63b1c8e8d12/screen696x696.jpeg'> 
</div>
  </details>

- VPN On: Extension to turn on VPN [` App Store`](https://itunes.apple.com/app/vpn-on/id951344279)  
  <details><summary><code>swift</code> 🔥🔥🔥🔥🔥</summary>

  https://github.com/lexrus/VPNOn<br>  Added March 16, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='VPN On image 1' src='https://cdn-images-1.medium.com/max/800/1*9qSbd77zijp5UPODaWM9CQ.png'> 
</div>
  </details>


## Finance 
 
[back to top](#readme) 
 
- Argent: Payments app  
  <details><summary><code>swift</code> </summary>

  https://github.com/argent-os/argent-ios<br>  Added July 21, 2017<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Argent image 1' src='https://raw.githubusercontent.com/argent-os/argent-ios/master/demo.png'> 
</div>
  </details>

- BoardBank: Money manager for board games [` App Store`](https://itunes.apple.com/app/boardbank-money-manager-for/id1191367526)  
  <details><summary><code>swift</code> 🔥</summary>

  https://github.com/richardxyx/BoardBank<br>  https://www.richardneitzke.com<br>  Added March 20, 2017<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='BoardBank image 1' src='https://i.imgur.com/fXB42iY.png'> <img height='300' alt='BoardBank image 2' src='https://i.imgur.com/EMGOw0g.png'> 
</div>
  </details>

- Buck Tracker: Expense tracker  
  <details><summary><code>swift</code> </summary>

  https://github.com/hkalexling/Buck_Tracker<br>  Added November 16, 2015<br>  License: `other`
  <div>
</div>
  </details>

- doughwallet: Dogecoin wallet [` App Store`](https://itunes.apple.com/app/doughwallet/id951731776)  
  <details><summary><code>objc</code> </summary>

  https://github.com/peritus/doughwallet<br>  Added July  9, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='doughwallet image 1' src='http://a3.mzstatic.com/us/r30/Purple1/v4/f7/97/46/f7974641-835a-3c11-fa55-0d08f429308c/screen696x696.jpeg'> <img height='300' alt='doughwallet image 2' src='http://a1.mzstatic.com/us/r30/Purple3/v4/ba/3d/89/ba3d89f9-98e5-2844-3de3-b4fd23b3fab0/screen696x696.jpeg'> <img height='300' alt='doughwallet image 3' src='http://a1.mzstatic.com/us/r30/Purple5/v4/8d/20/50/8d2050d0-751a-17fa-1e25-a77abaa68de8/screen696x696.jpeg'> <img height='300' alt='doughwallet image 4' src='http://a5.mzstatic.com/us/r30/Purple1/v4/a5/35/20/a53520fa-de31-3635-f319-c08956a5951c/screen696x696.jpeg'> <img height='300' alt='doughwallet image 5' src='http://a1.mzstatic.com/us/r30/Purple3/v4/ca/4f/9e/ca4f9e88-4e1e-e87e-42a0-26bfa586d8b3/screen696x696.jpeg'> 
</div>
  </details>

- EconoApp: Keep track of economic information [` App Store`](https://itunes.apple.com/app/econoapp/id1252140352)  
  <details><summary><code>swift</code> </summary>

  https://github.com/viniciusvieir/EconoApp<br>  Added June 26, 2017
  <div><img height='300' alt='EconoApp image 1' src='https://raw.githubusercontent.com/viniciusvieir/EconoApp/1da96afc7317c1096a6c9a45c7a06f9d72f431fb/Screenshot%20EN%201.jpg'> <img height='300' alt='EconoApp image 2' src='https://raw.githubusercontent.com/viniciusvieir/EconoApp/3520001bbbc88e6e2f15d6fc0ca7e6bcb0819364/Screenshot%20EN%202.jpg'> <img height='300' alt='EconoApp image 3' src='https://raw.githubusercontent.com/viniciusvieir/EconoApp/2afa3886d92de25f87a272f18fd5725f875ed108/Screenshot%20EN%203.jpg'> 
</div>
  </details>

- EMI Calculator: Calculate your Equated Monthly installment (EMI) for home, car & personal loans [` App Store`](https://itunes.apple.com/app/id1105890730)  
  <details><summary><code>swift</code> <code>viper</code> </summary>

  https://github.com/tirupati17/loan-emi-calculator-clean-swift<br>  Added July  3, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='EMI Calculator image 1' src='http://a2.mzstatic.com/us/r30/Purple20/v4/20/94/8a/20948a2b-3d8d-e65b-2831-a582d912ed13/screen696x696.jpeg'> <img height='300' alt='EMI Calculator image 2' src='http://a3.mzstatic.com/us/r30/Purple49/v4/aa/6a/2f/aa6a2f8a-d067-725a-e1f4-83caeaac8e75/screen696x696.jpeg'> <img height='300' alt='EMI Calculator image 3' src='http://a3.mzstatic.com/us/r30/Purple30/v4/e6/87/fb/e687fb83-cd3d-6b40-2d3b-94f6fd1e82a5/screen696x696.jpeg'> 
</div>
  </details>

- Encryptr: A zero-knowledge, cloud-based e-wallet & password manager [` App Store`](https://itunes.apple.com/app/id1066041348)  
  <details><summary><code>cordova</code> <code>grunt</code> <code>node</code> 🔥🔥🔥🔥</summary>

  https://github.com/SpiderOak/Encryptr<br>  https://spideroak.com/encryptr/<br>  Added June  2, 2016<br>  License: [`gpl-3.0`](http://choosealicense.com/licenses/gpl-3.0/)
  <div><img height='300' alt='Encryptr image 1' src='http://a1.mzstatic.com/us/r30/Purple49/v4/cc/ab/0f/ccab0fca-197f-56c0-c265-4b73c99e4ef8/screen696x696.jpeg'> 
</div>
  </details>

- Exchanger: Exchange currencies from multiply wallets on ECB exchange rates  
  <details><summary><code>viper</code> <code>objc</code> <code>core-data</code> </summary>

  https://github.com/vkaltyrin/exchanger<br>  Added December 21, 2017<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Exchanger image 1' src='https://github.com/vkaltyrin/exchanger/blob/master/screenshot.png?raw=true'> 
</div>
  </details>

- Neverlate: Pay-if-U-R-late app with geofences  
  <details><summary><code>venmo api</code> </summary>

  https://github.com/ayunav/Neverlate<br>  Added May 27, 2016<br>  License: `other`
  <div><img height='300' alt='Neverlate image 1' src='https://github.com/ayunav/Neverlate/raw/master/NeverlateDemo.gif'> 
</div>
  </details>

- Savings Assistant: Expense tracker [` App Store`](https://itunes.apple.com/app/savings-assistant/id1022760996)  
  <details><summary><code>swift</code> </summary>

  https://github.com/chrisamanse/savings-assistant<br>  Added September  5, 2015<br>  License: [`gpl-2.0`](http://choosealicense.com/licenses/gpl-2.0/)
  <div><img height='300' alt='Savings Assistant image 1' src='http://a5.mzstatic.com/us/r30/Purple69/v4/74/bb/6d/74bb6dc2-2177-fe4b-17d3-2caa07a9cd59/screen696x696.jpeg'> <img height='300' alt='Savings Assistant image 2' src='http://a1.mzstatic.com/us/r30/Purple49/v4/72/08/f6/7208f671-6648-9cb6-8ae2-2cfcbaaacaf5/screen696x696.jpeg'> <img height='300' alt='Savings Assistant image 3' src='http://a3.mzstatic.com/us/r30/Purple7/v4/94/bf/a9/94bfa97b-3d91-2c54-1df7-bc738949a73d/screen696x696.jpeg'> <img height='300' alt='Savings Assistant image 4' src='http://a1.mzstatic.com/us/r30/Purple18/v4/7b/ef/6f/7bef6f61-5ea6-9525-b4ee-77948bc7d3ab/screen696x696.jpeg'> <img height='300' alt='Savings Assistant image 5' src='http://a2.mzstatic.com/us/r30/Purple7/v4/ef/12/d6/ef12d62a-80f1-b719-8d2b-b51e69317b7f/screen696x696.jpeg'> 
</div>
  </details>

- SIP Calculator: Calculate the future value of SIP (Systematic Investment Plan) payments [` App Store`](https://itunes.apple.com/app/id1092822415)  
  <details><summary><code>swift</code> </summary>

  https://github.com/tirupati17/sip-calculator-swift<br>  Added July 17, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='SIP Calculator image 1' src='http://a5.mzstatic.com/us/r30/Purple69/v4/dc/cc/2c/dccc2c04-f147-30b4-0a9e-9bff2a857476/screen696x696.jpeg'> 
</div>
  </details>

- Stocks-iOS: A simple finance app showing price information, historical prices and news.  
  <details><summary><code>finance</code> <code>objective-c</code> </summary>

  https://github.com/MauriceArikoglu/stocks-ios<br>  Added February  3, 2018<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Stocks-iOS image 1' src='https://raw.githubusercontent.com/MauriceArikoglu/stocks-ios/master/Stocks/Screenshot.png'> 
</div>
  </details>

- Tip Calculator: Calculate tip & split the bill between any number of people [` App Store`](https://itunes.apple.com/app/id1139456857)  
  <details><summary><code>viper</code> </summary>

  https://github.com/tirupati17/tip-calculator-auto-layout-viper-objective-c<br>  Added August  8, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Tip Calculator image 1' src='https://raw.githubusercontent.com/tirupati17/tip-calculator-auto-layout-viper-objective-c/master/TipCalculator/Resources/Images/iphone_5s.png'> 
</div>
  </details>

- TodayStocks: Show portfolio in a minimalist Today Extension  
  <details><summary><code>objc</code> </summary>

  https://github.com/premnirmal/TodayStocks<br>  Added June 29, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='TodayStocks image 1' src='http://a4.mzstatic.com/us/r30/Purple1/v4/81/de/d6/81ded63c-8a48-dff9-062f-92ac2c5299ee/screen696x696.jpeg'> <img height='300' alt='TodayStocks image 2' src='http://a4.mzstatic.com/us/r30/Purple5/v4/d2/ca/dd/d2cadd24-5d85-f613-aba2-9931cb785b65/screen696x696.jpeg'> <img height='300' alt='TodayStocks image 3' src='http://a1.mzstatic.com/us/r30/Purple1/v4/82/5a/ff/825affaf-cc4a-6d24-99e0-f3197f769f58/screen696x696.jpeg'> <img height='300' alt='TodayStocks image 4' src='http://a2.mzstatic.com/us/r30/Purple7/v4/6e/03/d6/6e03d609-2cb7-4095-cc24-a63b1c8e8d12/screen696x696.jpeg'> 
</div>
  </details>

- Toshi: Private & secure messaging, Ethereum wallet and browser  
  <details><summary><code>swift</code> </summary>

  https://github.com/toshiapp/toshi-ios-client<br>  Added April 21, 2017<br>  License: [`gpl-3.0`](http://choosealicense.com/licenses/gpl-3.0/)
  <div><img height='300' alt='Toshi image 1' src='http://a1.mzstatic.com/us/r30/Purple122/v4/45/e5/da/45e5daf2-6dd5-ae2c-da9f-35f60f9cdaca/screen696x696.jpeg'> 
</div>
  </details>

- ToThePenny: Budget tracker  
  <details><summary><code>objc</code> </summary>

  https://github.com/vanyaland/ToThePenny<br>  Added April 27, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='ToThePenny image 1' src='http://a3.mzstatic.com/us/r30/Purple7/v4/a3/8e/6d/a38e6df9-b9bb-cb89-bca3-bad9b682fb05/screen696x696.jpeg'> <img height='300' alt='ToThePenny image 2' src='http://a4.mzstatic.com/us/r30/Purple5/v4/18/5b/b1/185bb117-bb3e-fa8b-58cf-c60e73af51b9/screen696x696.jpeg'> <img height='300' alt='ToThePenny image 3' src='http://a3.mzstatic.com/us/r30/Purple1/v4/db/70/8f/db708fd7-b3be-fd6b-a7aa-0f4f6af4ba25/screen696x696.jpeg'> <img height='300' alt='ToThePenny image 4' src='http://a2.mzstatic.com/us/r30/Purple7/v4/ce/8c/3f/ce8c3f07-99fa-bc94-7223-32620cc7dbd4/screen696x696.jpeg'> <img height='300' alt='ToThePenny image 5' src='http://a3.mzstatic.com/us/r30/Purple7/v4/5a/37/35/5a37355a-d2bb-49ba-e6b9-abe7a4b518ee/screen696x696.jpeg'> 
</div>
  </details>


### Bitcoin 
 
[back to top](#readme) 
 
- Bither: Simple & secure Bitcoin wallet  
  <details><summary><code>objc</code> 🔥</summary>

  https://github.com/bither/bither-ios<br>  Added April  3, 2015<br>  License: [`apache-2.0`](http://choosealicense.com/licenses/apache-2.0/)
  <div><img height='300' alt='Bither image 1' src='http://a1.mzstatic.com/us/r30/Purple7/v4/f9/f8/d4/f9f8d401-2a9a-fb50-fe24-76a1158600b2/screen696x696.jpeg'> 
</div>
  </details>

- BitPrice - Bitcoin Rate: Display and monitor the current Bitcoint rate. [` App Store`](https://itunes.apple.com/app/id1343270451)  
  <details><summary><code>swift</code> </summary>

  https://github.com/Bruno-Furtado/bitprice-ios<br>  Added February  6, 2018<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='BitPrice - Bitcoin Rate image 1' src='https://is5-ssl.mzstatic.com/image/thumb/Purple118/v4/07/30/e3/0730e3d1-dd14-e27f-b982-734f3f8dda6d/source/230x0w.jpg'> <img height='300' alt='BitPrice - Bitcoin Rate image 2' src='https://is2-ssl.mzstatic.com/image/thumb/Purple118/v4/da/2a/10/da2a1060-8e6c-4a9d-41ef-3839a493cf92/source/230x0w.jpg'> 
</div>
  </details>

- BitStore: Bitcoin wallet  
  <details><summary><code>objc</code> </summary>

  https://github.com/BitStore/BitStore-iOS<br>  Added April 11, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='BitStore image 1' src='http://a1.mzstatic.com/us/r30/Purple5/v4/4a/97/6b/4a976b84-565e-e7a1-b62b-b2a14b3cea7a/screen696x696.jpeg'> <img height='300' alt='BitStore image 2' src='http://a5.mzstatic.com/us/r30/Purple3/v4/19/23/7a/19237adf-2fa5-39aa-f92f-7c1a0f9d3c4b/screen696x696.jpeg'> <img height='300' alt='BitStore image 3' src='http://a4.mzstatic.com/us/r30/Purple3/v4/e0/65/f1/e065f1b2-cb58-ae9a-8b10-012dc1c81c11/screen696x696.jpeg'> <img height='300' alt='BitStore image 4' src='http://a1.mzstatic.com/us/r30/Purple1/v4/5d/a3/69/5da3692e-96a8-7c15-d115-16bdb2e6329f/screen696x696.jpeg'> <img height='300' alt='BitStore image 5' src='http://a2.mzstatic.com/us/r30/Purple1/v4/ae/40/19/ae4019c9-463b-3b73-7147-1b47473596d7/screen696x696.jpeg'> 
</div>
  </details>

- Bread: Bitcoin wallet [` App Store`](https://itunes.apple.com/app/breadwallet/id885251393)  
  <details><summary><code>swift</code> 🔥</summary>

  https://github.com/breadwallet/breadwallet-ios<br>  Added July  8, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Bread image 1' src='http://is2.mzstatic.com/image/thumb/Purple118/v4/5d/97/3b/5d973bb2-2e40-428e-bc10-ee4eb11ecc0d/source/392x696bb.jpg'> 
</div>
  </details>


## Game 
 
[back to top](#readme) 
 
- 2048  
  <details><summary><code>objc</code> 🔥🔥</summary>

  https://github.com/austinzheng/iOS-2048<br>  Added March 24, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='2048 image 1' src='https://github.com/austinzheng/iOS-2048/raw/master/screenshots/ss1.png?raw=true'> 
</div>
  </details>

- 2048  
  <details><summary><code>swift</code> 🔥🔥🔥🔥🔥</summary>

  https://github.com/austinzheng/swift-2048<br>  Added March 18, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='2048 image 1' src='https://cdn-images-1.medium.com/max/800/1*Lzt_Wm8hbVUEptBW-vhhMg.png'> 
</div>
  </details>

- 2048  
  <details><summary><code>spritekit</code> <code>objc</code> 🔥🔥🔥</summary>

  https://github.com/danqing/2048<br>  Added July 11, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='2048 image 1' src='https://camo.githubusercontent.com/ff3c4e76617a7af782d9670f1438801c7603c700/687474703a2f2f61342e6d7a7374617469632e636f6d2f75732f7233302f507572706c65342f76342f61342f66382f61662f61346638616631642d333837382d303831372d383539642d6465373662616531363963372f73637265656e353638783536382e6a706567'> 
</div>
  </details>

- Aeropack: Steampunk retro 2D platformer  
  <details><summary><code>objc</code> </summary>

  https://github.com/insurgentgames/Aeropack<br>  Added May 31, 2016<br>  License: [`gpl-3.0`](http://choosealicense.com/licenses/gpl-3.0/)
  <div><img height='300' alt='Aeropack image 1' src='http://www.guitarinfocenter.com/gameimages/aeropack1.jpg'> 
</div>
  </details>

- Bat Loves Bugs: Eat as many bugs as you can catch  
  <details><summary><code>objc</code> </summary>

  https://github.com/xyclos/BatLovesBugs<br>  Added October 27, 2016<br>  License: `other`
  <div><img height='300' alt='Bat Loves Bugs image 1' src='http://a5.mzstatic.com/us/r30/Purple1/v4/9a/1a/f9/9a1af9cc-7db1-7985-a14f-b5ccdfcc985b/screen696x696.jpeg'> <img height='300' alt='Bat Loves Bugs image 2' src='http://a3.mzstatic.com/us/r30/Purple3/v4/da/43/ec/da43ecba-523c-02b4-1391-1b9104e8f5cc/screen696x696.jpeg'> <img height='300' alt='Bat Loves Bugs image 3' src='http://a1.mzstatic.com/us/r30/Purple3/v4/c1/78/f6/c178f6ab-6803-430d-5028-a764015d240d/screen696x696.jpeg'> <img height='300' alt='Bat Loves Bugs image 4' src='http://a1.mzstatic.com/us/r30/Purple1/v4/27/44/51/2744512c-9a1a-0e68-2cd1-7aa8392a7ddd/screen696x696.jpeg'> <img height='300' alt='Bat Loves Bugs image 5' src='http://a3.mzstatic.com/us/r30/Purple5/v4/88/f1/33/88f13350-94f9-7248-2fb7-9bed86ff3179/screen696x696.jpeg'> 
</div>
  </details>

- Canabalt: Infinite runner [` App Store`](https://itunes.apple.com/app/canabalt/id333180061)  
  <details><summary><code>objc</code> 🔥🔥🔥🔥</summary>

  https://github.com/ericjohnson/canabalt-ios<br>  Added March 26, 2015<br>  License: `other`
  <div><img height='300' alt='Canabalt image 1' src='http://a2.mzstatic.com/us/r30/Purple5/v4/17/8b/bc/178bbcd2-96ac-c280-e01a-c9a7b5cbbda7/screen696x696.jpeg'> <img height='300' alt='Canabalt image 2' src='http://a2.mzstatic.com/us/r30/Purple3/v4/0e/b2/dc/0eb2dc13-d153-5631-53c5-db019d461d70/screen696x696.jpeg'> <img height='300' alt='Canabalt image 3' src='http://a2.mzstatic.com/us/r30/Purple1/v4/b2/51/45/b25145a0-69b9-7a9b-4c2d-c0d1f2748c87/screen696x696.jpeg'> <img height='300' alt='Canabalt image 4' src='http://a4.mzstatic.com/us/r30/Purple3/v4/12/a4/04/12a404e7-7822-d824-9ca2-c268ea911ffe/screen696x696.jpeg'> <img height='300' alt='Canabalt image 5' src='http://a2.mzstatic.com/us/r30/Purple3/v4/78/0d/69/780d6918-15e8-09ee-4a39-a5f787f0ff25/screen696x696.jpeg'> 
</div>
  </details>

- CardsAgainst: Cards Against Humanity app  
  <details><summary><code>swift</code> 🔥🔥</summary>

  https://github.com/jpsim/CardsAgainst<br>  Added January 26, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='CardsAgainst image 1' src='https://www.objc.io/images/issue-18/dedicated-9942fc7b.gif'> 
</div>
  </details>

- Castle Hassle: A real-time physical game where you build your kingdom while crushing your opponents  
  <details><summary><code>objc</code> 🔥</summary>

  https://github.com/bryceredd/CastleHassle<br>  Added May 31, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div>
</div>
  </details>

- Chuck: Throw a ball and catch it, over and over and over  
  <details><summary><code>objc</code> </summary>

  https://github.com/moowahaha/Chuck<br>  Added October 25, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Chuck image 1' src='http://a1.mzstatic.com/us/r30/Purple6/v4/c6/fd/bc/c6fdbcde-afe3-a9aa-44ea-781ca2b8e468/screen696x696.jpeg'> <img height='300' alt='Chuck image 2' src='http://a1.mzstatic.com/us/r30/Purple22/v4/b4/4a/07/b44a070b-ec26-2b15-40d0-dc71de6daa1f/screen696x696.jpeg'> <img height='300' alt='Chuck image 3' src='http://a2.mzstatic.com/us/r30/Purple32/v4/32/26/2b/32262b2d-90ce-96fd-bf5a-445156aeee08/screen696x696.jpeg'> <img height='300' alt='Chuck image 4' src='http://a5.mzstatic.com/us/r30/Purple69/v4/8e/40/9d/8e409d97-5b09-4581-8f3f-5b7ba83c4f1d/screen696x696.jpeg'> <img height='300' alt='Chuck image 5' src='http://a5.mzstatic.com/us/r30/Purple32/v4/23/1f/c5/231fc547-694a-995d-13d6-7d1097487388/screen696x696.jpeg'> 
</div>
  </details>

- CodeCombat: Multiplayer programming game for learning how to code  
  <details><summary><code>objc</code> </summary>

  https://github.com/codecombat/codecombat-ios<br>  Added January 23, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='CodeCombat image 1' src='http://a1.mzstatic.com/us/r30/Purple1/v4/a6/e5/e4/a6e5e42e-cfb4-159c-8fe6-819e0db0d09c/screen480x480.jpeg'> 
</div>
  </details>

- Concentration game (翻翻看)  
  <details><summary><code>swift</code> 🇨🇳 🔥</summary>

  https://github.com/geek5nan/FanFanSwift<br>  Added May 14, 2015<br>  License: `other`
  <div><img height='300' alt='Concentration game (翻翻看) image 1' src='https://raw.githubusercontent.com/geek5nan/FanFanSwift/master/screenshot/2.png'> 
</div>
  </details>

- Conway's Game of Life (Vie) [` App Store`](https://itunes.apple.com/app/vie-conways-game-of-life/id989686123)  
  <details><summary><code>objc</code> </summary>

  https://github.com/fabienwarniez/Vie<br>  Added July 22, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Conway's Game of Life (Vie) image 1' src='http://a2.mzstatic.com/us/r30/Purple20/v4/3f/36/56/3f3656f4-30d9-df8b-6a58-e1260a72dee9/screen696x696.jpeg'> 
</div>
  </details>

- Doom Classic [` App Store`](https://itunes.apple.com/app/doom-classic/id336347946)  
  <details><summary><code>objc</code> 🔥🔥</summary>

  https://github.com/id-Software/DOOM-iOS<br>  Added May 19, 2015<br>  License: [`gpl-2.0`](http://choosealicense.com/licenses/gpl-2.0/)
  <div><img height='300' alt='Doom Classic image 1' src='http://a1.mzstatic.com/us/r30/Purple6/v4/87/bf/74/87bf7496-9c18-61df-272e-2803844f0747/screen696x696.jpeg'> <img height='300' alt='Doom Classic image 2' src='http://a2.mzstatic.com/us/r30/Purple/v4/88/95/dd/8895ddc3-f46c-4da3-058a-3c9b76016ee3/screen696x696.jpeg'> <img height='300' alt='Doom Classic image 3' src='http://a1.mzstatic.com/us/r30/Purple/v4/4a/17/2e/4a172e70-08c6-ed51-51c9-317e836a4cca/screen696x696.jpeg'> 
</div>
  </details>

- DOOM Classic 2 [` App Store`](https://itunes.apple.com/app/doom-ii-rpg/id354051766)  
  <details><summary><code>objc</code> 🔥</summary>

  https://github.com/id-Software/DOOM-IOS2<br>  Added May 19, 2015<br>  License: [`gpl-2.0`](http://choosealicense.com/licenses/gpl-2.0/)
  <div><img height='300' alt='DOOM Classic 2 image 1' src='http://a4.mzstatic.com/us/r30/Purple/v4/2a/60/50/2a6050d0-c040-3684-fb0f-1694fd1edde4/screen480x480.jpeg'> 
</div>
  </details>

- Dragon Shout App 2: A social journal for the Elder Scrolls® series  
  <details><summary><code>objc</code> </summary>

  https://github.com/rblalock/dragon_shout_app_open_source<br>  Added June  1, 2016<br>  License: [`apache-2.0`](http://choosealicense.com/licenses/apache-2.0/)
  <div>
</div>
  </details>

- DropColour: Drag & drop one circle onto another of the same color [` App Store`](https://itunes.apple.com/app/dropcolour/id1046339763)  
  <details><summary><code>swift</code> <code>swift2.2</code> </summary>

  https://github.com/elpassion/DropColour-iOS<br>  Added July 12, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='DropColour image 1' src='http://a2.mzstatic.com/us/r30/Purple60/v4/7f/50/5a/7f505ad9-b065-e8e3-6fe2-6d8610c13fa7/screen696x696.jpeg'> 
</div>
  </details>

- Dungeon Crawl: A game of dungeon exploration, combat & magic, involving characters of diverse skills  
  <details><summary><code>objc</code> </summary>

  https://github.com/CliffsDover/crawl<br>  https://github.com/CliffsDover/crawl/tree/iOS_Release<br>  Added March 23, 2016<br>  License: [`gpl-2.0`](http://choosealicense.com/licenses/gpl-2.0/)
  <div><img height='300' alt='Dungeon Crawl image 1' src='https://i.imgur.com/MZZeHCf.png'> 
</div>
  </details>

- FlappyBird clone - Scary Flight  
  <details><summary><code>objc</code> </summary>

  https://github.com/EvgenyKarkan/ScaryFlight<br>  Added May 13, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='FlappyBird clone - Scary Flight image 1' src='http://a5.mzstatic.com/us/r30/Purple4/v4/9d/17/17/9d17174d-aee3-a503-38bf-d768056313ce/screen696x696.jpeg'> <img height='300' alt='FlappyBird clone - Scary Flight image 2' src='http://a3.mzstatic.com/us/r30/Purple6/v4/43/de/20/43de20bb-d602-e5e4-c7ea-5f4b4551b6fc/screen696x696.jpeg'> <img height='300' alt='FlappyBird clone - Scary Flight image 3' src='http://a4.mzstatic.com/us/r30/Purple/v4/d1/a3/59/d1a359c5-0b01-6b61-d87b-a69d9d67dbb5/screen696x696.jpeg'> 
</div>
  </details>

- FlappySwift: Flappy Bird clone  
  <details><summary><code>swift</code> 🔥🔥🔥🔥🔥</summary>

  https://github.com/fullstackio/FlappySwift<br>  Added March 18, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='FlappySwift image 1' src='https://camo.githubusercontent.com/867dfad61329bd77258f00d586b16476c7bc405a/687474703a2f2f692e696d6775722e636f6d2f314e4c6f546f552e676966'> 
</div>
  </details>

- Frogatto & Friends: Action-adventure game, starring a certain quixotic frog  
  <details><summary><code>objc</code> 🔥🔥</summary>

  https://github.com/frogatto/frogatto<br>  https://frogatto.com/<br>  Added October 27, 2016<br>  License: `other`
  <div><img height='300' alt='Frogatto & Friends image 1' src='https://i.imgur.com/vMp5j2Y.gif'> 
</div>
  </details>

- Frotz: Play hundreds of free works of Interactive Fiction (text adventure games) [` App Store`](https://itunes.apple.com/app/id287653015)  
  <details><summary><code>objc</code> </summary>

  https://github.com/ifrotz/iosfrotz<br>  https://github.com/ifrotz/iosfrotz/blob/wiki/FrotzMain.md<br>  Added June  1, 2016<br>  License: [`gpl-2.0`](http://choosealicense.com/licenses/gpl-2.0/)
  <div><img height='300' alt='Frotz image 1' src='http://a3.mzstatic.com/us/r30/Purple62/v4/c9/c1/a2/c9c1a21b-bf4a-6f4e-058f-5578e10013a3/screen696x696.jpeg'> <img height='300' alt='Frotz image 2' src='http://a3.mzstatic.com/us/r30/Purple71/v4/3a/52/47/3a524725-42b9-54e6-d81e-8f81790d977f/screen696x696.jpeg'> <img height='300' alt='Frotz image 3' src='http://a2.mzstatic.com/us/r30/Purple71/v4/76/75/fe/7675fe03-875c-6ea3-a3fb-2bc5b8c43aec/screen696x696.jpeg'> <img height='300' alt='Frotz image 4' src='http://a5.mzstatic.com/us/r30/Purple62/v4/09/f1/1b/09f11b70-c3ef-a97f-73f3-9be6b32eed3b/screen696x696.jpeg'> <img height='300' alt='Frotz image 5' src='http://a3.mzstatic.com/us/r30/Purple71/v4/9b/b0/40/9bb04057-975f-1519-1490-b7b53fd6c576/screen696x696.jpeg'> 
</div>
  </details>

- Game of War clone: 4x strategy game  
  <details><summary><code>helpshift</code> <code>ssziparchive</code> </summary>

  https://github.com/shankqr/4xMobileGame<br>  Added July  5, 2017<br>  License: `other`
  <div><img height='300' alt='Game of War clone image 1' src='https://user-images.githubusercontent.com/3216424/27571005-10f73774-5b35-11e7-9a84-c0b720280fc1.jpeg'> 
</div>
  </details>

- Green Mahjong: Solitaire mahjong [` App Store`](https://itunes.apple.com/app/id933634500)  
  <details><summary><code>netbeans</code> </summary>

  https://github.com/danbeck/green-mahjong<br>  Added October 27, 2016<br>  License: `other`
  <div><img height='300' alt='Green Mahjong image 1' src='http://a1.mzstatic.com/us/r30/Purple3/v4/0e/08/99/0e0899aa-4685-d52e-1bea-1586e7531ac4/screen696x696.jpeg'> <img height='300' alt='Green Mahjong image 2' src='http://a2.mzstatic.com/us/r30/Purple3/v4/58/d2/aa/58d2aab2-e9f9-919d-6856-a94ddb296bdb/screen696x696.jpeg'> <img height='300' alt='Green Mahjong image 3' src='http://a2.mzstatic.com/us/r30/Purple1/v4/0e/94/aa/0e94aaa8-43fb-8e0b-0238-5acf559da6c0/screen696x696.jpeg'> <img height='300' alt='Green Mahjong image 4' src='http://a3.mzstatic.com/us/r30/Purple1/v4/7d/9e/b2/7d9eb29e-a89d-04f6-a323-8d17839e11df/screen696x696.jpeg'> <img height='300' alt='Green Mahjong image 5' src='http://a3.mzstatic.com/us/r30/Purple3/v4/4e/dc/41/4edc41ac-ccd3-ce53-2318-a984ee69b3b6/screen696x696.jpeg'> 
</div>
  </details>

- Hedgewars: A turn-based strategy game [` App Store`](https://itunes.apple.com/app/id391234866)  
  <details><summary><code>objc</code> </summary>

  http://hg.hedgewars.org/hedgewars/<br>  http://www.hedgewars.org/<br>  Added June  2, 2016<br>  License: [`gpl-2.0`](http://choosealicense.com/licenses/gpl-2.0/)
  <div><img height='300' alt='Hedgewars image 1' src='http://a4.mzstatic.com/us/r30/Purple71/v4/23/7d/d5/237dd544-8e72-4a38-ec03-b4d48d0ef94a/screen696x696.jpeg'> <img height='300' alt='Hedgewars image 2' src='http://a2.mzstatic.com/us/r30/Purple71/v4/d6/54/d5/d654d552-a3df-1d88-a5f9-8af48bf8edcb/screen696x696.jpeg'> <img height='300' alt='Hedgewars image 3' src='http://a3.mzstatic.com/us/r30/Purple62/v4/66/eb/1d/66eb1d41-66e0-aebd-51cf-0f8d165849a7/screen696x696.jpeg'> <img height='300' alt='Hedgewars image 4' src='http://a1.mzstatic.com/us/r30/Purple71/v4/58/7d/52/587d5293-4f6f-2901-41fd-aebf8abca45a/screen696x696.jpeg'> <img height='300' alt='Hedgewars image 5' src='http://a4.mzstatic.com/us/r30/Purple62/v4/b0/8e/04/b08e0476-b276-9fff-093e-d4213091e1e3/screen696x696.jpeg'> 
</div>
  </details>

- Hostile Takeover: A release of the real time strategy game Warfare Incorporated  
  <details><summary><code>objc</code> 🔥</summary>

  https://github.com/spiffcode/hostile-takeover<br>  Added June  1, 2016<br>  License: [`bsd-2-clause`](http://choosealicense.com/licenses/bsd-2-clause/)
  <div><img height='300' alt='Hostile Takeover image 1' src='https://i.imgur.com/PQ1QX2u.jpg'> 
</div>
  </details>

- hoxChess: Xiangqi (Chinese Chess) with single & multiplayer modes  
  <details><summary><code>objc</code> </summary>

  https://github.com/huygithub/hoxChess<br>  Added June  1, 2016<br>  License: [`gpl-3.0`](http://choosealicense.com/licenses/gpl-3.0/)
  <div><img height='300' alt='hoxChess image 1' src='http://a5.mzstatic.com/us/r30/Purple4/v4/3a/ac/87/3aac87ca-d5cc-9bea-3899-807cf211da85/screen696x696.jpeg'> <img height='300' alt='hoxChess image 2' src='http://a5.mzstatic.com/us/r30/Purple3/v4/d8/75/0d/d8750d68-3619-b760-99c5-ec4eac12ae35/screen696x696.jpeg'> <img height='300' alt='hoxChess image 3' src='http://a3.mzstatic.com/us/r30/Purple3/v4/41/9c/d3/419cd344-da8a-f046-3bcf-757f6f10768d/screen696x696.jpeg'> <img height='300' alt='hoxChess image 4' src='http://a4.mzstatic.com/us/r30/Purple5/v4/11/28/6e/11286e79-b0b0-1057-7315-3e122a15a62c/screen696x696.jpeg'> <img height='300' alt='hoxChess image 5' src='http://a5.mzstatic.com/us/r30/Purple4/v4/ca/99/1e/ca991e9e-1fe3-8764-b7f9-5c38b4c6e565/screen696x696.jpeg'> 
</div>
  </details>

- littlego: Game of Go [` App Store`](https://itunes.apple.com/app/little-go/id490753989)  
  <details><summary><code>iphone</code> <code>ipad</code> </summary>

  https://github.com/herzbube/littlego<br>  Added March  6, 2016<br>  License: [`apache-2.0`](http://choosealicense.com/licenses/apache-2.0/)
  <div><img height='300' alt='littlego image 1' src='http://a1.mzstatic.com/us/r30/Purple71/v4/ad/36/59/ad3659ad-8c68-5f2f-36ca-fa27d5042e58/screen696x696.jpeg'> <img height='300' alt='littlego image 2' src='http://a2.mzstatic.com/us/r30/Purple62/v4/ba/9e/b6/ba9eb6ca-7c61-2277-4406-3ba863bed714/screen696x696.jpeg'> <img height='300' alt='littlego image 3' src='http://a2.mzstatic.com/us/r30/Purple62/v4/e3/96/b4/e396b4a4-5cd7-847a-a7c4-66f714470699/screen696x696.jpeg'> <img height='300' alt='littlego image 4' src='http://a5.mzstatic.com/us/r30/Purple62/v4/98/48/ab/9848ab1c-831a-c76a-4ad3-c1512b54ef5c/screen696x696.jpeg'> <img height='300' alt='littlego image 5' src='http://a4.mzstatic.com/us/r30/Purple71/v4/9b/52/85/9b528510-9276-04aa-2500-11248a7aca01/screen696x696.jpeg'> 
</div>
  </details>

- Master: PokéMon-like game that uses your location  
  <details><summary><code>objc</code> 🔥🔥</summary>

  https://github.com/Kjuly/iPokeMon<br>  Added May 15, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div>
</div>
  </details>

- MechaHamster: Roll through customizable environments that you can share with friends  
  <details><summary><code>unity3d</code> <code>csharp</code> <code>firebase</code> </summary>

  https://github.com/google/mechahamster<br>  Added May 19, 2017<br>  License: [`apache-2.0`](http://choosealicense.com/licenses/apache-2.0/)
  <div><img height='300' alt='MechaHamster image 1' src='https://google.github.io/mechahamster/gameplay1.png'> 
</div>
  </details>

- Mission999  
  <details><summary><code>objc</code> </summary>

  https://github.com/whunmr/Mission999<br>  Added February 17, 2016<br>  License: [`apache-2.0`](http://choosealicense.com/licenses/apache-2.0/)
  <div><img height='300' alt='Mission999 image 1' src='http://a1.mzstatic.com/us/r30/Purple6/v4/6a/6f/1f/6a6f1f51-23ab-7457-f5db-47590d971f2d/screen696x696.jpeg'> <img height='300' alt='Mission999 image 2' src='http://a3.mzstatic.com/us/r30/Purple5/v4/cc/34/24/cc34240d-245f-4776-dc12-11c0eef68b51/screen696x696.jpeg'> <img height='300' alt='Mission999 image 3' src='http://a3.mzstatic.com/us/r30/Purple69/v4/55/d9/20/55d9203f-ae32-c684-1cbd-328334082f2a/screen696x696.jpeg'> <img height='300' alt='Mission999 image 4' src='http://a1.mzstatic.com/us/r30/Purple30/v4/44/51/4b/44514bb9-5c0b-ada3-eaa3-fa31fabcda90/screen696x696.jpeg'> <img height='300' alt='Mission999 image 5' src='http://a4.mzstatic.com/us/r30/Purple6/v4/e6/ff/e8/e6ffe8ed-9702-e843-6202-c51a94b52e62/screen696x696.jpeg'> 
</div>
  </details>

- MUDRammer: MUD app (Multi-User Dungeon) [` App Store`](https://itunes.apple.com/app/mudrammer-a-modern-mud-client/id597157072)  
  <details><summary><code>iphone</code> <code>ipad</code> </summary>

  https://github.com/splinesoft/MUDRammer<br>  Added June 28, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='MUDRammer image 1' src='http://a2.mzstatic.com/us/r30/Purple4/v4/88/e8/ec/88e8ec63-a6a8-9dfe-ade2-d4e9666ee9e9/screen696x696.jpeg'> <img height='300' alt='MUDRammer image 2' src='http://a4.mzstatic.com/us/r30/Purple1/v4/44/b7/ca/44b7ca02-aab1-314e-4fd8-01f588ef6b85/screen696x696.jpeg'> <img height='300' alt='MUDRammer image 3' src='http://a1.mzstatic.com/us/r30/Purple4/v4/27/22/46/2722468d-705c-dc8c-08dc-79d801e492f1/screen696x696.jpeg'> <img height='300' alt='MUDRammer image 4' src='http://a5.mzstatic.com/us/r30/Purple4/v4/29/fc/5f/29fc5f66-2e80-f455-61d7-08c5acd56046/screen696x696.jpeg'> <img height='300' alt='MUDRammer image 5' src='http://a1.mzstatic.com/us/r30/Purple1/v4/aa/94/19/aa9419d0-2742-e741-e3af-215aaa567aaa/screen696x696.jpeg'> <img height='300' alt='MUDRammer image 6' src='http://a4.mzstatic.com/us/r30/Purple1/v4/c6/bc/0d/c6bc0d7c-a61d-e2cd-7274-b7b94ff38cee/screen696x696.jpeg'> 
</div>
  </details>

- My First Memory: Memory game, includes introduction to iOS & Swift  
  <details><summary><code>swift</code> <code>instagram api</code> </summary>

  https://github.com/Sajjon/SwiftIntro<br>  Added July  6, 2016<br>  License: [`gpl-3.0`](http://choosealicense.com/licenses/gpl-3.0/)
  <div><img height='300' alt='My First Memory image 1' src='https://i.imgur.com/8u73w5u.png'> <img height='300' alt='My First Memory image 2' src='https://i.imgur.com/MShIfCe.png'> 
</div>
  </details>

- Neocom for EVE Online: EveOnline MMORG character management tool [` App Store`](https://itunes.apple.com/app/eveuniverse/id418895101)  
  <details><summary><code>objc</code> </summary>

  https://github.com/mrdepth/Neocom<br>  Added June  1, 2016<br>  License: [`lgpl-2.1`](http://choosealicense.com/licenses/lgpl-2.1/)
  <div><img height='300' alt='Neocom for EVE Online image 1' src='http://a1.mzstatic.com/us/r30/Purple62/v4/45/76/1c/45761c5c-7f4e-1a5a-842a-76314a1268a1/screen696x696.jpeg'> <img height='300' alt='Neocom for EVE Online image 2' src='http://a3.mzstatic.com/us/r30/Purple62/v4/7d/d7/f4/7dd7f488-cd08-d943-450f-8fcb2d5471cc/screen696x696.jpeg'> <img height='300' alt='Neocom for EVE Online image 3' src='http://a5.mzstatic.com/us/r30/Purple62/v4/10/32/49/10324902-3310-8541-aac4-1104e97b5f48/screen696x696.jpeg'> <img height='300' alt='Neocom for EVE Online image 4' src='http://a5.mzstatic.com/us/r30/Purple71/v4/6e/dc/f8/6edcf87a-3b7c-41f2-e2a1-ffb0ad99830f/screen696x696.jpeg'> <img height='300' alt='Neocom for EVE Online image 5' src='http://a3.mzstatic.com/us/r30/Purple71/v4/59/66/a8/5966a85b-0851-bfc1-f539-47708f5cc38c/screen696x696.jpeg'> 
</div>
  </details>

- Pterodactyl Attack: Blast your way through waves of pterodactyls, includes detailed writeup on how it's made  
  <details><summary><code>objc</code> </summary>

  https://github.com/shaunlebron/PterodactylAttack<br>  https://shaunlebron.github.io/pteroattack.com/<br>  Added June  1, 2016<br>  License: [`gpl-3.0`](http://choosealicense.com/licenses/gpl-3.0/)
  <div><img height='300' alt='Pterodactyl Attack image 1' src='http://a5.mzstatic.com/us/r30/Purple7/v4/aa/33/d8/aa33d8aa-ccb6-293d-a213-f7bd5cdc55e1/screen696x696.jpeg'> <img height='300' alt='Pterodactyl Attack image 2' src='http://a4.mzstatic.com/us/r30/Purple1/v4/2a/fe/98/2afe98b7-d218-cd50-ec2e-706bb93bd9a3/screen696x696.jpeg'> <img height='300' alt='Pterodactyl Attack image 3' src='http://a4.mzstatic.com/us/r30/Purple5/v4/ea/29/3d/ea293d10-eb58-009d-9590-51b8c647568f/screen696x696.jpeg'> <img height='300' alt='Pterodactyl Attack image 4' src='http://a1.mzstatic.com/us/r30/Purple1/v4/3f/1d/0a/3f1d0a4e-da6c-b3dc-058a-44c8c562855e/screen696x696.jpeg'> <img height='300' alt='Pterodactyl Attack image 5' src='http://a4.mzstatic.com/us/r30/Purple5/v4/e0/3d/4f/e03d4f98-caed-0026-9072-0ffd5f6df2aa/screen696x696.jpeg'> 
</div>
  </details>

- RealmPop: Platform / multiplayer game where players pair up to clear a level of bubbles  
  <details><summary><code>swift</code> <code>realm</code> </summary>

  https://github.com/realm/RealmPop<br>  Added March  7, 2017<br>  License: `other`
  <div><img height='300' alt='RealmPop image 1' src='https://i.imgur.com/pTxoTPX.png'> <img height='300' alt='RealmPop image 2' src='https://i.imgur.com/Zrvfypq.png'> 
</div>
  </details>

- S.C.P-Asylum-Fail: A game like ’Life Line’  
  <details><summary><code>swift</code> 🇨🇳 </summary>

  https://github.com/cpo007/S.C.P-Asylum-Fail<br>  Added October  8, 2016<br>  License: `other`
  <div><img height='300' alt='S.C.P-Asylum-Fail image 1' src='https://github.com/cpo007/S.C.P-Asylum-Fail/blob/master/Image/Launch.png'> <img height='300' alt='S.C.P-Asylum-Fail image 2' src='https://github.com/cpo007/S.C.P-Asylum-Fail/blob/master/Image/Home.png'> 
</div>
  </details>

- SaveTheDot: Escape from the squares  
  <details><summary><code>uiviewpropertyanimator</code> 🔥🔥🔥</summary>

  https://github.com/JakeLin/SaveTheDot<br>  Added June 23, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='SaveTheDot image 1' src='https://cloud.githubusercontent.com/assets/573856/16248754/90150c2a-3854-11e6-9ee1-c2e4f228a9b6.gif'> 
</div>
  </details>

- SHMUP: 3D multiplatform game written primarily in C [` App Store`](https://itunes.apple.com/app/shmup/id337663605)  
  <details><summary><code>objc</code> 🔥</summary>

  https://github.com/fabiensanglard/Shmup<br>  http://fabiensanglard.net/shmup/<br>  Added July 12, 2016<br>  License: [`gpl-3.0`](http://choosealicense.com/licenses/gpl-3.0/)
  <div><img height='300' alt='SHMUP image 1' src='http://a3.mzstatic.com/us/r30/Purple/v4/e2/ee/82/e2ee8263-7265-3376-ec94-604ab58e631a/screen320x480.jpeg'> 
</div>
  </details>

- Skeleton Key: A puzzle game where you must shift keys around a board to unlock treasure chests  
  <details><summary><code>objc</code> 🔥</summary>

  https://github.com/insurgentgames/Skeleton-Key-iOS<br>  Added May 31, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  </details>

- Space Zero: Merchant ships have been stranded in space! Rescue as many as you can, but watch out for enemies!  
  <details><summary><code>swift</code> </summary>

  https://github.com/xyclos/space_squared<br>  Added November  2, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Space Zero image 1' src='http://a1.mzstatic.com/us/r30/Purple62/v4/9a/a7/5b/9aa75b3a-0dec-0834-7475-dbd611e0ba5d/screen696x696.jpeg'> 
</div>
  </details>

- Spare Parts: Simple 2D point & line physics using Verlet integration [` App Store`](https://itunes.apple.com/app/spare-parts/id981297199)  
  <details><summary><code>objc</code> </summary>

  https://github.com/adamwulf/spare-parts-app<br>  Added April  6, 2015<br>  License: `other`
  <div><img height='300' alt='Spare Parts image 1' src='http://a2.mzstatic.com/us/r30/Purple5/v4/22/a4/44/22a444e1-7626-03ee-05e7-6bdf58ea577d/screen480x480.jpeg'> 
</div>
  </details>

- teh internets: Pilot a rolfcopter to collect lolcats, dodge popups, feed trolls cheezburgers & more in this side-scrolling arcade shooter  
  <details><summary><code>objc</code> </summary>

  https://github.com/insurgentgames/teh-internets<br>  Added June  1, 2016<br>  License: [`gpl-3.0`](http://choosealicense.com/licenses/gpl-3.0/)
  <div><img height='300' alt='teh internets image 1' src='http://cdn.iphoneincanada.ca/wp-content/uploads/2009/11/IMG_0520.PNG'> 
</div>
  </details>

- Wolfenstein 3D: Wolfenstein 3D for iOS [` App Store`](https://itunes.apple.com/app/wolfenstein-3d-classic-platinum/id309470478)  
  <details><summary><code>objc</code> 🔥🔥</summary>

  https://github.com/id-Software/Wolf3D-iOS<br>  Added May 19, 2015<br>  License: [`gpl-2.0`](http://choosealicense.com/licenses/gpl-2.0/)
  <div><img height='300' alt='Wolfenstein 3D image 1' src='http://a2.mzstatic.com/us/r30/Purple5/v4/7e/e4/82/7ee482ac-e8e2-edef-1187-d27110ed80d3/screen696x696.jpeg'> <img height='300' alt='Wolfenstein 3D image 2' src='http://a1.mzstatic.com/us/r30/Purple1/v4/08/71/7b/08717b85-2044-bc08-0b7e-db345d80ff1d/screen696x696.jpeg'> 
</div>
  </details>


### Cocos2d 
 
http://cocos2d.org/ — [back to top](#readme) 
 
- Alienblast: Cute & sweet shooting game [` App Store`](https://itunes.apple.com/app/id1098323034)  
  <details><summary><code>swift</code> <code>spritebuilder</code> </summary>

  https://github.com/etamity/AlienBlast<br>  Added July 18, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Alienblast image 1' src='http://a3.mzstatic.com/us/r30/Purple49/v4/fd/71/de/fd71deb3-7e75-2d3d-5de1-e859712af0ef/screen696x696.jpeg'> <img height='300' alt='Alienblast image 2' src='http://a4.mzstatic.com/us/r30/Purple49/v4/ba/35/35/ba35350b-2507-990a-4ee0-b1b4fa822413/screen696x696.jpeg'> <img height='300' alt='Alienblast image 3' src='http://a4.mzstatic.com/us/r30/Purple49/v4/c2/e1/d3/c2e1d311-7d49-2d4b-5948-e13bd7066536/screen696x696.jpeg'> <img height='300' alt='Alienblast image 4' src='http://a1.mzstatic.com/us/r30/Purple49/v4/26/32/be/2632be98-bce4-6a61-2eac-c8417e4b8b1d/screen696x696.jpeg'> <img height='300' alt='Alienblast image 5' src='http://a4.mzstatic.com/us/r30/Purple49/v4/e9/4b/50/e94b50db-71b8-13c8-603f-8cee86236b60/screen696x696.jpeg'> <img height='300' alt='Alienblast image 6' src='http://a4.mzstatic.com/us/r30/Purple49/v4/70/a4/7c/70a47c33-d67c-1563-3bc9-7a238f83d65b/screen696x696.jpeg'> 
</div>
  </details>

- Balloon Burst  
  <details><summary><code>objc</code> </summary>

  https://github.com/jamiely/ios-balloon-burst<br>  Added May 16, 2016<br>  License: `other`
  <div><img height='300' alt='Balloon Burst image 1' src='https://i.imgur.com/z9rNl4a.png'> 
</div>
  </details>

- Heredox: Place tiles to form your allegiance's symbols  
  <details><summary><code>objc</code> </summary>

  https://github.com/RolandasRazma/Heredox<br>  http://www.heredox.com/<br>  Added June  1, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Heredox image 1' src='https://i.imgur.com/Wg6TIR7.jpg'> <img height='300' alt='Heredox image 2' src='https://i.imgur.com/PatEcU8.jpg'> 
</div>
  </details>

- Lumio: Puzzle game  
  <details><summary><code>objc</code> 🔥</summary>

  https://github.com/sephine/lumio<br>  Added October 27, 2016<br>  License: `other`
  <div><img height='300' alt='Lumio image 1' src='https://raw.githubusercontent.com/sephine/lumio/master/Lumio/Resources/Screenshots/ScreenShot1.png'> 
</div>
  </details>


### SpriteKit 
 
https://developer.apple.com/reference/spritekit — [back to top](#readme) 
 
- 2048  
  <details><summary><code>spritekit</code> <code>objc</code> 🔥🔥🔥</summary>

  https://github.com/danqing/2048<br>  Added July 11, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='2048 image 1' src='https://camo.githubusercontent.com/ff3c4e76617a7af782d9670f1438801c7603c700/687474703a2f2f61342e6d7a7374617469632e636f6d2f75732f7233302f507572706c65342f76342f61342f66382f61662f61346638616631642d333837382d303831372d383539642d6465373662616531363963372f73637265656e353638783536382e6a706567'> 
</div>
  </details>

- Crosses-n-Ous: Class Tic Tac Toe reincarnation with AI and state machines  
  <details><summary><code>swift</code> <code>gameplaykit</code> </summary>

  https://github.com/ChickenHeart/Crosses-n-Ous<br>  Added August 27, 2017<br>  License: [`apache-2.0`](http://choosealicense.com/licenses/apache-2.0/)
  <div><img height='300' alt='Crosses-n-Ous image 1' src='https://user-images.githubusercontent.com/5098753/29486890-28e5c01a-84f9-11e7-8572-8b9f3b3d37a4.gif'> 
</div>
  </details>

- Five In A Row (五子棋)  
  <details><summary><code>objc</code> 🇨🇳 </summary>

  https://github.com/WelkinXie/FiveInARow<br>  Added May  6, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Five In A Row (五子棋) image 1' src='https://i.imgur.com/anzIXHK.png'> 
</div>
  </details>

- Mergel: Shape matching puzzle  
  <details><summary><code>swift</code> </summary>

  https://github.com/snazzware/Mergel<br>  Added November  9, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Mergel image 1' src='https://i.imgur.com/978TVq5.png'> 
</div>
  </details>

- Orbit7  
  <details><summary><code>swift</code> 🔥</summary>

  https://github.com/Aaron-A/Orbit7<br>  Added April  2, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Orbit7 image 1' src='https://camo.githubusercontent.com/9c5aa602321121d160837fbe8c0af605196810b4/687474703a2f2f73382e706f7374696d672e6f72672f346c377575746f30352f4f72626974375f47616d652e676966'> 
</div>
  </details>

- Sakura Fly [` App Store`](https://itunes.apple.com/app/sakura-fly/id1019023051)  
  <details><summary><code>objc</code> </summary>

  https://github.com/cl7/Sakura-Fly<br>  Added March 14, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Sakura Fly image 1' src='https://cloud.githubusercontent.com/assets/6619146/13731560/965791fe-e942-11e5-9a11-f66f404fa18c.gif'> 
</div>
  </details>

- Snake Classic: A snake engine for all Apple devices  
  <details><summary><code>swift</code> </summary>

  https://github.com/PiXeL16/SnakeClassic<br>  Added August 31, 2017<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Snake Classic image 1' src='https://raw.githubusercontent.com/PiXeL16/SnakeClassic/master/Art/SnakeWatch.png'> 
</div>
  </details>

- Stick-Hero-Swift  
  <details><summary><code>swift</code> <code>iphone</code> <code>ipad</code> 🔥🔥</summary>

  https://github.com/phpmaple/Stick-Hero-Swift<br>  Added June 30, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Stick-Hero-Swift image 1' src='https://raw.githubusercontent.com/phpmaple/Stick-Hero-Swift/master/Assets/Images/stick_background.jpg'> 
</div>
  </details>

- SwiftSnake: Snake clone  
  <details><summary><code>swift</code> </summary>

  https://github.com/caleb0/SwiftSnake<br>  Added August 19, 2016<br>  License: `other`
  <div><img height='300' alt='SwiftSnake image 1' src='https://i.imgur.com/mBi9Jfj.png'> 
</div>
  </details>


## Health 
 
[back to top](#readme) 
 
- Arex: Reminders for taking your medications  
  <details><summary><code>swift</code> <code>swift2.2</code> <code>carthage</code> <code>pistachio</code> <code>reactivecocoa</code> </summary>

  https://github.com/a2/arex<br>  Added June  9, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  </details>

- CaseAssistant: Cases recording, study, & sharing for ophthalmologist [` App Store`](https://itunes.apple.com/app/id1003007080)  
  <details><summary><code>swift</code> <code>realm</code> 🇨🇳 🔥</summary>

  https://github.com/herrkaefer/CaseAssistant<br>  Added June 17, 2016<br>  License: [`mpl-2.0`](http://choosealicense.com/licenses/mpl-2.0/)
  <div><img height='300' alt='CaseAssistant image 1' src='http://a3.mzstatic.com/us/r30/Purple1/v4/b2/6c/9c/b26c9cfb-91da-df36-7c08-b9d6b22dae24/screen696x696.jpeg'> <img height='300' alt='CaseAssistant image 2' src='http://a4.mzstatic.com/us/r30/Purple7/v4/f6/37/56/f6375600-df23-5faf-79b0-0214f031d847/screen696x696.jpeg'> <img height='300' alt='CaseAssistant image 3' src='http://a1.mzstatic.com/us/r30/Purple7/v4/96/e7/3b/96e73bf8-a1cf-7b66-d5e6-6829d2a540a6/screen696x696.jpeg'> <img height='300' alt='CaseAssistant image 4' src='http://a3.mzstatic.com/us/r30/Purple7/v4/ce/20/13/ce2013e4-fc70-0b41-718d-c391bb3d9b9e/screen696x696.jpeg'> <img height='300' alt='CaseAssistant image 5' src='http://a1.mzstatic.com/us/r30/Purple1/v4/d4/4b/25/d44b2552-cc5f-3b56-74ac-513ee347da0a/screen696x696.jpeg'> <img height='300' alt='CaseAssistant image 6' src='http://a1.mzstatic.com/us/r30/Purple7/v4/2a/53/4b/2a534b42-ebef-537e-f7ff-9b90ef827922/screen696x696.jpeg'> 
</div>
  </details>

- Depressed: Test if you are depressed [` App Store`](https://itunes.apple.com/app/depressed/id1062594092)  
  <details><summary><code>swift</code> </summary>

  https://github.com/DerLobi/Depressed<br>  Added January 13, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Depressed image 1' src='http://a2.mzstatic.com/us/r30/Purple69/v4/9f/82/17/9f8217e4-00da-b516-1853-23fbc6ecbdaf/screen696x696.jpeg'> <img height='300' alt='Depressed image 2' src='http://a2.mzstatic.com/us/r30/Purple49/v4/c9/cd/e2/c9cde204-5712-97c4-c952-7f0884490153/screen696x696.jpeg'> <img height='300' alt='Depressed image 3' src='http://a3.mzstatic.com/us/r30/Purple49/v4/28/fd/66/28fd66a4-d756-34ce-98f0-aa5dae26ff7d/screen696x696.jpeg'> <img height='300' alt='Depressed image 4' src='http://a5.mzstatic.com/us/r30/Purple69/v4/7e/80/b9/7e80b966-2e41-a36a-a1a3-b02c70ec0961/screen696x696.jpeg'> 
</div>
  </details>

- Glucosio: Diabetes management and research  
  <details><summary><code>swift</code> <code>objc</code> <code>healthkit</code> <code>realm</code> </summary>

  https://github.com/Glucosio/glucosio-ios<br>  Added January 13, 2018<br>  License: [`gpl-3.0`](http://choosealicense.com/licenses/gpl-3.0/)
  </details>

- HealthKit~Swift: Sample app  
  <details><summary><code>swift</code> <code>healthkit</code> </summary>

  https://github.com/Darktt/HealthKit-Swift<br>  Added October 27, 2015<br>  License: `other`
  <div><img height='300' alt='HealthKit~Swift image 1' src='https://i.imgur.com/0pIsqGe.png'> <img height='300' alt='HealthKit~Swift image 2' src='https://i.imgur.com/DbSH2qC.png'> <img height='300' alt='HealthKit~Swift image 3' src='https://i.imgur.com/VIexU8t.png'> <img height='300' alt='HealthKit~Swift image 4' src='https://i.imgur.com/iuiwmyY.png'> 
</div>
  </details>

- Hidrate: Interacts with smart water bottle  
  <details><summary><code>objc</code> </summary>

  https://github.com/mjcuva/Hidrate<br>  Added May  3, 2016<br>  License: `other`
  <div><img height='300' alt='Hidrate image 1' src='https://i.imgur.com/nOAhewe.png'> <img height='300' alt='Hidrate image 2' src='https://i.imgur.com/DmfcHr6.png'> <img height='300' alt='Hidrate image 3' src='https://i.imgur.com/5xlFNzo.png'> <img height='300' alt='Hidrate image 4' src='https://i.imgur.com/mCDJdlD.png'> 
</div>
  </details>

- MyWeight History: Body mass tracker with easy data input & access to history [` App Store`](https://itunes.apple.com/app/myweight-history/id1098061879)  
  <details><summary><code>swift</code> </summary>

  https://github.com/diogot/MyWeight<br>  Added June 12, 2017<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='MyWeight History image 1' src='http://a1.mzstatic.com/us/r30/Purple122/v4/2d/28/8c/2d288c05-33f0-1f18-b06a-4e3a24e1d608/screen696x696.jpeg'> 
</div>
  </details>


### Fitness 
 
[back to top](#readme) 
 
- Jim: Track your gym workouts  
  <details><summary><code>swift</code> <code>parse</code> </summary>

  https://github.com/kylejm/Jim<br>  Added January  4, 2016<br>  License: `other`
  </details>

- LogU: Simple logging app for strength athletes [` App Store`](https://itunes.apple.com/app/logu-a-strength-logger/id1084487510)  
  <details><summary><code>swift</code> </summary>

  https://github.com/brettalcox/logU-swift<br>  Added April 11, 2016<br>  License: `other`
  <div><img height='300' alt='LogU image 1' src='http://a3.mzstatic.com/us/r30/Purple69/v4/3b/93/e1/3b93e16c-298e-0f9d-2339-e81e8ec73d8a/screen696x696.jpeg'> <img height='300' alt='LogU image 2' src='http://a4.mzstatic.com/us/r30/Purple69/v4/a5/0a/d9/a50ad971-6053-f4c4-2dc1-23efc843a207/screen696x696.jpeg'> <img height='300' alt='LogU image 3' src='http://a3.mzstatic.com/us/r30/Purple49/v4/2f/21/50/2f21504e-ebc3-5ea9-77c9-b6d940fc7d6d/screen696x696.jpeg'> <img height='300' alt='LogU image 4' src='http://a2.mzstatic.com/us/r30/Purple69/v4/4e/8c/a1/4e8ca167-df01-5d8f-ca5e-f0458099e0dc/screen696x696.jpeg'> <img height='300' alt='LogU image 5' src='http://a5.mzstatic.com/us/r30/Purple69/v4/c9/53/9b/c9539bcd-3064-bdab-0192-6d82a785a458/screen696x696.jpeg'> 
</div>
  </details>

- RaceMe: Run tracking & ghosting  
  <details><summary><code>swift</code> <code>parse</code> 🔥🔥🔥</summary>

  https://github.com/enochng1/RaceMe<br>  Added July 20, 2016<br>  License: `other`
  <div><img height='300' alt='RaceMe image 1' src='https://raw.githubusercontent.com/enochng1/RaceMe/master/raceMeGitImage.png'> 
</div>
  </details>

- rTracker: A generic, customizable personal data tracker [` App Store`](https://itunes.apple.com/app/rtracker-track-it-all-your-way/id486541371)  
  <details><summary><code>objc</code> </summary>

  https://github.com/rob-miller/rTracker<br>  Added April 19, 2016<br>  License: [`apache-2.0`](http://choosealicense.com/licenses/apache-2.0/)
  <div><img height='300' alt='rTracker image 1' src='http://a1.mzstatic.com/us/r30/Purple3/v4/00/c2/36/00c236fe-5e93-7c98-33d6-f228d4d86f47/screen696x696.jpeg'> <img height='300' alt='rTracker image 2' src='http://a4.mzstatic.com/us/r30/Purple3/v4/61/a4/7a/61a47a57-36e3-8c79-6d5e-4664d83734b7/screen696x696.jpeg'> <img height='300' alt='rTracker image 3' src='http://a1.mzstatic.com/us/r30/Purple3/v4/32/9c/a7/329ca79e-eaba-f25f-cd5c-43ab865834e6/screen696x696.jpeg'> <img height='300' alt='rTracker image 4' src='http://a5.mzstatic.com/us/r30/Purple5/v4/be/b1/56/beb15613-dc36-6ded-9aa5-148667b866f8/screen696x696.jpeg'> <img height='300' alt='rTracker image 5' src='http://a4.mzstatic.com/us/r30/Purple5/v4/74/ff/c8/74ffc84a-8d27-62bd-7f23-c9eb9e60944c/screen696x696.jpeg'> 
</div>
  </details>

- Swift-Walk-Tracker: Track your walks  
  <details><summary><code>swift</code> 🔥</summary>

  https://github.com/kevinvanderlugt/Swift-Walk-Tracker<br>  Added June  7, 2015<br>  License: `other`
  <div><img height='300' alt='Swift-Walk-Tracker image 1' src='https://github.com/kevinvanderlugt/Swift-Walk-Tracker/raw/master/images/screenshot_map.PNG'> <img height='300' alt='Swift-Walk-Tracker image 2' src='https://github.com/kevinvanderlugt/Swift-Walk-Tracker/raw/master/images/screenshot_list.PNG'> 
</div>
  </details>

- Theseus: Personal analytics app  
  <details><summary><code>objc</code> 🔥🔥🔥</summary>

  https://github.com/lazerwalker/Theseus<br>  Added April  1, 2015<br>  License: [`gpl-2.0`](http://choosealicense.com/licenses/gpl-2.0/)
  <div><img height='300' alt='Theseus image 1' src='https://raw.githubusercontent.com/lazerwalker/Theseus/master/ReadmeImages/triptych.png'> 
</div>
  </details>


### ResearchKit 
 
https://www.apple.com/researchkit/ — [back to top](#readme) 
 
- AlzPrevent: Clinical research platform for Alzheimer's disease [` App Store`](https://itunes.apple.com/app/alzprevent/id1065403320)  
  <details><summary><code>swift</code> </summary>

  https://github.com/BBBInc/AlzPrevent-ios<br>  Added August  2, 2016<br>  License: [`bsd-3-clause`](http://choosealicense.com/licenses/bsd-3-clause/)
  <div><img height='300' alt='AlzPrevent image 1' src='http://a1.mzstatic.com/us/r30/Purple49/v4/a3/ae/9e/a3ae9e2a-6586-5f76-2ff7-6373a7a40d9f/screen696x696.jpeg'> <img height='300' alt='AlzPrevent image 2' src='http://a3.mzstatic.com/us/r30/Purple69/v4/52/2b/46/522b460b-ac91-ee2e-de45-a17d2947f00b/screen696x696.jpeg'> <img height='300' alt='AlzPrevent image 3' src='http://a1.mzstatic.com/us/r30/Purple49/v4/1f/5e/0a/1f5e0a2a-5b04-7ffc-9dca-e373ba2deb4b/screen696x696.jpeg'> <img height='300' alt='AlzPrevent image 4' src='http://a3.mzstatic.com/us/r30/Purple49/v4/7c/f8/36/7cf8369a-56a5-b59c-3a65-763cd468740b/screen696x696.jpeg'> <img height='300' alt='AlzPrevent image 5' src='http://a1.mzstatic.com/us/r30/Purple69/v4/19/70/ee/1970eed8-6dea-c646-a99a-bb4752ab2339/screen696x696.jpeg'> 
</div>
  </details>

- AsthmaHealth: Asthma study  
  <details><summary><code>objc</code> </summary>

  https://github.com/ResearchKit/AsthmaHealth<br>  Added April 14, 2015<br>  License: [`bsd-3-clause`](http://choosealicense.com/licenses/bsd-3-clause/)
  <div><img height='300' alt='AsthmaHealth image 1' src='http://a3.mzstatic.com/us/r30/Purple69/v4/34/15/aa/3415aab3-bb08-71df-35be-156f803e04a8/screen696x696.jpeg'> <img height='300' alt='AsthmaHealth image 2' src='http://a2.mzstatic.com/us/r30/Purple69/v4/6f/81/89/6f81894e-754b-3056-12a3-81f0e4c6e239/screen696x696.jpeg'> <img height='300' alt='AsthmaHealth image 3' src='http://a5.mzstatic.com/us/r30/Purple69/v4/f8/49/97/f8499754-0be4-eb3c-f9e3-ffa9c5c6345c/screen696x696.jpeg'> <img height='300' alt='AsthmaHealth image 4' src='http://a5.mzstatic.com/us/r30/Purple49/v4/c9/d6/1f/c9d61f44-4ae5-5181-5052-bb1e1821a895/screen696x696.jpeg'> <img height='300' alt='AsthmaHealth image 5' src='http://a4.mzstatic.com/us/r30/Purple69/v4/62/35/cf/6235cf12-7979-ab53-2b97-14062bdc44fc/screen696x696.jpeg'> <img height='300' alt='AsthmaHealth image 6' src='http://a3.mzstatic.com/us/r30/Purple69/v4/05/86/f8/0586f8fd-b7f5-30a5-694f-bd38e2454edc/screen696x696.jpeg'> 
</div>
  </details>

- Colorblind: Easy test for colorblind people  
  <details><summary><code>swift</code> </summary>

  https://github.com/boostcode/ResearchKit-ColorBlind<br>  Added May 18, 2016<br>  License: `other`
  <div><img height='300' alt='Colorblind image 1' src='http://a2.mzstatic.com/us/r30/Purple49/v4/70/f7/85/70f78511-8bc9-7151-2a5a-b057d24a91e5/screen696x696.jpeg'> <img height='300' alt='Colorblind image 2' src='http://a3.mzstatic.com/us/r30/Purple49/v4/c5/b3/cb/c5b3cb07-fdd8-ed26-db4a-263bbb8765d9/screen696x696.jpeg'> <img height='300' alt='Colorblind image 3' src='http://a5.mzstatic.com/us/r30/Purple49/v4/b3/cb/71/b3cb710e-b4de-adc5-2369-cfb46a2ef0a8/screen696x696.jpeg'> 
</div>
  </details>

- GlucoSuccess: Diabetes study  
  <details><summary><code>objc</code> </summary>

  https://github.com/ResearchKit/GlucoSuccess<br>  Added April 15, 2015<br>  License: [`bsd-3-clause`](http://choosealicense.com/licenses/bsd-3-clause/)
  <div><img height='300' alt='GlucoSuccess image 1' src='http://a4.mzstatic.com/us/r30/Purple3/v4/01/45/a4/0145a41a-cad3-58b3-6db9-20d72bc2b595/screen696x696.jpeg'> <img height='300' alt='GlucoSuccess image 2' src='http://a2.mzstatic.com/us/r30/Purple5/v4/9e/40/f3/9e40f3d1-90dd-ba6a-c680-9543544b4e41/screen696x696.jpeg'> <img height='300' alt='GlucoSuccess image 3' src='http://a1.mzstatic.com/us/r30/Purple3/v4/bb/e2/e1/bbe2e151-2884-fdf6-ba9d-5aaa76baf876/screen696x696.jpeg'> <img height='300' alt='GlucoSuccess image 4' src='http://a3.mzstatic.com/us/r30/Purple5/v4/61/8f/72/618f7292-b0e1-48b7-040f-05b91420d745/screen696x696.jpeg'> <img height='300' alt='GlucoSuccess image 5' src='http://a4.mzstatic.com/us/r30/Purple3/v4/e2/d8/c2/e2d8c2e8-f8f3-dec5-03c9-e662d10b4d69/screen696x696.jpeg'> <img height='300' alt='GlucoSuccess image 6' src='http://a3.mzstatic.com/us/r30/Purple5/v4/e7/4b/80/e74b80fd-e9db-3a24-83af-753964ab8288/screen696x696.jpeg'> 
</div>
  </details>

- mPower: Parkinson's disease study [` App Store`](https://itunes.apple.com/app/parkinson-mpower-study-app/id972191200)  
  <details><summary><code>objc</code> </summary>

  https://github.com/ResearchKit/mPower<br>  Added April 15, 2015<br>  License: [`bsd-3-clause`](http://choosealicense.com/licenses/bsd-3-clause/)
  <div><img height='300' alt='mPower image 1' src='http://a4.mzstatic.com/us/r30/Purple69/v4/29/a9/f8/29a9f8e0-8c4e-2e07-46c7-2f0034ee9eb3/screen696x696.jpeg'> <img height='300' alt='mPower image 2' src='http://a4.mzstatic.com/us/r30/Purple49/v4/ea/1f/46/ea1f46f8-f539-0bcb-348f-66721384daa7/screen696x696.jpeg'> <img height='300' alt='mPower image 3' src='http://a5.mzstatic.com/us/r30/Purple49/v4/a9/91/c5/a991c55e-a298-217d-c8c6-e420409f00cb/screen696x696.jpeg'> <img height='300' alt='mPower image 4' src='http://a4.mzstatic.com/us/r30/Purple69/v4/00/a5/3e/00a53e69-ae5b-130c-941f-618474ca0911/screen696x696.jpeg'> <img height='300' alt='mPower image 5' src='http://a2.mzstatic.com/us/r30/Purple49/v4/83/1c/ce/831cce21-8d46-cb68-6d00-76570ed44a1e/screen696x696.jpeg'> 
</div>
  </details>

- MyHeartCounts: Personalized tool that can help you measure daily activity, fitness, & cardiovascular risk [` App Store`](https://itunes.apple.com/app/id972189947)  
  <details><summary><code>objc</code> </summary>

  https://github.com/ResearchKit/MyHeartCounts<br>  Added October 27, 2015<br>  License: [`bsd-3-clause`](http://choosealicense.com/licenses/bsd-3-clause/)
  <div><img height='300' alt='MyHeartCounts image 1' src='http://a2.mzstatic.com/us/r30/Purple60/v4/cf/70/57/cf7057e9-d9e7-4073-cd48-5a3bcabaaa25/screen696x696.jpeg'> <img height='300' alt='MyHeartCounts image 2' src='http://a1.mzstatic.com/us/r30/Purple60/v4/ad/ad/55/adad5549-b6d5-1973-3e45-4c742a3875da/screen696x696.jpeg'> <img height='300' alt='MyHeartCounts image 3' src='http://a3.mzstatic.com/us/r30/Purple60/v4/2b/b0/64/2bb06441-1deb-8709-646d-1ce80b1a1253/screen696x696.jpeg'> <img height='300' alt='MyHeartCounts image 4' src='http://a3.mzstatic.com/us/r30/Purple60/v4/fe/ee/f2/feeef2b4-e4ff-e1c1-0707-404578c628b0/screen696x696.jpeg'> 
</div>
  </details>

- Share The Journey: Breast cancer study  
  <details><summary><code>objc</code> </summary>

  https://github.com/ResearchKit/ShareTheJourney<br>  Added April 15, 2015<br>  License: [`bsd-3-clause`](http://choosealicense.com/licenses/bsd-3-clause/)
  <div>
</div>
  </details>


## Keyboard 
 
[back to top](#readme) 
 
- AA-Keyboard: ASCII art keyboard [` App Store`](https://itunes.apple.com/app/aa-keyboard/id964182815)  
  <details><summary><code>objc</code> 🔥</summary>

  https://github.com/sonsongithub/AAKeyboard<br>  Added July  1, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='AA-Keyboard image 1' src='http://a5.mzstatic.com/us/r30/Purple6/v4/28/59/25/285925a7-b4c8-0042-d59c-5ac9ae854189/screen696x696.jpeg'> <img height='300' alt='AA-Keyboard image 2' src='http://a4.mzstatic.com/us/r30/Purple3/v4/9f/aa/14/9faa14df-83e2-1503-67e1-d482539dca69/screen696x696.jpeg'> 
</div>
  </details>

- Link Keyboard : My Links Everywhere: Put all your links in one place & make them accessible with a keyboard. [` App Store`](https://itunes.apple.com/app/link-keyboard-my-links-everywhere/id1098798450)  
  <details><summary><code>swift</code> </summary>

  https://github.com/ayushgoel/LinkKeyboard<br>  Added October 20, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Link Keyboard : My Links Everywhere image 1' src='http://a2.mzstatic.com/us/r30/Purple60/v4/d3/4a/5d/d34a5d0e-45f0-6605-aca6-0b86c169f6a8/screen696x696.jpeg'> <img height='300' alt='Link Keyboard : My Links Everywhere image 2' src='http://a3.mzstatic.com/us/r30/Purple30/v4/56/d8/5d/56d85d95-eafa-f347-31b5-0c4b0a17bcc9/screen696x696.jpeg'> <img height='300' alt='Link Keyboard : My Links Everywhere image 3' src='http://a5.mzstatic.com/us/r30/Purple30/v4/70/59/11/705911ee-338a-4154-6074-62c8ba5998ac/screen696x696.jpeg'> <img height='300' alt='Link Keyboard : My Links Everywhere image 4' src='http://a3.mzstatic.com/us/r30/Purple20/v4/23/d1/bb/23d1bb47-6aac-a6e5-4575-e8639d188af7/screen696x696.jpeg'> <img height='300' alt='Link Keyboard : My Links Everywhere image 5' src='http://a5.mzstatic.com/us/r30/Purple30/v4/e3/b3/98/e3b398e1-da5e-404a-067e-613a625abe1a/screen696x696.jpeg'> 
</div>
  </details>

- Slidden: Customizable keyboard  
  <details><summary><code>objc</code> 🔥🔥🔥</summary>

  https://github.com/Brimizer/Slidden<br>  Added November 24, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Slidden image 1' src='https://github.com/Brimizer/Slidden/raw/master/assets/screenshot.png'> 
</div>
  </details>


## Location 
 
[back to top](#readme) 
 
- AirCheck: Check air pollution on a map  
  <details><summary><code>swift</code> <code>mapbox</code> <code>pop</code> <code>swiftyjson</code> <code>alamofire</code> 🇪🇸 </summary>

  https://github.com/lojals/AirCheck<br>  Added November 18, 2016<br>  License: `other`
  <div><img height='300' alt='AirCheck image 1' src='https://media.giphy.com/media/uSyooIBl2qBHi/giphy.gif'> 
</div>
  </details>

- Alarm: Geolocation based alarm app for travelers  
  <details><summary><code>swift</code> 🔥</summary>

  https://github.com/ChrisChares/swift-alarm<br>  Added March 27, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  </details>

- Cepp: Find information on addresses  
  <details><summary><code>swift</code> <code>afnetworking</code> 🇵🇹 </summary>

  https://github.com/filipealva/Cepp<br>  Added November  4, 2016<br>  License: `other`
  <div><img height='300' alt='Cepp image 1' src='https://raw.githubusercontent.com/filipealva/Cepp/res/searchi5.png'> <img height='300' alt='Cepp image 2' src='https://raw.githubusercontent.com/filipealva/Cepp/res/detailsi5.png'> 
</div>
  </details>

- Compass: Minimal compass [` App Store`](https://itunes.apple.com/app/compass-a-minimal-compass-app/id1231545538)  
  <details><summary><code>swift</code> </summary>

  https://github.com/zntfdr/Compass<br>  Added May 12, 2017<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Compass image 1' src='http://a5.mzstatic.com/us/r30/Purple122/v4/ea/60/8e/ea608e2a-a471-11d8-1801-e621ad8ed651/screen696x696.jpeg'> 
</div>
  </details>

- CrimeMapper: Look at crime data in the UK [` App Store`](https://itunes.apple.com/app/crimemapper/id1212133404)  
  <details><summary><code>swift</code> </summary>

  https://github.com/swwol/CrimeMapper<br>  https://samwoolf.net<br>  Added April  6, 2017<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='CrimeMapper image 1' src='http://samwoolf.net/wp-content/uploads/2017/03/crimemapper1a-1.jpg'> <img height='300' alt='CrimeMapper image 2' src='http://samwoolf.net/wp-content/uploads/2017/03/crimemapper2a.jpg'> <img height='300' alt='CrimeMapper image 3' src='http://samwoolf.net/wp-content/uploads/2017/03/crimemapper3a.jpg'> <img height='300' alt='CrimeMapper image 4' src='http://samwoolf.net/wp-content/uploads/2017/03/crimemapper4a.jpg'> <img height='300' alt='CrimeMapper image 5' src='http://samwoolf.net/wp-content/uploads/2017/03/crimemapper5a.jpg'> 
</div>
  </details>

- DoctorNearby: Helps you find doctors in your city  
  <details><summary><code>objc</code> </summary>

  https://github.com/vincezzh/doctornearby-ios<br>  Added July 14, 2016<br>  License: `other`
  <div><img height='300' alt='DoctorNearby image 1' src='http://a3.mzstatic.com/us/r30/Purple69/v4/91/75/58/9175587b-c43c-f330-342e-da05235719c0/screen696x696.jpeg'> <img height='300' alt='DoctorNearby image 2' src='http://a3.mzstatic.com/us/r30/Purple69/v4/58/10/27/58102772-bd0a-fde4-3525-01e4f35c132e/screen696x696.jpeg'> <img height='300' alt='DoctorNearby image 3' src='http://a3.mzstatic.com/us/r30/Purple69/v4/d5/90/e9/d590e967-8355-db00-03a6-1adf8bccc298/screen696x696.jpeg'> <img height='300' alt='DoctorNearby image 4' src='http://a3.mzstatic.com/us/r30/Purple49/v4/de/d2/b5/ded2b5b4-9414-c195-40da-36335d961d2e/screen696x696.jpeg'> <img height='300' alt='DoctorNearby image 5' src='http://a4.mzstatic.com/us/r30/Purple69/v4/02/3e/29/023e2983-bb73-dc0b-a541-7887704e4fac/screen696x696.jpeg'> 
</div>
  </details>

- Doppio: Finds the nearest Starbucks  
  <details><summary><code>objc</code> 🔥🔥🔥</summary>

  https://github.com/chroman/Doppio<br>  https://imgur.com/a/ges5M<br>  Added March  5, 2016<br>  License: [`bsd-2-clause`](http://choosealicense.com/licenses/bsd-2-clause/)
  <div><img height='300' alt='Doppio image 1' src='https://i.imgur.com/2ZG08AX.png'> <img height='300' alt='Doppio image 2' src='https://i.imgur.com/PDUUWTj.png'> 
</div>
  </details>

- EatNow: Get recommendations for restaurants nearby [` App Store`](https://itunes.apple.com/app/eat-now-instant-personalized/id946591471)  
  <details><summary><code>objc</code> </summary>

  https://github.com/callzhang/Eat-Now<br>  Added October 19, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='EatNow image 1' src='http://a1.mzstatic.com/us/r30/Purple7/v4/e0/65/ca/e065caa7-e2be-1e25-f78a-ccb19a7cf1b0/screen696x696.jpeg'> <img height='300' alt='EatNow image 2' src='http://a4.mzstatic.com/us/r30/Purple7/v4/d4/bf/20/d4bf20c6-8dc8-0739-9977-1a8c3f2f7052/screen696x696.jpeg'> <img height='300' alt='EatNow image 3' src='http://a4.mzstatic.com/us/r30/Purple1/v4/15/60/8d/15608d60-d7c0-2dfb-e89a-97c49573fd75/screen696x696.jpeg'> <img height='300' alt='EatNow image 4' src='http://a5.mzstatic.com/us/r30/Purple1/v4/b2/36/fb/b236fba1-3e84-c6a4-c186-8b73abca6109/screen696x696.jpeg'> <img height='300' alt='EatNow image 5' src='http://a5.mzstatic.com/us/r30/Purple2/v4/1c/d0/2d/1cd02d13-9d9c-d115-1605-3fb4dae72831/screen696x696.jpeg'> 
</div>
  </details>

- Find My Bus NJ: Track NJ Transit bus times  
  <details><summary><code>swift</code> </summary>

  https://github.com/findmybusnj/findmybusnj-swift<br>  Added July 13, 2016<br>  License: [`gpl-3.0`](http://choosealicense.com/licenses/gpl-3.0/)
  <div><img height='300' alt='Find My Bus NJ image 1' src='https://github.com/findmybusnj/findmybusnj-swift/raw/master/README_banner.png'> 
</div>
  </details>

- GeoTappy: Share your location  
  <details><summary><code>objc</code> </summary>

  https://github.com/GeoTappy/GeoTappy-iOS<br>  Added April 14, 2015<br>  License: [`apache-2.0`](http://choosealicense.com/licenses/apache-2.0/)
  <div><img height='300' alt='GeoTappy image 1' src='https://i.imgur.com/FWj32S0.png'> <img height='300' alt='GeoTappy image 2' src='https://i.imgur.com/IyfFdCc.png'> 
</div>
  </details>

- Grove: Crowd-sourced hammock locations  
  <details><summary><code>swift</code> <code>alamofire</code> <code>realm</code> <code>swiftybeaver</code> <code>kingfisher</code> <code>asyncswift</code> </summary>

  https://github.com/kylebshr/grove-ios<br>  Added October 17, 2016<br>  License: `other`
  <div><img height='300' alt='Grove image 1' src='https://github.com/kylebshr/grove-ios/blob/master/External%20Assets/Original%20Screenshots/Screenshot%201.png?raw=true'> 
</div>
  </details>

- HopperBus: Timetable for the University of Nottingham Hopper Bus  
  <details><summary><code>swift</code> </summary>

  https://github.com/TosinAF/HopperBus-iOS<br>  Added January 22, 2016<br>  License: `other`
  <div><img height='300' alt='HopperBus image 1' src='https://raw.githubusercontent.com/TosinAF/HopperBus-iOS/master/Screenshots/RouteView.png'> <img height='300' alt='HopperBus image 2' src='https://raw.githubusercontent.com/TosinAF/HopperBus-iOS/master/Screenshots/RealTimeView.png'> <img height='300' alt='HopperBus image 3' src='https://raw.githubusercontent.com/TosinAF/HopperBus-iOS/master/Screenshots/RouteTimesView.png'> <img height='300' alt='HopperBus image 4' src='https://raw.githubusercontent.com/TosinAF/HopperBus-iOS/master/Screenshots/MapView.png'> 
</div>
  </details>

- iPokeGo: Map Pokemon around you! [` App Store`](https://itunes.apple.com/app/ipokego-for-pokemon-go/id1138277066)  
  <details><summary><code>objc</code> 🔥🔥🔥</summary>

  https://github.com/istornz/iPokeGo<br>  Added January 14, 2018<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='iPokeGo image 1' src='https://camo.githubusercontent.com/6181f3576f7c5ffa609bb37883b7a9e584fb27dc/687474703a2f2f64696d697472696465737375732e66722f696d672f69506f6b65476f2f73637265656e73686f74732f69506f6b65476f372e6a7067'> <img height='300' alt='iPokeGo image 2' src='https://camo.githubusercontent.com/43c1514a43761a6ef920bd66fba83f74c029292f/687474703a2f2f64696d697472696465737375732e66722f696d672f69506f6b65476f2f73637265656e73686f74732f69506f6b65476f382e6a7067'> <img height='300' alt='iPokeGo image 3' src='https://camo.githubusercontent.com/175de42215cd8fa04bd5b597a2dfd5f6b8cb0b1b/687474703a2f2f64696d697472696465737375732e66722f696d672f69506f6b65476f2f73637265656e73686f74732f69506f6b65476f332e6a7067'> 
</div>
  </details>

- Locative: Helping you to get the best out of your automated home, geofencing, iBeacons [` App Store`](https://itunes.apple.com/app/locative/id725198453)  
  <details><summary><code>objc</code> 🔥🔥</summary>

  https://github.com/LocativeHQ/Locative-iOS<br>  Added December 21, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Locative image 1' src='http://a4.mzstatic.com/us/r30/Purple22/v4/21/c1/5b/21c15b39-59ac-cb25-0aea-857ada781327/screen696x696.jpeg'> <img height='300' alt='Locative image 2' src='http://a3.mzstatic.com/us/r30/Purple41/v4/e9/2c/30/e92c3020-50f6-3ec9-0f05-93af09dfc536/screen696x696.jpeg'> <img height='300' alt='Locative image 3' src='http://a1.mzstatic.com/us/r30/Purple41/v4/9f/63/01/9f630162-1043-5aec-83f7-38c0a056da9c/screen696x696.jpeg'> <img height='300' alt='Locative image 4' src='http://a1.mzstatic.com/us/r30/Purple71/v4/38/51/6b/38516bb5-8934-1fb6-876a-9b24b3549cb4/screen696x696.jpeg'> <img height='300' alt='Locative image 5' src='http://a3.mzstatic.com/us/r30/Purple62/v4/bc/20/18/bc201818-03fe-d866-a9e0-2fd72085b93a/screen696x696.jpeg'> 
</div>
  </details>

- Lunchify: Find restaurants offering 10€ lunch buffets in Finland  
  <details><summary><code>swift</code> <code>swiftyjson</code> <code>alamofire</code> <code>dznemptydataset</code> </summary>

  https://github.com/sallar/lunchify-swift<br>  Added October 25, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Lunchify image 1' src='http://a2.mzstatic.com/us/r30/Purple49/v4/6a/24/b7/6a24b73c-dc99-d96f-93e8-268f9bb74268/screen696x696.jpeg'> <img height='300' alt='Lunchify image 2' src='http://a5.mzstatic.com/us/r30/Purple49/v4/ad/59/63/ad59636f-7605-60dd-17ac-319075222468/screen696x696.jpeg'> <img height='300' alt='Lunchify image 3' src='http://a3.mzstatic.com/us/r30/Purple49/v4/e5/62/50/e56250a9-07b0-ca33-58e4-33124aff6fab/screen696x696.jpeg'> 
</div>
  </details>

- MAPS.ME: Offline maps app with navigation [` App Store`](https://itunes.apple.com/app/id510623322)  
  <details><summary><code>openstreetmap api</code> 🔥🔥🔥🔥🔥</summary>

  https://github.com/mapsme/omim<br>  https://maps.me/<br>  Added May 31, 2016<br>  License: [`apache-2.0`](http://choosealicense.com/licenses/apache-2.0/)
  <div><img height='300' alt='MAPS.ME image 1' src='http://a3.mzstatic.com/us/r30/Purple71/v4/0b/78/17/0b7817dc-d0d4-d3fe-1a41-a3813f0598eb/screen696x696.jpeg'> <img height='300' alt='MAPS.ME image 2' src='http://a1.mzstatic.com/us/r30/Purple71/v4/31/a1/a8/31a1a87f-2148-223e-369d-00ef3625ae35/screen696x696.jpeg'> <img height='300' alt='MAPS.ME image 3' src='http://a3.mzstatic.com/us/r30/Purple62/v4/ea/4f/7f/ea4f7f30-1268-1437-177e-5bf303e987ab/screen696x696.jpeg'> <img height='300' alt='MAPS.ME image 4' src='http://a5.mzstatic.com/us/r30/Purple62/v4/9c/f7/9a/9cf79aa0-e3a0-b607-88e0-9fa14bc2d609/screen696x696.jpeg'> <img height='300' alt='MAPS.ME image 5' src='http://a3.mzstatic.com/us/r30/Purple71/v4/0b/a9/52/0ba95283-dcac-de78-05d7-7578a5b1760e/screen696x696.jpeg'> 
</div>
  </details>

- Miataru: A location tracking app where data can be shared over public or private servers [` App Store`](https://itunes.apple.com/app/id717539389)  
  <details><summary><code>objc</code> </summary>

  https://github.com/miataru/miataru-ios-client<br>  http://miataru.com/ios/<br>  Added June  2, 2016<br>  License: [`bsd-2-clause`](http://choosealicense.com/licenses/bsd-2-clause/)
  <div><img height='300' alt='Miataru image 1' src='http://a4.mzstatic.com/us/r30/Purple3/v4/b5/19/d4/b519d461-a067-fe54-7996-d599297162e8/screen696x696.jpeg'> <img height='300' alt='Miataru image 2' src='http://a3.mzstatic.com/us/r30/Purple3/v4/ad/1a/ac/ad1aac76-794b-176f-f11a-5c897fb797a5/screen696x696.jpeg'> <img height='300' alt='Miataru image 3' src='http://a2.mzstatic.com/us/r30/Purple1/v4/20/f9/35/20f93531-bb95-4a54-b9a2-0f3a918d9b3e/screen696x696.jpeg'> <img height='300' alt='Miataru image 4' src='http://a4.mzstatic.com/us/r30/Purple3/v4/4d/c6/24/4dc624af-0cae-4e82-427f-b9955221eb3a/screen696x696.jpeg'> <img height='300' alt='Miataru image 5' src='http://a1.mzstatic.com/us/r30/Purple3/v4/c0/3f/16/c03f16fd-f104-d93e-d2f0-ba53283bfdb1/screen696x696.jpeg'> 
</div>
  </details>

- Moves: Visualize where you spend your time  
  <details><summary><code>objc</code> </summary>

  https://github.com/neonichu/Places<br>  Added July 13, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Moves image 1' src='https://github.com/neonichu/Places/raw/master/Screenshots/1.png'> 
</div>
  </details>

- Neverlate: Pay-if-U-R-late app with geofences  
  <details><summary><code>venmo api</code> </summary>

  https://github.com/ayunav/Neverlate<br>  Added May 27, 2016<br>  License: `other`
  <div><img height='300' alt='Neverlate image 1' src='https://github.com/ayunav/Neverlate/raw/master/NeverlateDemo.gif'> 
</div>
  </details>

- OneBusAway: Real-time arrival & schedule information for public transit in Seattle, Atlanta, Tampa, & more [` App Store`](https://itunes.apple.com/app/onebusaway/id329380089)  
  <details><summary><code>objc</code> 🔥</summary>

  https://github.com/OneBusAway/onebusaway-iphone<br>  Added August 21, 2015<br>  License: [`apache-2.0`](http://choosealicense.com/licenses/apache-2.0/)
  <div><img height='300' alt='OneBusAway image 1' src='http://a1.mzstatic.com/us/r30/Purple71/v4/6a/58/76/6a587632-97c9-1633-a5f1-c2dd09171bd8/screen696x696.jpeg'> <img height='300' alt='OneBusAway image 2' src='http://a4.mzstatic.com/us/r30/Purple71/v4/5c/74/ce/5c74ce0a-a6ef-8aab-5f00-9e6e69abeec2/screen696x696.jpeg'> <img height='300' alt='OneBusAway image 3' src='http://a5.mzstatic.com/us/r30/Purple71/v4/b4/d2/2e/b4d22e1e-13b7-1bbc-740d-82efc6d5e938/screen696x696.jpeg'> <img height='300' alt='OneBusAway image 4' src='http://a3.mzstatic.com/us/r30/Purple62/v4/0f/83/1c/0f831cde-e597-8ea4-372c-9ee43c0e7330/screen696x696.jpeg'> <img height='300' alt='OneBusAway image 5' src='http://a2.mzstatic.com/us/r30/Purple71/v4/6a/e9/c9/6ae9c98a-366e-084a-b674-b4003e3d44e9/screen696x696.jpeg'> 
</div>
  </details>

- OpenStreetView: Collect OpenStreetView data [` App Store`](https://itunes.apple.com/app/openstreetview/id1089548849)  
  <details><summary><code>objc</code> </summary>

  https://github.com/openstreetcam/ios<br>  http://openstreetview.org<br>  Added August 21, 2016<br>  License: [`gpl-3.0`](http://choosealicense.com/licenses/gpl-3.0/)
  <div><img height='300' alt='OpenStreetView image 1' src='http://a5.mzstatic.com/us/r30/Purple30/v4/b5/9f/0f/b59f0f32-eec9-7612-ad5f-4a545561c2cf/screen696x696.jpeg'> 
</div>
  </details>

- OsmAnd Maps: A map app with access to OpenStreetMaps [` App Store`](https://itunes.apple.com/app/id934850257)  
  <details><summary><code>objc</code> 🔥🔥🔥🔥</summary>

  https://github.com/osmandapp/Osmand<br>  http://osmand.net/<br>  Added June  1, 2016<br>  License: [`gpl-3.0`](http://choosealicense.com/licenses/gpl-3.0/)
  <div><img height='300' alt='OsmAnd Maps image 1' src='http://a4.mzstatic.com/us/r30/Purple62/v4/6e/66/38/6e66384e-1493-1fef-bf4a-b46a32ce6add/screen696x696.jpeg'> <img height='300' alt='OsmAnd Maps image 2' src='http://a2.mzstatic.com/us/r30/Purple71/v4/10/4c/29/104c294c-1adc-93c3-bde8-ca50ce97eb04/screen696x696.jpeg'> <img height='300' alt='OsmAnd Maps image 3' src='http://a3.mzstatic.com/us/r30/Purple71/v4/c2/63/b5/c263b598-22ea-ee5e-5b0a-c2a6bf6b3215/screen696x696.jpeg'> <img height='300' alt='OsmAnd Maps image 4' src='http://a3.mzstatic.com/us/r30/Purple62/v4/d0/91/4b/d0914b8b-1908-fc6a-e7b5-59955a41c482/screen696x696.jpeg'> <img height='300' alt='OsmAnd Maps image 5' src='http://a2.mzstatic.com/us/r30/Purple71/v4/e5/7e/dc/e57edc40-d4b6-6f2c-3205-8dac724e325a/screen696x696.jpeg'> 
</div>
  </details>

- OwnTracks: Keep track of your own location, you can build your private location diary or share it with your family & friends [` App Store`](https://itunes.apple.com/app/mqttitude/id692424691)  
  <details><summary><code>cocoalumberjack</code> 🔥</summary>

  https://github.com/owntracks/ios<br>  Added April  3, 2016<br>  License: `other`
  <div><img height='300' alt='OwnTracks image 1' src='http://a4.mzstatic.com/us/r30/Purple69/v4/c1/6b/39/c16b39c0-da01-94b0-6a59-89d134a79d61/screen520x924.jpeg'> 
</div>
  </details>

- ParkenDD: Check the status of several public parking lots in Germany & Switzerland [` App Store`](https://itunes.apple.com/app/parkendd/id957165041)  
  <details><summary><code>swift</code> </summary>

  https://github.com/kiliankoe/ParkenDD<br>  Added April 25, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='ParkenDD image 1' src='http://a5.mzstatic.com/us/r30/Purple42/v4/2d/d5/6e/2dd56eb7-9c19-0d14-371b-08a6f6bcba9f/screen696x696.jpeg'> <img height='300' alt='ParkenDD image 2' src='http://a5.mzstatic.com/us/r30/Purple41/v4/2a/78/f9/2a78f92a-111f-24e9-e8a7-9acef35007db/screen696x696.jpeg'> <img height='300' alt='ParkenDD image 3' src='http://a3.mzstatic.com/us/r30/Purple19/v4/74/7d/12/747d12d0-1e24-2156-1cb0-6a9296556440/screen696x696.jpeg'> 
</div>
  </details>

- PebCiti: Pebble app to show nearest CitiBike NYC dock  
  <details><summary><code>objc</code> </summary>

  https://github.com/joemasilotti/PebCiti<br>  Added May  5, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='PebCiti image 1' src='https://raw.githubusercontent.com/joemasilotti/PebCiti/master/Screenshots/iOS.png'> 
</div>
  </details>

- Prey: Track lost or stolen devices & perform actions remotely [` App Store`](https://itunes.apple.com/app/id456755037)  
  <details><summary><code>objc</code> 🔥🔥</summary>

  https://github.com/prey/prey-ios-client<br>  https://preyproject.com/<br>  Added June  1, 2016<br>  License: [`gpl-3.0`](http://choosealicense.com/licenses/gpl-3.0/)
  <div><img height='300' alt='Prey image 1' src='http://a3.mzstatic.com/us/r30/Purple62/v4/43/f7/91/43f791d0-319a-2e3f-449a-2471e240b068/screen696x696.jpeg'> <img height='300' alt='Prey image 2' src='http://a5.mzstatic.com/us/r30/Purple62/v4/c3/f9/ba/c3f9ba54-b8df-10bc-e2e0-ea6b1a736d91/screen696x696.jpeg'> <img height='300' alt='Prey image 3' src='http://a2.mzstatic.com/us/r30/Purple62/v4/e3/96/3e/e3963e31-b683-16c2-cc94-4768fe16020a/screen696x696.jpeg'> <img height='300' alt='Prey image 4' src='http://a4.mzstatic.com/us/r30/Purple71/v4/d6/af/c3/d6afc340-1972-af85-053b-8e52ed5a4588/screen696x696.jpeg'> <img height='300' alt='Prey image 5' src='http://a1.mzstatic.com/us/r30/Purple62/v4/f3/50/71/f35071d7-9fa9-1bf9-fa91-2641458bcd1e/screen696x696.jpeg'> 
</div>
  </details>

- Prey: Track lost or stolen devices & perform actions remotely  
  <details><summary><code>swift</code> </summary>

  https://github.com/prey/prey-swift-client<br>  https://preyproject.com/<br>  Added June  1, 2016<br>  License: [`gpl-3.0`](http://choosealicense.com/licenses/gpl-3.0/)
  <div><img height='300' alt='Prey image 1' src='https://preyproject.com/img/home/report-simple-2.png'> 
</div>
  </details>

- S.I.T. (雕刻时光): An app for Chinese cafe chain Diaokeshiguang (Sit Coffee) [` App Store`](https://itunes.apple.com/app/diao-ke-shi-guang/id440983941)  
  <details><summary><code>objc</code> 🇨🇳 </summary>

  https://github.com/flexih/Cafe<br>  Added April 15, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='S.I.T. (雕刻时光) image 1' src='https://github.com/flexih/Cafe/raw/master/snapshot/1.png'> 
</div>
  </details>

- Santa Tracker  
  <details><summary><code>swift</code> <code>realm</code> </summary>

  https://github.com/keitaito/RealmSantaTracker<br>  Added May 16, 2017<br>  License: `other`
  <div><img height='300' alt='Santa Tracker image 1' src='http://images.contentful.com/emmiduwd41v7/1TmcZsJy7Si4qCYm24aAse/158d511e7e58461d64cf902fb5a26d32/santa-app-final.png'> 
</div>
  </details>

- Startups - Mapped In Israel: Discover new startups & locate co-working spaces  
  <details><summary><code>objc</code> </summary>

  https://github.com/sugarso/MappedInIsrael<br>  Added April  6, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Startups - Mapped In Israel image 1' src='https://i.imgur.com/vSyWHSA.png'> <img height='300' alt='Startups - Mapped In Israel image 2' src='https://i.imgur.com/WJbZSB6.png'> <img height='300' alt='Startups - Mapped In Israel image 3' src='https://i.imgur.com/fTlosLW.png'> <img height='300' alt='Startups - Mapped In Israel image 4' src='https://i.imgur.com/eTnGn5F.png'> 
</div>
  </details>

- tpg offline: Navigate the Geneva public transport [` App Store`](https://itunes.apple.com/app/tpg-offline/id1001560047)  
  <details><summary><code>swift</code> <code>carthage</code> <code>alamofire</code> <code>locationmanager</code> 🇫🇷 </summary>

  https://github.com/RemyDCF/tpg-offline<br>  Added October 14, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='tpg offline image 1' src='http://is5.mzstatic.com/image/thumb/Purple118/v4/89/93/38/8993388e-d712-f774-f418-a3662a60aef1/source/392x696bb.jpg'> 
</div>
  </details>

- Traccar Client: Report device location to the server [` App Store`](https://itunes.apple.com/us/app/traccar-client/id843156974)  
  <details><summary><code>objc</code> </summary>

  https://github.com/tananaev/traccar-client-ios<br>  Added July 12, 2016<br>  License: [`apache-2.0`](http://choosealicense.com/licenses/apache-2.0/)
  <div><img height='300' alt='Traccar Client image 1' src='http://a5.mzstatic.com/us/r30/Purple3/v4/6c/6b/d6/6c6bd694-0715-d363-9a3b-ed27dbdaa0b9/screen696x696.jpeg'> 
</div>
  </details>

- Traccar Manager: Track GPS devices on a map [` App Store`](https://itunes.apple.com/us/app/traccar-manager/id1113966562)  
  <details><summary><code>objc</code> </summary>

  https://github.com/tananaev/traccar-manager-ios<br>  Added July 12, 2016<br>  License: [`apache-2.0`](http://choosealicense.com/licenses/apache-2.0/)
  <div><img height='300' alt='Traccar Manager image 1' src='http://a5.mzstatic.com/us/r30/Purple30/v4/26/e7/f5/26e7f5cc-f421-146b-0d05-a81733e58807/screen696x696.jpeg'> <img height='300' alt='Traccar Manager image 2' src='http://a5.mzstatic.com/us/r30/Purple60/v4/62/5a/c4/625ac44e-2bb5-6f2b-044c-592e818054d3/screen696x696.jpeg'> 
</div>
  </details>

- VisitBCN: City guide for Barcelona [` App Store`](https://itunes.apple.com/app/visitbcn/id904676442)  
  <details><summary><code>objc</code> </summary>

  https://github.com/maurovc/visitBCN<br>  Added March 16, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='VisitBCN image 1' src='http://a4.mzstatic.com/us/r30/Purple1/v4/9c/1c/ab/9c1cab42-c51f-6ba6-2838-6871f5e70e9d/screen696x696.jpeg'> <img height='300' alt='VisitBCN image 2' src='http://a3.mzstatic.com/us/r30/Purple3/v4/85/ed/b9/85edb904-5006-7ea4-4eb9-3f2324fb2ce8/screen696x696.jpeg'> <img height='300' alt='VisitBCN image 3' src='http://a5.mzstatic.com/us/r30/Purple3/v4/12/f0/58/12f05837-5cdb-8b8e-7e7a-b96577f138c3/screen696x696.jpeg'> <img height='300' alt='VisitBCN image 4' src='http://a1.mzstatic.com/us/r30/Purple1/v4/49/31/7a/49317ad1-eb15-0e22-49e4-c9dd57f20838/screen696x696.jpeg'> <img height='300' alt='VisitBCN image 5' src='http://a5.mzstatic.com/us/r30/Purple1/v4/69/b6/40/69b64064-ffbe-f727-eac9-95e12cc84d73/screen696x696.jpeg'> 
</div>
  </details>

- Wheelmap: Map to locate wheelchair-accessible places [` App Store`](https://itunes.apple.com/app/id399239476)  
  <details><summary><code>objc</code> </summary>

  https://github.com/sozialhelden/wheelmap-iphone2<br>  http://wheelmap.org<br>  Added June  2, 2016<br>  License: [`apache-2.0`](http://choosealicense.com/licenses/apache-2.0/)
  <div><img height='300' alt='Wheelmap image 1' src='http://a2.mzstatic.com/us/r30/Purple71/v4/31/98/51/31985171-13ac-746f-b7f6-6caafa79b31b/screen696x696.jpeg'> <img height='300' alt='Wheelmap image 2' src='http://a1.mzstatic.com/us/r30/Purple71/v4/9e/eb/19/9eeb1915-0499-24b3-9ca3-12a755c55b21/screen696x696.jpeg'> <img height='300' alt='Wheelmap image 3' src='http://a5.mzstatic.com/us/r30/Purple71/v4/d2/d8/1d/d2d81d12-bd4e-4068-0eca-f14b02e05c73/screen696x696.jpeg'> <img height='300' alt='Wheelmap image 4' src='http://a4.mzstatic.com/us/r30/Purple41/v4/9b/df/9b/9bdf9b42-5744-b8c1-70cf-5b68af6ad5b2/screen696x696.jpeg'> <img height='300' alt='Wheelmap image 5' src='http://a2.mzstatic.com/us/r30/Purple22/v4/7f/c7/fb/7fc7fbbc-c443-d17a-43e7-679586f80bb6/screen696x696.jpeg'> 
</div>
  </details>

- WWDC Family iOS: Easily connect with fellow developers during WWDC  
  <details><summary><code>swift</code> </summary>

  https://github.com/3lvis/ios<br>  Added February 21, 2017<br>  License: `other`
  <div><img height='300' alt='WWDC Family iOS image 1' src='https://raw.githubusercontent.com/wwdc-family/design/master/Images/1.png'> 
</div>
  </details>

- WWDC Family React Native: Easily connect with fellow developers during WWDC  
  <details><summary><code>react-native</code> 🔥</summary>

  https://github.com/wwdc-family/app<br>  Added April  3, 2017<br>  License: `other`
  <div><img height='300' alt='WWDC Family React Native image 1' src='https://raw.githubusercontent.com/wwdc-family/app/master/design/Screenshot1.png'> 
</div>
  </details>


## Media 
 
Image, video, audio, reading — [back to top](#readme) 
 
- ASCII Art Generator  
  <details><summary><code>swift</code> 🔥🔥</summary>

  https://github.com/ijoshsmith/swift-ascii-art<br>  Added May  6, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='ASCII Art Generator image 1' src='https://camo.githubusercontent.com/9ba7830d528cd45c20fc771b7347e8d2191a8cc6/68747470733a2f2f696a6f7368736d6974682e66696c65732e776f726470726573732e636f6d2f323031352f30342f61736369695f6b65726d69742e706e67'> 
</div>
  </details>

- Blear: Transform your photos into stunning blurry wallpapers for your device [` App Store`](https://itunes.apple.com/app/blear-create-blurry-wallpapers/id994182280)  
  <details><summary><code>objc</code> 🔥🔥</summary>

  https://github.com/sindresorhus/blear<br>  Added February 24, 2017<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Blear image 1' src='http://a2.mzstatic.com/us/r30/Purple111/v4/25/5b/c7/255bc7ab-95e2-1660-3bba-717b0ae21f1d/screen696x696.jpeg'> <img height='300' alt='Blear image 2' src='http://a3.mzstatic.com/us/r30/Purple111/v4/34/7a/42/347a42bd-3a7b-1f86-c2b8-3e043ea5e0e7/screen696x696.jpeg'> <img height='300' alt='Blear image 3' src='http://a4.mzstatic.com/us/r30/Purple122/v4/37/6b/27/376b278d-d698-981f-c931-d0e5b01c6733/screen696x696.jpeg'> <img height='300' alt='Blear image 4' src='http://a2.mzstatic.com/us/r30/Purple111/v4/ed/9a/9b/ed9a9b30-72f6-fc12-662f-0d1493a3d136/screen696x696.jpeg'> <img height='300' alt='Blear image 5' src='http://a2.mzstatic.com/us/r30/Purple122/v4/d0/8e/fa/d08efa30-4057-323e-15ee-9f2fe1e5aaff/screen696x696.jpeg'> 
</div>
  </details>

- ComicFlow: Comic reader [` App Store`](https://itunes.apple.com/app/comicflow/id409290355)  
  <details><summary><code>ipad</code> 🔥🔥</summary>

  https://github.com/swisspol/ComicFlow<br>  Added August 13, 2015<br>  License: [`gpl-3.0`](http://choosealicense.com/licenses/gpl-3.0/)
  <div><img height='300' alt='ComicFlow image 1' src='http://a5.mzstatic.com/us/r30/Purple/v4/d4/c0/91/d4c09117-c6df-beaa-db5f-0566be580645/screen480x480.jpeg'> 
</div>
  </details>

- Facemotion: Find a contact by face recognition  
  <details><summary><code>opencv</code> 🔥</summary>

  https://github.com/remirobert/Facemotion<br>  Added July 27, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Facemotion image 1' src='https://cloud.githubusercontent.com/assets/3276768/16144253/4e96344e-34a4-11e6-9257-06f5bcdf06ef.gif'> 
</div>
  </details>

- Filterpedia: Core Image Filter explorer  
  <details><summary><code>swift</code> <code>coreimage</code> 🔥🔥🔥🔥</summary>

  https://github.com/FlexMonkey/Filterpedia<br>  Added January  7, 2016<br>  License: [`gpl-3.0`](http://choosealicense.com/licenses/gpl-3.0/)
  <div><img height='300' alt='Filterpedia image 1' src='https://github.com/FlexMonkey/Filterpedia/raw/master/Filterpedia/assets/screenshot.jpg'> 
</div>
  </details>

- GreatReader: "Great" PDF reader [` App Store`](https://itunes.apple.com/app/greatreader/id903651112)  
  <details><summary><code>iphone</code> <code>ipad</code> 🔥🔥🔥</summary>

  https://github.com/semweb/GreatReader<br>  Added March 16, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='GreatReader image 1' src='http://a2.mzstatic.com/us/r30/Purple4/v4/7c/02/41/7c024189-7030-2183-08fd-a7ae4f0dbb7f/screen696x696.jpeg'> <img height='300' alt='GreatReader image 2' src='http://a1.mzstatic.com/us/r30/Purple4/v4/a4/cb/0d/a4cb0dba-039e-4f8e-1b44-95a946a3638f/screen696x696.jpeg'> <img height='300' alt='GreatReader image 3' src='http://a1.mzstatic.com/us/r30/Purple3/v4/4b/2f/2a/4b2f2ade-d9dc-cd4a-cf2b-357938ba0df0/screen696x696.jpeg'> <img height='300' alt='GreatReader image 4' src='http://a5.mzstatic.com/us/r30/Purple3/v4/d7/8a/2f/d78a2f7a-862b-c836-60c8-271d62679184/screen696x696.jpeg'> <img height='300' alt='GreatReader image 5' src='http://a1.mzstatic.com/us/r30/Purple4/v4/72/bf/92/72bf92cd-73c6-6046-2a9a-1fb081f30fab/screen696x696.jpeg'> 
</div>
  </details>

- Inkpad: Vector illustration  
  <details><summary><code>objc</code> 🔥🔥🔥🔥🔥</summary>

  https://github.com/sprang/Inkpad<br>  Added June  1, 2016<br>  License: [`mpl-2.0`](http://choosealicense.com/licenses/mpl-2.0/)
  <div><img height='300' alt='Inkpad image 1' src='https://github.com/sprang/Inkpad/blob/develop/Screenshots/Gradient.png?raw=true'> <img height='300' alt='Inkpad image 2' src='https://github.com/sprang/Inkpad/blob/develop/Screenshots/Hue.png?raw=true'> <img height='300' alt='Inkpad image 3' src='https://github.com/sprang/Inkpad/blob/develop/Screenshots/Layers.png?raw=true'> <img height='300' alt='Inkpad image 4' src='https://github.com/sprang/Inkpad/blob/develop/Screenshots/Selection.png?raw=true'> <img height='300' alt='Inkpad image 5' src='https://github.com/sprang/Inkpad/blob/develop/Screenshots/Swatches.png?raw=true'> 
</div>
  </details>

- Kodi: A popular media player & entertainment hub  
  <details><summary><code>objc</code> 🔥🔥🔥🔥🔥</summary>

  https://github.com/xbmc/xbmc<br>  https://kodi.wiki/view/IOS<br>  Added June  1, 2016<br>  License: [`gpl-2.0`](http://choosealicense.com/licenses/gpl-2.0/)
  <div><img height='300' alt='Kodi image 1' src='https://kodi.wiki/images/9/99/Kodi_on_ipad_in_hand.jpg'> 
</div>
  </details>

- Kodi Remote: A full-featured remote control for Kodi Media Center [` App Store`](https://itunes.apple.com/app/id520480364)  
  <details><summary><code>objc</code> 🔥🔥🔥🔥🔥</summary>

  https://github.com/xbmc/xbmc<br>  https://kodi.tv/<br>  Added June  1, 2016<br>  License: [`gpl-2.0`](http://choosealicense.com/licenses/gpl-2.0/)
  <div><img height='300' alt='Kodi Remote image 1' src='http://a2.mzstatic.com/us/r30/Purple3/v4/b4/ec/a9/b4eca96d-142c-d230-9eff-37a11d98dca3/screen696x696.jpeg'> <img height='300' alt='Kodi Remote image 2' src='http://a3.mzstatic.com/us/r30/Purple3/v4/ad/18/46/ad1846eb-e78b-f5a8-c404-967ac5ff18f3/screen696x696.jpeg'> <img height='300' alt='Kodi Remote image 3' src='http://a5.mzstatic.com/us/r30/Purple2/v4/b1/ff/95/b1ff95a3-1bf4-c7f7-f57f-18f45e2323d7/screen696x696.jpeg'> <img height='300' alt='Kodi Remote image 4' src='http://a3.mzstatic.com/us/r30/Purple3/v4/4c/20/5e/4c205e02-766b-69c5-7423-34e2eeb85921/screen696x696.jpeg'> <img height='300' alt='Kodi Remote image 5' src='http://a3.mzstatic.com/us/r30/Purple3/v4/2f/3a/30/2f3a30f0-166d-e7ac-34a5-9b6559ef54a5/screen696x696.jpeg'> 
</div>
  </details>

- Longboxed: Track the releases of your favorite comics  
  <details><summary><code>objc</code> </summary>

  https://github.com/jayhickey/Longboxed-iOS<br>  Added June 20, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Longboxed image 1' src='http://a2.mzstatic.com/us/r30/Purple5/v4/63/78/76/637876d8-da2f-a781-3989-3676566703bb/screen696x696.jpeg'> <img height='300' alt='Longboxed image 2' src='http://a2.mzstatic.com/us/r30/Purple3/v4/d8/55/ba/d855bade-a829-f3c3-44a0-6e0bbc015355/screen696x696.jpeg'> <img height='300' alt='Longboxed image 3' src='http://a2.mzstatic.com/us/r30/Purple1/v4/5d/1b/b3/5d1bb332-047f-3767-b9ec-52e80311a303/screen696x696.jpeg'> <img height='300' alt='Longboxed image 4' src='http://a3.mzstatic.com/us/r30/Purple5/v4/7c/cb/ab/7ccbab7b-104d-a08e-6a13-a384d8758558/screen696x696.jpeg'> <img height='300' alt='Longboxed image 5' src='http://a1.mzstatic.com/us/r30/Purple5/v4/63/54/a7/6354a7f6-891f-da89-b21b-1b4ab81f59cb/screen696x696.jpeg'> 
</div>
  </details>

- Loose Leaf: Take notes, import & annotate PDFs, manipulate imported photos with intuitive gestures [` App Store`](https://itunes.apple.com/app/loose-leaf/id625659452)  
  <details><summary><code>ipad</code> <code>pdf</code> <code>apple pencil</code> 🔥🔥</summary>

  https://github.com/adamwulf/loose-leaf<br>  Added January 11, 2017<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Loose Leaf image 1' src='https://github.com/adamwulf/loose-leaf/blob/master/example-gif/collapse-stack.gif?raw=true'> 
</div>
  </details>

- Marvel Comics  
  <details><summary><code>swift</code> <code>moya</code> <code>rxswift</code> <code>dollar</code> <code>kingfisher</code> <code>quick</code> <code>nimble</code> 🔥</summary>

  https://github.com/thiagolioy/marvelapp<br>  Added January  9, 2017<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Marvel Comics image 1' src='https://github.com/thiagolioy/marvelapp/blob/master/assets/marvel_screens.png?raw=true'> 
</div>
  </details>

- Meme Maker: Create & share memes [` App Store`](https://itunes.apple.com/app/id962121383)  
  <details><summary><code>swift</code> </summary>

  https://github.com/MemeMaker/Meme-Maker-iOS<br>  Added June  6, 2016<br>  License: `other`
  <div><img height='300' alt='Meme Maker image 1' src='http://a5.mzstatic.com/us/r30/Purple18/v4/94/86/ff/9486ff9f-23d3-ea8c-7e78-3f33d8bcf2bc/screen696x696.jpeg'> <img height='300' alt='Meme Maker image 2' src='http://a1.mzstatic.com/us/r30/Purple60/v4/3e/f2/26/3ef2262c-3d53-a7f7-d1e5-cb52b8e18ff0/screen696x696.jpeg'> <img height='300' alt='Meme Maker image 3' src='http://a5.mzstatic.com/us/r30/Purple18/v4/bf/8d/54/bf8d54f3-88ae-d5a8-570e-c00f0f1fc42f/screen696x696.jpeg'> <img height='300' alt='Meme Maker image 4' src='http://a5.mzstatic.com/us/r30/Purple30/v4/68/49/b8/6849b8e9-70c1-c337-eb27-0a5cc0618bba/screen696x696.jpeg'> <img height='300' alt='Meme Maker image 5' src='http://a2.mzstatic.com/us/r30/Purple20/v4/6f/46/29/6f4629c6-b41a-07e9-e867-e34f2363ac63/screen696x696.jpeg'> 
</div>
  </details>

- MuPDF: A PDF, XPS/OpenXPS, CBZ & EPUB document viewer [` App Store`](https://itunes.apple.com/app/id482941798)  
  <details><summary><code>objc</code> </summary>

  http://git.ghostscript.com/?p=mupdf.git;a=summary<br>  https://mupdf.com/<br>  Added June  2, 2016<br>  License: [`agpl-3.0`](http://choosealicense.com/licenses/agpl-3.0/)
  <div><img height='300' alt='MuPDF image 1' src='http://a5.mzstatic.com/us/r30/Purple3/v4/da/1b/05/da1b0583-54d6-d116-1ebb-4d4d9a4737ac/screen696x696.jpeg'> <img height='300' alt='MuPDF image 2' src='http://a4.mzstatic.com/us/r30/Purple1/v4/ac/50/ef/ac50ef39-e1af-2dd1-87a3-d0b2931d089b/screen696x696.jpeg'> <img height='300' alt='MuPDF image 3' src='http://a3.mzstatic.com/us/r30/Purple3/v4/44/9d/26/449d26a2-756c-d034-f734-0f6924b9937d/screen696x696.jpeg'> 
</div>
  </details>

- Pictograph: Hide messages in images with steganography [` App Store`](https://itunes.apple.com/us/app/id1051879856)  
  <details><summary><code>swift</code> </summary>

  https://github.com/MrAdamBoyd/Pictograph<br>  Added June 14, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Pictograph image 1' src='http://a3.mzstatic.com/us/r30/Purple69/v4/ce/65/eb/ce65eb78-616b-b274-0f3d-52c73818cd4c/screen696x696.jpeg'> <img height='300' alt='Pictograph image 2' src='http://a4.mzstatic.com/us/r30/Purple69/v4/3c/ac/c3/3cacc3cd-dcc9-98da-26ea-6ec44691ebcd/screen696x696.jpeg'> <img height='300' alt='Pictograph image 3' src='http://a5.mzstatic.com/us/r30/Purple7/v4/0b/4a/a3/0b4aa3eb-cdec-8563-c3de-5fbb80de6b04/screen696x696.jpeg'> 
</div>
  </details>

- projectM: Advanced music visualization [` App Store`](https://itunes.apple.com/app/id530922227)  
  <details><summary><code>opengl</code> </summary>

  https://sourceforge.net/projects/projectm/<br>  http://projectm.sourceforge.net/<br>  Added June  2, 2016<br>  License: [`gpl-2.0`](http://choosealicense.com/licenses/gpl-2.0/)
  <div><img height='300' alt='projectM image 1' src='http://a2.mzstatic.com/us/r30/Purple7/v4/44/17/41/44174112-c9f9-1719-8967-c43cb42bbf26/screen696x696.jpeg'> <img height='300' alt='projectM image 2' src='http://a4.mzstatic.com/us/r30/Purple7/v4/80/05/55/8005556a-437c-2d6a-d41d-044fc4e6740a/screen696x696.jpeg'> <img height='300' alt='projectM image 3' src='http://a4.mzstatic.com/us/r30/Purple5/v4/1a/6e/8e/1a6e8ef0-998f-34e4-7c92-f41de9227c73/screen696x696.jpeg'> <img height='300' alt='projectM image 4' src='http://a5.mzstatic.com/us/r30/Purple2/v4/35/c4/e2/35c4e23b-7eae-f138-a333-66e92b4c63dc/screen696x696.jpeg'> <img height='300' alt='projectM image 5' src='http://a1.mzstatic.com/us/r30/Purple1/v4/f3/8a/2b/f38a2bcd-e5d9-22b8-61cd-0b9e4cc159ae/screen696x696.jpeg'> 
</div>
  </details>

- Screenshotter: Organize & manage screenshots [` App Store`](https://itunes.apple.com/app/screenshotter-organize-manage/id826596892)  
  <details><summary><code>iphone</code> </summary>

  https://github.com/rsattar/screenshotter<br>  Added July 28, 2016<br>  License: [`apache-2.0`](http://choosealicense.com/licenses/apache-2.0/)
  <div><img height='300' alt='Screenshotter image 1' src='http://a1.mzstatic.com/us/r30/Purple111/v4/be/d3/72/bed372f2-d1fb-511b-8e76-d55a7805fc64/screen696x696.jpeg'> 
</div>
  </details>

- SeeFood: Detect various dishes using the camera  
  <details><summary><code>swift</code> <code>coreml</code> 🔥🔥</summary>

  https://github.com/kingreza/SeeFood<br>  Added September  5, 2017<br>  License: [`gpl-3.0`](http://choosealicense.com/licenses/gpl-3.0/)
  <div><img height='300' alt='SeeFood image 1' src='https://github.com/kingreza/SeeFood/raw/master/seefood1.gif'> 
</div>
  </details>

- Selfie Stick: Sync 2 devices & use one as a remote control for the other's camera [` App Store`](https://itunes.apple.com/app/id1084487132)  
  <details><summary><code>objc</code> </summary>

  https://github.com/RF-Nelson/open-source-selfie-stick<br>  Added February 18, 2016<br>  License: [`mpl-2.0`](http://choosealicense.com/licenses/mpl-2.0/)
  <div><img height='300' alt='Selfie Stick image 1' src='http://a1.mzstatic.com/us/r30/Purple69/v4/e2/df/a7/e2dfa79d-8c5b-1626-7743-bd5796626c4c/screen696x696.jpeg'> <img height='300' alt='Selfie Stick image 2' src='http://a2.mzstatic.com/us/r30/Purple69/v4/e3/32/92/e332929e-ade9-7df5-539f-347a5ceec305/screen696x696.jpeg'> 
</div>
  </details>

- SwiftSpace: Gyroscope driven drawing in 3D space  
  <details><summary><code>swift</code> <code>coremotion</code> 🔥</summary>

  https://github.com/FlexMonkey/SwiftSpace<br>  Added September  1, 2015<br>  License: `other`
  <div><img height='300' alt='SwiftSpace image 1' src='https://i.imgur.com/6khfaX6.png'> 
</div>
  </details>

- Tagger: Help tag your photos on Instagram or Flickr  
  <details><summary><code>swift</code> </summary>

  https://github.com/vanyaland/Tagger<br>  Added July  3, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Tagger image 1' src='https://github.com/vanyaland/Tagger/raw/master/Screenshots/main.png'> 
</div>
  </details>

- Upupu: Simple camera app that can backup pictures [` App Store`](https://itunes.apple.com/app/upupu/id508401854)  
  <details><summary><code>webdav</code> <code>dropbox</code> </summary>

  https://github.com/xcoo/upupu<br>  Added April  9, 2015<br>  License: [`apache-2.0`](http://choosealicense.com/licenses/apache-2.0/)
  <div><img height='300' alt='Upupu image 1' src='http://a1.mzstatic.com/us/r30/Purple62/v4/c3/82/0a/c3820aba-84fb-fc93-2cd6-092d52360128/screen696x696.jpeg'> <img height='300' alt='Upupu image 2' src='http://a3.mzstatic.com/us/r30/Purple71/v4/40/7a/69/407a69d2-7f9e-2c01-0548-e96ba9f862f5/screen696x696.jpeg'> <img height='300' alt='Upupu image 3' src='http://a5.mzstatic.com/us/r30/Purple62/v4/4d/ea/cf/4deacf02-1071-6dda-e7fe-730858a0515e/screen696x696.jpeg'> 
</div>
  </details>

- wallabag: A self-hosted read-it-later app. [` App Store`](https://itunes.apple.com/app/wallabag-2-official/id1170800946)  
  <details><summary><code>swift</code> </summary>

  https://github.com/wallabag/ios-app<br>  Added February  5, 2018<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='wallabag image 1' src='https://github.com/wallabag/ios-app/blob/master/fastlane/framed/iPhone6Plus-01Home-d41d8cd98f00b204e9800998ecf8427e_framed.png?raw=true'> <img height='300' alt='wallabag image 2' src='https://github.com/wallabag/ios-app/blob/master/fastlane/framed/iPhone6Plus-02Article-d41d8cd98f00b204e9800998ecf8427e_framed.png?raw=true'> 
</div>
  </details>


### Animoji 
 
[back to top](#readme) 
 
- Animoji Studio: Make Animoji videos with unlimited duration and share anywhere  
  <details><summary><code>objc</code> <code>iphonex</code> 🔥🔥🔥</summary>

  https://github.com/insidegui/AnimojiStudio<br>  Added November 26, 2017<br>  License: [`bsd-2-clause`](http://choosealicense.com/licenses/bsd-2-clause/)
  <div><img height='300' alt='Animoji Studio image 1' src='https://raw.githubusercontent.com/insidegui/AnimojiStudio/master/screenshots/AnimojiStudio_Screens2.png'> 
</div>
  </details>

- SBSAnimoji: Uses Apple's private framework AvatarKit  
  <details><summary><code>swift</code> <code>iphonex</code> 🔥🔥🔥</summary>

  https://github.com/simonbs/SBSAnimoji<br>  Added November  7, 2017<br>  License: `other`
  <div><img height='300' alt='SBSAnimoji image 1' src='https://github.com/simonbs/SBSAnimoji/raw/master/screenshot.png'> 
</div>
  </details>


### Audio 
 
[back to top](#readme) 
 
- Analog Synth X: Simple analog synthesizer keyboard music app example  
  <details><summary><code>swift</code> <code>swift2</code> </summary>

  http://audiokit.io/examples/AnalogSynthX/<br>  https://github.com/audiokit/AudioKit/tree/master/Examples/iOS/AnalogSynthX<br>  Added February  1, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Analog Synth X image 1' src='https://cdn-images-1.medium.com/max/800/1*hj0rxmPvapxpY1URdvw97A.png'> 
</div>
  </details>

- AudioKit ROM Player: Make your own sample music instrument [` App Store`](https://itunes.apple.com/app/fm-player-classic-dx-synths/id1307785646)  
  <details><summary><code>swift</code> <code>swift4</code> <code>ipad</code> 🔥🔥</summary>

  https://github.com/AudioKit/ROMPlayer<br>  https://audiokitpro.com/rom-player-code/<br>  Added December 12, 2017<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='AudioKit ROM Player image 1' src='https://audiokitpro.com/wp-content/uploads/2017/11/romplayer.png'> 
</div>
  </details>

- DoubanFM: https://douban.fm/ app  
  <details><summary><code>afnetworking</code> <code>mpmovieplayer</code> <code>iphone</code> 🇨🇳 🔥🔥</summary>

  https://github.com/XVXVXXX/DoubanFM<br>  Added October  1, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='DoubanFM image 1' src='https://github.com/XVXVXXX/DoubanFM/raw/master/readmeImage/page0.png'> 
</div>
  </details>

- Helio Workstation: Lightweight music creation playground [` App Store`](https://itunes.apple.com/app/id943796588)  
  <details><summary><code>ipad</code> <code>c++</code> 🔥🔥🔥🔥</summary>

  https://github.com/helio-fm/helio-workstation<br>  Added April 27, 2017<br>  License: [`gpl-3.0`](http://choosealicense.com/licenses/gpl-3.0/)
  <div><img height='300' alt='Helio Workstation image 1' src='http://a1.mzstatic.com/us/r30/Purple111/v4/ec/90/d9/ec90d9a0-0eac-cc83-0781-16cc3eebd783/sc552x414.jpeg'> <img height='300' alt='Helio Workstation image 2' src='http://a4.mzstatic.com/us/r30/Purple122/v4/72/a1/be/72a1bedb-055b-2fc5-b8e6-bcfb8f396b61/sc552x414.jpeg'> 
</div>
  </details>

- MiamiSunglasses: Plays the first five seconds of the CSI Miami theme song for on-the-go meme creation (YEAAAAAAAAAAHH)  
  <details><summary><code>swift</code> </summary>

  https://github.com/DeveloperACE/MiamiSunglasses<br>  Added May 13, 2016<br>  License: [`apache-2.0`](http://choosealicense.com/licenses/apache-2.0/)
  <div><img height='300' alt='MiamiSunglasses image 1' src='https://i.imgur.com/DYoZw6Q.png'> 
</div>
  </details>

- Monotone Delay: A simple synthesiser, based on the Korg Monotron Delay [` App Store`](https://itunes.apple.com/app/monotone-delay/id737483162)  
  <details><summary><code>objc</code> </summary>

  https://github.com/jkandzi/Monotone-Delay<br>  http://monotone.justuskandzi.com<br>  Added December 21, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Monotone Delay image 1' src='http://a4.mzstatic.com/us/r30/Purple5/v4/7d/be/82/7dbe82a0-26a2-ec64-2804-47de55caa190/screen520x924.jpeg'> 
</div>
  </details>

- Prodigal Music Player [` App Store`](https://itunes.apple.com/app/kuansun/id1231296263)  
  <details><summary><code>swift</code> <code>snapkit</code> <code>haneke</code> <code>koloda</code> </summary>

  https://github.com/SpongeBobSun/Prodigal-iOS<br>  Added May  3, 2017<br>  License: `other`
  <div><img height='300' alt='Prodigal Music Player image 1' src='https://github.com/SpongeBobSun/Prodigal-iOS/raw/master/artworks/home.png'> 
</div>
  </details>

- Radio Paradise: Official app for http://www.radioparadise.com/ [` App Store`](https://itunes.apple.com/app/id663334697)  
  <details><summary><code>objc</code> </summary>

  https://github.com/ilTofa/rposx<br>  https://www.iltofa.com/rphd/<br>  Added June  1, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Radio Paradise image 1' src='http://a5.mzstatic.com/us/r30/Purple30/v4/97/22/95/97229577-fbbd-2de8-3822-b906eadb6354/screen800x500.jpeg'> 
</div>
  </details>

- Swift Radio Pro: Professional radio station app  
  <details><summary><code>swift</code> <code>swift2</code> 🔥🔥🔥🔥</summary>

  https://github.com/analogcode/Swift-Radio-Pro<br>  Added January 24, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Swift Radio Pro image 1' src='https://cdn-images-1.medium.com/max/800/1*THdzhTjeuB-niUriPwsxfg.png'> 
</div>
  </details>

- VoiceMemos: Audio recorder  
  <details><summary><code>swift</code> 🔥🔥</summary>

  https://github.com/MoZhouqi/VoiceMemos<br>  Added April  1, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='VoiceMemos image 1' src='https://raw.githubusercontent.com/MoZhouqi/VoiceMemos/master/Screenshots/recording.png'> 
</div>
  </details>


### Content 
 
[back to top](#readme) 
 
- A Menjar: Food menu [` App Store`](https://itunes.apple.com/app/a-menjar!/id816473131)  
  <details><summary><code>objc</code> 🇪🇸 </summary>

  https://github.com/maurovc/aMenjar<br>  Added March 16, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='A Menjar image 1' src='http://a5.mzstatic.com/us/r30/Purple4/v4/52/51/78/525178dc-a5c4-ccc3-b2bb-fb1afe4915b5/screen696x696.jpeg'> <img height='300' alt='A Menjar image 2' src='http://a4.mzstatic.com/us/r30/Purple4/v4/f1/1f/ee/f11fee6f-f21d-af5f-3921-04f8adfecb6b/screen696x696.jpeg'> <img height='300' alt='A Menjar image 3' src='http://a3.mzstatic.com/us/r30/Purple4/v4/ad/c0/e1/adc0e18d-ade4-d0a2-e272-ed34500e63b2/screen696x696.jpeg'> <img height='300' alt='A Menjar image 4' src='http://a1.mzstatic.com/us/r30/Purple1/v4/c7/e4/22/c7e4228e-9e7e-a42b-24bd-48663cb2ed6d/screen696x696.jpeg'> 
</div>
  </details>

- American Chronicle: Search Chronicling America's collection of digitized U.S. newspapers [` App Store`](https://itunes.apple.com/app/id1092988367)  
  <details><summary><code>viper</code> </summary>

  https://github.com/ryanipete/AmericanChronicle<br>  http://ryanipete.com/AmericanChronicle/<br>  Added June 22, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='American Chronicle image 1' src='http://a5.mzstatic.com/us/r30/Purple60/v4/1e/82/3b/1e823b8a-d10c-2085-2063-1d18ba68ce2e/screen696x696.jpeg'> 
</div>
  </details>

- Artsy: The art world in your pocket [` App Store`](https://itunes.apple.com/app/artsy-art-world-in-your-pocket/id703796080)  
  <details><summary><code>iphone</code> <code>ipad</code> <code>afnetworking</code> <code>mantle</code> <code>cocoapodskeys</code> <code>reactivecocoa</code> 🔥🔥🔥🔥🔥</summary>

  https://github.com/artsy/eigen<br>  Added January 26, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Artsy image 1' src='http://a1.mzstatic.com/us/r30/Purple30/v4/f9/fd/e3/f9fde323-7f53-12d9-99cc-94f435fc9a06/screen696x696.jpeg'> <img height='300' alt='Artsy image 2' src='http://a1.mzstatic.com/us/r30/Purple30/v4/dc/17/9a/dc179a52-4cda-f91e-c36a-5d6bce72ff3c/screen696x696.jpeg'> <img height='300' alt='Artsy image 3' src='http://a5.mzstatic.com/us/r30/Purple30/v4/52/65/c4/5265c4b3-5d0c-4fce-1520-f1a6da6835af/screen696x696.jpeg'> <img height='300' alt='Artsy image 4' src='http://a2.mzstatic.com/us/r30/Purple20/v4/9f/84/d6/9f84d61d-59d5-e10e-236a-fd8c9685c9c1/screen696x696.jpeg'> <img height='300' alt='Artsy image 5' src='http://a2.mzstatic.com/us/r30/Purple18/v4/75/09/05/75090520-f464-e0c4-8d9b-9b07c6bb8c15/screen696x696.jpeg'> 
</div>
  </details>

- Artsy Folio: Artwork showcase [` App Store`](https://itunes.apple.com/app/artsy-folio/id504862164)  
  <details><summary><code>objc</code> 🔥</summary>

  https://github.com/artsy/energy<br>  Added August 11, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Artsy Folio image 1' src='http://a5.mzstatic.com/us/r30/Purple71/v4/23/c4/ea/23c4eaee-0df9-1ef2-c179-944e4a0ef83d/screen696x696.jpeg'> <img height='300' alt='Artsy Folio image 2' src='http://a4.mzstatic.com/us/r30/Purple62/v4/94/c0/c2/94c0c26d-f357-ae4f-c428-97d6b030e36d/screen696x696.jpeg'> <img height='300' alt='Artsy Folio image 3' src='http://a5.mzstatic.com/us/r30/Purple62/v4/fe/2b/67/fe2b6779-8a73-2924-8aa3-45cc42cb1127/screen696x696.jpeg'> <img height='300' alt='Artsy Folio image 4' src='http://a2.mzstatic.com/us/r30/Purple71/v4/6e/78/13/6e781329-db0f-81ca-1783-428f85b4f76c/screen696x696.jpeg'> 
</div>
  </details>

- Awesome Mobile Conference: Collaborative list of Mobile Conferences [` App Store`](https://itunes.apple.com/app/awesome-mobile-conferences/id1289255473)  
  <details><summary><code>swift</code> </summary>

  https://github.com/aweconf/iOS<br>  Added November  3, 2017<br>  License: `other`
  <div><img height='300' alt='Awesome Mobile Conference image 1' src='http://is2.mzstatic.com/image/thumb/Purple128/v4/92/6b/9d/926b9de9-9f22-39e3-073b-f409ed8e7439/source/392x696bb.jpg'> <img height='300' alt='Awesome Mobile Conference image 2' src='http://is5.mzstatic.com/image/thumb/Purple128/v4/83/90/53/839053c8-d824-2188-7053-d21a92f24618/source/392x696bb.jpg'> 
</div>
  </details>

- Awesome Swift iOS App: Official awesome-swift repository app [` App Store`](https://itunes.apple.com/app/awesome-for-swift-cheatsheet/id1078115427)  
  <details><summary><code>swift</code> </summary>

  https://github.com/matteocrippa/awesome-swift-ios<br>  Added June 11, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Awesome Swift iOS App image 1' src='http://a3.mzstatic.com/us/r30/Purple1/v4/95/16/1a/95161a0b-1f38-d1e3-d535-bab4fdc95cb8/screen696x696.jpeg'> <img height='300' alt='Awesome Swift iOS App image 2' src='http://a4.mzstatic.com/us/r30/Purple1/v4/de/40/91/de4091f4-de82-f018-03b1-67224139f3df/screen696x696.jpeg'> <img height='300' alt='Awesome Swift iOS App image 3' src='http://a2.mzstatic.com/us/r30/Purple1/v4/f3/26/ae/f326aee3-af48-fc10-746e-898072b7d931/screen696x696.jpeg'> <img height='300' alt='Awesome Swift iOS App image 4' src='http://a2.mzstatic.com/us/r30/Purple4/v4/65/33/cf/6533cfdf-3c11-91ad-86c3-707dfdd42e5b/screen696x696.jpeg'> <img height='300' alt='Awesome Swift iOS App image 5' src='http://a5.mzstatic.com/us/r30/Purple49/v4/54/3b/9e/543b9e97-0797-8058-5cbb-e430d6dc605b/screen696x696.jpeg'> 
</div>
  </details>

- bar: Cocktail menu  
  <details><summary><code>swift</code> </summary>

  https://github.com/soffes/bar<br>  Added January 26, 2015<br>  License: `other`
  <div><img height='300' alt='bar image 1' src='https://i.imgur.com/PTUo4e7.png'> <img height='300' alt='bar image 2' src='https://i.imgur.com/bXZH0LB.png'> <img height='300' alt='bar image 3' src='https://i.imgur.com/tIFW8bu.png'> <img height='300' alt='bar image 4' src='https://i.imgur.com/D095xih.png'> 
</div>
  </details>

- Dunk  
  <details><summary><code>swift</code> <code>dribbble</code> 🔥🔥🔥</summary>

  https://github.com/naoyashiga/Dunk<br>  Added December 10, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Dunk image 1' src='https://cdn-images-1.medium.com/max/800/1*0TkH9-Guo_A_hdlI9UEnvQ.png'> 
</div>
  </details>

- Good Living Guide: home snacks, gifts, beauty, shopping..  
  <details><summary><code>swift</code> 🇨🇳 🔥🔥🔥</summary>

  https://github.com/hrscy/DanTang<br>  Added August  4, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Good Living Guide: home snacks, gifts, beauty, shopping.. image 1' src='http://a4.mzstatic.com/us/r30/Purple1/v4/7a/5f/b7/7a5fb7a2-e038-2b81-63b6-8b76872b86fe/screen696x696.jpeg'> 
</div>
  </details>

- Homepok: Catalog of Ukrainian vehicle plates [` App Store`](https://itunes.apple.com/app/id1105827929)  
  <details><summary><code>swift</code> 🇷🇺 </summary>

  https://github.com/iAlexander/Homepok<br>  Added November 27, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Homepok image 1' src='https://raw.githubusercontent.com/iAlexander/Homepok/master/Screenshots.jpg'> 
</div>
  </details>

- Kiwix: An offline reader for Wikipedia (& many other websites) [` App Store`](https://itunes.apple.com/app/id997079563)  
  <details><summary><code>swift</code> </summary>

  https://github.com/kiwix/apple<br>  http://wiki.kiwix.org/wiki/Main_Page<br>  Added June  2, 2016<br>  License: `other`
  <div><img height='300' alt='Kiwix image 1' src='http://a5.mzstatic.com/us/r30/Purple30/v4/d7/75/7d/d7757dca-fbd0-2ad8-5cb5-eedd8a440664/screen696x696.jpeg'> <img height='300' alt='Kiwix image 2' src='http://a2.mzstatic.com/us/r30/Purple60/v4/0a/a6/50/0aa650de-c849-a135-528b-9eaf30da9207/screen696x696.jpeg'> <img height='300' alt='Kiwix image 3' src='http://a4.mzstatic.com/us/r30/Purple60/v4/a4/1c/db/a41cdb64-d122-80f4-fc3c-fc8ebf430f22/screen696x696.jpeg'> <img height='300' alt='Kiwix image 4' src='http://a3.mzstatic.com/us/r30/Purple60/v4/ec/8e/6a/ec8e6a20-8dae-4619-d352-24f076c86550/screen696x696.jpeg'> <img height='300' alt='Kiwix image 5' src='http://a5.mzstatic.com/us/r30/Purple18/v4/da/23/5c/da235cde-a1e6-2cab-3bdb-7d42d81e98e1/screen696x696.jpeg'> 
</div>
  </details>

- KonaBot: An app for http://konachan.net/ [` App Store`](https://itunes.apple.com/app/konabot/id1055716649)  
  <details><summary><code>swift</code> </summary>

  https://github.com/hkalexling/KonaBot-iOS<br>  Added December  3, 2015<br>  License: `other`
  <div><img height='300' alt='KonaBot image 1' src='http://a4.mzstatic.com/us/r30/Purple69/v4/3c/49/5c/3c495c55-a5bf-fb2d-4896-1185afcebe28/screen696x696.jpeg'> <img height='300' alt='KonaBot image 2' src='http://a4.mzstatic.com/us/r30/Purple49/v4/62/72/49/627249dc-fa3e-b859-cbbb-e039e34966fe/screen696x696.jpeg'> <img height='300' alt='KonaBot image 3' src='http://a3.mzstatic.com/us/r30/Purple69/v4/87/d5/56/87d556a0-a9df-3d4d-cdb8-21103ba30d75/screen696x696.jpeg'> <img height='300' alt='KonaBot image 4' src='http://a5.mzstatic.com/us/r30/Purple69/v4/c7/f0/46/c7f046c0-8915-8e90-80a1-2e258204d212/screen696x696.jpeg'> <img height='300' alt='KonaBot image 5' src='http://a3.mzstatic.com/us/r30/Purple49/v4/fe/45/c4/fe45c4c1-ced9-7ffc-9175-a5e3c3e74b91/screen696x696.jpeg'> 
</div>
  </details>

- LidderbuchApp: Songbook for Luxembourgish students [` App Store`](https://itunes.apple.com/app/lidderbuch/id997143407)  
  <details><summary><code>swift</code> 🇱🇺 </summary>

  https://github.com/AcelLuxembourg/LidderbuchApp<br>  Added September 28, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='LidderbuchApp image 1' src='http://a3.mzstatic.com/us/r30/Purple3/v4/14/b8/82/14b882f5-3e8b-bd4e-a42f-ce6e36db1c83/screen696x696.jpeg'> <img height='300' alt='LidderbuchApp image 2' src='http://a5.mzstatic.com/us/r30/Purple6/v4/92/13/ed/9213ed30-3533-d50b-4e61-a28057dc9111/screen696x696.jpeg'> <img height='300' alt='LidderbuchApp image 3' src='http://a2.mzstatic.com/us/r30/Purple3/v4/1b/8d/c5/1b8dc5f0-6308-da78-42e8-df7eff755959/screen696x696.jpeg'> <img height='300' alt='LidderbuchApp image 4' src='http://a3.mzstatic.com/us/r30/Purple3/v4/28/38/4f/28384f60-d2eb-067c-4c15-469e83ce2307/screen696x696.jpeg'> 
</div>
  </details>

- Molecules: Visualize molecules in 3D [` App Store`](https://itunes.apple.com/app/molecules/id284943090)  
  <details><summary><code>objc</code> </summary>

  http://www.sunsetlakesoftware.com/molecules<br>  Added May 31, 2016<br>  License: `other`
  <div><img height='300' alt='Molecules image 1' src='http://a1.mzstatic.com/us/r30/Purple/v4/2f/7c/cd/2f7ccdde-4478-b24b-7801-809b11b9e6f3/screen320x480.jpeg'> 
</div>
  </details>

- movieapp: Discover movies & tv shows  
  <details><summary><code>react native</code> <code>tmdb</code> 🔥🔥🔥🔥</summary>

  https://github.com/JuneDomingo/movieapp<br>  Added November 28, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='movieapp image 1' src='https://cloud.githubusercontent.com/assets/5106887/20606597/f176b3e2-b2ac-11e6-9163-c9e625df7748.png'> 
</div>
  </details>

- MovieDict: Offline dictionary for international movie titles [` App Store`](https://itunes.apple.com/app/movieglot-what-do-they-call-it/id710587066)  
  <details><summary><code>wikipedia</code> </summary>

  https://github.com/lurado/MovieDict<br>  https://moviedict.info<br>  Added July 26, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='MovieDict image 1' src='https://camo.githubusercontent.com/09de19622e05913567e36c75911e2dd981295036/68747470733a2f2f6d6f766965646963742e696e666f2f6970686f6e652e706e67'> 
</div>
  </details>

- movies: Movie info app  
  <details><summary><code>afnetworking</code> <code>sdwebimage</code> <code>tmdb</code> 🔥🔥🔥</summary>

  https://github.com/KMindeguia/movies<br>  Added February 20, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='movies image 1' src='https://raw.githubusercontent.com/KMindeguia/movies/master/Gif%20Demo/demo.gif'> 
</div>
  </details>

- Open States: Browse state legislatures  
  <details><summary><code>objc</code> </summary>

  https://github.com/openstates/openstates-ios<br>  Added April  6, 2016<br>  License: [`bsd-3-clause`](http://choosealicense.com/licenses/bsd-3-clause/)
  <div><img height='300' alt='Open States image 1' src='https://s3.mzstatic.com/r30/Purple6/v4/d3/db/1a/d3db1a57-d85c-b2b1-3b15-5c14bb455229/screen1136x1136.jpeg'> 
</div>
  </details>

- OpenPics: View historical images from multiple remote sources [` App Store`](https://itunes.apple.com/app/openpics/id633423505)  
  <details><summary><code>swift</code> </summary>

  https://github.com/pj4533/OpenPics<br>  Added December 31, 2015<br>  License: [`gpl-3.0`](http://choosealicense.com/licenses/gpl-3.0/)
  <div><img height='300' alt='OpenPics image 1' src='https://github.com/pj4533/OpenPics/raw/master/openpics.gif'> 
</div>
  </details>

- osia: Super basic app to browse open-source-ios-apps  
  <details><summary><code>swift</code> </summary>

  https://github.com/dkhamsing/osia<br>  Added July 25, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='osia image 1' src='https://github.com/dkhamsing/osia/raw/master/Assets/0.1.png'> 
</div>
  </details>

- PhishOD: Listen to any song from phish.in, view concert ratings & reviews from phish.net [` App Store`](https://itunes.apple.com/app/phish-on-demand-all-phish/id672139018)  
  <details><summary><code>objc</code> </summary>

  https://github.com/alecgorge/PhishOD-iOS<br>  Added June 26, 2015<br>  License: `other`
  <div><img height='300' alt='PhishOD image 1' src='http://a2.mzstatic.com/us/r30/Purple5/v4/9d/27/83/9d27832d-3c16-a64e-f3a2-7e3fbd5cc2b5/screen696x696.jpeg'> <img height='300' alt='PhishOD image 2' src='http://a2.mzstatic.com/us/r30/Purple5/v4/ec/74/2a/ec742a14-e875-2070-178b-948def533d2e/screen696x696.jpeg'> <img height='300' alt='PhishOD image 3' src='http://a1.mzstatic.com/us/r30/Purple1/v4/9d/c4/58/9dc45823-97bd-296d-0126-fc9e86879d87/screen696x696.jpeg'> <img height='300' alt='PhishOD image 4' src='http://a1.mzstatic.com/us/r30/Purple1/v4/9f/aa/5f/9faa5ff9-d299-9859-8c8c-00d680d26dd6/screen696x696.jpeg'> <img height='300' alt='PhishOD image 5' src='http://a1.mzstatic.com/us/r30/Purple5/v4/80/1f/f7/801ff748-97f6-9092-0b7d-dda68070de3d/screen696x696.jpeg'> 
</div>
  </details>

- PhotoBrowser: Simple Instagram photo browser  
  <details><summary><code>swift</code> <code>instagram api</code> 🔥🔥🔥</summary>

  https://github.com/MoZhouqi/PhotoBrowser<br>  Added March 31, 2015<br>  License: `other`
  <div><img height='300' alt='PhotoBrowser image 1' src='https://raw.githubusercontent.com/MoZhouqi/PhotoBrowser/master/assets/login.png'> <img height='300' alt='PhotoBrowser image 2' src='https://raw.githubusercontent.com/MoZhouqi/PhotoBrowser/master/assets/gallary.png'> 
</div>
  </details>

- PHPHub: App for https://laravel-china.org/  
  <details><summary><code>iphone</code> <code>ipad</code> 🇨🇳 🔥🔥🔥🔥</summary>

  https://github.com/Aufree/phphub-ios<br>  Added December  4, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div>
</div>
  </details>

- Pickery: Works with AWS SDK to store your pictures & videos [` App Store`](https://itunes.apple.com/app/pickery/id1164219958)  
  <details><summary><code>swift</code> <code>realm</code> </summary>

  https://github.com/Performador/Pickery<br>  Added January 10, 2017<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Pickery image 1' src='http://www.okanarikan.com/assets/Apps/Pickery/Screen1.jpg'> <img height='300' alt='Pickery image 2' src='http://www.okanarikan.com/assets/Apps/Pickery/Screen2.jpg'> <img height='300' alt='Pickery image 3' src='http://www.okanarikan.com/assets/Apps/Pickery/Screen3.jpg'> 
</div>
  </details>

- PopcornTime: PopcornTime movie app  
  <details><summary><code>swift</code> 🔥</summary>

  https://github.com/danylokostyshyn/popcorntime-ios<br>  Added May 20, 2015<br>  License: `other`
  <div><img height='300' alt='PopcornTime image 1' src='https://camo.githubusercontent.com/c50d34929cbeaa6ca7c30773410fbd74de95470f/68747470733a2f2f7261772e6769746875622e636f6d2f64616e796c6f6b6f7374797368796e2f706f70636f726e74696d652d696f732f6d61737465722f53637265656e73686f74732f312e706e67'> <img height='300' alt='PopcornTime image 2' src='https://camo.githubusercontent.com/acbc97860741cc35d9b99f785dd00410c5006773/68747470733a2f2f7261772e6769746875622e636f6d2f64616e796c6f6b6f7374797368796e2f706f70636f726e74696d652d696f732f6d61737465722f53637265656e73686f74732f322e706e67'> <img height='300' alt='PopcornTime image 3' src='https://camo.githubusercontent.com/daa316738f69b74d328d5172fb0beae9fd8aebbb/68747470733a2f2f7261772e6769746875622e636f6d2f64616e796c6f6b6f7374797368796e2f706f70636f726e74696d652d696f732f6d61737465722f53637265656e73686f74732f332e706e67'> 
</div>
  </details>

- Popular Movies: Cross-platform app for discovering recent & popular movies  
  <details><summary><code>swift</code> <code>realm</code> <code>alamofire</code> <code>tmdb</code> </summary>

  https://github.com/vanyaland/Popular-Movies<br>  Added January 19, 2017<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Popular Movies image 1' src='https://github.com/vanyaland/Popular-Movies/blob/master/res/iOS-movie-detail.png'> <img height='300' alt='Popular Movies image 2' src='https://github.com/vanyaland/Popular-Movies/blob/master/res/iOS-movies-list.png'> 
</div>
  </details>

- QiitaCollection: Technical knowledge sharing & collaboration platform  
  <details><summary><code>objc</code> 🇯🇵 </summary>

  https://github.com/anzfactory/QiitaCollection<br>  Added October 17, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='QiitaCollection image 1' src='http://a1.mzstatic.com/us/r30/Purple5/v4/4f/7d/a9/4f7da952-8094-5e24-723b-c2c6d590c605/screen696x696.jpeg'> <img height='300' alt='QiitaCollection image 2' src='http://a5.mzstatic.com/us/r30/Purple3/v4/00/20/8d/00208db3-aa34-7f70-0c82-ced3cf27f569/screen696x696.jpeg'> <img height='300' alt='QiitaCollection image 3' src='http://a5.mzstatic.com/us/r30/Purple1/v4/ec/60/2a/ec602a8e-40e5-44bd-475c-d26d8baf6c47/screen696x696.jpeg'> <img height='300' alt='QiitaCollection image 4' src='http://a1.mzstatic.com/us/r30/Purple3/v4/ca/57/7d/ca577d9b-623f-7b0c-3baa-855f783284a1/screen696x696.jpeg'> <img height='300' alt='QiitaCollection image 5' src='http://a4.mzstatic.com/us/r30/Purple5/v4/69/09/1d/69091d91-c788-ab5d-467b-4866763ed7d9/screen696x696.jpeg'> 
</div>
  </details>

- Reading List: Track personal reading lists [` App Store`](https://itunes.apple.com/app/reading-list-a-book-tracking-log/id1217139955)  
  <details><summary><code>swift</code> <code>iphone</code> <code>ipad</code> <code>swift3</code> <code>rxswift</code> </summary>

  https://github.com/AndrewBennet/readinglist<br>  Added July 21, 2017<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Reading List image 1' src='https://raw.githubusercontent.com/AndrewBennet/readinglist/master/site/assets/iPhone7-ToReadList_framed.png'> 
</div>
  </details>

- RealmVideo: Watch Realm videos & slides  
  <details><summary><code>swift</code> <code>iphone</code> 🔥🔥</summary>

  https://github.com/BalestraPatrick/RealmVideo<br>  Added May 11, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='RealmVideo image 1' src='https://github.com/BalestraPatrick/RealmVideo/raw/master/Resources/demo.gif'> 
</div>
  </details>

- Rewatch: Get suggestions for your BetaSeries account on what episode to rewatch [` App Store`](https://itunes.apple.com/app/rewatch-get-suggestion-rewatch/id1054419288)  
  <details><summary><code>swift</code> <code>carthage</code> 🇨🇳 </summary>

  https://github.com/Palleas/Rewatch<br>  Added September 13, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Rewatch image 1' src='http://a5.mzstatic.com/us/r30/Purple18/v4/f9/5c/67/f95c6741-8c28-958e-f532-1eb7ec8fe792/screen696x696.jpeg'> 
</div>
  </details>

- SoundCloudSwift: SoundCloud app  
  <details><summary><code>swift</code> 🔥🔥</summary>

  https://github.com/pepibumur/SoundCloudSwift<br>  Added May  1, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='SoundCloudSwift image 1' src='https://cdn-images-1.medium.com/max/800/1*C0s-C27rJbQrIa0j5dBctQ.png'> 
</div>
  </details>

- Textbook: textbooks from People's Education Press in China  
  <details><summary><code>swift</code> 🇨🇳 </summary>

  https://github.com/JohnWong/textbook<br>  Added February 17, 2016<br>  License: `other`
  <div><img height='300' alt='Textbook image 1' src='http://a4.mzstatic.com/us/r30/Purple7/v4/53/a8/65/53a8655a-f9bc-61c5-260e-2ef534d8b950/screen696x696.jpeg'> <img height='300' alt='Textbook image 2' src='http://a3.mzstatic.com/us/r30/Purple1/v4/a4/1e/6d/a41e6d5b-54cd-a1e7-eafd-eb49278b26c8/screen696x696.jpeg'> <img height='300' alt='Textbook image 3' src='http://a3.mzstatic.com/us/r30/Purple5/v4/2f/84/19/2f8419f7-bb15-c1d2-28eb-674e780ba533/screen696x696.jpeg'> <img height='300' alt='Textbook image 4' src='http://a4.mzstatic.com/us/r30/Purple7/v4/52/20/0c/52200c71-07d2-a6c6-d3da-2bacf03ac0d1/screen696x696.jpeg'> 
</div>
  </details>

- Words: Thesaurus app  
  <details><summary><code>objc</code> </summary>

  https://github.com/soffes/words<br>  Added January 26, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Words image 1' src='https://i.imgur.com/84QPJ8v.png'> 
</div>
  </details>

- WWDC Students: WWDC scholarship entries  
  <details><summary><code>swift</code> 🔥</summary>

  https://github.com/wwdc<br>  Added March 21, 2016<br>  License: `other`
  <div><img height='300' alt='WWDC Students image 1' src='https://i.imgur.com/EsK2V67.png'> <img height='300' alt='WWDC Students image 2' src='https://i.imgur.com/vmrzCDz.png'> 
</div>
  </details>

- xkcd [` App Store`](https://itunes.apple.com/app/xkcd/id303688284)  
  <details><summary><code>iphone</code> </summary>

  https://github.com/paulrehkugler/xkcd<br>  Added June  5, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='xkcd image 1' src='http://a1.mzstatic.com/us/r30/Purple19/v4/39/b4/d5/39b4d554-fad7-152c-5a7c-3b111524ca99/screen696x696.jpeg'> <img height='300' alt='xkcd image 2' src='http://a1.mzstatic.com/us/r30/Purple41/v4/d0/f5/13/d0f5131a-7e94-6b3e-82f7-b01d3dc14fc5/screen696x696.jpeg'> <img height='300' alt='xkcd image 3' src='http://a4.mzstatic.com/us/r30/Purple41/v4/b9/e0/eb/b9e0eb3b-935b-6ce6-8fbb-c975f073b9f7/screen696x696.jpeg'> <img height='300' alt='xkcd image 4' src='http://a4.mzstatic.com/us/r30/Purple22/v4/03/6d/88/036d88c7-11d8-9699-db7d-7af36a41bb93/screen696x696.jpeg'> 
</div>
  </details>

- xkcd Open Source: An xkcd comic reader [` App Store`](https://itunes.apple.com/app/xkcd-open-source/id995811425)  
  <details><summary><code>objc</code> 🔥</summary>

  https://github.com/mamaral/xkcd-Open-Source<br>  Added June  5, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='xkcd Open Source image 1' src='http://a1.mzstatic.com/us/r30/Purple71/v4/d0/27/26/d0272612-eb38-f31b-c9d4-3eac2869af32/screen696x696.jpeg'> <img height='300' alt='xkcd Open Source image 2' src='http://a1.mzstatic.com/us/r30/Purple71/v4/41/19/3b/41193bd3-c509-4ca5-705c-02a76eea1563/screen696x696.jpeg'> <img height='300' alt='xkcd Open Source image 3' src='http://a4.mzstatic.com/us/r30/Purple62/v4/7a/72/23/7a7223c4-3af8-45cc-70ce-2bf736105be2/screen696x696.jpeg'> <img height='300' alt='xkcd Open Source image 4' src='http://a2.mzstatic.com/us/r30/Purple71/v4/22/b9/07/22b907ab-074c-c3c9-533d-3ab6a3788aaa/screen696x696.jpeg'> 
</div>
  </details>

- YaleMobile: App for Yale University students  
  <details><summary><code>objc</code> </summary>

  https://github.com/kiokoo/YaleMobile<br>  Added July 13, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='YaleMobile image 1' src='http://a1.mzstatic.com/us/r30/Purple3/v4/b3/63/b0/b363b05e-8d4a-a8b5-1591-efc0cce59314/screen696x696.jpeg'> <img height='300' alt='YaleMobile image 2' src='http://a4.mzstatic.com/us/r30/Purple3/v4/a0/c4/6d/a0c46d99-a34e-d317-5df2-8b348850c20a/screen696x696.jpeg'> <img height='300' alt='YaleMobile image 3' src='http://a4.mzstatic.com/us/r30/Purple5/v4/8c/08/eb/8c08ebfd-da89-af44-c1c5-9c39ec464576/screen696x696.jpeg'> <img height='300' alt='YaleMobile image 4' src='http://a5.mzstatic.com/us/r30/Purple5/v4/fd/9d/3d/fd9d3d73-3a97-af1c-d421-abf38b518f24/screen696x696.jpeg'> <img height='300' alt='YaleMobile image 5' src='http://a1.mzstatic.com/us/r30/Purple5/v4/eb/3c/49/eb3c4940-c927-284d-0dfb-e96eb4ca0703/screen696x696.jpeg'> 
</div>
  </details>


### GIF 
 
Mostly using http://giphy.com/ — [back to top](#readme) 
 
- AlohaGIF: Create GIFs easily with speech detection. Just record a short video or pick one from your Photos. [` App Store`](https://itunes.apple.com/app/aloha-gifs-with-dynamic-subtitles/id1231254189)  
  <details><summary><code>swift</code> <code>avfoundation</code> <code>sfspeechrecognizer</code> </summary>

  https://github.com/michaello/Aloha<br>  http://www.alohagif.com/<br>  Added October 28, 2017<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='AlohaGIF image 1' src='http://is1.mzstatic.com/image/thumb/Purple82/v4/44/60/72/446072a3-cc4f-3fc8-ece5-14568643dc15/source/392x696bb.jpg'> <img height='300' alt='AlohaGIF image 2' src='http://is4.mzstatic.com/image/thumb/Purple91/v4/90/58/e3/9058e3be-4676-5668-8301-2488df8322d3/source/392x696bb.jpg'> 
</div>
  </details>

- Giraffe  
  <details><summary><code>swift</code> <code>reactivecocoa</code> </summary>

  https://github.com/evgeniyd/Giraffe<br>  Added September  1, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Giraffe image 1' src='https://raw.githubusercontent.com/evgeniyd/Giraffe/master/App_Preview_Giraffe_Screens.png'> 
</div>
  </details>

- LivelyGIFs: Show your Live Photos & export as GIF  
  <details><summary><code>objc</code> </summary>

  https://github.com/KrisYu/LivelyGIFs<br>  Added April  6, 2017
  <div><img height='300' alt='LivelyGIFs image 1' src='https://github.com/KrisYu/LivelyGIFs/blob/master/demo.gif?raw=true'> 
</div>
  </details>

- notGIF: Play - Tag - Share your GIFs in Photos [` App Store`](https://itunes.apple.com/app/id1069688631)  
  <details><summary><code>swift</code> <code>gif</code> <code>tag</code> <code>share</code> </summary>

  https://github.com/atuooo/notGIF<br>  Added July  1, 2017<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='notGIF image 1' src='https://raw.githubusercontent.com/atuooo/notGIF/master/images/screenshots.png'> 
</div>
  </details>


### Photo 
 
[back to top](#readme) 
 
- ColorBlur: Add blur to your photos [` App Store`](https://itunes.apple.com/app/id928863510)  
  <details><summary><code>objc</code> </summary>

  https://github.com/maurovc/ColorBlur<br>  Added March 16, 2015<br>  License: `other`
  <div><img height='300' alt='ColorBlur image 1' src='http://a5.mzstatic.com/us/r30/Purple3/v4/68/3f/1b/683f1b36-f274-e2f0-64a6-ae00aadca2ab/screen696x696.jpeg'> <img height='300' alt='ColorBlur image 2' src='http://a4.mzstatic.com/us/r30/Purple1/v4/bb/b9/f5/bbb9f50a-4358-a5d0-604f-29e29ed7677f/screen696x696.jpeg'> <img height='300' alt='ColorBlur image 3' src='http://a3.mzstatic.com/us/r30/Purple3/v4/f9/8c/11/f98c116a-a49a-598e-e5d7-be0684c35bc5/screen696x696.jpeg'> <img height='300' alt='ColorBlur image 4' src='http://a5.mzstatic.com/us/r30/Purple1/v4/ff/6b/2c/ff6b2c22-68be-1f50-868a-e23ff8add3aa/screen696x696.jpeg'> 
</div>
  </details>

- EmotionNote Diary: Choose or take a photo of your face & the app will tell you your emotion  
  <details><summary><code>swift</code> </summary>

  https://github.com/Yogayu/EmotionNote<br>  Added April 19, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='EmotionNote Diary image 1' src='https://github.com/Yogayu/EmotionNote/raw/master/imgs/Desktop%20HD.png'> 
</div>
  </details>

- Megabite: Turn a photo of your food into a face  
  <details><summary><code>opencv</code> <code>pop</code> 🔥🔥</summary>

  https://github.com/AaronRandall/Megabite<br>  Added February  2, 2016<br>  License: `other`
  <div><img height='300' alt='Megabite image 1' src='https://github.com/AaronRandall/Megabite/raw/master/Megabite/Assets.xcassets/Megabite.gif'> 
</div>
  </details>

- mosaix: Create photo mosaic  
  <details><summary><code>swift</code> <code>metal</code> </summary>

  https://github.com/shelly/mosaix<br>  Added December 10, 2017<br>  License: `other`
  <div><img height='300' alt='mosaix image 1' src='https://hunt.blob.core.windows.net/web-images/parallel/gates.jpg'> 
</div>
  </details>

- PixPic: Photo editing  
  <details><summary><code>swift</code> 🔥🔥🔥</summary>

  https://github.com/Yalantis/PixPic<br>  Added July 29, 2016<br>  License: `other`
  <div><img height='300' alt='PixPic image 1' src='https://i.imgur.com/c8ahfkv.png'> 
</div>
  </details>

- SharedImages: Save your images in your own cloud storage (e.g., Google Drive), and safely share those images with others  
  <details><summary><code>swift</code> <code>google drive api</code> <code>facebook api</code> <code>syncserverii client</code> </summary>

  https://github.com/crspybits/SharedImages<br>  Added November 18, 2017<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='SharedImages image 1' src='https://github.com/crspybits/SharedImages/raw/master/Screenshots/screenshot1.png'> 
</div>
  </details>

- Triggy: Intervalometer for WiFi-enabled Canon DSLRs [` App Store`](https://itunes.apple.com/app/triggy/id1193570460)  
  <details><summary><code>swift</code> </summary>

  https://github.com/jnordberg/triggy<br>  Added May 18, 2017<br>  License: [`gpl-3.0`](http://choosealicense.com/licenses/gpl-3.0/)
  <div><img height='300' alt='Triggy image 1' src='https://raw.githubusercontent.com/jnordberg/triggy/master/triggy.jpg'> 
</div>
  </details>


### Video 
 
[back to top](#readme) 
 
- 360 VR Player: 360 video player  
  <details><summary><code>iphone</code> <code>ipad</code> 🔥🔥🔥🔥</summary>

  https://github.com/hanton/HTY360Player<br>  Added December  2, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='360 VR Player image 1' src='http://a3.mzstatic.com/us/r30/Purple60/v4/61/14/fa/6114fa5c-1e42-b09b-53db-55b01eb3e810/screen696x696.jpeg'> <img height='300' alt='360 VR Player image 2' src='http://a3.mzstatic.com/us/r30/Purple20/v4/06/49/61/0649619f-972d-f7b3-f38c-f81f07a78660/screen696x696.jpeg'> <img height='300' alt='360 VR Player image 3' src='http://a4.mzstatic.com/us/r30/Purple20/v4/b5/0e/31/b50e3114-df2c-b729-a344-1f000fdc02e0/screen696x696.jpeg'> 
</div>
  </details>

- DownTube: Download videos from YouTube for offline use  
  <details><summary><code>swift</code> </summary>

  https://github.com/MrAdamBoyd/DownTube<br>  Added June 15, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='DownTube image 1' src='https://raw.githubusercontent.com/MrAdamBoyd/DownTube/master/Screenshots/screenshot1.png'> <img height='300' alt='DownTube image 2' src='https://raw.githubusercontent.com/MrAdamBoyd/DownTube/master/Screenshots/screenshot2.png'> 
</div>
  </details>

- Fetch: The best way to watch Put.io  
  <details><summary><code>iphone</code> <code>ipad</code> <code>alamofire</code> <code>swiftyjson</code> <code>keychainaccess</code> <code>realm</code> <code>1password</code> </summary>

  https://github.com/TryFetch/Fetch<br>  http://getfetchapp.com/<br>  Added November 16, 2016<br>  License: [`gpl-3.0`](http://choosealicense.com/licenses/gpl-3.0/)
  <div><img height='300' alt='Fetch image 1' src='http://getfetchapp.com/img/product.png'> 
</div>
  </details>

- prankPro: Record a 6-second video while playing prank sounds  
  <details><summary><code>objc</code> 🔥🔥</summary>

  https://github.com/huijimuhe/prankPro<br>  Added March 24, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='prankPro image 1' src='https://i.imgur.com/geiofMw.png'> <img height='300' alt='prankPro image 2' src='https://i.imgur.com/fdYYztR.png'> <img height='300' alt='prankPro image 3' src='https://i.imgur.com/sh4pL25.png'> 
</div>
  </details>

- VLC: Media Player [` App Store`](https://itunes.apple.com/app/vlc-for-ios/id650377962)  
  <details><summary><code>objc</code> 🔥🔥🔥🔥🔥</summary>

  https://github.com/videolan/vlc<br>  https://www.videolan.org/<br>  Added March 22, 2015<br>  License: [`gpl-2.0`](http://choosealicense.com/licenses/gpl-2.0/)
  <div><img height='300' alt='VLC image 1' src='http://a2.mzstatic.com/us/r30/Purple1/v4/09/9c/32/099c326b-be06-90db-a070-591bb182b718/screen696x696.jpeg'> <img height='300' alt='VLC image 2' src='http://a1.mzstatic.com/us/r30/Purple1/v4/cf/ea/8e/cfea8e88-0160-6c53-6595-78bb802d5252/screen696x696.jpeg'> <img height='300' alt='VLC image 3' src='http://a1.mzstatic.com/us/r30/Purple5/v4/a6/2b/21/a62b2150-b431-4b12-2707-a681f83554aa/screen696x696.jpeg'> 
</div>
  </details>


## News 
 
[back to top](#readme) 
 
- Designer News: Browse the https://www.designernews.co/ design & technology site  
  <details><summary><code>swift</code> 🔥🔥🔥🔥🔥</summary>

  https://github.com/MengTo/DesignerNewsApp<br>  Added March 15, 2015<br>  License: `other`
  <div><img height='300' alt='Designer News image 1' src='https://cdn-images-1.medium.com/max/800/1*NeMFTvgJVJiM8aiy4Pambw.png'> 
</div>
  </details>

- GrinnellEvents: Grinnell College campus events  
  <details><summary><code>objc</code> </summary>

  https://github.com/kvnbautista/Grinnell-Events-iOS<br>  Added October 16, 2015<br>  License: [`gpl-2.0`](http://choosealicense.com/licenses/gpl-2.0/)
  <div><img height='300' alt='GrinnellEvents image 1' src='http://a3.mzstatic.com/us/r30/Purple1/v4/6e/46/d1/6e46d11f-87e0-0015-cc26-d19bf960a9a9/screen696x696.jpeg'> <img height='300' alt='GrinnellEvents image 2' src='http://a4.mzstatic.com/us/r30/Purple5/v4/e0/29/8c/e0298c8d-bbea-170f-83b8-6939787fc024/screen696x696.jpeg'> <img height='300' alt='GrinnellEvents image 3' src='http://a5.mzstatic.com/us/r30/Purple3/v4/db/93/8a/db938a1c-e143-546b-c453-3b0864599163/screen696x696.jpeg'> 
</div>
  </details>

- Keinex tech blog  
  <details><summary><code>swift</code> </summary>

  https://github.com/AndreyBaranchikov/Keinex-iOS<br>  Added August  8, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Keinex tech blog image 1' src='https://github.com/AndreyBaranchikov/Keinex-iOS/blob/master/1.jpg'> <img height='300' alt='Keinex tech blog image 2' src='https://github.com/AndreyBaranchikov/Keinex-iOS/blob/master/2.jpg'> 
</div>
  </details>

- LobsterApp: Browse the https://lobste.rs/ community news site  
  <details><summary><code>objc</code> </summary>

  https://github.com/rpowelll/LobsterApp<br>  Added July 21, 2016<br>  License: `other`
  <div><img height='300' alt='LobsterApp image 1' src='https://i.imgur.com/WF6eY71.png'> 
</div>
  </details>

- lobsters-reader  
  <details><summary><code>swift</code> </summary>

  https://github.com/cfdrake/lobsters-reader<br>  Added June 13, 2017<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='lobsters-reader image 1' src='https://raw.githubusercontent.com/cfdrake/lobsters-reader/master/Assets/screenshot.png'> 
</div>
  </details>

- NirZhihuDaily2.0  
  <details><summary><code>objc</code> 🇨🇳 🔥🔥🔥🔥</summary>

  https://github.com/zpz1237/NirZhihuDaily2.0<br>  Added November  4, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='NirZhihuDaily2.0 image 1' src='https://github.com/zpz1237/NirZhihuDaily2.0/raw/master/effect1.gif'> 
</div>
  </details>

- TabDump: TabDump news app  
  <details><summary><code>afnetworking</code> </summary>

  https://github.com/dkhamsing/TabDump<br>  Added January 26, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='TabDump image 1' src='https://github.com/dkhamsing/TabDump/raw/master/assets/screenshots/screenshot.png'> 
</div>
  </details>

- The Oakland Post: Oakland University student-run newspaper in Rochester, Michigan  
  <details><summary><code>swift</code> 🔥🔥</summary>

  https://github.com/aclissold/the-oakland-post<br>  Added March 18, 2015<br>  License: [`bsd-3-clause`](http://choosealicense.com/licenses/bsd-3-clause/)
  <div>
</div>
  </details>

- v2ex: Browse the https://www.v2ex.com/ startup, designer & developer site [` App Store`](https://itunes.apple.com/app/v2ex-chuang-yi-gong-zuo-zhe/id898181535)  
  <details><summary><code>objc</code> 🇨🇳 🔥🔥🔥🔥</summary>

  https://github.com/singro/v2ex<br>  Added April 19, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='v2ex image 1' src='http://a4.mzstatic.com/us/r30/Purple18/v4/cd/7e/af/cd7eafe2-9672-c37a-9c95-bad1651e23b9/screen696x696.jpeg'> <img height='300' alt='v2ex image 2' src='http://a1.mzstatic.com/us/r30/Purple18/v4/d5/a3/18/d5a31896-d70d-9d06-ba50-004df03d3735/screen696x696.jpeg'> <img height='300' alt='v2ex image 3' src='http://a2.mzstatic.com/us/r30/Purple20/v4/af/75/88/af7588a9-8481-5d75-f3fd-8b1aa0a35bd6/screen696x696.jpeg'> <img height='300' alt='v2ex image 4' src='http://a5.mzstatic.com/us/r30/Purple60/v4/3a/cb/a3/3acba32e-10c3-4916-1136-ebb922c33a2a/screen696x696.jpeg'> <img height='300' alt='v2ex image 5' src='http://a4.mzstatic.com/us/r30/Purple30/v4/ac/80/bb/ac80bbc1-1f81-1faf-26a0-c141e515082c/screen696x696.jpeg'> 
</div>
  </details>

- ZeitSuche: Search for articles published by Germany's 'Zeit' newspaper.  
  <details><summary><code>swift</code> <code>iphone</code> </summary>

  https://github.com/niftycode/ZeitSuche_iOS<br>  Added June  7, 2017<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='ZeitSuche image 1' src='https://bodo-schoenfeld.de/wp-content/uploads/2016/07/ZeitSuche-Screenshot.png'> 
</div>
  </details>


### Hacker News 
 
https://news.ycombinator.com/ — [back to top](#readme) 
 
- Hacker News Client [` App Store`](https://itunes.apple.com/app/hacker-news-client/id939454231)  
  <details><summary><code>firebase</code> 🔥🔥</summary>

  https://github.com/bonzoq/hniosreader<br>  Added April 30, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Hacker News Client image 1' src='http://a5.mzstatic.com/us/r30/Purple1/v4/46/69/84/46698435-8f5f-dd7f-ac16-367147207a19/screen696x696.jpeg'> <img height='300' alt='Hacker News Client image 2' src='http://a4.mzstatic.com/us/r30/Purple1/v4/e2/ed/6b/e2ed6bb7-0c9f-f508-b05b-f466adedbf2e/screen696x696.jpeg'> <img height='300' alt='Hacker News Client image 3' src='http://a3.mzstatic.com/us/r30/Purple3/v4/af/7a/39/af7a39ec-9064-7d8b-5167-4ba6ef58c46d/screen696x696.jpeg'> <img height='300' alt='Hacker News Client image 4' src='http://a4.mzstatic.com/us/r30/Purple1/v4/86/90/fc/8690fc26-a667-d618-be3d-c84cb55cdb84/screen696x696.jpeg'> 
</div>
  </details>

- HackerNews  
  <details><summary><code>swift</code> 🔥🔥🔥🔥</summary>

  https://github.com/amitburst/HackerNews<br>  Added March 19, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='HackerNews image 1' src='https://github.com/amitburst/HackerNews/raw/master/Resources/screenshot1.png'> 
</div>
  </details>

- Hackers  
  <details><summary><code>swift</code> 🔥🔥</summary>

  https://github.com/weiran/Hackers<br>  Added December 15, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Hackers image 1' src='https://camo.githubusercontent.com/c8ae11c347f57bbb6641ca131dc165f927e3b8c1/687474703a2f2f692e696d6775722e636f6d2f61677a7565744e2e706e67'> 
</div>
  </details>

- HN Reader: Hacker News Reader [` App Store`](https://itunes.apple.com/app/hn-reader-hacker-news-reader/id919243741)  
  <details><summary><code>swift</code> 🔥🔥🔥🔥</summary>

  https://github.com/Dimillian/SwiftHN<br>  Added January 26, 2015<br>  License: [`gpl-2.0`](http://choosealicense.com/licenses/gpl-2.0/)
  <div><img height='300' alt='HN Reader image 1' src='https://cdn-images-1.medium.com/max/800/1*6Bey3OUZ2Xhuk-ZXCB-gOg.png'> 
</div>
  </details>

- news: yc  
  <details><summary><code>objc</code> 🔥🔥🔥🔥</summary>

  https://github.com/grp/newsyc<br>  Added March 19, 2015<br>  License: [`bsd-2-clause`](http://choosealicense.com/licenses/bsd-2-clause/)
  <div>
</div>
  </details>

- React Native Hacker News [` App Store`](https://itunes.apple.com/app/react-native-hacker-news/id1220272464)  
  <details><summary><code>react-native</code> </summary>

  https://github.com/G2Jose/ReactNative-HackerNews<br>  Added March 30, 2017<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='React Native Hacker News image 1' src='https://raw.githubusercontent.com/G2Jose/ReactNative-HackerNews/refactor/redux/screenshots/iOS/show.png'> 
</div>
  </details>

- Simple Reader [` App Store`](https://itunes.apple.com/app/simple-reader-free-open-source/id1000995253)  
  <details><summary><code>objc</code> 🔥🔥</summary>

  https://github.com/rnystrom/HackerNewsReader<br>  Added October 21, 2015<br>  License: `other`
  <div><img height='300' alt='Simple Reader image 1' src='http://a5.mzstatic.com/us/r30/Purple7/v4/f6/ad/cf/f6adcf2a-ede3-ef34-aa6b-97632b2b0ad7/screen696x696.jpeg'> <img height='300' alt='Simple Reader image 2' src='http://a1.mzstatic.com/us/r30/Purple7/v4/6c/cc/9b/6ccc9bab-f69f-e697-e854-785a87fc25ee/screen696x696.jpeg'> <img height='300' alt='Simple Reader image 3' src='http://a4.mzstatic.com/us/r30/Purple5/v4/40/7a/3d/407a3d55-692a-7975-170a-414c2df0e0fe/screen696x696.jpeg'> 
</div>
  </details>


### News API 
 
https://newsapi.org/ — [back to top](#readme) 
 
- DailyFeed  
  <details><summary><code>swift</code> </summary>

  https://github.com/paulsumit1993/DailyFeed<br>  Added January 26, 2017<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='DailyFeed image 1' src='https://raw.githubusercontent.com/paulsumit1993/DailyFeed/master/assets/iphone_dailyfeed.jpg'> 
</div>
  </details>

- News: Discover & read news on a range of news sources/blogs  
  <details><summary><code>objc</code> </summary>

  https://github.com/vanyaland/News<br>  Added November  1, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='News image 1' src='https://raw.githubusercontent.com/vanyaland/News/master/res/sources.png'> <img height='300' alt='News image 2' src='https://raw.githubusercontent.com/vanyaland/News/master/res/articles.png'> <img height='300' alt='News image 3' src='https://raw.githubusercontent.com/vanyaland/News/master/res/article.png'> 
</div>
  </details>


### RSS 
 
[back to top](#readme) 
 
- Feeds4U: Well architected RSS reader [` App Store`](https://itunes.apple.com/app/feeds4u/id1038456442)  
  <details><summary><code>swift</code> </summary>

  https://github.com/EvgenyKarkan/Feeds4U<br>  Added October 10, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Feeds4U image 1' src='http://a3.mzstatic.com/us/r30/Purple41/v4/a1/97/59/a19759d4-a458-cb91-72fd-5ea8b43330e8/screen696x696.jpeg'> <img height='300' alt='Feeds4U image 2' src='http://a1.mzstatic.com/us/r30/Purple3/v4/55/f1/1e/55f11e69-eaa3-3d69-da83-07925223e3c4/screen696x696.jpeg'> <img height='300' alt='Feeds4U image 3' src='http://a2.mzstatic.com/us/r30/Purple69/v4/14/69/32/146932c6-52e1-f6f6-5259-5a7846c24055/screen696x696.jpeg'> <img height='300' alt='Feeds4U image 4' src='http://a5.mzstatic.com/us/r30/Purple69/v4/6e/25/7b/6e257bdc-f103-30ef-f676-acf5018e5ec3/screen696x696.jpeg'> 
</div>
  </details>

- RSSRead: Includes offline mode  
  <details><summary><code>objc</code> 🇨🇳 🔥🔥🔥</summary>

  https://github.com/ming1016/RSSRead<br>  Added April 19, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='RSSRead image 1' src='http://a2.mzstatic.com/us/r30/Purple3/v4/15/a3/26/15a3262c-4dd0-e9c3-9215-3f30cffae17b/screen696x696.jpeg'> <img height='300' alt='RSSRead image 2' src='http://a3.mzstatic.com/us/r30/Purple1/v4/1d/6a/c9/1d6ac957-8507-39bd-a74b-c185399b2ec6/screen696x696.jpeg'> <img height='300' alt='RSSRead image 3' src='http://a1.mzstatic.com/us/r30/Purple5/v4/78/2a/fa/782afab4-c37e-f882-cc1b-52af95d00447/screen696x696.jpeg'> <img height='300' alt='RSSRead image 4' src='http://a5.mzstatic.com/us/r30/Purple5/v4/77/15/8a/77158a0d-e8bd-3fd5-6b23-5e6cde61b9df/screen696x696.jpeg'> <img height='300' alt='RSSRead image 5' src='http://a4.mzstatic.com/us/r30/Purple5/v4/6a/2b/e7/6a2be7dc-361d-e815-e35c-5ce9f47cd1c3/screen696x696.jpeg'> 
</div>
  </details>

- SwiftBlog: Read the official Apple Swift Blog with RSS  
  <details><summary><code>swift</code> </summary>

  https://github.com/BalestraPatrick/SwiftBlog<br>  Added June 21, 2016<br>  License: `other`
  <div><img height='300' alt='SwiftBlog image 1' src='https://github.com/BalestraPatrick/SwiftBlog/raw/master/Screenshot.png'> 
</div>
  </details>

- Tenere News Reader [` App Store`](https://itunes.apple.com/tr/app/tenere-news-reader/id987277462)  
  <details><summary><code>objc</code> </summary>

  https://github.com/yavuz/Tenere<br>  Added August 20, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Tenere News Reader image 1' src='http://a1.mzstatic.com/us/r30/Purple1/v4/75/87/99/75879937-4c0d-a6df-ac99-e1f9b30b8e66/screen696x696.jpeg'> 
</div>
  </details>


## Official 
 
[back to top](#readme) 
 
- Awesome Swift iOS App: Official awesome-swift repository app [` App Store`](https://itunes.apple.com/app/awesome-for-swift-cheatsheet/id1078115427)  
  <details><summary><code>swift</code> </summary>

  https://github.com/matteocrippa/awesome-swift-ios<br>  Added June 11, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Awesome Swift iOS App image 1' src='http://a3.mzstatic.com/us/r30/Purple1/v4/95/16/1a/95161a0b-1f38-d1e3-d535-bab4fdc95cb8/screen696x696.jpeg'> <img height='300' alt='Awesome Swift iOS App image 2' src='http://a4.mzstatic.com/us/r30/Purple1/v4/de/40/91/de4091f4-de82-f018-03b1-67224139f3df/screen696x696.jpeg'> <img height='300' alt='Awesome Swift iOS App image 3' src='http://a2.mzstatic.com/us/r30/Purple1/v4/f3/26/ae/f326aee3-af48-fc10-746e-898072b7d931/screen696x696.jpeg'> <img height='300' alt='Awesome Swift iOS App image 4' src='http://a2.mzstatic.com/us/r30/Purple4/v4/65/33/cf/6533cfdf-3c11-91ad-86c3-707dfdd42e5b/screen696x696.jpeg'> <img height='300' alt='Awesome Swift iOS App image 5' src='http://a5.mzstatic.com/us/r30/Purple49/v4/54/3b/9e/543b9e97-0797-8058-5cbb-e430d6dc605b/screen696x696.jpeg'> 
</div>
  </details>

- Chrome  
  <details><summary><code>objective-c++</code> </summary>

  https://chromium.googlesource.com/chromium/src.git/+/master/ios/<br>  https://blog.chromium.org/2017/01/open-sourcing-chrome-on-ios.html<br>  Added February  1, 2017<br>  License: [`bsd-2-clause`](http://choosealicense.com/licenses/bsd-2-clause/)
  <div><img height='300' alt='Chrome image 1' src='http://a5.mzstatic.com/us/r30/Purple71/v4/4b/d8/9a/4bd89a0d-d1f8-ea48-492a-2cec600c453c/screen696x696.jpeg'> <img height='300' alt='Chrome image 2' src='http://a3.mzstatic.com/us/r30/Purple62/v4/20/f2/6e/20f26eb0-e862-358f-8252-0e299bc89d94/screen696x696.jpeg'> <img height='300' alt='Chrome image 3' src='http://a3.mzstatic.com/us/r30/Purple71/v4/53/5b/b4/535bb49d-d1ec-7edc-4195-ba0359de2779/screen696x696.jpeg'> <img height='300' alt='Chrome image 4' src='http://a5.mzstatic.com/us/r30/Purple62/v4/56/ee/b0/56eeb0f0-0e39-cb27-d389-511e2d9964c4/screen696x696.jpeg'> <img height='300' alt='Chrome image 5' src='http://a5.mzstatic.com/us/r30/Purple62/v4/e8/a1/ab/e8a1ab12-b616-f9d0-7f1b-2e1764b0e872/screen696x696.jpeg'> 
</div>
  </details>

- Coding: Official Coding app [` App Store`](https://itunes.apple.com/app/coding/id923676989)  
  <details><summary><code>reactivecocoa</code> <code>masonry</code> 🇨🇳 🔥🔥🔥🔥🔥</summary>

  https://github.com/Coding/Coding-iOS<br>  Added September 26, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Coding image 1' src='http://a4.mzstatic.com/us/r30/Purple69/v4/d9/af/b7/d9afb7d3-1d4c-2e44-1501-371f2a32a0da/screen696x696.jpeg'> <img height='300' alt='Coding image 2' src='http://a5.mzstatic.com/us/r30/Purple69/v4/ed/8c/2f/ed8c2f53-0d0f-e44f-40a8-f55f87dfd517/screen696x696.jpeg'> <img height='300' alt='Coding image 3' src='http://a4.mzstatic.com/us/r30/Purple49/v4/43/09/21/430921eb-aa5a-c68a-9c02-8372dba3a241/screen696x696.jpeg'> <img height='300' alt='Coding image 4' src='http://a5.mzstatic.com/us/r30/Purple69/v4/43/f2/27/43f227be-e0ec-f5de-ef7c-5a786719899a/screen696x696.jpeg'> <img height='300' alt='Coding image 5' src='http://a4.mzstatic.com/us/r30/Purple69/v4/42/98/19/429819d8-b91b-d248-3fc1-1a6f127d82de/screen696x696.jpeg'> 
</div>
  </details>

- DuckDuckGo: Official DuckDuckGo app [` App Store`](https://itunes.apple.com/app/duckduckgo-search-stories/id663592361)  
  <details><summary><code>afnetworking</code> 🔥🔥</summary>

  https://github.com/duckduckgo/ios<br>  Added March 17, 2016<br>  License: [`apache-2.0`](http://choosealicense.com/licenses/apache-2.0/)
  <div><img height='300' alt='DuckDuckGo image 1' src='http://a4.mzstatic.com/us/r30/Purple22/v4/09/83/3f/09833f7a-445e-0324-7d0e-6b75d9a3a7c3/screen696x696.jpeg'> <img height='300' alt='DuckDuckGo image 2' src='http://a3.mzstatic.com/us/r30/Purple41/v4/54/30/1f/54301f79-bded-4986-157f-4daf3012a244/screen696x696.jpeg'> <img height='300' alt='DuckDuckGo image 3' src='http://a3.mzstatic.com/us/r30/Purple62/v4/8e/16/b1/8e16b1e7-eefb-4b60-5525-d7cece5debb9/screen696x696.jpeg'> <img height='300' alt='DuckDuckGo image 4' src='http://a4.mzstatic.com/us/r30/Purple41/v4/a4/38/86/a43886a3-5ece-21bd-33ef-68b21be66d0c/screen696x696.jpeg'> <img height='300' alt='DuckDuckGo image 5' src='http://a1.mzstatic.com/us/r30/Purple19/v4/2b/42/1c/2b421c88-688e-9213-b647-c6a22bf41d66/screen696x696.jpeg'> 
</div>
  </details>

- F8 2016: Official F8 app  
  <details><summary><code>react native</code> 🔥🔥🔥🔥🔥</summary>

  https://github.com/fbsamples/f8app<br>  Added April 14, 2016<br>  License: `other`
  <div><img height='300' alt='F8 2016 image 1' src='https://github.com/fbsamples/f8app/raw/master/.github/screenshot-app@2x.png'> 
</div>
  </details>

- Firefox: Official Firefox app [` App Store`](https://itunes.apple.com/app/firefox-web-browser/id989804926)  
  <details><summary><code>swift</code> <code>carthage</code> <code>alamofire</code> <code>snapkit</code> <code>libphonenumber</code> 🔥🔥🔥🔥🔥</summary>

  https://github.com/mozilla-mobile/firefox-ios<br>  Added January 26, 2015<br>  License: [`mpl-2.0`](http://choosealicense.com/licenses/mpl-2.0/)
  <div><img height='300' alt='Firefox image 1' src='http://a4.mzstatic.com/us/r30/Purple49/v4/53/81/08/53810869-af7c-31ff-c2bd-43b2a7ec5f56/screen322x572.jpeg'> 
</div>
  </details>

- Kickstarter: Where independent creators & passionate backers come together to bring new ideas to life [` App Store`](https://itunes.apple.com/app/kickstarter/id596961532)  
  <details><summary><code>swift</code> <code>1password</code> <code>alamorefire</code> <code>stripe</code> <code>ios-snapshot-test-case</code> 🔥🔥🔥🔥🔥</summary>

  https://github.com/kickstarter/ios-oss<br>  Added December 14, 2016<br>  License: [`apache-2.0`](http://choosealicense.com/licenses/apache-2.0/)
  <div><img height='300' alt='Kickstarter image 1' src='http://a1.mzstatic.com/us/r30/Purple71/v4/80/e2/06/80e206db-711c-ba1d-dfd1-cf02de5336d7/screen696x696.jpeg'> <img height='300' alt='Kickstarter image 2' src='http://a3.mzstatic.com/us/r30/Purple71/v4/80/e7/17/80e717dd-3ff1-7159-6e0a-5a357b197184/screen696x696.jpeg'> <img height='300' alt='Kickstarter image 3' src='http://a4.mzstatic.com/us/r30/Purple71/v4/25/fb/c7/25fbc7b3-ac7c-6019-9a15-c86491121989/screen696x696.jpeg'> <img height='300' alt='Kickstarter image 4' src='http://a4.mzstatic.com/us/r30/Purple71/v4/e9/73/49/e97349df-f83d-5970-8937-fffb38fb544c/screen696x696.jpeg'> <img height='300' alt='Kickstarter image 5' src='http://a2.mzstatic.com/us/r30/Purple71/v4/ad/c0/93/adc0936c-22d3-d2c1-cb7b-c53cd1f79b9c/screen696x696.jpeg'> 
</div>
  </details>

- Kodi: A popular media player & entertainment hub  
  <details><summary><code>objc</code> 🔥🔥🔥🔥🔥</summary>

  https://github.com/xbmc/xbmc<br>  https://kodi.wiki/view/IOS<br>  Added June  1, 2016<br>  License: [`gpl-2.0`](http://choosealicense.com/licenses/gpl-2.0/)
  <div><img height='300' alt='Kodi image 1' src='https://kodi.wiki/images/9/99/Kodi_on_ipad_in_hand.jpg'> 
</div>
  </details>

- Kodi Remote: A full-featured remote control for Kodi Media Center [` App Store`](https://itunes.apple.com/app/id520480364)  
  <details><summary><code>objc</code> 🔥🔥🔥🔥🔥</summary>

  https://github.com/xbmc/xbmc<br>  https://kodi.tv/<br>  Added June  1, 2016<br>  License: [`gpl-2.0`](http://choosealicense.com/licenses/gpl-2.0/)
  <div><img height='300' alt='Kodi Remote image 1' src='http://a2.mzstatic.com/us/r30/Purple3/v4/b4/ec/a9/b4eca96d-142c-d230-9eff-37a11d98dca3/screen696x696.jpeg'> <img height='300' alt='Kodi Remote image 2' src='http://a3.mzstatic.com/us/r30/Purple3/v4/ad/18/46/ad1846eb-e78b-f5a8-c404-967ac5ff18f3/screen696x696.jpeg'> <img height='300' alt='Kodi Remote image 3' src='http://a5.mzstatic.com/us/r30/Purple2/v4/b1/ff/95/b1ff95a3-1bf4-c7f7-f57f-18f45e2323d7/screen696x696.jpeg'> <img height='300' alt='Kodi Remote image 4' src='http://a3.mzstatic.com/us/r30/Purple3/v4/4c/20/5e/4c205e02-766b-69c5-7423-34e2eeb85921/screen696x696.jpeg'> <img height='300' alt='Kodi Remote image 5' src='http://a3.mzstatic.com/us/r30/Purple3/v4/2f/3a/30/2f3a30f0-166d-e7ac-34a5-9b6559ef54a5/screen696x696.jpeg'> 
</div>
  </details>

- Northern California Cherry Blossom Festival [` App Store`](https://itunes.apple.com/app/northern-california-cherry-blossom-festival/id981016442)  
  <details><summary><code>swift</code> </summary>

  https://github.com/keitaito/NCCBF-iOS<br>  https://sfcherryblossom.org/<br>  Added May  4, 2017<br>  License: `other`
  <div><img height='300' alt='Northern California Cherry Blossom Festival image 1' src='http://a5.mzstatic.com/us/r30/Purple122/v4/85/60/0d/85600dea-3b85-bb34-07c0-a66db27d11e3/screen696x696.jpeg'> <img height='300' alt='Northern California Cherry Blossom Festival image 2' src='http://a5.mzstatic.com/us/r30/Purple111/v4/5d/00/d6/5d00d698-9537-6216-575f-b9dd327d3219/screen696x696.jpeg'> <img height='300' alt='Northern California Cherry Blossom Festival image 3' src='http://a3.mzstatic.com/us/r30/Purple111/v4/e5/97/e2/e597e2e9-2d30-f341-72b9-fe1a1227b8c4/screen696x696.jpeg'> 
</div>
  </details>

- osia: Super basic app to browse open-source-ios-apps  
  <details><summary><code>swift</code> </summary>

  https://github.com/dkhamsing/osia<br>  Added July 25, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='osia image 1' src='https://github.com/dkhamsing/osia/raw/master/Assets/0.1.png'> 
</div>
  </details>

- Radio Paradise: Official app for http://www.radioparadise.com/ [` App Store`](https://itunes.apple.com/app/id663334697)  
  <details><summary><code>objc</code> </summary>

  https://github.com/ilTofa/rposx<br>  https://www.iltofa.com/rphd/<br>  Added June  1, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Radio Paradise image 1' src='http://a5.mzstatic.com/us/r30/Purple30/v4/97/22/95/97229577-fbbd-2de8-3822-b906eadb6354/screen800x500.jpeg'> 
</div>
  </details>

- Scholars of WWDC: Official app of recipients for https://developer.apple.com/wwdc/scholarships/ [` App Store`](https://itunes.apple.com/app/scholars-of-wwdc/id999731893)  
  <details><summary><code>swift</code> </summary>

  https://github.com/WWDCScholars/iOS-app<br>  Added July 12, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Scholars of WWDC image 1' src='http://a1.mzstatic.com/us/r30/Purple60/v4/ab/92/bb/ab92bbe9-6540-ff6b-836d-9fd737221466/screen696x696.jpeg'> 
</div>
  </details>

- Simplenote: Keep notes, lists, ideas & more (sync in the cloud) — includes sharing notes, collaboration. [` App Store`](https://itunes.apple.com/app/simplenote/id289429962)  
  <details><summary><code>1password</code> <code>fabric</code> <code>crashlytics</code> 🔥🔥🔥🔥</summary>

  https://github.com/automattic/simplenote-ios<br>  https://simplenote.com/<br>  Added August 11, 2016<br>  License: [`gpl-2.0`](http://choosealicense.com/licenses/gpl-2.0/)
  <div><img height='300' alt='Simplenote image 1' src='https://cdn.pastemagazine.com/www/articles/simplenoteapp.jpg'> 
</div>
  </details>

- VLC: Media Player [` App Store`](https://itunes.apple.com/app/vlc-for-ios/id650377962)  
  <details><summary><code>objc</code> 🔥🔥🔥🔥🔥</summary>

  https://github.com/videolan/vlc<br>  https://www.videolan.org/<br>  Added March 22, 2015<br>  License: [`gpl-2.0`](http://choosealicense.com/licenses/gpl-2.0/)
  <div><img height='300' alt='VLC image 1' src='http://a2.mzstatic.com/us/r30/Purple1/v4/09/9c/32/099c326b-be06-90db-a070-591bb182b718/screen696x696.jpeg'> <img height='300' alt='VLC image 2' src='http://a1.mzstatic.com/us/r30/Purple1/v4/cf/ea/8e/cfea8e88-0160-6c53-6595-78bb802d5252/screen696x696.jpeg'> <img height='300' alt='VLC image 3' src='http://a1.mzstatic.com/us/r30/Purple5/v4/a6/2b/21/a62b2150-b431-4b12-2707-a681f83554aa/screen696x696.jpeg'> 
</div>
  </details>

- WhiteHouse: Official White House app  
  <details><summary><code>objc</code> 🔥🔥🔥</summary>

  https://github.com/WhiteHouse/wh-app-ios<br>  Added May 15, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='WhiteHouse image 1' src='http://a3.mzstatic.com/us/r30/Purple3/v4/da/18/da/da18da5c-96e9-42cb-e181-01aebb59d499/screen696x696.jpeg'> <img height='300' alt='WhiteHouse image 2' src='http://a2.mzstatic.com/us/r30/Purple1/v4/a7/7a/bc/a77abcc4-65df-4a35-4ab8-d5c231c83198/screen696x696.jpeg'> <img height='300' alt='WhiteHouse image 3' src='http://a4.mzstatic.com/us/r30/Purple3/v4/c1/1b/6b/c11b6bf8-f1ce-9484-ddcb-dd3958dc76e9/screen696x696.jpeg'> <img height='300' alt='WhiteHouse image 4' src='http://a1.mzstatic.com/us/r30/Purple3/v4/db/ce/8b/dbce8bbc-ecbd-9a60-8b3e-7b47bdb2c6f9/screen696x696.jpeg'> <img height='300' alt='WhiteHouse image 5' src='http://a2.mzstatic.com/us/r30/Purple3/v4/ad/42/ad/ad42add7-5082-3bdd-67eb-10c428431134/screen696x696.jpeg'> 
</div>
  </details>

- Wikipedia: Official Wikipedia app [` App Store`](https://itunes.apple.com/app/wikipedia-mobile/id324715238)  
  <details><summary><code>swift</code> 🔥🔥🔥🔥</summary>

  https://github.com/wikimedia/wikipedia-ios<br>  Added January 26, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Wikipedia image 1' src='http://a3.mzstatic.com/us/r30/Purple71/v4/a4/f7/b2/a4f7b2e5-12d4-d242-90b1-deb18c9e678e/screen696x696.jpeg'> <img height='300' alt='Wikipedia image 2' src='http://a3.mzstatic.com/us/r30/Purple71/v4/0e/db/08/0edb082a-8c49-82cd-be7f-5ce5af9dbb6a/screen696x696.jpeg'> <img height='300' alt='Wikipedia image 3' src='http://a2.mzstatic.com/us/r30/Purple71/v4/b4/41/78/b441780c-9042-3048-a9f2-1c4fa9a729bf/screen696x696.jpeg'> <img height='300' alt='Wikipedia image 4' src='http://a5.mzstatic.com/us/r30/Purple71/v4/62/5b/fe/625bfe5a-67d7-794e-2098-e9fb6a7f2716/screen696x696.jpeg'> <img height='300' alt='Wikipedia image 5' src='http://a2.mzstatic.com/us/r30/Purple71/v4/c3/8f/6e/c38f6e06-ae1a-32b6-7a01-5f28ddf19629/screen696x696.jpeg'> 
</div>
  </details>

- Wire: Modern, private communications with crystal clear voice, video, group chats. Always encrypted. [` App Store`](https://itunes.apple.com/app/wire/id930944768)  
  <details><summary><code>swift</code> <code>carthage</code> <code>afnetworking</code> <code>purelayout</code> 🔥🔥🔥🔥🔥</summary>

  https://github.com/wireapp/wire-ios<br>  Added July 22, 2016<br>  License: [`gpl-3.0`](http://choosealicense.com/licenses/gpl-3.0/)
  <div><img height='300' alt='Wire image 1' src='https://cdn-images-1.medium.com/max/800/1*CEtofzY1rIOKuGT7JO3VkA.png'> 
</div>
  </details>

- WordPress: Official WordPress app [` App Store`](https://itunes.apple.com/app/wordpress/id335703880)  
  <details><summary><code>objc</code> 🔥🔥🔥🔥🔥</summary>

  https://github.com/wordpress-mobile/WordPress-iOS<br>  Added March 17, 2015<br>  License: [`gpl-2.0`](http://choosealicense.com/licenses/gpl-2.0/)
  <div><img height='300' alt='WordPress image 1' src='https://cdn-images-1.medium.com/max/800/1*DC2_2VNsltlTH_16RKIvsw.png'> 
</div>
  </details>


## Reactive Programming 
 
[back to top](#readme) 
 
- Siesta GitHub Browser: Browse & star GitHub repositories  
  <details><summary><code>swift</code> <code>rest</code> 🔥🔥🔥</summary>

  https://github.com/bustoutsolutions/siesta/tree/master/Examples/GithubBrowser<br>  Added July 26, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Siesta GitHub Browser image 1' src='https://i.imgur.com/OBGvFKw.png'> <img height='300' alt='Siesta GitHub Browser image 2' src='https://i.imgur.com/50eCbeX.png'> 
</div>
  </details>


### ReactiveCocoa 
 
https://github.com/ReactiveCocoa/ReactiveCocoa — [back to top](#readme) 
 
- Arex: Reminders for taking your medications  
  <details><summary><code>swift</code> <code>swift2.2</code> <code>carthage</code> <code>pistachio</code> <code>reactivecocoa</code> </summary>

  https://github.com/a2/arex<br>  Added June  9, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  </details>

- Artsy: The art world in your pocket [` App Store`](https://itunes.apple.com/app/artsy-art-world-in-your-pocket/id703796080)  
  <details><summary><code>iphone</code> <code>ipad</code> <code>afnetworking</code> <code>mantle</code> <code>cocoapodskeys</code> <code>reactivecocoa</code> 🔥🔥🔥🔥🔥</summary>

  https://github.com/artsy/eigen<br>  Added January 26, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Artsy image 1' src='http://a1.mzstatic.com/us/r30/Purple30/v4/f9/fd/e3/f9fde323-7f53-12d9-99cc-94f435fc9a06/screen696x696.jpeg'> <img height='300' alt='Artsy image 2' src='http://a1.mzstatic.com/us/r30/Purple30/v4/dc/17/9a/dc179a52-4cda-f91e-c36a-5d6bce72ff3c/screen696x696.jpeg'> <img height='300' alt='Artsy image 3' src='http://a5.mzstatic.com/us/r30/Purple30/v4/52/65/c4/5265c4b3-5d0c-4fce-1520-f1a6da6835af/screen696x696.jpeg'> <img height='300' alt='Artsy image 4' src='http://a2.mzstatic.com/us/r30/Purple20/v4/9f/84/d6/9f84d61d-59d5-e10e-236a-fd8c9685c9c1/screen696x696.jpeg'> <img height='300' alt='Artsy image 5' src='http://a2.mzstatic.com/us/r30/Purple18/v4/75/09/05/75090520-f464-e0c4-8d9b-9b07c6bb8c15/screen696x696.jpeg'> 
</div>
  </details>

- BrewMobile: App for managing the beer brewing process  
  <details><summary><code>swift</code> 🔥</summary>

  https://github.com/brewfactory/BrewMobile<br>  Added September 10, 2015<br>  License: `other`
  <div><img height='300' alt='BrewMobile image 1' src='https://camo.githubusercontent.com/edffaf12ff2fcc5e3e2b85539c6ab372fdfd41a7/687474703a2f2f62726577666163746f72792e6f72672f427265774d6f62696c652f696d672f395f736d616c6c2e706e67'> 
</div>
  </details>

- C-41: Simple timer to make developing film easier & more reliable  
  <details><summary><code>objc</code> 🔥🔥🔥🔥</summary>

  https://github.com/ashfurrow/C-41<br>  Added January 26, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div>
</div>
  </details>

- Coding: Official Coding app [` App Store`](https://itunes.apple.com/app/coding/id923676989)  
  <details><summary><code>reactivecocoa</code> <code>masonry</code> 🇨🇳 🔥🔥🔥🔥🔥</summary>

  https://github.com/Coding/Coding-iOS<br>  Added September 26, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Coding image 1' src='http://a4.mzstatic.com/us/r30/Purple69/v4/d9/af/b7/d9afb7d3-1d4c-2e44-1501-371f2a32a0da/screen696x696.jpeg'> <img height='300' alt='Coding image 2' src='http://a5.mzstatic.com/us/r30/Purple69/v4/ed/8c/2f/ed8c2f53-0d0f-e44f-40a8-f55f87dfd517/screen696x696.jpeg'> <img height='300' alt='Coding image 3' src='http://a4.mzstatic.com/us/r30/Purple49/v4/43/09/21/430921eb-aa5a-c68a-9c02-8372dba3a241/screen696x696.jpeg'> <img height='300' alt='Coding image 4' src='http://a5.mzstatic.com/us/r30/Purple69/v4/43/f2/27/43f227be-e0ec-f5de-ef7c-5a786719899a/screen696x696.jpeg'> <img height='300' alt='Coding image 5' src='http://a4.mzstatic.com/us/r30/Purple69/v4/42/98/19/429819d8-b91b-d248-3fc1-1a6f127d82de/screen696x696.jpeg'> 
</div>
  </details>

- Crystal Clipboard: Copy and paste between devices [` App Store`](https://itunes.apple.com/app/crystal-clipboard/id1287332321)  
  <details><summary><code>swift</code> <code>swift4</code> <code>cocoapodskeys</code> <code>reactivecocoa</code> <code>moya</code> <code>starscream</code> <code>mvvm</code> </summary>

  https://github.com/jzzocc/crystal-clipboard-ios<br>  Added October 12, 2017<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Crystal Clipboard image 1' src='https://raw.githubusercontent.com/jzzocc/crystal-clipboard-ios/master/screenshots/en-US/iPhone%208-landing.png'> <img height='300' alt='Crystal Clipboard image 2' src='https://raw.githubusercontent.com/jzzocc/crystal-clipboard-ios/master/screenshots/en-US/iPhone%208-clips.png'> <img height='300' alt='Crystal Clipboard image 3' src='https://raw.githubusercontent.com/jzzocc/crystal-clipboard-ios/master/screenshots/en-US/iPhone%208-add.png'> 
</div>
  </details>

- Giraffe  
  <details><summary><code>swift</code> <code>reactivecocoa</code> </summary>

  https://github.com/evgeniyd/Giraffe<br>  Added September  1, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Giraffe image 1' src='https://raw.githubusercontent.com/evgeniyd/Giraffe/master/App_Preview_Giraffe_Screens.png'> 
</div>
  </details>

- GitBucket: GitHub app [` App Store`](https://itunes.apple.com/app/id961330940)  
  <details><summary><code>reactivecocoa</code> <code>mvvm</code> <code>mantle</code> 🔥🔥🔥🔥🔥</summary>

  https://github.com/leichunfeng/MVVMReactiveCocoa<br>  Added October 12, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='GitBucket image 1' src='http://a4.mzstatic.com/us/r30/Purple20/v4/ba/37/a3/ba37a3d1-622f-866f-f9eb-e2d21173cc93/screen696x696.jpeg'> <img height='300' alt='GitBucket image 2' src='http://a5.mzstatic.com/us/r30/Purple20/v4/8e/06/d7/8e06d79a-ede3-284c-df34-9702c835a382/screen696x696.jpeg'> <img height='300' alt='GitBucket image 3' src='http://a5.mzstatic.com/us/r30/Purple60/v4/24/11/37/2411374d-175b-7290-1f36-8190f4ee7740/screen696x696.jpeg'> <img height='300' alt='GitBucket image 4' src='http://a3.mzstatic.com/us/r30/Purple20/v4/cb/ab/b6/cbabb6b4-854f-9b86-ddaa-d9455dc272cc/screen696x696.jpeg'> <img height='300' alt='GitBucket image 5' src='http://a5.mzstatic.com/us/r30/Purple60/v4/a2/64/07/a2640705-ccef-163c-56e5-87a7874d9483/screen696x696.jpeg'> 
</div>
  </details>

- ReactiveSwiftFlickrSearch: Photo search  
  <details><summary><code>swift</code> <code>mvvm</code> <code>flickr api</code> 🔥🔥</summary>

  https://github.com/ColinEberhardt/ReactiveSwiftFlickrSearch<br>  Added February  4, 2015<br>  License: `other`
  <div><img height='300' alt='ReactiveSwiftFlickrSearch image 1' src='https://github.com/ColinEberhardt/ReactiveSwiftFlickrSearch/raw/master/FinishedApp.png'> 
</div>
  </details>

- SimpleAuth: Simple authentication (OAuth for Twitter, Facebook, Instagram, Tumblr & more)  
  <details><summary><code>objc</code> 🔥🔥🔥🔥</summary>

  https://github.com/calebd/SimpleAuth<br>  Added April 10, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='SimpleAuth image 1' src='https://i.imgur.com/OxImInV.png'> 
</div>
  </details>

- Tropos Weather [` App Store`](https://itunes.apple.com/app/tropos-weather-forecasts-for/id955209376)  
  <details><summary><code>dark sky api (forecast api)</code> <code>reactivecocoa</code> 🔥🔥🔥🔥</summary>

  https://github.com/thoughtbot/Tropos<br>  Added June 22, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Tropos Weather image 1' src='http://a2.mzstatic.com/us/r30/Purple5/v4/8b/3e/bd/8b3ebd2c-9dfe-1ce5-cdf5-8c89d854e375/screen696x696.jpeg'> <img height='300' alt='Tropos Weather image 2' src='http://a3.mzstatic.com/us/r30/Purple5/v4/e6/4f/36/e64f369d-d453-f007-dd15-361d21641116/screen696x696.jpeg'> 
</div>
  </details>


### RxSwift 
 
https://github.com/ReactiveX/RxSwift — [back to top](#readme) 
 
- Count It: Dead simple way to you count anything  
  <details><summary><code>swift</code> </summary>

  https://github.com/PiXeL16/CountItApp<br>  Added July 11, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Count It image 1' src='http://a4.mzstatic.com/us/r30/Purple49/v4/d9/07/8b/d9078bba-fcf6-8de1-c674-d69b895f17c6/screen696x696.jpeg'> <img height='300' alt='Count It image 2' src='http://a3.mzstatic.com/us/r30/Purple49/v4/85/9b/94/859b94ea-b37e-6f77-fe7b-afc9f76934e7/screen696x696.jpeg'> <img height='300' alt='Count It image 3' src='http://a5.mzstatic.com/us/r30/Purple49/v4/19/de/08/19de08b9-4688-556e-c544-bfcc2d8154fb/screen696x696.jpeg'> <img height='300' alt='Count It image 4' src='http://a1.mzstatic.com/us/r30/Purple49/v4/83/71/1c/83711c7a-0119-cc7f-5f86-9e1da4d210c6/screen696x696.jpeg'> 
</div>
  </details>

- Drrrible [` App Store`](https://itunes.apple.com/app/drrrible/id1229592223)  
  <details><summary><code>swift</code> <code>dribbble</code> <code>reactorkit</code> <code>moya</code> <code>kingfisher</code> 🔥🔥</summary>

  https://github.com/devxoul/Drrrible<br>  Added May  3, 2017<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Drrrible image 1' src='http://a3.mzstatic.com/us/r30/Purple111/v4/32/20/62/32206236-57e6-dd41-ccc6-9d9870a6e1ac/screen696x696.jpeg'> <img height='300' alt='Drrrible image 2' src='http://a4.mzstatic.com/us/r30/Purple111/v4/6f/1f/77/6f1f771f-c9a8-5d60-6556-1bcb3993d568/screen696x696.jpeg'> <img height='300' alt='Drrrible image 3' src='http://a1.mzstatic.com/us/r30/Purple122/v4/81/bc/39/81bc3933-4d0a-97da-88ab-265b679a2801/screen696x696.jpeg'> 
</div>
  </details>

- GitHub API Client  
  <details><summary><code>swift</code> <code>mvvm</code> <code>rxswift</code> 🔥🔥</summary>

  https://github.com/tailec/boilerplate<br>  Added March 14, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='GitHub API Client image 1' src='https://i.imgur.com/611wefH.png'> 
</div>
  </details>

- GrandCentralBoard: Hang a TV in your open space / team room to show everyone what's up & get them up to speed  
  <details><summary><code>swift</code> <code>alamofire</code> <code>rxswift</code> 🔥🔥</summary>

  https://github.com/macoscope/GrandCentralBoard<br>  Added April 29, 2016<br>  License: [`gpl-3.0`](http://choosealicense.com/licenses/gpl-3.0/)
  <div><img height='300' alt='GrandCentralBoard image 1' src='http://cdn.macoscope.com/blog/wp-content/uploads/2016/03/zegar_anim_1.gif'> 
</div>
  </details>

- Kiosk: Artsy auction app  
  <details><summary><code>swift</code> <code>rxswift</code> 🔥🔥🔥🔥🔥</summary>

  https://github.com/artsy/eidolon<br>  Added January 27, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Kiosk image 1' src='http://artsy.github.io/images/2014-11-12-eidolon-retrospective/listings.png'> 
</div>
  </details>

- RxCurrency: Currency converter for ReactiveX  
  <details><summary><code>swift</code> <code>swift3</code> </summary>

  https://github.com/inkyfox/RxCurrency_iOS<br>  Added February 16, 2017<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='RxCurrency image 1' src='https://raw.githubusercontent.com/inkyfox/RxCurrency_iOS/master/RxCurrency.gif'> 
</div>
  </details>

- RxMarbles: Interactive diagrams of Rx Observables [` App Store`](https://itunes.apple.com/us/app/rxmarbles/id1087272442)  
  <details><summary><code>swift</code> 🔥🔥</summary>

  https://github.com/RxSwiftCommunity/RxMarbles<br>  Added June 29, 2016<br>  License: `other`
  <div><img height='300' alt='RxMarbles image 1' src='http://a3.mzstatic.com/us/r30/Purple49/v4/87/c5/e3/87c5e346-4f01-ce50-b03f-a50d7fa02740/screen696x696.jpeg'> <img height='300' alt='RxMarbles image 2' src='http://a4.mzstatic.com/us/r30/Purple69/v4/1b/db/f3/1bdbf390-575d-e759-2ea3-7e734f1d088a/screen696x696.jpeg'> <img height='300' alt='RxMarbles image 3' src='http://a2.mzstatic.com/us/r30/Purple69/v4/71/00/9b/71009b0c-6e10-1d12-e182-a2a88b1e077d/screen696x696.jpeg'> 
</div>
  </details>

- RxTodo  
  <details><summary><code>swift</code> <code>swift3</code> <code>rxswift</code> <code>mvvm</code> 🔥🔥🔥</summary>

  https://github.com/devxoul/RxTodo<br>  Added September 19, 2016<br>  License: `other`
  <div><img height='300' alt='RxTodo image 1' src='https://cloud.githubusercontent.com/assets/931655/16531082/eae3ead2-4005-11e6-8537-a6856d704d74.png'> 
</div>
  </details>

- Tweetometer: See who is tweeting in your timeline  
  <details><summary><code>swift</code> </summary>

  https://github.com/BalestraPatrick/Tweetometer<br>  Added May 26, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Tweetometer image 1' src='https://github.com/BalestraPatrick/Tweetometer/raw/master/header.png'> 
</div>
  </details>


## Sample 
 
[back to top](#readme) 
 
- 30 days of React Native demos  
  <details><summary><code>react native</code> 🔥🔥🔥🔥🔥</summary>

  https://github.com/fangwei716/30-days-of-react-native<br>  Added August 15, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='30 days of React Native demos image 1' src='https://raw.githubusercontent.com/fangwei716/ThirtyDaysOfReactNative/screenshots/screenshot/main.gif'> 
</div>
  </details>

- Apple Developer Library  
  <details><summary><code>objc</code> </summary>

  https://developer.apple.com/library/content/navigation/#section=Resource%20Types&topic=Sample%20Code<br>  Added March 24, 2015<br>  License: `other`
  </details>

- Apple WWDC 2015: Code samples from WWDC 2015  
  <details><summary><code>objc</code> </summary>

  https://developer.apple.com/sample-code/wwdc/2015/<br>  Added July 16, 2015<br>  License: `other`
  </details>

- Artist: Use Relay to access the Artsy GraphQL API  
  <details><summary><code>react native</code> <code>graphql</code> </summary>

  https://github.com/orta/Relay-Artist-Example<br>  Added February  7, 2017<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Artist image 1' src='https://github.com/orta/Relay-Artist-Example/raw/master/screenshots/workshop.png?raw=true'> 
</div>
  </details>

- Cannonball: Fun way to create / share stories & poems [` App Store`](https://itunes.apple.com/app/cannonball-magnetic-poetry/id929750075)  
  <details><summary><code>swift</code> 🔥🔥</summary>

  https://github.com/crashlytics/cannonball-ios<br>  Added March 24, 2015<br>  License: [`apache-2.0`](http://choosealicense.com/licenses/apache-2.0/)
  <div><img height='300' alt='Cannonball image 1' src='http://a4.mzstatic.com/us/r30/Purple7/v4/e6/7b/37/e67b37c8-46a3-eff4-e8e4-85070f1604b9/screen696x696.jpeg'> <img height='300' alt='Cannonball image 2' src='http://a5.mzstatic.com/us/r30/Purple5/v4/7a/09/1c/7a091c85-509a-2d34-ba92-d6361a700fed/screen696x696.jpeg'> <img height='300' alt='Cannonball image 3' src='http://a2.mzstatic.com/us/r30/Purple5/v4/3e/65/ce/3e65ce5f-554c-1dcc-4b7c-078ada30284d/screen696x696.jpeg'> <img height='300' alt='Cannonball image 4' src='http://a1.mzstatic.com/us/r30/Purple7/v4/17/67/a9/1767a993-71ca-6e9d-9712-6d858747ea0d/screen696x696.jpeg'> <img height='300' alt='Cannonball image 5' src='http://a5.mzstatic.com/us/r30/Purple7/v4/99/87/f0/9987f0a1-1b59-8ee1-24d1-243d443e253e/screen696x696.jpeg'> 
</div>
  </details>

- CastVideos: Sender app to be used as the starting for Google Cast  
  <details><summary><code>swift</code> </summary>

  https://github.com/googlecast/CastVideos-ios<br>  Added July 10, 2017<br>  License: [`apache-2.0`](http://choosealicense.com/licenses/apache-2.0/)
  </details>

- CloudKit  
  <details><summary><code>cloudkit</code> 🔥</summary>

  https://github.com/Yalantis/CloudKit-Demo.Objective-C<br>  Added May 17, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='CloudKit image 1' src='https://i.imgur.com/anNR2DT.png'> 
</div>
  </details>

- CloudKit  
  <details><summary><code>swift</code> <code>cloudkit</code> 🔥🔥</summary>

  https://github.com/Yalantis/CloudKit-Demo.Swift<br>  Added May 17, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='CloudKit image 1' src='https://i.imgur.com/dS9aFJL.png'> 
</div>
  </details>

- Face Landmarks Detection: Find facial features such as face contour, eyes, mouth and nose in an image  
  <details><summary><code>swift</code> <code>vision</code> </summary>

  https://github.com/mattlawer/FaceLandmarksDetection<br>  Added January 25, 2018<br>  License: `other`
  <div><img height='300' alt='Face Landmarks Detection image 1' src='https://camo.githubusercontent.com/e00a575cd16831a1b76c6a329ea1d353bf00ae4e/687474703a2f2f6936332e74696e797069632e636f6d2f6a31306b37622e676966'> 
</div>
  </details>

- iOS 10 Day by Day: Code examples for the new functions in iOS 10  
  <details><summary><code>swift</code> 🔥🔥🔥</summary>

  https://github.com/ShinobiControls/iOS10-day-by-day<br>  Added September  2, 2016<br>  License: `other`
  <div><img height='300' alt='iOS 10 Day by Day image 1' src='https://www.shinobicontrols.com/wp-content/uploads/2016/07/App_Demo.gif'> 
</div>
  </details>

- iOS 11 by Examples: New iOS 11 APIs  
  <details><summary><code>swift</code> <code>coreml</code> <code>vision</code> <code>arkit</code> <code>drag-and-drop</code> <code>core-nfc</code> <code>mapkit</code> <code>identity-lookup</code> <code>devicecheck</code> <code>spritekit</code> 🔥🔥🔥🔥🔥</summary>

  https://github.com/artemnovichkov/iOS-11-by-Examples<br>  Added September  7, 2017<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='iOS 11 by Examples image 1' src='https://github.com/artemnovichkov/iOS-11-by-Examples/blob/master/resources/vision-landmarks-example.jpeg'> 
</div>
  </details>

- iOS 8 Sampler: Code examples for the new functions in iOS 8  
  <details><summary><code>objc</code> 🔥🔥🔥🔥🔥</summary>

  https://github.com/shu223/iOS8-Sampler<br>  Added April 30, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='iOS 8 Sampler image 1' src='http://f.cl.ly/items/2m0W310X0f0J2Z0b0o2r/top.jpg'> 
</div>
  </details>

- iOS 9 Sampler: Code examples for the new functions in iOS 9  
  <details><summary><code>swift</code> 🔥🔥🔥🔥🔥</summary>

  https://github.com/shu223/iOS-9-Sampler<br>  Added September 19, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='iOS 9 Sampler image 1' src='https://raw.githubusercontent.com/shu223/iOS-9-Sampler/master/ResourcesForREADME/map.gif'> 
</div>
  </details>

- iOSDesignPatternSamples: Github user search demo app which made by many variety of design patterns.  
  <details><summary><code>swift</code> <code>mvc</code> <code>mvp</code> <code>mvvm</code> <code>flux</code> <code>design-patterns</code> 🔥🔥</summary>

  https://github.com/marty-suzuki/iOSDesignPatternSamples<br>  Added January  5, 2018<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='iOSDesignPatternSamples image 1' src='https://github.com/marty-suzuki/iOSDesignPatternSamples/blob/master/Images/app.gif?raw=true'> <img height='300' alt='iOSDesignPatternSamples image 2' src='https://github.com/marty-suzuki/iOSDesignPatternSamples/blob/master/Images/diff.png?raw=true'> 
</div>
  </details>

- Knock: Use Accelerometer & background mode to create a feature of knocking your phone  
  <details><summary><code>objc</code> </summary>

  https://github.com/MatheusCavalca/Knock<br>  Added March 20, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Knock image 1' src='https://i.imgur.com/PfuYfjU.png'> 
</div>
  </details>

- Layer-Parse  
  <details><summary><code>swift</code> <code>parse</code> <code>atlas</code> 🔥</summary>

  https://github.com/kwkhaw/Layer-Parse-iOS-Swift-Example<br>  Added January 25, 2016<br>  License: [`apache-2.0`](http://choosealicense.com/licenses/apache-2.0/)
  <div><img height='300' alt='Layer-Parse image 1' src='https://raw.githubusercontent.com/kwkhaw/Layer-Parse-iOS-Swift-Example/master/Assets/Atlas-Layer-Parse-github.png'> 
</div>
  </details>

- LayerPlayer: Explore the capabilities of Apple's Core Animation API [` App Store`](https://itunes.apple.com/app/layer-player/id949768742)  
  <details><summary><code>swift</code> 🔥🔥🔥</summary>

  https://github.com/scotteg/LayerPlayer<br>  Added March 23, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='LayerPlayer image 1' src='http://a2.mzstatic.com/us/r30/Purple6/v4/07/32/b6/0732b62f-2f8d-6f35-0126-40c32cb5d86f/screen696x696.jpeg'> <img height='300' alt='LayerPlayer image 2' src='http://a5.mzstatic.com/us/r30/Purple69/v4/bf/ca/f9/bfcaf936-e812-ca87-9e46-374c9e6a32f0/screen696x696.jpeg'> <img height='300' alt='LayerPlayer image 3' src='http://a3.mzstatic.com/us/r30/Purple6/v4/a9/aa/5b/a9aa5bc4-0587-c433-055c-2b98786185a5/screen696x696.jpeg'> <img height='300' alt='LayerPlayer image 4' src='http://a1.mzstatic.com/us/r30/Purple22/v4/f7/aa/7d/f7aa7d2b-8ad1-9d85-8592-c82c51309655/screen696x696.jpeg'> <img height='300' alt='LayerPlayer image 5' src='http://a3.mzstatic.com/us/r30/Purple69/v4/6e/c1/a5/6ec1a500-8d0b-ea2e-ee71-9647ba736685/screen696x696.jpeg'> 
</div>
  </details>

- OpenShop.io: Ecommerce shopping app [` App Store`](https://itunes.apple.com/app/id1088689646)  
  <details><summary><code>objc</code> 🔥🔥</summary>

  https://github.com/openshopio/openshop.io-ios<br>  Added April 22, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='OpenShop.io image 1' src='http://a2.mzstatic.com/us/r30/Purple49/v4/f1/5e/74/f15e74dd-2999-3c26-5399-746cda25c1df/screen696x696.jpeg'> <img height='300' alt='OpenShop.io image 2' src='http://a3.mzstatic.com/us/r30/Purple49/v4/fd/f3/e7/fdf3e7e2-fb8f-4583-d6c2-74acd5c0bf1a/screen696x696.jpeg'> <img height='300' alt='OpenShop.io image 3' src='http://a3.mzstatic.com/us/r30/Purple49/v4/40/fd/44/40fd44f8-68c0-9e0f-948a-f17e3f06840a/screen696x696.jpeg'> <img height='300' alt='OpenShop.io image 4' src='http://a4.mzstatic.com/us/r30/Purple49/v4/e5/19/74/e51974db-b60c-a715-c77b-8c9efa677821/screen696x696.jpeg'> <img height='300' alt='OpenShop.io image 5' src='http://a2.mzstatic.com/us/r30/Purple49/v4/b7/6f/95/b76f95d1-5c40-b766-d399-d02d9963a56b/screen696x696.jpeg'> 
</div>
  </details>

- Polls: App for Polls API by Apiary  
  <details><summary><code>swift</code> </summary>

  https://github.com/apiaryio/polls-app<br>  Added June 17, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Polls image 1' src='https://github.com/apiaryio/polls-app/raw/master/Screenshot.png'> 
</div>
  </details>

- Protocol-Oriented MVVM Examples  
  <details><summary><code>swift</code> <code>mvvm</code> </summary>

  https://github.com/vanyaland/MVVM-Example<br>  Added September  8, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Protocol-Oriented MVVM Examples image 1' src='https://github.com/vanyaland/MVVM-Example/blob/master/resources/images/mvvm-generic-apps-list.png'> <img height='300' alt='Protocol-Oriented MVVM Examples image 2' src='https://github.com/vanyaland/MVVM-Example/blob/master/resources/images/mvvm-generic-detail.png'> <img height='300' alt='Protocol-Oriented MVVM Examples image 3' src='https://github.com/vanyaland/MVVM-Example/blob/master/resources/images/mvvm-example-minion.png'> 
</div>
  </details>

- RKGist: GitHub Gists  
  <details><summary><code>restkit</code> </summary>

  https://github.com/RestKit/RKGist<br>  Added April  9, 2015<br>  License: [`apache-2.0`](http://choosealicense.com/licenses/apache-2.0/)
  <div><img height='300' alt='RKGist image 1' src='https://i.imgur.com/3yKeZP7.png'> <img height='300' alt='RKGist image 2' src='https://i.imgur.com/cPwvXZa.png'> 
</div>
  </details>

- SafariAutoLoginTest: Demo of how to auto-login users using Safari cookies  
  <details><summary><code>swift</code> <code>ios9</code> 🔥🔥</summary>

  https://github.com/mackuba/SafariAutoLoginTest<br>  https://vimeo.com/136968596<br>  Added April 22, 2016<br>  License: `other`
  <div><img height='300' alt='SafariAutoLoginTest image 1' src='https://i.imgur.com/vaGCfA0.png'> 
</div>
  </details>

- Siesta GitHub Browser: Browse & star GitHub repositories  
  <details><summary><code>swift</code> <code>rest</code> 🔥🔥🔥</summary>

  https://github.com/bustoutsolutions/siesta/tree/master/Examples/GithubBrowser<br>  Added July 26, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Siesta GitHub Browser image 1' src='https://i.imgur.com/OBGvFKw.png'> <img height='300' alt='Siesta GitHub Browser image 2' src='https://i.imgur.com/50eCbeX.png'> 
</div>
  </details>

- StateRestorationDemo: State preservation & restoration APIs  
  <details><summary><code>swift</code> </summary>

  https://github.com/shagedorn/StateRestorationDemo<br>  Added January 25, 2016<br>  License: [`bsd-3-clause`](http://choosealicense.com/licenses/bsd-3-clause/)
  <div><img height='300' alt='StateRestorationDemo image 1' src='https://raw.githubusercontent.com/shagedorn/StateRestorationDemo/master/Presentation/app_screenshot.png'> 
</div>
  </details>

- Swift-Demos: Mirror of Apple example code  
  <details><summary><code>swift</code> 🇨🇳 🔥🔥🔥🔥🔥</summary>

  https://github.com/Lax/iOS-Swift-Demos<br>  Added April 22, 2016<br>  License: `other`
  </details>


## Scan 
 
[back to top](#readme) 
 
- QR Blank: No ads simple QR code URL scanner [` App Store`](https://itunes.apple.com/app/id1137064763)  
  <details><summary><code>swift</code> </summary>

  https://github.com/kahopoon/QR-Blank<br>  Added August 10, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='QR Blank image 1' src='https://raw.githubusercontent.com/kahopoon/QR-Blank/master/readme-images/intro.gif'> <img height='300' alt='QR Blank image 2' src='https://github.com/kahopoon/QR-Blank/raw/master/readme-images/screenA.jpeg'> <img height='300' alt='QR Blank image 3' src='https://github.com/kahopoon/QR-Blank/raw/master/readme-images/screenB.jpeg'> 
</div>
  </details>

- ZBar Barcode Reader: A comprehensive barcode reader  
  <details><summary><code>objc</code> </summary>

  https://sourceforge.net/projects/zbar/<br>  http://zbar.sourceforge.net/<br>  Added June  1, 2016<br>  License: [`lgpl-2.1`](http://choosealicense.com/licenses/lgpl-2.1/)
  <div>
</div>
  </details>


## Security 
 
[back to top](#readme) 
 
- Easy Diceware: Passphrase generator  
  <details><summary><code>swift</code> </summary>

  https://github.com/cfdrake/easy-diceware<br>  Added June  1, 2017<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Easy Diceware image 1' src='https://raw.githubusercontent.com/cfdrake/easy-diceware/master/.github/screenshot.png'> 
</div>
  </details>

- iCepa: System-wide VPN based Tor client  
  <details><summary><code>swift</code> <code>tor</code> 🔥🔥</summary>

  https://github.com/iCepa/iCepa<br>  Added September  7, 2016<br>  License: `other`
  </details>

- keyacid: Secure and easy crypto for everyone  
  <details><summary><code>swift</code> <code>carthage</code> <code>libsodium</code> </summary>

  https://github.com/keyacid/keyacid-iOS<br>  Added August  3, 2017<br>  License: [`bsd-3-clause`](http://choosealicense.com/licenses/bsd-3-clause/)
  <div><img height='300' alt='keyacid image 1' src='http://a1.mzstatic.com/us/r30/Purple117/v4/49/ba/f3/49baf3cf-a821-ec84-21f4-ac7f466c72b4/screen696x696.jpeg'> <img height='300' alt='keyacid image 2' src='http://a5.mzstatic.com/us/r30/Purple117/v4/36/fe/e2/36fee29b-22fc-d047-396a-3d2b043e9d53/screen696x696.jpeg'> 
</div>
  </details>

- Keybase [` App Store`](https://itunes.apple.com/app/keybase-crypto-for-everyone/id1044461770)  
  <details><summary><code>react native</code> 🔥🔥🔥🔥🔥</summary>

  https://github.com/keybase/client<br>  Added February  9, 2017<br>  License: [`bsd-3-clause`](http://choosealicense.com/licenses/bsd-3-clause/)
  </details>

- Krypton: Generate & store an SSH key on your phone [` App Store`](https://itunes.apple.com/app/krypton-by-krypt-co/id1161494806)  
  <details><summary><code>swift</code> 🔥</summary>

  https://github.com/kryptco/krypton-ios<br>  Added May  2, 2017<br>  License: `other`
  <div><img height='300' alt='Krypton image 1' src='http://a2.mzstatic.com/us/r30/Purple122/v4/a1/44/1f/a1441fb4-a4de-c877-fe07-335c75724c03/screen696x696.jpeg'> 
</div>
  </details>

- Onions: Cloud encrypted notes  
  <details><summary><code>objc</code> </summary>

  https://github.com/onionsapp/Onions-iOS<br>  Added January 27, 2015<br>  License: `other`
  <div><img height='300' alt='Onions image 1' src='http://a2.mzstatic.com/us/r30/Purple/v4/d0/08/29/d00829d7-e34f-69e7-d21b-bfd3f48ae8fc/screen696x696.jpeg'> <img height='300' alt='Onions image 2' src='http://a3.mzstatic.com/us/r30/Purple4/v4/9d/18/f7/9d18f743-51ef-adfa-5720-ce52057f2232/screen696x696.jpeg'> <img height='300' alt='Onions image 3' src='http://a2.mzstatic.com/us/r30/Purple2/v4/85/63/c3/8563c3ce-2e2a-0a6f-472d-68b60a274841/screen696x696.jpeg'> <img height='300' alt='Onions image 4' src='http://a4.mzstatic.com/us/r30/Purple/v4/e2/43/a1/e243a12f-6391-f347-c684-22e5236f0d79/screen696x696.jpeg'> 
</div>
  </details>

- Pass: Client for the Pass command line app https://www.passwordstore.org/  
  <details><summary><code>swift</code> <code>carthage</code> <code>keychainaccess</code> <code>onetimepassword</code> 🔥🔥</summary>

  https://github.com/mssun/passforios<br>  Added May 30, 2017<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Pass image 1' src='https://github.com/mssun/passforios/raw/master/screenshot/preview.gif'> 
</div>
  </details>

- Prey: Track lost or stolen devices & perform actions remotely [` App Store`](https://itunes.apple.com/app/id456755037)  
  <details><summary><code>objc</code> 🔥🔥</summary>

  https://github.com/prey/prey-ios-client<br>  https://preyproject.com/<br>  Added June  1, 2016<br>  License: [`gpl-3.0`](http://choosealicense.com/licenses/gpl-3.0/)
  <div><img height='300' alt='Prey image 1' src='http://a3.mzstatic.com/us/r30/Purple62/v4/43/f7/91/43f791d0-319a-2e3f-449a-2471e240b068/screen696x696.jpeg'> <img height='300' alt='Prey image 2' src='http://a5.mzstatic.com/us/r30/Purple62/v4/c3/f9/ba/c3f9ba54-b8df-10bc-e2e0-ea6b1a736d91/screen696x696.jpeg'> <img height='300' alt='Prey image 3' src='http://a2.mzstatic.com/us/r30/Purple62/v4/e3/96/3e/e3963e31-b683-16c2-cc94-4768fe16020a/screen696x696.jpeg'> <img height='300' alt='Prey image 4' src='http://a4.mzstatic.com/us/r30/Purple71/v4/d6/af/c3/d6afc340-1972-af85-053b-8e52ed5a4588/screen696x696.jpeg'> <img height='300' alt='Prey image 5' src='http://a1.mzstatic.com/us/r30/Purple62/v4/f3/50/71/f35071d7-9fa9-1bf9-fa91-2641458bcd1e/screen696x696.jpeg'> 
</div>
  </details>

- Prey: Track lost or stolen devices & perform actions remotely  
  <details><summary><code>swift</code> </summary>

  https://github.com/prey/prey-swift-client<br>  https://preyproject.com/<br>  Added June  1, 2016<br>  License: [`gpl-3.0`](http://choosealicense.com/licenses/gpl-3.0/)
  <div><img height='300' alt='Prey image 1' src='https://preyproject.com/img/home/report-simple-2.png'> 
</div>
  </details>

- Tutanota: End-to-end encrypted email [` App Store`](https://itunes.apple.com/app/id922429609)  
  <details><summary><code>javascript</code> <code>cordova</code> <code>iphone</code> <code>ipad</code> 🔥🔥🔥🔥</summary>

  https://github.com/tutao/tutanota<br>  https://tutanota.com/<br>  Added June  1, 2016<br>  License: [`gpl-3.0`](http://choosealicense.com/licenses/gpl-3.0/)
  <div><img height='300' alt='Tutanota image 1' src='http://a2.mzstatic.com/us/r30/Purple71/v4/7e/80/e2/7e80e291-ee1e-ffb4-9449-c0431136832c/screen696x696.jpeg'> <img height='300' alt='Tutanota image 2' src='http://a1.mzstatic.com/us/r30/Purple62/v4/d3/37/fd/d337fd23-a7e0-a903-3249-6b793974df2d/screen696x696.jpeg'> <img height='300' alt='Tutanota image 3' src='http://a2.mzstatic.com/us/r30/Purple71/v4/7b/09/a2/7b09a205-22f4-addf-6641-c1462c1d0c98/screen696x696.jpeg'> <img height='300' alt='Tutanota image 4' src='http://a5.mzstatic.com/us/r30/Purple22/v4/9e/c9/8f/9ec98f0b-b5a8-1aa4-98ba-b3c748ed8e18/screen696x696.jpeg'> 
</div>
  </details>

- VPN On: Extension to turn on VPN [` App Store`](https://itunes.apple.com/app/vpn-on/id951344279)  
  <details><summary><code>swift</code> 🔥🔥🔥🔥🔥</summary>

  https://github.com/lexrus/VPNOn<br>  Added March 16, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='VPN On image 1' src='https://cdn-images-1.medium.com/max/800/1*9qSbd77zijp5UPODaWM9CQ.png'> 
</div>
  </details>


### Password 
 
[back to top](#readme) 
 
- Authenticator: A simple two-factor authentication app with a clean UI [` App Store`](https://itunes.apple.com/app/id766157276)  
  <details><summary><code>objc</code> 🔥🔥</summary>

  https://github.com/mattrubin/authenticator<br>  https://mattrubin.me/authenticator/<br>  Added March 11, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Authenticator image 1' src='http://a3.mzstatic.com/us/r30/Purple4/v4/d0/6f/3d/d06f3d75-b4f9-d2c0-1f24-01ec8f84d3d2/screen696x696.jpeg'> <img height='300' alt='Authenticator image 2' src='http://a4.mzstatic.com/us/r30/Purple3/v4/ba/b8/ee/bab8eeb5-de24-7319-9401-c90cf2e95212/screen696x696.jpeg'> <img height='300' alt='Authenticator image 3' src='http://a3.mzstatic.com/us/r30/Purple5/v4/aa/8f/5e/aa8f5eff-74da-db7c-a647-cfb18a54cfaf/screen696x696.jpeg'> 
</div>
  </details>

- Encryptr: A zero-knowledge, cloud-based e-wallet & password manager [` App Store`](https://itunes.apple.com/app/id1066041348)  
  <details><summary><code>cordova</code> <code>grunt</code> <code>node</code> 🔥🔥🔥🔥</summary>

  https://github.com/SpiderOak/Encryptr<br>  https://spideroak.com/encryptr/<br>  Added June  2, 2016<br>  License: [`gpl-3.0`](http://choosealicense.com/licenses/gpl-3.0/)
  <div><img height='300' alt='Encryptr image 1' src='http://a1.mzstatic.com/us/r30/Purple49/v4/cc/ab/0f/ccab0fca-197f-56c0-c265-4b73c99e4ef8/screen696x696.jpeg'> 
</div>
  </details>

- FreeOTP Authenticator: Two-Factor Authentication [` App Store`](https://itunes.apple.com/app/freeotp/id872559395)  
  <details><summary><code>swift</code> <code>moa</code> </summary>

  https://github.com/freeotp/freeotp-ios<br>  Added March 11, 2016<br>  License: [`apache-2.0`](http://choosealicense.com/licenses/apache-2.0/)
  <div><img height='300' alt='FreeOTP Authenticator image 1' src='http://a4.mzstatic.com/us/r30/Purple5/v4/66/8b/9c/668b9cf1-3502-3683-7787-ef450ef90019/screen696x696.jpeg'> 
</div>
  </details>

- MasterPassword: Stateless password management solution [` App Store`](https://itunes.apple.com/app/id510296984)  
  <details><summary><code>objc</code> 🔥🔥🔥🔥</summary>

  https://github.com/Lyndir/MasterPassword<br>  Added May 15, 2015<br>  License: [`gpl-3.0`](http://choosealicense.com/licenses/gpl-3.0/)
  <div><img height='300' alt='MasterPassword image 1' src='http://a3.mzstatic.com/us/r30/Purple1/v4/2d/a3/e2/2da3e280-a7b2-2919-0a62-b4d9063102bd/screen696x696.jpeg'> <img height='300' alt='MasterPassword image 2' src='http://a4.mzstatic.com/us/r30/Purple5/v4/54/31/3c/54313ca9-4faa-3a44-703b-42deadbdb3d5/screen696x696.jpeg'> <img height='300' alt='MasterPassword image 3' src='http://a1.mzstatic.com/us/r30/Purple5/v4/9c/8d/8b/9c8d8bee-69ee-7c98-9415-e7237b4e5b17/screen696x696.jpeg'> <img height='300' alt='MasterPassword image 4' src='http://a4.mzstatic.com/us/r30/Purple5/v4/f3/8f/e0/f38fe060-897e-20f9-00d5-cc99b9061673/screen696x696.jpeg'> <img height='300' alt='MasterPassword image 5' src='http://a5.mzstatic.com/us/r30/Purple3/v4/2a/7c/fd/2a7cfd81-8764-4394-6396-4bfc8b41f53c/screen696x696.jpeg'> 
</div>
  </details>

- MiniKeePass: Secure Password Manager [` App Store`](https://itunes.apple.com/app/id451661808)  
  <details><summary><code>objc</code> 🔥🔥🔥</summary>

  https://github.com/MiniKeePass/MiniKeePass<br>  Added February  7, 2016<br>  License: [`gpl-3.0`](http://choosealicense.com/licenses/gpl-3.0/)
  <div><img height='300' alt='MiniKeePass image 1' src='http://a4.mzstatic.com/us/r30/Purple7/v4/d8/41/81/d84181ef-d7fe-2283-5b54-7cfb63f8fb01/screen696x696.jpeg'> <img height='300' alt='MiniKeePass image 2' src='http://a2.mzstatic.com/us/r30/Purple5/v4/16/d4/46/16d446eb-11ab-4f22-48bc-da22b75df89a/screen696x696.jpeg'> <img height='300' alt='MiniKeePass image 3' src='http://a4.mzstatic.com/us/r30/Purple1/v4/5f/01/13/5f0113bc-577d-ebb9-cd12-58674f9ac989/screen696x696.jpeg'> <img height='300' alt='MiniKeePass image 4' src='http://a1.mzstatic.com/us/r30/Purple5/v4/38/1d/e7/381de7b6-9414-99bf-d02c-de4ffc12d21d/screen696x696.jpeg'> <img height='300' alt='MiniKeePass image 5' src='http://a3.mzstatic.com/us/r30/Purple1/v4/1f/dd/eb/1fddeb0e-e562-10f2-8a79-e7ea385117cf/screen696x696.jpeg'> 
</div>
  </details>

- pass: password-store app  
  <details><summary><code>objc++</code> <code>touchid</code> </summary>

  https://github.com/davidjb/pass-ios<br>  https://www.passwordstore.org/<br>  Added November  8, 2016<br>  License: [`apache-2.0`](http://choosealicense.com/licenses/apache-2.0/)
  <div><img height='300' alt='pass image 1' src='https://github.com/davidjb/pass-ios/raw/master/screenshots/1_main_screen.png?raw=true'> <img height='300' alt='pass image 2' src='https://github.com/davidjb/pass-ios/raw/master/screenshots/3_entry.png?raw=true'> 
</div>
  </details>

- PassDrop: Keepass password manager [` App Store`](https://itunes.apple.com/app/passdrop-2/id1206056096)  
  <details><summary><code>openssl</code> </summary>

  https://github.com/chadaustin/passdrop<br>  Added July  6, 2017<br>  License: [`gpl-3.0`](http://choosealicense.com/licenses/gpl-3.0/)
  <div><img height='300' alt='PassDrop image 1' src='http://a3.mzstatic.com/us/r30/Purple111/v4/d3/29/9c/d3299cfd-8dbc-f3b4-3031-8d7d478e744d/screen696x696.jpeg'> 
</div>
  </details>

- SkeletonKey: Password manager with Dropbox  
  <details><summary><code>iphone</code> </summary>

  https://github.com/chrishulbert/SkeletonKey<br>  Added March 31, 2016<br>  License: `other`
  <div><img height='300' alt='SkeletonKey image 1' src='http://a2.mzstatic.com/us/r30/Purple1/v4/83/3d/68/833d684f-39f7-f310-1b18-e9a6d0f7353f/screen696x696.jpeg'> <img height='300' alt='SkeletonKey image 2' src='http://a2.mzstatic.com/us/r30/Purple3/v4/c0/cc/aa/c0ccaaee-4ae8-2d84-974a-d4a3b887fa5a/screen696x696.jpeg'> <img height='300' alt='SkeletonKey image 3' src='http://a3.mzstatic.com/us/r30/Purple1/v4/a3/17/ff/a317ff61-9846-47ba-0633-b3bc203326c0/screen696x696.jpeg'> <img height='300' alt='SkeletonKey image 4' src='http://a5.mzstatic.com/us/r30/Purple4/v4/09/94/7f/09947fc6-28e0-0182-74d3-08f5c97c7451/screen696x696.jpeg'> <img height='300' alt='SkeletonKey image 5' src='http://a4.mzstatic.com/us/r30/Purple5/v4/13/10/89/13108957-9826-ccd6-40d0-0a65f08299d4/screen696x696.jpeg'> 
</div>
  </details>

- ZeroStore: password storage without the storage [` App Store`](https://itunes.apple.com/app/zerostore-password-storage/id1037141587)  
  <details><summary><code>objc</code> </summary>

  https://github.com/kylebshr/zerostore-ios<br>  Added September  8, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='ZeroStore image 1' src='http://a4.mzstatic.com/us/r30/Purple69/v4/96/fb/0a/96fb0a2f-de8c-41a1-07e3-5be00ba1f2f8/screen696x696.jpeg'> <img height='300' alt='ZeroStore image 2' src='http://a2.mzstatic.com/us/r30/Purple3/v4/17/dc/16/17dc1676-f485-4fe9-e38a-7a095916393c/screen696x696.jpeg'> <img height='300' alt='ZeroStore image 3' src='http://a4.mzstatic.com/us/r30/Purple3/v4/21/8e/8c/218e8cb3-5fe4-f909-9761-ab2f1367b0a8/screen696x696.jpeg'> <img height='300' alt='ZeroStore image 4' src='http://a1.mzstatic.com/us/r30/Purple3/v4/0f/1d/02/0f1d0261-6f35-5e34-45e7-7603a7f2d098/screen696x696.jpeg'> <img height='300' alt='ZeroStore image 5' src='http://a5.mzstatic.com/us/r30/Purple6/v4/fd/8c/47/fd8c47fa-13ec-1cdb-65f5-8c936dfa7a12/screen696x696.jpeg'> 
</div>
  </details>


## Social 
 
[back to top](#readme) 
 
- Aozora: Discover & track anime  
  <details><summary><code>swift</code> </summary>

  https://github.com/opensourceios/Aozora<br>  Added February  8, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div>
</div>
  </details>

- Ello: Ello is the Creators Network [` App Store`](https://itunes.apple.com/app/ello/id953614327)  
  <details><summary><code>swift</code> 🔥🔥🔥</summary>

  https://github.com/ello/ello-ios<br>  Added June  2, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Ello image 1' src='http://a5.mzstatic.com/us/r30/Purple62/v4/d3/f7/04/d3f7045e-84bc-b237-09f0-6f28c1c6774a/screen696x696.jpeg'> <img height='300' alt='Ello image 2' src='http://a2.mzstatic.com/us/r30/Purple71/v4/c7/3e/c9/c73ec9fb-0284-2bd7-15dd-7378555af681/screen696x696.jpeg'> <img height='300' alt='Ello image 3' src='http://a3.mzstatic.com/us/r30/Purple71/v4/a8/8d/fb/a88dfbcb-6b8e-bb3d-5e0d-f581b686c708/screen696x696.jpeg'> <img height='300' alt='Ello image 4' src='http://a4.mzstatic.com/us/r30/Purple71/v4/78/33/45/783345e2-4cfd-b57a-00fc-55b87d91eb51/screen696x696.jpeg'> <img height='300' alt='Ello image 5' src='http://a1.mzstatic.com/us/r30/Purple62/v4/83/95/e3/8395e3e4-23f9-b0cd-0ef7-8734f58506ba/screen696x696.jpeg'> 
</div>
  </details>

- Minds: An encrypted social network [` App Store`](https://itunes.apple.com/app/id961771928)  
  <details><summary><code>angular</code> <code>cordova</code> 🔥</summary>

  https://github.com/Minds/mobile<br>  https://www.minds.com/<br>  Added June  2, 2016<br>  License: [`agpl-3.0`](http://choosealicense.com/licenses/agpl-3.0/)
  <div><img height='300' alt='Minds image 1' src='http://a2.mzstatic.com/us/r30/Purple69/v4/88/d6/7e/88d67efd-b235-e4ac-fe33-0f9c6a48717d/screen696x696.jpeg'> <img height='300' alt='Minds image 2' src='http://a4.mzstatic.com/us/r30/Purple7/v4/cd/91/fb/cd91fbc1-927a-68dc-0d06-6abd52627ff0/screen696x696.jpeg'> <img height='300' alt='Minds image 3' src='http://a3.mzstatic.com/us/r30/Purple2/v4/55/27/2c/55272c66-e389-5b0c-ceab-9165d3b4a9ec/screen696x696.jpeg'> <img height='300' alt='Minds image 4' src='http://a1.mzstatic.com/us/r30/Purple49/v4/ce/78/dc/ce78dc5a-2c47-0c12-309c-a821bbb8e4f3/screen696x696.jpeg'> 
</div>
  </details>

- Peggsite: App for sharing a social board  
  <details><summary><code>objc</code> </summary>

  https://github.com/jenduf/GenericSocialApp<br>  Added March 17, 2015<br>  License: `other`
  <div>
</div>
  </details>

- Post Manager: Post/schedule Twitter posts like Buffer, includes a Share Extension  
  <details><summary><code>swift</code> <code>node</code> </summary>

  https://github.com/TomekB/PostManager<br>  Added July 15, 2016<br>  License: `other`
  <div><img height='300' alt='Post Manager image 1' src='https://github.com/TomekB/PostManager/raw/master/IMG/Simulator%20Screen%20Shot%2015%20Jul%202016%2007.52.18.png?raw=true'> <img height='300' alt='Post Manager image 2' src='https://github.com/TomekB/PostManager/raw/master/IMG/Simulator%20Screen%20Shot%2015%20Jul%202016%2007.52.54.png?raw=true'> <img height='300' alt='Post Manager image 3' src='https://github.com/TomekB/PostManager/raw/master/IMG/Simulator%20Screen%20Shot%2015%20Jul%202016%2007.54.47.png?raw=true'> 
</div>
  </details>

- Potter Pics: Harry Potter themed social network similar to Instagram.  
  <details><summary><code>swift</code> <code>swift3</code> <code>firebase</code> 🔥</summary>

  https://github.com/surayashivji/PotterPics<br>  Added January 15, 2017
  <div><img height='300' alt='Potter Pics image 1' src='https://github.com/surayashivji/PotterPics/blob/master/Overview.gif'> 
</div>
  </details>

- StreetMusicMap: Is a collaborative global community that connects street musicians, fans & videomakers  
  <details><summary><code>objc</code> </summary>

  https://github.com/henriquevelloso/StreetMusicMap<br>  Added April 20, 2016<br>  License: `other`
  <div><img height='300' alt='StreetMusicMap image 1' src='http://a4.mzstatic.com/us/r30/Purple5/v4/a6/87/38/a68738e5-ed64-b538-cd38-42df82d5339f/screen696x696.jpeg'> <img height='300' alt='StreetMusicMap image 2' src='http://a1.mzstatic.com/us/r30/Purple5/v4/a3/e0/05/a3e0055b-b4fc-dc75-4276-e4e0bba4ad7b/screen696x696.jpeg'> <img height='300' alt='StreetMusicMap image 3' src='http://a3.mzstatic.com/us/r30/Purple7/v4/81/7d/f4/817df403-8bb2-1d31-8046-b3e6f0509e12/screen696x696.jpeg'> <img height='300' alt='StreetMusicMap image 4' src='http://a3.mzstatic.com/us/r30/Purple5/v4/bd/30/db/bd30dbd9-0ef6-f21a-8822-c0dd37b6f014/screen696x696.jpeg'> 
</div>
  </details>

- Yep: Discover talent & build something together  
  <details><summary><code>swift</code> 🔥🔥🔥🔥🔥</summary>

  https://github.com/CatchChat/Yep<br>  Added February  3, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Yep image 1' src='http://a3.mzstatic.com/us/r30/Purple49/v4/7b/87/7a/7b877a50-9913-34d0-2c17-b065abeaa351/screen696x696.jpeg'> <img height='300' alt='Yep image 2' src='http://a4.mzstatic.com/us/r30/Purple69/v4/2f/ea/ae/2feaae56-46f9-16ce-1cd8-970cb5ac2d53/screen696x696.jpeg'> <img height='300' alt='Yep image 3' src='http://a1.mzstatic.com/us/r30/Purple49/v4/2b/f4/0c/2bf40cc1-0dc4-e731-86ab-544c473674ea/screen696x696.jpeg'> <img height='300' alt='Yep image 4' src='http://a3.mzstatic.com/us/r30/Purple69/v4/f7/2c/ef/f72cefc8-8dd4-3e9f-b7cc-84247cc30978/screen696x696.jpeg'> <img height='300' alt='Yep image 5' src='http://a4.mzstatic.com/us/r30/Purple49/v4/71/50/e6/7150e6ce-963d-1383-c627-1c81f2015bbc/screen696x696.jpeg'> 
</div>
  </details>


### Mastodon 
 
https://mastodon.social — [back to top](#readme) 
 
- 11t  
  <details><summary><code>fuse-tools</code> </summary>

  https://github.com/jeroensmeets/mastodon-app<br>  Added April 10, 2017<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='11t image 1' src='https://github.com/jeroensmeets/mastodon-app/blob/master/Assets/images/store/appstore/screenshot_timeline.png?raw=true'> 
</div>
  </details>

- tootbot  
  <details><summary><code>swift</code> </summary>

  https://github.com/tootbot/tootbot<br>  Added April 11, 2017<br>  License: [`agpl-3.0`](http://choosealicense.com/licenses/agpl-3.0/)
  </details>


## Tasks 
 
[back to top](#readme) 
 
- 1Trackr: Log your community service hours to the cloud  
  <details><summary><code>parse</code> </summary>

  https://github.com/JerryHDev/1Trackr<br>  Added April 11, 2016<br>  License: `other`
  <div><img height='300' alt='1Trackr image 1' src='http://a3.mzstatic.com/us/r30/Purple60/v4/2a/23/28/2a2328e4-4006-604e-1751-d38e2b287d80/screen696x696.jpeg'> <img height='300' alt='1Trackr image 2' src='http://a2.mzstatic.com/us/r30/Purple18/v4/f1/b8/b0/f1b8b077-1977-15fa-7731-0672303a94e2/screen696x696.jpeg'> <img height='300' alt='1Trackr image 3' src='http://a4.mzstatic.com/us/r30/Purple30/v4/0d/b0/57/0db05780-fb74-f2b6-3329-505cd8a529f0/screen696x696.jpeg'> <img height='300' alt='1Trackr image 4' src='http://a5.mzstatic.com/us/r30/Purple30/v4/03/b4/4f/03b44f66-7cfe-7314-5ee0-0acd900d6c92/screen696x696.jpeg'> <img height='300' alt='1Trackr image 5' src='http://a1.mzstatic.com/us/r30/Purple20/v4/97/05/12/97051277-bc7b-5afc-d73b-6d5df2e7fc8a/screen696x696.jpeg'> 
</div>
  </details>

- eCortex: Manage / organize thoughts & ideas into custom categories [` App Store`](https://itunes.apple.com/app/ecortex/id1105026832)  
  <details><summary><code>swift</code> </summary>

  https://github.com/atmaniwhy/cortex<br>  Added January 25, 2017
  <div><img height='300' alt='eCortex image 1' src='http://a5.mzstatic.com/us/r30/Purple60/v4/03/9e/a9/039ea9b6-6427-ac1b-9bf9-773c91e5b8c9/screen696x696.jpeg'> 
</div>
  </details>

- Habitica: Habit building & productivity [` App Store`](https://itunes.apple.com/app/id994882113)  
  <details><summary><code>objc</code> 🔥</summary>

  https://github.com/HabitRPG/habitica-ios<br>  https://habitica.com/static/front<br>  Added June  1, 2016<br>  License: [`gpl-3.0`](http://choosealicense.com/licenses/gpl-3.0/)
  <div><img height='300' alt='Habitica image 1' src='http://a5.mzstatic.com/us/r30/Purple6/v4/a2/af/06/a2af06ac-0644-00b5-85f1-ae13e3ebf1cd/screen696x696.jpeg'> 
</div>
  </details>

- Planc: Minimalistic to-do list  
  <details><summary><code>swift</code> </summary>

  https://github.com/aerlinn13/planc<br>  Added August 20, 2017<br>  License: `other`
  <div><img height='300' alt='Planc image 1' src='https://github.com/aerlinn13/Planc/blob/master/screenshots/1.png?raw=true'> 
</div>
  </details>

- RealmTasks: To Do app built with Realm, inspired by Clear for iOS  
  <details><summary><code>swift</code> <code>realm</code> <code>react native</code> <code>cartography</code> <code>swiftlint</code> 🔥🔥</summary>

  https://github.com/realm/realm-tasks<br>  Added February  2, 2017<br>  License: [`apache-2.0`](http://choosealicense.com/licenses/apache-2.0/)
  <div><img height='300' alt='RealmTasks image 1' src='https://cloud.githubusercontent.com/assets/429119/18797910/b01b7fd4-8202-11e6-8b70-afe224f3b9e0.png'> <img height='300' alt='RealmTasks image 2' src='https://i.imgur.com/Y9ZG7Of.png'> 
</div>
  </details>

- RealmToDo: A small to-do list with Realm integration  
  <details><summary><code>swift</code> </summary>

  https://github.com/pietbrauer/RealmToDo<br>  Added July 31, 2015<br>  License: `other`
  </details>

- Task Coach: A simple to-do manager designed for composite tasks [` App Store`](https://itunes.apple.com/app/task-coach/id311403563)  
  <details><summary><code>objc</code> </summary>

  https://sourceforge.net/projects/taskcoach/<br>  http://taskcoach.org/<br>  Added May 31, 2016<br>  License: [`gpl-3.0`](http://choosealicense.com/licenses/gpl-3.0/)
  <div><img height='300' alt='Task Coach image 1' src='http://a4.mzstatic.com/us/r30/Purple6/v4/91/19/de/9119debe-4936-ac90-6fa0-6cd9bd92fd1e/screen696x696.jpeg'> <img height='300' alt='Task Coach image 2' src='http://a4.mzstatic.com/us/r30/Purple4/v4/52/9b/45/529b453d-1cae-0720-1d9e-ef336c760f4f/screen696x696.jpeg'> <img height='300' alt='Task Coach image 3' src='http://a4.mzstatic.com/us/r30/Purple6/v4/d5/f0/a8/d5f0a87a-3772-0e79-2709-6d5ecdf6d5d2/screen696x696.jpeg'> <img height='300' alt='Task Coach image 4' src='http://a3.mzstatic.com/us/r30/Purple/v4/8c/8d/7b/8c8d7b2c-5739-cf8f-a3ab-d7b2c5a492b1/screen696x696.jpeg'> <img height='300' alt='Task Coach image 5' src='http://a2.mzstatic.com/us/r30/Purple6/v4/fe/9b/1e/fe9b1e76-6717-7223-6944-c5587c834b18/screen696x696.jpeg'> 
</div>
  </details>

- Tinylog: Minimal to-do app  
  <details><summary><code>swift</code> <code>iphone</code> <code>ipad</code> </summary>

  https://github.com/binarylevel/Tinylog-iOS<br>  Added January 26, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div>
</div>
  </details>

- Todo  
  <details><summary><code>swift</code> 🔥🔥</summary>

  https://github.com/JakeLin/Todo<br>  Added November 30, 2015<br>  License: `other`
  <div><img height='300' alt='Todo image 1' src='https://github.com/JakeLin/Todo/raw/master/Screenshots/1.png'> <img height='300' alt='Todo image 2' src='https://github.com/JakeLin/Todo/raw/master/Screenshots/2.png'> 
</div>
  </details>

- Todo.txt: If you have a file called todo.txt on your computer right now, you're in the right place  
  <details><summary><code>objc</code> 🔥🔥</summary>

  https://github.com/todotxt/todo.txt-ios<br>  Added November 30, 2015<br>  License: [`gpl-3.0`](http://choosealicense.com/licenses/gpl-3.0/)
  <div><img height='300' alt='Todo.txt image 1' src='http://a4.mzstatic.com/us/r30/Purple6/v4/41/c8/da/41c8dafa-79ab-3405-f45c-faf12256d62e/screen696x696.jpeg'> <img height='300' alt='Todo.txt image 2' src='http://a4.mzstatic.com/us/r30/Purple6/v4/0d/90/54/0d9054bf-a38b-9c6d-44a9-8dccf72a7917/screen696x696.jpeg'> <img height='300' alt='Todo.txt image 3' src='http://a2.mzstatic.com/us/r30/Purple/v4/df/95/0a/df950a0e-dd3a-786a-0ebe-8936062b03be/screen696x696.jpeg'> <img height='300' alt='Todo.txt image 4' src='http://a3.mzstatic.com/us/r30/Purple/v4/aa/4c/3a/aa4c3acf-4b93-ceae-2315-fd25837d2241/screen696x696.jpeg'> 
</div>
  </details>

- VIPER-SWIFT: Todo list  
  <details><summary><code>swift</code> 🔥🔥</summary>

  https://github.com/mutualmobile/VIPER-SWIFT<br>  Added November  2, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='VIPER-SWIFT image 1' src='https://i.imgur.com/BlZtGZR.png'> 
</div>
  </details>


## Text 
 
[back to top](#readme) 
 
- Edhita: Text editor [` App Store`](https://itunes.apple.com/app/edhita-open-source-text-editor/id398896655)  
  <details><summary><code>swift</code> 🔥🔥🔥</summary>

  https://github.com/tnantoka/edhita<br>  Added January 27, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Edhita image 1' src='http://a3.mzstatic.com/us/r30/Purple62/v4/92/84/ea/9284ea12-6151-28ba-7ca5-c7a20a485794/screen696x696.jpeg'> <img height='300' alt='Edhita image 2' src='http://a1.mzstatic.com/us/r30/Purple62/v4/4f/a3/d0/4fa3d02f-03e0-c774-3a11-e8cd2ed524e2/screen696x696.jpeg'> 
</div>
  </details>

- Sentiments: Analyzes text for positive or negative sentiment  
  <details><summary><code>swift</code> 🔥</summary>

  https://github.com/kyleweiner/Sentiments<br>  Added May 17, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Sentiments image 1' src='https://github.com/kyleweiner/Sentiments/raw/master/Assets/sentiments_example.gif'> 
</div>
  </details>


### Notes 
 
[back to top](#readme) 
 
- Loose Leaf: Take notes, import & annotate PDFs, manipulate imported photos with intuitive gestures [` App Store`](https://itunes.apple.com/app/loose-leaf/id625659452)  
  <details><summary><code>ipad</code> <code>pdf</code> <code>apple pencil</code> 🔥🔥</summary>

  https://github.com/adamwulf/loose-leaf<br>  Added January 11, 2017<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Loose Leaf image 1' src='https://github.com/adamwulf/loose-leaf/blob/master/example-gif/collapse-stack.gif?raw=true'> 
</div>
  </details>

- MajorKey: The fastest way to add a note to your email inbox  
  <details><summary><code>swift</code> </summary>

  https://github.com/KrauseFx/MajorKey<br>  Added January 28, 2018<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='MajorKey image 1' src='https://github.com/KrauseFx/MajorKey/blob/master/screenshot.png'> 
</div>
  </details>

- Onions: Cloud encrypted notes  
  <details><summary><code>objc</code> </summary>

  https://github.com/onionsapp/Onions-iOS<br>  Added January 27, 2015<br>  License: `other`
  <div><img height='300' alt='Onions image 1' src='http://a2.mzstatic.com/us/r30/Purple/v4/d0/08/29/d00829d7-e34f-69e7-d21b-bfd3f48ae8fc/screen696x696.jpeg'> <img height='300' alt='Onions image 2' src='http://a3.mzstatic.com/us/r30/Purple4/v4/9d/18/f7/9d18f743-51ef-adfa-5720-ce52057f2232/screen696x696.jpeg'> <img height='300' alt='Onions image 3' src='http://a2.mzstatic.com/us/r30/Purple2/v4/85/63/c3/8563c3ce-2e2a-0a6f-472d-68b60a274841/screen696x696.jpeg'> <img height='300' alt='Onions image 4' src='http://a4.mzstatic.com/us/r30/Purple/v4/e2/43/a1/e243a12f-6391-f347-c684-22e5236f0d79/screen696x696.jpeg'> 
</div>
  </details>

- SimpleMemo: Sync notes to EverNote  
  <details><summary><code>objc</code> 🔥🔥</summary>

  https://github.com/lijuncode/SimpleMemo<br>  Added August 27, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div>
</div>
  </details>

- Simplenote: Keep notes, lists, ideas & more (sync in the cloud) — includes sharing notes, collaboration. [` App Store`](https://itunes.apple.com/app/simplenote/id289429962)  
  <details><summary><code>1password</code> <code>fabric</code> <code>crashlytics</code> 🔥🔥🔥🔥</summary>

  https://github.com/automattic/simplenote-ios<br>  https://simplenote.com/<br>  Added August 11, 2016<br>  License: [`gpl-2.0`](http://choosealicense.com/licenses/gpl-2.0/)
  <div><img height='300' alt='Simplenote image 1' src='https://cdn.pastemagazine.com/www/articles/simplenoteapp.jpg'> 
</div>
  </details>

- Standard Notes: Notes app with focus on longevity, portability & privacy [` App Store`](https://itunes.apple.com/app/standard-notes/id1285392450)  
  <details><summary><code>react-native</code> 🔥</summary>

  https://github.com/standardnotes/mobile<br>  Added January 18, 2017<br>  License: `other`
  <div><img height='300' alt='Standard Notes image 1' src='http://is1.mzstatic.com/image/thumb/Purple118/v4/20/d6/3e/20d63e81-ad02-c057-a4d8-fa105f8fff22/source/392x696bb.jpg'> 
</div>
  </details>

- Thoughtless: Quickly jot down thoughts, supports Markdown  
  <details><summary><code>swift</code> <code>swifthexcolors</code> <code>cfalertviewcontroller</code> </summary>

  https://github.com/yoha/Thoughtless<br>  Added June 20, 2017<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Thoughtless image 1' src='http://i.imgur.com/263faeN.png'> 
</div>
  </details>

- Vesper: Note-taking app [` App Store`](https://itunes.apple.com/app/vesper/id655895325)  
  <details><summary><code>objc</code> 🔥🔥</summary>

  https://github.com/brentsimmons/Vesper<br>  Added December 21, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Vesper image 1' src='http://a4.mzstatic.com/us/r30/Purple1/v4/ff/44/1f/ff441f09-8a8f-b839-b9be-e80d614318c9/screen696x696.jpeg'> <img height='300' alt='Vesper image 2' src='http://a5.mzstatic.com/us/r30/Purple1/v4/13/fe/a1/13fea138-ceff-8ff1-a768-6840ce787ddd/screen696x696.jpeg'> <img height='300' alt='Vesper image 3' src='http://a1.mzstatic.com/us/r30/Purple5/v4/f3/b0/79/f3b07907-a0f8-21e1-cceb-b623cf786020/screen696x696.jpeg'> <img height='300' alt='Vesper image 4' src='http://a4.mzstatic.com/us/r30/Purple1/v4/4d/30/a9/4d30a9a7-b8bc-eb8b-a038-1db045a18524/screen696x696.jpeg'> <img height='300' alt='Vesper image 5' src='http://a5.mzstatic.com/us/r30/Purple3/v4/de/2b/09/de2b09a8-b6f6-9558-28bb-ce2ce90c471c/screen696x696.jpeg'> 
</div>
  </details>


## Timer 
 
[back to top](#readme) 
 
- 4Pets: Helps you take care of your pet's routines & schedules  
  <details><summary><code>swift</code> </summary>

  https://github.com/feliborgez/4pets<br>  Added May 18, 2017<br>  License: [`gpl-3.0`](http://choosealicense.com/licenses/gpl-3.0/)
  <div><img height='300' alt='4Pets image 1' src='https://raw.githubusercontent.com/feliborgez/4pets/master/img/screenshots.png'> 
</div>
  </details>

- C-41: Simple timer to make developing film easier & more reliable  
  <details><summary><code>objc</code> 🔥🔥🔥🔥</summary>

  https://github.com/ashfurrow/C-41<br>  Added January 26, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div>
</div>
  </details>

- Coffee Timer  
  <details><summary><code>swift</code> </summary>

  https://github.com/ashfurrow/yourfirstswiftapp<br>  Added April  7, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Coffee Timer image 1' src='https://i.imgur.com/p2r8TmY.png'> <img height='300' alt='Coffee Timer image 2' src='https://i.imgur.com/zEHz6j8.png'> 
</div>
  </details>

- Fojusi: Work timer with Today Extension [` App Store`](https://itunes.apple.com/app/fojusi/id923044693)  
  <details><summary><code>swift</code> 🔥🔥</summary>

  https://github.com/dasdom/Tomate<br>  Added June 21, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Fojusi image 1' src='http://a4.mzstatic.com/us/r30/Purple32/v4/cd/ac/98/cdac9892-c5e1-9389-6efe-ef31a90daaf4/screen696x696.jpeg'> <img height='300' alt='Fojusi image 2' src='http://a5.mzstatic.com/us/r30/Purple6/v4/6c/c1/1b/6cc11bb2-5f1e-693c-f05c-313034b0194a/screen696x696.jpeg'> <img height='300' alt='Fojusi image 3' src='http://a4.mzstatic.com/us/r30/Purple3/v4/05/67/17/05671722-b9e9-0698-7725-59ff117e377d/screen696x696.jpeg'> <img height='300' alt='Fojusi image 4' src='http://a4.mzstatic.com/us/r30/Purple3/v4/8c/2c/a0/8c2ca0be-628e-4daa-0911-bdf0b58318e1/screen696x696.jpeg'> 
</div>
  </details>

- Stopwatch: Best simple stopwatch app with great UI/UX for tracking time [` App Store`](https://itunes.apple.com/app/stopwatch-timer-time-logger/id1126783712)  
  <details><summary><code>swift</code> </summary>

  https://github.com/toggl/stopwatch<br>  Added April 21, 2017<br>  License: `other`
  <div><img height='300' alt='Stopwatch image 1' src='http://is2.mzstatic.com/image/thumb/Purple71/v4/b8/28/80/b82880a1-b833-6fdf-e381-996d9b5efbe9/source/392x696bb.jpg'> <img height='300' alt='Stopwatch image 2' src='http://is4.mzstatic.com/image/thumb/Purple62/v4/b1/93/93/b19393b8-4f40-da6f-5782-9dc064a00b7a/source/392x696bb.jpg'> <img height='300' alt='Stopwatch image 3' src='http://is1.mzstatic.com/image/thumb/Purple62/v4/f0/97/48/f0974881-d371-ed70-ee40-d813d5253a81/source/392x696bb.jpg'> <img height='300' alt='Stopwatch image 4' src='http://is3.mzstatic.com/image/thumb/Purple71/v4/17/6b/c3/176bc37e-da3d-7b14-3983-7fe1e255dc3d/source/392x696bb.jpg'> 
</div>
  </details>

- Superday: Superday tracks your activities automatically and helps you to find balance between life and work [` App Store`](https://itunes.apple.com/app/superday-automatic-productivity/id1169609181)  
  <details><summary><code>swift</code> </summary>

  https://github.com/toggl/superday<br>  Added October 10, 2017<br>  License: [`bsd-3-clause`](http://choosealicense.com/licenses/bsd-3-clause/)
  <div><img height='300' alt='Superday image 1' src='http://is5.mzstatic.com/image/thumb/Purple118/v4/d6/97/b8/d697b84a-e5e4-9a30-f349-64e46c960310/source/392x696bb.jpg'> <img height='300' alt='Superday image 2' src='http://is3.mzstatic.com/image/thumb/Purple128/v4/77/2c/1a/772c1ad8-a491-8688-5747-b5f8c2dfc3e9/source/392x696bb.jpg'> <img height='300' alt='Superday image 3' src='http://is2.mzstatic.com/image/thumb/Purple118/v4/ed/52/fe/ed52fead-02f5-dbea-ae3b-e1a8c902f0f0/source/392x696bb.jpg'> 
</div>
  </details>

- TrackMyTime [` App Store`](https://itunes.apple.com/app/trackmyday/id789386884)  
  <details><summary><code>objc</code> </summary>

  https://github.com/EvgenyKarkan/TrackMyTime<br>  Added May  3, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='TrackMyTime image 1' src='http://a4.mzstatic.com/us/r30/Purple6/v4/f9/75/47/f9754726-07fd-1f7b-cda9-6f7135c45695/screen696x696.jpeg'> <img height='300' alt='TrackMyTime image 2' src='http://a1.mzstatic.com/us/r30/Purple4/v4/e5/5c/48/e55c4806-441f-a36e-75d6-0537445b380d/screen696x696.jpeg'> <img height='300' alt='TrackMyTime image 3' src='http://a5.mzstatic.com/us/r30/Purple/v4/bd/b6/a9/bdb6a9f5-fb3d-2a79-7cf4-9959267684b9/screen696x696.jpeg'> <img height='300' alt='TrackMyTime image 4' src='http://a5.mzstatic.com/us/r30/Purple6/v4/6f/48/03/6f4803c4-b260-474f-38f6-5d2f9c9cf344/screen696x696.jpeg'> <img height='300' alt='TrackMyTime image 5' src='http://a2.mzstatic.com/us/r30/Purple6/v4/46/0e/fb/460efb66-a2bc-dc45-832c-1429fa12ed91/screen696x696.jpeg'> 
</div>
  </details>

- Triggy: Intervalometer for WiFi-enabled Canon DSLRs [` App Store`](https://itunes.apple.com/app/triggy/id1193570460)  
  <details><summary><code>swift</code> </summary>

  https://github.com/jnordberg/triggy<br>  Added May 18, 2017<br>  License: [`gpl-3.0`](http://choosealicense.com/licenses/gpl-3.0/)
  <div><img height='300' alt='Triggy image 1' src='https://raw.githubusercontent.com/jnordberg/triggy/master/triggy.jpg'> 
</div>
  </details>


## Travel 
 
[back to top](#readme) 
 
- Alarm: Geolocation based alarm app for travelers  
  <details><summary><code>swift</code> 🔥</summary>

  https://github.com/ChrisChares/swift-alarm<br>  Added March 27, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  </details>

- Californication: Discover only the best points of interest in the California  
  <details><summary><code>swift</code> </summary>

  https://github.com/vanyaland/Californication<br>  Added August  7, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Californication image 1' src='https://github.com/vanyaland/Californication/raw/master/screenshot.png'> 
</div>
  </details>

- MetricTime: Displays 'Metric Time' for pranking friends on trips to countries that use the metric system  
  <details><summary><code>swift</code> </summary>

  https://github.com/DeveloperACE/MetricTime<br>  Added May 13, 2016<br>  License: [`apache-2.0`](http://choosealicense.com/licenses/apache-2.0/)
  <div><img height='300' alt='MetricTime image 1' src='https://i.imgur.com/N2QeLpm.png'> <img height='300' alt='MetricTime image 2' src='https://i.imgur.com/f33KAQY.png'> <img height='300' alt='MetricTime image 3' src='https://i.imgur.com/EDZFKpP.png'> 
</div>
  </details>

- MovieDict: Offline dictionary for international movie titles [` App Store`](https://itunes.apple.com/app/movieglot-what-do-they-call-it/id710587066)  
  <details><summary><code>wikipedia</code> </summary>

  https://github.com/lurado/MovieDict<br>  https://moviedict.info<br>  Added July 26, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='MovieDict image 1' src='https://camo.githubusercontent.com/09de19622e05913567e36c75911e2dd981295036/68747470733a2f2f6d6f766965646963742e696e666f2f6970686f6e652e706e67'> 
</div>
  </details>

- prox: Decide what to do next, based on your current location  
  <details><summary><code>swift</code> <code>afnetworking</code> <code>firebase</code> </summary>

  https://github.com/mozilla-mobile/prox<br>  https://wiki.mozilla.org/New_Mobile_Experience<br>  Added February  3, 2017<br>  License: `other`
  <div><img height='300' alt='prox image 1' src='https://cdn-images-1.medium.com/max/800/1*vwHKVE8rpcMyqr5Ec7MSxQ.png'> 
</div>
  </details>

- Smart Traveller (UberGuide): Simple & comfortable way to explore a city  
  <details><summary><code>uber api</code> 🔥🔥</summary>

  https://github.com/hACKbUSTER/UberGuide-iOS<br>  Added January 22, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Smart Traveller (UberGuide) image 1' src='https://raw.githubusercontent.com/hACKbUSTER/UberGuide-iOS/master/ScreenShots/IMG_0460.PNG'> 
</div>
  </details>

- Themoji: Use Emojis to communicate while traveling  
  <details><summary><code>objc</code> </summary>

  https://github.com/themoji/ios<br>  https://themoji.me/<br>  Added July 12, 2016<br>  License: `other`
  <div><img height='300' alt='Themoji image 1' src='https://themoji.me/ThemojiIdea.jpg'> <img height='300' alt='Themoji image 2' src='http://media.148apps.com/screenshots/1086378368/us-ipad-1-themoji-express-yourself-with-emojis.jpeg'> <img height='300' alt='Themoji image 3' src='http://media.148apps.com/screenshots/1086378368/us-iphone-3-themoji-express-yourself-with-emojis.jpeg'> 
</div>
  </details>


## Weather 
 
[back to top](#readme) 
 
- Lucid Weather Clock: Precipitation clock  
  <details><summary><code>swift</code> <code>dark sky api (forecast api)</code> </summary>

  https://github.com/wrutkowski/Lucid-Weather-Clock<br>  Added January  5, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Lucid Weather Clock image 1' src='https://camo.githubusercontent.com/b961f69ba4ef05bbd2ec444277aa67f031d40d1e/687474703a2f2f692e67697068792e636f6d2f6d636d727333417277617745302e676966'> 
</div>
  </details>

- Pocket Forecast  
  <details><summary><code>swift</code> <code>typhoon</code> 🔥🔥</summary>

  https://github.com/appsquickly/Typhoon-Swift-Example<br>  Added March 24, 2015<br>  License: [`apache-2.0`](http://choosealicense.com/licenses/apache-2.0/)
  <div><img height='300' alt='Pocket Forecast image 1' src='http://typhoonframework.org/images/portfolio/PocketForecast3.gif'> 
</div>
  </details>

- RainMan  
  <details><summary><code>swift</code> <code>dark sky api (forecast api)</code> 🔥🔥🔥</summary>

  https://github.com/Aaron-A/Project-RainMan<br>  Added April 26, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='RainMan image 1' src='http://s10.postimg.org/yxy033a6h/Project_Ran_Main_Background.png'> 
</div>
  </details>

- SimpleWeather  
  <details><summary><code>swift</code> <code>iglistkit</code> <code>openweathermap</code> </summary>

  https://github.com/rnystrom/SimpleWeather<br>  Added July  7, 2017<br>  License: `other`
  <div><img height='300' alt='SimpleWeather image 1' src='https://i.imgur.com/yN9A2oJ.png'> <img height='300' alt='SimpleWeather image 2' src='https://i.imgur.com/oODNivj.png'> <img height='300' alt='SimpleWeather image 3' src='https://i.imgur.com/vjf1Bsr.png'> 
</div>
  </details>

- SmileWeather  
  <details><summary><code>wunderground api</code> <code>openweathermap api</code> 🔥🔥</summary>

  https://github.com/liu044100/SmileWeather<br>  Added August 21, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='SmileWeather image 1' src='https://github.com/liu044100/SmileWeather/raw/master/SmileWeather-Example/demo_gif/new_pro.jpg'> 
</div>
  </details>

- Sol  
  <details><summary><code>wunderground api</code> 🔥🔥🔥🔥</summary>

  https://github.com/comyar/Sol<br>  Added June 15, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Sol image 1' src='https://github.com/comyar/Sol/raw/master/Screenshots/1.png'> <img height='300' alt='Sol image 2' src='https://github.com/comyar/Sol/raw/master/Screenshots/2.png'> 
</div>
  </details>

- SwiftLanguageWeather  
  <details><summary><code>swift</code> 🔥🔥🔥🔥🔥</summary>

  https://github.com/JakeLin/SwiftLanguageWeather<br>  Added March 18, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='SwiftLanguageWeather image 1' src='https://i.imgur.com/9Ofn3QC.jpg'> 
</div>
  </details>

- Tropos Weather [` App Store`](https://itunes.apple.com/app/tropos-weather-forecasts-for/id955209376)  
  <details><summary><code>dark sky api (forecast api)</code> <code>reactivecocoa</code> 🔥🔥🔥🔥</summary>

  https://github.com/thoughtbot/Tropos<br>  Added June 22, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Tropos Weather image 1' src='http://a2.mzstatic.com/us/r30/Purple5/v4/8b/3e/bd/8b3ebd2c-9dfe-1ce5-cdf5-8c89d854e375/screen696x696.jpeg'> <img height='300' alt='Tropos Weather image 2' src='http://a3.mzstatic.com/us/r30/Purple5/v4/e6/4f/36/e64f369d-d453-f007-dd15-361d21641116/screen696x696.jpeg'> 
</div>
  </details>

- YoCelsius  
  <details><summary><code>objc</code> 🔥🔥🔥🔥🔥</summary>

  https://github.com/YouXianMing/YoCelsius<br>  Added June  3, 2015<br>  License: `other`
  <div><img height='300' alt='YoCelsius image 1' src='http://a5.mzstatic.com/us/r30/Purple5/v4/a8/a9/22/a8a92296-022f-8779-73b9-663152fcf241/screen696x696.jpeg'> <img height='300' alt='YoCelsius image 2' src='http://a2.mzstatic.com/us/r30/Purple1/v4/e3/a6/63/e3a66355-643c-354f-814b-03efc196d9cb/screen696x696.jpeg'> <img height='300' alt='YoCelsius image 3' src='http://a4.mzstatic.com/us/r30/Purple3/v4/0b/8d/7a/0b8d7ae5-ff45-9fc6-e77f-9d640a2aa5b0/screen696x696.jpeg'> <img height='300' alt='YoCelsius image 4' src='http://a4.mzstatic.com/us/r30/Purple5/v4/e6/a8/f6/e6a8f6e1-9d8c-f2bf-408d-0bf5626e333a/screen696x696.jpeg'> 
</div>
  </details>


## Misc 
 
[back to top](#readme) 
 
- 5 Calls: Spend 5 minutes, make 5 calls — Calling is the most effective way to influence your representative [` App Store`](https://itunes.apple.com/app/5-calls/id1202558609)  
  <details><summary><code>swift</code> <code>pantry</code> 🔥</summary>

  https://github.com/5calls/ios<br>  Added February 10, 2017<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='5 Calls image 1' src='http://a4.mzstatic.com/us/r30/Purple111/v4/d1/ae/b8/d1aeb811-24f2-2c1c-9a5f-1d2060157dd7/screen696x696.jpeg'> <img height='300' alt='5 Calls image 2' src='http://a1.mzstatic.com/us/r30/Purple91/v4/ef/98/fc/ef98fc2c-2d69-8c9c-12da-920c6b7c3ffc/screen696x696.jpeg'> <img height='300' alt='5 Calls image 3' src='http://a5.mzstatic.com/us/r30/Purple122/v4/e4/1a/a6/e41aa661-3a3f-eef0-4ea6-5bd5e608a53b/screen696x696.jpeg'> <img height='300' alt='5 Calls image 4' src='http://a1.mzstatic.com/us/r30/Purple111/v4/2d/d7/9e/2dd79e9f-50f4-8ba9-7c9b-c6f5e9cc5dc9/screen696x696.jpeg'> <img height='300' alt='5 Calls image 5' src='http://a1.mzstatic.com/us/r30/Purple111/v4/a1/46/fe/a146fed8-56a2-5bfc-0bf8-db3c6a4a54ac/screen696x696.jpeg'> 
</div>
  </details>

- AssociationBot: Game chatbot with word association & image recognition  
  <details><summary><code>ai</code> <code>machine-learning</code> <code>natural-language-processing</code> <code>neural-network</code> <code>word2vec</code> </summary>

  https://github.com/alexsosn/AssociationBot<br>  Added June 21, 2017<br>  License: [`apache-2.0`](http://choosealicense.com/licenses/apache-2.0/)
  <div><img height='300' alt='AssociationBot image 1' src='https://raw.githubusercontent.com/alexsosn/AssociationBot/master/Screenshots/Screen%20Shot%201.png'> <img height='300' alt='AssociationBot image 2' src='https://raw.githubusercontent.com/alexsosn/AssociationBot/master/Screenshots/Screen%20Shot%202.png'> 
</div>
  </details>

- BlogQuest: Alternative Tumblr client  
  <details><summary><code>objc</code> </summary>

  https://github.com/irace/BlogQuest<br>  Added March 10, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='BlogQuest image 1' src='https://camo.githubusercontent.com/1e2b57cde873201b31fc2d7c051a4737e4041260/68747470733a2f2f35362e6d656469612e74756d626c722e636f6d2f63656566333361666136373866623132643664323537633735633163613136362f74756d626c725f6e35646431344f697948317162316c32756f315f3534302e6a7067'> 
</div>
  </details>

- Borrowed Books: Manage ufrgs.br library books  
  <details><summary><code>swift</code> <code>alamofire</code> 🇵🇹 </summary>

  https://github.com/MatheusCavalca/RenovaLivrosUFRGS<br>  Added March 20, 2016<br>  License: `other`
  <div><img height='300' alt='Borrowed Books image 1' src='https://github.com/MatheusCavalca/RenovaLivrosUFRGS/raw/master/RenovaLivrosUFRGS/Images.xcassets/login_scren.imageset/login_scren.png'> <img height='300' alt='Borrowed Books image 2' src='https://github.com/MatheusCavalca/RenovaLivrosUFRGS/raw/master/RenovaLivrosUFRGS/Images.xcassets/book_list_screen.imageset/book_list_screen.png'> 
</div>
  </details>

- CardDecks: Configurable card decks  
  <details><summary><code>objc</code> </summary>

  https://github.com/aharren/CardDecks<br>  Added April 28, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='CardDecks image 1' src='https://i.imgur.com/h2ybAgQ.png'> 
</div>
  </details>

- DeckRocket: Remote app for Deckset presentations  
  <details><summary><code>swift</code> <code>iphone</code> 🔥🔥</summary>

  https://github.com/jpsim/DeckRocket<br>  Added March 26, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='DeckRocket image 1' src='https://github.com/jpsim/DeckRocket/raw/master/demo.gif'> 
</div>
  </details>

- FreeRDP: An implementation of the Remote Desktop Protocol (RDP) [` App Store`](https://itunes.apple.com/app/ifreerdp/id604813768)  
  <details><summary><code>objc</code> 🔥🔥🔥🔥🔥</summary>

  https://github.com/FreeRDP/FreeRDP<br>  http://www.freerdp.com/<br>  Added June  2, 2016<br>  License: [`apache-2.0`](http://choosealicense.com/licenses/apache-2.0/)
  <div><img height='300' alt='FreeRDP image 1' src='http://a1.mzstatic.com/us/r30/Purple2/v4/e3/12/7a/e3127ad7-99e8-c4f7-225a-dc99edf760d9/screen696x696.jpeg'> <img height='300' alt='FreeRDP image 2' src='http://a1.mzstatic.com/us/r30/Purple/v4/d9/c9/4b/d9c94b66-389b-0b57-cd54-794a2aa18d7f/screen696x696.jpeg'> <img height='300' alt='FreeRDP image 3' src='http://a3.mzstatic.com/us/r30/Purple2/v4/aa/59/90/aa59909a-ddfb-2c80-1814-dba25350d4d4/screen696x696.jpeg'> <img height='300' alt='FreeRDP image 4' src='http://a2.mzstatic.com/us/r30/Purple/v4/ff/c2/c3/ffc2c3cc-23da-490e-13a3-f827a61dac70/screen696x696.jpeg'> 
</div>
  </details>

- FuseCloud: Music player that connects with SoundCloud  
  <details><summary><code>fuse</code> <code>javascript</code> </summary>

  https://github.com/fusetools/FuseCloud<br>  Added July 24, 2017<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='FuseCloud image 1' src='http://a1.mzstatic.com/us/r30/Purple71/v4/98/3a/e2/983ae222-5541-f601-0c9f-4b83bc2d12d1/screen696x696.jpeg'> <img height='300' alt='FuseCloud image 2' src='http://a2.mzstatic.com/us/r30/Purple71/v4/25/a9/d6/25a9d622-1764-f0d4-eb74-bb0662a3c375/screen696x696.jpeg'> 
</div>
  </details>

- Hackfoldr: Share all your project documents with a link [` App Store`](https://itunes.apple.com/app/hackfoldr/id919010837)  
  <details><summary><code>objc</code> </summary>

  https://github.com/hackfoldr/hackfoldr-iOS<br>  https://hackfoldr.org<br>  Added July 18, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Hackfoldr image 1' src='http://a3.mzstatic.com/us/r30/Purple69/v4/bb/ee/2f/bbee2f6f-68b0-48b8-5949-e5b4bc49cc8c/screen696x696.jpeg'> <img height='300' alt='Hackfoldr image 2' src='http://a4.mzstatic.com/us/r30/Purple49/v4/b6/7a/49/b67a496a-c81c-d9b9-81e0-cae43136b41b/screen696x696.jpeg'> <img height='300' alt='Hackfoldr image 3' src='http://a5.mzstatic.com/us/r30/Purple60/v4/49/56/85/4956850f-d8e7-bcb3-26f5-f778b80f8540/screen696x696.jpeg'> 
</div>
  </details>

- iCopyPasta: Pasteboard feed  
  <details><summary><code>swift</code> </summary>

  https://github.com/alltheflow/iCopyPasta<br>  Added February 28, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='iCopyPasta image 1' src='https://i.imgur.com/6Tw24I2.png'> <img height='300' alt='iCopyPasta image 2' src='https://i.imgur.com/akwJw0D.png'> 
</div>
  </details>

- LibreOffice Remote for Impress: Interact with [LibreOffice](https://www.libreoffice.org/) slideshows remotely [` App Store`](https://itunes.apple.com/app/id806879890)  
  <details><summary><code>objc</code> </summary>

  https://cgit.freedesktop.org/libreoffice/impress_remote/<br>  Added June  2, 2016<br>  License: [`mpl-2.0`](http://choosealicense.com/licenses/mpl-2.0/)
  <div><img height='300' alt='LibreOffice Remote for Impress image 1' src='http://a2.mzstatic.com/us/r30/Purple4/v4/1c/51/bc/1c51bc28-3304-2397-bdf1-9914c0174941/screen696x696.jpeg'> <img height='300' alt='LibreOffice Remote for Impress image 2' src='http://a1.mzstatic.com/us/r30/Purple6/v4/0d/0c/ac/0d0cac78-443e-2843-93b4-420a51ff087e/screen696x696.jpeg'> <img height='300' alt='LibreOffice Remote for Impress image 3' src='http://a5.mzstatic.com/us/r30/Purple/v4/b1/9f/c3/b19fc322-91e7-e917-8701-52c88fd91b0d/screen696x696.jpeg'> <img height='300' alt='LibreOffice Remote for Impress image 4' src='http://a2.mzstatic.com/us/r30/Purple/v4/6d/67/a2/6d67a262-409a-8156-aaee-86e14bebfc6d/screen696x696.jpeg'> <img height='300' alt='LibreOffice Remote for Impress image 5' src='http://a5.mzstatic.com/us/r30/Purple/v4/2c/56/d7/2c56d7d8-f310-0a4f-9db6-38d7508939b9/screen696x696.jpeg'> 
</div>
  </details>

- MADBike: Can you imagine if the BiciMAD app had its own style, was easy and intuitive, and had an awesome design? That’s exactly what we do. [` App Store`](https://itunes.apple.com/app/madbike/id1067596651)  
  <details><summary><code>3d-touch</code> <code>clone</code> <code>core-data</code> <code>firebase</code> <code>fitness</code> <code>location</code> <code>news</code> <code>weather</code> </summary>

  https://github.com/alexruperez/MADBike<br>  https://www.madbikeapp.com<br>  Added September 25, 2017<br>  License: [`gpl-3.0`](http://choosealicense.com/licenses/gpl-3.0/)
  <div><img height='300' alt='MADBike image 1' src='https://is1-ssl.mzstatic.com/image/thumb/Purple62/v4/8b/9e/71/8b9e71a4-38e6-44b5-fa82-0b7a0ce3bacd/pr_source.png/0x0ss.jpg'> <img height='300' alt='MADBike image 2' src='https://is1-ssl.mzstatic.com/image/thumb/Purple62/v4/10/6d/cc/106dcc94-1daf-c1f8-12ce-0cb234657f7e/pr_source.png/0x0ss.jpg'> <img height='300' alt='MADBike image 3' src='https://is1-ssl.mzstatic.com/image/thumb/Purple71/v4/85/a5/a7/85a5a7c0-ebc9-27d4-5f81-6d7c6f7b4c02/pr_source.png/0x0ss.jpg'> <img height='300' alt='MADBike image 4' src='https://is1-ssl.mzstatic.com/image/thumb/Purple71/v4/b6/91/dd/b691dda9-6f80-4942-3182-0c848ac0477a/pr_source.jpg/0x0ss.jpg'> 
</div>
  </details>

- Mirror++: Minimalist mirror  
  <details><summary><code>swift</code> </summary>

  https://github.com/nathunsmitty/MirrorPlusPlus<br>  Added January  4, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Mirror++ image 1' src='https://i.imgur.com/i2nVDNQ.png'> 
</div>
  </details>

- my41: HP-41C/CV/CX Microcode emulator [` App Store`](https://itunes.apple.com/app/my41cx/id979041950)  
  <details><summary><code>objc</code> </summary>

  https://github.com/mperovic/my41<br>  Added February 19, 2016<br>  License: [`bsd-3-clause`](http://choosealicense.com/licenses/bsd-3-clause/)
  <div><img height='300' alt='my41 image 1' src='http://a4.mzstatic.com/us/r30/Purple5/v4/67/ee/d3/67eed392-7fb1-5cb6-7e94-de81031ac6b3/screen696x696.jpeg'> <img height='300' alt='my41 image 2' src='http://a2.mzstatic.com/us/r30/Purple3/v4/62/27/f9/6227f9dd-9c29-938d-7dc1-4f6549f4fed9/screen696x696.jpeg'> <img height='300' alt='my41 image 3' src='http://a2.mzstatic.com/us/r30/Purple3/v4/d7/7f/24/d77f240e-4f3e-fc00-34b3-1e1a5ade3394/screen696x696.jpeg'> <img height='300' alt='my41 image 4' src='http://a2.mzstatic.com/us/r30/Purple3/v4/8d/3b/c0/8d3bc0a3-d13a-4860-ec67-f0f89ef972f2/screen696x696.jpeg'> 
</div>
  </details>

- ooniprobe: Detect internet censorship & test your network's speed [` App Store`](https://itunes.apple.com/app/id1199566366)  
  <details><summary><code>toast</code> </summary>

  https://github.com/TheTorProject/ooniprobe-ios<br>  Added February 10, 2017<br>  License: [`bsd-2-clause`](http://choosealicense.com/licenses/bsd-2-clause/)
  <div><img height='300' alt='ooniprobe image 1' src='http://a5.mzstatic.com/us/r30/Purple122/v4/58/f4/3a/58f43a5b-cc09-413a-c0b5-fc0f1c9c660b/screen696x696.jpeg'> <img height='300' alt='ooniprobe image 2' src='http://a4.mzstatic.com/us/r30/Purple122/v4/26/21/b8/2621b82f-f8e8-02ef-7ea7-411d5168247a/screen696x696.jpeg'> <img height='300' alt='ooniprobe image 3' src='http://a1.mzstatic.com/us/r30/Purple122/v4/72/59/e7/7259e715-c87b-5fd4-daa7-98daccd3892d/screen696x696.jpeg'> <img height='300' alt='ooniprobe image 4' src='http://a4.mzstatic.com/us/r30/Purple111/v4/93/ed/00/93ed005d-36f9-5e8d-7b9f-0a4e2a8def60/screen696x696.jpeg'> <img height='300' alt='ooniprobe image 5' src='http://a4.mzstatic.com/us/r30/Purple111/v4/53/bb/0d/53bb0dae-168b-126b-f8a3-fdb0f9d43111/screen696x696.jpeg'> 
</div>
  </details>

- openHAB: Vendor & technology agnostic home automation [` App Store`](https://itunes.apple.com/app/id492054521)  
  <details><summary><code>objc</code> </summary>

  https://github.com/openhab/openhab.ios<br>  http://www.openhab.org/<br>  Added June  2, 2016<br>  License: [`epl-1.0`](http://choosealicense.com/licenses/epl-1.0/)
  <div><img height='300' alt='openHAB image 1' src='http://a5.mzstatic.com/us/r30/Purple1/v4/ce/c8/32/cec832bd-868f-30be-ed46-37c8323659d5/screen696x696.jpeg'> <img height='300' alt='openHAB image 2' src='http://a3.mzstatic.com/us/r30/Purple5/v4/ff/54/8e/ff548e6a-7163-1d55-2f22-7fa0cd91475b/screen696x696.jpeg'> <img height='300' alt='openHAB image 3' src='http://a1.mzstatic.com/us/r30/Purple5/v4/fb/69/1b/fb691b81-40db-5acd-6003-dc5709f04791/screen696x696.jpeg'> <img height='300' alt='openHAB image 4' src='http://a2.mzstatic.com/us/r30/Purple3/v4/0c/38/5b/0c385b22-15b0-4ab4-b032-f186a1da5f11/screen696x696.jpeg'> <img height='300' alt='openHAB image 5' src='http://a5.mzstatic.com/us/r30/Purple3/v4/ef/f2/91/eff2918a-0b62-2d0e-68b4-912ee8b989e1/screen696x696.jpeg'> 
</div>
  </details>

- ownCloud: File browser & sync for ownCloud file hosting service [` App Store`](https://itunes.apple.com/app/owncloud/id543672169)  
  <details><summary><code>objc</code> 🔥🔥🔥</summary>

  https://github.com/owncloud/ios<br>  Added May 18, 2015<br>  License: [`gpl-3.0`](http://choosealicense.com/licenses/gpl-3.0/)
  <div><img height='300' alt='ownCloud image 1' src='http://a3.mzstatic.com/us/r30/Purple62/v4/fd/37/a1/fd37a1e0-d1dd-4830-6eb3-0e6825d4ba75/screen696x696.jpeg'> <img height='300' alt='ownCloud image 2' src='http://a2.mzstatic.com/us/r30/Purple22/v4/04/ca/6e/04ca6e9b-24b9-7a91-a72b-020153721110/screen696x696.jpeg'> <img height='300' alt='ownCloud image 3' src='http://a3.mzstatic.com/us/r30/Purple71/v4/71/66/6d/71666db7-0256-3742-4ba7-543ab499c24b/screen696x696.jpeg'> <img height='300' alt='ownCloud image 4' src='http://a2.mzstatic.com/us/r30/Purple71/v4/ce/0a/6f/ce0a6ffa-1da8-d2ad-dab0-9e2e04752fcc/screen696x696.jpeg'> <img height='300' alt='ownCloud image 5' src='http://a1.mzstatic.com/us/r30/Purple71/v4/ad/d5/7f/add57f6a-f4c6-55e0-4b99-6548e32ae37f/screen696x696.jpeg'> 
</div>
  </details>

- Phonetic: Add phonetic keys for Chinese names  
  <details><summary><code>swift</code> 🔥🔥🔥</summary>

  https://github.com/iAugux/Phonetic<br>  Added February 27, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Phonetic image 1' src='https://raw.githubusercontent.com/iAugux/ProjectScreenshots/master/Phonetic/nickname.gif'> 
</div>
  </details>

- Seafile Pro: App for Seafile self-hosted file sharing [` App Store`](https://itunes.apple.com/app/id639202512)  
  <details><summary><code>objc</code> 🔥</summary>

  https://github.com/haiwen/seafile-iOS<br>  https://www.seafile.com/en/home/<br>  Added June  1, 2016<br>  License: [`apache-2.0`](http://choosealicense.com/licenses/apache-2.0/)
  <div><img height='300' alt='Seafile Pro image 1' src='http://a5.mzstatic.com/us/r30/Purple69/v4/ed/0e/97/ed0e97b6-a234-0cf4-be3f-26cad9e8af54/screen696x696.jpeg'> <img height='300' alt='Seafile Pro image 2' src='http://a3.mzstatic.com/us/r30/Purple49/v4/a8/f7/90/a8f79012-1000-bd3b-a35c-bdd1a6c67006/screen696x696.jpeg'> <img height='300' alt='Seafile Pro image 3' src='http://a4.mzstatic.com/us/r30/Purple49/v4/c5/ad/b2/c5adb208-d27d-35ff-ef4d-91a031155986/screen696x696.jpeg'> <img height='300' alt='Seafile Pro image 4' src='http://a4.mzstatic.com/us/r30/Purple49/v4/50/03/6a/50036a6e-861b-dd04-56e8-1590d539c5fe/screen696x696.jpeg'> <img height='300' alt='Seafile Pro image 5' src='http://a5.mzstatic.com/us/r30/Purple49/v4/a1/a5/c5/a1a5c524-5a8c-6a68-5bca-30bdb3989b3d/screen696x696.jpeg'> 
</div>
  </details>

- Swiflytics: See your realtime Google Analytics data  
  <details><summary><code>swift</code> </summary>

  https://github.com/aciidb0mb3r/Swiflytics<br>  Added April 26, 2016<br>  License: `other`
  <div><img height='300' alt='Swiflytics image 1' src='http://a3.mzstatic.com/us/r30/Purple69/v4/86/ab/68/86ab68a5-88d7-b086-da5d-1fc67b01053a/screen696x696.jpeg'> <img height='300' alt='Swiflytics image 2' src='http://a4.mzstatic.com/us/r30/Purple49/v4/59/06/4d/59064d82-a209-b76f-11d9-60cc244a3280/screen696x696.jpeg'> <img height='300' alt='Swiflytics image 3' src='http://a1.mzstatic.com/us/r30/Purple49/v4/8d/19/c8/8d19c833-2cb8-49d0-3ae3-a646d9a9a1ee/screen696x696.jpeg'> <img height='300' alt='Swiflytics image 4' src='http://a2.mzstatic.com/us/r30/Purple69/v4/02/b0/7c/02b07c1a-40ad-417a-a875-fa6b3bfbe12d/screen696x696.jpeg'> 
</div>
  </details>

- TKeyboard: Enter content into your device with a Mac keyboard, clipboard/image sync & more [` App Store`](https://itunes.apple.com/app/tkeyboard/id1168383839)  
  <details><summary><code>bluetooth</code> 🔥🔥🔥</summary>

  https://github.com/music4kid/TKeyboard<br>  Added June  2, 2017<br>  License: [`gpl-3.0`](http://choosealicense.com/licenses/gpl-3.0/)
  <div><img height='300' alt='TKeyboard image 1' src='http://a2.mzstatic.com/us/r30/Purple122/v4/e0/19/ea/e019ea9f-124c-4476-2683-e49f4e568d43/screen696x696.jpeg'> 
</div>
  </details>

- Vinylogue: Last.fm app [` App Store`](https://itunes.apple.com/app/vinylogue-for-last.fm/id617471119)  
  <details><summary><code>objc</code> 🔥</summary>

  https://github.com/twocentstudios/vinylogue<br>  Added January 27, 2015<br>  License: [`bsd-3-clause`](http://choosealicense.com/licenses/bsd-3-clause/)
  <div><img height='300' alt='Vinylogue image 1' src='http://a5.mzstatic.com/us/r30/Purple3/v4/a7/4f/eb/a74feb66-e0ff-97be-8998-5e1dedabe6d4/screen696x696.jpeg'> <img height='300' alt='Vinylogue image 2' src='http://a3.mzstatic.com/us/r30/Purple3/v4/84/32/4d/84324d90-b033-ecb1-6cca-9d4ac426d5ad/screen696x696.jpeg'> <img height='300' alt='Vinylogue image 3' src='http://a2.mzstatic.com/us/r30/Purple5/v4/8f/4d/83/8f4d83a3-844a-e491-00ec-797055b99ba8/screen696x696.jpeg'> <img height='300' alt='Vinylogue image 4' src='http://a2.mzstatic.com/us/r30/Purple3/v4/87/9f/31/879f3147-e2e2-f25a-550f-8cac23dfd829/screen696x696.jpeg'> 
</div>
  </details>


### 3D Touch 
 
[back to top](#readme) 
 
- ForceSketch: Sketching app  
  <details><summary><code>swift</code> </summary>

  https://github.com/FlexMonkey/ForceSketch<br>  Added October 28, 2015<br>  License: `other`
  <div><img height='300' alt='ForceSketch image 1' src='https://github.com/FlexMonkey/ForceSketch/raw/master/ForceSketch/ForceSketch.gif'> 
</div>
  </details>

- Plum-O-Meter: Weigh plums (and other small fruit!)  
  <details><summary><code>swift</code> 🔥🔥</summary>

  https://github.com/FlexMonkey/Plum-O-Meter<br>  Added October 27, 2015<br>  License: `other`
  <div><img height='300' alt='Plum-O-Meter image 1' src='https://i.imgur.com/V3kaLaC.png'> 
</div>
  </details>


### Appcelerator 
 
[back to top](#readme) 
 
- LVMC: Multicolumn ListView example  
  <details><summary><code>titanium</code> <code>javascript</code> </summary>

  https://github.com/falkolab/LVMC-Demo-Alloy-App<br>  Added April  4, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='LVMC image 1' src='https://github.com/falkolab/LVMC/raw/master/screenshot.png?raw=true'> 
</div>
  </details>

- OMDB: Movie information  
  <details><summary><code>titanium</code> <code>javascript</code> </summary>

  https://github.com/gnithin/appceleratorOMDB<br>  Added February  8, 2017<br>  License: [`apache-2.0`](http://choosealicense.com/licenses/apache-2.0/)
  </details>

- Tracker 4 Compassion: Track your walk, run or ride [` App Store`](https://itunes.apple.com/app/g.o.-tracker-4-compassion/id1100240821)  
  <details><summary><code>titanium</code> <code>javascript</code> </summary>

  https://github.com/fokkezb/tracker<br>  Added April 21, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Tracker 4 Compassion image 1' src='http://a1.mzstatic.com/us/r30/Purple49/v4/f5/f4/07/f5f4071e-ba12-9c92-a931-599dcabffa71/screen696x696.jpeg'> <img height='300' alt='Tracker 4 Compassion image 2' src='http://a5.mzstatic.com/us/r30/Purple49/v4/29/de/d0/29ded0fb-2754-ea0d-d0d7-ed66f26e5838/screen696x696.jpeg'> <img height='300' alt='Tracker 4 Compassion image 3' src='http://a5.mzstatic.com/us/r30/Purple49/v4/aa/24/c7/aa24c7ba-6fc1-5c13-ec7c-0a8509296c95/screen696x696.jpeg'> <img height='300' alt='Tracker 4 Compassion image 4' src='http://a3.mzstatic.com/us/r30/Purple49/v4/8a/d4/97/8ad49780-e8f9-a122-fbba-a0a62a08506c/screen696x696.jpeg'> 
</div>
  </details>


### Core Data 
 
[back to top](#readme) 
 
- Crystal Clipboard: Copy and paste between devices [` App Store`](https://itunes.apple.com/app/crystal-clipboard/id1287332321)  
  <details><summary><code>swift</code> <code>swift4</code> <code>cocoapodskeys</code> <code>reactivecocoa</code> <code>moya</code> <code>starscream</code> <code>mvvm</code> </summary>

  https://github.com/jzzocc/crystal-clipboard-ios<br>  Added October 12, 2017<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Crystal Clipboard image 1' src='https://raw.githubusercontent.com/jzzocc/crystal-clipboard-ios/master/screenshots/en-US/iPhone%208-landing.png'> <img height='300' alt='Crystal Clipboard image 2' src='https://raw.githubusercontent.com/jzzocc/crystal-clipboard-ios/master/screenshots/en-US/iPhone%208-clips.png'> <img height='300' alt='Crystal Clipboard image 3' src='https://raw.githubusercontent.com/jzzocc/crystal-clipboard-ios/master/screenshots/en-US/iPhone%208-add.png'> 
</div>
  </details>

- DVD Collection Tracker  
  <details><summary><code>objc</code> </summary>

  https://github.com/chrismiles/OrganisingCoreData<br>  Added August  7, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='DVD Collection Tracker image 1' src='https://i.imgur.com/MuViFyc.png'> <img height='300' alt='DVD Collection Tracker image 2' src='https://i.imgur.com/pn2qSEg.png'> <img height='300' alt='DVD Collection Tracker image 3' src='https://i.imgur.com/yTD7r0K.png'> <img height='300' alt='DVD Collection Tracker image 4' src='https://i.imgur.com/MxFiCpn.png'> 
</div>
  </details>

- Listr: Wish list  
  <details><summary><code>swift</code> </summary>

  https://github.com/etchsaleh/Listr<br>  Added February  3, 2017<br>  License: [`gpl-2.0`](http://choosealicense.com/licenses/gpl-2.0/)
  <div><img height='300' alt='Listr image 1' src='https://i.imgur.com/CJsIdOS.png'> <img height='300' alt='Listr image 2' src='https://i.imgur.com/rLX3Fsf.png'> 
</div>
  </details>

- Nested Lists  
  <details><summary><code>objc</code> 🔥</summary>

  https://github.com/objcio/issue-4-full-core-data-application<br>  Added August  7, 2015<br>  License: `other`
  <div><img height='300' alt='Nested Lists image 1' src='https://i.imgur.com/z8Xw0qC.png'> <img height='300' alt='Nested Lists image 2' src='https://i.imgur.com/M5pwaAf.png'> 
</div>
  </details>

- Tagger: Help tag your photos on Instagram or Flickr  
  <details><summary><code>swift</code> </summary>

  https://github.com/vanyaland/Tagger<br>  Added July  3, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Tagger image 1' src='https://github.com/vanyaland/Tagger/raw/master/Screenshots/main.png'> 
</div>
  </details>

- Tasks: Designed to quickly & easily add tasks [` App Store`](https://itunes.apple.com/app/task-application/id960435759)  
  <details><summary><code>swift</code> <code>iphone</code> </summary>

  https://github.com/mbcrump/TasksForSwiftWithPersistingData<br>  Added March  5, 2015<br>  License: `other`
  <div><img height='300' alt='Tasks image 1' src='http://a3.mzstatic.com/us/r30/Purple3/v4/9f/b9/e8/9fb9e869-e097-7fa2-ca0c-0b013e1c7d06/screen696x696.jpeg'> <img height='300' alt='Tasks image 2' src='http://a2.mzstatic.com/us/r30/Purple1/v4/d1/ba/40/d1ba40d5-760c-141b-06ec-4379d21d6316/screen696x696.jpeg'> <img height='300' alt='Tasks image 3' src='http://a5.mzstatic.com/us/r30/Purple3/v4/70/5f/f2/705ff244-02ac-c7a4-eef0-9971f0c89ed1/screen696x696.jpeg'> <img height='300' alt='Tasks image 4' src='http://a3.mzstatic.com/us/r30/Purple3/v4/04/52/da/0452daf2-5d76-62f7-1f98-86de67e257dc/screen696x696.jpeg'> 
</div>
  </details>


### Firebase 
 
https://firebase.google.com/ — [back to top](#readme) 
 
- Californication: Discover only the best points of interest in the California  
  <details><summary><code>swift</code> </summary>

  https://github.com/vanyaland/Californication<br>  Added August  7, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Californication image 1' src='https://github.com/vanyaland/Californication/raw/master/screenshot.png'> 
</div>
  </details>

- Chaty: Anonymous messaging with real time data sync  
  <details><summary><code>firebase</code> <code>websocket</code> <code>nosql</code> 🔥🔥</summary>

  https://github.com/LunarFlash/Chaty<br>  Added May 25, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Chaty image 1' src='https://github.com/LunarFlash/Chaty/raw/master/ChatChat/screen1.png'> 
</div>
  </details>

- CodeSprint: Real-time SCRUM management tool for teams  
  <details><summary><code>objc</code> </summary>

  https://github.com/chauvincent/CodeSprint-iOS<br>  Added November 23, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='CodeSprint image 1' src='http://a1.mzstatic.com/us/r30/Purple62/v4/95/15/ad/9515add9-5322-a96e-5ab6-bbd258d524d5/screen696x696.jpeg'> <img height='300' alt='CodeSprint image 2' src='http://a1.mzstatic.com/us/r30/Purple71/v4/3e/95/f0/3e95f062-ed08-1a9f-b64a-f7cc05930e42/screen696x696.jpeg'> <img height='300' alt='CodeSprint image 3' src='http://a4.mzstatic.com/us/r30/Purple62/v4/88/94/25/88942500-f5ea-c03f-41d6-81477f9b78f9/screen696x696.jpeg'> <img height='300' alt='CodeSprint image 4' src='http://a3.mzstatic.com/us/r30/Purple62/v4/36/1c/42/361c4270-a061-f7fc-19fa-91e4321aecc4/screen696x696.jpeg'> <img height='300' alt='CodeSprint image 5' src='http://a5.mzstatic.com/us/r30/Purple62/v4/5a/47/90/5a47904c-a86c-336d-c105-9dd20dac1872/screen696x696.jpeg'> 
</div>
  </details>

- Hacker News Client [` App Store`](https://itunes.apple.com/app/hacker-news-client/id939454231)  
  <details><summary><code>firebase</code> 🔥🔥</summary>

  https://github.com/bonzoq/hniosreader<br>  Added April 30, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Hacker News Client image 1' src='http://a5.mzstatic.com/us/r30/Purple1/v4/46/69/84/46698435-8f5f-dd7f-ac16-367147207a19/screen696x696.jpeg'> <img height='300' alt='Hacker News Client image 2' src='http://a4.mzstatic.com/us/r30/Purple1/v4/e2/ed/6b/e2ed6bb7-0c9f-f508-b05b-f466adedbf2e/screen696x696.jpeg'> <img height='300' alt='Hacker News Client image 3' src='http://a3.mzstatic.com/us/r30/Purple3/v4/af/7a/39/af7a39ec-9064-7d8b-5167-4ba6ef58c46d/screen696x696.jpeg'> <img height='300' alt='Hacker News Client image 4' src='http://a4.mzstatic.com/us/r30/Purple1/v4/86/90/fc/8690fc26-a667-d618-be3d-c84cb55cdb84/screen696x696.jpeg'> 
</div>
  </details>

- how-much: Simple app to record how much things cost  
  <details><summary><code>parse</code> <code>firebase</code> <code>realm</code> </summary>

  https://github.com/dkhamsing/how-much<br>  Added October  6, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='how-much image 1' src='https://github.com/dkhamsing/how-much/raw/master/Assets/screens.png'> 
</div>
  </details>

- Messenger: Audio/video calls, realtime chat & full offline support  
  <details><summary><code>firebase</code> <code>onesignal</code> <code>realm</code> 🔥🔥🔥🔥🔥</summary>

  https://github.com/relatedcode/Messenger<br>  Added July 19, 2017<br>  License: `other`
  <div><img height='300' alt='Messenger image 1' src='http://relatedcode.com/screen/chat01.png'> <img height='300' alt='Messenger image 2' src='http://relatedcode.com/screen/call1.png'> 
</div>
  </details>

- Potter Pics: Harry Potter themed social network similar to Instagram.  
  <details><summary><code>swift</code> <code>swift3</code> <code>firebase</code> 🔥</summary>

  https://github.com/surayashivji/PotterPics<br>  Added January 15, 2017
  <div><img height='300' alt='Potter Pics image 1' src='https://github.com/surayashivji/PotterPics/blob/master/Overview.gif'> 
</div>
  </details>

- prox: Decide what to do next, based on your current location  
  <details><summary><code>swift</code> <code>afnetworking</code> <code>firebase</code> </summary>

  https://github.com/mozilla-mobile/prox<br>  https://wiki.mozilla.org/New_Mobile_Experience<br>  Added February  3, 2017<br>  License: `other`
  <div><img height='300' alt='prox image 1' src='https://cdn-images-1.medium.com/max/800/1*vwHKVE8rpcMyqr5Ec7MSxQ.png'> 
</div>
  </details>

- Quick Chat: Real time chat app  
  <details><summary><code>swift</code> <code>swift3</code> <code>firebase</code> 🔥🔥🔥🔥</summary>

  https://github.com/aslanyanhaik/Quick-Chat<br>  Added January  6, 2017<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Quick Chat image 1' src='https://raw.githubusercontent.com/aslanyanhaik/Quick-Chat/master/screenshot.gif'> 
</div>
  </details>

- Quickstart Samples  
  <details><summary><code>objc</code> 🔥🔥🔥</summary>

  https://github.com/firebase/quickstart-ios<br>  Added May 17, 2017<br>  License: [`apache-2.0`](http://choosealicense.com/licenses/apache-2.0/)
  </details>

- Real-time Chat  
  <details><summary><code>firebase</code> </summary>

  https://www.raywenderlich.com/140836/firebase-tutorial-real-time-chat-2<br>  Added November 11, 2016<br>  License: `other`
  <div><img height='300' alt='Real-time Chat image 1' src='https://koenig-media.raywenderlich.com/uploads/2016/08/RoadCyclingChatThread.jpg'> 
</div>
  </details>

- WhatsUp: Chat app  
  <details><summary><code>swift</code> <code>swift3</code> <code>firebase</code> <code>contacts</code> <code>otp</code> </summary>

  https://github.com/satishbabariya/WhatsUp<br>  Added September 12, 2017<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='WhatsUp image 1' src='https://raw.githubusercontent.com/satishbabariya/WhatsUp/master/screenshot2.jpg'> 
</div>
  </details>


### Ionic 
 
http://ionicframework.com/ — [back to top](#readme) 
 
- Minds: An encrypted social network [` App Store`](https://itunes.apple.com/app/id961771928)  
  <details><summary><code>angular</code> <code>cordova</code> 🔥</summary>

  https://github.com/Minds/mobile<br>  https://www.minds.com/<br>  Added June  2, 2016<br>  License: [`agpl-3.0`](http://choosealicense.com/licenses/agpl-3.0/)
  <div><img height='300' alt='Minds image 1' src='http://a2.mzstatic.com/us/r30/Purple69/v4/88/d6/7e/88d67efd-b235-e4ac-fe33-0f9c6a48717d/screen696x696.jpeg'> <img height='300' alt='Minds image 2' src='http://a4.mzstatic.com/us/r30/Purple7/v4/cd/91/fb/cd91fbc1-927a-68dc-0d06-6abd52627ff0/screen696x696.jpeg'> <img height='300' alt='Minds image 3' src='http://a3.mzstatic.com/us/r30/Purple2/v4/55/27/2c/55272c66-e389-5b0c-ceab-9165d3b4a9ec/screen696x696.jpeg'> <img height='300' alt='Minds image 4' src='http://a1.mzstatic.com/us/r30/Purple49/v4/ce/78/dc/ce78dc5a-2c47-0c12-309c-a821bbb8e4f3/screen696x696.jpeg'> 
</div>
  </details>

- Vegan Lists UK: View & collect vegan food lists  
  <details><summary><code>typescript</code> </summary>

  https://github.com/dsgriffin/vegan-lists-uk<br>  Added February 28, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Vegan Lists UK image 1' src='http://a1.mzstatic.com/us/r30/Purple49/v4/4d/55/87/4d558798-7ba1-51fd-cfaf-f43073621bd2/screen696x696.jpeg'> <img height='300' alt='Vegan Lists UK image 2' src='http://a5.mzstatic.com/us/r30/Purple69/v4/09/43/96/09439616-213a-1355-1cbd-d65626cf2bb6/screen696x696.jpeg'> <img height='300' alt='Vegan Lists UK image 3' src='http://a4.mzstatic.com/us/r30/Purple69/v4/cd/09/c1/cd09c198-bb31-5b74-1aca-6973eeade7ae/screen696x696.jpeg'> <img height='300' alt='Vegan Lists UK image 4' src='http://a5.mzstatic.com/us/r30/Purple49/v4/ee/cc/c0/eeccc040-d840-4c30-0dd0-037dce7ec3dd/screen696x696.jpeg'> <img height='300' alt='Vegan Lists UK image 5' src='http://a3.mzstatic.com/us/r30/Purple69/v4/0e/36/32/0e36329c-71a0-a6af-fa2a-643a91167c05/screen696x696.jpeg'> 
</div>
  </details>


### Parse 
 
https://en.wikipedia.org/wiki/Parse_(company) — [back to top](#readme) 
 
- 1Trackr: Log your community service hours to the cloud  
  <details><summary><code>parse</code> </summary>

  https://github.com/JerryHDev/1Trackr<br>  Added April 11, 2016<br>  License: `other`
  <div><img height='300' alt='1Trackr image 1' src='http://a3.mzstatic.com/us/r30/Purple60/v4/2a/23/28/2a2328e4-4006-604e-1751-d38e2b287d80/screen696x696.jpeg'> <img height='300' alt='1Trackr image 2' src='http://a2.mzstatic.com/us/r30/Purple18/v4/f1/b8/b0/f1b8b077-1977-15fa-7731-0672303a94e2/screen696x696.jpeg'> <img height='300' alt='1Trackr image 3' src='http://a4.mzstatic.com/us/r30/Purple30/v4/0d/b0/57/0db05780-fb74-f2b6-3329-505cd8a529f0/screen696x696.jpeg'> <img height='300' alt='1Trackr image 4' src='http://a5.mzstatic.com/us/r30/Purple30/v4/03/b4/4f/03b44f66-7cfe-7314-5ee0-0acd900d6c92/screen696x696.jpeg'> <img height='300' alt='1Trackr image 5' src='http://a1.mzstatic.com/us/r30/Purple20/v4/97/05/12/97051277-bc7b-5afc-d73b-6d5df2e7fc8a/screen696x696.jpeg'> 
</div>
  </details>

- 2CITY: Find out the coolest things to do in your city  
  <details><summary><code>objc</code> </summary>

  https://github.com/2city/2CITY-iOS<br>  Added October 12, 2015<br>  License: `other`
  <div><img height='300' alt='2CITY image 1' src='http://a3.mzstatic.com/us/r30/Purple3/v4/97/56/ac/9756acae-6315-37b3-3e0c-f53d7317a056/screen696x696.jpeg'> <img height='300' alt='2CITY image 2' src='http://a1.mzstatic.com/us/r30/Purple5/v4/b9/03/90/b90390ca-787a-b0aa-f5b3-82d1ba233bd1/screen696x696.jpeg'> <img height='300' alt='2CITY image 3' src='http://a2.mzstatic.com/us/r30/Purple3/v4/97/98/5d/97985d61-9604-7eaa-8087-027f97beb1e8/screen696x696.jpeg'> <img height='300' alt='2CITY image 4' src='http://a4.mzstatic.com/us/r30/Purple3/v4/f2/22/22/f22222e3-e3cd-aa5e-9a1f-e58506c8b94e/screen696x696.jpeg'> 
</div>
  </details>

- Anypic  
  <details><summary><code>swift</code> </summary>

  https://github.com/SwiftAnyPic/SwiftAnyPic<br>  Added November  2, 2015<br>  License: [`cc0-1.0`](http://choosealicense.com/licenses/cc0-1.0/)
  <div><img height='300' alt='Anypic image 1' src='https://i.imgur.com/hkcrHaH.jpg'> 
</div>
  </details>

- Jim: Track your gym workouts  
  <details><summary><code>swift</code> <code>parse</code> </summary>

  https://github.com/kylejm/Jim<br>  Added January  4, 2016<br>  License: `other`
  </details>

- Parse Dashboard: Manage your Parse apps while you are on the go [` App Store`](https://itunes.apple.com/app/parse-dashboard/id1212141622)  
  <details><summary><code>swift</code> <code>swiftyjson</code> </summary>

  https://github.com/nathantannar4/Parse-Dashboard-for-iOS<br>  Added October  1, 2017<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Parse Dashboard image 1' src='https://github.com/nathantannar4/Parse-Dashboard-for-iOS/raw/master/Screenshots/D.png?raw=true'> <img height='300' alt='Parse Dashboard image 2' src='https://github.com/nathantannar4/Parse-Dashboard-for-iOS/raw/master/Screenshots/E.png?raw=true'> 
</div>
  </details>

- RaceMe: Run tracking & ghosting  
  <details><summary><code>swift</code> <code>parse</code> 🔥🔥🔥</summary>

  https://github.com/enochng1/RaceMe<br>  Added July 20, 2016<br>  License: `other`
  <div><img height='300' alt='RaceMe image 1' src='https://raw.githubusercontent.com/enochng1/RaceMe/master/raceMeGitImage.png'> 
</div>
  </details>


### React Native 
 
http://facebook.github.io/react-native/ — [back to top](#readme) 
 
- 30 days of React Native demos  
  <details><summary><code>react native</code> 🔥🔥🔥🔥🔥</summary>

  https://github.com/fangwei716/30-days-of-react-native<br>  Added August 15, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='30 days of React Native demos image 1' src='https://raw.githubusercontent.com/fangwei716/ThirtyDaysOfReactNative/screenshots/screenshot/main.gif'> 
</div>
  </details>

- AirBnb clone  
  <details><summary><code>react-native</code> 🔥🔥</summary>

  https://github.com/VctrySam/AirBnb<br>  Added August 14, 2016<br>  License: `other`
  <div><img height='300' alt='AirBnb clone image 1' src='https://i.imgur.com/vMgWK6m.png'> 
</div>
  </details>

- Artist: Use Relay to access the Artsy GraphQL API  
  <details><summary><code>react native</code> <code>graphql</code> </summary>

  https://github.com/orta/Relay-Artist-Example<br>  Added February  7, 2017<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Artist image 1' src='https://github.com/orta/Relay-Artist-Example/raw/master/screenshots/workshop.png?raw=true'> 
</div>
  </details>

- Assemblies: Developer-focused Meetup clone  
  <details><summary><code>react native</code> 🔥🔥</summary>

  https://github.com/buildreactnative/assemblies<br>  Added May  2, 2016<br>  License: `other`
  <div><img height='300' alt='Assemblies image 1' src='https://github.com/buildreactnative/assemblies/raw/master/screenshots/assemblies-a.png'> <img height='300' alt='Assemblies image 2' src='https://github.com/buildreactnative/assemblies/raw/master/screenshots/assemblies-b.png'> <img height='300' alt='Assemblies image 3' src='https://github.com/buildreactnative/assemblies/raw/master/screenshots/assemblies-c.png'> 
</div>
  </details>

- Bíóhúsið: See movie showtimes in Iceland [` App Store`](https://itunes.apple.com/app/biohusi/id1112946298)  
  <details><summary><code>react native</code> </summary>

  https://github.com/birkir/kvikmyndr-app<br>  Added February 27, 2017<br>  License: `other`
  <div><img height='300' alt='Bíóhúsið image 1' src='http://a3.mzstatic.com/us/r30/Purple122/v4/47/60/af/4760af23-821d-fe64-bef0-609676699d5d/screen696x696.jpeg'> <img height='300' alt='Bíóhúsið image 2' src='http://a3.mzstatic.com/us/r30/Purple111/v4/c2/c2/36/c2c236d9-7144-0a00-54d3-8caffd554174/screen696x696.jpeg'> <img height='300' alt='Bíóhúsið image 3' src='http://a3.mzstatic.com/us/r30/Purple111/v4/9b/15/d4/9b15d4d7-6ca3-1b33-d78c-cd098e35e4af/screen696x696.jpeg'> <img height='300' alt='Bíóhúsið image 4' src='http://a2.mzstatic.com/us/r30/Purple111/v4/c0/e1/83/c0e18311-891e-724b-8d32-e77a9aa3e4a5/screen696x696.jpeg'> 
</div>
  </details>

- Calculator: React Native calculator  
  <details><summary><code>react native</code> 🔥🔥🔥🔥🔥</summary>

  https://github.com/benoitvallon/react-native-nw-react-calculator<br>  Added March 23, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Calculator image 1' src='https://i.imgur.com/8OKDHjU.png'> 
</div>
  </details>

- Den: View houses for sale in the Northwest  
  <details><summary><code>react native</code> 🔥🔥</summary>

  https://github.com/asamiller/den<br>  Added May 29, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Den image 1' src='https://cloud.githubusercontent.com/assets/5133623/7338978/01976cce-ec13-11e4-9b79-f2e2e47503b6.jpg'> 
</div>
  </details>

- Dribbble  
  <details><summary><code>react native</code> <code>dribbble</code> 🔥🔥🔥🔥</summary>

  https://github.com/catalinmiron/react-native-dribbble-app<br>  Added June 13, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Dribbble image 1' src='https://cloud.githubusercontent.com/assets/2805320/8113463/db61b072-1076-11e5-8aa2-52417f019ea0.jpg'> 
</div>
  </details>

- F8 2016: Official F8 app  
  <details><summary><code>react native</code> 🔥🔥🔥🔥🔥</summary>

  https://github.com/fbsamples/f8app<br>  Added April 14, 2016<br>  License: `other`
  <div><img height='300' alt='F8 2016 image 1' src='https://github.com/fbsamples/f8app/raw/master/.github/screenshot-app@2x.png'> 
</div>
  </details>

- FC Barcelona clone  
  <details><summary><code>react-native</code> </summary>

  https://github.com/VctrySam/FCBarca<br>  Added August 14, 2016<br>  License: `other`
  <div><img height='300' alt='FC Barcelona clone image 1' src='https://i.imgur.com/6Xogt5Y.png'> 
</div>
  </details>

- Finance: The system Stocks app written in React Native  
  <details><summary><code>react native</code> 🔥🔥🔥🔥</summary>

  https://github.com/7kfpun/FinanceReactNative<br>  Added July  8, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Finance image 1' src='https://github.com/7kfpun/FinanceReactNative/blob/master/previewIOS.gif?raw=true'> 
</div>
  </details>

- Gitify: Brings your GitHub notifications in your pocket [` App Store`](https://itunes.apple.com/app/gitify/id1123311036)  
  <details><summary><code>react-native</code> </summary>

  https://github.com/manosim/gitify-mobile<br>  Added July  8, 2017<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Gitify image 1' src='http://a1.mzstatic.com/us/r30/Purple18/v4/88/b6/8a/88b68a7f-d3d8-e51b-9918-cb886b7a4a24/screen696x696.jpeg'> 
</div>
  </details>

- GitPoint: GitHub app with a minimal & beautiful UI [` App Store`](https://itunes.apple.com/app/gitpoint/id1251245162)  
  <details><summary><code>react-native</code> 🔥🔥🔥🔥🔥</summary>

  https://github.com/gitpoint/git-point<br>  Added July 14, 2017<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='GitPoint image 1' src='http://a3.mzstatic.com/us/r30/Purple127/v4/6d/82/6b/6d826be2-2f68-495c-0ba1-86d3da548287/screen696x696.jpeg'> <img height='300' alt='GitPoint image 2' src='http://a4.mzstatic.com/us/r30/Purple117/v4/1c/14/83/1c148311-bbee-ff46-6b97-1d109a0213b4/screen696x696.jpeg'> 
</div>
  </details>

- Hacker News app by iSimar [` App Store`](https://itunes.apple.com/app/hacker-news-reader-react-native/id1067161633)  
  <details><summary><code>react native</code> 🔥🔥🔥🔥🔥</summary>

  https://github.com/iSimar/HackerNews-React-Native<br>  Added July 10, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Hacker News app by iSimar image 1' src='http://a2.mzstatic.com/us/r30/Purple49/v4/ca/eb/26/caeb26d6-1bb4-8342-3e84-09dae06966ff/screen696x696.jpeg'> <img height='300' alt='Hacker News app by iSimar image 2' src='http://a1.mzstatic.com/us/r30/Purple69/v4/86/8a/f9/868af914-0fce-cc79-872a-63b96f8f5e53/screen696x696.jpeg'> <img height='300' alt='Hacker News app by iSimar image 3' src='http://a2.mzstatic.com/us/r30/Purple49/v4/ea/57/e6/ea57e6f5-4f1c-01e2-9175-d64833de659e/screen696x696.jpeg'> <img height='300' alt='Hacker News app by iSimar image 4' src='http://a5.mzstatic.com/us/r30/Purple49/v4/3c/b8/87/3cb8878d-44c2-6776-c9a2-6db9964f0ac1/screen696x696.jpeg'> 
</div>
  </details>

- iTunes Catalog Search  
  <details><summary><code>react native</code> </summary>

  https://github.com/alexissan/ReactNativeWorkshop<br>  Added June 13, 2015<br>  License: `other`
  <div><img height='300' alt='iTunes Catalog Search image 1' src='https://github.com/alexissan/ReactNativeWorkshop/raw/master/Screenshots/scsh1.png?raw=true'> 
</div>
  </details>

- Keybase [` App Store`](https://itunes.apple.com/app/keybase-crypto-for-everyone/id1044461770)  
  <details><summary><code>react native</code> 🔥🔥🔥🔥🔥</summary>

  https://github.com/keybase/client<br>  Added February  9, 2017<br>  License: [`bsd-3-clause`](http://choosealicense.com/licenses/bsd-3-clause/)
  </details>

- movieapp: Discover movies & tv shows  
  <details><summary><code>react native</code> <code>tmdb</code> 🔥🔥🔥🔥</summary>

  https://github.com/JuneDomingo/movieapp<br>  Added November 28, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='movieapp image 1' src='https://cloud.githubusercontent.com/assets/5106887/20606597/f176b3e2-b2ac-11e6-9163-c9e625df7748.png'> 
</div>
  </details>

- NBA allyoop: NBA game scores  
  <details><summary><code>react native</code> 🔥🔥🔥🔥</summary>

  https://github.com/wwayne/react-native-nba-app<br>  Added January  6, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='NBA allyoop image 1' src='https://cloud.githubusercontent.com/assets/5305874/12059257/dacf1ad0-af92-11e5-920c-ba4818d8dc1d.png'> 
</div>
  </details>

- NBAreact: NBA stats & standings  
  <details><summary><code>react native</code> </summary>

  https://github.com/jbkuczma/NBAreact<br>  Added July 14, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='NBAreact image 1' src='https://github.com/jbkuczma/NBAreact/raw/master/NBAreact_iOS.gif'> 
</div>
  </details>

- newswatch: News app based on YouTube playlists  
  <details><summary><code>react native</code> 🔥</summary>

  https://github.com/bradoyler/newswatch-react-native<br>  Added May 15, 2015<br>  License: `other`
  <div><img height='300' alt='newswatch image 1' src='https://cloud.githubusercontent.com/assets/425966/7039857/2f122810-dd95-11e4-99c4-db636d4c66a9.gif'> 
</div>
  </details>

- Nortal TechDay 2015  
  <details><summary><code>react native</code> 🔥🔥</summary>

  https://github.com/mikkoj/NortalTechDay<br>  Added May  3, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Nortal TechDay 2015 image 1' src='http://res.cloudinary.com/mikkoj/image/upload/v1467119333/nortal-techday-1.mov_triupn.gif'> <img height='300' alt='Nortal TechDay 2015 image 2' src='http://res.cloudinary.com/mikkoj/image/upload/v1467119489/nortal-techday-2.mov_lcvqqx.gif'> 
</div>
  </details>

- PokeDB: Clean and simple Pokédex app for Pokémon GO  
  <details><summary><code>react-native</code> 🔥</summary>

  https://github.com/satya164/PocketGear<br>  Added September 14, 2016<br>  License: `other`
  <div><img height='300' alt='PokeDB image 1' src='http://a1.mzstatic.com/us/r30/Purple71/v4/78/63/2e/78632e47-b8cf-5068-19be-e8e848581dbf/screen696x696.jpeg'> 
</div>
  </details>

- Pokemon Go clone  
  <details><summary><code>react-native</code> 🔥</summary>

  https://github.com/VctrySam/Pokemon<br>  Added August 14, 2016<br>  License: `other`
  <div><img height='300' alt='Pokemon Go clone image 1' src='https://i.imgur.com/PrMRwmY.png'> 
</div>
  </details>

- pokemon-map: Locate Pokemon around you  
  <details><summary><code>react native</code> </summary>

  https://github.com/bakery/pokemon-map<br>  Added September 14, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div>
</div>
  </details>

- pokevision: Display all the Pokémon around you  
  <details><summary><code>react native</code> <code>goradar</code> </summary>

  https://github.com/Morhaus/rn-pokevision<br>  Added September  9, 2016<br>  License: `other`
  <div><img height='300' alt='pokevision image 1' src='https://github.com/Morhaus/rn-pokevision/raw/master/screenshot.png'> 
</div>
  </details>

- Property Finder  
  <details><summary><code>react native</code> 🔥🔥</summary>

  https://github.com/ColinEberhardt/ReactNative-PropertyFinder<br>  Added April 10, 2015<br>  License: `other`
  <div><img height='300' alt='Property Finder image 1' src='https://koenig-media.raywenderlich.com/uploads/2015/03/PropertyFinder.png'> 
</div>
  </details>

- React Native Hacker News [` App Store`](https://itunes.apple.com/app/react-native-hacker-news/id1220272464)  
  <details><summary><code>react-native</code> </summary>

  https://github.com/G2Jose/ReactNative-HackerNews<br>  Added March 30, 2017<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='React Native Hacker News image 1' src='https://raw.githubusercontent.com/G2Jose/ReactNative-HackerNews/refactor/redux/screenshots/iOS/show.png'> 
</div>
  </details>

- RealmTasks: To Do app built with Realm, inspired by Clear for iOS  
  <details><summary><code>swift</code> <code>realm</code> <code>react native</code> <code>cartography</code> <code>swiftlint</code> 🔥🔥</summary>

  https://github.com/realm/realm-tasks<br>  Added February  2, 2017<br>  License: [`apache-2.0`](http://choosealicense.com/licenses/apache-2.0/)
  <div><img height='300' alt='RealmTasks image 1' src='https://cloud.githubusercontent.com/assets/429119/18797910/b01b7fd4-8202-11e6-8b70-afe224f3b9e0.png'> <img height='300' alt='RealmTasks image 2' src='https://i.imgur.com/Y9ZG7Of.png'> 
</div>
  </details>

- Reviewery: Rate songs in Spotify playlists  
  <details><summary><code>react-native</code> </summary>

  https://github.com/vadymmarkov/reviewery-mobile<br>  Added April 27, 2017<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Reviewery image 1' src='https://github.com/vadymmarkov/reviewery-mobile/raw/master/reviewery.gif'> 
</div>
  </details>

- RNTester: Showcases React Native views & modules  
  <details><summary><code>react native</code> </summary>

  https://github.com/facebook/react-native/tree/master/RNTester<br>  Added February  5, 2016<br>  License: `other`
  <div><img height='300' alt='RNTester image 1' src='https://i.imgur.com/DYqIgci.png'> 
</div>
  </details>

- RSS Reader  
  <details><summary><code>react native</code> 🔥</summary>

  https://github.com/christopherdro/react-native-rss-reader<br>  Added June 22, 2015<br>  License: `other`
  <div><img height='300' alt='RSS Reader image 1' src='https://github.com/christopherdro/react-native-rss-reader/raw/master/RssReaderDemo.gif'> 
</div>
  </details>

- Snapchat clone  
  <details><summary><code>react-native</code> 🔥🔥🔥</summary>

  https://github.com/VctrySam/SnapChat<br>  Added August 14, 2016<br>  License: `other`
  <div><img height='300' alt='Snapchat clone image 1' src='https://i.imgur.com/6HfPmrT.png'> 
</div>
  </details>

- Tinder clone  
  <details><summary><code>react-native</code> 🔥🔥</summary>

  https://github.com/VctrySam/Tinder<br>  Added August 14, 2016<br>  License: `other`
  <div><img height='300' alt='Tinder clone image 1' src='https://i.imgur.com/I7d06Pq.png'> 
</div>
  </details>

- To Do List  
  <details><summary><code>react native</code> 🔥</summary>

  https://github.com/joemaddalone/react-native-todo<br>  Added June 20, 2016<br>  License: `other`
  </details>

- To Do List (Redux): Uses Redux for managing app state  
  <details><summary><code>react native</code> </summary>

  https://github.com/uiheros/react-native-redux-todo-list<br>  Added June 20, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='To Do List (Redux) image 1' src='https://github.com/uiheros/react-native-redux-todo-list/raw/master/todolist.gif'> 
</div>
  </details>

- Twitch  
  <details><summary><code>react native</code> </summary>

  https://github.com/IFours/react-native-twitch<br>  Added February  4, 2016<br>  License: `other`
  <div><img height='300' alt='Twitch image 1' src='https://github.com/IFours/react-native-twitch/raw/rn0.15/assets/twitch.gif'> 
</div>
  </details>

- Twitter clone  
  <details><summary><code>react-native</code> 🔥</summary>

  https://github.com/VctrySam/Twitter<br>  Added August 14, 2016<br>  License: `other`
  <div><img height='300' alt='Twitter clone image 1' src='https://i.imgur.com/0kzQBEJ.png'> 
</div>
  </details>

- Weather by JakeLin  
  <details><summary><code>react native</code> </summary>

  https://github.com/JakeLin/ReactNativeWeather<br>  Added May  3, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Weather by JakeLin image 1' src='https://raw.githubusercontent.com/JakeLin/ReactNativeWeather/master/screenshots/screenshot-iOS.png'> 
</div>
  </details>

- Weather by jsphkhan  
  <details><summary><code>react native</code> </summary>

  https://github.com/jsphkhan/ReactNativeExamples<br>  https://github.com/jsphkhan/ReactNativeExamples/tree/master/ios/WeatherApp<br>  Added May  4, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Weather by jsphkhan image 1' src='https://camo.githubusercontent.com/d8d6748920497b1f6da276dbe7af715fa8df8a6a/687474703a2f2f6a7370686b68616e2e6769746875622e696f2f52656163744e6174697665576561746865724170702f6173736574732f73637265656e73686f74732f73637265656e312e706e67'> <img height='300' alt='Weather by jsphkhan image 2' src='https://camo.githubusercontent.com/dd8f80345ddd2a2f17663d07e3f38259a8f36982/687474703a2f2f6a7370686b68616e2e6769746875622e696f2f52656163744e6174697665576561746865724170702f6173736574732f73637265656e73686f74732f73637265656e322e706e67'> <img height='300' alt='Weather by jsphkhan image 3' src='https://camo.githubusercontent.com/da5efecec43f93228bb766d70ff7a33ad09d2d17/687474703a2f2f6a7370686b68616e2e6769746875622e696f2f52656163744e6174697665576561746865724170702f6173736574732f73637265656e73686f74732f73637265656e332e706e67'> 
</div>
  </details>

- Whatsapp clone  
  <details><summary><code>react-native</code> 🔥🔥🔥🔥</summary>

  https://github.com/VctrySam/whatsapp<br>  Added August 14, 2016<br>  License: `other`
  <div><img height='300' alt='Whatsapp clone image 1' src='https://i.imgur.com/T6Hwv3b.png'> 
</div>
  </details>

- WWDC Family React Native: Easily connect with fellow developers during WWDC  
  <details><summary><code>react-native</code> 🔥</summary>

  https://github.com/wwdc-family/app<br>  Added April  3, 2017<br>  License: `other`
  <div><img height='300' alt='WWDC Family React Native image 1' src='https://raw.githubusercontent.com/wwdc-family/app/master/design/Screenshot1.png'> 
</div>
  </details>


### Realm 
 
https://realm.io/ — [back to top](#readme) 
 
- Done: To-do list data sharing between extension & main app  
  <details><summary><code>swift</code> <code>realm</code> <code>watchkit</code> 🔥</summary>

  https://github.com/FancyPixel/done-swift<br>  Added May  1, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Done image 1' src='https://raw.githubusercontent.com/FancyPixel/done-swift/master/assets/screenshot.gif'> 
</div>
  </details>

- Facemotion: Find a contact by face recognition  
  <details><summary><code>opencv</code> 🔥</summary>

  https://github.com/remirobert/Facemotion<br>  Added July 27, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Facemotion image 1' src='https://cloud.githubusercontent.com/assets/3276768/16144253/4e96344e-34a4-11e6-9257-06f5bcdf06ef.gif'> 
</div>
  </details>

- how-much: Simple app to record how much things cost  
  <details><summary><code>parse</code> <code>firebase</code> <code>realm</code> </summary>

  https://github.com/dkhamsing/how-much<br>  Added October  6, 2015<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='how-much image 1' src='https://github.com/dkhamsing/how-much/raw/master/Assets/screens.png'> 
</div>
  </details>

- Obědář: Daily menu of restaurants near Czech Technical University  
  <details><summary><code>swift</code> <code>alamofire</code> <code>swiftyjson</code> </summary>

  https://github.com/syky27/LunchGuy<br>  Added June 16, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Obědář image 1' src='https://raw.githubusercontent.com/syky27/lunch_guy-ios/dev/screenshots/2.png'> <img height='300' alt='Obědář image 2' src='https://raw.githubusercontent.com/syky27/lunch_guy-ios/dev/screenshots/1.png'> 
</div>
  </details>

- Popular Movies: Cross-platform app for discovering recent & popular movies  
  <details><summary><code>swift</code> <code>realm</code> <code>alamofire</code> <code>tmdb</code> </summary>

  https://github.com/vanyaland/Popular-Movies<br>  Added January 19, 2017<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Popular Movies image 1' src='https://github.com/vanyaland/Popular-Movies/blob/master/res/iOS-movie-detail.png'> <img height='300' alt='Popular Movies image 2' src='https://github.com/vanyaland/Popular-Movies/blob/master/res/iOS-movies-list.png'> 
</div>
  </details>

- RaceMe: Run tracking & ghosting  
  <details><summary><code>swift</code> <code>parse</code> 🔥🔥🔥</summary>

  https://github.com/enochng1/RaceMe<br>  Added July 20, 2016<br>  License: `other`
  <div><img height='300' alt='RaceMe image 1' src='https://raw.githubusercontent.com/enochng1/RaceMe/master/raceMeGitImage.png'> 
</div>
  </details>

- RealmPop: Platform / multiplayer game where players pair up to clear a level of bubbles  
  <details><summary><code>swift</code> <code>realm</code> </summary>

  https://github.com/realm/RealmPop<br>  Added March  7, 2017<br>  License: `other`
  <div><img height='300' alt='RealmPop image 1' src='https://i.imgur.com/pTxoTPX.png'> <img height='300' alt='RealmPop image 2' src='https://i.imgur.com/Zrvfypq.png'> 
</div>
  </details>

- RealmTasks: To Do app built with Realm, inspired by Clear for iOS  
  <details><summary><code>swift</code> <code>realm</code> <code>react native</code> <code>cartography</code> <code>swiftlint</code> 🔥🔥</summary>

  https://github.com/realm/realm-tasks<br>  Added February  2, 2017<br>  License: [`apache-2.0`](http://choosealicense.com/licenses/apache-2.0/)
  <div><img height='300' alt='RealmTasks image 1' src='https://cloud.githubusercontent.com/assets/429119/18797910/b01b7fd4-8202-11e6-8b70-afe224f3b9e0.png'> <img height='300' alt='RealmTasks image 2' src='https://i.imgur.com/Y9ZG7Of.png'> 
</div>
  </details>

- RealmToDo: A small to-do list with Realm integration  
  <details><summary><code>swift</code> </summary>

  https://github.com/pietbrauer/RealmToDo<br>  Added July 31, 2015<br>  License: `other`
  </details>

- Riot: Collaboration for teams, chat & share with https://matrix.org/ [` App Store`](https://itunes.apple.com/us/app/vector-open-source-collaboration/id1083446067)  
  <details><summary><code>webrtc</code> <code>realm</code> 🔥🔥</summary>

  https://github.com/vector-im/riot-ios<br>  https://vector.im/<br>  Added July 21, 2016<br>  License: [`apache-2.0`](http://choosealicense.com/licenses/apache-2.0/)
  <div><img height='300' alt='Riot image 1' src='http://a2.mzstatic.com/us/r30/Purple18/v4/7a/22/48/7a224810-475c-cb4e-a165-02761701831d/screen696x696.jpeg'> 
</div>
  </details>

- Santa Tracker  
  <details><summary><code>swift</code> <code>realm</code> </summary>

  https://github.com/keitaito/RealmSantaTracker<br>  Added May 16, 2017<br>  License: `other`
  <div><img height='300' alt='Santa Tracker image 1' src='http://images.contentful.com/emmiduwd41v7/1TmcZsJy7Si4qCYm24aAse/158d511e7e58461d64cf902fb5a26d32/santa-app-final.png'> 
</div>
  </details>

- try! Swift NYC  
  <details><summary><code>swift</code> <code>toucan</code> <code>realm</code> 🔥</summary>

  https://github.com/tryswift/trySwiftNYC<br>  Added November  8, 2016<br>  License: `other`
  <div><img height='300' alt='try! Swift NYC image 1' src='https://i.imgur.com/xyu7t89.png'> <img height='300' alt='try! Swift NYC image 2' src='https://i.imgur.com/Jes7vLF.png'> 
</div>
  </details>

- try! Swift Tokyo  
  <details><summary><code>swift</code> <code>timepiece</code> <code>realm</code> <code>kingfisher</code> <code>acknowlist</code> 🔥</summary>

  https://github.com/tryswift/trySwiftAppFinal<br>  Added February 22, 2017<br>  License: `other`
  <div><img height='300' alt='try! Swift Tokyo image 1' src='https://cloud.githubusercontent.com/assets/4190298/23140345/534ae20c-f7b1-11e6-8584-b65aded1f59e.png'> <img height='300' alt='try! Swift Tokyo image 2' src='https://cloud.githubusercontent.com/assets/4190298/23140344/53463e82-f7b1-11e6-8d84-c0cedcc930b1.png'> 
</div>
  </details>


### VIPER 
 
https://mutualmobile.com/posts/meet-viper-fast-agile-non-lethal-ios-architecture-framework — [back to top](#readme) 
 
- American Chronicle: Search Chronicling America's collection of digitized U.S. newspapers [` App Store`](https://itunes.apple.com/app/id1092988367)  
  <details><summary><code>viper</code> </summary>

  https://github.com/ryanipete/AmericanChronicle<br>  http://ryanipete.com/AmericanChronicle/<br>  Added June 22, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='American Chronicle image 1' src='http://a5.mzstatic.com/us/r30/Purple60/v4/1e/82/3b/1e823b8a-d10c-2085-2063-1d18ba68ce2e/screen696x696.jpeg'> 
</div>
  </details>

- Articles: Fetch and display a list of articles  
  <details><summary><code>swift</code> <code>rest</code> 🔥</summary>

  https://github.com/pedrohperalta/Articles-iOS-VIPER<br>  https://cheesecakelabs.com/blog/ios-project-architecture-using-viper/<br>  Added November  3, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Articles image 1' src='https://i.imgur.com/fEPFBzr.png'> 
</div>
  </details>

- Contacts  
  <details><summary><code>objc</code> </summary>

  https://github.com/sebastianwr/VIPER-Persons<br>  Added February  8, 2016<br>  License: `other`
  </details>

- Counter  
  <details><summary><code>objc</code> 🔥🔥</summary>

  https://github.com/mutualmobile/Counter<br>  Added February  8, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Counter image 1' src='https://i.imgur.com/vgZbwrp.png'> 
</div>
  </details>

- Currency Converter: Live foreign exchange rates & currency calculator [` App Store`](https://itunes.apple.com/app/currency-converter-free-quick/id1163490933)  
  <details><summary><code>swift</code> <code>viper</code> 🔥</summary>

  https://github.com/tirupati17/currency-converter-swift3.0-viper<br>  Added October 24, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Currency Converter image 1' src='https://raw.githubusercontent.com/tirupati17/currency-converter-swift3.0-viper/master/CurrencyConverter/Resources/iphone_5s.png'> 
</div>
  </details>

- EMI Calculator: Calculate your Equated Monthly installment (EMI) for home, car & personal loans [` App Store`](https://itunes.apple.com/app/id1105890730)  
  <details><summary><code>swift</code> <code>viper</code> </summary>

  https://github.com/tirupati17/loan-emi-calculator-clean-swift<br>  Added July  3, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='EMI Calculator image 1' src='http://a2.mzstatic.com/us/r30/Purple20/v4/20/94/8a/20948a2b-3d8d-e65b-2831-a582d912ed13/screen696x696.jpeg'> <img height='300' alt='EMI Calculator image 2' src='http://a3.mzstatic.com/us/r30/Purple49/v4/aa/6a/2f/aa6a2f8a-d067-725a-e1f4-83caeaac8e75/screen696x696.jpeg'> <img height='300' alt='EMI Calculator image 3' src='http://a3.mzstatic.com/us/r30/Purple30/v4/e6/87/fb/e687fb83-cd3d-6b40-2d3b-94f6fd1e82a5/screen696x696.jpeg'> 
</div>
  </details>

- Exchanger: Exchange currencies from multiply wallets on ECB exchange rates  
  <details><summary><code>viper</code> <code>objc</code> <code>core-data</code> </summary>

  https://github.com/vkaltyrin/exchanger<br>  Added December 21, 2017<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Exchanger image 1' src='https://github.com/vkaltyrin/exchanger/blob/master/screenshot.png?raw=true'> 
</div>
  </details>

- Rambler&IT: Portfolio of mobile architectures used at Rambler&Co [` App Store`](https://itunes.apple.com/app/rambler-it/id1145829115)  
  <details><summary><code>magicalrecord</code> <code>typhoon</code> <code>afnetworking</code> <code>purelayout</code> <code>sdwebimage</code> 🇷🇺 🔥🔥</summary>

  https://github.com/rambler-digital-solutions/rambler-it-ios<br>  Added March  8, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Rambler&IT image 1' src='http://a1.mzstatic.com/us/r30/Purple71/v4/e9/c4/29/e9c429aa-8e88-7b40-f37f-036d1795fbda/screen696x696.jpeg'> <img height='300' alt='Rambler&IT image 2' src='http://a4.mzstatic.com/us/r30/Purple71/v4/03/47/78/034778fc-3dd4-ded5-3423-85a372409f67/screen696x696.jpeg'> <img height='300' alt='Rambler&IT image 3' src='http://a3.mzstatic.com/us/r30/Purple71/v4/64/66/d3/6466d349-2ccf-399c-1956-c98a619d0736/screen696x696.jpeg'> <img height='300' alt='Rambler&IT image 4' src='http://a2.mzstatic.com/us/r30/Purple71/v4/25/48/98/254898a9-7c27-a115-d792-fcfcd63ff6df/screen696x696.jpeg'> <img height='300' alt='Rambler&IT image 5' src='http://a5.mzstatic.com/us/r30/Purple71/v4/c8/8e/00/c88e00ee-da4d-6df7-900a-f08549ddb59c/screen696x696.jpeg'> 
</div>
  </details>

- Tip Calculator: Calculate tip & split the bill between any number of people [` App Store`](https://itunes.apple.com/app/id1139456857)  
  <details><summary><code>viper</code> </summary>

  https://github.com/tirupati17/tip-calculator-auto-layout-viper-objective-c<br>  Added August  8, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='Tip Calculator image 1' src='https://raw.githubusercontent.com/tirupati17/tip-calculator-auto-layout-viper-objective-c/master/TipCalculator/Resources/Images/iphone_5s.png'> 
</div>
  </details>

- To do  
  <details><summary><code>objc</code> 🔥🔥🔥</summary>

  https://github.com/objcio/issue-13-viper<br>  https://www.objc.io/issues/13-architecture/viper/<br>  Added February  8, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='To do image 1' src='https://i.imgur.com/UhJOVuw.png'> 
</div>
  </details>

- VIPER-SWIFT: Todo list  
  <details><summary><code>swift</code> 🔥🔥</summary>

  https://github.com/mutualmobile/VIPER-SWIFT<br>  Added November  2, 2016<br>  License: [`mit`](http://choosealicense.com/licenses/mit/)
  <div><img height='300' alt='VIPER-SWIFT image 1' src='https://i.imgur.com/BlZtGZR.png'> 
</div>
  </details>


### Xamarin 
 
https://www.xamarin.com/ — [back to top](#readme) 
 
- CodeHub: Browse & maintain GitHub repositories [` App Store`](https://itunes.apple.com/app/id707173885)  
  <details><summary><code>csharp</code> 🔥🔥🔥🔥🔥</summary>

  https://github.com/CodeHubApp/CodeHub<br>  http://codehub-app.com/<br>  Added June  1, 2016<br>  License: `other`
  <div><img height='300' alt='CodeHub image 1' src='http://a1.mzstatic.com/us/r30/Purple49/v4/34/47/f7/3447f73d-7c25-0ace-719c-d8a286521ed7/screen696x696.jpeg'> <img height='300' alt='CodeHub image 2' src='http://a4.mzstatic.com/us/r30/Purple69/v4/4c/e1/5b/4ce15b73-3010-47c4-2c94-569b1898aebb/screen696x696.jpeg'> <img height='300' alt='CodeHub image 3' src='http://a1.mzstatic.com/us/r30/Purple49/v4/28/8b/0d/288b0d9b-d596-4128-de57-d51310d63cff/screen696x696.jpeg'> <img height='300' alt='CodeHub image 4' src='http://a4.mzstatic.com/us/r30/Purple49/v4/e7/eb/f0/e7ebf020-0ad7-f61a-e702-e6507e8c1925/screen696x696.jpeg'> <img height='300' alt='CodeHub image 5' src='http://a4.mzstatic.com/us/r30/Purple49/v4/fc/94/aa/fc94aaa7-bddf-5c48-9727-09ee45595194/screen696x696.jpeg'> 
</div>
  </details>

- PropertyCross: Search UK property listings  
  <details><summary><code>csharp</code> 🔥🔥🔥</summary>

  https://github.com/tastejs/PropertyCross/tree/master/xamarin<br>  Added December  5, 2016<br>  License: `other`
  <div><img height='300' alt='PropertyCross image 1' src='http://propertycross.com/frameworks/xamarin/ios/PropertyCross.thumbnail.png'> <img height='300' alt='PropertyCross image 2' src='http://propertycross.com/frameworks/xamarin/ios/SearchResults.thumbnail.png'> 
</div>
  </details>

- Toggl Timer: Timesheet tracker  
  <details><summary><code>csharp</code> </summary>

  https://github.com/toggl/mobileapp<br>  Added May  8, 2017<br>  License: [`bsd-3-clause`](http://choosealicense.com/licenses/bsd-3-clause/)
  </details>


## Bonus 
 
[back to top](#readme) 
 
- awesome-arkit  
  <details><summary><code>list</code> 🔥🔥🔥🔥🔥</summary>

  https://github.com/olucurious/awesome-arkit<br>  Added August 17, 2017<br>  License: `other`
  </details>

- awesome-macOS  
  <details><summary><code>list</code> 🔥🔥🔥🔥🔥</summary>

  https://github.com/iCHAIT/awesome-macOS<br>  License: `other`
  </details>

- open-source-android-apps  
  <details><summary><code>list</code> 🔥🔥🔥🔥🔥</summary>

  https://github.com/pcqpcq/open-source-android-apps<br>  License: `other`
  </details>

- open-source-ios-apps app store: Only listing projects that are on the App Store  
  <details><summary><code>list</code> </summary>

  https://github.com/dkhamsing/open-source-ios-apps/blob/master/APPSTORE.md<br>  Added June 14, 2017<br>  License: `other`
  </details>

- open-source-ios-apps archive: Projects that are no longer maintained  
  <details><summary><code>list</code> </summary>

  https://github.com/dkhamsing/open-source-ios-apps/blob/master/ARCHIVE.md<br>  License: `other`
  </details>


## Thanks

This list was inspired by [awesome-ios](https://github.com/vsouza/awesome-ios) and [awesome-swift](https://github.com/matteocrippa/awesome-swift). Thanks to all the [contributors](https://github.com/dkhamsing/open-source-ios-apps/graphs/contributors) 🎉 

## Contact

- [github.com/dkhamsing](https://github.com/dkhamsing)
- [twitter.com/dkhamsing](https://twitter.com/dkhamsing)
- [github.com/vpeschenkov](https://github.com/vpeschenkov)
