package haxe.io;

/**
	HTML MimeType Enum
	@see http://www.sitepoint.com/web-foundations/mime-types-complete-list/
**/
enum abstract Mime(String) from String to String {
	var XWorldX3dmf = 'x-world/x-3dmf';
	var ApplicationOctetStream = 'application/octet-stream';
	var ApplicationXAuthorwareBin = 'application/x-authorware-bin';
	var ApplicationXAuthorwareMap = 'application/x-authorware-map';
	var ApplicationXAuthorwareSeg = 'application/x-authorware-seg';
	var TextVndAbc = 'text/vnd.abc';
	var TextHtml = 'text/html';
	var VideoAnimaflex = 'video/animaflex';
	var ApplicationPostscript = 'application/postscript';
	var AudioAiff = 'audio/aiff';
	var AudioXAiff = 'audio/x-aiff';
	var ApplicationXAim = 'application/x-aim';
	var TextXAudiosoftIntra = 'text/x-audiosoft-intra';
	var ApplicationXNaviAnimation = 'application/x-navi-animation';
	var ApplicationXNokia9000CommunicatorAddOnSoftware = 'application/x-nokia-9000-communicator-add-on-software';
	var ApplicationMime = 'application/mime';
	var ApplicationArj = 'application/arj';
	var ImageXJg = 'image/x-jg';
	var VideoXMsAsf = 'video/x-ms-asf';
	var TextXAsm = 'text/x-asm';
	var TextAsp = 'text/asp';
	var ApplicationXMplayer2 = 'application/x-mplayer2';
	var AudioBasic = 'audio/basic';
	var ApplicationXTroffMsvideo = 'application/x-troff-msvideo';
	var VideoAvi = 'video/avi';
	var VideoMsvideo = 'video/msvideo';
	var VideoXMsvideo = 'video/x-msvideo';
	var VideoAvsVideo = 'video/avs-video';
	var ApplicationXBcpio = 'application/x-bcpio';
	var ApplicationMacBinary = 'application/mac-binary';
	var ApplicationMacbinary = 'application/macbinary';
	var ApplicationXBinary = 'application/x-binary';
	var ApplicationXMacbinary = 'application/x-macbinary';
	var ImageBmp = 'image/bmp';
	var ImageXWindowsBmp = 'image/x-windows-bmp';
	var ApplicationBook = 'application/book';
	var ApplicationXBzip2 = 'application/x-bzip2';
	var ApplicationXBsh = 'application/x-bsh';
	var ApplicationXBzip = 'application/x-bzip';
	var TextPlain = 'text/plain';
	var TextXC = 'text/x-c';
	var ApplicationVndMsPkiSeccat = 'application/vnd.ms-pki.seccat';
	var ApplicationClariscad = 'application/clariscad';
	var ApplicationXCocoa = 'application/x-cocoa';
	var ApplicationCdf = 'application/cdf';
	var ApplicationXCdf = 'application/x-cdf';
	var ApplicationXNetcdf = 'application/x-netcdf';
	var ApplicationPkixCert = 'application/pkix-cert';
	var ApplicationXX509CaCert = 'application/x-x509-ca-cert';
	var ApplicationXChat = 'application/x-chat';
	var ApplicationJava = 'application/java';
	var ApplicationJavaByteCode = 'application/java-byte-code';
	var ApplicationXJavaClass = 'application/x-java-class';
	var ApplicationXCpio = 'application/x-cpio';
	var ApplicationMacCompactpro = 'application/mac-compactpro';
	var ApplicationPkcsCrl = 'application/pkcs-crl';
	var ApplicationXCsh = 'application/x-csh';
	var TextCss = 'text/css';
	var ApplicationXDirector = 'application/x-director';
	var ApplicationXDeepv = 'application/x-deepv';
	var VideoXDv = 'video/x-dv';
	var VideoDl = 'video/dl';
	var ApplicationMsword = 'application/msword';
	var ApplicationCommonground = 'application/commonground';
	var ApplicationDrafting = 'application/drafting';
	var ApplicationXDvi = 'application/x-dvi';
	var DrawingXDwf = 'drawing/x-dwf (old)';
	var ApplicationAcad = 'application/acad';
	var ApplicationDxf = 'application/dxf';
	var TextXScriptElisp = 'text/x-script.elisp';
	var ApplicationXBytecodeElisp = 'application/x-bytecode.elisp (compiled elisp)';
	var ApplicationXEnvoy = 'application/x-envoy';
	var ApplicationXEsrehber = 'application/x-esrehber';
	var TextXSetext = 'text/x-setext';
	var ApplicationEnvoy = 'application/envoy';
	var TextXFortran = 'text/x-fortran';
	var ApplicationVndFdf = 'application/vnd.fdf';
	var ImageFif = 'image/fif';
	var VideoFli = 'video/fli';
	var ImageFlorian = 'image/florian';
	var TextVndFmiFlexstor = 'text/vnd.fmi.flexstor';
	var VideoXAtomic3dFeature = 'video/x-atomic3d-feature';
	var ImageVndFpx = 'image/vnd.fpx';
	var ApplicationFreeloader = 'application/freeloader';
	var AudioMake = 'audio/make';
	var ImageG3fax = 'image/g3fax';
	var ImageGif = 'image/gif';
	var VideoGl = 'video/gl';
	var AudioXGsm = 'audio/x-gsm';
	var ApplicationXGsp = 'application/x-gsp';
	var ApplicationXGss = 'application/x-gss';
	var ApplicationXGtar = 'application/x-gtar';
	var ApplicationXCompressed = 'application/x-compressed';
	var ApplicationXGzip = 'application/x-gzip';
	var ApplicationXHdf = 'application/x-hdf';
	var ApplicationXHelpfile = 'application/x-helpfile';
	var TextXScript = 'text/x-script';
	var ApplicationHlp = 'application/hlp';
	var ApplicationVndHpHpgl = 'application/vnd.hp-hpgl';
	var ApplicationBinhex = 'application/binhex';
	var ApplicationHta = 'application/hta';
	var TextXComponent = 'text/x-component';
	var TextWebviewhtml = 'text/webviewhtml';
	var XConferenceXCooltalk = 'x-conference/x-cooltalk';
	var ImageXIcon = 'image/x-icon';
	var ImageIef = 'image/ief';
	var ApplicationIges = 'application/iges';
	var ApplicationXIma = 'application/x-ima';
	var ApplicationXHttpdImap = 'application/x-httpd-imap';
	var ApplicationInf = 'application/inf';
	var ApplicationXInternettSignup = 'application/x-internett-signup';
	var ApplicationXIp2 = 'application/x-ip2';
	var VideoXIsvideo = 'video/x-isvideo';
	var AudioIt = 'audio/it';
	var ApplicationXInventor = 'application/x-inventor';
	var IWorldIVrml = 'i-world/i-vrml';
	var ApplicationXLivescreen = 'application/x-livescreen';
	var AudioXJam = 'audio/x-jam';
	var ApplicationXJavaCommerce = 'application/x-java-commerce';
	var ImageJpeg = 'image/jpeg';
	var ImageXJps = 'image/x-jps';
	var TextJavascript = 'text/javascript';
	var ApplicationJson = 'application/json';
	var ApplicationJavascript = 'application/javascript';
	var ImageJutvision = 'image/jutvision';
	var AudioMidi = 'audio/midi';
	var ApplicationXKsh = 'application/x-ksh';
	var AudioNspaudio = 'audio/nspaudio';
	var AudioXLiveaudio = 'audio/x-liveaudio';
	var ApplicationXLatex = 'application/x-latex';
	var ApplicationXLisp = 'application/x-lisp';
	var TextXLaAsf = 'text/x-la-asf';
	var ApplicationLzx = 'application/lzx';
	var VideoMpeg = 'video/mpeg';
	var AudioMpeg = 'audio/mpeg';
	var AudioXMpequrl = 'audio/x-mpequrl';
	var ApplicationXTroffMan = 'application/x-troff-man';
	var ApplicationXNavimap = 'application/x-navimap';
	var ApplicationMbedlet = 'application/mbedlet';
	var ApplicationXMagicCapPackage10 = 'application/x-magic-cap-package-1.0';
	var ApplicationMcad = 'application/mcad';
	var ImageVasa = 'image/vasa';
	var ApplicationNetmc = 'application/netmc';
	var ApplicationXTroffMe = 'application/x-troff-me';
	var MessageRfc822 = 'message/rfc822';
	var ApplicationXMif = 'application/x-mif';
	var WwwMime = 'www/mime';
	var AudioXVndAudioexplosionMjuicemediafile = 'audio/x-vnd.audioexplosion.mjuicemediafile';
	var VideoXMotionJpeg = 'video/x-motion-jpeg';
	var ApplicationBase64 = 'application/base64';
	var AudioMod = 'audio/mod';
	var VideoQuicktime = 'video/quicktime';
	var VideoXSgiMovie = 'video/x-sgi-movie';
	var AudioMpeg3 = 'audio/mpeg3';
	var ApplicationXProject = 'application/x-project';
	var ApplicationVndMsProject = 'application/vnd.ms-project';
	var ApplicationMarc = 'application/marc';
	var ApplicationXTroffMs = 'application/x-troff-ms';
	var ApplicationXVndAudioexplosionMzz = 'application/x-vnd.audioexplosion.mzz';
	var ImageNaplps = 'image/naplps';
	var ApplicationVndNokiaConfigurationMessage = 'application/vnd.nokia.configuration-message';
	var ImageXNiff = 'image/x-niff';
	var ApplicationXMixTransfer = 'application/x-mix-transfer';
	var ApplicationXConference = 'application/x-conference';
	var ApplicationXNavidoc = 'application/x-navidoc';
	var ApplicationOda = 'application/oda';
	var ApplicationXOmc = 'application/x-omc';
	var ApplicationXOmcdatamaker = 'application/x-omcdatamaker';
	var ApplicationXOmcregerator = 'application/x-omcregerator';
	var TextXPascal = 'text/x-pascal';
	var ApplicationPkcs10 = 'application/pkcs10';
	var ApplicationPkcs12 = 'application/pkcs-12';
	var ApplicationXPkcs7Signature = 'application/x-pkcs7-signature';
	var ApplicationPkcs7Mime = 'application/pkcs7-mime';
	var ApplicationXPkcs7Certreqresp = 'application/x-pkcs7-certreqresp';
	var ApplicationPkcs7Signature = 'application/pkcs7-signature';
	var ApplicationPro_eng = 'application/pro_eng';
	var TextPascal = 'text/pascal';
	var ImageXPortableBitmap = 'image/x-portable-bitmap';
	var ApplicationVndHpPcl = 'application/vnd.hp-pcl';
	var ImageXPict = 'image/x-pict';
	var ImageXPcx = 'image/x-pcx';
	var ChemicalXPdb = 'chemical/x-pdb';
	var ApplicationPdf = 'application/pdf';
	var ImageXPortableGraymap = 'image/x-portable-graymap';
	var ImagePict = 'image/pict';
	var ApplicationXNewtonCompatiblePkg = 'application/x-newton-compatible-pkg';
	var ApplicationVndMsPkiPko = 'application/vnd.ms-pki.pko';
	var ApplicationXPixclscript = 'application/x-pixclscript';
	var ImageXXpixmap = 'image/x-xpixmap';
	var ApplicationXPagemaker = 'application/x-pagemaker';
	var ImagePng = 'image/png';
	var ApplicationXPortableAnymap = 'application/x-portable-anymap';
	var ApplicationMspowerpoint = 'application/mspowerpoint';
	var ModelXPov = 'model/x-pov';
	var ApplicationVndMsPowerpoint = 'application/vnd.ms-powerpoint';
	var ImageXPortablePixmap = 'image/x-portable-pixmap';
	var ApplicationXFreelance = 'application/x-freelance';
	var PaleovuXPv = 'paleovu/x-pv';
	var TextXScriptPhyton = 'text/x-script.phyton';
	var ApplicationXBytecodePython = 'application/x-bytecode.python';
	var AudioVndQcelp = 'audio/vnd.qcelp';
	var ImageXQuicktime = 'image/x-quicktime';
	var VideoXQtc = 'video/x-qtc';
	var AudioXPnRealaudio = 'audio/x-pn-realaudio';
	var ApplicationXCmuRaster = 'application/x-cmu-raster';
	var ImageCmuRaster = 'image/cmu-raster';
	var TextXScriptRexx = 'text/x-script.rexx';
	var ImageVndRnRealflash = 'image/vnd.rn-realflash';
	var ImageXRgb = 'image/x-rgb';
	var ApplicationVndRnRealmedia = 'application/vnd.rn-realmedia';
	var AudioMid = 'audio/mid';
	var ApplicationRingingTones = 'application/ringing-tones';
	var ApplicationVndRnRealplayer = 'application/vnd.rn-realplayer';
	var ApplicationXTroff = 'application/x-troff';
	var ImageVndRnRealpix = 'image/vnd.rn-realpix';
	var AudioXPnRealaudioPlugin = 'audio/x-pn-realaudio-plugin';
	var TextRichtext = 'text/richtext';
	var ApplicationRtf = 'application/rtf';
	var VideoVndRnRealvideo = 'video/vnd.rn-realvideo';
	var AudioS3m = 'audio/s3m';
	var ApplicationXTbook = 'application/x-tbook';
	var ApplicationXLotusscreencam = 'application/x-lotusscreencam';
	var ApplicationSdp = 'application/sdp';
	var ApplicationSounder = 'application/sounder';
	var ApplicationSea = 'application/sea';
	var ApplicationSet = 'application/set';
	var AudioXPsid = 'audio/x-psid';
	var ApplicationXSit = 'application/x-sit';
	var ApplicationXKoan = 'application/x-koan';
	var ApplicationXSeelogo = 'application/x-seelogo';
	var ApplicationSmil = 'application/smil';
	var ApplicationSolids = 'application/solids';
	var ApplicationXPkcs7Certificates = 'application/x-pkcs7-certificates';
	var ApplicationFuturesplash = 'application/futuresplash';
	var ApplicationXSprite = 'application/x-sprite';
	var ApplicationXWaisSource = 'application/x-wais-source';
	var TextXServerParsedHtml = 'text/x-server-parsed-html';
	var ApplicationStreamingmedia = 'application/streamingmedia';
	var ApplicationVndMsPkiCertstore = 'application/vnd.ms-pki.certstore';
	var ApplicationStep = 'application/step';
	var ApplicationSla = 'application/sla';
	var ApplicationXSv4cpio = 'application/x-sv4cpio';
	var ApplicationXSv4crc = 'application/x-sv4crc';
	var ImageVndDwg = 'image/vnd.dwg';
	var ApplicationXWorld = 'application/x-world';
	var ApplicationXShockwaveFlash = 'application/x-shockwave-flash';
	var TextXSpeech = 'text/x-speech';
	var ApplicationXTar = 'application/x-tar';
	var ApplicationToolbook = 'application/toolbook';
	var ApplicationXTcl = 'application/x-tcl';
	var TextXScriptTcsh = 'text/x-script.tcsh';
	var ApplicationXTex = 'application/x-tex';
	var ApplicationXTexinfo = 'application/x-texinfo';
	var ApplicationGnutar = 'application/gnutar';
	var ImageTiff = 'image/tiff';
	var AudioTspAudio = 'audio/tsp-audio';
	var ApplicationDsptype = 'application/dsptype';
	var TextTabSeparatedValues = 'text/tab-separated-values';
	var TextXUil = 'text/x-uil';
	var TextUriList = 'text/uri-list';
	var ApplicationIDeas = 'application/i-deas';
	var ApplicationXUstar = 'application/x-ustar';
	var TextXUuencode = 'text/x-uuencode';
	var ApplicationXCdlink = 'application/x-cdlink';
	var TextXVcalendar = 'text/x-vcalendar';
	var ApplicationVda = 'application/vda';
	var VideoVdo = 'video/vdo';
	var ApplicationGroupwise = 'application/groupwise';
	var VideoVivo = 'video/vivo';
	var ApplicationVocaltecMediaDesc = 'application/vocaltec-media-desc';
	var ApplicationVocaltecMediaFile = 'application/vocaltec-media-file';
	var AudioVoc = 'audio/voc';
	var VideoVosaic = 'video/vosaic';
	var AudioVoxware = 'audio/voxware';
	var AudioXTwinvqPlugin = 'audio/x-twinvq-plugin';
	var AudioXTwinvq = 'audio/x-twinvq';
	var ApplicationXVrml = 'application/x-vrml';
	var XWorldXVrt = 'x-world/x-vrt';
	var ApplicationXVisio = 'application/x-visio';
	var ApplicationWordperfect60 = 'application/wordperfect6.0';
	var ApplicationWordperfect61 = 'application/wordperfect6.1';
	var AudioWav = 'audio/wav';
	var ApplicationXQpro = 'application/x-qpro';
	var ImageVndWapWbmp = 'image/vnd.wap.wbmp';
	var ApplicationVndXara = 'application/vnd.xara';
	var ImageWebp = 'image/webp';
	var ApplicationX123 = 'application/x-123';
	var WindowsMetafile = 'windows/metafile';
	var TextVndWapWml = 'text/vnd.wap.wml';
	var ApplicationVndWapWmlc = 'application/vnd.wap.wmlc';
	var TextVndWapWmlscript = 'text/vnd.wap.wmlscript';
	var ApplicationVndWapWmlscriptc = 'application/vnd.wap.wmlscriptc';
	var ApplicationWordperfect = 'application/wordperfect';
	var ApplicationXLotus = 'application/x-lotus';
	var ApplicationMswrite = 'application/mswrite';
	var ModelVrml = 'model/vrml';
	var TextScriplet = 'text/scriplet';
	var ApplicationXWintalk = 'application/x-wintalk';
	var ImageXXbitmap = 'image/x-xbitmap';
	var VideoXAmtDemorun = 'video/x-amt-demorun';
	var XglDrawing = 'xgl/drawing';
	var ImageVndXiff = 'image/vnd.xiff';
	var ApplicationExcel = 'application/excel';
	var AudioXm = 'audio/xm';
	var ApplicationXml = 'application/xml';
	var XglMovie = 'xgl/movie';
	var ApplicationXVndLsXpix = 'application/x-vnd.ls-xpix';
	var VideoXAmtShowrun = 'video/x-amt-showrun';
	var ImageXXwd = 'image/x-xwd';
	var ApplicationXCompress = 'application/x-compress';
	var MultipartXZip = 'multipart/x-zip';
	var TextXScriptZsh = 'text/x-script.zsh';
}
