/* Copyright 2017 R. Thomas
 * Copyright 2017 Quarkslab
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#include <map>

#include "LIEF/PE/signature/OIDToString.hpp"

namespace LIEF {
namespace PE {
const char* oid_to_string(const oid_t& oid) {
  const std::map<oid_t, const char*> oid_to_str  {
    { "0.2.262.1.10",                     "TELESEC" },
    { "0.2.262.1.10.0",                   "EXTENSION" },
    { "0.2.262.1.10.1",                   "MECHANISM" },
    { "0.2.262.1.10.1.0",                 "AUTHENTICATION" },
    { "0.2.262.1.10.1.0.1",               "PASSWORD_AUTHENTICATION" },
    { "0.2.262.1.10.1.0.2",               "PROTECTED_PASSWORD_AUTHENTICATION" },
    { "0.2.262.1.10.1.0.3",               "ONE_WAY_X509_AUTHENTICATION" },
    { "0.2.262.1.10.1.0.4",               "TWO_WAY_X509_AUTHENTICATION" },
    { "0.2.262.1.10.1.0.5",               "THREE_WAY_X509_AUTHENTICATION" },
    { "0.2.262.1.10.1.0.6",               "ONE_WAY_ISO9798_AUTHENTICATION" },
    { "0.2.262.1.10.1.0.7",               "TWO_WAY_ISO9798_AUTHENTICATION" },
    { "0.2.262.1.10.1.0.8",               "TELEKOM_AUTHENTICATION" },
    { "0.2.262.1.10.1.1",                 "SIGNATURE" },
    { "0.2.262.1.10.1.1.1",               "MD4_WITH_RSA_AND_ISO9697" },
    { "0.2.262.1.10.1.1.2",               "MD4_WITH_RSA_AND_TELESEC_SIGNATURE_STANDARD" },
    { "0.2.262.1.10.1.1.3",               "MD5_WITH_RSA_AND_ISO9697" },
    { "0.2.262.1.10.1.1.4",               "MD5_WITH_RSA_AND_TELESEC_SIGNATURE_STANDARD" },
    { "0.2.262.1.10.1.1.5",               "RIPEMD160_WITH_RSA_AND_TELEKOM_SIGNATURE_STANDARD" },
    { "0.2.262.1.10.1.1.9",               "HBCI_RSA_SIGNATURE" },
    { "0.2.262.1.10.1.2",                 "ENCRYPTION" },
    { "0.2.262.1.10.1.2.0",               "NONE" },
    { "0.2.262.1.10.1.2.1",               "RSA_TELESEC" },
    { "0.2.262.1.10.1.2.2",               "DES" },
    { "0.2.262.1.10.1.2.2.1",             "DES_ECB" },
    { "0.2.262.1.10.1.2.2.2",             "DES_CBC" },
    { "0.2.262.1.10.1.2.2.3",             "DES_OFB" },
    { "0.2.262.1.10.1.2.2.4",             "DES_CFB8" },
    { "0.2.262.1.10.1.2.2.5",             "DES_CFB64" },
    { "0.2.262.1.10.1.2.3",               "DES3" },
    { "0.2.262.1.10.1.2.3.1",             "DES3_ECB" },
    { "0.2.262.1.10.1.2.3.2",             "DES3_CBC" },
    { "0.2.262.1.10.1.2.3.3",             "DES3_OFB" },
    { "0.2.262.1.10.1.2.3.4",             "DES3_CFB8" },
    { "0.2.262.1.10.1.2.3.5",             "DES3_CFB64" },
    { "0.2.262.1.10.1.2.4",               "MAGENTA" },
    { "0.2.262.1.10.1.2.5",               "IDEA" },
    { "0.2.262.1.10.1.2.5.1",             "IDEA_ECB" },
    { "0.2.262.1.10.1.2.5.2",             "IDEA_CBC" },
    { "0.2.262.1.10.1.2.5.3",             "IDEA_OFB" },
    { "0.2.262.1.10.1.2.5.4",             "IDEA_CFB8" },
    { "0.2.262.1.10.1.2.5.5",             "IDEA_CFB64" },
    { "0.2.262.1.10.1.3",                 "ONE_WAY_FUNCTION" },
    { "0.2.262.1.10.1.3.1",               "MD4" },
    { "0.2.262.1.10.1.3.2",               "MD5" },
    { "0.2.262.1.10.1.3.3",               "SQ_MOD_NX509" },
    { "0.2.262.1.10.1.3.4",               "SQ_MOD_NISO" },
    { "0.2.262.1.10.1.3.5",               "RIPEMD128" },
    { "0.2.262.1.10.1.3.6",               "HASH_USING_BLOCK_CIPHER" },
    { "0.2.262.1.10.1.3.7",               "MAC" },
    { "0.2.262.1.10.1.3.8",               "RIPEMD160" },
    { "0.2.262.1.10.1.4",                 "FEC_FUNCTION" },
    { "0.2.262.1.10.1.4.1",               "REED_SOLOMON" },
    { "0.2.262.1.10.2",                   "MODULE" },
    { "0.2.262.1.10.2.0",                 "ALGORITHMS" },
    { "0.2.262.1.10.2.1",                 "ATTRIBUTE_TYPES" },
    { "0.2.262.1.10.2.2",                 "CERTIFICATE_TYPES" },
    { "0.2.262.1.10.2.3",                 "MESSAGE_TYPES" },
    { "0.2.262.1.10.2.4",                 "PL_PROTOCOL" },
    { "0.2.262.1.10.2.5",                 "SME_AND_COMPONENTS_OF_SME" },
    { "0.2.262.1.10.2.6",                 "FEC" },
    { "0.2.262.1.10.2.7",                 "USEFUL_DEFINITIONS" },
    { "0.2.262.1.10.2.8",                 "STEFILES" },
    { "0.2.262.1.10.2.9",                 "SADMIB" },
    { "0.2.262.1.10.2.10",                "ELECTRONIC_ORDER" },
    { "0.2.262.1.10.2.11",                "TELESEC_TTP_ASYMMETRIC_APPLICATION" },
    { "0.2.262.1.10.2.12",                "TELESEC_TTP_BASIS_APPLICATION" },
    { "0.2.262.1.10.2.13",                "TELESEC_TTP_MESSAGES" },
    { "0.2.262.1.10.2.14",                "TELESEC_TTP_TIME_STAMP_APPLICATION" },
    { "0.2.262.1.10.3",                   "OBJECT_CLASS" },
    { "0.2.262.1.10.3.0",                 "TELESEC_OTHER_NAME" },
    { "0.2.262.1.10.3.1",                 "DIRECTORY" },
    { "0.2.262.1.10.3.2",                 "DIRECTORY_TYPE" },
    { "0.2.262.1.10.3.3",                 "DIRECTORY_GROUP" },
    { "0.2.262.1.10.3.4",                 "DIRECTORY_USER" },
    { "0.2.262.1.10.3.5",                 "SYMMETRIC_KEY_ENTRY" },
    { "0.2.262.1.10.4",                   "PACKAGE" },
    { "0.2.262.1.10.5",                   "PARAMETER" },
    { "0.2.262.1.10.6",                   "NAME_BINDING" },
    { "0.2.262.1.10.7",                   "ATTRIBUTE" },
    { "0.2.262.1.10.7.0",                 "APPLICATION_GROUP_IDENTIFIER" },
    { "0.2.262.1.10.7.1",                 "CERTIFICATE_TYPE" },
    { "0.2.262.1.10.7.2",                 "TELESEC_CERTIFICATE" },
    { "0.2.262.1.10.7.3",                 "CERTIFICATE_NUMBER" },
    { "0.2.262.1.10.7.4",                 "CERTIFICATE_REVOCATION_LIST" },
    { "0.2.262.1.10.7.5",                 "CREATION_DATE" },
    { "0.2.262.1.10.7.6",                 "ISSUER" },
    { "0.2.262.1.10.7.7",                 "NAMING_AUTHORITY" },
    { "0.2.262.1.10.7.8",                 "PUBLIC_KEY_DIRECTORY" },
    { "0.2.262.1.10.7.9",                 "SECURITY_DOMAIN" },
    { "0.2.262.1.10.7.10",                "SUBJECT" },
    { "0.2.262.1.10.7.11",                "TIME_OF_REVOCATION" },
    { "0.2.262.1.10.7.12",                "USER_GROUP_REFERENCE" },
    { "0.2.262.1.10.7.13",                "VALIDITY" },
    { "0.2.262.1.10.7.14",                "ZERT93" },
    { "0.2.262.1.10.7.15",                "SECURITY_MESS_ENV" },
    { "0.2.262.1.10.7.16",                "ANONYMIZED_PUBLIC_KEY_DIRECTORY" },
    { "0.2.262.1.10.7.17",                "TELESEC_GIVEN_NAME" },
    { "0.2.262.1.10.7.18",                "NAME_ADDITIONS" },
    { "0.2.262.1.10.7.19",                "TELESEC_POSTAL_CODE" },
    { "0.2.262.1.10.7.20",                "NAME_DISTINGUISHER" },
    { "0.2.262.1.10.7.21",                "TELESEC_CERTIFICATE_LIST" },
    { "0.2.262.1.10.7.22",                "TELETRUST_CERTIFICATE_LIST" },
    { "0.2.262.1.10.7.23",                "X509_CERTIFICATE_LIST" },
    { "0.2.262.1.10.7.24",                "TIME_OF_ISSUE" },
    { "0.2.262.1.10.7.25",                "PHYSICAL_CARD_NUMBER" },
    { "0.2.262.1.10.7.26",                "FILE_TYPE" },
    { "0.2.262.1.10.7.27",                "CTL_FILE_IS_ARCHIVE" },
    { "0.2.262.1.10.7.28",                "EMAIL_ADDRESS" },
    { "0.2.262.1.10.7.29",                "CERTIFICATE_TEMPLATE_LIST" },
    { "0.2.262.1.10.7.30",                "DIRECTORY_NAME" },
    { "0.2.262.1.10.7.31",                "DIRECTORY_TYPE_NAME" },
    { "0.2.262.1.10.7.32",                "DIRECTORY_GROUP_NAME" },
    { "0.2.262.1.10.7.33",                "DIRECTORY_USER_NAME" },
    { "0.2.262.1.10.7.34",                "REVOCATION_FLAG" },
    { "0.2.262.1.10.7.35",                "SYMMETRIC_KEY_ENTRY_NAME" },
    { "0.2.262.1.10.7.36",                "GL_NUMBER" },
    { "0.2.262.1.10.7.37",                "GO_NUMBER" },
    { "0.2.262.1.10.7.38",                "G_KEY_DATA" },
    { "0.2.262.1.10.7.39",                "Z_KEY_DATA" },
    { "0.2.262.1.10.7.40",                "KT_KEY_DATA" },
    { "0.2.262.1.10.7.41",                "KT_KEY_NUMBER" },
    { "0.2.262.1.10.7.51",                "TIME_OF_REVOCATION_GEN" },
    { "0.2.262.1.10.7.52",                "LIABILITY_TEXT" },
    { "0.2.262.1.10.8",                   "ATTRIBUTE_GROUP" },
    { "0.2.262.1.10.9",                   "ACTION" },
    { "0.2.262.1.10.10",                  "NOTIFICATION" },
    { "0.2.262.1.10.11",                  "SNMP_MIBS" },
    { "0.2.262.1.10.11.1",                "SECURITY_APPLICATION" },
    { "0.2.262.1.10.12",                  "CERT_AND_CRL_EXTENSION_DEFINITIONS" },
    { "0.2.262.1.10.12.0",                "LIABILITY_LIMITATION_FLAG" },
    { "0.2.262.1.10.12.1",                "TELESEC_CERT_ID_EXT" },
    { "0.2.262.1.10.12.2",                "TELESEC_POLICY_IDENTIFIER" },
    { "0.2.262.1.10.12.3",                "TELESEC_POLICY_QUALIFIER_ID" },
    { "0.2.262.1.10.12.4",                "TELESEC_CRL_FILTERED_EXT" },
    { "0.2.262.1.10.12.5",                "TELESEC_CRL_FILTER_EXT" },
    { "0.2.262.1.10.12.6",                "TELESEC_NAMING_AUTHORITY_EXT" },
    { "0.4.0.127.0.7",                    "BSI" },
    { "0.4.0.127.0.7.1",                  "BSI_ECC" },
    { "0.4.0.127.0.7.1.1",                "BSIFIELD_TYPE" },
    { "0.4.0.127.0.7.1.1.1",              "BSI_PRIME_FIELD" },
    { "0.4.0.127.0.7.1.1.2",              "BSI_CHARACTERISTIC_TWO_FIELD" },
    { "0.4.0.127.0.7.1.1.2.2",            "BSI_ECTLV_KEY_FORMAT" },
    { "0.4.0.127.0.7.1.1.2.2.1",          "BSI_ECTLV_PUBLIC_KEY" },
    { "0.4.0.127.0.7.1.1.2.3",            "BSI_CHARACTERISTIC_TWO_BASIS" },
    { "0.4.0.127.0.7.1.1.2.3.1",          "BSI_GN_BASIS" },
    { "0.4.0.127.0.7.1.1.2.3.2",          "BSI_TP_BASIS" },
    { "0.4.0.127.0.7.1.1.2.3.3",          "BSI_PP_BASIS" },
    { "0.4.0.127.0.7.1.1.4.1",            "BSI_ECDSA_SIGNATURES" },
    { "0.4.0.127.0.7.1.1.4.1.1",          "BSI_ECDSA_WITH_SHA1" },
    { "0.4.0.127.0.7.1.1.4.1.2",          "BSI_ECDSA_WITH_SHA224" },
    { "0.4.0.127.0.7.1.1.4.1.3",          "BSI_ECDSA_WITH_SHA256" },
    { "0.4.0.127.0.7.1.1.4.1.4",          "BSI_ECDSA_WITH_SHA384" },
    { "0.4.0.127.0.7.1.1.4.1.5",          "BSI_ECDSA_WITH_SHA512" },
    { "0.4.0.127.0.7.1.1.4.1.6",          "BSI_ECDSA_WITH_RIPEMD160" },
    { "0.4.0.127.0.7.1.1.5.1.1",          "BSI_ECKA_EG_X963_KDF" },
    { "0.4.0.127.0.7.1.1.5.1.1.1",        "BSI_ECKA_EG_X963_KDF_WITH_SHA1" },
    { "0.4.0.127.0.7.1.1.5.1.1.2",        "BSI_ECKA_EG_X963_KDF_WITH_SHA224" },
    { "0.4.0.127.0.7.1.1.5.1.1.3",        "BSI_ECKA_EG_X963_KDF_WITH_SHA256" },
    { "0.4.0.127.0.7.1.1.5.1.1.4",        "BSI_ECKA_EG_X963_KDF_WITH_SHA384" },
    { "0.4.0.127.0.7.1.1.5.1.1.5",        "BSI_ECKA_EG_X963_KDF_WITH_SHA512" },
    { "0.4.0.127.0.7.1.1.5.1.1.6",        "BSI_ECKA_EG_X963_KDF_WITH_RIPEMD160" },
    { "0.4.0.127.0.7.1.1.5.1.2",          "BSI_ECKA_EG_SESSION_KDF" },
    { "0.4.0.127.0.7.1.1.5.1.2.1",        "BSI_ECKA_EG_SESSION_KDF_WITH3_DES" },
    { "0.4.0.127.0.7.1.1.5.1.2.2",        "BSI_ECKA_EG_SESSION_KDF_WITH_AES128" },
    { "0.4.0.127.0.7.1.1.5.1.2.3",        "BSI_ECKA_EG_SESSION_KDF_WITH_AES192" },
    { "0.4.0.127.0.7.1.1.5.1.2.4",        "BSI_ECKA_EG_SESSION_KDF_WITH_AES256" },
    { "0.4.0.127.0.7.1.1.5.2",            "BSI_ECKA_DH" },
    { "0.4.0.127.0.7.1.1.5.2.1",          "BSI_ECKA_DHX963_KDF" },
    { "0.4.0.127.0.7.1.1.5.2.1.1",        "BSI_ECKA_DHX963_KDF_WITH_SHA1" },
    { "0.4.0.127.0.7.1.1.5.2.1.2",        "BSI_ECKA_DHX963_KDF_WITH_SHA224" },
    { "0.4.0.127.0.7.1.1.5.2.1.3",        "BSI_ECKA_DHX963_KDF_WITH_SHA256" },
    { "0.4.0.127.0.7.1.1.5.2.1.4",        "BSI_ECKA_DHX963_KDF_WITH_SHA384" },
    { "0.4.0.127.0.7.1.1.5.2.1.5",        "BSI_ECKA_DHX963_KDF_WITH_SHA512" },
    { "0.4.0.127.0.7.1.1.5.2.1.6",        "BSI_ECKA_DHX963_KDF_WITH_RIPEMD160" },
    { "0.4.0.127.0.7.1.1.5.2.2",          "BSI_ECKA_DH_SESSION_KDF" },
    { "0.4.0.127.0.7.1.1.5.2.2.1",        "BSI_ECKA_DH_SESSION_KDF_WITH3_DES" },
    { "0.4.0.127.0.7.1.1.5.2.2.2",        "BSI_ECKA_DH_SESSION_KDF_WITH_AES128" },
    { "0.4.0.127.0.7.1.1.5.2.2.3",        "BSI_ECKA_DH_SESSION_KDF_WITH_AES192" },
    { "0.4.0.127.0.7.1.1.5.2.2.4",        "BSI_ECKA_DH_SESSION_KDF_WITH_AES256" },
    { "0.4.0.127.0.7.1.2",                "BSI_EC_KEY_TYPE" },
    { "0.4.0.127.0.7.1.2.1",              "BSI_EC_PUBLIC_KEY" },
    { "0.4.0.127.0.7.1.5.1",              "BSI_KAEG" },
    { "0.4.0.127.0.7.1.5.1.1",            "BSI_KAEG_WITH_X963_KDF" },
    { "0.4.0.127.0.7.1.5.1.2",            "BSI_KAEG_WITH3_DESKDF" },
    { "0.4.0.127.0.7.2.2.1",              "BSI_PK" },
    { "0.4.0.127.0.7.2.2.1.1",            "BSI_PK_DH" },
    { "0.4.0.127.0.7.2.2.1.2",            "BSI_PK_ECDH" },
    { "0.4.0.127.0.7.2.2.2",              "BSI_TA" },
    { "0.4.0.127.0.7.2.2.2.1",            "BSI_TA_RSA" },
    { "0.4.0.127.0.7.2.2.2.1.1",          "BSI_TA_RS_AV1_5_SHA1" },
    { "0.4.0.127.0.7.2.2.2.1.2",          "BSI_TA_RS_AV1_5_SHA256" },
    { "0.4.0.127.0.7.2.2.2.1.3",          "BSI_TA_RSAPSS_SHA1" },
    { "0.4.0.127.0.7.2.2.2.1.4",          "BSI_TA_RSAPSS_SHA256" },
    { "0.4.0.127.0.7.2.2.2.1.5",          "BSI_TA_RS_AV1_5_SHA512" },
    { "0.4.0.127.0.7.2.2.2.1.6",          "BSI_TA_RSAPSS_SHA512" },
    { "0.4.0.127.0.7.2.2.2.2",            "BSI_TA_ECDSA" },
    { "0.4.0.127.0.7.2.2.2.2.1",          "BSI_TA_ECDSA_SHA1" },
    { "0.4.0.127.0.7.2.2.2.2.2",          "BSI_TA_ECDSA_SHA224" },
    { "0.4.0.127.0.7.2.2.2.2.3",          "BSI_TA_ECDSA_SHA256" },
    { "0.4.0.127.0.7.2.2.2.2.4",          "BSI_TA_ECDSA_SHA384" },
    { "0.4.0.127.0.7.2.2.2.2.5",          "BSI_TA_ECDSA_SHA512" },
    { "0.4.0.127.0.7.2.2.3",              "BSI_CA" },
    { "0.4.0.127.0.7.2.2.3.1",            "BSI_CA_DH" },
    { "0.4.0.127.0.7.2.2.3.1.1",          "BSI_CA_DH_3_DES_CBC_CBC" },
    { "0.4.0.127.0.7.2.2.3.1.2",          "BSI_CA_DH_AES_CBC_CMAC_128" },
    { "0.4.0.127.0.7.2.2.3.1.3",          "BSI_CA_DH_AES_CBC_CMAC_192" },
    { "0.4.0.127.0.7.2.2.3.1.4",          "BSI_CA_DH_AES_CBC_CMAC_256" },
    { "0.4.0.127.0.7.2.2.3.2",            "BSI_CA_ECDH" },
    { "0.4.0.127.0.7.2.2.3.2.1",          "BSI_CA_ECDH_3_DES_CBC_CBC" },
    { "0.4.0.127.0.7.2.2.3.2.2",          "BSI_CA_ECDH_AES_CBC_CMAC_128" },
    { "0.4.0.127.0.7.2.2.3.2.3",          "BSI_CA_ECDH_AES_CBC_CMAC_192" },
    { "0.4.0.127.0.7.2.2.3.2.4",          "BSI_CA_ECDH_AES_CBC_CMAC_256" },
    { "0.4.0.127.0.7.2.2.4",              "BSI_PACE" },
    { "0.4.0.127.0.7.2.2.4.1",            "BSI_PACE_DH_GM" },
    { "0.4.0.127.0.7.2.2.4.1.1",          "BSI_PACE_DH_GM_3_DES_CBC_CBC" },
    { "0.4.0.127.0.7.2.2.4.1.2",          "BSI_PACE_DH_GM_AES_CBC_CMAC_128" },
    { "0.4.0.127.0.7.2.2.4.1.3",          "BSI_PACE_DH_GM_AES_CBC_CMAC_192" },
    { "0.4.0.127.0.7.2.2.4.1.4",          "BSI_PACE_DH_GM_AES_CBC_CMAC_256" },
    { "0.4.0.127.0.7.2.2.4.2",            "BSI_PACE_ECDH_GM" },
    { "0.4.0.127.0.7.2.2.4.2.1",          "BSI_PACE_ECDH_GM_3_DES_CBC_CBC" },
    { "0.4.0.127.0.7.2.2.4.2.2",          "BSI_PACE_ECDH_GM_AES_CBC_CMAC_128" },
    { "0.4.0.127.0.7.2.2.4.2.3",          "BSI_PACE_ECDH_GM_AES_CBC_CMAC_192" },
    { "0.4.0.127.0.7.2.2.4.2.4",          "BSI_PACE_ECDH_GM_AES_CBC_CMAC_256" },
    { "0.4.0.127.0.7.2.2.4.3",            "BSI_PACE_DH_IM" },
    { "0.4.0.127.0.7.2.2.4.3.1",          "BSI_PACE_DH_IM_3_DES_CBC_CBC" },
    { "0.4.0.127.0.7.2.2.4.3.2",          "BSI_PACE_DH_IM_AES_CBC_CMAC_128" },
    { "0.4.0.127.0.7.2.2.4.3.3",          "BSI_PACE_DH_IM_AES_CBC_CMAC_192" },
    { "0.4.0.127.0.7.2.2.4.3.4",          "BSI_PACE_DH_IM_AES_CBC_CMAC_256" },
    { "0.4.0.127.0.7.2.2.4.4",            "BSI_PACE_ECDH_IM" },
    { "0.4.0.127.0.7.2.2.4.4.1",          "BSI_PACE_ECDH_IM_3_DES_CBC_CBC" },
    { "0.4.0.127.0.7.2.2.4.4.2",          "BSI_PACE_ECDH_IM_AES_CBC_CMAC_128" },
    { "0.4.0.127.0.7.2.2.4.4.3",          "BSI_PACE_ECDH_IM_AES_CBC_CMAC_192" },
    { "0.4.0.127.0.7.2.2.4.4.4",          "BSI_PACE_ECDH_IM_AES_CBC_CMAC_256" },
    { "0.4.0.127.0.7.2.2.5",              "BSI_RI" },
    { "0.4.0.127.0.7.2.2.5.1",            "BSI_RI_DH" },
    { "0.4.0.127.0.7.2.2.5.1.1",          "BSI_RI_DH_SHA1" },
    { "0.4.0.127.0.7.2.2.5.1.2",          "BSI_RI_DH_SHA224" },
    { "0.4.0.127.0.7.2.2.5.1.3",          "BSI_RI_DH_SHA256" },
    { "0.4.0.127.0.7.2.2.5.1.4",          "BSI_RI_DH_SHA384" },
    { "0.4.0.127.0.7.2.2.5.1.5",          "BSI_RI_DH_SHA512" },
    { "0.4.0.127.0.7.2.2.5.2",            "BSI_RI_ECDH" },
    { "0.4.0.127.0.7.2.2.5.2.1",          "BSI_RI_ECDH_SHA1" },
    { "0.4.0.127.0.7.2.2.5.2.2",          "BSI_RI_ECDH_SHA224" },
    { "0.4.0.127.0.7.2.2.5.2.3",          "BSI_RI_ECDH_SHA256" },
    { "0.4.0.127.0.7.2.2.5.2.4",          "BSI_RI_ECDH_SHA384" },
    { "0.4.0.127.0.7.2.2.5.2.5",          "BSI_RI_ECDH_SHA512" },
    { "0.4.0.127.0.7.2.2.6",              "BSI_CARD_INFO" },
    { "0.4.0.127.0.7.2.2.7",              "BSI_EID_SECURITY" },
    { "0.4.0.127.0.7.2.2.8",              "BSI_PT" },
    { "0.4.0.127.0.7.3.1.2",              "BSI_EAC_ROLES" },
    { "0.4.0.127.0.7.3.1.2.1",            "BSI_EAC_ROLES_IS" },
    { "0.4.0.127.0.7.3.1.2.2",            "BSI_EAC_ROLES_AT" },
    { "0.4.0.127.0.7.3.1.2.3",            "BSI_EAC_ROLES_ST" },
    { "0.4.0.127.0.7.3.1.3",              "BSI_T_AV2CE" },
    { "0.4.0.127.0.7.3.1.3.1",            "BSI_T_AV2CE_DESCRIPTION" },
    { "0.4.0.127.0.7.3.1.3.1.1",          "BSI_T_AV2CE_DESCRIPTION_PLAIN_TEXT" },
    { "0.4.0.127.0.7.3.1.3.1.2",          "BSI_T_AV2CE_DESCRIPTION_IA5_STRING" },
    { "0.4.0.127.0.7.3.1.3.1.3",          "BSI_T_AV2CE_DESCRIPTION_OCTET_STRING" },
    { "0.4.0.127.0.7.3.1.3.2",            "BSI_T_AV2CE_TERMINAL_SECTOR" },
    { "0.4.0.127.0.7.3.1.4",              "BSI_AUX_DATA" },
    { "0.4.0.127.0.7.3.1.4.1",            "BSI_AUX_DATA_BIRTHDAY" },
    { "0.4.0.127.0.7.3.1.4.2",            "BSI_AUX_DATA_EXPIRE_DATE" },
    { "0.4.0.127.0.7.3.1.4.3",            "BSI_AUX_DATA_COMMUNITY_ID" },
    { "0.4.0.127.0.7.3.1.5",              "BSI_DEFECT_LIST" },
    { "0.4.0.127.0.7.3.1.5.1",            "BSI_DEFECT_AUTH_DEFECT" },
    { "0.4.0.127.0.7.3.1.5.1.1",          "BSI_DEFECT_CERT_REVOKED" },
    { "0.4.0.127.0.7.3.1.5.1.2",          "BSI_DEFECT_CERT_REPLACED" },
    { "0.4.0.127.0.7.3.1.5.1.3",          "BSI_DEFECT_CHIP_AUTH_KEY_REVOKED" },
    { "0.4.0.127.0.7.3.1.5.1.4",          "BSI_DEFECT_ACTIVE_AUTH_KEY_REVOKED" },
    { "0.4.0.127.0.7.3.1.5.2",            "BSI_DEFECT_E_PASSPORT_DEFECT" },
    { "0.4.0.127.0.7.3.1.5.2.1",          "BSI_DEFECT_E_PASSPORT_DG_MALFORMED" },
    { "0.4.0.127.0.7.3.1.5.2.2",          "BSI_DEFECT_SOD_INVALID" },
    { "0.4.0.127.0.7.3.1.5.3",            "BSI_DEFECT_EID_DEFECT" },
    { "0.4.0.127.0.7.3.1.5.3.1",          "BSI_DEFECT_EIDDG_MALFORMED" },
    { "0.4.0.127.0.7.3.1.5.3.2",          "BSI_DEFECT_EID_INTEGRITY" },
    { "0.4.0.127.0.7.3.1.5.4",            "BSI_DEFECT_DOCUMENT_DEFECT" },
    { "0.4.0.127.0.7.3.1.5.4.1",          "BSI_DEFECT_CARD_SECURITY_MALFORMED" },
    { "0.4.0.127.0.7.3.1.5.4.2",          "BSI_DEFECT_CHIP_SECURITY_MALFORMED" },
    { "0.4.0.127.0.7.3.1.5.4.3",          "BSI_DEFECT_POWER_DOWN_REQ" },
    { "0.4.0.127.0.7.3.1.6",              "BSI_LIST_CONTENT_DESCRIPTION" },
    { "0.4.0.127.0.7.3.2.1",              "BSI_SECURITY_OBJECT" },
    { "0.4.0.127.0.7.3.2.2",              "BSI_BLACK_LIST" },
    { "0.4.0.1862",                       "ETSI_QCS_PROFILE" },
    { "0.4.0.1862.1",                     "ETSI_QCS" },
    { "0.4.0.1862.1.1",                   "ETSI_QCS_COMPLIANCE" },
    { "0.4.0.1862.1.2",                   "ETSI_QCS_LIMIT_VALUE" },
    { "0.4.0.1862.1.3",                   "ETSI_QCS_RETENTION_PERIOD" },
    { "0.4.0.1862.1.4",                   "ETSI_QCS_QC_SSCD" },
    { "0.9.2342.19200300.100.1.1",        "USER_ID" },
    { "0.9.2342.19200300.100.1.3",        "RFC822_MAILBOX" },
    { "0.9.2342.19200300.100.1.25",       "DOMAIN_COMPONENT" },
    { "1.0.10118.3.0.49",                 "RIPEMD160" },
    { "1.0.10118.3.0.50",                 "RIPEMD128" },
    { "1.0.10118.3.0.55",                 "WHIRLPOOL" },
    { "1.2.36.1.3.1.1.1",                 "QGPKI" },
    { "1.2.36.1.3.1.1.1.1",               "QGPKI_POLICIES" },
    { "1.2.36.1.3.1.1.1.1.1",             "QGPKI_MED_INTERMED_CA" },
    { "1.2.36.1.3.1.1.1.1.1.1",           "QGPKI_MED_INTERMED_INDIVIDUAL" },
    { "1.2.36.1.3.1.1.1.1.1.2",           "QGPKI_MED_INTERMED_DEVICE_CONTROL" },
    { "1.2.36.1.3.1.1.1.1.1.3",           "QGPKI_MED_INTERMED_DEVICE" },
    { "1.2.36.1.3.1.1.1.1.1.4",           "QGPKI_MED_INTERMED_AUTHORISED_PARTY" },
    { "1.2.36.1.3.1.1.1.1.1.5",           "QGPKI_MED_INTERMED_DEVICE_SYSTEM" },
    { "1.2.36.1.3.1.1.1.1.2",             "QGPKI_MED_ISSUING_CA" },
    { "1.2.36.1.3.1.1.1.1.2.1",           "QGPKI_MED_ISSUING_INDIVIDUAL" },
    { "1.2.36.1.3.1.1.1.1.2.2",           "QGPKI_MED_ISSUING_DEVICE_CONTROL" },
    { "1.2.36.1.3.1.1.1.1.2.3",           "QGPKI_MED_ISSUING_DEVICE" },
    { "1.2.36.1.3.1.1.1.1.2.4",           "QGPKI_MED_ISSUING_AUTHORISED_PARTY" },
    { "1.2.36.1.3.1.1.1.1.2.5",           "QGPKI_MED_ISSUING_CLIENT_AUTH" },
    { "1.2.36.1.3.1.1.1.1.2.6",           "QGPKI_MED_ISSUING_SERVER_AUTH" },
    { "1.2.36.1.3.1.1.1.1.2.7",           "QGPKI_MED_ISSUING_DATA_PROT" },
    { "1.2.36.1.3.1.1.1.1.2.8",           "QGPKI_MED_ISSUING_TOKEN_AUTH" },
    { "1.2.36.1.3.1.1.1.1.3",             "QGPKI_BASIC_INTERMED_CA" },
    { "1.2.36.1.3.1.1.1.1.3.1",           "QGPKI_BASIC_INTERMED_DEVICE_SYSTEM" },
    { "1.2.36.1.3.1.1.1.1.4",             "QGPKI_BASIC_ISSUING_CA" },
    { "1.2.36.1.3.1.1.1.1.4.1",           "QGPKI_BASIC_ISSUING_CLIENT_AUTH" },
    { "1.2.36.1.3.1.1.1.1.4.2",           "QGPKI_BASIC_ISSUING_SERVER_AUTH" },
    { "1.2.36.1.3.1.1.1.1.4.3",           "QGPKI_BASIC_ISSUING_DATA_SIGNING" },
    { "1.2.36.1.3.1.1.1.2",               "QGPKI_ASSURANCE_LEVEL" },
    { "1.2.36.1.3.1.1.1.2.1",             "QGPKI_ASSURANCE_RUDIMENTARY" },
    { "1.2.36.1.3.1.1.1.2.2",             "QGPKI_ASSURANCE_BASIC" },
    { "1.2.36.1.3.1.1.1.2.3",             "QGPKI_ASSURANCE_MEDIUM" },
    { "1.2.36.1.3.1.1.1.2.4",             "QGPKI_ASSURANCE_HIGH" },
    { "1.2.36.1.3.1.1.1.3",               "QGPKI_CERT_FUNCTION" },
    { "1.2.36.1.3.1.1.1.3.1",             "QGPKI_FUNCTION_INDIVIDUAL" },
    { "1.2.36.1.3.1.1.1.3.2",             "QGPKI_FUNCTION_DEVICE" },
    { "1.2.36.1.3.1.1.1.3.3",             "QGPKI_FUNCTION_AUTHORISED_PARTY" },
    { "1.2.36.1.3.1.1.1.3.4",             "QGPKI_FUNCTION_DEVICE_CONTROL" },
    { "1.2.36.1.3.1.2",                   "QPSPKI" },
    { "1.2.36.1.3.1.2.1",                 "QPSPKI_POLICIES" },
    { "1.2.36.1.3.1.2.1.2",               "QPSPKI_POLICY_BASIC" },
    { "1.2.36.1.3.1.2.1.3",               "QPSPKI_POLICY_MEDIUM" },
    { "1.2.36.1.3.1.2.1.4",               "QPSPKI_POLICY_HIGH" },
    { "1.2.36.1.3.1.3.2",                 "QTMRPKI" },
    { "1.2.36.1.3.1.3.2.1",               "QTMRPKI_POLICIES" },
    { "1.2.36.1.3.1.3.2.2",               "QTMRPKI_PURPOSE" },
    { "1.2.36.1.3.1.3.2.2.1",             "QTMRPKI_INDIVIDUAL" },
    { "1.2.36.1.3.1.3.2.2.2",             "QTMRPKI_DEVICE_CONTROL" },
    { "1.2.36.1.3.1.3.2.2.3",             "QTMRPKI_DEVICE" },
    { "1.2.36.1.3.1.3.2.2.4",             "QTMRPKI_AUTHORISED_PARTY" },
    { "1.2.36.1.3.1.3.2.2.5",             "QTMRPKI_DEVICE_SYSTEM" },
    { "1.2.36.1.3.1.3.2.3",               "QTMRPKI_DEVICE" },
    { "1.2.36.1.3.1.3.2.3.1",             "QTMRPKI_DRIVER_LICENSE" },
    { "1.2.36.1.3.1.3.2.3.2",             "QTMRPKI_INDUSTRY_AUTHORITY" },
    { "1.2.36.1.3.1.3.2.3.3",             "QTMRPKI_MARINE_LICENSE" },
    { "1.2.36.1.3.1.3.2.3.4",             "QTMRPKI_ADULT_PROOF_OF_AGE" },
    { "1.2.36.1.3.1.3.2.3.5",             "QTMRPKI_SAM" },
    { "1.2.36.1.3.1.3.2.4",               "QTMRPKI_AUTHORISED_PARTY" },
    { "1.2.36.1.3.1.3.2.4.1",             "QTMRPKI_TRANSPORT_INSPECTOR" },
    { "1.2.36.1.3.1.3.2.4.2",             "QTMRPKI_POLICE_OFFICER" },
    { "1.2.36.1.3.1.3.2.4.3",             "QTMRPKI_SYSTEM" },
    { "1.2.36.1.3.1.3.2.4.4",             "QTMRPKI_LIQUOR_LICENSING_INSPECTOR" },
    { "1.2.36.1.3.1.3.2.4.5",             "QTMRPKI_MARINE_ENFORCEMENT_OFFICER" },
    { "1.2.36.1.333.1",                   "AUSTRALIAN_BUSINESS_NUMBER" },
    { "1.2.36.68980861.1.1.2",            "SIGNET_PERSONAL" },
    { "1.2.36.68980861.1.1.3",            "SIGNET_BUSINESS" },
    { "1.2.36.68980861.1.1.4",            "SIGNET_LEGAL" },
    { "1.2.36.68980861.1.1.10",           "SIGNET_PILOT" },
    { "1.2.36.68980861.1.1.11",           "SIGNET_INTRA_NET" },
    { "1.2.36.68980861.1.1.20",           "SIGNET_POLICY" },
    { "1.2.36.75878867.1.100.1.1",        "CERTIFICATES_AUSTRALIA_POLICY" },
    { "1.2.392.200011.61.1.1.1",          "MITSUBISHI_SECURITY_ALGORITHM" },
    { "1.2.392.200011.61.1.1.1.1",        "MISTY1_CBC" },
    { "1.2.410.200004.1",                 "KISA_ALGORITHM" },
    { "1.2.410.200004.1.1",               "KCDSA" },
    { "1.2.410.200004.1.2",               "HAS160" },
    { "1.2.410.200004.1.3",               "SEED_ECB" },
    { "1.2.410.200004.1.4",               "SEED_CBC" },
    { "1.2.410.200004.1.5",               "SEED_OFB" },
    { "1.2.410.200004.1.6",               "SEED_CFB" },
    { "1.2.410.200004.1.7",               "SEED_MAC" },
    { "1.2.410.200004.1.8",               "KCDSA_WITH_HAS160" },
    { "1.2.410.200004.1.9",               "KCDSA_WITH_SHA1" },
    { "1.2.410.200004.1.10",              "PBE_WITH_HAS160_AND_SEED_ECB" },
    { "1.2.410.200004.1.11",              "PBE_WITH_HAS160_AND_SEED_CBC" },
    { "1.2.410.200004.1.12",              "PBE_WITH_HAS160_AND_SEED_CFB" },
    { "1.2.410.200004.1.13",              "PBE_WITH_HAS160_AND_SEED_OFB" },
    { "1.2.410.200004.1.14",              "PBE_WITH_SHA1_AND_SEED_ECB" },
    { "1.2.410.200004.1.15",              "PBE_WITH_SHA1_AND_SEED_CBC" },
    { "1.2.410.200004.1.16",              "PBE_WITH_SHA1_AND_SEED_CFB" },
    { "1.2.410.200004.1.17",              "PBE_WITH_SHA1_AND_SEED_OFB" },
    { "1.2.410.200004.1.20",              "RSA_WITH_HAS160" },
    { "1.2.410.200004.1.21",              "KCDSA1" },
    { "1.2.410.200004.2",                 "NPKI_CP" },
    { "1.2.410.200004.2.1",               "NPKI_SIGNATURE_POLICY" },
    { "1.2.410.200004.3",                 "NPKI_KP" },
    { "1.2.410.200004.4",                 "NPKI_AT" },
    { "1.2.410.200004.5",                 "NPKI_LCA" },
    { "1.2.410.200004.5.1",               "NPKI_SIGN_KOREA" },
    { "1.2.410.200004.5.2",               "NPKI_SIGN_GATE" },
    { "1.2.410.200004.5.3",               "NPKI_NCA_SIGN" },
    { "1.2.410.200004.6",                 "NPKI_ON" },
    { "1.2.410.200004.7",                 "NPKI_APP" },
    { "1.2.410.200004.7.1",               "NPKI_SMIME" },
    { "1.2.410.200004.7.1.1",             "NPKI_SMIME_ALGO" },
    { "1.2.410.200004.7.1.1.1",           "NPKI_CMS_SEED_WRAP" },
    { "1.2.410.200004.10",                "NPKI" },
    { "1.2.410.200004.10.1",              "NPKI_ATTRIBUTE" },
    { "1.2.410.200004.10.1.1",            "NPKI_IDENTIFY_DATA" },
    { "1.2.410.200004.10.1.1.1",          "NPKI_VID" },
    { "1.2.410.200004.10.1.1.2",          "NPKI_ENCRYPTED_VID" },
    { "1.2.410.200004.10.1.1.3",          "NPKI_RANDOM_NUM" },
    { "1.2.410.200004.10.1.1.4",          "NPKI_VID" },
    { "1.2.410.200046.1.1",               "ARIA1_ALGORITHM_MODES" },
    { "1.2.410.200046.1.1.1",             "ARIA128_ECB" },
    { "1.2.410.200046.1.1.2",             "ARIA128_CBC" },
    { "1.2.410.200046.1.1.3",             "ARIA128_CFB" },
    { "1.2.410.200046.1.1.4",             "ARIA128_OFB" },
    { "1.2.410.200046.1.1.5",             "ARIA128_CTR" },
    { "1.2.410.200046.1.1.6",             "ARIA192_ECB" },
    { "1.2.410.200046.1.1.7",             "ARIA192_CBC" },
    { "1.2.410.200046.1.1.8",             "ARIA192_CFB" },
    { "1.2.410.200046.1.1.9",             "ARIA192_OFB" },
    { "1.2.410.200046.1.1.10",            "ARIA192_CTR" },
    { "1.2.410.200046.1.1.11",            "ARIA256_ECB" },
    { "1.2.410.200046.1.1.12",            "ARIA256_CBC" },
    { "1.2.410.200046.1.1.13",            "ARIA256_CFB" },
    { "1.2.410.200046.1.1.14",            "ARIA256_OFB" },
    { "1.2.410.200046.1.1.15",            "ARIA256_CTR" },
    { "1.2.410.200046.1.1.21",            "ARIA128_CMAC" },
    { "1.2.410.200046.1.1.22",            "ARIA192_CMAC" },
    { "1.2.410.200046.1.1.23",            "ARIA256_CMAC" },
    { "1.2.410.200046.1.1.31",            "ARIA128_OCB2" },
    { "1.2.410.200046.1.1.32",            "ARIA192_OCB2" },
    { "1.2.410.200046.1.1.33",            "ARIA256_OCB2" },
    { "1.2.410.200046.1.1.34",            "ARIA128_GCM" },
    { "1.2.410.200046.1.1.35",            "ARIA192_GCM" },
    { "1.2.410.200046.1.1.36",            "ARIA256_GCM" },
    { "1.2.410.200046.1.1.37",            "ARIA128_CCM" },
    { "1.2.410.200046.1.1.38",            "ARIA192_CCM" },
    { "1.2.410.200046.1.1.39",            "ARIA256_CCM" },
    { "1.2.410.200046.1.1.40",            "ARIA128_KEYWRAP" },
    { "1.2.410.200046.1.1.41",            "ARIA192_KEYWRAP" },
    { "1.2.410.200046.1.1.42",            "ARIA256_KEYWRAP" },
    { "1.2.410.200046.1.1.43",            "ARIA128_KEYWRAP_WITH_PAD" },
    { "1.2.410.200046.1.1.44",            "ARIA192_KEYWRAP_WITH_PAD" },
    { "1.2.410.200046.1.1.45",            "ARIA256_KEYWRAP_WITH_PAD" },
    { "1.2.643.2.2.3",                    "GOST_SIGNATURE" },
    { "1.2.643.2.2.4",                    "GOST94_SIGNATURE" },
    { "1.2.643.2.2.19",                   "GOST_PUBLIC_KEY" },
    { "1.2.643.2.2.20",                   "GOST94_PUBLIC_KEY" },
    { "1.2.643.2.2.21",                   "GOST_CIPHER" },
    { "1.2.643.2.2.31.0",                 "TEST_CIPHER_PARAMS" },
    { "1.2.643.2.2.31.1",                 "CRYPTO_PRO_CIPHER_A" },
    { "1.2.643.2.2.31.2",                 "CRYPTO_PRO_CIPHER_B" },
    { "1.2.643.2.2.31.3",                 "CRYPTO_PRO_CIPHER_C" },
    { "1.2.643.2.2.31.4",                 "CRYPTO_PRO_CIPHER_D" },
    { "1.2.643.2.2.31.5",                 "OSCAR11_CIPHER" },
    { "1.2.643.2.2.31.6",                 "OSCAR10_CIPHER" },
    { "1.2.643.2.2.31.7",                 "RIC1_CIPHER" },
    { "1.2.643.2.2.9",                    "GOST_DIGEST" },
    { "1.2.643.2.2.30.0",                 "TEST_DIGEST_PARAMS" },
    { "1.2.643.2.2.30.1",                 "CRYPTO_PRO_DIGEST_A" },
    { "1.2.643.2.2.35.0",                 "TEST_SIGN_PARAMS" },
    { "1.2.643.2.2.35.1",                 "CRYPTO_PRO_SIGN_A" },
    { "1.2.643.2.2.35.2",                 "CRYPTO_PRO_SIGN_B" },
    { "1.2.643.2.2.35.3",                 "CRYPTO_PRO_SIGN_C" },
    { "1.2.643.2.2.36.0",                 "CRYPTO_PRO_SIGN_XA" },
    { "1.2.643.2.2.36.1",                 "CRYPTO_PRO_SIGN_XB" },
    { "1.2.643.2.2.14.0",                 "NULL_MESHING" },
    { "1.2.643.2.2.14.1",                 "CRYPTO_PRO_MESHING" },
    { "1.2.643.2.2.10",                   "HMAC_GOST" },
    { "1.2.643.2.2.13.0",                 "GOST_WRAP" },
    { "1.2.643.2.2.13.1",                 "CRYPTO_PRO_WRAP" },
    { "1.2.643.2.2.96",                   "CRYPTO_PRO_ECDH_WRAP" },
    { "1.2.752.34.1",                     "SEIS_CP" },
    { "1.2.752.34.1.1",                   "SEIS_HIGH_ASSURANCE_POLICY_IDENTIFIER" },
    { "1.2.752.34.1.2",                   "SEIS_GAK_POLICY_IDENTIFIER" },
    { "1.2.752.34.2",                     "SEIS_PE" },
    { "1.2.752.34.3",                     "SEIS_AT" },
    { "1.2.752.34.3.1",                   "SEIS_AT_PERSONAL_IDENTIFIER" },
    { "1.2.840.10040.1",                  "MODULE" },
    { "1.2.840.10040.1.1",                "X9F1_CERT_MGMT" },
    { "1.2.840.10040.2",                  "HOLDINSTRUCTION" },
    { "1.2.840.10040.2.1",                "HOLDINSTRUCTION_NONE" },
    { "1.2.840.10040.2.2",                "CALLISSUER" },
    { "1.2.840.10040.2.3",                "REJECT" },
    { "1.2.840.10040.2.4",                "PICKUP_TOKEN" },
    { "1.2.840.10040.3",                  "ATTRIBUTE" },
    { "1.2.840.10040.3.1",                "COUNTERSIGNATURE" },
    { "1.2.840.10040.3.2",                "ATTRIBUTE_CERT" },
    { "1.2.840.10040.4",                  "ALGORITHM" },
    { "1.2.840.10040.4.1",                "DSA" },
    { "1.2.840.10040.4.2",                "DSA_MATCH" },
    { "1.2.840.10040.4.3",                "DSA_WITH_SHA1" },
    { "1.2.840.10045.1",                  "FIELD_TYPE" },
    { "1.2.840.10045.1.1",                "PRIME_FIELD" },
    { "1.2.840.10045.1.2",                "CHARACTERISTIC_TWO_FIELD" },
    { "1.2.840.10045.1.2.3",              "CHARACTERISTIC_TWO_BASIS" },
    { "1.2.840.10045.1.2.3.1",            "ON_BASIS" },
    { "1.2.840.10045.1.2.3.2",            "TP_BASIS" },
    { "1.2.840.10045.1.2.3.3",            "PP_BASIS" },
    { "1.2.840.10045.2",                  "PUBLIC_KEY_TYPE" },
    { "1.2.840.10045.2.1",                "EC_PUBLIC_KEY" },
    { "1.2.840.10045.3.0.1",              "C2PNB163V1" },
    { "1.2.840.10045.3.0.2",              "C2PNB163V2" },
    { "1.2.840.10045.3.0.3",              "C2PNB163V3" },
    { "1.2.840.10045.3.0.5",              "C2TNB191V1" },
    { "1.2.840.10045.3.0.6",              "C2TNB191V2" },
    { "1.2.840.10045.3.0.7",              "C2TNB191V3" },
    { "1.2.840.10045.3.0.10",             "C2PNB208W1" },
    { "1.2.840.10045.3.0.11",             "C2TNB239V1" },
    { "1.2.840.10045.3.0.12",             "C2TNB239V2" },
    { "1.2.840.10045.3.0.13",             "C2TNB239V3" },
    { "1.2.840.10045.3.0.16",             "C2PNB272W1" },
    { "1.2.840.10045.3.0.18",             "C2TNB359V1" },
    { "1.2.840.10045.3.0.19",             "C2PNB368W1" },
    { "1.2.840.10045.3.0.20",             "C2TNB431R1" },
    { "1.2.840.10045.3.1.1",              "PRIME192V1" },
    { "1.2.840.10045.3.1.2",              "PRIME192V2" },
    { "1.2.840.10045.3.1.3",              "PRIME192V3" },
    { "1.2.840.10045.3.1.4",              "PRIME239V1" },
    { "1.2.840.10045.3.1.5",              "PRIME239V2" },
    { "1.2.840.10045.3.1.6",              "PRIME239V3" },
    { "1.2.840.10045.3.1.7",              "PRIME256V1" },
    { "1.2.840.10045.4.1",                "ECDSA_WITH_SHA1" },
    { "1.2.840.10045.4.2",                "ECDSA_WITH_RECOMMENDED" },
    { "1.2.840.10045.4.3",                "ECDSA_WITH_SPECIFIED" },
    { "1.2.840.10045.4.3.1",              "ECDSA_WITH_SHA224" },
    { "1.2.840.10045.4.3.2",              "ECDSA_WITH_SHA256" },
    { "1.2.840.10045.4.3.3",              "ECDSA_WITH_SHA384" },
    { "1.2.840.10045.4.3.4",              "ECDSA_WITH_SHA512" },
    { "1.2.840.10046.1",                  "FIELD_TYPE" },
    { "1.2.840.10046.1.1",                "GF_PRIME" },
    { "1.2.840.10046.2",                  "NUMBER_TYPE" },
    { "1.2.840.10046.2.1",                "DH_PUBLIC_KEY" },
    { "1.2.840.10046.3",                  "SCHEME" },
    { "1.2.840.10046.3.1",                "DH_STATIC" },
    { "1.2.840.10046.3.2",                "DH_EPHEM" },
    { "1.2.840.10046.3.3",                "DH_HYBRID1" },
    { "1.2.840.10046.3.4",                "DH_HYBRID2" },
    { "1.2.840.10046.3.5",                "MQV2" },
    { "1.2.840.10046.3.6",                "MQV1" },
    { "1.2.840.10065.2.2",                "?" },
    { "1.2.840.10065.2.3",                "HEALTHCARE_LICENSE" },
    { "1.2.840.10065.2.3.1.1",            "LICENSE?" },
    { "1.2.840.10070.",                   "IEC62351" },
    { "1.2.840.10070.8",                  "IEC62351_8" },
    { "1.2.840.10070.8.1",                "IEC_USER_ROLES" },
    { "1.2.840.113533.7",                 "NSN" },
    { "1.2.840.113533.7.65",              "NSN_CE" },
    { "1.2.840.113533.7.65.0",            "ENTRUST_VERS_INFO" },
    { "1.2.840.113533.7.66",              "NSN_ALG" },
    { "1.2.840.113533.7.66.3",            "CAST3_CBC" },
    { "1.2.840.113533.7.66.10",           "CAST5_CBC" },
    { "1.2.840.113533.7.66.11",           "CAST5_MAC" },
    { "1.2.840.113533.7.66.12",           "PBE_WITH_MD5_AND_CAST5_CBC" },
    { "1.2.840.113533.7.66.13",           "PASSWORD_BASED_MAC" },
    { "1.2.840.113533.7.67",              "NSN_OC" },
    { "1.2.840.113533.7.67.0",            "ENTRUST_USER" },
    { "1.2.840.113533.7.68",              "NSN_AT" },
    { "1.2.840.113533.7.68.0",            "ENTRUST_CA_INFO" },
    { "1.2.840.113533.7.68.10",           "ATTRIBUTE_CERTIFICATE" },
    { "1.2.840.113549.1.1",               "PKCS_1" },
    { "1.2.840.113549.1.1.1",             "RSA_ENCRYPTION" },
    { "1.2.840.113549.1.1.2",             "MD2_WITH_RSA_ENCRYPTION" },
    { "1.2.840.113549.1.1.3",             "MD4_WITH_RSA_ENCRYPTION" },
    { "1.2.840.113549.1.1.4",             "MD5_WITH_RSA_ENCRYPTION" },
    { "1.2.840.113549.1.1.5",             "SHA1_WITH_RSA_ENCRYPTION" },
    { "1.2.840.113549.1.1.7",             "RSA_OAEP" },
    { "1.2.840.113549.1.1.8",             "PKCS1_MGF" },
    { "1.2.840.113549.1.1.9",             "RSA_OAEP_P_SPECIFIED" },
    { "1.2.840.113549.1.1.10",            "RSA_PSS" },
    { "1.2.840.113549.1.1.11",            "SHA256_WITH_RSA_ENCRYPTION" },
    { "1.2.840.113549.1.1.12",            "SHA384_WITH_RSA_ENCRYPTION" },
    { "1.2.840.113549.1.1.13",            "SHA512_WITH_RSA_ENCRYPTION" },
    { "1.2.840.113549.1.1.14",            "SHA224_WITH_RSA_ENCRYPTION" },
    { "1.2.840.113549.1.1.6",             "RSA_OAEP_ENCRYPTION_SET" },
    { "1.2.840.113549.1.2",               "BSAFE_RSA_ENCR" },
    { "1.2.840.113549.1.3",               "PKCS_3" },
    { "1.2.840.113549.1.3.1",             "DH_KEY_AGREEMENT" },
    { "1.2.840.113549.1.5",               "PKCS_5" },
    { "1.2.840.113549.1.5.1",             "PBE_WITH_MD2_AND_DES_CBC" },
    { "1.2.840.113549.1.5.3",             "PBE_WITH_MD5_AND_DES_CBC" },
    { "1.2.840.113549.1.5.4",             "PBE_WITH_MD2_AND_RC2_CBC" },
    { "1.2.840.113549.1.5.6",             "PBE_WITH_MD5_AND_RC2_CBC" },
    { "1.2.840.113549.1.5.9",             "PBE_WITH_MD5_AND_XOR" },
    { "1.2.840.113549.1.5.10",            "PBE_WITH_SHA_AND_DES_CBC" },
    { "1.2.840.113549.1.5.12",            "PKCS5_PBKDF2" },
    { "1.2.840.113549.1.5.13",            "PKCS5_PBES2" },
    { "1.2.840.113549.1.5.14",            "PKCS5_PBMAC1" },
    { "1.2.840.113549.1.7",               "PKCS_7" },
    { "1.2.840.113549.1.7.1",             "DATA" },
    { "1.2.840.113549.1.7.2",             "SIGNED_DATA" },
    { "1.2.840.113549.1.7.3",             "ENVELOPED_DATA" },
    { "1.2.840.113549.1.7.4",             "SIGNED_AND_ENVELOPED_DATA" },
    { "1.2.840.113549.1.7.5",             "DIGESTED_DATA" },
    { "1.2.840.113549.1.7.6",             "ENCRYPTED_DATA" },
    { "1.2.840.113549.1.7.7",             "DATA_WITH_ATTRIBUTES" },
    { "1.2.840.113549.1.7.8",             "ENCRYPTED_PRIVATE_KEY_INFO" },
    { "1.2.840.113549.1.9",               "PKCS_9" },
    { "1.2.840.113549.1.9.1",             "EMAIL_ADDRESS" },
    { "1.2.840.113549.1.9.2",             "UNSTRUCTURED_NAME" },
    { "1.2.840.113549.1.9.3",             "CONTENT_TYPE" },
    { "1.2.840.113549.1.9.4",             "MESSAGE_DIGEST" },
    { "1.2.840.113549.1.9.5",             "SIGNING_TIME" },
    { "1.2.840.113549.1.9.6",             "COUNTERSIGNATURE" },
    { "1.2.840.113549.1.9.7",             "CHALLENGE_PASSWORD" },
    { "1.2.840.113549.1.9.8",             "UNSTRUCTURED_ADDRESS" },
    { "1.2.840.113549.1.9.9",             "EXTENDED_CERTIFICATE_ATTRIBUTES" },
    { "1.2.840.113549.1.9.10",            "ISSUER_AND_SERIAL_NUMBER" },
    { "1.2.840.113549.1.9.11",            "PASSWORD_CHECK" },
    { "1.2.840.113549.1.9.12",            "PUBLIC_KEY" },
    { "1.2.840.113549.1.9.13",            "SIGNING_DESCRIPTION" },
    { "1.2.840.113549.1.9.14",            "EXTENSION_REQUEST" },
    { "1.2.840.113549.1.9.15",            "S_MIME_CAPABILITIES" },
    { "1.2.840.113549.1.9.15.1",          "PREFER_SIGNED_DATA" },
    { "1.2.840.113549.1.9.15.2",          "CAN_NOT_DECRYPT_ANY" },
    { "1.2.840.113549.1.9.15.3",          "RECEIPT_REQUEST" },
    { "1.2.840.113549.1.9.15.4",          "RECEIPT" },
    { "1.2.840.113549.1.9.15.5",          "CONTENT_HINTS" },
    { "1.2.840.113549.1.9.15.6",          "ML_EXPANSION_HISTORY" },
    { "1.2.840.113549.1.9.16",            "ID_S_MIME" },
    { "1.2.840.113549.1.9.16.0",          "ID_MOD" },
    { "1.2.840.113549.1.9.16.0.1",        "ID_MOD_CMS" },
    { "1.2.840.113549.1.9.16.0.2",        "ID_MOD_ESS" },
    { "1.2.840.113549.1.9.16.0.3",        "ID_MOD_OID" },
    { "1.2.840.113549.1.9.16.0.4",        "ID_MOD_MSG_V3" },
    { "1.2.840.113549.1.9.16.0.5",        "ID_MOD_ETS_E_SIGNATURE_88" },
    { "1.2.840.113549.1.9.16.0.6",        "ID_MOD_ETS_E_SIGNATURE_97" },
    { "1.2.840.113549.1.9.16.0.7",        "ID_MOD_ETS_E_SIG_POLICY_88" },
    { "1.2.840.113549.1.9.16.0.8",        "ID_MOD_ETS_E_SIG_POLICY_88" },
    { "1.2.840.113549.1.9.16.1",          "CONTENT_TYPE" },
    { "1.2.840.113549.1.9.16.1.1",        "RECEIPT" },
    { "1.2.840.113549.1.9.16.1.2",        "AUTH_DATA" },
    { "1.2.840.113549.1.9.16.1.3",        "PUBLISH_CERT" },
    { "1.2.840.113549.1.9.16.1.4",        "T_ST_INFO" },
    { "1.2.840.113549.1.9.16.1.5",        "T_DT_INFO" },
    { "1.2.840.113549.1.9.16.1.6",        "CONTENT_INFO" },
    { "1.2.840.113549.1.9.16.1.7",        "D_VCS_REQUEST_DATA" },
    { "1.2.840.113549.1.9.16.1.8",        "D_VCS_RESPONSE_DATA" },
    { "1.2.840.113549.1.9.16.1.9",        "COMPRESSED_DATA" },
    { "1.2.840.113549.1.9.16.1.10",       "SCVP_CERT_VAL_REQUEST" },
    { "1.2.840.113549.1.9.16.1.11",       "SCVP_CERT_VAL_RESPONSE" },
    { "1.2.840.113549.1.9.16.1.12",       "SCVP_VAL_POL_REQUEST" },
    { "1.2.840.113549.1.9.16.1.13",       "SCVP_VAL_POL_RESPONSE" },
    { "1.2.840.113549.1.9.16.1.14",       "ATTR_CERT_ENC_ATTRS" },
    { "1.2.840.113549.1.9.16.1.15",       "T_S_REQ" },
    { "1.2.840.113549.1.9.16.1.16",       "FIRMWARE_PACKAGE" },
    { "1.2.840.113549.1.9.16.1.17",       "FIRMWARE_LOAD_RECEIPT" },
    { "1.2.840.113549.1.9.16.1.18",       "FIRMWARE_LOAD_ERROR" },
    { "1.2.840.113549.1.9.16.1.19",       "CONTENT_COLLECTION" },
    { "1.2.840.113549.1.9.16.1.20",       "CONTENT_WITH_ATTRS" },
    { "1.2.840.113549.1.9.16.1.21",       "ENC_KEY_WITH_ID" },
    { "1.2.840.113549.1.9.16.1.22",       "ENC_PEPSI" },
    { "1.2.840.113549.1.9.16.1.23",       "AUTH_ENVELOPED_DATA" },
    { "1.2.840.113549.1.9.16.1.24",       "ROUTE_ORIGIN_ATTEST" },
    { "1.2.840.113549.1.9.16.1.25",       "SYMMETRIC_KEY_PACKAGE" },
    { "1.2.840.113549.1.9.16.1.26",       "RPKI_MANIFEST" },
    { "1.2.840.113549.1.9.16.1.27",       "ASCII_TEXT_WITH_CRLF" },
    { "1.2.840.113549.1.9.16.1.28",       "XML" },
    { "1.2.840.113549.1.9.16.1.29",       "PDF" },
    { "1.2.840.113549.1.9.16.1.30",       "POSTSCRIPT" },
    { "1.2.840.113549.1.9.16.1.31",       "TIMESTAMPED_DATA" },
    { "1.2.840.113549.1.9.16.1.32",       "AS_ADJACENCY_ATTEST" },
    { "1.2.840.113549.1.9.16.1.33",       "RPKI_TRUST_ANCHOR" },
    { "1.2.840.113549.1.9.16.1.34",       "TRUST_ANCHOR_LIST" },
    { "1.2.840.113549.1.9.16.2",          "AUTHENTICATED_ATTRIBUTES" },
    { "1.2.840.113549.1.9.16.2.1",        "RECEIPT_REQUEST" },
    { "1.2.840.113549.1.9.16.2.2",        "SECURITY_LABEL" },
    { "1.2.840.113549.1.9.16.2.3",        "ML_EXPAND_HISTORY" },
    { "1.2.840.113549.1.9.16.2.4",        "CONTENT_HINT" },
    { "1.2.840.113549.1.9.16.2.5",        "MSG_SIG_DIGEST" },
    { "1.2.840.113549.1.9.16.2.6",        "ENCAP_CONTENT_TYPE" },
    { "1.2.840.113549.1.9.16.2.7",        "CONTENT_IDENTIFIER" },
    { "1.2.840.113549.1.9.16.2.8",        "MAC_VALUE" },
    { "1.2.840.113549.1.9.16.2.9",        "EQUIVALENT_LABELS" },
    { "1.2.840.113549.1.9.16.2.10",       "CONTENT_REFERENCE" },
    { "1.2.840.113549.1.9.16.2.11",       "ENCRYP_KEY_PREF" },
    { "1.2.840.113549.1.9.16.2.12",       "SIGNING_CERTIFICATE" },
    { "1.2.840.113549.1.9.16.2.13",       "SMIME_ENCRYPT_CERTS" },
    { "1.2.840.113549.1.9.16.2.14",       "TIME_STAMP_TOKEN" },
    { "1.2.840.113549.1.9.16.2.15",       "SIG_POLICY_ID" },
    { "1.2.840.113549.1.9.16.2.16",       "COMMITMENT_TYPE" },
    { "1.2.840.113549.1.9.16.2.17",       "SIGNER_LOCATION" },
    { "1.2.840.113549.1.9.16.2.18",       "SIGNER_ATTR" },
    { "1.2.840.113549.1.9.16.2.19",       "OTHER_SIG_CERT" },
    { "1.2.840.113549.1.9.16.2.20",       "CONTENT_TIMESTAMP" },
    { "1.2.840.113549.1.9.16.2.21",       "CERTIFICATE_REFS" },
    { "1.2.840.113549.1.9.16.2.22",       "REVOCATION_REFS" },
    { "1.2.840.113549.1.9.16.2.23",       "CERT_VALUES" },
    { "1.2.840.113549.1.9.16.2.24",       "REVOCATION_VALUES" },
    { "1.2.840.113549.1.9.16.2.25",       "ESC_TIME_STAMP" },
    { "1.2.840.113549.1.9.16.2.26",       "CERT_CRL_TIMESTAMP" },
    { "1.2.840.113549.1.9.16.2.27",       "ARCHIVE_TIME_STAMP" },
    { "1.2.840.113549.1.9.16.2.28",       "SIGNATURE_TYPE" },
    { "1.2.840.113549.1.9.16.2.29",       "DVCS_DVC" },
    { "1.2.840.113549.1.9.16.2.30",       "CEK_REFERENCE" },
    { "1.2.840.113549.1.9.16.2.31",       "MAX_CEK_DECRYPTS" },
    { "1.2.840.113549.1.9.16.2.32",       "KEK_DERIVATION_ALG" },
    { "1.2.840.113549.1.9.16.2.33",       "INTENDED_RECIPIENTS" },
    { "1.2.840.113549.1.9.16.2.34",       "CMC_UNSIGNED_DATA" },
    { "1.2.840.113549.1.9.16.2.35",       "FW_PACKAGE_ID" },
    { "1.2.840.113549.1.9.16.2.36",       "FW_TARGET_HARDWARE_I_DS" },
    { "1.2.840.113549.1.9.16.2.37",       "FW_DECRYPT_KEY_ID" },
    { "1.2.840.113549.1.9.16.2.38",       "FW_IMPL_CRYPT_ALGS" },
    { "1.2.840.113549.1.9.16.2.39",       "FW_WRAPPED_FIRMWARE_KEY" },
    { "1.2.840.113549.1.9.16.2.40",       "FW_COMMUNITY_IDENTIFIERS" },
    { "1.2.840.113549.1.9.16.2.41",       "FW_PKG_MESSAGE_DIGEST" },
    { "1.2.840.113549.1.9.16.2.42",       "FW_PACKAGE_INFO" },
    { "1.2.840.113549.1.9.16.2.43",       "FW_IMPL_COMPRESS_ALGS" },
    { "1.2.840.113549.1.9.16.2.44",       "ETS_ATTR_CERTIFICATE_REFS" },
    { "1.2.840.113549.1.9.16.2.45",       "ETS_ATTR_REVOCATION_REFS" },
    { "1.2.840.113549.1.9.16.2.46",       "BINARY_SIGNING_TIME" },
    { "1.2.840.113549.1.9.16.2.47",       "SIGNING_CERTIFICATE_V2" },
    { "1.2.840.113549.1.9.16.2.48",       "ETS_ARCHIVE_TIME_STAMP_V2" },
    { "1.2.840.113549.1.9.16.2.49",       "ER_INTERNAL" },
    { "1.2.840.113549.1.9.16.2.50",       "ER_EXTERNAL" },
    { "1.2.840.113549.1.9.16.2.51",       "MULTIPLE_SIGNATURES" },
    { "1.2.840.113549.1.9.16.3.1",        "ES_D_HWITH3_DES" },
    { "1.2.840.113549.1.9.16.3.2",        "ES_D_HWITH_RC2" },
    { "1.2.840.113549.1.9.16.3.3",        "3DES_WRAP" },
    { "1.2.840.113549.1.9.16.3.4",        "RC2_WRAP" },
    { "1.2.840.113549.1.9.16.3.5",        "ES_DH" },
    { "1.2.840.113549.1.9.16.3.6",        "CMS3_DE_SWRAP" },
    { "1.2.840.113549.1.9.16.3.7",        "CMS_RC2WRAP" },
    { "1.2.840.113549.1.9.16.3.8",        "ZLIB" },
    { "1.2.840.113549.1.9.16.3.9",        "PWRI_KEK" },
    { "1.2.840.113549.1.9.16.3.10",       "SS_DH" },
    { "1.2.840.113549.1.9.16.3.11",       "HMAC_WITH3_DE_SWRAP" },
    { "1.2.840.113549.1.9.16.3.12",       "HMAC_WITH_AE_SWRAP" },
    { "1.2.840.113549.1.9.16.3.13",       "MD5_XOR_EXPERIMENT" },
    { "1.2.840.113549.1.9.16.3.14",       "RSA_KEM" },
    { "1.2.840.113549.1.9.16.3.15",       "AUTH_ENC128" },
    { "1.2.840.113549.1.9.16.3.16",       "AUTH_ENC256" },
    { "1.2.840.113549.1.9.16.4.1",        "CERT_DIST_LDAP" },
    { "1.2.840.113549.1.9.16.5.1",        "SIG_POLICY_QUALIFIER_SPURI_X" },
    { "1.2.840.113549.1.9.16.5.2",        "SIG_POLICY_QUALIFIER_SP_USER_NOTICE" },
    { "1.2.840.113549.1.9.16.6.1",        "PROOF_OF_ORIGIN" },
    { "1.2.840.113549.1.9.16.6.2",        "PROOF_OF_RECEIPT" },
    { "1.2.840.113549.1.9.16.6.3",        "PROOF_OF_DELIVERY" },
    { "1.2.840.113549.1.9.16.6.4",        "PROOF_OF_SENDER" },
    { "1.2.840.113549.1.9.16.6.5",        "PROOF_OF_APPROVAL" },
    { "1.2.840.113549.1.9.16.6.6",        "PROOF_OF_CREATION" },
    { "1.2.840.113549.1.9.16.8.1",        "GL_USE_KEK" },
    { "1.2.840.113549.1.9.16.8.2",        "GL_DELETE" },
    { "1.2.840.113549.1.9.16.8.3",        "GL_ADD_MEMBER" },
    { "1.2.840.113549.1.9.16.8.4",        "GL_DELETE_MEMBER" },
    { "1.2.840.113549.1.9.16.8.5",        "GL_REKEY" },
    { "1.2.840.113549.1.9.16.8.6",        "GL_ADD_OWNER" },
    { "1.2.840.113549.1.9.16.8.7",        "GL_REMOVE_OWNER" },
    { "1.2.840.113549.1.9.16.8.8",        "GLK_COMPROMISE" },
    { "1.2.840.113549.1.9.16.8.9",        "GLK_REFRESH" },
    { "1.2.840.113549.1.9.16.8.10",       "GL_FAIL_INFO" },
    { "1.2.840.113549.1.9.16.8.11",       "GLA_QUERY_REQUEST" },
    { "1.2.840.113549.1.9.16.8.12",       "GLA_QUERY_RESPONSE" },
    { "1.2.840.113549.1.9.16.8.13",       "GL_PROVIDE_CERT" },
    { "1.2.840.113549.1.9.16.8.14",       "GL_UPDATE_CERT" },
    { "1.2.840.113549.1.9.16.8.15",       "GL_KEY" },
    { "1.2.840.113549.1.9.16.9",          "SIGNATURE_TYPE_IDENTIFIER" },
    { "1.2.840.113549.1.9.16.9.1",        "ORIGINATOR_SIG" },
    { "1.2.840.113549.1.9.16.9.2",        "DOMAIN_SIG" },
    { "1.2.840.113549.1.9.16.9.3",        "ADDITIONAL_ATTRIBUTES_SIG" },
    { "1.2.840.113549.1.9.16.9.4",        "REVIEW_SIG" },
    { "1.2.840.113549.1.9.16.11",         "CAPABILITIES" },
    { "1.2.840.113549.1.9.16.11.1",       "PREFER_BINARY_INSIDE" },
    { "1.2.840.113549.1.9.20",            "FRIENDLY_NAME_(FOR_PKCS_#12)" },
    { "1.2.840.113549.1.9.21",            "LOCAL_KEY_ID_(FOR_PKCS_#12)" },
    { "1.2.840.113549.1.9.22",            "CERT_TYPES_(FOR_PKCS_#12)" },
    { "1.2.840.113549.1.9.22.1",          "X509_CERTIFICATE_(FOR_PKCS_#12)" },
    { "1.2.840.113549.1.9.22.2",          "SDSI_CERTIFICATE_(FOR_PKCS_#12)" },
    { "1.2.840.113549.1.9.23",            "CRL_TYPES_(FOR_PKCS_#12)" },
    { "1.2.840.113549.1.9.23.1",          "X509_CRL_(FOR_PKCS_#12)" },
    { "1.2.840.113549.1.9.24",            "PKCS9OBJECT_CLASS" },
    { "1.2.840.113549.1.9.25",            "PKCS9ATTRIBUTES" },
    { "1.2.840.113549.1.9.25.1",          "PKCS15_TOKEN" },
    { "1.2.840.113549.1.9.25.2",          "ENCRYPTED_PRIVATE_KEY_INFO" },
    { "1.2.840.113549.1.9.25.3",          "RANDOM_NONCE" },
    { "1.2.840.113549.1.9.25.4",          "SEQUENCE_NUMBER" },
    { "1.2.840.113549.1.9.25.5",          "PKCS7_PDU" },
    { "1.2.840.113549.1.9.26",            "PKCS9SYNTAX" },
    { "1.2.840.113549.1.9.27",            "PKCS9MATCHING_RULES" },
    { "1.2.840.113549.1.12",              "PKCS_12" },
    { "1.2.840.113549.1.12.1",            "PKCS_12_PBE_IDS" },
    { "1.2.840.113549.1.12.1.1",          "PBE_WITH_SHA_AND128_BIT_RC4" },
    { "1.2.840.113549.1.12.1.2",          "PBE_WITH_SHA_AND40_BIT_RC4" },
    { "1.2.840.113549.1.12.1.3",          "PBE_WITH_SHA_AND3_KEY_TRIPLE_DES_CBC" },
    { "1.2.840.113549.1.12.1.4",          "PBE_WITH_SHA_AND2_KEY_TRIPLE_DES_CBC" },
    { "1.2.840.113549.1.12.1.5",          "PBE_WITH_SHA_AND128_BIT_RC2_CBC" },
    { "1.2.840.113549.1.12.1.6",          "PBE_WITH_SHA_AND40_BIT_RC2_CBC" },
    { "1.2.840.113549.1.12.2",            "PKCS_12_ESPVKID" },
    { "1.2.840.113549.1.12.2.1",          "PKCS_12_PKCS8_KEY_SHROUDING" },
    { "1.2.840.113549.1.12.3",            "PKCS_12_BAG_IDS" },
    { "1.2.840.113549.1.12.3.1",          "PKCS_12_KEY_BAG_ID" },
    { "1.2.840.113549.1.12.3.2",          "PKCS_12_CERT_AND_CRL_BAG_ID" },
    { "1.2.840.113549.1.12.3.3",          "PKCS_12_SECRET_BAG_ID" },
    { "1.2.840.113549.1.12.3.4",          "PKCS_12_SAFE_CONTENTS_ID" },
    { "1.2.840.113549.1.12.3.5",          "PKCS_12_PKCS_8_SHROUDED_KEY_BAG_ID" },
    { "1.2.840.113549.1.12.4",            "PKCS_12_CERT_BAG_ID" },
    { "1.2.840.113549.1.12.4.1",          "PKCS_12_X509_CERT_CRL_BAG_ID" },
    { "1.2.840.113549.1.12.4.2",          "PKCS_12_SDSI_CERT_BAG_ID" },
    { "1.2.840.113549.1.12.5",            "PKCS_12_OID" },
    { "1.2.840.113549.1.12.5.1",          "PKCS_12_PBEID" },
    { "1.2.840.113549.1.12.5.1.1",        "PKCS_12_PBE_WITH_SHA1_AND128_BIT_RC4" },
    { "1.2.840.113549.1.12.5.1.2",        "PKCS_12_PBE_WITH_SHA1_AND40_BIT_RC4" },
    { "1.2.840.113549.1.12.5.1.3",        "PKCS_12_PBE_WITH_SHA1_AND_TRIPLE_DESCBC" },
    { "1.2.840.113549.1.12.5.1.4",        "PKCS_12_PBE_WITH_SHA1_AND128_BIT_RC2_CBC" },
    { "1.2.840.113549.1.12.5.1.5",        "PKCS_12_PBE_WITH_SHA1_AND40_BIT_RC2_CBC" },
    { "1.2.840.113549.1.12.5.1.6",        "PKCS_12_PBE_WITH_SHA1_AND_RC4" },
    { "1.2.840.113549.1.12.5.1.7",        "PKCS_12_PBE_WITH_SHA1_AND_RC2_CBC" },
    { "1.2.840.113549.1.12.5.2",          "PKCS_12_ENVELOPING_ID" },
    { "1.2.840.113549.1.12.5.2.1",        "PKCS_12_RSA_ENCRYPTION_WITH128_BIT_RC4" },
    { "1.2.840.113549.1.12.5.2.2",        "PKCS_12_RSA_ENCRYPTION_WITH40_BIT_RC4" },
    { "1.2.840.113549.1.12.5.2.3",        "PKCS_12_RSA_ENCRYPTION_WITH_TRIPLE_DES" },
    { "1.2.840.113549.1.12.5.3",          "PKCS_12_SIGNATURE_ID" },
    { "1.2.840.113549.1.12.5.3.1",        "PKCS_12_RSA_SIGNATURE_WITH_SHA1_DIGEST" },
    { "1.2.840.113549.1.12.10",           "PKCS_12_VERSION1" },
    { "1.2.840.113549.1.12.10.1",         "PKCS_12_BAD_IDS" },
    { "1.2.840.113549.1.12.10.1.1",       "PKCS_12_KEY_BAG" },
    { "1.2.840.113549.1.12.10.1.2",       "PKCS_12_PKCS_8_SHROUDED_KEY_BAG" },
    { "1.2.840.113549.1.12.10.1.3",       "PKCS_12_CERT_BAG" },
    { "1.2.840.113549.1.12.10.1.4",       "PKCS_12_CRL_BAG" },
    { "1.2.840.113549.1.12.10.1.5",       "PKCS_12_SECRET_BAG" },
    { "1.2.840.113549.1.12.10.1.6",       "PKCS_12_SAFE_CONTENTS_BAG" },
    { "1.2.840.113549.1.15.1",            "PKCS15MODULES" },
    { "1.2.840.113549.1.15.2",            "PKCS15ATTRIBUTES" },
    { "1.2.840.113549.1.15.3",            "PKCS15CONTENT_TYPE" },
    { "1.2.840.113549.1.15.3.1",          "PKCS15CONTENT" },
    { "1.2.840.113549.2",                 "DIGEST_ALGORITHM" },
    { "1.2.840.113549.2.2",               "MD2" },
    { "1.2.840.113549.2.4",               "MD4" },
    { "1.2.840.113549.2.5",               "MD5" },
    { "1.2.840.113549.2.7",               "HMAC_WITH_SHA1" },
    { "1.2.840.113549.2.8",               "HMAC_WITH_SHA224" },
    { "1.2.840.113549.2.9",               "HMAC_WITH_SHA256" },
    { "1.2.840.113549.2.10",              "HMAC_WITH_SHA384" },
    { "1.2.840.113549.2.11",              "HMAC_WITH_SHA512" },
    { "1.2.840.113549.3",                 "ENCRYPTION_ALGORITHM" },
    { "1.2.840.113549.3.2",               "RC2_CBC" },
    { "1.2.840.113549.3.3",               "RC2_ECB" },
    { "1.2.840.113549.3.4",               "RC4" },
    { "1.2.840.113549.3.5",               "RC4_WITH_MAC" },
    { "1.2.840.113549.3.6",               "DESX_CBC" },
    { "1.2.840.113549.3.7",               "DES_EDE3_CBC" },
    { "1.2.840.113549.3.8",               "RC5_CBC" },
    { "1.2.840.113549.3.9",               "RC5_CBC_PAD" },
    { "1.2.840.113549.3.10",              "DES_CDMF" },
    { "1.2.840.114021.1.6.1",             "IDENTRUS_UNKNOWN_POLICY_IDENTIFIER" },
    { "1.2.840.114021.4.1",               "IDENTRUS_OCSP" },
    { "1.2.840.113556.1.2.241",           "DELIVERY_MECHANISM" },
    { "1.2.840.113556.1.2.281",           "NT_SECURITY_DESCRIPTOR" },
    { "1.2.840.113556.1.3.0",             "SITE_ADDRESSING" },
    { "1.2.840.113556.1.3.13",            "CLASS_SCHEMA" },
    { "1.2.840.113556.1.3.14",            "ATTRIBUTE_SCHEMA" },
    { "1.2.840.113556.1.3.17",            "MAILBOX_AGENT" },
    { "1.2.840.113556.1.3.22",            "MAILBOX" },
    { "1.2.840.113556.1.3.23",            "CONTAINER" },
    { "1.2.840.113556.1.3.46",            "MAIL_RECIPIENT" },
    { "1.2.840.113556.1.4.145",           "REVISION" },
    { "1.2.840.113556.1.4.1327",          "P_KI_DEFAULT_KEY_SPEC" },
    { "1.2.840.113556.1.4.1328",          "P_KI_KEY_USAGE" },
    { "1.2.840.113556.1.4.1329",          "P_KI_MAX_ISSUING_DEPTH" },
    { "1.2.840.113556.1.4.1330",          "P_KI_CRITICAL_EXTENSIONS" },
    { "1.2.840.113556.1.4.1331",          "P_KI_EXPIRATION_PERIOD" },
    { "1.2.840.113556.1.4.1332",          "P_KI_OVERLAP_PERIOD" },
    { "1.2.840.113556.1.4.1333",          "P_KI_EXTENDED_KEY_USAGE" },
    { "1.2.840.113556.1.4.1334",          "P_KI_DEFAULT_CS_PS" },
    { "1.2.840.113556.1.4.1335",          "P_KI_ENROLLMENT_ACCESS" },
    { "1.2.840.113556.1.4.1429",          "MS_PKI_RA_SIGNATURE" },
    { "1.2.840.113556.1.4.1430",          "MS_PKI_ENROLLMENT_FLAG" },
    { "1.2.840.113556.1.4.1431",          "MS_PKI_PRIVATE_KEY_FLAG" },
    { "1.2.840.113556.1.4.1432",          "MS_PKI_CERTIFICATE_NAME_FLAG" },
    { "1.2.840.113556.1.4.1433",          "MS_PKI_MINIMAL_KEY_SIZE" },
    { "1.2.840.113556.1.4.1434",          "MS_PKI_TEMPLATE_SCHEMA_VERSION" },
    { "1.2.840.113556.1.4.1435",          "MS_PKI_TEMPLATE_MINOR_REVISION" },
    { "1.2.840.113556.1.4.1436",          "MS_PKI_CERT_TEMPLATE_OID" },
    { "1.2.840.113556.1.4.1437",          "MS_PKI_SUPERSEDE_TEMPLATES" },
    { "1.2.840.113556.1.4.1438",          "MS_PKI_RA_POLICIES" },
    { "1.2.840.113556.1.4.1439",          "MS_PKI_CERTIFICATE_POLICY" },
    { "1.2.840.113556.1.4.1674",          "MS_PKI_CERTIFICATE_APPLICATION_POLICY" },
    { "1.2.840.113556.1.4.1675",          "MS_PKI_RA_APPLICATION_POLICIES" },
    { "1.2.840.113556.4.3",               "MICROSOFT_EXCEL" },
    { "1.2.840.113556.4.4",               "TITLED_WITH_OID" },
    { "1.2.840.113556.4.5",               "MICROSOFT_POWER_POINT" },
    { "1.2.840.113583.1",                 "ADOBE_ACROBAT" },
    { "1.2.840.113583.1.1",               "ACROBAT_SECURITY" },
    { "1.2.840.113583.1.1.1",             "PDF_PASSWORD" },
    { "1.2.840.113583.1.1.2",             "PDF_DEFAULT_SIGNING_CREDENTIAL" },
    { "1.2.840.113583.1.1.3",             "PDF_DEFAULT_ENCRYPTION_CREDENTIAL" },
    { "1.2.840.113583.1.1.4",             "PDF_PASSWORD_TIMEOUT" },
    { "1.2.840.113583.1.1.5",             "PDF_AUTHENTIC_DOCUMENTS_TRUST" },
    { "1.2.840.113583.1.1.6",             "PDF_DYNAMIC_CONTENT_TRUST" },
    { "1.2.840.113583.1.1.7",             "PDF_UBIQUITY_TRUST" },
    { "1.2.840.113583.1.1.8",             "PDF_REVOCATION_INFO_ARCHIVAL" },
    { "1.2.840.113583.1.1.9",             "PDF_X509_EXTENSION" },
    { "1.2.840.113583.1.1.9.1",           "PDF_TIME_STAMP" },
    { "1.2.840.113583.1.1.9.2",           "PDF_ARCHIVE_REV_INFO" },
    { "1.2.840.113583.1.1.10",            "PDF_PPLK_LITE_CREDENTIAL" },
    { "1.2.840.113583.1.2.",              "ACROBAT_CPS" },
    { "1.2.840.113583.1.2.1",             "PDF_AUTHENTIC_DOCUMENTS_CPS" },
    { "1.2.840.113583.1.2.2",             "PDF_TEST_CPS" },
    { "1.2.840.113583.1.2.3",             "PDF_UBIQUITY_CPS" },
    { "1.2.840.113583.1.2.4",             "PDF_ADHOC_CPS" },
    { "1.2.840.113583.1.7",               "ACROBAT_UBIQUITY" },
    { "1.2.840.113583.1.7.1",             "PDF_UBIQUITY_SUB_RIGHTS" },
    { "1.2.840.113583.1.9",               "ACROBAT_EXTENSION" },
    { "1.2.840.113628.114.1.7",           "ADOBE_PKCS7" },
    { "1.2.840.113635.100",               "APPLE_DATA_SECURITY" },
    { "1.2.840.113635.100.1",             "APPLE_TRUST_POLICY" },
    { "1.2.840.113635.100.1.1",           "APPLE_I_SIGN_TP" },
    { "1.2.840.113635.100.1.2",           "APPLE_X509_BASIC" },
    { "1.2.840.113635.100.1.3",           "APPLE_SSL_POLICY" },
    { "1.2.840.113635.100.1.4",           "APPLE_LOCAL_CERT_GEN_POLICY" },
    { "1.2.840.113635.100.1.5",           "APPLE_CSR_GEN_POLICY" },
    { "1.2.840.113635.100.1.6",           "APPLE_CRL_POLICY" },
    { "1.2.840.113635.100.1.7",           "APPLE_OCSP_POLICY" },
    { "1.2.840.113635.100.1.8",           "APPLE_SMIME_POLICY" },
    { "1.2.840.113635.100.1.9",           "APPLE_EAP_POLICY" },
    { "1.2.840.113635.100.1.10",          "APPLE_SW_UPDATE_SIGNING_POLICY" },
    { "1.2.840.113635.100.1.11",          "APPLE_IP_SEC_POLICY" },
    { "1.2.840.113635.100.1.12",          "APPLE_I_CHAT_POLICY" },
    { "1.2.840.113635.100.1.13",          "APPLE_RESOURCE_SIGN_POLICY" },
    { "1.2.840.113635.100.1.14",          "APPLE_PKINIT_CLIENT_POLICY" },
    { "1.2.840.113635.100.1.15",          "APPLE_PKINIT_SERVER_POLICY" },
    { "1.2.840.113635.100.1.16",          "APPLE_CODE_SIGNING_POLICY" },
    { "1.2.840.113635.100.1.17",          "APPLE_PACKAGE_SIGNING_POLICY" },
    { "1.2.840.113635.100.2",             "APPLE_SECURITY_ALGORITHM" },
    { "1.2.840.113635.100.2.1",           "APPLE_FEE" },
    { "1.2.840.113635.100.2.2",           "APPLE_ASC" },
    { "1.2.840.113635.100.2.3",           "APPLE_FEE_MD5" },
    { "1.2.840.113635.100.2.4",           "APPLE_FEE_SHA1" },
    { "1.2.840.113635.100.2.5",           "APPLE_FEED" },
    { "1.2.840.113635.100.2.6",           "APPLE_FEEDEXP" },
    { "1.2.840.113635.100.2.7",           "APPLE_ECDSA" },
    { "1.2.840.113635.100.3",             "APPLE_DOT_MAC_CERTIFICATE" },
    { "1.2.840.113635.100.3.1",           "APPLE_DOT_MAC_CERTIFICATE_REQUEST" },
    { "1.2.840.113635.100.3.2",           "APPLE_DOT_MAC_CERTIFICATE_EXTENSION" },
    { "1.2.840.113635.100.3.3",           "APPLE_DOT_MAC_CERTIFICATE_REQUEST_VALUES" },
    { "1.2.840.113635.100.4",             "APPLE_EXTENDED_KEY_USAGE" },
    { "1.2.840.113635.100.4.1",           "APPLE_CODE_SIGNING" },
    { "1.2.840.113635.100.4.1.1",         "APPLE_CODE_SIGNING_DEVELOPMENT" },
    { "1.2.840.113635.100.4.1.2",         "APPLE_SOFTWARE_UPDATE_SIGNING" },
    { "1.2.840.113635.100.4.1.3",         "APPLE_CODE_SIGNING_THIRD_PARTY" },
    { "1.2.840.113635.100.4.1.4",         "APPLE_RESOURCE_SIGNING" },
    { "1.2.840.113635.100.4.2",           "APPLE_I_CHAT_SIGNING" },
    { "1.2.840.113635.100.4.3",           "APPLE_I_CHAT_ENCRYPTION" },
    { "1.2.840.113635.100.4.4",           "APPLE_SYSTEM_IDENTITY" },
    { "1.2.840.113635.100.4.5",           "APPLE_CRYPTO_ENV" },
    { "1.2.840.113635.100.4.5.1",         "APPLE_CRYPTO_PRODUCTION_ENV" },
    { "1.2.840.113635.100.4.5.2",         "APPLE_CRYPTO_MAINTENANCE_ENV" },
    { "1.2.840.113635.100.4.5.3",         "APPLE_CRYPTO_TEST_ENV" },
    { "1.2.840.113635.100.4.5.4",         "APPLE_CRYPTO_DEVELOPMENT_ENV" },
    { "1.2.840.113635.100.4.6",           "APPLE_CRYPTO_QO_S" },
    { "1.2.840.113635.100.4.6.1",         "APPLE_CRYPTO_TIER0_QO_S" },
    { "1.2.840.113635.100.4.6.2",         "APPLE_CRYPTO_TIER1_QO_S" },
    { "1.2.840.113635.100.4.6.3",         "APPLE_CRYPTO_TIER2_QO_S" },
    { "1.2.840.113635.100.4.6.4",         "APPLE_CRYPTO_TIER3_QO_S" },
    { "1.2.840.113635.100.5",             "APPLE_CERTIFICATE_POLICIES" },
    { "1.2.840.113635.100.5.1",           "APPLE_CERTIFICATE_POLICY_ID" },
    { "1.2.840.113635.100.5.2",           "APPLE_DOT_MAC_CERTIFICATE_POLICY_ID" },
    { "1.2.840.113635.100.5.3",           "APPLE_ADC_CERTIFICATE_POLICY_ID" },
    { "1.2.840.113635.100.6",             "APPLE_CERTIFICATE_EXTENSIONS" },
    { "1.2.840.113635.100.6.1",           "APPLE_CERTIFICATE_EXTENSION_CODE_SIGNING" },
    { "1.2.840.113635.100.6.1.1",         "APPLE_CERTIFICATE_EXTENSION_APPLE_SIGNING" },
    { "1.2.840.113635.100.6.1.2",         "APPLE_CERTIFICATE_EXTENSION_ADC_DEVELOPER_SIGNING" },
    { "1.2.840.113635.100.6.1.3",         "APPLE_CERTIFICATE_EXTENSION_ADC_APPLE_SIGNING" },
    { "1.3.6.1.4.1.311.2.1.4",            "SPC_INDIRECT_DATA_CONTEXT" },
    { "1.3.6.1.4.1.311.2.1.10",           "SPC_AGENCY_INFO" },
    { "1.3.6.1.4.1.311.2.1.11",           "SPC_STATEMENT_TYPE" },
    { "1.3.6.1.4.1.311.2.1.12",           "SPC_SP_OPUS_INFO" },
    { "1.3.6.1.4.1.311.2.1.14",           "CERT_REQ_EXTENSIONS" },
    { "1.3.6.1.4.1.311.2.1.15",           "SPC_PE_IMAGE_DATA" },
    { "1.3.6.1.4.1.311.2.1.18",           "SPC_RAW_FILE_DATA" },
    { "1.3.6.1.4.1.311.2.1.19",           "SPC_STRUCTURED_STORAGE_DATA" },
    { "1.3.6.1.4.1.311.2.1.20",           "SPC_JAVA_CLASS_DATA_(TYPE_1)" },
    { "1.3.6.1.4.1.311.2.1.21",           "INDIVIDUAL_CODE_SIGNING" },
    { "1.3.6.1.4.1.311.2.1.22",           "COMMERCIAL_CODE_SIGNING" },
    { "1.3.6.1.4.1.311.2.1.25",           "SPC_LINK_(TYPE_2)" },
    { "1.3.6.1.4.1.311.2.1.26",           "SPC_MINIMAL_CRITERIA_INFO" },
    { "1.3.6.1.4.1.311.2.1.27",           "SPC_FINANCIAL_CRITERIA_INFO" },
    { "1.3.6.1.4.1.311.2.1.28",           "SPC_LINK_(TYPE_3)" },
    { "1.3.6.1.4.1.311.2.1.29",           "SPC_HASH_INFO_OBJ_ID" },
    { "1.3.6.1.4.1.311.2.1.30",           "SPC_SIP_INFO_OBJ_ID" },
    { "1.3.6.1.4.1.311.2.2",              "CTL" },
    { "1.3.6.1.4.1.311.2.2.1",            "CTL_TRUSTED_CODESIGNING_CA_LIST" },
    { "1.3.6.1.4.1.311.2.2.2",            "CTL_TRUSTED_CLIENT_AUTH_CA_LIST" },
    { "1.3.6.1.4.1.311.2.2.3",            "CTL_TRUSTED_SERVER_AUTH_CA_LIST" },
    { "1.3.6.1.4.1.311.3.2.1",            "TIMESTAMP_REQUEST" },
    { "1.3.6.1.4.1.311.10.1",             "CERT_TRUST_LIST" },
    { "1.3.6.1.4.1.311.10.1.1",           "SORTED_CTL" },
    { "1.3.6.1.4.1.311.10.2",             "NEXT_UPDATE_LOCATION" },
    { "1.3.6.1.4.1.311.10.3.1",           "CERT_TRUST_LIST_SIGNING" },
    { "1.3.6.1.4.1.311.10.3.2",           "TIME_STAMP_SIGNING" },
    { "1.3.6.1.4.1.311.10.3.3",           "SERVER_GATED_CRYPTO" },
    { "1.3.6.1.4.1.311.10.3.3.1",         "SERIALIZED" },
    { "1.3.6.1.4.1.311.10.3.4",           "ENCRYPTED_FILE_SYSTEM" },
    { "1.3.6.1.4.1.311.10.3.5",           "WHQL_CRYPTO" },
    { "1.3.6.1.4.1.311.10.3.6",           "NT5_CRYPTO" },
    { "1.3.6.1.4.1.311.10.3.7",           "OEM_WHQL_CRYPTO" },
    { "1.3.6.1.4.1.311.10.3.8",           "EMBEDDED_NT_CRYPTO" },
    { "1.3.6.1.4.1.311.10.3.9",           "ROOT_LIST_SIGNER" },
    { "1.3.6.1.4.1.311.10.3.10",          "QUALIFIED_SUBORDINATION" },
    { "1.3.6.1.4.1.311.10.3.11",          "KEY_RECOVERY" },
    { "1.3.6.1.4.1.311.10.3.12",          "DOCUMENT_SIGNING" },
    { "1.3.6.1.4.1.311.10.3.13",          "LIFETIME_SIGNING" },
    { "1.3.6.1.4.1.311.10.3.14",          "MOBILE_DEVICE_SOFTWARE" },
    { "1.3.6.1.4.1.311.10.3.15",          "SMART_DISPLAY" },
    { "1.3.6.1.4.1.311.10.3.16",          "CSP_SIGNATURE" },
    { "1.3.6.1.4.1.311.10.3.4.1",         "EFS_RECOVERY" },
    { "1.3.6.1.4.1.311.10.4.1",           "YESNO_TRUST_ATTR" },
    { "1.3.6.1.4.1.311.10.5.1",           "DRM" },
    { "1.3.6.1.4.1.311.10.5.2",           "DRM_INDIVIDUALIZATION" },
    { "1.3.6.1.4.1.311.10.6.1",           "LICENSES" },
    { "1.3.6.1.4.1.311.10.6.2",           "LICENSE_SERVER" },
    { "1.3.6.1.4.1.311.10.7.1",           "KEYID_RDN" },
    { "1.3.6.1.4.1.311.10.8.1",           "REMOVE_CERTIFICATE" },
    { "1.3.6.1.4.1.311.10.9.1",           "CROSS_CERT_DIST_POINTS" },
    { "1.3.6.1.4.1.311.10.10.1",          "CMC_ADD_ATTRIBUTES" },
    { "1.3.6.1.4.1.311.10.11",            "CERT_PROP_ID_PREFIX" },
    { "1.3.6.1.4.1.311.10.11.4",          "CERT_MD5_HASH_PROP_ID" },
    { "1.3.6.1.4.1.311.10.11.20",         "CERT_KEY_IDENTIFIER_PROP_ID" },
    { "1.3.6.1.4.1.311.10.11.28",         "CERT_ISSUER_SERIAL_NUMBER_MD5_HASH_PROP_ID" },
    { "1.3.6.1.4.1.311.10.11.29",         "CERT_SUBJECT_NAME_MD5_HASH_PROP_ID" },
    { "1.3.6.1.4.1.311.10.12.1",          "ANY_APPLICATION_POLICY" },
    { "1.3.6.1.4.1.311.12",               "CATALOG" },
    { "1.3.6.1.4.1.311.12.1.1",           "CATALOG_LIST" },
    { "1.3.6.1.4.1.311.12.1.2",           "CATALOG_LIST_MEMBER" },
    { "1.3.6.1.4.1.311.12.2.1",           "CATALOG_NAME_VALUE_OBJ_ID" },
    { "1.3.6.1.4.1.311.12.2.2",           "CATALOG_MEMBER_INFO_OBJ_ID" },
    { "1.3.6.1.4.1.311.13.1",             "RENEWAL_CERTIFICATE" },
    { "1.3.6.1.4.1.311.13.2.1",           "ENROLMENT_NAME_VALUE_PAIR" },
    { "1.3.6.1.4.1.311.13.2.2",           "ENROLMENT_CSP" },
    { "1.3.6.1.4.1.311.13.2.3",           "OS_VERSION" },
    { "1.3.6.1.4.1.311.16.4",             "MICROSOFT_RECIPIENT_INFO" },
    { "1.3.6.1.4.1.311.17.1",             "PKCS12_KEY_PROVIDER_NAME_ATTR" },
    { "1.3.6.1.4.1.311.17.2",             "LOCAL_MACHINE_KEYSET" },
    { "1.3.6.1.4.1.311.17.3",             "PKCS12_EXTENDED_ATTRIBUTES" },
    { "1.3.6.1.4.1.311.20.1",             "AUTO_ENROLL_CTL_USAGE" },
    { "1.3.6.1.4.1.311.20.2",             "ENROLL_CERTTYPE_EXTENSION" },
    { "1.3.6.1.4.1.311.20.2.1",           "ENROLLMENT_AGENT" },
    { "1.3.6.1.4.1.311.20.2.2",           "SMARTCARD_LOGON" },
    { "1.3.6.1.4.1.311.20.2.3",           "UNIVERSAL_PRINCIPAL_NAME" },
    { "1.3.6.1.4.1.311.20.3",             "CERT_MANIFOLD" },
    { "1.3.6.1.4.1.311.21.1",             "C_A_KEY_CERT_INDEX_PAIR" },
    { "1.3.6.1.4.1.311.21.2",             "CERT_SRV_PREVIOUS_CERT_HASH" },
    { "1.3.6.1.4.1.311.21.3",             "CRL_VIRTUAL_BASE" },
    { "1.3.6.1.4.1.311.21.4",             "CRL_NEXT_PUBLISH" },
    { "1.3.6.1.4.1.311.21.5",             "CA_EXCHANGE" },
    { "1.3.6.1.4.1.311.21.6",             "KEY_RECOVERY" },
    { "1.3.6.1.4.1.311.21.7",             "CERTIFICATE_TEMPLATE" },
    { "1.3.6.1.4.1.311.21.9",             "RDN_DUMMY_SIGNER" },
    { "1.3.6.1.4.1.311.21.10",            "APPLICATION_CERT_POLICIES" },
    { "1.3.6.1.4.1.311.21.11",            "APPLICATION_POLICY_MAPPINGS" },
    { "1.3.6.1.4.1.311.21.12",            "APPLICATION_POLICY_CONSTRAINTS" },
    { "1.3.6.1.4.1.311.21.13",            "ARCHIVED_KEY" },
    { "1.3.6.1.4.1.311.21.14",            "CRL_SELF_CDP" },
    { "1.3.6.1.4.1.311.21.15",            "REQUIRE_CERT_CHAIN_POLICY" },
    { "1.3.6.1.4.1.311.21.16",            "ARCHIVED_KEY_CERT_HASH" },
    { "1.3.6.1.4.1.311.21.17",            "ISSUED_CERT_HASH" },
    { "1.3.6.1.4.1.311.21.19",            "DS_EMAIL_REPLICATION" },
    { "1.3.6.1.4.1.311.21.20",            "REQUEST_CLIENT_INFO" },
    { "1.3.6.1.4.1.311.21.21",            "ENCRYPTED_KEY_HASH" },
    { "1.3.6.1.4.1.311.21.22",            "CERTSRV_CROSS_CA_VERSION" },
    { "1.3.6.1.4.1.311.25.1",             "NTDS_REPLICATION" },
    { "1.3.6.1.4.1.311.31.1",             "PRODUCT_UPDATE" },
    { "1.3.6.1.4.1.311.47.1.1",           "SYSTEM_HEALTH" },
    { "1.3.6.1.4.1.311.47.1.3",           "SYSTEM_HEALTH_LOOPHOLE" },
    { "1.3.6.1.4.1.311.60.1.1",           "ROOT_PROGRAM_FLAGS" },
    { "1.3.6.1.4.1.311.61.1.1",           "KERNEL_MODE_CODE_SIGNING" },
    { "1.3.6.1.4.1.311.60.2.1.1",         "JURISDICTION_OF_INCORPORATION_L" },
    { "1.3.6.1.4.1.311.60.2.1.2",         "JURISDICTION_OF_INCORPORATION_SP" },
    { "1.3.6.1.4.1.311.60.2.1.3",         "JURISDICTION_OF_INCORPORATION_C" },
    { "1.3.6.1.4.1.311.88",               "CAPI_COM" },
    { "1.3.6.1.4.1.311.88.1",             "CAPI_COM_VERSION" },
    { "1.3.6.1.4.1.311.88.2",             "CAPI_COM_ATTRIBUTE" },
    { "1.3.6.1.4.1.311.88.2.1",           "CAPI_COM_DOCUMENT_NAME" },
    { "1.3.6.1.4.1.311.88.2.2",           "CAPI_COM_DOCUMENT_DESCRIPTION" },
    { "1.3.6.1.4.1.311.88.3",             "CAPI_COM_ENCRYPTED_DATA" },
    { "1.3.6.1.4.1.311.88.3.1",           "CAPI_COM_ENCRYPTED_CONTENT" },
    { "1.3.6.1.4.1.188.7.1.1",            "ASCOM" },
    { "1.3.6.1.4.1.188.7.1.1.1",          "IDEA_ECB" },
    { "1.3.6.1.4.1.188.7.1.1.2",          "IDEA_CBC" },
    { "1.3.6.1.4.1.188.7.1.1.3",          "IDEA_CFB" },
    { "1.3.6.1.4.1.188.7.1.1.4",          "IDEA_OFB" },
    { "1.3.6.1.4.1.2428.10.1.1",          "UNINETT_POLICY_IDENTIFIER" },
    { "1.3.6.1.4.1.2712.10",              "ICE_TEL_POLICY_IDENTIFIER" },
    { "1.3.6.1.4.1.2786.1.1.1",           "ICE_TEL_ITALIAN_POLICY_IDENTIFIER" },
    { "1.3.6.1.4.1.3029.1.1.1",           "BLOWFISH_ECB" },
    { "1.3.6.1.4.1.3029.1.1.2",           "BLOWFISH_CBC" },
    { "1.3.6.1.4.1.3029.1.1.3",           "BLOWFISH_CFB" },
    { "1.3.6.1.4.1.3029.1.1.4",           "BLOWFISH_OFB" },
    { "1.3.6.1.4.1.3029.1.2.1",           "ELGAMAL" },
    { "1.3.6.1.4.1.3029.1.2.1.1",         "ELGAMAL_WITH_SHA_1" },
    { "1.3.6.1.4.1.3029.1.2.1.2",         "ELGAMAL_WITH_RIPEMD_160" },
    { "1.3.6.1.4.1.3029.3.1.1",           "CRYPTLIB_PRESENCE_CHECK" },
    { "1.3.6.1.4.1.3029.3.1.2",           "PKI_BOOT" },
    { "1.3.6.1.4.1.3029.3.1.4",           "CRL_EXT_REASON" },
    { "1.3.6.1.4.1.3029.3.1.5",           "KEY_FEATURES" },
    { "1.3.6.1.4.1.3029.4.1",             "CRYPTLIB_CONTENT" },
    { "1.3.6.1.4.1.3029.4.1.1",           "CRYPTLIB_CONFIG_DATA" },
    { "1.3.6.1.4.1.3029.4.1.2",           "CRYPTLIB_USER_INDEX" },
    { "1.3.6.1.4.1.3029.4.1.3",           "CRYPTLIB_USER_INFO" },
    { "1.3.6.1.4.1.3029.4.1.4",           "RTCS_REQUEST" },
    { "1.3.6.1.4.1.3029.4.1.5",           "RTCS_RESPONSE" },
    { "1.3.6.1.4.1.3029.4.1.6",           "RTCS_RESPONSE_EXT" },
    { "1.3.6.1.4.1.3029.42.11172.1",      "MPEG_1" },
    { "1.3.6.1.4.1.3029.54.11940.54",     "TSA_POLICY" },
    { "1.3.6.1.4.1.3029.88.89.90.90.89",  "X_YZZY_POLICY_IDENTIFIER" },
    { "1.3.6.1.4.1.3401.8.1.1",           "PGP_EXTENSION" },
    { "1.3.6.1.4.1.3576.7",               "ECIA_ASC_X12_EDI" },
    { "1.3.6.1.4.1.3576.7.1",             "PLAIN_ED_IMESSAGE" },
    { "1.3.6.1.4.1.3576.7.2",             "SIGNED_ED_IMESSAGE" },
    { "1.3.6.1.4.1.3576.7.5",             "INTEGRITY_ED_IMESSAGE" },
    { "1.3.6.1.4.1.3576.7.65",            "IA_RECEIPT_MESSAGE" },
    { "1.3.6.1.4.1.3576.7.97",            "IA_STATUS_MESSAGE" },
    { "1.3.6.1.4.1.3576.8",               "ECIA_EDIFACT" },
    { "1.3.6.1.4.1.3576.9",               "ECIA_NON_EDI" },
    { "1.3.6.1.4.1.4146",                 "GLOBALSIGN" },
    { "1.3.6.1.4.1.4146.1",               "GLOBALSIGN_POLICY" },
    { "1.3.6.1.4.1.4146.1.10",            "GLOBALSIGN_DV_POLICY" },
    { "1.3.6.1.4.1.4146.1.20",            "GLOBALSIGN_OV_POLICY" },
    { "1.3.6.1.4.1.4146.1.30",            "GLOBALSIGN_TSA_POLICY" },
    { "1.3.6.1.4.1.4146.1.40",            "GLOBALSIGN_CLIENT_CERT_POLICY" },
    { "1.3.6.1.4.1.4146.1.50",            "GLOBALSIGN_CODE_SIGN_POLICY" },
    { "1.3.6.1.4.1.4146.1.60",            "GLOBALSIGN_ROOT_SIGN_POLICY" },
    { "1.3.6.1.4.1.4146.1.70",            "GLOBALSIGN_TRUSTED_ROOT_POLICY" },
    { "1.3.6.1.4.1.4146.1.80",            "GLOBALSIGN_EDI_CLIENT_POLICY" },
    { "1.3.6.1.4.1.4146.1.81",            "GLOBALSIGN_EDI_SERVER_POLICY" },
    { "1.3.6.1.4.1.4146.1.90",            "GLOBALSIGN_TPM_ROOT_POLICY" },
    { "1.3.6.1.4.1.4146.1.95",            "GLOBALSIGN_OCSP_POLICY" },
    { "1.3.6.1.4.1.5309.1",               "EDEL_WEB_POLICY" },
    { "1.3.6.1.4.1.5309.1.2",             "EDEL_WEB_CUSTOMER_POLICY" },
    { "1.3.6.1.4.1.5309.1.2.1",           "EDEL_WEB_CLEPSYDRE_POLICY" },
    { "1.3.6.1.4.1.5309.1.2.2",           "EDEL_WEB_EXPERIMENTAL_TSA_POLICY" },
    { "1.3.6.1.4.1.5309.1.2.3",           "EDEL_WEB_OPEN_EVIDENCE_TSA_POLICY" },
    { "1.3.6.1.4.1.5472",                 "TIMEPROOF" },
    { "1.3.6.1.4.1.5472.1",               "TSS" },
    { "1.3.6.1.4.1.5472.1.1",             "TSS80" },
    { "1.3.6.1.4.1.5472.1.2",             "TSS380" },
    { "1.3.6.1.4.1.5472.1.3",             "TSS400" },
    { "1.3.6.1.4.1.5770.0.3",             "SECONDARY_PRACTICES" },
    { "1.3.6.1.4.1.5770.0.4",             "PHYSICIAN_IDENTIFIERS" },
    { "1.3.6.1.4.1.6449.1.2.1.3.1",       "COMODO_POLICY" },
    { "1.3.6.1.4.1.6449.1.2.2.15",        "WOTRUST_POLICY" },
    { "1.3.6.1.4.1.6449.1.3.5.2",         "COMODO_CERTIFIED_DELIVERY_SERVICE" },
    { "1.3.6.1.4.1.6449.2.1.1",           "COMODO_TIMESTAMPING_POLICY" },
    { "1.3.6.1.4.1.8301.3.5.1",           "VALIDITY_MODEL_CHAIN" },
    { "1.3.6.1.4.1.8301.3.5.2",           "VALIDITY_MODEL_SHELL" },
    { "1.3.6.1.4.1.8231.1",               "ROL_UNICO_NACIONAL" },
    { "1.3.6.1.4.1.11591",                "GNU" },
    { "1.3.6.1.4.1.11591.1",              "GNU_RADIUS" },
    { "1.3.6.1.4.1.11591.3",              "GNU_RADAR" },
    { "1.3.6.1.4.1.11591.12",             "GNU_DIGEST_ALGORITHM" },
    { "1.3.6.1.4.1.11591.12.2",           "TIGER" },
    { "1.3.6.1.4.1.11591.13",             "GNU_ENCRYPTION_ALGORITHM" },
    { "1.3.6.1.4.1.11591.13.2",           "SERPENT" },
    { "1.3.6.1.4.1.11591.13.2.1",         "SERPENT128_ECB" },
    { "1.3.6.1.4.1.11591.13.2.2",         "SERPENT128_CBC" },
    { "1.3.6.1.4.1.11591.13.2.3",         "SERPENT128_OFB" },
    { "1.3.6.1.4.1.11591.13.2.4",         "SERPENT128_CFB" },
    { "1.3.6.1.4.1.11591.13.2.21",        "SERPENT192_ECB" },
    { "1.3.6.1.4.1.11591.13.2.22",        "SERPENT192_CBC" },
    { "1.3.6.1.4.1.11591.13.2.23",        "SERPENT192_OFB" },
    { "1.3.6.1.4.1.11591.13.2.24",        "SERPENT192_CFB" },
    { "1.3.6.1.4.1.11591.13.2.41",        "SERPENT256_ECB" },
    { "1.3.6.1.4.1.11591.13.2.42",        "SERPENT256_CBC" },
    { "1.3.6.1.4.1.11591.13.2.43",        "SERPENT256_OFB" },
    { "1.3.6.1.4.1.11591.13.2.44",        "SERPENT256_CFB" },
    { "1.3.6.1.4.1.16334.509.1.1",        "NORTHROP_GRUMMAN_EXT_KEY_USAGE?" },
    { "1.3.6.1.4.1.16334.509.2.1",        "NGC_CLASS1" },
    { "1.3.6.1.4.1.16334.509.2.2",        "NGC_CLASS2" },
    { "1.3.6.1.4.1.16334.509.2.3",        "NGC_CLASS3" },
    { "1.3.6.1.4.1.23629.1.4.2.1.1",      "SAFENET_USAGE_LIMIT" },
    { "1.3.6.1.4.1.23629.1.4.2.1.2",      "SAFENET_END_DATE" },
    { "1.3.6.1.4.1.23629.1.4.2.1.3",      "SAFENET_START_DATE" },
    { "1.3.6.1.4.1.23629.1.4.2.1.4",      "SAFENET_ADMIN_CERT" },
    { "1.3.6.1.4.1.23629.1.4.2.2.1",      "SAFENET_KEY_DIGEST" },
    { "1.3.6.1.5.5.7",                    "PKIX" },
    { "1.3.6.1.5.5.7.0.12",               "ATTRIBUTE_CERT" },
    { "1.3.6.1.5.5.7.1",                  "PRIVATE_EXTENSION" },
    { "1.3.6.1.5.5.7.1.1",                "AUTHORITY_INFO_ACCESS" },
    { "1.3.6.1.5.5.7.1.2",                "BIOMETRIC_INFO" },
    { "1.3.6.1.5.5.7.1.3",                "QC_STATEMENTS" },
    { "1.3.6.1.5.5.7.1.4",                "AC_AUDIT_IDENTITY" },
    { "1.3.6.1.5.5.7.1.5",                "AC_TARGETING" },
    { "1.3.6.1.5.5.7.1.6",                "AC_AA_CONTROLS" },
    { "1.3.6.1.5.5.7.1.7",                "IP_ADDR_BLOCKS" },
    { "1.3.6.1.5.5.7.1.8",                "AUTONOMOUS_SYS_IDS" },
    { "1.3.6.1.5.5.7.1.9",                "ROUTER_IDENTIFIER" },
    { "1.3.6.1.5.5.7.1.10",               "AC_PROXYING" },
    { "1.3.6.1.5.5.7.1.11",               "SUBJECT_INFO_ACCESS" },
    { "1.3.6.1.5.5.7.1.12",               "LOGO_TYPE" },
    { "1.3.6.1.5.5.7.1.13",               "WLAN_SSID" },
    { "1.3.6.1.5.5.7.2",                  "POLICY_QUALIFIER_IDS" },
    { "1.3.6.1.5.5.7.2.1",                "CPS" },
    { "1.3.6.1.5.5.7.2.2",                "UNOTICE" },
    { "1.3.6.1.5.5.7.2.3",                "TEXT_NOTICE" },
    { "1.3.6.1.5.5.7.3",                  "KEY_PURPOSE" },
    { "1.3.6.1.5.5.7.3.1",                "SERVER_AUTH" },
    { "1.3.6.1.5.5.7.3.2",                "CLIENT_AUTH" },
    { "1.3.6.1.5.5.7.3.3",                "CODE_SIGNING" },
    { "1.3.6.1.5.5.7.3.4",                "EMAIL_PROTECTION" },
    { "1.3.6.1.5.5.7.3.5",                "IPSEC_END_SYSTEM" },
    { "1.3.6.1.5.5.7.3.6",                "IPSEC_TUNNEL" },
    { "1.3.6.1.5.5.7.3.7",                "IPSEC_USER" },
    { "1.3.6.1.5.5.7.3.8",                "TIME_STAMPING" },
    { "1.3.6.1.5.5.7.3.9",                "OCSP_SIGNING" },
    { "1.3.6.1.5.5.7.3.10",               "DVCS" },
    { "1.3.6.1.5.5.7.3.11",               "SBGP_CERT_AA_SERVER_AUTH" },
    { "1.3.6.1.5.5.7.3.13",               "EAP_OVER_PPP" },
    { "1.3.6.1.5.5.7.3.14",               "EAP_OVER_LAN" },
    { "1.3.6.1.5.5.7.4",                  "CMP_INFORMATION_TYPES" },
    { "1.3.6.1.5.5.7.4.1",                "CA_PROT_ENC_CERT" },
    { "1.3.6.1.5.5.7.4.2",                "SIGN_KEY_PAIR_TYPES" },
    { "1.3.6.1.5.5.7.4.3",                "ENC_KEY_PAIR_TYPES" },
    { "1.3.6.1.5.5.7.4.4",                "PREFERRED_SYMM_ALG" },
    { "1.3.6.1.5.5.7.4.5",                "CA_KEY_UPDATE_INFO" },
    { "1.3.6.1.5.5.7.4.6",                "CURRENT_CRL" },
    { "1.3.6.1.5.5.7.4.7",                "UNSUPPORTED_OI_DS" },
    { "1.3.6.1.5.5.7.4.10",               "KEY_PAIR_PARAM_REQ" },
    { "1.3.6.1.5.5.7.4.11",               "KEY_PAIR_PARAM_REP" },
    { "1.3.6.1.5.5.7.4.12",               "REV_PASSPHRASE" },
    { "1.3.6.1.5.5.7.4.13",               "IMPLICIT_CONFIRM" },
    { "1.3.6.1.5.5.7.4.14",               "CONFIRM_WAIT_TIME" },
    { "1.3.6.1.5.5.7.4.15",               "ORIG_PKI_MESSAGE" },
    { "1.3.6.1.5.5.7.4.16",               "SUPP_LANG_TAGS" },
    { "1.3.6.1.5.5.7.5",                  "CRMF_REGISTRATION" },
    { "1.3.6.1.5.5.7.5.1",                "REG_CTRL" },
    { "1.3.6.1.5.5.7.5.1.1",              "REG_TOKEN" },
    { "1.3.6.1.5.5.7.5.1.2",              "AUTHENTICATOR" },
    { "1.3.6.1.5.5.7.5.1.3",              "PKI_PUBLICATION_INFO" },
    { "1.3.6.1.5.5.7.5.1.4",              "PKI_ARCHIVE_OPTIONS" },
    { "1.3.6.1.5.5.7.5.1.5",              "OLD_CERT_ID" },
    { "1.3.6.1.5.5.7.5.1.6",              "PROTOCOL_ENCR_KEY" },
    { "1.3.6.1.5.5.7.5.1.7",              "ALT_CERT_TEMPLATE" },
    { "1.3.6.1.5.5.7.5.1.8",              "WTLS_TEMPLATE" },
    { "1.3.6.1.5.5.7.5.2",                "UTF8_PAIRS" },
    { "1.3.6.1.5.5.7.5.2.1",              "UTF8_PAIRS" },
    { "1.3.6.1.5.5.7.5.2.2",              "CERT_REQ" },
    { "1.3.6.1.5.5.7.6",                  "ALGORITHMS" },
    { "1.3.6.1.5.5.7.6.1",                "DES40" },
    { "1.3.6.1.5.5.7.6.2",                "NO_SIGNATURE" },
    { "1.3.6.1.5.5.7.6.3",                "DH_SIG_HMAC_SHA1" },
    { "1.3.6.1.5.5.7.6.4",                "DH_POP" },
    { "1.3.6.1.5.5.7.7",                  "CMC_CONTROLS" },
    { "1.3.6.1.5.5.7.8",                  "OTHER_NAMES" },
    { "1.3.6.1.5.5.7.8.1",                "PERSONAL_DATA" },
    { "1.3.6.1.5.5.7.8.2",                "USER_GROUP" },
    { "1.3.6.1.5.5.7.8.5",                "XMPP_ADDR" },
    { "1.3.6.1.5.5.7.9",                  "PERSONAL_DATA" },
    { "1.3.6.1.5.5.7.9.1",                "DATE_OF_BIRTH" },
    { "1.3.6.1.5.5.7.9.2",                "PLACE_OF_BIRTH" },
    { "1.3.6.1.5.5.7.9.3",                "GENDER" },
    { "1.3.6.1.5.5.7.9.4",                "COUNTRY_OF_CITIZENSHIP" },
    { "1.3.6.1.5.5.7.9.5",                "COUNTRY_OF_RESIDENCE" },
    { "1.3.6.1.5.5.7.10",                 "ATTRIBUTE_CERTIFICATE" },
    { "1.3.6.1.5.5.7.10.1",               "AUTHENTICATION_INFO" },
    { "1.3.6.1.5.5.7.10.2",               "ACCESS_IDENTITY" },
    { "1.3.6.1.5.5.7.10.3",               "CHARGING_IDENTITY" },
    { "1.3.6.1.5.5.7.10.4",               "GROUP" },
    { "1.3.6.1.5.5.7.10.5",               "ROLE" },
    { "1.3.6.1.5.5.7.10.6",               "WLAN_SSID" },
    { "1.3.6.1.5.5.7.11",                 "PERSONAL_DATA" },
    { "1.3.6.1.5.5.7.11.1",               "PKIX_QC_SYNTAX_V1" },
    { "1.3.6.1.5.5.7.14.2",               "RESOURCE_CERTIFICATE_POLICY" },
    { "1.3.6.1.5.5.7.20",                 "LOGO" },
    { "1.3.6.1.5.5.7.20.1",               "LOGO_LOYALTY" },
    { "1.3.6.1.5.5.7.20.2",               "LOGO_BACKGROUND" },
    { "1.3.6.1.5.5.7.48.1",               "OCSP" },
    { "1.3.6.1.5.5.7.48.1.1",             "OCSP_BASIC" },
    { "1.3.6.1.5.5.7.48.1.2",             "OCSP_NONCE" },
    { "1.3.6.1.5.5.7.48.1.3",             "OCSP_CRL" },
    { "1.3.6.1.5.5.7.48.1.4",             "OCSP_RESPONSE" },
    { "1.3.6.1.5.5.7.48.1.5",             "OCSP_NO_CHECK" },
    { "1.3.6.1.5.5.7.48.1.6",             "OCSP_ARCHIVE_CUTOFF" },
    { "1.3.6.1.5.5.7.48.1.7",             "OCSP_SERVICE_LOCATOR" },
    { "1.3.6.1.5.5.7.48.2",               "CA_ISSUERS" },
    { "1.3.6.1.5.5.7.48.3",               "TIME_STAMPING" },
    { "1.3.6.1.5.5.7.48.4",               "DVCS" },
    { "1.3.6.1.5.5.7.48.5",               "CA_REPOSITORY" },
    { "1.3.6.1.5.5.7.48.7",               "SIGNED_OBJECT_REPOSITORY" },
    { "1.3.6.1.5.5.7.48.10",              "RPKI_MANIFEST" },
    { "1.3.6.1.5.5.7.48.11",              "SIGNED_OBJECT" },
    { "1.3.6.1.5.5.8.1.1",                "HMAC_MD5" },
    { "1.3.6.1.5.5.8.1.2",                "HMAC_SHA" },
    { "1.3.6.1.5.5.8.1.3",                "HMAC_TIGER" },
    { "1.3.6.1.5.5.8.2.2",                "I_KE_INTERMEDIATE" },
    { "1.3.12.2.1011.7.1",                "DEC_ENCRYPTION_ALGORITHM" },
    { "1.3.12.2.1011.7.1.2",              "DEC_DEA" },
    { "1.3.12.2.1011.7.2",                "DEC_HASH_ALGORITHM" },
    { "1.3.12.2.1011.7.2.1",              "DEC_MD2" },
    { "1.3.12.2.1011.7.2.2",              "DEC_MD4" },
    { "1.3.12.2.1011.7.3",                "DEC_SIGNATURE_ALGORITHM" },
    { "1.3.12.2.1011.7.3.1",              "DEC_MD2WITH_RSA" },
    { "1.3.12.2.1011.7.3.2",              "DEC_MD4WITH_RSA" },
    { "1.3.12.2.1011.7.3.3",              "DEC_DEAMAC" },
    { "1.3.14.2.26.5",                    "SHA" },
    { "1.3.14.3.2.1.1",                   "RSA" },
    { "1.3.14.3.2.2",                     "MD4_WIT_RSA" },
    { "1.3.14.3.2.3",                     "MD5_WITH_RSA" },
    { "1.3.14.3.2.4",                     "MD4_WITH_RSA_ENCRYPTION" },
    { "1.3.14.3.2.2.1",                   "SQMOD_N" },
    { "1.3.14.3.2.3.1",                   "SQMOD_NWITH_RSA" },
    { "1.3.14.3.2.6",                     "DES_ECB" },
    { "1.3.14.3.2.7",                     "DES_CBC" },
    { "1.3.14.3.2.8",                     "DES_OFB" },
    { "1.3.14.3.2.9",                     "DES_CFB" },
    { "1.3.14.3.2.10",                    "DES_MAC" },
    { "1.3.14.3.2.11",                    "RSA_SIGNATURE" },
    { "1.3.14.3.2.12",                    "DSA" },
    { "1.3.14.3.2.13",                    "DSA_WITH_SHA" },
    { "1.3.14.3.2.14",                    "MDC2_WITH_RSA_SIGNATURE" },
    { "1.3.14.3.2.15",                    "SHA_WITH_RSA_SIGNATURE" },
    { "1.3.14.3.2.16",                    "DH_WITH_COMMON_MODULUS" },
    { "1.3.14.3.2.17",                    "DES_EDE" },
    { "1.3.14.3.2.18",                    "SHA" },
    { "1.3.14.3.2.19",                    "MDC_2" },
    { "1.3.14.3.2.20",                    "DSA_COMMON" },
    { "1.3.14.3.2.21",                    "DSA_COMMON_WITH_SHA" },
    { "1.3.14.3.2.22",                    "RSA_KEY_TRANSPORT" },
    { "1.3.14.3.2.23",                    "KEYED_HASH_SEAL" },
    { "1.3.14.3.2.24",                    "MD2_WITH_RSA_SIGNATURE" },
    { "1.3.14.3.2.25",                    "MD5_WITH_RSA_SIGNATURE" },
    { "1.3.14.3.2.26",                    "SHA1" },
    { "1.3.14.3.2.27",                    "DSA_WITH_SHA1" },
    { "1.3.14.3.2.28",                    "DSA_WITH_COMMON_SHA1" },
    { "1.3.14.3.2.29",                    "SHA_1_WITH_RSA_ENCRYPTION" },
    { "1.3.14.3.3.1",                     "SIMPLE_STRONG_AUTH_MECHANISM" },
    { "1.3.14.7.2.1.1",                   "EL_GAMAL" },
    { "1.3.14.7.2.3.1",                   "MD2_WITH_RSA" },
    { "1.3.14.7.2.3.2",                   "MD2_WITH_EL_GAMAL" },
    { "1.3.36.1",                         "DOCUMENT" },
    { "1.3.36.1.1",                       "FINAL_VERSION" },
    { "1.3.36.1.2",                       "DRAFT" },
    { "1.3.36.2",                         "SIO" },
    { "1.3.36.2.1",                       "SEDU" },
    { "1.3.36.3",                         "ALGORITHM" },
    { "1.3.36.3.1",                       "ENCRYPTION_ALGORITHM" },
    { "1.3.36.3.1.1",                     "DES" },
    { "1.3.36.3.1.1.1",                   "DES_ECB_PAD" },
    { "1.3.36.3.1.1.1.1",                 "DES_ECB_IS_OPAD" },
    { "1.3.36.3.1.1.2.1",                 "DES_CBC_PAD" },
    { "1.3.36.3.1.1.2.1.1",               "DES_CBC_IS_OPAD" },
    { "1.3.36.3.1.3",                     "DES_3" },
    { "1.3.36.3.1.3.1.1",                 "DES_3_ECB_PAD" },
    { "1.3.36.3.1.3.1.1.1",               "DES_3_ECB_IS_OPAD" },
    { "1.3.36.3.1.3.2.1",                 "DES_3_CBC_PAD" },
    { "1.3.36.3.1.3.2.1.1",               "DES_3_CBC_IS_OPAD" },
    { "1.3.36.3.1.2",                     "IDEA" },
    { "1.3.36.3.1.2.1",                   "IDEA_ECB" },
    { "1.3.36.3.1.2.1.1",                 "IDEA_ECB_PAD" },
    { "1.3.36.3.1.2.1.1.1",               "IDEA_ECB_IS_OPAD" },
    { "1.3.36.3.1.2.2",                   "IDEA_CBC" },
    { "1.3.36.3.1.2.2.1",                 "IDEA_CBC_PAD" },
    { "1.3.36.3.1.2.2.1.1",               "IDEA_CBC_IS_OPAD" },
    { "1.3.36.3.1.2.3",                   "IDEA_OFB" },
    { "1.3.36.3.1.2.4",                   "IDEA_CFB" },
    { "1.3.36.3.1.4",                     "RSA_ENCRYPTION" },
    { "1.3.36.3.1.4.512.17",              "RSA_ENCRYPTION_WITHLMOD512EXPE17" },
    { "1.3.36.3.1.5",                     "BSI_1" },
    { "1.3.36.3.1.5.1",                   "BSI_1_ECB_PAD" },
    { "1.3.36.3.1.5.2",                   "BSI_1_CBC_PAD" },
    { "1.3.36.3.1.5.2.1",                 "BSI_1_CBC_PE_MPAD" },
    { "1.3.36.3.2",                       "HASH_ALGORITHM" },
    { "1.3.36.3.2.1",                     "RIPEMD160" },
    { "1.3.36.3.2.2",                     "RIPEMD128" },
    { "1.3.36.3.2.3",                     "RIPEMD256" },
    { "1.3.36.3.2.4",                     "MDC2SINGLE_LENGTH" },
    { "1.3.36.3.2.5",                     "MDC2DOUBLE_LENGTH" },
    { "1.3.36.3.3",                       "SIGNATURE_ALGORITHM" },
    { "1.3.36.3.3.1",                     "RSA_SIGNATURE" },
    { "1.3.36.3.3.1.1",                   "RSA_SIGNATURE_WITHSHA1" },
    { "1.3.36.3.3.1.1.1024.11",           "RSA_SIGNATURE_WITHSHA1_L1024_L11" },
    { "1.3.36.3.3.1.2",                   "RSA_SIGNATURE_WITHRIPEMD160" },
    { "1.3.36.3.3.1.2.1024.11",           "RSA_SIGNATURE_WITHRIPEMD160_L1024_L11" },
    { "1.3.36.3.3.1.3",                   "RSA_SIGNATURE_WITHRIMPEMD128" },
    { "1.3.36.3.3.1.4",                   "RSA_SIGNATURE_WITHRIMPEMD256" },
    { "1.3.36.3.3.2",                     "ECSIE_SIGN" },
    { "1.3.36.3.3.2.1",                   "ECSIE_SIGN_WITHSHA1" },
    { "1.3.36.3.3.2.2",                   "ECSIE_SIGN_WITHRIPEMD160" },
    { "1.3.36.3.3.2.3",                   "ECSIE_SIGN_WITHMD2" },
    { "1.3.36.3.3.2.4",                   "ECSIE_SIGN_WITHMD5" },
    { "1.3.36.3.3.2.8.1.1.1",             "BRAINPOOL_P160R1" },
    { "1.3.36.3.3.2.8.1.1.2",             "BRAINPOOL_P160T1" },
    { "1.3.36.3.3.2.8.1.1.3",             "BRAINPOOL_P192R1" },
    { "1.3.36.3.3.2.8.1.1.4",             "BRAINPOOL_P192T1" },
    { "1.3.36.3.3.2.8.1.1.5",             "BRAINPOOL_P224R1" },
    { "1.3.36.3.3.2.8.1.1.6",             "BRAINPOOL_P224T1" },
    { "1.3.36.3.3.2.8.1.1.7",             "BRAINPOOL_P256R1" },
    { "1.3.36.3.3.2.8.1.1.8",             "BRAINPOOL_P256T1" },
    { "1.3.36.3.3.2.8.1.1.9",             "BRAINPOOL_P320R1" },
    { "1.3.36.3.3.2.8.1.1.10",            "BRAINPOOL_P320T1" },
    { "1.3.36.3.3.2.8.1.1.11",            "BRAINPOOL_P384R1" },
    { "1.3.36.3.3.2.8.1.1.12",            "BRAINPOOL_P384T1" },
    { "1.3.36.3.3.2.8.1.1.13",            "BRAINPOOL_P512R1" },
    { "1.3.36.3.3.2.8.1.1.14",            "BRAINPOOL_P512T1" },
    { "1.3.36.3.4",                       "SIGNATURE_SCHEME" },
    { "1.3.36.3.4.1",                     "SIG_S_ISO9796_1" },
    { "1.3.36.3.4.2",                     "SIG_S_ISO9796_2" },
    { "1.3.36.3.4.2.1",                   "SIG_S_ISO9796_2_WITHRED" },
    { "1.3.36.3.4.2.2",                   "SIG_S_ISO9796_2_WITHRSA" },
    { "1.3.36.3.4.2.3",                   "SIG_S_ISO9796_2_WITHRND" },
    { "1.3.36.4",                         "ATTRIBUTE" },
    { "1.3.36.5",                         "POLICY" },
    { "1.3.36.6",                         "API" },
    { "1.3.36.6.1",                       "MANUFACTURER_SPECIFIC_API" },
    { "1.3.36.6.1.1",                     "UTIMACO_API" },
    { "1.3.36.6.2",                       "FUNCTIONALITY_SPECIFIC_API" },
    { "1.3.36.7",                         "KEYMGMNT" },
    { "1.3.36.7.1",                       "KEYAGREE" },
    { "1.3.36.7.1.1",                     "BSI_PKE" },
    { "1.3.36.7.2",                       "KEYTRANS" },
    { "1.3.36.7.2.1",                     "ENC_ISO9796_2_WITHRSA" },
    { "1.3.36.8.1.1",                     "TELETRUST_SIG_G_CONFORM_POLICY_IDENTIFIER" },
    { "1.3.36.8.2.1",                     "DIRECTORY_SERVICE" },
    { "1.3.36.8.3.1",                     "DATE_OF_CERT_GEN" },
    { "1.3.36.8.3.2",                     "PROCURATION" },
    { "1.3.36.8.3.3",                     "ADMISSION" },
    { "1.3.36.8.3.4",                     "MONETARY_LIMIT" },
    { "1.3.36.8.3.5",                     "DECLARATION_OF_MAJORITY" },
    { "1.3.36.8.3.6",                     "INTEGRATED_CIRCUIT_CARD_SERIAL_NUMBER" },
    { "1.3.36.8.3.7",                     "P_K_REFERENCE" },
    { "1.3.36.8.3.8",                     "RESTRICTION" },
    { "1.3.36.8.3.9",                     "RETRIEVE_IF_ALLOWED" },
    { "1.3.36.8.3.10",                    "REQUESTED_CERTIFICATE" },
    { "1.3.36.8.3.11",                    "NAMING_AUTHORITIES" },
    { "1.3.36.8.3.11.1",                  "RECHT_WIRTSCHAFT_STEUERN" },
    { "1.3.36.8.3.11.1.1",                "RECHTSANWAELTIN" },
    { "1.3.36.8.3.11.1.2",                "RECHTSANWALT" },
    { "1.3.36.8.3.11.1.3",                "RECHTS_BEISTAND" },
    { "1.3.36.8.3.11.1.4",                "STEUER_BERATERIN" },
    { "1.3.36.8.3.11.1.5",                "STEUER_BERATER" },
    { "1.3.36.8.3.11.1.6",                "STEUER_BEVOLLMAECHTIGTE" },
    { "1.3.36.8.3.11.1.7",                "STEUER_BEVOLLMAECHTIGTER" },
    { "1.3.36.8.3.11.1.8",                "NOTARIN" },
    { "1.3.36.8.3.11.1.9",                "NOTAR" },
    { "1.3.36.8.3.11.1.10",               "NOTAR_VERTRETERIN" },
    { "1.3.36.8.3.11.1.11",               "NOTAR_VERTRETER" },
    { "1.3.36.8.3.11.1.12",               "NOTARIATS_VERWALTERIN" },
    { "1.3.36.8.3.11.1.13",               "NOTARIATS_VERWALTER" },
    { "1.3.36.8.3.11.1.14",               "WIRTSCHAFTS_PRUEFERIN" },
    { "1.3.36.8.3.11.1.15",               "WIRTSCHAFTS_PRUEFER" },
    { "1.3.36.8.3.11.1.16",               "VEREIDIGTE_BUCHPRUEFERIN" },
    { "1.3.36.8.3.11.1.17",               "VEREIDIGTER_BUCHPRUEFER" },
    { "1.3.36.8.3.11.1.18",               "PATENT_ANWAELTIN" },
    { "1.3.36.8.3.11.1.19",               "PATENT_ANWALT" },
    { "1.3.36.8.3.12",                    "CERT_IN_DIR_SINCE" },
    { "1.3.36.8.3.13",                    "CERT_HASH" },
    { "1.3.36.8.3.14",                    "NAME_AT_BIRTH" },
    { "1.3.36.8.3.15",                    "ADDITIONAL_INFORMATION" },
    { "1.3.36.8.4.1",                     "PERSONAL_DATA" },
    { "1.3.36.8.4.8",                     "RESTRICTION" },
    { "1.3.36.8.5.1.1.1",                 "RSA_INDICATE_SHA1" },
    { "1.3.36.8.5.1.1.2",                 "RSA_INDICATE_RIPEMD160" },
    { "1.3.36.8.5.1.1.3",                 "RSA_WITH_SHA1" },
    { "1.3.36.8.5.1.1.4",                 "RSA_WITH_RIPEMD160" },
    { "1.3.36.8.5.1.2.1",                 "DSA_EXTENDED" },
    { "1.3.36.8.5.1.2.2",                 "DSA_WITH_RIPEMD160" },
    { "1.3.36.8.6.1",                     "CERT" },
    { "1.3.36.8.6.2",                     "CERT_REF" },
    { "1.3.36.8.6.3",                     "ATTR_CERT" },
    { "1.3.36.8.6.4",                     "ATTR_REF" },
    { "1.3.36.8.6.5",                     "FILE_NAME" },
    { "1.3.36.8.6.6",                     "STORAGE_TIME" },
    { "1.3.36.8.6.7",                     "FILE_SIZE" },
    { "1.3.36.8.6.8",                     "LOCATION" },
    { "1.3.36.8.6.9",                     "SIG_NUMBER" },
    { "1.3.36.8.6.10",                    "AUTO_GEN" },
    { "1.3.36.8.7.1.1",                   "PT_ADOBE_ILL" },
    { "1.3.36.8.7.1.2",                   "PT_AMI_PRO" },
    { "1.3.36.8.7.1.3",                   "PT_AUTO_CAD" },
    { "1.3.36.8.7.1.4",                   "PT_BINARY" },
    { "1.3.36.8.7.1.5",                   "PT_BMP" },
    { "1.3.36.8.7.1.6",                   "PT_CGM" },
    { "1.3.36.8.7.1.7",                   "PT_COREL_CRT" },
    { "1.3.36.8.7.1.8",                   "PT_COREL_DRW" },
    { "1.3.36.8.7.1.9",                   "PT_COREL_EXC" },
    { "1.3.36.8.7.1.10",                  "PT_COREL_PHT" },
    { "1.3.36.8.7.1.11",                  "PT_DRAW" },
    { "1.3.36.8.7.1.12",                  "PT_DVI" },
    { "1.3.36.8.7.1.13",                  "PT_EPS" },
    { "1.3.36.8.7.1.14",                  "PT_EXCEL" },
    { "1.3.36.8.7.1.15",                  "PT_GEM" },
    { "1.3.36.8.7.1.16",                  "PT_GIF" },
    { "1.3.36.8.7.1.17",                  "PT_HPGL" },
    { "1.3.36.8.7.1.18",                  "PT_JPEG" },
    { "1.3.36.8.7.1.19",                  "PT_KODAK" },
    { "1.3.36.8.7.1.20",                  "PT_LA_TE_X" },
    { "1.3.36.8.7.1.21",                  "PT_LOTUS" },
    { "1.3.36.8.7.1.22",                  "PT_LOTUS_PIC" },
    { "1.3.36.8.7.1.23",                  "PT_MAC_PICT" },
    { "1.3.36.8.7.1.24",                  "PT_MAC_WORD" },
    { "1.3.36.8.7.1.25",                  "PT_MS_WF_D" },
    { "1.3.36.8.7.1.26",                  "PT_MS_WORD" },
    { "1.3.36.8.7.1.27",                  "PT_MS_WORD2" },
    { "1.3.36.8.7.1.28",                  "PT_MS_WORD6" },
    { "1.3.36.8.7.1.29",                  "PT_MS_WORD8" },
    { "1.3.36.8.7.1.30",                  "PT_PDF" },
    { "1.3.36.8.7.1.31",                  "PT_PIF" },
    { "1.3.36.8.7.1.32",                  "PT_POSTSCRIPT" },
    { "1.3.36.8.7.1.33",                  "PT_RTF" },
    { "1.3.36.8.7.1.34",                  "PT_SCITEX" },
    { "1.3.36.8.7.1.35",                  "PT_TAR" },
    { "1.3.36.8.7.1.36",                  "PT_TARGA" },
    { "1.3.36.8.7.1.37",                  "PT_TE_X" },
    { "1.3.36.8.7.1.38",                  "PT_TEXT" },
    { "1.3.36.8.7.1.39",                  "PT_TIFF" },
    { "1.3.36.8.7.1.40",                  "PT_TIFF_FC" },
    { "1.3.36.8.7.1.41",                  "PT_UID" },
    { "1.3.36.8.7.1.42",                  "PT_UU_ENCODE" },
    { "1.3.36.8.7.1.43",                  "PT_WMF" },
    { "1.3.36.8.7.1.44",                  "PT_WORD_PERFECT" },
    { "1.3.36.8.7.1.45",                  "PT_WP_GRPH" },
    { "1.3.101.1.4",                      "THAWTE_CE" },
    { "1.3.101.1.4.1",                    "STRONG_EXTRANET" },
    { "1.3.132.0.1",                      "SECT163K1" },
    { "1.3.132.0.2",                      "SECT163R1" },
    { "1.3.132.0.3",                      "SECT239K1" },
    { "1.3.132.0.4",                      "SECT113R1" },
    { "1.3.132.0.5",                      "SECT113R2" },
    { "1.3.132.0.6",                      "SECP112R1" },
    { "1.3.132.0.7",                      "SECP112R2" },
    { "1.3.132.0.8",                      "SECP160R1" },
    { "1.3.132.0.9",                      "SECP160K1" },
    { "1.3.132.0.10",                     "SECP256K1" },
    { "1.3.132.0.15",                     "SECT163R2" },
    { "1.3.132.0.16",                     "SECT283K1" },
    { "1.3.132.0.17",                     "SECT283R1" },
    { "1.3.132.0.22",                     "SECT131R1" },
    { "1.3.132.0.23",                     "SECT131R2" },
    { "1.3.132.0.24",                     "SECT193R1" },
    { "1.3.132.0.25",                     "SECT193R2" },
    { "1.3.132.0.26",                     "SECT233K1" },
    { "1.3.132.0.27",                     "SECT233R1" },
    { "1.3.132.0.28",                     "SECP128R1" },
    { "1.3.132.0.29",                     "SECP128R2" },
    { "1.3.132.0.30",                     "SECP160R2" },
    { "1.3.132.0.31",                     "SECP192K1" },
    { "1.3.132.0.32",                     "SECP224K1" },
    { "1.3.132.0.33",                     "SECP224R1" },
    { "1.3.132.0.34",                     "SECP384R1" },
    { "1.3.132.0.35",                     "SECP521R1" },
    { "1.3.132.0.36",                     "SECT409K1" },
    { "1.3.132.0.37",                     "SECT409R1" },
    { "1.3.132.0.38",                     "SECT571K1" },
    { "1.3.132.0.39",                     "SECT571R1" },
    { "1.3.133.16.840.9.84",              "X984" },
    { "1.3.133.16.840.9.84.0",            "X984_MODULE" },
    { "1.3.133.16.840.9.84.0.1",          "X984_BIOMETRICS" },
    { "1.3.133.16.840.9.84.0.2",          "X984_CMS" },
    { "1.3.133.16.840.9.84.0.3",          "X984_IDENTIFIERS" },
    { "1.3.133.16.840.9.84.1",            "X984_BIOMETRIC" },
    { "1.3.133.16.840.9.84.1.0",          "BIOMETRIC_UNKNOWN_TYPE" },
    { "1.3.133.16.840.9.84.1.1",          "BIOMETRIC_BODY_ODOR" },
    { "1.3.133.16.840.9.84.1.2",          "BIOMETRIC_DNA" },
    { "1.3.133.16.840.9.84.1.3",          "BIOMETRIC_EAR_SHAPE" },
    { "1.3.133.16.840.9.84.1.4",          "BIOMETRIC_FACIAL_FEATURES" },
    { "1.3.133.16.840.9.84.1.5",          "BIOMETRIC_FINGER_IMAGE" },
    { "1.3.133.16.840.9.84.1.6",          "BIOMETRIC_FINGER_GEOMETRY" },
    { "1.3.133.16.840.9.84.1.7",          "BIOMETRIC_HAND_GEOMETRY" },
    { "1.3.133.16.840.9.84.1.8",          "BIOMETRIC_IRIS_FEATURES" },
    { "1.3.133.16.840.9.84.1.9",          "BIOMETRIC_KEYSTROKE_DYNAMICS" },
    { "1.3.133.16.840.9.84.1.10",         "BIOMETRIC_PALM" },
    { "1.3.133.16.840.9.84.1.11",         "BIOMETRIC_RETINA" },
    { "1.3.133.16.840.9.84.1.12",         "BIOMETRIC_SIGNATURE" },
    { "1.3.133.16.840.9.84.1.13",         "BIOMETRIC_SPEECH_PATTERN" },
    { "1.3.133.16.840.9.84.1.14",         "BIOMETRIC_THERMAL_IMAGE" },
    { "1.3.133.16.840.9.84.1.15",         "BIOMETRIC_VEIN_PATTERN" },
    { "1.3.133.16.840.9.84.1.16",         "BIOMETRIC_THERMAL_FACE_IMAGE" },
    { "1.3.133.16.840.9.84.1.17",         "BIOMETRIC_THERMAL_HAND_IMAGE" },
    { "1.3.133.16.840.9.84.1.18",         "BIOMETRIC_LIP_MOVEMENT" },
    { "1.3.133.16.840.9.84.1.19",         "BIOMETRIC_GAIT" },
    { "1.3.133.16.840.9.84.3",            "X984_MATCHING_METHOD" },
    { "1.3.133.16.840.9.84.4",            "X984_FORMAT_OWNER" },
    { "1.3.133.16.840.9.84.4.0",          "X984_CBEFF_OWNER" },
    { "1.3.133.16.840.9.84.4.1",          "X984_IBIA_OWNER" },
    { "1.3.133.16.840.9.84.4.1.1",        "IBIA_OWNER_SAFLINK" },
    { "1.3.133.16.840.9.84.4.1.2",        "IBIA_OWNER_BIOSCRYPT" },
    { "1.3.133.16.840.9.84.4.1.3",        "IBIA_OWNER_VISIONICS" },
    { "1.3.133.16.840.9.84.4.1.4",        "IBIA_OWNER_INFINEON_TECHNOLOGIES_AG" },
    { "1.3.133.16.840.9.84.4.1.5",        "IBIA_OWNER_IRIDIAN_TECHNOLOGIES" },
    { "1.3.133.16.840.9.84.4.1.6",        "IBIA_OWNER_VERIDICOM" },
    { "1.3.133.16.840.9.84.4.1.7",        "IBIA_OWNER_CYBER_SIGN" },
    { "1.3.133.16.840.9.84.4.1.8",        "IBIA_OWNERE_CRYP" },
    { "1.3.133.16.840.9.84.4.1.9",        "IBIA_OWNER_FINGERPRINT_CARDS_AB" },
    { "1.3.133.16.840.9.84.4.1.10",       "IBIA_OWNER_SECU_GEN" },
    { "1.3.133.16.840.9.84.4.1.11",       "IBIA_OWNER_PRECISE_BIOMETRIC" },
    { "1.3.133.16.840.9.84.4.1.12",       "IBIA_OWNER_IDENTIX" },
    { "1.3.133.16.840.9.84.4.1.13",       "IBIA_OWNER_DERMALOG" },
    { "1.3.133.16.840.9.84.4.1.14",       "IBIA_OWNER_LOGICO" },
    { "1.3.133.16.840.9.84.4.1.15",       "IBIA_OWNER_NIST" },
    { "1.3.133.16.840.9.84.4.1.16",       "IBIA_OWNER_A3_VISION" },
    { "1.3.133.16.840.9.84.4.1.17",       "IBIA_OWNER_NEC" },
    { "1.3.133.16.840.9.84.4.1.18",       "IBIA_OWNER_ST_MICROELECTRONICS" },
    { "2.5.4.0",                          "OBJECT_CLASS" },
    { "2.5.4.1",                          "ALIASED_ENTRY_NAME" },
    { "2.5.4.2",                          "KNOWLEDGE_INFORMATION" },
    { "2.5.4.3",                          "COMMON_NAME" },
    { "2.5.4.4",                          "SURNAME" },
    { "2.5.4.5",                          "SERIAL_NUMBER" },
    { "2.5.4.6",                          "COUNTRY_NAME" },
    { "2.5.4.7",                          "LOCALITY_NAME" },
    { "2.5.4.7.1",                        "COLLECTIVE_LOCALITY_NAME" },
    { "2.5.4.8",                          "STATE_OR_PROVINCE_NAME" },
    { "2.5.4.8.1",                        "COLLECTIVE_STATE_OR_PROVINCE_NAME" },
    { "2.5.4.9",                          "STREET_ADDRESS" },
    { "2.5.4.9.1",                        "COLLECTIVE_STREET_ADDRESS" },
    { "2.5.4.10",                         "ORGANIZATION_NAME" },
    { "2.5.4.10.1",                       "COLLECTIVE_ORGANIZATION_NAME" },
    { "2.5.4.11",                         "ORGANIZATIONAL_UNIT_NAME" },
    { "2.5.4.11.1",                       "COLLECTIVE_ORGANIZATIONAL_UNIT_NAME" },
    { "2.5.4.12",                         "TITLE" },
    { "2.5.4.13",                         "DESCRIPTION" },
    { "2.5.4.14",                         "SEARCH_GUIDE" },
    { "2.5.4.15",                         "BUSINESS_CATEGORY" },
    { "2.5.4.16",                         "POSTAL_ADDRESS" },
    { "2.5.4.16.1",                       "COLLECTIVE_POSTAL_ADDRESS" },
    { "2.5.4.17",                         "POSTAL_CODE" },
    { "2.5.4.17.1",                       "COLLECTIVE_POSTAL_CODE" },
    { "2.5.4.18",                         "POST_OFFICE_BOX" },
    { "2.5.4.18.1",                       "COLLECTIVE_POST_OFFICE_BOX" },
    { "2.5.4.19",                         "PHYSICAL_DELIVERY_OFFICE_NAME" },
    { "2.5.4.19.1",                       "COLLECTIVE_PHYSICAL_DELIVERY_OFFICE_NAME" },
    { "2.5.4.20",                         "TELEPHONE_NUMBER" },
    { "2.5.4.20.1",                       "COLLECTIVE_TELEPHONE_NUMBER" },
    { "2.5.4.21",                         "TELEX_NUMBER" },
    { "2.5.4.21.1",                       "COLLECTIVE_TELEX_NUMBER" },
    { "2.5.4.22",                         "TELETEX_TERMINAL_IDENTIFIER" },
    { "2.5.4.22.1",                       "COLLECTIVE_TELETEX_TERMINAL_IDENTIFIER" },
    { "2.5.4.23",                         "FACSIMILE_TELEPHONE_NUMBER" },
    { "2.5.4.23.1",                       "COLLECTIVE_FACSIMILE_TELEPHONE_NUMBER" },
    { "2.5.4.24",                         "X121_ADDRESS" },
    { "2.5.4.25",                         "INTERNATIONAL_ISDN_NUMBER" },
    { "2.5.4.25.1",                       "COLLECTIVE_INTERNATIONAL_ISDN_NUMBER" },
    { "2.5.4.26",                         "REGISTERED_ADDRESS" },
    { "2.5.4.27",                         "DESTINATION_INDICATOR" },
    { "2.5.4.28",                         "PREFERRED_DELIVERY_MEHTOD" },
    { "2.5.4.29",                         "PRESENTATION_ADDRESS" },
    { "2.5.4.30",                         "SUPPORTED_APPLICATION_CONTEXT" },
    { "2.5.4.31",                         "MEMBER" },
    { "2.5.4.32",                         "OWNER" },
    { "2.5.4.33",                         "ROLE_OCCUPANT" },
    { "2.5.4.34",                         "SEE_ALSO" },
    { "2.5.4.35",                         "USER_PASSWORD" },
    { "2.5.4.36",                         "USER_CERTIFICATE" },
    { "2.5.4.37",                         "CA_CERTIFICATE" },
    { "2.5.4.38",                         "AUTHORITY_REVOCATION_LIST" },
    { "2.5.4.39",                         "CERTIFICATE_REVOCATION_LIST" },
    { "2.5.4.40",                         "CROSS_CERTIFICATE_PAIR" },
    { "2.5.4.41",                         "NAME" },
    { "2.5.4.42",                         "GIVEN_NAME" },
    { "2.5.4.43",                         "INITIALS" },
    { "2.5.4.44",                         "GENERATION_QUALIFIER" },
    { "2.5.4.45",                         "UNIQUE_IDENTIFIER" },
    { "2.5.4.46",                         "DN_QUALIFIER" },
    { "2.5.4.47",                         "ENHANCED_SEARCH_GUIDE" },
    { "2.5.4.48",                         "PROTOCOL_INFORMATION" },
    { "2.5.4.49",                         "DISTINGUISHED_NAME" },
    { "2.5.4.50",                         "UNIQUE_MEMBER" },
    { "2.5.4.51",                         "HOUSE_IDENTIFIER" },
    { "2.5.4.52",                         "SUPPORTED_ALGORITHMS" },
    { "2.5.4.53",                         "DELTA_REVOCATION_LIST" },
    { "2.5.4.54",                         "DMD_NAME" },
    { "2.5.4.55",                         "CLEARANCE" },
    { "2.5.4.56",                         "DEFAULT_DIR_QOP" },
    { "2.5.4.57",                         "ATTRIBUTE_INTEGRITY_INFO" },
    { "2.5.4.58",                         "ATTRIBUTE_CERTIFICATE" },
    { "2.5.4.59",                         "ATTRIBUTE_CERTIFICATE_REVOCATION_LIST" },
    { "2.5.4.60",                         "CONF_KEY_INFO" },
    { "2.5.4.61",                         "A_A_CERTIFICATE" },
    { "2.5.4.62",                         "ATTRIBUTE_DESCRIPTOR_CERTIFICATE" },
    { "2.5.4.63",                         "ATTRIBUTE_AUTHORITY_REVOCATION_LIST" },
    { "2.5.4.64",                         "FAMILY_INFORMATION" },
    { "2.5.4.65",                         "PSEUDONYM" },
    { "2.5.4.66",                         "COMMUNICATIONS_SERVICE" },
    { "2.5.4.67",                         "COMMUNICATIONS_NETWORK" },
    { "2.5.4.68",                         "CERTIFICATION_PRACTICE_STMT" },
    { "2.5.4.69",                         "CERTIFICATE_POLICY" },
    { "2.5.4.70",                         "PKI_PATH" },
    { "2.5.4.71",                         "PRIV_POLICY" },
    { "2.5.4.72",                         "ROLE" },
    { "2.5.4.73",                         "DELEGATION_PATH" },
    { "2.5.4.74",                         "PROT_PRIV_POLICY" },
    { "2.5.4.75",                         "X_ML_PRIVILEGE_INFO" },
    { "2.5.4.76",                         "XML_PRIV_POLICY" },
    { "2.5.4.82",                         "PERMISSION" },
    { "2.5.6.0",                          "TOP" },
    { "2.5.6.1",                          "ALIAS" },
    { "2.5.6.2",                          "COUNTRY" },
    { "2.5.6.3",                          "LOCALITY" },
    { "2.5.6.4",                          "ORGANIZATION" },
    { "2.5.6.5",                          "ORGANIZATIONAL_UNIT" },
    { "2.5.6.6",                          "PERSON" },
    { "2.5.6.7",                          "ORGANIZATIONAL_PERSON" },
    { "2.5.6.8",                          "ORGANIZATIONAL_ROLE" },
    { "2.5.6.9",                          "GROUP_OF_NAMES" },
    { "2.5.6.10",                         "RESIDENTIAL_PERSON" },
    { "2.5.6.11",                         "APPLICATION_PROCESS" },
    { "2.5.6.12",                         "APPLICATION_ENTITY" },
    { "2.5.6.13",                         "D_SA" },
    { "2.5.6.14",                         "DEVICE" },
    { "2.5.6.15",                         "STRONG_AUTHENTICATION_USER" },
    { "2.5.6.16",                         "CERTIFICATE_AUTHORITY" },
    { "2.5.6.17",                         "GROUP_OF_UNIQUE_NAMES" },
    { "2.5.6.21",                         "PKI_USER" },
    { "2.5.6.22",                         "PKI_CA" },
    { "2.5.8.1.1",                        "RSA" },
    { "2.5.29.1",                         "AUTHORITY_KEY_IDENTIFIER" },
    { "2.5.29.2",                         "KEY_ATTRIBUTES" },
    { "2.5.29.3",                         "CERTIFICATE_POLICIES" },
    { "2.5.29.4",                         "KEY_USAGE_RESTRICTION" },
    { "2.5.29.5",                         "POLICY_MAPPING" },
    { "2.5.29.6",                         "SUBTREES_CONSTRAINT" },
    { "2.5.29.7",                         "SUBJECT_ALT_NAME" },
    { "2.5.29.8",                         "ISSUER_ALT_NAME" },
    { "2.5.29.9",                         "SUBJECT_DIRECTORY_ATTRIBUTES" },
    { "2.5.29.10",                        "BASIC_CONSTRAINTS" },
    { "2.5.29.11",                        "NAME_CONSTRAINTS" },
    { "2.5.29.12",                        "POLICY_CONSTRAINTS" },
    { "2.5.29.13",                        "BASIC_CONSTRAINTS" },
    { "2.5.29.14",                        "SUBJECT_KEY_IDENTIFIER" },
    { "2.5.29.15",                        "KEY_USAGE" },
    { "2.5.29.16",                        "PRIVATE_KEY_USAGE_PERIOD" },
    { "2.5.29.17",                        "SUBJECT_ALT_NAME" },
    { "2.5.29.18",                        "ISSUER_ALT_NAME" },
    { "2.5.29.19",                        "BASIC_CONSTRAINTS" },
    { "2.5.29.20",                        "C_RL_NUMBER" },
    { "2.5.29.21",                        "C_RL_REASON" },
    { "2.5.29.22",                        "EXPIRATION_DATE" },
    { "2.5.29.23",                        "INSTRUCTION_CODE" },
    { "2.5.29.24",                        "INVALIDITY_DATE" },
    { "2.5.29.25",                        "C_RL_DISTRIBUTION_POINTS" },
    { "2.5.29.26",                        "ISSUING_DISTRIBUTION_POINT" },
    { "2.5.29.27",                        "DELTA_CRL_INDICATOR" },
    { "2.5.29.28",                        "ISSUING_DISTRIBUTION_POINT" },
    { "2.5.29.29",                        "CERTIFICATE_ISSUER" },
    { "2.5.29.30",                        "NAME_CONSTRAINTS" },
    { "2.5.29.31",                        "C_RL_DISTRIBUTION_POINTS" },
    { "2.5.29.32",                        "CERTIFICATE_POLICIES" },
    { "2.5.29.32.0",                      "ANY_POLICY" },
    { "2.5.29.33",                        "POLICY_MAPPINGS" },
    { "2.5.29.34",                        "POLICY_CONSTRAINTS" },
    { "2.5.29.35",                        "AUTHORITY_KEY_IDENTIFIER" },
    { "2.5.29.36",                        "POLICY_CONSTRAINTS" },
    { "2.5.29.37",                        "EXT_KEY_USAGE" },
    { "2.5.29.37.0",                      "ANY_EXTENDED_KEY_USAGE" },
    { "2.5.29.38",                        "AUTHORITY_ATTRIBUTE_IDENTIFIER" },
    { "2.5.29.39",                        "ROLE_SPEC_CERT_IDENTIFIER" },
    { "2.5.29.40",                        "C_RL_STREAM_IDENTIFIER" },
    { "2.5.29.41",                        "BASIC_ATT_CONSTRAINTS" },
    { "2.5.29.42",                        "DELEGATED_NAME_CONSTRAINTS" },
    { "2.5.29.43",                        "TIME_SPECIFICATION" },
    { "2.5.29.44",                        "C_RL_SCOPE" },
    { "2.5.29.45",                        "STATUS_REFERRALS" },
    { "2.5.29.46",                        "FRESHEST_CRL" },
    { "2.5.29.47",                        "ORDERED_LIST" },
    { "2.5.29.48",                        "ATTRIBUTE_DESCRIPTOR" },
    { "2.5.29.49",                        "USER_NOTICE" },
    { "2.5.29.50",                        "S_OA_IDENTIFIER" },
    { "2.5.29.51",                        "BASE_UPDATE_TIME" },
    { "2.5.29.52",                        "ACCEPTABLE_CERT_POLICIES" },
    { "2.5.29.53",                        "DELTA_INFO" },
    { "2.5.29.54",                        "INHIBIT_ANY_POLICY" },
    { "2.5.29.55",                        "TARGET_INFORMATION" },
    { "2.5.29.56",                        "NO_REV_AVAIL" },
    { "2.5.29.57",                        "ACCEPTABLE_PRIVILEGE_POLICIES" },
    { "2.5.29.58",                        "TO_BE_REVOKED" },
    { "2.5.29.59",                        "REVOKED_GROUPS" },
    { "2.5.29.60",                        "EXPIRED_CERTS_ON_CRL" },
    { "2.5.29.61",                        "INDIRECT_ISSUER" },
    { "2.5.29.62",                        "NO_ASSERTION" },
    { "2.5.29.63",                        "A_AISSUING_DISTRIBUTION_POINT" },
    { "2.5.29.64",                        "ISSUED_ON_BEHALF_OF" },
    { "2.5.29.65",                        "SINGLE_USE" },
    { "2.5.29.66",                        "GROUP_AC" },
    { "2.5.29.67",                        "ALLOWED_ATT_ASS" },
    { "2.5.29.68",                        "ATTRIBUTE_MAPPINGS" },
    { "2.5.29.69",                        "HOLDER_NAME_CONSTRAINTS" },
    { "2.16.724.1.2.2.4.1",               "PERSONAL_DATA_INFO" },
    { "2.16.840.1.101.2.1.1.1",           "SDNS_SIGNATURE_ALGORITHM" },
    { "2.16.840.1.101.2.1.1.2",           "FORTEZZA_SIGNATURE_ALGORITHM" },
    { "2.16.840.1.101.2.1.1.3",           "SDNS_CONFIDENTIALITY_ALGORITHM" },
    { "2.16.840.1.101.2.1.1.4",           "FORTEZZA_CONFIDENTIALITY_ALGORITHM" },
    { "2.16.840.1.101.2.1.1.5",           "SDNS_INTEGRITY_ALGORITHM" },
    { "2.16.840.1.101.2.1.1.6",           "FORTEZZA_INTEGRITY_ALGORITHM" },
    { "2.16.840.1.101.2.1.1.7",           "SDNS_TOKEN_PROTECTION_ALGORITHM" },
    { "2.16.840.1.101.2.1.1.8",           "FORTEZZA_TOKEN_PROTECTION_ALGORITHM" },
    { "2.16.840.1.101.2.1.1.9",           "SDNS_KEY_MANAGEMENT_ALGORITHM" },
    { "2.16.840.1.101.2.1.1.10",          "FORTEZZA_KEY_MANAGEMENT_ALGORITHM" },
    { "2.16.840.1.101.2.1.1.11",          "SDNS_K_MAND_SIG_ALGORITHM" },
    { "2.16.840.1.101.2.1.1.12",          "FORTEZZA_K_MAND_SIG_ALGORITHM" },
    { "2.16.840.1.101.2.1.1.13",          "SUITE_A_SIGNATURE_ALGORITHM" },
    { "2.16.840.1.101.2.1.1.14",          "SUITE_A_CONFIDENTIALITY_ALGORITHM" },
    { "2.16.840.1.101.2.1.1.15",          "SUITE_A_INTEGRITY_ALGORITHM" },
    { "2.16.840.1.101.2.1.1.16",          "SUITE_A_TOKEN_PROTECTION_ALGORITHM" },
    { "2.16.840.1.101.2.1.1.17",          "SUITE_A_KEY_MANAGEMENT_ALGORITHM" },
    { "2.16.840.1.101.2.1.1.18",          "SUITE_AK_MAND_SIG_ALGORITHM" },
    { "2.16.840.1.101.2.1.1.19",          "FORTEZZA_UPDATED_SIG_ALGORITHM" },
    { "2.16.840.1.101.2.1.1.20",          "FORTEZZA_K_MAND_UPD_SIG_ALGORITHMS" },
    { "2.16.840.1.101.2.1.1.21",          "FORTEZZA_UPDATED_INTEG_ALGORITHM" },
    { "2.16.840.1.101.2.1.1.22",          "KEY_EXCHANGE_ALGORITHM" },
    { "2.16.840.1.101.2.1.1.23",          "FORTEZZA_WRAP80_ALGORITHM" },
    { "2.16.840.1.101.2.1.1.24",          "K_EA_KEY_ENCRYPTION_ALGORITHM" },
    { "2.16.840.1.101.2.1.2.1",           "RFC822_MESSAGE_FORMAT" },
    { "2.16.840.1.101.2.1.2.2",           "EMPTY_CONTENT" },
    { "2.16.840.1.101.2.1.2.3",           "CSP_CONTENT_TYPE" },
    { "2.16.840.1.101.2.1.2.42",          "MSP_REV3_CONTENT_TYPE" },
    { "2.16.840.1.101.2.1.2.48",          "MSP_CONTENT_TYPE" },
    { "2.16.840.1.101.2.1.2.49",          "MSP_REKEY_AGENT_PROTOCOL" },
    { "2.16.840.1.101.2.1.2.50",          "MSP_MMP" },
    { "2.16.840.1.101.2.1.2.66",          "MSP_REV3_1_CONTENT_TYPE" },
    { "2.16.840.1.101.2.1.2.72",          "FORWARDED_MSP_MESSAGE_BODY_PART" },
    { "2.16.840.1.101.2.1.2.73",          "MSP_FORWARDED_MESSAGE_PARAMETERS" },
    { "2.16.840.1.101.2.1.2.74",          "FORWARDED_CSP_MSG_BODY_PART" },
    { "2.16.840.1.101.2.1.2.75",          "CSP_FORWARDED_MESSAGE_PARAMETERS" },
    { "2.16.840.1.101.2.1.2.76",          "MSP_MMP2" },
    { "2.16.840.1.101.2.1.3.1",           "SDNS_SECURITY_POLICY" },
    { "2.16.840.1.101.2.1.3.2",           "SDNS_PRBAC" },
    { "2.16.840.1.101.2.1.3.3",           "MOSAIC_PRBAC" },
    { "2.16.840.1.101.2.1.3.10",          "SI_SECURITY_POLICY" },
    { "2.16.840.1.101.2.1.3.10.0",        "SI_NASP" },
    { "2.16.840.1.101.2.1.3.10.1",        "SI_ELCO" },
    { "2.16.840.1.101.2.1.3.10.2",        "SI_TK" },
    { "2.16.840.1.101.2.1.3.10.3",        "SI_DSAP" },
    { "2.16.840.1.101.2.1.3.10.4",        "SI_SSSS" },
    { "2.16.840.1.101.2.1.3.10.5",        "SI_DNASP" },
    { "2.16.840.1.101.2.1.3.10.6",        "SI_BYEMAN" },
    { "2.16.840.1.101.2.1.3.10.7",        "SI_REL_US" },
    { "2.16.840.1.101.2.1.3.10.8",        "SI_REL_AUS" },
    { "2.16.840.1.101.2.1.3.10.9",        "SI_REL_CAN" },
    { "2.16.840.1.101.2.1.3.10.10",       "SI_REL_UK" },
    { "2.16.840.1.101.2.1.3.10.11",       "SI_REL_NZ" },
    { "2.16.840.1.101.2.1.3.10.12",       "SI_GENERIC" },
    { "2.16.840.1.101.2.1.3.11",          "GENSER" },
    { "2.16.840.1.101.2.1.3.11.0",        "GENSER_NATIONS" },
    { "2.16.840.1.101.2.1.3.11.1",        "GENSER_COMSEC" },
    { "2.16.840.1.101.2.1.3.11.2",        "GENSER_ACQUISITION" },
    { "2.16.840.1.101.2.1.3.11.3",        "GENSER_SECURITY_CATEGORIES" },
    { "2.16.840.1.101.2.1.3.11.3.0",      "GENSER_TAG_SET_NAME" },
    { "2.16.840.1.101.2.1.3.12",          "DEFAULT_SECURITY_POLICY" },
    { "2.16.840.1.101.2.1.3.13",          "CAPCO_MARKINGS" },
    { "2.16.840.1.101.2.1.3.13.0",        "CAPCO_SECURITY_CATEGORIES" },
    { "2.16.840.1.101.2.1.3.13.0.1",      "CAPCO_TAG_SET_NAME1" },
    { "2.16.840.1.101.2.1.3.13.0.2",      "CAPCO_TAG_SET_NAME2" },
    { "2.16.840.1.101.2.1.3.13.0.3",      "CAPCO_TAG_SET_NAME3" },
    { "2.16.840.1.101.2.1.3.13.0.4",      "CAPCO_TAG_SET_NAME4" },
    { "2.16.840.1.101.2.1.5.1",           "SDNS_KEY_MANAGEMENT_CERTIFICATE" },
    { "2.16.840.1.101.2.1.5.2",           "SDNS_USER_SIGNATURE_CERTIFICATE" },
    { "2.16.840.1.101.2.1.5.3",           "SDNS_K_MAND_SIG_CERTIFICATE" },
    { "2.16.840.1.101.2.1.5.4",           "FORTEZZA_KEY_MANAGEMENT_CERTIFICATE" },
    { "2.16.840.1.101.2.1.5.5",           "FORTEZZA_K_MAND_SIG_CERTIFICATE" },
    { "2.16.840.1.101.2.1.5.6",           "FORTEZZA_USER_SIGNATURE_CERTIFICATE" },
    { "2.16.840.1.101.2.1.5.7",           "FORTEZZA_CA_SIGNATURE_CERTIFICATE" },
    { "2.16.840.1.101.2.1.5.8",           "SDNS_CA_SIGNATURE_CERTIFICATE" },
    { "2.16.840.1.101.2.1.5.10",          "AUXILIARY_VECTOR" },
    { "2.16.840.1.101.2.1.5.11",          "ML_RECEIPT_POLICY" },
    { "2.16.840.1.101.2.1.5.12",          "ML_MEMBERSHIP" },
    { "2.16.840.1.101.2.1.5.13",          "ML_ADMINISTRATORS" },
    { "2.16.840.1.101.2.1.5.14",          "ALID" },
    { "2.16.840.1.101.2.1.5.20",          "JAN_UK_MS" },
    { "2.16.840.1.101.2.1.5.21",          "FEB_UK_MS" },
    { "2.16.840.1.101.2.1.5.22",          "MAR_UK_MS" },
    { "2.16.840.1.101.2.1.5.23",          "APR_UK_MS" },
    { "2.16.840.1.101.2.1.5.24",          "MAY_UK_MS" },
    { "2.16.840.1.101.2.1.5.25",          "JUN_UK_MS" },
    { "2.16.840.1.101.2.1.5.26",          "JUL_UK_MS" },
    { "2.16.840.1.101.2.1.5.27",          "AUG_UK_MS" },
    { "2.16.840.1.101.2.1.5.28",          "SEP_UK_MS" },
    { "2.16.840.1.101.2.1.5.29",          "OCT_UK_MS" },
    { "2.16.840.1.101.2.1.5.30",          "NOV_UK_MS" },
    { "2.16.840.1.101.2.1.5.31",          "DEC_UK_MS" },
    { "2.16.840.1.101.2.1.5.40",          "META_SDN_SCKL" },
    { "2.16.840.1.101.2.1.5.41",          "SDNS_CKL" },
    { "2.16.840.1.101.2.1.5.42",          "META_SDN_SSIGNATURE_CKL" },
    { "2.16.840.1.101.2.1.5.43",          "SDNS_SIGNATURE_CKL" },
    { "2.16.840.1.101.2.1.5.44",          "SDNS_CERTIFICATE_REVOCATION_LIST" },
    { "2.16.840.1.101.2.1.5.45",          "FORTEZZA_CERTIFICATE_REVOCATION_LIST" },
    { "2.16.840.1.101.2.1.5.46",          "FORTEZZA_CKL" },
    { "2.16.840.1.101.2.1.5.47",          "AL_EXEMPTED_ADDRESS_PROCESSOR" },
    { "2.16.840.1.101.2.1.5.48",          "GUARD" },
    { "2.16.840.1.101.2.1.5.49",          "ALGORITHMS_SUPPORTED" },
    { "2.16.840.1.101.2.1.5.50",          "SUITE_A_KEY_MANAGEMENT_CERTIFICATE" },
    { "2.16.840.1.101.2.1.5.51",          "SUITE_AK_MAND_SIG_CERTIFICATE" },
    { "2.16.840.1.101.2.1.5.52",          "SUITE_A_USER_SIGNATURE_CERTIFICATE" },
    { "2.16.840.1.101.2.1.5.53",          "PRBAC_INFO" },
    { "2.16.840.1.101.2.1.5.54",          "PRBAC_CA_CONSTRAINTS" },
    { "2.16.840.1.101.2.1.5.55",          "SIG_OR_KM_PRIVILEGES" },
    { "2.16.840.1.101.2.1.5.56",          "COMM_PRIVILEGES" },
    { "2.16.840.1.101.2.1.5.57",          "LABELED_ATTRIBUTE" },
    { "2.16.840.1.101.2.1.5.58",          "POLICY_INFORMATION_FILE" },
    { "2.16.840.1.101.2.1.5.59",          "SEC_POLICY_INFORMATION_FILE" },
    { "2.16.840.1.101.2.1.5.60",          "C_A_CLEARANCE_CONSTRAINT" },
    { "2.16.840.1.101.2.1.7.1",           "CSP_EXTNS" },
    { "2.16.840.1.101.2.1.7.1.0",         "CSP_CS_EXTN" },
    { "2.16.840.1.101.2.1.8.1",           "M_ISSI_SECURITY_CATEGORIES" },
    { "2.16.840.1.101.2.1.8.2",           "STANDARD_SECURITY_LABEL_PRIVILEGES" },
    { "2.16.840.1.101.2.1.10.1",          "SIG_PRIVILEGES" },
    { "2.16.840.1.101.2.1.10.2",          "KM_PRIVILEGES" },
    { "2.16.840.1.101.2.1.10.3",          "NAMED_TAG_SET_PRIVILEGE" },
    { "2.16.840.1.101.2.1.11.1",          "UK_DEMO" },
    { "2.16.840.1.101.2.1.11.2",          "US_DOD_CLASS2" },
    { "2.16.840.1.101.2.1.11.3",          "US_MEDIUM_PILOT" },
    { "2.16.840.1.101.2.1.11.4",          "US_DOD_CLASS4" },
    { "2.16.840.1.101.2.1.11.5",          "US_DOD_CLASS3" },
    { "2.16.840.1.101.2.1.11.6",          "US_DOD_CLASS5" },
    { "2.16.840.1.101.2.1.12.0",          "TEST_SECURITY_POLICY" },
    { "2.16.840.1.101.2.1.12.0.1",        "TSP1" },
    { "2.16.840.1.101.2.1.12.0.1.0",      "TSP1_SECURITY_CATEGORIES" },
    { "2.16.840.1.101.2.1.12.0.1.0.0",    "TSP1_TAG_SET_ZERO" },
    { "2.16.840.1.101.2.1.12.0.1.0.1",    "TSP1_TAG_SET_ONE" },
    { "2.16.840.1.101.2.1.12.0.1.0.2",    "TSP1_TAG_SET_TWO" },
    { "2.16.840.1.101.2.1.12.0.2",        "TSP2" },
    { "2.16.840.1.101.2.1.12.0.2.0",      "TSP2_SECURITY_CATEGORIES" },
    { "2.16.840.1.101.2.1.12.0.2.0.0",    "TSP2_TAG_SET_ZERO" },
    { "2.16.840.1.101.2.1.12.0.2.0.1",    "TSP2_TAG_SET_ONE" },
    { "2.16.840.1.101.2.1.12.0.2.0.2",    "TSP2_TAG_SET_TWO" },
    { "2.16.840.1.101.2.1.12.0.3",        "KAFKA" },
    { "2.16.840.1.101.2.1.12.0.3.0",      "KAFKA_SECURITY_CATEGORIES" },
    { "2.16.840.1.101.2.1.12.0.3.0.1",    "KAFKA_TAG_SET_NAME1" },
    { "2.16.840.1.101.2.1.12.0.3.0.2",    "KAFKA_TAG_SET_NAME2" },
    { "2.16.840.1.101.2.1.12.0.3.0.3",    "KAFKA_TAG_SET_NAME3" },
    { "2.16.840.1.101.2.1.12.1.1",        "TCP1" },
    { "2.16.840.1.101.3.1",               "SLABEL" },
    { "2.16.840.1.101.3.2",               "PKI" },
    { "2.16.840.1.101.3.2.1",             "NIST_POLICY_IDENTIFIER" },
    { "2.16.840.1.101.3.2.1.3.1",         "FBCA_RUDIMENTARY_POLICY" },
    { "2.16.840.1.101.3.2.1.3.2",         "FBCA_BASIC_POLICY" },
    { "2.16.840.1.101.3.2.1.3.3",         "FBCA_MEDIUM_POLICY" },
    { "2.16.840.1.101.3.2.1.3.4",         "FBCA_HIGH_POLICY" },
    { "2.16.840.1.101.3.2.1.48.1",        "NIST_TEST_POLICY1" },
    { "2.16.840.1.101.3.2.1.48.2",        "NIST_TEST_POLICY2" },
    { "2.16.840.1.101.3.2.1.48.3",        "NIST_TEST_POLICY3" },
    { "2.16.840.1.101.3.2.1.48.4",        "NIST_TEST_POLICY4" },
    { "2.16.840.1.101.3.2.1.48.5",        "NIST_TEST_POLICY5" },
    { "2.16.840.1.101.3.2.1.48.6",        "NIST_TEST_POLICY6" },
    { "2.16.840.1.101.3.2.2",             "GAK" },
    { "2.16.840.1.101.3.2.2.1",           "K_RA_KEY" },
    { "2.16.840.1.101.3.2.3",             "EXTENSIONS" },
    { "2.16.840.1.101.3.2.3.1",           "K_R_TECHNIQUE" },
    { "2.16.840.1.101.3.2.3.2",           "K_RECOVERY_CAPABLE" },
    { "2.16.840.1.101.3.2.3.3",           "K_R" },
    { "2.16.840.1.101.3.2.4",             "KEY_RECOVERY_SCHEMES" },
    { "2.16.840.1.101.3.2.5",             "KRAPOLA" },
    { "2.16.840.1.101.3.3",               "ARPA" },
    { "2.16.840.1.101.3.4",               "NIST_ALGORITHM" },
    { "2.16.840.1.101.3.4.1",             "AES" },
    { "2.16.840.1.101.3.4.1.1",           "AES128_ECB" },
    { "2.16.840.1.101.3.4.1.2",           "AES128_CBC" },
    { "2.16.840.1.101.3.4.1.3",           "AES128_OFB" },
    { "2.16.840.1.101.3.4.1.4",           "AES128_CFB" },
    { "2.16.840.1.101.3.4.1.5",           "AES128_WRAP" },
    { "2.16.840.1.101.3.4.1.6",           "AES128_GCM" },
    { "2.16.840.1.101.3.4.1.7",           "AES128_CCM" },
    { "2.16.840.1.101.3.4.1.8",           "AES128_WRAP_PAD" },
    { "2.16.840.1.101.3.4.1.21",          "AES192_ECB" },
    { "2.16.840.1.101.3.4.1.22",          "AES192_CBC" },
    { "2.16.840.1.101.3.4.1.23",          "AES192_OFB" },
    { "2.16.840.1.101.3.4.1.24",          "AES192_CFB" },
    { "2.16.840.1.101.3.4.1.25",          "AES192_WRAP" },
    { "2.16.840.1.101.3.4.1.26",          "AES192_GCM" },
    { "2.16.840.1.101.3.4.1.27",          "AES192_CCM" },
    { "2.16.840.1.101.3.4.1.28",          "AES192_WRAP_PAD" },
    { "2.16.840.1.101.3.4.1.41",          "AES256_ECB" },
    { "2.16.840.1.101.3.4.1.42",          "AES256_CBC" },
    { "2.16.840.1.101.3.4.1.43",          "AES256_OFB" },
    { "2.16.840.1.101.3.4.1.44",          "AES256_CFB" },
    { "2.16.840.1.101.3.4.1.45",          "AES256_WRAP" },
    { "2.16.840.1.101.3.4.1.46",          "AES256_GCM" },
    { "2.16.840.1.101.3.4.1.47",          "AES256_CCM" },
    { "2.16.840.1.101.3.4.1.48",          "AES256_WRAP_PAD" },
    { "2.16.840.1.101.3.4.2",             "HASH_ALGOS" },
    { "2.16.840.1.101.3.4.2.1",           "SHA_256" },
    { "2.16.840.1.101.3.4.2.2",           "SHA_384" },
    { "2.16.840.1.101.3.4.2.3",           "SHA_512" },
    { "2.16.840.1.101.3.4.2.4",           "SHA_224" },
    { "2.16.840.1.101.3.4.3.1",           "DSA_WITH_SHA224" },
    { "2.16.840.1.101.3.4.3.2",           "DSA_WITH_SHA256" },
    { "2.16.840.1.113719.1.2.8",          "NOVELL_ALGORITHM" },
    { "2.16.840.1.113719.1.2.8.22",       "DES_CBC_IV8" },
    { "2.16.840.1.113719.1.2.8.23",       "DES_CBC_PAD_IV8" },
    { "2.16.840.1.113719.1.2.8.24",       "DES_EDE2_CBC_IV8" },
    { "2.16.840.1.113719.1.2.8.25",       "DES_EDE2_CBC_PAD_IV8" },
    { "2.16.840.1.113719.1.2.8.26",       "DES_EDE3_CBC_IV8" },
    { "2.16.840.1.113719.1.2.8.27",       "DES_EDE3_CBC_PAD_IV8" },
    { "2.16.840.1.113719.1.2.8.28",       "RC5_CBC_PAD" },
    { "2.16.840.1.113719.1.2.8.29",       "MD2_WITH_RSA_ENCRYPTION_B_SAFE1" },
    { "2.16.840.1.113719.1.2.8.30",       "MD5_WITH_RSA_ENCRYPTION_B_SAFE1" },
    { "2.16.840.1.113719.1.2.8.31",       "SHA1_WITH_RSA_ENCRYPTION_B_SAFE1" },
    { "2.16.840.1.113719.1.2.8.32",       "LM_DIGEST" },
    { "2.16.840.1.113719.1.2.8.40",       "MD2" },
    { "2.16.840.1.113719.1.2.8.50",       "MD5" },
    { "2.16.840.1.113719.1.2.8.51",       "IKE_HMAC_WITH_SHA1_RSA" },
    { "2.16.840.1.113719.1.2.8.52",       "IKE_HMAC_WITH_MD5_RSA" },
    { "2.16.840.1.113719.1.2.8.69",       "RC2_CBC_PAD" },
    { "2.16.840.1.113719.1.2.8.82",       "SHA_1" },
    { "2.16.840.1.113719.1.2.8.92",       "RC2_B_SAFE1_CBC" },
    { "2.16.840.1.113719.1.2.8.95",       "MD4" },
    { "2.16.840.1.113719.1.2.8.130",      "MD4_PACKET" },
    { "2.16.840.1.113719.1.2.8.131",      "RSA_ENCRYPTION_BSAFE1" },
    { "2.16.840.1.113719.1.2.8.132",      "NW_PASSWORD" },
    { "2.16.840.1.113719.1.2.8.133",      "NOVELL_OBFUSCATE_1" },
    { "2.16.840.1.113719.1.9",            "PKI" },
    { "2.16.840.1.113719.1.9.4",          "PKI_ATTRIBUTE_TYPE" },
    { "2.16.840.1.113719.1.9.4.1",        "SECURITY_ATTRIBUTES" },
    { "2.16.840.1.113719.1.9.4.2",        "RELIANCE_LIMIT" },
    { "2.16.840.1.113730.1",              "CERT_EXTENSION" },
    { "2.16.840.1.113730.1.1",            "NETSCAPE_CERT_TYPE" },
    { "2.16.840.1.113730.1.2",            "NETSCAPE_BASE_URL" },
    { "2.16.840.1.113730.1.3",            "NETSCAPE_REVOCATION_URL" },
    { "2.16.840.1.113730.1.4",            "NETSCAPE_CA_REVOCATION_URL" },
    { "2.16.840.1.113730.1.7",            "NETSCAPE_CERT_RENEWAL_URL" },
    { "2.16.840.1.113730.1.8",            "NETSCAPE_CA_POLICY_URL" },
    { "2.16.840.1.113730.1.9",            "HOME_PAGE_URL" },
    { "2.16.840.1.113730.1.10",           "ENTITY_LOGO" },
    { "2.16.840.1.113730.1.11",           "USER_PICTURE" },
    { "2.16.840.1.113730.1.12",           "NETSCAPE_SSL_SERVER_NAME" },
    { "2.16.840.1.113730.1.13",           "NETSCAPE_COMMENT" },
    { "2.16.840.1.113730.2",              "DATA_TYPE" },
    { "2.16.840.1.113730.2.1",            "DATA_GIF" },
    { "2.16.840.1.113730.2.2",            "DATA_JPEG" },
    { "2.16.840.1.113730.2.3",            "DATA_URL" },
    { "2.16.840.1.113730.2.4",            "DATA_HTML" },
    { "2.16.840.1.113730.2.5",            "CERT_SEQUENCE" },
    { "2.16.840.1.113730.2.6",            "CERT_URL" },
    { "2.16.840.1.113730.3",              "DIRECTORY" },
    { "2.16.840.1.113730.3.1",            "LDAP_DEFINITIONS" },
    { "2.16.840.1.113730.3.1.1",          "CAR_LICENSE" },
    { "2.16.840.1.113730.3.1.2",          "DEPARTMENT_NUMBER" },
    { "2.16.840.1.113730.3.1.3",          "EMPLOYEE_NUMBER" },
    { "2.16.840.1.113730.3.1.4",          "EMPLOYEE_TYPE" },
    { "2.16.840.1.113730.3.2.2",          "INET_ORG_PERSON" },
    { "2.16.840.1.113730.4.1",            "SERVER_GATED_CRYPTO" },
    { "2.16.840.1.113733.1.6.3",          "VERISIGN_CZAG" },
    { "2.16.840.1.113733.1.6.6",          "VERISIGN_IN_BOX" },
    { "2.16.840.1.113733.1.6.11",         "VERISIGN_ONSITE_JURISDICTION_HASH" },
    { "2.16.840.1.113733.1.6.13",         "UNKNOWN_VERISIGN_VPN_EXTENSION" },
    { "2.16.840.1.113733.1.6.15",         "VERISIGN_SERVER_ID" },
    { "2.16.840.1.113733.1.7.1.1",        "VERISIGN_CERT_POLICIES95_QUALIFIER1" },
    { "2.16.840.1.113733.1.7.1.1.1",      "VERISIGN_CP_SV1NOTICE" },
    { "2.16.840.1.113733.1.7.1.1.2",      "VERISIGN_CP_SV1NSI" },
    { "2.16.840.1.113733.1.8.1",          "VERISIGN_ISS_STRONG_CRYPTO" },
    { "2.16.840.1.113733.1",              "PKI" },
    { "2.16.840.1.113733.1.9",            "PKCS7_ATTRIBUTE" },
    { "2.16.840.1.113733.1.9.2",          "MESSAGE_TYPE" },
    { "2.16.840.1.113733.1.9.3",          "PKI_STATUS" },
    { "2.16.840.1.113733.1.9.4",          "FAIL_INFO" },
    { "2.16.840.1.113733.1.9.5",          "SENDER_NONCE" },
    { "2.16.840.1.113733.1.9.6",          "RECIPIENT_NONCE" },
    { "2.16.840.1.113733.1.9.7",          "TRANS_ID" },
    { "2.16.840.1.113733.1.9.8",          "EXTENSION_REQ" },
    { "2.16.840.1.113741.2",              "INTEL_CDSA" },
    { "2.16.840.1.114412.1",              "DIGI_CERT_NON_EV_CERTS" },
    { "2.16.840.1.114412.1.1",            "DIGI_CERT_OV_CERT" },
    { "2.16.840.1.114412.1.2",            "DIGI_CERT_DV_CERT" },
    { "2.16.840.1.114412.1.11",           "DIGI_CERT_FEDERATED_DEVICE_CERT" },
    { "2.16.840.1.114412.1.3.0.1",        "DIGI_CERT_GLOBAL_CA_POLICY" },
    { "2.16.840.1.114412.1.3.0.2",        "DIGI_CERT_HIGH_ASSURANCE_EVCA_POLICY" },
    { "2.16.840.1.114412.1.3.0.3",        "DIGI_CERT_GLOBAL_ROOT_CA_POLICY" },
    { "2.16.840.1.114412.1.3.0.4",        "DIGI_CERT_ASSURED_ID_ROOT_CA_POLICY" },
    { "2.16.840.1.114412.2.2",            "DIGI_CERT_EV_CERT" },
    { "2.16.840.1.114412.2.3",            "DIGI_CERT_OBJECT_SIGNING_CERT" },
    { "2.16.840.1.114412.2.3.1",          "DIGI_CERT_CODE_SIGNING_CERT" },
    { "2.16.840.1.114412.2.3.2",          "DIGI_CERT_EV_CODE_SIGNING_CERT" },
    { "2.16.840.1.114412.2.3.11",         "DIGI_CERT_KERNEL_CODE_SIGNING_CERT" },
    { "2.16.840.1.114412.2.3.21",         "DIGI_CERT_DOCUMENT_SIGNING_CERT" },
    { "2.16.840.1.114412.2.4",            "DIGI_CERT_CLIENT_CERT" },
    { "2.16.840.1.114412.2.4.1.1",        "DIGI_CERT_LEVEL1_PERSONAL_CLIENT_CERT" },
    { "2.16.840.1.114412.2.4.1.2",        "DIGI_CERT_LEVEL1_ENTERPRISE_CLIENT_CERT" },
    { "2.16.840.1.114412.2.4.2",          "DIGI_CERT_LEVEL2_CLIENT_CERT" },
    { "2.16.840.1.114412.2.4.3.1",        "DIGI_CERT_LEVEL3_US_CLIENT_CERT" },
    { "2.16.840.1.114412.2.4.3.2",        "DIGI_CERT_LEVEL3_CBP_CLIENT_CERT" },
    { "2.16.840.1.114412.2.4.4.1",        "DIGI_CERT_LEVEL4_US_CLIENT_CERT" },
    { "2.16.840.1.114412.2.4.4.2",        "DIGI_CERT_LEVEL4_CBP_CLIENT_CERT" },
    { "2.16.840.1.114412.2.4.5.1",        "DIGI_CERT_PIV_HARDWARE_CERT" },
    { "2.16.840.1.114412.2.4.5.2",        "DIGI_CERT_PIV_CARD_AUTH_CERT" },
    { "2.16.840.1.114412.2.4.5.3",        "DIGI_CERT_PIV_CONTENT_SIGNING_CERT" },
    { "2.16.840.1.114412.4.31",           "DIGI_CERT_GRID_CLASSIC_CERT" },
    { "2.16.840.1.114412.4.31.5",         "DIGI_CERT_GRID_INTEGRATED_CERT" },
    { "2.16.840.1.114412.31.4.31.1",      "DIGI_CERT_GRID_HOST_CERT" },
    { "2.23.42.0",                        "CONTENT_TYPE" },
    { "2.23.42.0.0",                      "PAN_DATA" },
    { "2.23.42.0.1",                      "PAN_TOKEN" },
    { "2.23.42.0.2",                      "PAN_ONLY" },
    { "2.23.42.1",                        "MSG_EXT" },
    { "2.23.42.2",                        "FIELD" },
    { "2.23.42.2.0",                      "FULL_NAME" },
    { "2.23.42.2.1",                      "GIVEN_NAME" },
    { "2.23.42.2.2",                      "FAMILY_NAME" },
    { "2.23.42.2.3",                      "BIRTH_FAMILY_NAME" },
    { "2.23.42.2.4",                      "PLACE_NAME" },
    { "2.23.42.2.5",                      "IDENTIFICATION_NUMBER" },
    { "2.23.42.2.6",                      "MONTH" },
    { "2.23.42.2.7",                      "DATE" },
    { "2.23.42.2.8",                      "ADDRESS" },
    { "2.23.42.2.9",                      "TELEPHONE" },
    { "2.23.42.2.10",                     "AMOUNT" },
    { "2.23.42.2.11",                     "ACCOUNT_NUMBER" },
    { "2.23.42.2.12",                     "PASS_PHRASE" },
    { "2.23.42.3",                        "ATTRIBUTE" },
    { "2.23.42.3.0",                      "CERT" },
    { "2.23.42.3.0.0",                    "ROOT_KEY_THUMB" },
    { "2.23.42.3.0.1",                    "ADDITIONAL_POLICY" },
    { "2.23.42.4",                        "ALGORITHM" },
    { "2.23.42.5",                        "POLICY" },
    { "2.23.42.5.0",                      "ROOT" },
    { "2.23.42.6",                        "MODULE" },
    { "2.23.42.7",                        "CERT_EXT" },
    { "2.23.42.7.0",                      "HASHED_ROOT_KEY" },
    { "2.23.42.7.1",                      "CERTIFICATE_TYPE" },
    { "2.23.42.7.2",                      "MERCHANT_DATA" },
    { "2.23.42.7.3",                      "CARD_CERT_REQUIRED" },
    { "2.23.42.7.4",                      "TUNNELING" },
    { "2.23.42.7.5",                      "SET_EXTENSIONS" },
    { "2.23.42.7.6",                      "SET_QUALIFIER" },
    { "2.23.42.8",                        "BRAND" },
    { "2.23.42.8.1",                      "IATA_ATA" },
    { "2.23.42.8.4",                      "VISA" },
    { "2.23.42.8.5",                      "MASTER_CARD" },
    { "2.23.42.8.30",                     "DINERS" },
    { "2.23.42.8.34",                     "AMERICAN_EXPRESS" },
    { "2.23.42.8.6011",                   "NOVUS" },
    { "2.23.42.9",                        "VENDOR" },
    { "2.23.42.9.0",                      "GLOBE_SET" },
    { "2.23.42.9.1",                      "IBM" },
    { "2.23.42.9.2",                      "CYBER_CASH" },
    { "2.23.42.9.3",                      "TERISA" },
    { "2.23.42.9.4",                      "RSADSI" },
    { "2.23.42.9.5",                      "VERI_FONE" },
    { "2.23.42.9.6",                      "TRIN_TECH" },
    { "2.23.42.9.7",                      "BANK_GATE" },
    { "2.23.42.9.8",                      "GTE" },
    { "2.23.42.9.9",                      "COMPU_SOURCE" },
    { "2.23.42.9.10",                     "GRIFFIN" },
    { "2.23.42.9.11",                     "CERTICOM" },
    { "2.23.42.9.12",                     "OSS" },
    { "2.23.42.9.13",                     "TENTH_MOUNTAIN" },
    { "2.23.42.9.14",                     "ANTARES" },
    { "2.23.42.9.15",                     "ECC" },
    { "2.23.42.9.16",                     "MAITHEAN" },
    { "2.23.42.9.17",                     "NETSCAPE" },
    { "2.23.42.9.18",                     "VERISIGN" },
    { "2.23.42.9.19",                     "BLUE_MONEY" },
    { "2.23.42.9.20",                     "LACERTE" },
    { "2.23.42.9.21",                     "FUJITSU" },
    { "2.23.42.9.22",                     "E_LAB" },
    { "2.23.42.9.23",                     "ENTRUST" },
    { "2.23.42.9.24",                     "VI_ANET" },
    { "2.23.42.9.25",                     "III" },
    { "2.23.42.9.26",                     "OPEN_MARKET" },
    { "2.23.42.9.27",                     "LEXEM" },
    { "2.23.42.9.28",                     "INTERTRADER" },
    { "2.23.42.9.29",                     "PERSIMMON" },
    { "2.23.42.9.30",                     "NABLE" },
    { "2.23.42.9.31",                     "ESPACE_NET" },
    { "2.23.42.9.32",                     "HITACHI" },
    { "2.23.42.9.33",                     "MICROSOFT" },
    { "2.23.42.9.34",                     "NEC" },
    { "2.23.42.9.35",                     "MITSUBISHI" },
    { "2.23.42.9.36",                     "NCR" },
    { "2.23.42.9.37",                     "E_COMM" },
    { "2.23.42.9.38",                     "GEMPLUS" },
    { "2.23.42.10",                       "NATIONAL" },
    { "2.23.42.10.392",                   "JAPAN" },
    { "2.23.43.1.4",                      "W_TLS_ECC" },
    { "2.23.43.1.4.1",                    "W_TLS_ECC_CURVE1" },
    { "2.23.43.1.4.6",                    "W_TLS_ECC_CURVE6" },
    { "2.23.43.1.4.8",                    "W_TLS_ECC_CURVE8" },
    { "2.23.43.1.4.9",                    "W_TLS_ECC_CURVE9" },
    { "2.23.133",                         "T_CPA" },
    { "2.23.133.1",                       "TCPA_SPEC_VERSION" },
    { "2.23.133.2",                       "TCPA_ATTRIBUTE" },
    { "2.23.133.2.1",                     "TCPA_TPM_MANUFACTURER" },
    { "2.23.133.2.2",                     "TCPA_TPM_MODEL" },
    { "2.23.133.2.3",                     "TCPA_TPM_VERSION" },
    { "2.23.133.2.4",                     "TCPA_PLATFORM_MANUFACTURER" },
    { "2.23.133.2.5",                     "TCPA_PLATFORM_MODEL" },
    { "2.23.133.2.6",                     "TCPA_PLATFORM_VERSION" },
    { "2.23.133.2.7",                     "TCPA_COMPONENT_MANUFACTURER" },
    { "2.23.133.2.8",                     "TCPA_COMPONENT_MODEL" },
    { "2.23.133.2.9",                     "TCPA_COMPONENT_VERSION" },
    { "2.23.133.2.10",                    "TCPA_SECURITY_QUALITIES" },
    { "2.23.133.2.11",                    "TCPA_TPM_PROTECTION_PROFILE" },
    { "2.23.133.2.12",                    "TCPA_TPM_SECURITY_TARGET" },
    { "2.23.133.2.13",                    "TCPA_FOUNDATION_PROTECTION_PROFILE" },
    { "2.23.133.2.14",                    "TCPA_FOUNDATION_SECURITY_TARGET" },
    { "2.23.133.2.15",                    "TCPA_TPM_ID_LABEL" },
    { "2.23.133.3",                       "TCPA_PROTOCOL" },
    { "2.23.133.3.1",                     "TCPA_PRTT_TPM_ID_PROTOCOL" },
    { "2.23.134.1.4.2.1",                 "POST_SIGNUM_ROOT_QCA" },
    { "2.23.134.1.2.2.3",                 "POST_SIGNUM_PUBLIC_CA" },
    { "2.23.134.1.2.1.8.210",             "POST_SIGNUM_COMMERCIAL_SERVER_POLICY" },
    { "2.23.136.1.1.1",                   "M_RTD_SIGNATURE_DATA" },
    { "2.54.1775.2",                      "HASHED_ROOT_KEY" },
    { "2.54.1775.3",                      "CERTIFICATE_TYPE" },
    { "2.54.1775.4",                      "MERCHANT_DATA" },
    { "2.54.1775.5",                      "CARD_CERT_REQUIRED" },
    { "2.54.1775.6",                      "TUNNELING" },
    { "2.54.1775.7",                      "SET_QUALIFIER" },
    { "2.54.1775.99",                     "SET_DATA" },
    { "1.2.40.0.17.1.22",                 "A_TRUST_EV_POLICY" },
    { "1.3.6.1.4.1.34697.2.1",            "AFFIRM_TRUST_EV_POLICY" },
    { "1.3.6.1.4.1.34697.2.2",            "AFFIRM_TRUST_EV_POLICY" },
    { "1.3.6.1.4.1.34697.2.3",            "AFFIRM_TRUST_EV_POLICY" },
    { "1.3.6.1.4.1.34697.2.4",            "AFFIRM_TRUST_EV_POLICY" },
    { "2.16.578.1.26.1.3.3",              "BUY_PASS_EV_POLICY" },
    { "1.3.6.1.4.1.17326.10.14.2.1.2",    "CAMERFIRMA_EV_POLICY" },
    { "1.3.6.1.4.1.17326.10.8.12.1.2",    "CAMERFIRMA_EV_POLICY" },
    { "1.3.6.1.4.1.22234.2.5.2.3.1",      "CERT_PLUS_EV_POLICY" },
    { "1.3.6.1.4.1.6449.1.2.1.5.1",       "COMODO_EV_POLICY" },
    { "1.3.6.1.4.1.6334.1.100.1",         "CYBERTRUST_EV_POLICY" },
    { "1.3.6.1.4.1.4788.2.202.1",         "D_TRUST_EV_POLICY" },
    { "2.16.840.1.114412.2.1",            "DIGI_CERT_EV_POLICY" },
    { "2.16.528.1.1001.1.1.1.12.6.1.1.1", "DIGI_NOTAR_EV_POLICY" },
    { "2.16.840.1.114028.10.1.2",         "ENTRUST_EV_POLICY" },
    { "1.3.6.1.4.1.14370.1.6",            "GEO_TRUST_EV_POLICY" },
    { "1.3.6.1.4.1.4146.1.1",             "GLOBAL_SIGN_EV_POLICY" },
    { "2.16.840.1.114413.1.7.23.3",       "GO_DADDY_EV_POLICY" },
    { "1.3.6.1.4.1.14777.6.1.1",          "IZENPE_EV_POLICY" },
    { "1.3.6.1.4.1.14777.6.1.2",          "IZENPE_EV_POLICY" },
    { "1.3.6.1.4.1.782.1.2.1.8.1",        "NETWORK_SOLUTIONS_EV_POLICY" },
    { "1.3.6.1.4.1.8024.0.2.100.1.2",     "QUO_VADIS_EV_POLICY" },
    { "1.2.392.200091.100.721.1",         "SECURITY_COMMUNICATION_(SECOM)_EV_POLICY" },
    { "2.16.840.1.114414.1.7.23.3",       "STARFIELD_EV_POLICY" },
    { "1.3.6.1.4.1.23223.1.1.1",          "START_COM_EV_POLICY" },
    { "2.16.756.1.89.1.2.1.1",            "SWISS_SIGN_EV_POLICY" },
    { "1.3.6.1.4.1.7879.13.24.1",         "T_TELE_SEC_EV_POLICY" },
    { "2.16.840.1.113733.1.7.48.1",       "THAWTE_EV_POLICY" },
    { "2.16.840.1.114404.1.1.2.4.1",      "TRUST_WAVE_EV_POLICY" },
    { "1.3.6.1.4.1.40869.1.1.22.3",       "TWCA_EV_POLICY" },
    { "2.16.840.1.113733.1.7.23.6",       "VERI_SIGN_EV_POLICY" },
    { "2.16.840.1.114171.500.9",          "WELLS_FARGO_EV_POLICY" }
  };
  auto   it  = oid_to_str.find(oid);
  return it == oid_to_str.end() ? "Out of range" : it->second;
}

}
}
