/* Copyright 2017 R. Thomas
 * Copyright 2017 Quarkslab
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#ifndef LIEF_PE_MSVCRT_DLL_LOOKUP_H_
#define LIEF_PE_MSVCRT_DLL_LOOKUP_H_

#include <map>

namespace LIEF {
namespace PE {

static const std::map<uint32_t, const char*> msvcrt_dll_lookup {
    { 0x0038, "$I10_OUTPUT"                                                  },
    { 0x0001, "??0__non_rtti_object@@QAE@ABV0@@Z"                            },
    { 0x0002, "??0__non_rtti_object@@QAE@PBD@Z"                              },
    { 0x0003, "??0bad_cast@@AAE@PBQBD@Z"                                     },
    { 0x0004, "??0bad_cast@@QAE@ABQBD@Z"                                     },
    { 0x0005, "??0bad_cast@@QAE@ABV0@@Z"                                     },
    { 0x0006, "??0bad_cast@@QAE@PBD@Z"                                       },
    { 0x0007, "??0bad_typeid@@QAE@ABV0@@Z"                                   },
    { 0x0008, "??0bad_typeid@@QAE@PBD@Z"                                     },
    { 0x0009, "??0exception@@QAE@ABQBD@Z"                                    },
    { 0x000a, "??0exception@@QAE@ABV0@@Z"                                    },
    { 0x000b, "??0exception@@QAE@XZ"                                         },
    { 0x000c, "??1__non_rtti_object@@UAE@XZ"                                 },
    { 0x000d, "??1bad_cast@@UAE@XZ"                                          },
    { 0x000e, "??1bad_typeid@@UAE@XZ"                                        },
    { 0x000f, "??1exception@@UAE@XZ"                                         },
    { 0x0010, "??1type_info@@UAE@XZ"                                         },
    { 0x0011, "??2@YAPAXI@Z"                                                 },
    { 0x0012, "??3@YAXPAX@Z"                                                 },
    { 0x0013, "??4__non_rtti_object@@QAEAAV0@ABV0@@Z"                        },
    { 0x0014, "??4bad_cast@@QAEAAV0@ABV0@@Z"                                 },
    { 0x0015, "??4bad_typeid@@QAEAAV0@ABV0@@Z"                               },
    { 0x0016, "??4exception@@QAEAAV0@ABV0@@Z"                                },
    { 0x0017, "??8type_info@@QBEHABV0@@Z"                                    },
    { 0x0018, "??9type_info@@QBEHABV0@@Z"                                    },
    { 0x0019, "??_7__non_rtti_object@@6B@"                                   },
    { 0x001a, "??_7bad_cast@@6B@"                                            },
    { 0x001b, "??_7bad_typeid@@6B@"                                          },
    { 0x001c, "??_7exception@@6B@"                                           },
    { 0x001d, "??_E__non_rtti_object@@UAEPAXI@Z"                             },
    { 0x001e, "??_Ebad_cast@@UAEPAXI@Z"                                      },
    { 0x001f, "??_Ebad_typeid@@UAEPAXI@Z"                                    },
    { 0x0020, "??_Eexception@@UAEPAXI@Z"                                     },
    { 0x0021, "??_Fbad_cast@@QAEXXZ"                                         },
    { 0x0022, "??_Fbad_typeid@@QAEXXZ"                                       },
    { 0x0023, "??_G__non_rtti_object@@UAEPAXI@Z"                             },
    { 0x0024, "??_Gbad_cast@@UAEPAXI@Z"                                      },
    { 0x0025, "??_Gbad_typeid@@UAEPAXI@Z"                                    },
    { 0x0026, "??_Gexception@@UAEPAXI@Z"                                     },
    { 0x0027, "??_U@YAPAXI@Z"                                                },
    { 0x0028, "??_V@YAXPAX@Z"                                                },
    { 0x002a, "?_query_new_handler@@YAP6AHI@ZXZ"                             },
    { 0x002b, "?_query_new_mode@@YAHXZ"                                      },
    { 0x002c, "?_set_new_handler@@YAP6AHI@ZP6AHI@Z@Z"                        },
    { 0x002d, "?_set_new_mode@@YAHH@Z"                                       },
    { 0x002e, "?_set_se_translator@@YAP6AXIPAU_EXCEPTION_POINTERS@@@ZP6AXI0@Z@Z" },
    { 0x002f, "?before@type_info@@QBEHABV1@@Z"                               },
    { 0x0030, "?name@type_info@@QBEPBDXZ"                                    },
    { 0x0031, "?raw_name@type_info@@QBEPBDXZ"                                },
    { 0x0032, "?set_new_handler@@YAP6AXXZP6AXXZ@Z"                           },
    { 0x0033, "?set_terminate@@YAP6AXXZP6AXXZ@Z"                             },
    { 0x0034, "?set_unexpected@@YAP6AXXZP6AXXZ@Z"                            },
    { 0x0035, "?terminate@@YAXXZ"                                            },
    { 0x0036, "?unexpected@@YAXXZ"                                           },
    { 0x0037, "?what@exception@@UBEPBDXZ"                                    },
    { 0x0039, "_CIacos"                                                      },
    { 0x003a, "_CIasin"                                                      },
    { 0x003b, "_CIatan"                                                      },
    { 0x003c, "_CIatan2"                                                     },
    { 0x003d, "_CIcos"                                                       },
    { 0x003e, "_CIcosh"                                                      },
    { 0x003f, "_CIexp"                                                       },
    { 0x0040, "_CIfmod"                                                      },
    { 0x0041, "_CIlog"                                                       },
    { 0x0042, "_CIlog10"                                                     },
    { 0x0043, "_CIpow"                                                       },
    { 0x0044, "_CIsin"                                                       },
    { 0x0045, "_CIsinh"                                                      },
    { 0x0046, "_CIsqrt"                                                      },
    { 0x0047, "_CItan"                                                       },
    { 0x0048, "_CItanh"                                                      },
    { 0x0049, "_CxxThrowException"                                           },
    { 0x004a, "_EH_prolog"                                                   },
    { 0x004b, "_Getdays"                                                     },
    { 0x004c, "_Getmonths"                                                   },
    { 0x004d, "_Gettnames"                                                   },
    { 0x004e, "_HUGE"                                                        },
    { 0x004f, "_Strftime"                                                    },
    { 0x0050, "_XcptFilter"                                                  },
    { 0x0051, "__CxxCallUnwindDtor"                                          },
    { 0x0052, "__CxxDetectRethrow"                                           },
    { 0x0053, "__CxxExceptionFilter"                                         },
    { 0x0054, "__CxxFrameHandler"                                            },
    { 0x0055, "__CxxLongjmpUnwind"                                           },
    { 0x0056, "__CxxQueryExceptionSize"                                      },
    { 0x0057, "__CxxRegisterExceptionObject"                                 },
    { 0x0058, "__CxxUnregisterExceptionObject"                               },
    { 0x0059, "__DestructExceptionObject"                                    },
    { 0x005a, "__RTCastToVoid"                                               },
    { 0x005b, "__RTDynamicCast"                                              },
    { 0x005c, "__RTtypeid"                                                   },
    { 0x005d, "__STRINGTOLD"                                                 },
    { 0x005e, "___lc_codepage_func"                                          },
    { 0x005f, "___lc_handle_func"                                            },
    { 0x0060, "___mb_cur_max_func"                                           },
    { 0x0061, "___setlc_active_func"                                         },
    { 0x0062, "___unguarded_readlc_active_add_func"                          },
    { 0x0063, "__argc"                                                       },
    { 0x0064, "__argv"                                                       },
    { 0x0065, "__badioinfo"                                                  },
    { 0x0066, "__crtCompareStringA"                                          },
    { 0x0067, "__crtCompareStringW"                                          },
    { 0x0068, "__crtGetLocaleInfoW"                                          },
    { 0x0069, "__crtGetStringTypeW"                                          },
    { 0x006a, "__crtLCMapStringA"                                            },
    { 0x006b, "__crtLCMapStringW"                                            },
    { 0x006c, "__dllonexit"                                                  },
    { 0x006d, "__doserrno"                                                   },
    { 0x006e, "__fpecode"                                                    },
    { 0x006f, "__getmainargs"                                                },
    { 0x0070, "__initenv"                                                    },
    { 0x0071, "__iob_func"                                                   },
    { 0x0072, "__isascii"                                                    },
    { 0x0073, "__iscsym"                                                     },
    { 0x0074, "__iscsymf"                                                    },
    { 0x0075, "__lc_codepage"                                                },
    { 0x0076, "__lc_collate_cp"                                              },
    { 0x0077, "__lc_handle"                                                  },
    { 0x0078, "__lconv_init"                                                 },
    { 0x0079, "__mb_cur_max"                                                 },
    { 0x007a, "__p___argc"                                                   },
    { 0x007b, "__p___argv"                                                   },
    { 0x007c, "__p___initenv"                                                },
    { 0x007d, "__p___mb_cur_max"                                             },
    { 0x007e, "__p___wargv"                                                  },
    { 0x007f, "__p___winitenv"                                               },
    { 0x0080, "__p__acmdln"                                                  },
    { 0x0081, "__p__amblksiz"                                                },
    { 0x0082, "__p__commode"                                                 },
    { 0x0083, "__p__daylight"                                                },
    { 0x0084, "__p__dstbias"                                                 },
    { 0x0085, "__p__environ"                                                 },
    { 0x0086, "__p__fileinfo"                                                },
    { 0x0087, "__p__fmode"                                                   },
    { 0x0088, "__p__iob"                                                     },
    { 0x0089, "__p__mbcasemap"                                               },
    { 0x008a, "__p__mbctype"                                                 },
    { 0x008b, "__p__osver"                                                   },
    { 0x008c, "__p__pctype"                                                  },
    { 0x008d, "__p__pgmptr"                                                  },
    { 0x008e, "__p__pwctype"                                                 },
    { 0x008f, "__p__timezone"                                                },
    { 0x0090, "__p__tzname"                                                  },
    { 0x0091, "__p__wcmdln"                                                  },
    { 0x0092, "__p__wenviron"                                                },
    { 0x0093, "__p__winmajor"                                                },
    { 0x0094, "__p__winminor"                                                },
    { 0x0095, "__p__winver"                                                  },
    { 0x0096, "__p__wpgmptr"                                                 },
    { 0x0097, "__pctype_func"                                                },
    { 0x0098, "__pioinfo"                                                    },
    { 0x0099, "__pxcptinfoptrs"                                              },
    { 0x009a, "__set_app_type"                                               },
    { 0x009b, "__setlc_active"                                               },
    { 0x009c, "__setusermatherr"                                             },
    { 0x009d, "__threadhandle"                                               },
    { 0x009e, "__threadid"                                                   },
    { 0x009f, "__toascii"                                                    },
    { 0x00a0, "__unDName"                                                    },
    { 0x00a1, "__unDNameEx"                                                  },
    { 0x0029, "__uncaught_exception"                                         },
    { 0x00a2, "__unguarded_readlc_active"                                    },
    { 0x00a3, "__wargv"                                                      },
    { 0x00a4, "__wcserror"                                                   },
    { 0x00a5, "__wgetmainargs"                                               },
    { 0x00a6, "__winitenv"                                                   },
    { 0x00a7, "_abnormal_termination"                                        },
    { 0x00a8, "_access"                                                      },
    { 0x00a9, "_acmdln"                                                      },
    { 0x00aa, "_adj_fdiv_m16i"                                               },
    { 0x00ab, "_adj_fdiv_m32"                                                },
    { 0x00ac, "_adj_fdiv_m32i"                                               },
    { 0x00ad, "_adj_fdiv_m64"                                                },
    { 0x00ae, "_adj_fdiv_r"                                                  },
    { 0x00af, "_adj_fdivr_m16i"                                              },
    { 0x00b0, "_adj_fdivr_m32"                                               },
    { 0x00b1, "_adj_fdivr_m32i"                                              },
    { 0x00b2, "_adj_fdivr_m64"                                               },
    { 0x00b3, "_adj_fpatan"                                                  },
    { 0x00b4, "_adj_fprem"                                                   },
    { 0x00b5, "_adj_fprem1"                                                  },
    { 0x00b6, "_adj_fptan"                                                   },
    { 0x00b7, "_adjust_fdiv"                                                 },
    { 0x00b8, "_aexit_rtn"                                                   },
    { 0x00b9, "_aligned_free"                                                },
    { 0x00ba, "_aligned_malloc"                                              },
    { 0x00bb, "_aligned_offset_malloc"                                       },
    { 0x00bc, "_aligned_offset_realloc"                                      },
    { 0x00bd, "_aligned_realloc"                                             },
    { 0x00be, "_amsg_exit"                                                   },
    { 0x00bf, "_assert"                                                      },
    { 0x00c0, "_atodbl"                                                      },
    { 0x00c1, "_atoi64"                                                      },
    { 0x00c2, "_atoldbl"                                                     },
    { 0x00c3, "_beep"                                                        },
    { 0x00c4, "_beginthread"                                                 },
    { 0x00c5, "_beginthreadex"                                               },
    { 0x00c6, "_c_exit"                                                      },
    { 0x00c7, "_cabs"                                                        },
    { 0x00c8, "_callnewh"                                                    },
    { 0x00c9, "_cexit"                                                       },
    { 0x00ca, "_cgets"                                                       },
    { 0x00cb, "_cgetws"                                                      },
    { 0x00cc, "_chdir"                                                       },
    { 0x00cd, "_chdrive"                                                     },
    { 0x00ce, "_chgsign"                                                     },
    { 0x00cf, "_chkesp"                                                      },
    { 0x00d0, "_chmod"                                                       },
    { 0x00d1, "_chsize"                                                      },
    { 0x00d2, "_clearfp"                                                     },
    { 0x00d3, "_close"                                                       },
    { 0x00d4, "_commit"                                                      },
    { 0x00d5, "_commode"                                                     },
    { 0x00d6, "_control87"                                                   },
    { 0x00d7, "_controlfp"                                                   },
    { 0x00d8, "_copysign"                                                    },
    { 0x00d9, "_cprintf"                                                     },
    { 0x00da, "_cputs"                                                       },
    { 0x00db, "_cputws"                                                      },
    { 0x00dc, "_creat"                                                       },
    { 0x00dd, "_cscanf"                                                      },
    { 0x00de, "_ctime64"                                                     },
    { 0x00df, "_ctype"                                                       },
    { 0x00e0, "_cwait"                                                       },
    { 0x00e1, "_cwprintf"                                                    },
    { 0x00e2, "_cwscanf"                                                     },
    { 0x00e3, "_daylight"                                                    },
    { 0x00e4, "_dstbias"                                                     },
    { 0x00e5, "_dup"                                                         },
    { 0x00e6, "_dup2"                                                        },
    { 0x00e7, "_ecvt"                                                        },
    { 0x00e8, "_endthread"                                                   },
    { 0x00e9, "_endthreadex"                                                 },
    { 0x00ea, "_environ"                                                     },
    { 0x00eb, "_eof"                                                         },
    { 0x00ec, "_errno"                                                       },
    { 0x00ed, "_except_handler2"                                             },
    { 0x00ee, "_except_handler3"                                             },
    { 0x00ef, "_execl"                                                       },
    { 0x00f0, "_execle"                                                      },
    { 0x00f1, "_execlp"                                                      },
    { 0x00f2, "_execlpe"                                                     },
    { 0x00f3, "_execv"                                                       },
    { 0x00f4, "_execve"                                                      },
    { 0x00f5, "_execvp"                                                      },
    { 0x00f6, "_execvpe"                                                     },
    { 0x00f7, "_exit"                                                        },
    { 0x00f8, "_expand"                                                      },
    { 0x00f9, "_fcloseall"                                                   },
    { 0x00fa, "_fcvt"                                                        },
    { 0x00fb, "_fdopen"                                                      },
    { 0x00fc, "_fgetchar"                                                    },
    { 0x00fd, "_fgetwchar"                                                   },
    { 0x00fe, "_filbuf"                                                      },
    { 0x00ff, "_fileinfo"                                                    },
    { 0x0100, "_filelength"                                                  },
    { 0x0101, "_filelengthi64"                                               },
    { 0x0102, "_fileno"                                                      },
    { 0x0103, "_findclose"                                                   },
    { 0x0104, "_findfirst"                                                   },
    { 0x0105, "_findfirst64"                                                 },
    { 0x0106, "_findfirsti64"                                                },
    { 0x0107, "_findnext"                                                    },
    { 0x0108, "_findnext64"                                                  },
    { 0x0109, "_findnexti64"                                                 },
    { 0x010a, "_finite"                                                      },
    { 0x010b, "_flsbuf"                                                      },
    { 0x010c, "_flushall"                                                    },
    { 0x010d, "_fmode"                                                       },
    { 0x010e, "_fpclass"                                                     },
    { 0x010f, "_fpieee_flt"                                                  },
    { 0x0110, "_fpreset"                                                     },
    { 0x0111, "_fputchar"                                                    },
    { 0x0112, "_fputwchar"                                                   },
    { 0x0113, "_fsopen"                                                      },
    { 0x0114, "_fstat"                                                       },
    { 0x0115, "_fstat64"                                                     },
    { 0x0116, "_fstati64"                                                    },
    { 0x0117, "_ftime"                                                       },
    { 0x0118, "_ftime64"                                                     },
    { 0x0119, "_ftol"                                                        },
    { 0x011a, "_fullpath"                                                    },
    { 0x011b, "_futime"                                                      },
    { 0x011c, "_futime64"                                                    },
    { 0x011d, "_gcvt"                                                        },
    { 0x011e, "_get_heap_handle"                                             },
    { 0x011f, "_get_osfhandle"                                               },
    { 0x0120, "_get_sbh_threshold"                                           },
    { 0x0121, "_getch"                                                       },
    { 0x0122, "_getche"                                                      },
    { 0x0123, "_getcwd"                                                      },
    { 0x0124, "_getdcwd"                                                     },
    { 0x0125, "_getdiskfree"                                                 },
    { 0x0126, "_getdllprocaddr"                                              },
    { 0x0127, "_getdrive"                                                    },
    { 0x0128, "_getdrives"                                                   },
    { 0x0129, "_getmaxstdio"                                                 },
    { 0x012a, "_getmbcp"                                                     },
    { 0x012b, "_getpid"                                                      },
    { 0x012c, "_getsystime"                                                  },
    { 0x012d, "_getw"                                                        },
    { 0x012e, "_getwch"                                                      },
    { 0x012f, "_getwche"                                                     },
    { 0x0130, "_getws"                                                       },
    { 0x0131, "_global_unwind2"                                              },
    { 0x0132, "_gmtime64"                                                    },
    { 0x0133, "_heapadd"                                                     },
    { 0x0134, "_heapchk"                                                     },
    { 0x0135, "_heapmin"                                                     },
    { 0x0136, "_heapset"                                                     },
    { 0x0137, "_heapused"                                                    },
    { 0x0138, "_heapwalk"                                                    },
    { 0x0139, "_hypot"                                                       },
    { 0x013a, "_i64toa"                                                      },
    { 0x013b, "_i64tow"                                                      },
    { 0x013c, "_initterm"                                                    },
    { 0x013d, "_inp"                                                         },
    { 0x013e, "_inpd"                                                        },
    { 0x013f, "_inpw"                                                        },
    { 0x0140, "_iob"                                                         },
    { 0x0141, "_isatty"                                                      },
    { 0x0142, "_isctype"                                                     },
    { 0x0143, "_ismbbalnum"                                                  },
    { 0x0144, "_ismbbalpha"                                                  },
    { 0x0145, "_ismbbgraph"                                                  },
    { 0x0146, "_ismbbkalnum"                                                 },
    { 0x0147, "_ismbbkana"                                                   },
    { 0x0148, "_ismbbkprint"                                                 },
    { 0x0149, "_ismbbkpunct"                                                 },
    { 0x014a, "_ismbblead"                                                   },
    { 0x014b, "_ismbbprint"                                                  },
    { 0x014c, "_ismbbpunct"                                                  },
    { 0x014d, "_ismbbtrail"                                                  },
    { 0x014e, "_ismbcalnum"                                                  },
    { 0x014f, "_ismbcalpha"                                                  },
    { 0x0150, "_ismbcdigit"                                                  },
    { 0x0151, "_ismbcgraph"                                                  },
    { 0x0152, "_ismbchira"                                                   },
    { 0x0153, "_ismbckata"                                                   },
    { 0x0154, "_ismbcl0"                                                     },
    { 0x0155, "_ismbcl1"                                                     },
    { 0x0156, "_ismbcl2"                                                     },
    { 0x0157, "_ismbclegal"                                                  },
    { 0x0158, "_ismbclower"                                                  },
    { 0x0159, "_ismbcprint"                                                  },
    { 0x015a, "_ismbcpunct"                                                  },
    { 0x015b, "_ismbcspace"                                                  },
    { 0x015c, "_ismbcsymbol"                                                 },
    { 0x015d, "_ismbcupper"                                                  },
    { 0x015e, "_ismbslead"                                                   },
    { 0x015f, "_ismbstrail"                                                  },
    { 0x0160, "_isnan"                                                       },
    { 0x0161, "_itoa"                                                        },
    { 0x0162, "_itow"                                                        },
    { 0x0163, "_j0"                                                          },
    { 0x0164, "_j1"                                                          },
    { 0x0165, "_jn"                                                          },
    { 0x0166, "_kbhit"                                                       },
    { 0x0167, "_lfind"                                                       },
    { 0x0168, "_loaddll"                                                     },
    { 0x0169, "_local_unwind2"                                               },
    { 0x016a, "_localtime64"                                                 },
    { 0x016b, "_lock"                                                        },
    { 0x016c, "_locking"                                                     },
    { 0x016d, "_logb"                                                        },
    { 0x016e, "_longjmpex"                                                   },
    { 0x016f, "_lrotl"                                                       },
    { 0x0170, "_lrotr"                                                       },
    { 0x0171, "_lsearch"                                                     },
    { 0x0172, "_lseek"                                                       },
    { 0x0173, "_lseeki64"                                                    },
    { 0x0174, "_ltoa"                                                        },
    { 0x0175, "_ltow"                                                        },
    { 0x0176, "_makepath"                                                    },
    { 0x0177, "_mbbtombc"                                                    },
    { 0x0178, "_mbbtype"                                                     },
    { 0x0179, "_mbcasemap"                                                   },
    { 0x017a, "_mbccpy"                                                      },
    { 0x017b, "_mbcjistojms"                                                 },
    { 0x017c, "_mbcjmstojis"                                                 },
    { 0x017d, "_mbclen"                                                      },
    { 0x017e, "_mbctohira"                                                   },
    { 0x017f, "_mbctokata"                                                   },
    { 0x0180, "_mbctolower"                                                  },
    { 0x0181, "_mbctombb"                                                    },
    { 0x0182, "_mbctoupper"                                                  },
    { 0x0183, "_mbctype"                                                     },
    { 0x0184, "_mbsbtype"                                                    },
    { 0x0185, "_mbscat"                                                      },
    { 0x0186, "_mbschr"                                                      },
    { 0x0187, "_mbscmp"                                                      },
    { 0x0188, "_mbscoll"                                                     },
    { 0x0189, "_mbscpy"                                                      },
    { 0x018a, "_mbscspn"                                                     },
    { 0x018b, "_mbsdec"                                                      },
    { 0x018c, "_mbsdup"                                                      },
    { 0x018d, "_mbsicmp"                                                     },
    { 0x018e, "_mbsicoll"                                                    },
    { 0x018f, "_mbsinc"                                                      },
    { 0x0190, "_mbslen"                                                      },
    { 0x0191, "_mbslwr"                                                      },
    { 0x0192, "_mbsnbcat"                                                    },
    { 0x0193, "_mbsnbcmp"                                                    },
    { 0x0194, "_mbsnbcnt"                                                    },
    { 0x0195, "_mbsnbcoll"                                                   },
    { 0x0196, "_mbsnbcpy"                                                    },
    { 0x0197, "_mbsnbicmp"                                                   },
    { 0x0198, "_mbsnbicoll"                                                  },
    { 0x0199, "_mbsnbset"                                                    },
    { 0x019a, "_mbsncat"                                                     },
    { 0x019b, "_mbsnccnt"                                                    },
    { 0x019c, "_mbsncmp"                                                     },
    { 0x019d, "_mbsncoll"                                                    },
    { 0x019e, "_mbsncpy"                                                     },
    { 0x019f, "_mbsnextc"                                                    },
    { 0x01a0, "_mbsnicmp"                                                    },
    { 0x01a1, "_mbsnicoll"                                                   },
    { 0x01a2, "_mbsninc"                                                     },
    { 0x01a3, "_mbsnset"                                                     },
    { 0x01a4, "_mbspbrk"                                                     },
    { 0x01a5, "_mbsrchr"                                                     },
    { 0x01a6, "_mbsrev"                                                      },
    { 0x01a7, "_mbsset"                                                      },
    { 0x01a8, "_mbsspn"                                                      },
    { 0x01a9, "_mbsspnp"                                                     },
    { 0x01aa, "_mbsstr"                                                      },
    { 0x01ab, "_mbstok"                                                      },
    { 0x01ac, "_mbstrlen"                                                    },
    { 0x01ad, "_mbsupr"                                                      },
    { 0x01ae, "_memccpy"                                                     },
    { 0x01af, "_memicmp"                                                     },
    { 0x01b0, "_mkdir"                                                       },
    { 0x01b1, "_mktemp"                                                      },
    { 0x01b2, "_mktime64"                                                    },
    { 0x01b3, "_msize"                                                       },
    { 0x01b4, "_nextafter"                                                   },
    { 0x01b5, "_onexit"                                                      },
    { 0x01b6, "_open"                                                        },
    { 0x01b7, "_open_osfhandle"                                              },
    { 0x01b8, "_osplatform"                                                  },
    { 0x01b9, "_osver"                                                       },
    { 0x01ba, "_outp"                                                        },
    { 0x01bb, "_outpd"                                                       },
    { 0x01bc, "_outpw"                                                       },
    { 0x01bd, "_pclose"                                                      },
    { 0x01be, "_pctype"                                                      },
    { 0x01bf, "_pgmptr"                                                      },
    { 0x01c0, "_pipe"                                                        },
    { 0x01c1, "_popen"                                                       },
    { 0x01c2, "_purecall"                                                    },
    { 0x01c3, "_putch"                                                       },
    { 0x01c4, "_putenv"                                                      },
    { 0x01c5, "_putw"                                                        },
    { 0x01c6, "_putwch"                                                      },
    { 0x01c7, "_putws"                                                       },
    { 0x01c8, "_pwctype"                                                     },
    { 0x01c9, "_read"                                                        },
    { 0x01ca, "_resetstkoflw"                                                },
    { 0x01cb, "_rmdir"                                                       },
    { 0x01cc, "_rmtmp"                                                       },
    { 0x01cd, "_rotl"                                                        },
    { 0x01ce, "_rotr"                                                        },
    { 0x01cf, "_safe_fdiv"                                                   },
    { 0x01d0, "_safe_fdivr"                                                  },
    { 0x01d1, "_safe_fprem"                                                  },
    { 0x01d2, "_safe_fprem1"                                                 },
    { 0x01d3, "_scalb"                                                       },
    { 0x01d4, "_scprintf"                                                    },
    { 0x01d5, "_scwprintf"                                                   },
    { 0x01d6, "_searchenv"                                                   },
    { 0x01d7, "_seh_longjmp_unwind"                                          },
    { 0x01d8, "_set_SSE2_enable"                                             },
    { 0x01d9, "_set_error_mode"                                              },
    { 0x01da, "_set_sbh_threshold"                                           },
    { 0x01db, "_seterrormode"                                                },
    { 0x01dc, "_setjmp"                                                      },
    { 0x01dd, "_setjmp3"                                                     },
    { 0x01de, "_setmaxstdio"                                                 },
    { 0x01df, "_setmbcp"                                                     },
    { 0x01e0, "_setmode"                                                     },
    { 0x01e1, "_setsystime"                                                  },
    { 0x01e2, "_sleep"                                                       },
    { 0x01e3, "_snprintf"                                                    },
    { 0x01e4, "_snscanf"                                                     },
    { 0x01e5, "_snwprintf"                                                   },
    { 0x01e6, "_snwscanf"                                                    },
    { 0x01e7, "_sopen"                                                       },
    { 0x01e8, "_spawnl"                                                      },
    { 0x01e9, "_spawnle"                                                     },
    { 0x01ea, "_spawnlp"                                                     },
    { 0x01eb, "_spawnlpe"                                                    },
    { 0x01ec, "_spawnv"                                                      },
    { 0x01ed, "_spawnve"                                                     },
    { 0x01ee, "_spawnvp"                                                     },
    { 0x01ef, "_spawnvpe"                                                    },
    { 0x01f0, "_splitpath"                                                   },
    { 0x01f1, "_stat"                                                        },
    { 0x01f2, "_stat64"                                                      },
    { 0x01f3, "_stati64"                                                     },
    { 0x01f4, "_statusfp"                                                    },
    { 0x01f5, "_strcmpi"                                                     },
    { 0x01f6, "_strdate"                                                     },
    { 0x01f7, "_strdup"                                                      },
    { 0x01f8, "_strerror"                                                    },
    { 0x01f9, "_stricmp"                                                     },
    { 0x01fa, "_stricoll"                                                    },
    { 0x01fb, "_strlwr"                                                      },
    { 0x01fc, "_strncoll"                                                    },
    { 0x01fd, "_strnicmp"                                                    },
    { 0x01fe, "_strnicoll"                                                   },
    { 0x01ff, "_strnset"                                                     },
    { 0x0200, "_strrev"                                                      },
    { 0x0201, "_strset"                                                      },
    { 0x0202, "_strtime"                                                     },
    { 0x0203, "_strtoi64"                                                    },
    { 0x0204, "_strtoui64"                                                   },
    { 0x0205, "_strupr"                                                      },
    { 0x0206, "_swab"                                                        },
    { 0x0207, "_sys_errlist"                                                 },
    { 0x0208, "_sys_nerr"                                                    },
    { 0x0209, "_tell"                                                        },
    { 0x020a, "_telli64"                                                     },
    { 0x020b, "_tempnam"                                                     },
    { 0x020c, "_time64"                                                      },
    { 0x020d, "_timezone"                                                    },
    { 0x020e, "_tolower"                                                     },
    { 0x020f, "_toupper"                                                     },
    { 0x0210, "_tzname"                                                      },
    { 0x0211, "_tzset"                                                       },
    { 0x0212, "_ui64toa"                                                     },
    { 0x0213, "_ui64tow"                                                     },
    { 0x0214, "_ultoa"                                                       },
    { 0x0215, "_ultow"                                                       },
    { 0x0216, "_umask"                                                       },
    { 0x0217, "_ungetch"                                                     },
    { 0x0218, "_ungetwch"                                                    },
    { 0x0219, "_unlink"                                                      },
    { 0x021a, "_unloaddll"                                                   },
    { 0x021b, "_unlock"                                                      },
    { 0x021c, "_utime"                                                       },
    { 0x021d, "_utime64"                                                     },
    { 0x021e, "_vscprintf"                                                   },
    { 0x021f, "_vscwprintf"                                                  },
    { 0x0220, "_vsnprintf"                                                   },
    { 0x0221, "_vsnwprintf"                                                  },
    { 0x0222, "_waccess"                                                     },
    { 0x0223, "_wasctime"                                                    },
    { 0x0224, "_wchdir"                                                      },
    { 0x0225, "_wchmod"                                                      },
    { 0x0226, "_wcmdln"                                                      },
    { 0x0227, "_wcreat"                                                      },
    { 0x0228, "_wcsdup"                                                      },
    { 0x0229, "_wcserror"                                                    },
    { 0x022a, "_wcsicmp"                                                     },
    { 0x022b, "_wcsicoll"                                                    },
    { 0x022c, "_wcslwr"                                                      },
    { 0x022d, "_wcsncoll"                                                    },
    { 0x022e, "_wcsnicmp"                                                    },
    { 0x022f, "_wcsnicoll"                                                   },
    { 0x0230, "_wcsnset"                                                     },
    { 0x0231, "_wcsrev"                                                      },
    { 0x0232, "_wcsset"                                                      },
    { 0x0233, "_wcstoi64"                                                    },
    { 0x0234, "_wcstoui64"                                                   },
    { 0x0235, "_wcsupr"                                                      },
    { 0x0236, "_wctime"                                                      },
    { 0x0237, "_wctime64"                                                    },
    { 0x0238, "_wenviron"                                                    },
    { 0x0239, "_wexecl"                                                      },
    { 0x023a, "_wexecle"                                                     },
    { 0x023b, "_wexeclp"                                                     },
    { 0x023c, "_wexeclpe"                                                    },
    { 0x023d, "_wexecv"                                                      },
    { 0x023e, "_wexecve"                                                     },
    { 0x023f, "_wexecvp"                                                     },
    { 0x0240, "_wexecvpe"                                                    },
    { 0x0241, "_wfdopen"                                                     },
    { 0x0242, "_wfindfirst"                                                  },
    { 0x0243, "_wfindfirst64"                                                },
    { 0x0244, "_wfindfirsti64"                                               },
    { 0x0245, "_wfindnext"                                                   },
    { 0x0246, "_wfindnext64"                                                 },
    { 0x0247, "_wfindnexti64"                                                },
    { 0x0248, "_wfopen"                                                      },
    { 0x0249, "_wfreopen"                                                    },
    { 0x024a, "_wfsopen"                                                     },
    { 0x024b, "_wfullpath"                                                   },
    { 0x024c, "_wgetcwd"                                                     },
    { 0x024d, "_wgetdcwd"                                                    },
    { 0x024e, "_wgetenv"                                                     },
    { 0x024f, "_winmajor"                                                    },
    { 0x0250, "_winminor"                                                    },
    { 0x0251, "_winver"                                                      },
    { 0x0252, "_wmakepath"                                                   },
    { 0x0253, "_wmkdir"                                                      },
    { 0x0254, "_wmktemp"                                                     },
    { 0x0255, "_wopen"                                                       },
    { 0x0256, "_wperror"                                                     },
    { 0x0257, "_wpgmptr"                                                     },
    { 0x0258, "_wpopen"                                                      },
    { 0x0259, "_wputenv"                                                     },
    { 0x025a, "_wremove"                                                     },
    { 0x025b, "_wrename"                                                     },
    { 0x025c, "_write"                                                       },
    { 0x025d, "_wrmdir"                                                      },
    { 0x025e, "_wsearchenv"                                                  },
    { 0x025f, "_wsetlocale"                                                  },
    { 0x0260, "_wsopen"                                                      },
    { 0x0261, "_wspawnl"                                                     },
    { 0x0262, "_wspawnle"                                                    },
    { 0x0263, "_wspawnlp"                                                    },
    { 0x0264, "_wspawnlpe"                                                   },
    { 0x0265, "_wspawnv"                                                     },
    { 0x0266, "_wspawnve"                                                    },
    { 0x0267, "_wspawnvp"                                                    },
    { 0x0268, "_wspawnvpe"                                                   },
    { 0x0269, "_wsplitpath"                                                  },
    { 0x026a, "_wstat"                                                       },
    { 0x026b, "_wstat64"                                                     },
    { 0x026c, "_wstati64"                                                    },
    { 0x026d, "_wstrdate"                                                    },
    { 0x026e, "_wstrtime"                                                    },
    { 0x026f, "_wsystem"                                                     },
    { 0x0270, "_wtempnam"                                                    },
    { 0x0271, "_wtmpnam"                                                     },
    { 0x0272, "_wtof"                                                        },
    { 0x0273, "_wtoi"                                                        },
    { 0x0274, "_wtoi64"                                                      },
    { 0x0275, "_wtol"                                                        },
    { 0x0276, "_wunlink"                                                     },
    { 0x0277, "_wutime"                                                      },
    { 0x0278, "_wutime64"                                                    },
    { 0x0279, "_y0"                                                          },
    { 0x027a, "_y1"                                                          },
    { 0x027b, "_yn"                                                          },
    { 0x027c, "abort"                                                        },
    { 0x027d, "abs"                                                          },
    { 0x027e, "acos"                                                         },
    { 0x027f, "asctime"                                                      },
    { 0x0280, "asin"                                                         },
    { 0x0281, "atan"                                                         },
    { 0x0282, "atan2"                                                        },
    { 0x0283, "atexit"                                                       },
    { 0x0284, "atof"                                                         },
    { 0x0285, "atoi"                                                         },
    { 0x0286, "atol"                                                         },
    { 0x0287, "bsearch"                                                      },
    { 0x0288, "calloc"                                                       },
    { 0x0289, "ceil"                                                         },
    { 0x028a, "clearerr"                                                     },
    { 0x028b, "clock"                                                        },
    { 0x028c, "cos"                                                          },
    { 0x028d, "cosh"                                                         },
    { 0x028e, "ctime"                                                        },
    { 0x028f, "difftime"                                                     },
    { 0x0290, "div"                                                          },
    { 0x0291, "exit"                                                         },
    { 0x0292, "exp"                                                          },
    { 0x0293, "fabs"                                                         },
    { 0x0294, "fclose"                                                       },
    { 0x0295, "feof"                                                         },
    { 0x0296, "ferror"                                                       },
    { 0x0297, "fflush"                                                       },
    { 0x0298, "fgetc"                                                        },
    { 0x0299, "fgetpos"                                                      },
    { 0x029a, "fgets"                                                        },
    { 0x029b, "fgetwc"                                                       },
    { 0x029c, "fgetws"                                                       },
    { 0x029d, "floor"                                                        },
    { 0x029e, "fmod"                                                         },
    { 0x029f, "fopen"                                                        },
    { 0x02a0, "fprintf"                                                      },
    { 0x02a1, "fputc"                                                        },
    { 0x02a2, "fputs"                                                        },
    { 0x02a3, "fputwc"                                                       },
    { 0x02a4, "fputws"                                                       },
    { 0x02a5, "fread"                                                        },
    { 0x02a6, "free"                                                         },
    { 0x02a7, "freopen"                                                      },
    { 0x02a8, "frexp"                                                        },
    { 0x02a9, "fscanf"                                                       },
    { 0x02aa, "fseek"                                                        },
    { 0x02ab, "fsetpos"                                                      },
    { 0x02ac, "ftell"                                                        },
    { 0x02ad, "fwprintf"                                                     },
    { 0x02ae, "fwrite"                                                       },
    { 0x02af, "fwscanf"                                                      },
    { 0x02b0, "getc"                                                         },
    { 0x02b1, "getchar"                                                      },
    { 0x02b2, "getenv"                                                       },
    { 0x02b3, "gets"                                                         },
    { 0x02b4, "getwc"                                                        },
    { 0x02b5, "getwchar"                                                     },
    { 0x02b6, "gmtime"                                                       },
    { 0x02b7, "is_wctype"                                                    },
    { 0x02b8, "isalnum"                                                      },
    { 0x02b9, "isalpha"                                                      },
    { 0x02ba, "iscntrl"                                                      },
    { 0x02bb, "isdigit"                                                      },
    { 0x02bc, "isgraph"                                                      },
    { 0x02bd, "isleadbyte"                                                   },
    { 0x02be, "islower"                                                      },
    { 0x02bf, "isprint"                                                      },
    { 0x02c0, "ispunct"                                                      },
    { 0x02c1, "isspace"                                                      },
    { 0x02c2, "isupper"                                                      },
    { 0x02c3, "iswalnum"                                                     },
    { 0x02c4, "iswalpha"                                                     },
    { 0x02c5, "iswascii"                                                     },
    { 0x02c6, "iswcntrl"                                                     },
    { 0x02c7, "iswctype"                                                     },
    { 0x02c8, "iswdigit"                                                     },
    { 0x02c9, "iswgraph"                                                     },
    { 0x02ca, "iswlower"                                                     },
    { 0x02cb, "iswprint"                                                     },
    { 0x02cc, "iswpunct"                                                     },
    { 0x02cd, "iswspace"                                                     },
    { 0x02ce, "iswupper"                                                     },
    { 0x02cf, "iswxdigit"                                                    },
    { 0x02d0, "isxdigit"                                                     },
    { 0x02d1, "labs"                                                         },
    { 0x02d2, "ldexp"                                                        },
    { 0x02d3, "ldiv"                                                         },
    { 0x02d4, "localeconv"                                                   },
    { 0x02d5, "localtime"                                                    },
    { 0x02d6, "log"                                                          },
    { 0x02d7, "log10"                                                        },
    { 0x02d8, "longjmp"                                                      },
    { 0x02d9, "malloc"                                                       },
    { 0x02da, "mblen"                                                        },
    { 0x02db, "mbstowcs"                                                     },
    { 0x02dc, "mbtowc"                                                       },
    { 0x02dd, "memchr"                                                       },
    { 0x02de, "memcmp"                                                       },
    { 0x02df, "memcpy"                                                       },
    { 0x02e0, "memmove"                                                      },
    { 0x02e1, "memset"                                                       },
    { 0x02e2, "mktime"                                                       },
    { 0x02e3, "modf"                                                         },
    { 0x02e4, "perror"                                                       },
    { 0x02e5, "pow"                                                          },
    { 0x02e6, "printf"                                                       },
    { 0x02e7, "putc"                                                         },
    { 0x02e8, "putchar"                                                      },
    { 0x02e9, "puts"                                                         },
    { 0x02ea, "putwc"                                                        },
    { 0x02eb, "putwchar"                                                     },
    { 0x02ec, "qsort"                                                        },
    { 0x02ed, "raise"                                                        },
    { 0x02ee, "rand"                                                         },
    { 0x02ef, "realloc"                                                      },
    { 0x02f0, "remove"                                                       },
    { 0x02f1, "rename"                                                       },
    { 0x02f2, "rewind"                                                       },
    { 0x02f3, "scanf"                                                        },
    { 0x02f4, "setbuf"                                                       },
    { 0x02f5, "setlocale"                                                    },
    { 0x02f6, "setvbuf"                                                      },
    { 0x02f7, "signal"                                                       },
    { 0x02f8, "sin"                                                          },
    { 0x02f9, "sinh"                                                         },
    { 0x02fa, "sprintf"                                                      },
    { 0x02fb, "sqrt"                                                         },
    { 0x02fc, "srand"                                                        },
    { 0x02fd, "sscanf"                                                       },
    { 0x02fe, "strcat"                                                       },
    { 0x02ff, "strchr"                                                       },
    { 0x0300, "strcmp"                                                       },
    { 0x0301, "strcoll"                                                      },
    { 0x0302, "strcpy"                                                       },
    { 0x0303, "strcspn"                                                      },
    { 0x0304, "strerror"                                                     },
    { 0x0305, "strftime"                                                     },
    { 0x0306, "strlen"                                                       },
    { 0x0307, "strncat"                                                      },
    { 0x0308, "strncmp"                                                      },
    { 0x0309, "strncpy"                                                      },
    { 0x030a, "strpbrk"                                                      },
    { 0x030b, "strrchr"                                                      },
    { 0x030c, "strspn"                                                       },
    { 0x030d, "strstr"                                                       },
    { 0x030e, "strtod"                                                       },
    { 0x030f, "strtok"                                                       },
    { 0x0310, "strtol"                                                       },
    { 0x0311, "strtoul"                                                      },
    { 0x0312, "strxfrm"                                                      },
    { 0x0313, "swprintf"                                                     },
    { 0x0314, "swscanf"                                                      },
    { 0x0315, "system"                                                       },
    { 0x0316, "tan"                                                          },
    { 0x0317, "tanh"                                                         },
    { 0x0318, "time"                                                         },
    { 0x0319, "tmpfile"                                                      },
    { 0x031a, "tmpnam"                                                       },
    { 0x031b, "tolower"                                                      },
    { 0x031c, "toupper"                                                      },
    { 0x031d, "towlower"                                                     },
    { 0x031e, "towupper"                                                     },
    { 0x031f, "ungetc"                                                       },
    { 0x0320, "ungetwc"                                                      },
    { 0x0321, "vfprintf"                                                     },
    { 0x0322, "vfwprintf"                                                    },
    { 0x0323, "vprintf"                                                      },
    { 0x0324, "vsprintf"                                                     },
    { 0x0325, "vswprintf"                                                    },
    { 0x0326, "vwprintf"                                                     },
    { 0x0327, "wcscat"                                                       },
    { 0x0328, "wcschr"                                                       },
    { 0x0329, "wcscmp"                                                       },
    { 0x032a, "wcscoll"                                                      },
    { 0x032b, "wcscpy"                                                       },
    { 0x032c, "wcscspn"                                                      },
    { 0x032d, "wcsftime"                                                     },
    { 0x032e, "wcslen"                                                       },
    { 0x032f, "wcsncat"                                                      },
    { 0x0330, "wcsncmp"                                                      },
    { 0x0331, "wcsncpy"                                                      },
    { 0x0332, "wcspbrk"                                                      },
    { 0x0333, "wcsrchr"                                                      },
    { 0x0334, "wcsspn"                                                       },
    { 0x0335, "wcsstr"                                                       },
    { 0x0336, "wcstod"                                                       },
    { 0x0337, "wcstok"                                                       },
    { 0x0338, "wcstol"                                                       },
    { 0x0339, "wcstombs"                                                     },
    { 0x033a, "wcstoul"                                                      },
    { 0x033b, "wcsxfrm"                                                      },
    { 0x033c, "wctomb"                                                       },
    { 0x033d, "wprintf"                                                      },
    { 0x033e, "wscanf"                                                       },
};


}
}

#endif

