# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class GenericCellTessellator(Object):
    r"""
    GenericCellTessellator - helper class to perform cell tessellation
    
    Superclass: Object
    
    GenericCellTessellator is a helper class to perform adaptive
    tessellation of particular cell topologies. The major purpose for
    this class is to transform higher-order cell types (e.g.,
    higher-order finite elements) into linear cells that can then be
    easily visualized by VTK. This class works in conjunction with the
    GenericDataSet and GenericAdaptorCell classes.
    
    This algorithm is based on edge subdivision. An error metric along
    each edge is evaluated, and if the error is greater than some
    tolerance, the edge is subdivided (as well as all connected 2D and 3D
    cells). The process repeats until the error metric is satisfied.
    
    A significant issue addressed by this algorithm is to ensure face
    compatibility across neighboring cells. That is, diagonals due to
    face triangulation must match to ensure that the mesh is compatible.
    The algorithm employs a precomputed table to accelerate the
    tessellation process. The table was generated with the help of
    OrderedTriangulator; the basic idea is that the choice of diagonal
    is made by considering the relative value of the point ids.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkGenericCellTessellator, obj, update, **traits)
    
    def _get_error_metrics(self):
        return wrap_vtk(self._vtk_obj.GetErrorMetrics())
    def _set_error_metrics(self, arg):
        old_val = self._get_error_metrics()
        self._wrap_call(self._vtk_obj.SetErrorMetrics,
                        deref_vtk(arg))
        self.trait_property_changed('error_metrics', old_val, arg)
    error_metrics = traits.Property(_get_error_metrics, _set_error_metrics, desc=\
        r"""
        
        """
    )

    measurement = traits.Int(0, enter_set=True, auto_set=False, desc=\
        r"""
        
        """
    )

    def _measurement_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMeasurement,
                        self.measurement)

    def get_max_errors(self, *args):
        """
        get_max_errors(self, errors:[float, ...]) -> None
        C++: void get_max_errors(double *errors)
        Get the maximum error measured after the fixed subdivision.
        \\pre errors_exists: errors!=0
        \\pre valid_size:
            sizeof(errors)==get_error_metrics()->get_number_of_items()
        """
        ret = self._wrap_call(self._vtk_obj.GetMaxErrors, *args)
        return ret

    def init_error_metrics(self, *args):
        """
        init_error_metrics(self, ds:GenericDataSet) -> None
        C++: void init_error_metrics(GenericDataSet *ds)
        Init the error metric with the dataset. Should be called in each
        filter before any tessellation of any cell.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.InitErrorMetrics, *my_args)
        return ret

    def initialize(self, *args):
        """
        initialize(self, ds:GenericDataSet) -> None
        C++: virtual void initialize(GenericDataSet *ds)
        Initialize the tessellator with a data set `ds'.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.Initialize, *my_args)
        return ret

    def tessellate(self, *args):
        """
        tessellate(self, cell:GenericAdaptorCell,
            att:GenericAttributeCollection, points:DoubleArray,
            cellArray:CellArray, internalPd:PointData) -> None
        C++: virtual void tessellate(GenericAdaptorCell *cell,
            GenericAttributeCollection *att, DoubleArray *points,
            CellArray *cellArray, PointData *internalPd)
        Tessellate a 3D `cell'. The result is a set of smaller linear
        tetrahedra in `cellArray' with `points' and point data
        `internalPd'.
        \\pre cell_exists: cell!=0
        \\pre valid_dimension: cell->get_dimension()==3
        \\pre att_exists: att!=0
        \\pre points_exists: points!=0
        \\pre cellArray_exists: cellArray!=0
        \\pre internalPd_exists: internalPd!=0
        """
        my_args = deref_array(args, [('vtkGenericAdaptorCell', 'vtkGenericAttributeCollection', 'vtkDoubleArray', 'vtkCellArray', 'vtkPointData')])
        ret = self._wrap_call(self._vtk_obj.Tessellate, *my_args)
        return ret

    def tessellate_face(self, *args):
        """
        tessellate_face(self, cell:GenericAdaptorCell,
            att:GenericAttributeCollection, index:int,
            points:DoubleArray, cellArray:CellArray,
            internalPd:PointData) -> None
        C++: virtual void tessellate_face(GenericAdaptorCell *cell,
            GenericAttributeCollection *att, IdType index,
            DoubleArray *points, CellArray *cellArray,
            PointData *internalPd)
        Tessellate a face of a 3D `cell'. The face is specified by the
        index value. The result is a set of smaller linear triangles in
        `cellArray' with `points' and point data `internalPd'.
        \\pre cell_exists: cell!=0
        \\pre valid_dimension: cell->get_dimension()==3
        \\pre valid_index_range: (index>=0) &&
            (index<cell->get_number_of_boundaries(2))
        \\pre att_exists: att!=0
        \\pre points_exists: points!=0
        \\pre cellArray_exists: cellArray!=0
        \\pre internalPd_exists: internalPd!=0
        """
        my_args = deref_array(args, [('vtkGenericAdaptorCell', 'vtkGenericAttributeCollection', 'int', 'vtkDoubleArray', 'vtkCellArray', 'vtkPointData')])
        ret = self._wrap_call(self._vtk_obj.TessellateFace, *my_args)
        return ret

    def triangulate(self, *args):
        """
        triangulate(self, cell:GenericAdaptorCell,
            att:GenericAttributeCollection, points:DoubleArray,
            cellArray:CellArray, internalPd:PointData) -> None
        C++: virtual void triangulate(GenericAdaptorCell *cell,
            GenericAttributeCollection *att, DoubleArray *points,
            CellArray *cellArray, PointData *internalPd)
        Triangulate a 2D `cell'. The result is a set of smaller linear
        triangles in `cellArray' with `points' and point data
        `internalPd'.
        \\pre cell_exists: cell!=0
        \\pre valid_dimension: cell->get_dimension()==2
        \\pre att_exists: att!=0
        \\pre points_exists: points!=0
        \\pre cellArray_exists: cellArray!=0
        \\pre internalPd_exists: internalPd!=0
        """
        my_args = deref_array(args, [('vtkGenericAdaptorCell', 'vtkGenericAttributeCollection', 'vtkDoubleArray', 'vtkCellArray', 'vtkPointData')])
        ret = self._wrap_call(self._vtk_obj.Triangulate, *my_args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('measurement', 'GetMeasurement'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'measurement'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(GenericCellTessellator, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit GenericCellTessellator properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['measurement']),
            title='Edit GenericCellTessellator properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit GenericCellTessellator properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

