---
id: fast-foundation.disclosure
title: Disclosure class
hide_title: true
---
<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[@microsoft/fast-foundation](./fast-foundation.md) &gt; [Disclosure](./fast-foundation.disclosure.md)

## Disclosure class

A Disclosure Custom HTML Element. Based largely on the [disclosure element](https://w3c.github.io/aria-practices/#disclosure)<!-- -->.


start - Content which can be provided before the summary content


end - Content which can be provided after the summary content


title - The summary content


- The default slot for the disclosure content


toggle - fires a toggle event when the summary is toggled

<b>Signature:</b>

```typescript
export declare class Disclosure extends FoundationElement 
```

## Properties

|  Property | Modifiers | Type | Description |
|  --- | --- | --- | --- |
|  [expanded](./fast-foundation.disclosure.expanded.md) |  | boolean | Determines if the element should show the extra content or not. |
|  [title](./fast-foundation.disclosure.title.md) |  | string | Invoker title |

## Methods

|  Method | Modifiers | Description |
|  --- | --- | --- |
|  [hide()](./fast-foundation.disclosure.hide.md) |  | Hide extra content. |
|  [onToggle()](./fast-foundation.disclosure.ontoggle.md) |  | Update the aria attr and fire <code>toggle</code> event |
|  [setup()](./fast-foundation.disclosure.setup.md) |  | Register listener and set default disclosure mode |
|  [show()](./fast-foundation.disclosure.show.md) |  | Show extra content. |
|  [toggle()](./fast-foundation.disclosure.toggle.md) |  | Toggle the current(expanded/collapsed) state. |
