#include <stdint.h>
#include <stdlib.h>
#include "numa.h"


int LLVMFuzzerTestOneInput(const uint8_t *data, size_t size) {
    struct bitmask *mask = NULL;

    char *fuzz_str1 = malloc(size+1);
    memcpy(fuzz_str1, data, size);
    fuzz_str1[size] = '\0';

    mask = numa_parse_nodestring(fuzz_str1);
    if (mask != NULL) {
        numa_bitmask_free(mask);
    }

    // NULLify the mask variable before we use it again.
    mask = NULL;
    mask = numa_parse_cpustring(fuzz_str1);
    if (mask != NULL) {
        numa_node_to_cpus_v2(0, mask);
        numa_bitmask_free(mask);
    }

    free(fuzz_str1);
    return 0;
}
