% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rowRanks.R
\name{rowRanks}
\alias{rowRanks}
\alias{rowRanks,matrix_OR_array_OR_table_OR_numeric-method}
\alias{rowRanks,ANY-method}
\alias{colRanks}
\alias{colRanks,matrix_OR_array_OR_table_OR_numeric-method}
\alias{colRanks,ANY-method}
\title{Calculates the rank of the elements for each row (column) of a matrix-like
object}
\usage{
rowRanks(x, rows = NULL, cols = NULL, ties.method = c("max", "average"),
  ..., useNames = TRUE)

\S4method{rowRanks}{matrix_OR_array_OR_table_OR_numeric}(x, rows = NULL,
  cols = NULL, ties.method = c("max", "average", "first", "last", "random",
  "max", "min", "dense"), dim. = dim(x), ..., useNames = TRUE)

\S4method{rowRanks}{ANY}(x, rows = NULL, cols = NULL,
  ties.method = c("max", "average"), ..., useNames = TRUE)

colRanks(x, rows = NULL, cols = NULL, ties.method = c("max", "average"),
  ..., useNames = TRUE)

\S4method{colRanks}{matrix_OR_array_OR_table_OR_numeric}(x, rows = NULL,
  cols = NULL, ties.method = c("max", "average", "first", "last", "random",
  "max", "min", "dense"), dim. = dim(x), preserveShape = FALSE, ...,
  useNames = TRUE)

\S4method{colRanks}{ANY}(x, rows = NULL, cols = NULL,
  ties.method = c("max", "average"), ..., useNames = TRUE)
}
\arguments{
\item{x}{An NxK matrix-like object.}

\item{rows, cols}{A \code{\link{vector}} indicating the subset of rows
(and/or columns) to operate over. If \code{\link{NULL}}, no subsetting is
done.}

\item{ties.method}{A character string specifying how ties are treated. Note
that the default specifies fewer options than the original matrixStats
package.}

\item{...}{Additional arguments passed to specific methods.}

\item{useNames}{If \code{\link{TRUE}} (default), names attributes of result are set. Else if \code{\link{FALSE}}, no naming support is done.}

\item{dim.}{An \code{\link{integer}} \code{\link{vector}} of length two
specifying the dimension of \code{x}, essential when x is a
\code{\link{numeric}} vector. Note, that this is not a generic
argument and not all methods need provide it.}

\item{preserveShape}{If \code{TRUE} the output matrix has the same shape as the
input x. Note, that this is not a generic argument and not all
implementation of this function have to provide it.}
}
\value{
A \code{\link[base]{matrix}} of type \code{\link[base]{integer}} is
returned, unless \code{ties.method = "average"} when it is of type
\code{\link[base]{numeric}}.

The \code{rowRanks()} function always returns an NxK
\code{\link[base]{matrix}}, where N (K) is the number of rows (columns)
whose ranks are calculated.

The \code{colRanks()} function returns an NxK \code{\link[base]{matrix}}, if
\code{preserveShape = TRUE}, otherwise a KxN \code{\link[base]{matrix}}.

Any \code{\link[base]{names}} of \code{x} are ignored and absent in the
result.
}
\description{
Calculates the rank of the elements for each row (column) of a matrix-like
object.
}
\details{
The S4 methods for \code{x} of type \code{\link{matrix}},
\code{\link{array}}, \code{\link{table}}, or \code{\link{numeric}} call
\code{matrixStats::\link[matrixStats]{rowRanks}} /
\code{matrixStats::\link[matrixStats]{colRanks}}.

The \code{matrixStats::rowRanks()} function can handle a lot of different
values for the \code{ties.method} argument. Users of the generic function
should however only rely on \code{max} and \code{average} because the other ones
are not guaranteed to be implemented:
\describe{
\item{\code{max}}{for values with identical values the maximum rank is
returned}
\item{\code{average}}{for values with identical values the average of the
ranks they cover is returned. Note, that in this case the return
value is of type \code{numeric}.}
}
}
\examples{
mat <- matrix(rnorm(15), nrow = 5, ncol = 3)
mat[2, 1] <- NA
mat[3, 3] <- Inf
mat[4, 1] <- 0

print(mat)

rowRanks(mat)
colRanks(mat)
}
\seealso{
\itemize{
\item \code{matrixStats::\link[matrixStats]{rowRanks}()} and
\code{matrixStats::\link[matrixStats:rowRanks]{colRanks}()} which are used
when the input is a \code{matrix} or \code{numeric} vector.
\item \link[base:rank]{base::rank}
}
}
\keyword{array}
\keyword{iteration}
\keyword{robust}
