% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hash.R
\name{hash_xxhash}
\alias{hash_xxhash}
\alias{hash_raw_xxhash}
\alias{hash_obj_xxhash}
\alias{hash_file_xxhash}
\alias{hash_xxhash64}
\alias{hash_raw_xxhash64}
\alias{hash_obj_xxhash64}
\alias{hash_file_xxhash64}
\title{xxHash}
\usage{
hash_xxhash(x)

hash_raw_xxhash(x)

hash_obj_xxhash(x, serialize_version = 2)

hash_file_xxhash(paths)

hash_xxhash64(x)

hash_raw_xxhash64(x)

hash_obj_xxhash64(x, serialize_version = 2)

hash_file_xxhash64(paths)
}
\arguments{
\item{x}{Character vector. If not a character vector, then
\code{\link[=as.character]{as.character()}} is used to try to coerce it into one. \code{NA} entries
will have an \code{NA} hash.}

\item{serialize_version}{Workspace format version to use, see
\code{\link[base:serialize]{base::serialize()}}.}

\item{paths}{Character vector of file names.}
}
\value{
\code{hash_xxhash()} returns a character vector of hexadecimal
xxHash hashes.

\code{hash_raw_xxhash()} returns a character scalar.

\code{hash_obj_xxhash()} returns a character scalar.

\code{hash_file_xxhash()} returns a character vector of xxHash
hashes.
}
\description{
Extremely fast hash algorithm.
}
\details{
\code{hash_raw_xxhash()} calculates the xxHash hash of the bytes
of a raw vector.

\code{hash_obj_xxhash()} calculates the xxHash hash of an R
object. The object is serialized into a binary vector first.

\code{hash_file_xxhash()} calculates the xxHash hash of one or
more files.

The \code{64} functions caculate the 64 bit variant
of xxHash. Otherwise they work the same.
}
\examples{
hash_xxhash(c("foo", NA, "bar", ""))
}
\seealso{
Other hash functions: 
\code{\link{hash_animal}()},
\code{\link{hash_emoji}()},
\code{\link{hash_md5}()},
\code{\link{hash_sha1}()},
\code{\link{hash_sha256}()}
}
\concept{hash functions}
