% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/favor.R
\name{conflicts_prefer}
\alias{conflicts_prefer}
\title{Declare many preferences at once}
\usage{
conflicts_prefer(..., .quiet = FALSE)
}
\arguments{
\item{...}{Functions to prefer in form \code{pkg::fun} or \code{pkg::fun()}.}

\item{.quiet}{If \code{TRUE}, all output will be suppressed}
}
\description{
\code{conflicts_prefer()} allows you to declare "winners" of conflicts,
declaring one or many winners at once.

See \code{\link[=conflict_prefer]{conflict_prefer()}} for more precise control.
}
\section{Best practices}{

I recommend placing a single call to \code{conflicts_prefer()} at the top of
your script, immediately after loading all needed packages with calls to
\code{library()}.
}

\examples{
conflicts_prefer(
  dplyr::filter(),
  dplyr::lag(),
)

# or
conflicts_prefer(
  dplyr::filter,
  dplyr::lag,
)
}
