% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_trim.R
\name{group_trim}
\alias{group_trim}
\title{Trim grouping structure}
\usage{
group_trim(.tbl, .drop = group_by_drop_default(.tbl))
}
\arguments{
\item{.tbl}{A \link[=grouped_df]{grouped data frame}}

\item{.drop}{See \code{\link[=group_by]{group_by()}}}
}
\value{
A \link[=grouped_df]{grouped data frame}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
Drop unused levels of all factors that are used as grouping variables,
then recalculates the grouping structure.

\code{group_trim()} is particularly useful after a \code{\link[=filter]{filter()}} that is intended
to select a subset of groups.
}
\examples{
iris \%>\%
  group_by(Species) \%>\%
  filter(Species == "setosa", .preserve = TRUE) \%>\%
  group_trim()
}
\seealso{
Other grouping functions: 
\code{\link{group_by}()},
\code{\link{group_map}()},
\code{\link{group_nest}()},
\code{\link{group_split}()}
}
\concept{grouping functions}
