% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme-current.R
\name{get_theme}
\alias{get_theme}
\alias{theme_get}
\alias{set_theme}
\alias{theme_set}
\alias{update_theme}
\alias{theme_update}
\alias{replace_theme}
\alias{theme_replace}
\alias{\%+replace\%}
\title{Get, set, and modify the active theme}
\usage{
get_theme()

theme_get()

set_theme(new = NULL)

theme_set(new = NULL)

update_theme(...)

theme_update(...)

replace_theme(...)

theme_replace(...)

e1 \%+replace\% e2
}
\arguments{
\item{new}{new theme (a list of theme elements). Sets theme to the default (\code{\link[=theme_grey]{theme_grey()}}) if \code{new} isn't supplied.}

\item{...}{named list of theme settings}

\item{e1, e2}{Theme and element to combine}
}
\value{
\code{set_theme()}, \code{update_theme()}, and \code{replace_theme()}
invisibly return the previous theme so you can easily save it, then
later restore it.
}
\description{
The current/active theme (see \code{\link[=theme]{theme()}}) is automatically applied to every
plot you draw. Use \code{get_theme()} to get the current theme, and \code{set_theme()} to
completely override it. \code{update_theme()} and \code{replace_theme()} are shorthands for
changing individual elements.
}
\section{Adding on to a theme}{


\code{+} and \verb{\%+replace\%} can be used to modify elements in themes.

\code{+} updates the elements of e1 that differ from elements specified (not
\code{NULL}) in e2. Thus this operator can be used to incrementally add or modify
attributes of a ggplot theme.

In contrast, \verb{\%+replace\%} replaces the entire element; any element of a
theme not specified in e2 will not be present in the resulting theme (i.e.
\code{NULL}). Thus this operator can be used to overwrite an entire theme.

\code{update_theme()} uses the \code{+} operator, so that any unspecified values in the
theme element will default to the values they are set in the theme.
\code{replace_theme()} uses \verb{\%+replace\%} to completely replace the element, so any
unspecified values will overwrite the current value in the theme with
\code{NULL}.

In summary, the main differences between \code{set_theme()}, \code{update_theme()},
and \code{replace_theme()} are:
\itemize{
\item \code{set_theme()} completely overrides the current theme.
\item \code{update_theme()} modifies a particular element of the current theme
using the \code{+} operator.
\item \code{replace_theme()} modifies a particular element of the current theme
using the \verb{\%+replace\%} operator.
}
}

\examples{
p <- ggplot(mtcars, aes(mpg, wt)) +
  geom_point()
p

# Use set_theme() to completely override the current theme.
# update_theme() and replace_theme() are similar except they
# apply directly to the current/active theme.
# update_theme() modifies a particular element of the current theme.
# Here we have the old theme so we can later restore it.
# Note that the theme is applied when the plot is drawn, not
# when it is created.
old <- set_theme(theme_bw())
p

set_theme(old)
update_theme(panel.grid.minor = element_line(colour = "red"))
p

set_theme(old)
replace_theme(panel.grid.minor = element_line(colour = "red"))
p

set_theme(old)
p


# Modifying theme objects -----------------------------------------
# You can use + and \%+replace\% to modify a theme object.
# They differ in how they deal with missing arguments in
# the theme elements.

add_el <- theme_grey() +
  theme(text = element_text(family = "Times"))
add_el$text

rep_el <- theme_grey() \%+replace\%
  theme(text = element_text(family = "Times"))
rep_el$text

}
\seealso{
\code{\link[=add_gg]{add_gg()}}
}
