htmltools 0.5.1.1
--------------------------------------------------------------------------------

* Added shiny as a suggested package.


htmltools 0.5.1
--------------------------------------------------------------------------------

## New Features & Improvements

* Added a new `tagFunction()` for generating `tags` and/or `htmlDependency()`s conditional on the rendering context. For an example, see `?tagFunction`. (#180)

* Closed #104: `save_html()`'s `file` argument now properly handles relative paths. (@haozhu233, #105, #192)

* `save_html()` now has a `lang` parameter that can be used to set the lang attribute of `<html>`. (@ColinFay, #185)

* Closed #101: `htmlDependency` & `renderDependencies` now allow the `script` argument to be given as a named list containing the elements: `src`, `integrity`, `crossorigin`. (@matthewstrasiotto, #188)

* Closed #189: `validateCssUnit()` now accepts `fit-content`. (#190)

* `htmlPreserve()` can now optionally use the Pandoc `raw_attribute` extension to enclose HTML.

## Breaking Changes

* Closed #161: `parseCssColors(x)` now requires `x` to be a character vector (it no longer accepts a `list()` of strings) and an error is no longer thrown when `mustWork = FALSE` and `x` contains `NA` value(s). (#194)

## Bug fixes

* `print(as.tags(x))` no longer results in error when `x` is a generic `list()` of tag-like objects. (#181)


htmltools 0.5.0
--------------------------------------------------------------------------------

* `tags` is now generated by a script which collects all
  [HTML](https://developer.mozilla.org/en-US/docs/Web/HTML/Element) and
  [SVG](https://developer.mozilla.org/en-US/docs/Web/SVG/Element) element tags
  documented in [MDN Web Docs](https://developer.mozilla.org).  This feature
  only appends to the existing set of `tags` (#159)

* Removed the Rcpp depedency and the compiled code now uses C rather than C++ (#158)

* BREAKING CHANGE: Fixed #57, #153: `htmlTemplate` output no longer inserts
  extra whitespace around {{...}} replacement values. (#154)

* `HTML()` now takes `.noWS` argument, which can be used to suppress surrounding
  whitespace (similar to the new argument for tags in htmltools 0.4.0). (#154)

* `css()` now returns `NULL` instead of `""` when no non-empty properties are
  specified. (#145)

* `save_html(tags$body(...))` no longer results in double <body> tags being
  written to the .html file. (Note that `save_html(tags$html(...))` is not
  supported at this time.) (#145)

* Trailing commas now permited in `...` arguments to `css()`, `tagList()`, and
  the var-arg mutation functions: `tagAppendAttributes()`, `tagSetChildren()`,
  and `tagAppendChildren()`. (#145)

* Added `capturePlot` and `plotTag` functions, for easily creating image files
  and HTML <img> tags (respectively) from plot expressions. (#150)

* Added `parseCssColors` function, for normalizing the various CSS color formats
  into #RRGGBB(AA) strings. (#155)

* Fixed #156: Now `extractPreserveChunks()` handles strings contain Emoji Unicode strings correctly on Windows. (#157)

* The `.noWS` parameter for suppressing whitespace can now take an `"inside"`
  value (equivalent to `c("after-start", "before-end")`). (#163)

htmltools 0.4.0
--------------------------------------------------------------------------------

* Fixed #128: Added support for trailing commas in tagLists and the predefined
  tags. (#135)

* Added some HTML tag functions to `tags` that were missing. (#111)

* Updated RcppExports for new version of Rcpp. (#93)

* `as.character.shiny.tags()` will handle non-ASCII attributes correctly if they
  are not encoded in native encoding.

* Fixed #99: `NA` attributes were sometimes rendered as `"NA"` in the HTML,
  instead of being blank. (#100)

* The error message for trailing commas in tag functions now provides context
  and useful information. (#109)

* Stopped using inline styles to set background color for `save_html`, as doing so
  makes it difficult to override using other CSS rules. (#123)

* Added a `.noWS` argument to `tag()` and `tags` which can be used to suppress
  the automatically generated whitespace around a particular tag. (#131)

* Added a shim for `system.file()` so that htmltools works with `htmlDependency`
  objects created by a package that was loaded with `devtools::load_all()`.
  (#129)

* `validateCssUnit()` now accepts `ch`, `rem`, and `calc()`. (#134)

* Fixed #125: `print.html` removes html dependencies. (#126)

* Stopped extra carriage returns from being inserted by `save_html` on Windows.
  (#137)

htmltools 0.3.6
--------------------------------------------------------------------------------

* `validateCssUnit()` now accepts viewport units (vw, vh, vmin, vmax). (#56)

* `restorePreserveChunks()` marks the output with the correct encoding now
  (UTF-8).

* Length-0 attributes are now dropped, like NULLs. (#65)

* Fixed #69: On Windows, `renderDocument()` did not mark output as UTF-8 if the
  head was UTF-8 but body was ASCII. (#71)

htmltools 0.3.5
--------------------------------------------------------------------------------

* `as.character` now returns a character vector with no other attributes.
  Previously it returned a character vector of class 'html'. (#31, #41)

* `htmlTemplate` now can use a string as a template instead of requiring a
  file. (#41, #43)

* HTML dependencies can now be added inline, instead of needing to use
  `attachDependencies()`. (#40, #42)

* `htmlDependency()` gained a new argument `all_files` to indicate whether all
  files under the src directory should be copied when rendering dependencies,
  or only those specified in the dependency objects. (#48)

* `copyDependencyToDir()` will always completely overwrite the target directory
  when copying HTML dependency files to make sure all dependency files are
  definitely updated in the target directory when the original dependency
  directory has been updated. In the past, the dependency files were not updated
  if they already existed. (#36)

* The version number in the directory name of an HTML dependency can be
  suppressed by setting options(htmltools.dir.version = FALSE) when the
  dependency is copied via `copyDependencyToDir()`. (#37)

* Performance improvement rendering tags, by switching from `readLines` to
  `readChar`.

htmltools 0.3
--------------------------------------------------------------------------------

* Add `css` function for conveniently forming CSS declaration strings.

* Add template support, with the `htmlTemplate()`, `renderDocument()`, and
  `suppressDependencies()` functions.


htmltools 0.2.9
--------------------------------------------------------------------------------

* Add check that `htmlDependency()` isn't called with an absolute path when a
  binary package is built. (#22)

* Allow HTML content to include UTF-8, Latin1, and system encoded content. All
  will be converted to UTF-8 using enc2utf8() at render time. (#21)

* Add `tagGetAttribute()` and `tagHasAttribute()` functions.


htmltools 0.2.7
--------------------------------------------------------------------------------

* Add "append" parameter to attachDependencies, to allow adding dependencies,
  instead of replacing them.


htmltools 0.2.6
--------------------------------------------------------------------------------

* Add "attachment" parameter to htmlDependency, which can be used to allow any
  file in the dependency directory to be available via URL at runtime.


htmltools 0.2.5
--------------------------------------------------------------------------------

* Explicit library(htmltools) is no longer required for tags to be rendered in
  knitr/rmarkdown documents.

* Added "viewer" parameter to html_print.


htmltools 0.2.4
--------------------------------------------------------------------------------

Initial release
