% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCMCfactanal.R
\name{MCMCfactanal}
\alias{MCMCfactanal}
\title{Markov Chain Monte Carlo for Normal Theory Factor Analysis Model}
\usage{
MCMCfactanal(
  x,
  factors,
  lambda.constraints = list(),
  data = NULL,
  burnin = 1000,
  mcmc = 20000,
  thin = 1,
  verbose = 0,
  seed = NA,
  lambda.start = NA,
  psi.start = NA,
  l0 = 0,
  L0 = 0,
  a0 = 0.001,
  b0 = 0.001,
  store.scores = FALSE,
  std.var = TRUE,
  ...
)
}
\arguments{
\item{x}{Either a formula or a numeric matrix containing the
manifest variables.}

\item{factors}{The number of factors to be fitted.}

\item{lambda.constraints}{List of lists specifying possible simple
equality or inequality constraints on the factor loadings. A
typical entry in the list has one of three forms:
\code{varname=list(d,c)} which will constrain the dth loading for
the variable named \code{varname} to be equal to c,
\code{varname=list(d,"+")} which will constrain the dth loading
for the variable named \code{varname} to be positive, and
\code{varname=list(d, "-")} which will constrain the dth loading
for the variable named \code{varname} to be negative. If x is a
matrix without column names defaults names of ``V1",``V2", ... ,
etc will be used.}

\item{data}{A data frame.}

\item{burnin}{The number of burn-in iterations for the sampler.}

\item{mcmc}{The number of iterations for the sampler.}

\item{thin}{The thinning interval used in the simulation.  The
number of iterations must be divisible by this value.}

\item{verbose}{A switch which determines whether or not the
progress of the sampler is printed to the screen.  If
\code{verbose} is greater than 0 the iteration number and the
factor loadings and uniquenesses are printed to the screen every
\code{verbose}th iteration.}

\item{seed}{The seed for the random number generator.  If NA, the
Mersenne Twister generator is used with default seed 12345; if an
integer is passed it is used to seed the Mersenne twister.  The
user can also pass a list of length two to use the L'Ecuyer
random number generator, which is suitable for parallel
computation.  The first element of the list is the L'Ecuyer seed,
which is a vector of length six or NA (if NA a default seed of
\code{rep(12345,6)} is used).  The second element of list is a
positive substream number. See the MCMCpack specification for
more details.}

\item{lambda.start}{Starting values for the factor loading matrix
Lambda. If \code{lambda.start} is set to a scalar the starting
value for all unconstrained loadings will be set to that
scalar. If \code{lambda.start} is a matrix of the same dimensions
as Lambda then the \code{lambda.start} matrix is used as the
starting values (except for equality-constrained elements). If
\code{lambda.start} is set to \code{NA} (the default) then
starting values for unconstrained elements are set to 0, and
starting values for inequality constrained elements are set to
either 0.5 or -0.5 depending on the nature of the constraints.}

\item{psi.start}{Starting values for the uniquenesses. If
\code{psi.start} is set to a scalar then the starting value for
all diagonal elements of \code{Psi} are set to this value. If
\code{psi.start} is a \eqn{k}-vector (where \eqn{k} is the number
of manifest variables) then the staring value of \code{Psi} has
\code{psi.start} on the main diagonal. If \code{psi.start} is set
to \code{NA} (the default) the starting values of all the
uniquenesses are set to 0.5.}

\item{l0}{The means of the independent Normal prior on the factor loadings.
Can be either a scalar or a matrix with the same dimensions as
\code{Lambda}.}

\item{L0}{The precisions (inverse variances) of the independent Normal prior
on the factor loadings. Can be either a scalar or a matrix with the same
dimensions as \code{Lambda}.}

\item{a0}{Controls the shape of the inverse Gamma prior on the uniqueness.
The actual shape parameter is set to \code{a0/2}. Can be either a scalar or
a \eqn{k}-vector.}

\item{b0}{Controls the scale of the inverse Gamma prior on the uniquenesses.
The actual scale parameter is set to \code{b0/2}. Can be either a scalar or
a \eqn{k}-vector.}

\item{store.scores}{A switch that determines whether or not to store the
factor scores for posterior analysis.  \emph{NOTE: This takes an enormous
amount of memory, so should only be used if the chain is thinned heavily, or
for applications with a small number of observations}.  By default, the
factor scores are not stored.}

\item{std.var}{If \code{TRUE} (the default) the manifest variables are
rescaled to have zero mean and unit variance. Otherwise, the manifest
variables are rescaled to have zero mean but retain their observed
variances.}

\item{...}{further arguments to be passed}
}
\value{
An mcmc object that contains the sample from the posterior
distribution. This object can be summarized by functions provided by the
coda package.
}
\description{
This function generates a sample from the posterior distribution of
a normal theory factor analysis model. Normal priors are assumed on
the factor loadings and factor scores while inverse Gamma priors
are assumed for the uniquenesses. The user supplies data and
parameters for the prior distributions, and a sample from the
posterior distribution is returned as an mcmc object, which can be
subsequently analyzed with functions provided in the coda package.
}
\details{
The model takes the following form:

\deqn{x_i = \Lambda \phi_i + \epsilon_i}

\deqn{\epsilon_i \sim \mathcal{N}(0,\Psi)}

where \eqn{x_i} is the \eqn{k}-vector of observed variables
specific to observation \eqn{i}, \eqn{\Lambda} is the \eqn{k \times
d} matrix of factor loadings, \eqn{\phi_i} is the \eqn{d}-vector of
latent factor scores, and \eqn{\Psi} is a diagonal, positive
definite matrix. Traditional factor analysis texts refer to the
diagonal elements of \eqn{\Psi} as uniquenesses.

The implementation used here assumes independent conjugate priors
for each element of \eqn{\Lambda} each \eqn{\phi_i}, and each
diagonal element of \eqn{\Psi}. More specifically we assume:

\deqn{\Lambda_{ij} \sim \mathcal{N}(l_{0_{ij}}, L_{0_{ij}}^{-1}),
i=1,\ldots,k, j=1,\ldots,d}

\deqn{\phi_i \sim \mathcal{N}(0, I), i=1,\dots,n}

\deqn{\Psi_{ii} \sim \mathcal{IG}(a_{0_i}/2, b_{0_i}/2),
i=1,\ldots,k}

\code{MCMCfactanal} simulates from the posterior distribution using
standard Gibbs sampling. The simulation proper is done in compiled
C++ code to maximize efficiency.  Please consult the coda
documentation for a comprehensive list of functions that can be
used to analyze the posterior sample.

As is the case with all measurement models, make sure that you have
plenty of free memory, especially when storing the scores.
}
\examples{

   \dontrun{
   ### An example using the formula interface
   data(swiss)
   posterior <- MCMCfactanal(~Agriculture+Examination+Education+Catholic
                    +Infant.Mortality, factors=2,
                    lambda.constraints=list(Examination=list(1,"+"),
                       Examination=list(2,"-"), Education=c(2,0),
                       Infant.Mortality=c(1,0)),
                    verbose=0, store.scores=FALSE, a0=1, b0=0.15,
                    data=swiss, burnin=5000, mcmc=50000, thin=20)
   plot(posterior)
   summary(posterior)

   ### An example using the matrix interface
   Y <- cbind(swiss$Agriculture, swiss$Examination,
              swiss$Education, swiss$Catholic,
              swiss$Infant.Mortality)
   colnames(Y) <- c("Agriculture", "Examination", "Education", "Catholic",
                    "Infant.Mortality")
   post <- MCMCfactanal(Y, factors=2,
                        lambda.constraints=list(Examination=list(1,"+"),
                          Examination=list(2,"-"), Education=c(2,0),
                          Infant.Mortality=c(1,0)),
                        verbose=0, store.scores=FALSE, a0=1, b0=0.15,
                        burnin=5000, mcmc=50000, thin=20)
   }

}
\references{
Andrew D. Martin, Kevin M. Quinn, and Jong Hee Park. 2011.
``MCMCpack: Markov Chain Monte Carlo in R.'', \emph{Journal of Statistical
Software}. 42(9): 1-21.  \url{https://www.jstatsoft.org/v42/i09/}.

Daniel Pemstein, Kevin M. Quinn, and Andrew D. Martin.  2007.  \emph{Scythe
Statistical Library 1.0.} \url{http://scythe.lsa.umich.edu}.

Martyn Plummer, Nicky Best, Kate Cowles, and Karen Vines. 2006.  ``Output
Analysis and Diagnostics for MCMC (CODA)'', \emph{R News}. 6(1): 7-11.
\url{https://CRAN.R-project.org/doc/Rnews/Rnews_2006-1.pdf}.
}
\seealso{
\code{\link[coda]{plot.mcmc}},\code{\link[coda]{summary.mcmc}},\code{\link[stats]{factanal}}
}
\keyword{models}
