% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tk2swaplist.R
\name{tk2swaplist}
\alias{tk2swaplist}
\title{A list selector that allows to select and arrange items freely}
\usage{
tk2swaplist(items, selection, title = "Select items", ...)
}
\arguments{
\item{items}{A vector with all items.}

\item{selection}{A vector with preselected items (must be a subset of \code{items}).}

\item{title}{The title of the dialog box, by default, "Select items".}

\item{...}{Further parameters passed to swaplist, see its tcl man page:
https://core.tcl-lang.org/tklib/doc/trunk/embedded/www/tklib/files/modules/swaplist/swaplist.html.}
}
\value{
A vector with the selected items in the chosen order.
}
\description{
The swaplist is perfect to select and arrange items in a given order from a
fixed initial set of possible items.
}
\examples{
\dontrun{
library(tcltk2)
# tk2swaplist() makes its use super-easy
tk2swaplist(1:9, selection = c(1, 3, 5))

# Use of the swaplist on your own
tclRequire("swaplist")
tt <- tktoplevel()
opts <- tclVar()
sl <- tcl("swaplist::swaplist", tt, opts, 1:9, c(1, 3, 5))
cat("You choose:", tclvalue(opts), "\n")
rm(opts, sl, tt)
}
}
\seealso{
\code{\link[=tk2listbox]{tk2listbox()}}, \code{\link[=tk2tablelist]{tk2tablelist()}}
}
