/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

var gTestfile = 'regress-348685.js';
//-----------------------------------------------------------------------------
var BUGNUMBER = 348685;
var summary = 'Let scoped variables should not be referenced outside blocks';
var actual = '';
var expect = '';


//-----------------------------------------------------------------------------
test();
//-----------------------------------------------------------------------------

function test()
{
  enterFunc ('test');
  printBugNumber(BUGNUMBER);
  printStatus (summary);
 
  function f() {
    for (let i = 0; i < 2; i++) {
      let j = 42;
      function g() {}
    }
    var a = i;
    print(a);
    print(i);
    return i;
  }

  expect = /ReferenceError: (i|"i") is not defined/;

  try
  {
    f();
  }
  catch(ex)
  {
    actual = ex + '';
  }
  reportMatch(expect, actual, summary);

  exitFunc ('test');
}
