# 2023-07-26 Triage Log

A relatively light week with respect to performance changes. The one major
regressing PR was reverted (for other reasons), and we saw some very nice gains
on compile-times from (1.) changes to our codegen-unit merging logic and from
(2.) changes to the stdlib slice iterators encoding its non-null guarantees
directly, allowing the removal of a call to the `assume` intrinsic.

Triage done by **@pnkfelix**.
Revision range: [6b9236ed..0308df23](https://perf.rust-lang.org/?start=6b9236ed5a58879969ddcf4c35a6a24f6260e979&end=0308df23e621e783e31a27ca5beaa01b9df60d4a&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.4%  | [0.6%, 10.2%]  | 27    |
| Regressions ❌ <br /> (secondary)  | 1.1%  | [0.3%, 2.9%]   | 19    |
| Improvements ✅ <br /> (primary)   | -2.2% | [-8.3%, -0.4%] | 21    |
| Improvements ✅ <br /> (secondary) | -1.6% | [-2.0%, -1.2%] | 2     |
| All ❌✅ (primary)                 | -0.2% | [-8.3%, 10.2%] | 48    |


1 Regressions, 1 Improvements, 4 Mixed; 1 of them in rollups
35 artifact comparisons made in total

#### Regressions

Prototype: Add unstable `-Z reference-niches` option [#113166](https://github.com/rust-lang/rust/pull/113166) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=1e6c09a803fd543a98bfbe1624d697a55300a786&end=557359f92512ca88b62a602ebda291f17a953002&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.7% | [0.3%, 1.1%] | 19    |
| Regressions ❌ <br /> (secondary)  | 1.0% | [0.3%, 1.2%] | 4     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.7% | [0.3%, 1.1%] | 19    |

* reverted in PR #113946
* marked as triaged

#### Improvements

Inline overlap based CGU merging [#113777](https://github.com/rust-lang/rust/pull/113777) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=903e279f468590fa3425f8aff7f3d61a5a873dbb&end=0d6a9b2bf7f823ed563ca3a75392ba9bf9ff1566&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.2%  | [1.2%, 1.2%]   | 1     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -1.8% | [-4.5%, -0.3%] | 11    |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -1.6% | [-4.5%, 1.2%]  | 12    |

this improved instruction-counts for 9 opt-full primary benchmarks. (The one regression was to regex-1.5.5 opt-full, by -1.15%; but the wins elsewhere pay for this.)

As noted by @nnethercote , this results in nearly 10second reduction in bootstrap time (i.e. -1.495%, no small feat at all!)

#### Mixed

Turn copy into moves during DSE. [#113758](https://github.com/rust-lang/rust/pull/113758) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=6b53175b5d8558b69f5f46ce969fe42fb457e01b&end=06a53ddc0bd3a50f9bcf2f7c373011dc7869f59f&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 9.4%  | [9.4%, 9.4%]   | 1     |
| Regressions ❌ <br /> (secondary)  | 0.6%  | [0.6%, 0.6%]   | 1     |
| Improvements ✅ <br /> (primary)   | -1.0% | [-2.1%, -0.2%] | 14    |
| Improvements ✅ <br /> (secondary) | -0.8% | [-1.3%, -0.2%] | 2     |
| All ❌✅ (primary)                 | -0.3% | [-2.1%, 9.4%]  | 15    |

* regression is to webrender-2022 opt incr-patched, (by 9.4%, as you can see from the above)
* from the flamegraphs, seems like `codegen_module_perform_lto` went from 8.6 seconds to 9.6 seconds, with half of the growth in `LLVM_lto_optimize`, and half in `LLVM_module_codegen_emit_obj`.
* not marking as triaged for now.

Rollup of 7 pull requests [#113890](https://github.com/rust-lang/rust/pull/113890) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=06a53ddc0bd3a50f9bcf2f7c373011dc7869f59f&end=092e4f46be168ab24d53e4141086b2cf04822b8e&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.2%  | [0.2%, 0.2%]   | 1     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.3%, -0.2%] | 4     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.3% | [-0.3%, -0.2%] | 4     |

* that doesn't seem worth dissecting
* marking as triaged
* (the specific secondary is tt-muncher check incr-unchanged 0.23%)

Always const-prop scalars and scalar pairs [#113858](https://github.com/rust-lang/rust/pull/113858) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=399b068235ceea440540539b3bfd1aeb82214a28&end=e2a7ba2771a70439cd546fdae676abe11dacf6f9&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.8%  | [0.3%, 3.3%]   | 42    |
| Regressions ❌ <br /> (secondary)  | 0.7%  | [0.2%, 1.1%]   | 19    |
| Improvements ✅ <br /> (primary)   | -0.6% | [-1.3%, -0.2%] | 6     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | 0.6%  | [-1.3%, 3.3%]  | 48    |

* we didn't anticipate such a high impact to the instruction-counts; the trial run said there were two primary regressions here, not 42.
    * exa-0.10.1 opt-full regressed by 3.34%
    * five various bitmaps-3.1.0 profiles/scenarios regressed by 1.01% to 1.21%
    * ripgrep-13.0.0 check-incr-unchanged regressed by 1.01%
    * bunch of others that regressed by a little less than 1%... seems not great.
* not marking as triaged.

Get `!nonnull` metadata on slice iterators, without `assume`s [#113344](https://github.com/rust-lang/rust/pull/113344) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=e2a7ba2771a70439cd546fdae676abe11dacf6f9&end=c720a9cd1280d24838d0f649538dcd0e4352692c&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 8.3%  | [8.3%, 8.3%]   | 1     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -1.1% | [-8.3%, -0.5%] | 63    |
| Improvements ✅ <br /> (secondary) | -0.7% | [-1.1%, -0.3%] | 15    |
| All ❌✅ (primary)                 | -1.0% | [-8.3%, 8.3%]  | 64    |

* cranelift-codegen-0.82.1 opt-full regressed by 8.31%
* a slew of other benchmarks improved (regex-1.5.5 incr-patched by -8.28%, bitmaps incr by 1.2-1.4%, the rest by -1% or less)
* overall, a nice win. That's enough to let me mark this as triaged.


#### Untriaged Pull Requests

- [#114011 interpret: Unify projections for MPlaceTy, PlaceTy, OpTy](https://github.com/rust-lang/rust/pull/114011)
- [#114004 Add `riscv64gc-unknown-hermit` target](https://github.com/rust-lang/rust/pull/114004)
- [#113973 match on chars instead of &strs for .split() or .strip_prefix()](https://github.com/rust-lang/rust/pull/113973)
- [#113965 Fix test panics for submodule of book is not updated](https://github.com/rust-lang/rust/pull/113965)
- [#113890 Rollup of 7 pull requests](https://github.com/rust-lang/rust/pull/113890)
- [#113858 Always const-prop scalars and scalar pairs](https://github.com/rust-lang/rust/pull/113858)
- [#113758 Turn copy into moves during DSE.](https://github.com/rust-lang/rust/pull/113758)
- [#113485 Bump version to 1.73](https://github.com/rust-lang/rust/pull/113485)
- [#113476 Reimplement C-str literals](https://github.com/rust-lang/rust/pull/113476)
- [#113370 Rollup of 8 pull requests](https://github.com/rust-lang/rust/pull/113370)
- [#113344 Get `!nonnull` metadata on slice iterators, without `assume`s](https://github.com/rust-lang/rust/pull/113344)
- [#113320 Add some extra information to opaque type cycle errors](https://github.com/rust-lang/rust/pull/113320)
- [#113306 Update debuginfo test runner to provide more useful output](https://github.com/rust-lang/rust/pull/113306)
- [#113304 Upgrade to indexmap 2.0.0](https://github.com/rust-lang/rust/pull/113304)
- [#113270 perform TokenStream replacement in-place when possible in expand_macro](https://github.com/rust-lang/rust/pull/113270)
- [#113166 Prototype: Add unstable `-Z reference-niches` option](https://github.com/rust-lang/rust/pull/113166)
- [#113057 Rollup of 2 pull requests](https://github.com/rust-lang/rust/pull/113057)
- [#112963 Stop bubbling out hidden types from the eval obligation queries](https://github.com/rust-lang/rust/pull/112963)
- [#112882 Rewrite `UnDerefer`](https://github.com/rust-lang/rust/pull/112882)
- [#112420 Rollup of 4 pull requests](https://github.com/rust-lang/rust/pull/112420)
- [#112157 Resurrect: rustc_target: Add alignment to indirectly-passed by-value types, correcting the alignment of byval on x86 in the process.](https://github.com/rust-lang/rust/pull/112157)
- [#112083 Make `TrustedStep` require `Copy`](https://github.com/rust-lang/rust/pull/112083)
- [#112016 Rollup of 6 pull requests](https://github.com/rust-lang/rust/pull/112016)
- [#112001 Enable MatchBranchSimplification](https://github.com/rust-lang/rust/pull/112001)
- [#111869 Rollup of 6 pull requests](https://github.com/rust-lang/rust/pull/111869)
- [#111850 Specialize `StepBy<Range<{integer}>>`](https://github.com/rust-lang/rust/pull/111850)
- [#111813 MIR: opt-in normalization of `BasicBlock` and `Local` numbering](https://github.com/rust-lang/rust/pull/111813)
- [#111623 move `super_relate_consts` hack to `normalize_param_env_or_error`](https://github.com/rust-lang/rust/pull/111623)
- [#111524 `ascii::Char`-ify the escaping code in `core`](https://github.com/rust-lang/rust/pull/111524)
- [#111425 Populate effective visibilities in `rustc_privacy` (take 2)](https://github.com/rust-lang/rust/pull/111425)
