* PACKAGE P2GRAV !" ʪ(2) (ߡ)
* 
********************************************************************* 
      SUBROUTINE GRAVTY          !" 
     O         ( UTG    , VTG    , TAUXG  , TAUYG  , 
     I           GDZSD  , IDSFC  , 
     I           GDU    , GDV    , GDT    , GDP    , GDTG   , 
     I           GDZ    , GDTM   , GDPM                       )
* 
*" [HIS] 92/07/20(takepiro)
*
*   [PARAM] 
#ifdef SYS_IBMS
      INCLUDE   (ZCDIM)                     !" GRID AND WAVE NUMBER
      INCLUDE   (ZCCOM)                     !" BASIC CONSTANTS
#else
#include        "zcdim.F"                   !" GRID AND WAVE NUMBER
#include        "zccom.F"                   !" BASIC CONSTANTS
#endif
* 
*   [OUTPUT] 
      REAL      UTG   ( IDIM*JDIM, KMAX )   !" U TENDENCY BY GRAVITY 
      REAL      VTG   ( IDIM*JDIM, KMAX )   !" V TENDENCY BY GRAVITY 
      REAL      TAUXG ( IDIM*JDIM, KMAX+1 ) !" U GRAVITY MOMENTUM 
      REAL      TAUYG ( IDIM*JDIM, KMAX+1 ) !" V GRAVITY MOMENTUM 
* 
*   [INPUT] 
      REAL      GDZSD ( IDIM*JDIM )         !" STANDARD DEVIATION 
      INTEGER   IDSFC ( IDIM*JDIM )         !" SURFACE INDEX 
      REAL      GDU   ( IDIM*JDIM, KMAX )   !" WESTERLY 
      REAL      GDV   ( IDIM*JDIM, KMAX )   !" SOUTHERLY WIND 
      REAL      GDT   ( IDIM*JDIM, KMAX )   !" TEMPERATURE 
      REAL      GDP   ( IDIM*JDIM, KMAX )   !" PRESSURE 
      REAL      GDTG  ( IDIM*JDIM )         !" SURFACE TEMPERATURE 
      REAL      GDZ   ( IDIM*JDIM, KMAX )   !" HEIGHT 
* 
      REAL      GDTM  ( IDIM*JDIM, KMAX+1 ) !" TEMPERATURE(INTERFACE) 
      REAL      GDPM  ( IDIM*JDIM, KMAX+1 ) !" PRESSURE(INTERFACE) 
* 
*   [INTERNAL PARM] 
      LOGICAL OFIRST 
      DATA    OFIRST /  .TRUE.  / 
      SAVE
*
      INTEGER    IJ, K
* 
*          < 0.0 GRAVITY WAVE DRAG PARAMETERS >
* 
      IF ( OFIRST ) THEN 
         WRITE ( 6,* ) ' DUMMY GRAVITY WAVE DRAG -  92/07/20' 
         OFIRST = .FALSE. 
      ENDIF 
* 
* 
*          < 1.  SET DUMMY VALUES > 
* 
      DO 3100 K = 1, KMAX 
         DO 3100 IJ = 1, IDIM*JDIM
               UTG  ( IJ,K ) = 0.  
               VTG  ( IJ,K ) = 0.  
               TAUXG( IJ,K ) = 0.  
               TAUYG( IJ,K ) = 0.  
 3100 CONTINUE 
* 
      RETURN 
      END 
