* PACKAGE DDIAG  !" ϳ  
*
*"  [HIS]  90/05/19(numaguti)
*
***********************************************************************
      SUBROUTINE DDIAG      !"  ǽ 
     I         ( GDU   , GDV   , GDT   , GDPS  , GDQ   ,
     I           GDVOR , GDDIV                          )
*
#ifdef SYS_IBMS
      INCLUDE   (ZCDIM)                      !" ʻ, ȿ
      INCLUDE   (ZCCOM)                      !" ɸʪ
#else
#include        "zcdim.F"                    !" ʻ, ȿ
#include        "zccom.F"                    !" ɸʪ
#endif
*
*   [INPUT]
      REAL       GDU   ( IDIM, JDIM, KMAX )  !"   
      REAL       GDV   ( IDIM, JDIM, KMAX )  !"   
      REAL       GDT   ( IDIM, JDIM, KMAX )  !"   
      REAL       GDPS  ( IDIM, JDIM )        !" ɽ
      REAL       GDQ   ( IDIM, JDIM, KMAX )  !" 漾  
      REAL       GDVOR ( IDIM, JDIM, KMAX )  !"   
      REAL       GDDIV ( IDIM, JDIM, KMAX )  !" ȯ  
*
*   [INTERNAL WORK]
      COMMON    /COMWRK /
     &           GDKE  , GDIE  , GDPE , GDLE ,
     &           GDTE  , GDENS , GDTM
*
      REAL       GDKE  ( IDIM, JDIM, KMAX )  !" ưͥ륮
      REAL       GDIE  ( IDIM, JDIM, KMAX )  !" ͥ륮
      REAL       GDPE  ( IDIM, JDIM, KMAX )  !" ݥƥ󥷥
      REAL       GDLE  ( IDIM, JDIM, KMAX )  !" Ǯͥ륮
      REAL       GDTE  ( IDIM, JDIM, KMAX )  !" ͥ륮
      REAL       GDENS ( IDIM, JDIM, KMAX )  !" 󥹥ȥե
      REAL       GDTM  ( IDIM, JDIM )        !" 
*
      INTEGER    I,J,K

*    [INTERNAL ONCE]      
      LOGICAL    OFIRST
      DATA       OFIRST / .TRUE. /
      SAVE       OFIRST
*[ONCE]
      IF ( OFIRST ) THEN
         OFIRST = .FALSE.
         CALL DDIHRG
      ENDIF
*
*"         < 1. ͥ륮󥹥ȥե >
*
*
      CALL GHYDRO
     O   ( GDPE  ,
     I     GDT     )
*
      DO 1100 K = 1, KMAX
         DO 1100 I = 1, IMAX
            DO 1100 J = 1, JMAX
*
               GDKE ( I,J,K )
     &                = ( GDU( I,J,K )**2 + GDV( I,J,K )**2 )/ 2.  
     &                  * GDPS( I,J ) * 100. / GRAV
*
               GDIE ( I,J,K )
     &                = CP * GDT( I,J,K )
     &                  * GDPS( I,J ) * 100. / GRAV
*
               GDPE ( I,J,K )
     &                = GDPE( I,J,K ) 
     &                  * GDPS( I,J ) * 100. / GRAV
*
               GDLE ( I,J,K )
     &                = EL * GDQ( I,J,K )
     &                  * GDPS( I,J ) * 100. / GRAV
*
               GDTE ( I,J,K )
     &                = GDKE ( I,J,K ) + GDIE ( I,J,K )
     &                + GDPE ( I,J,K ) + GDLE ( I,J,K )
*
               GDENS( I,J,K )
     &                = GDVOR ( I,J,K ) **2  
     &                  * GDPS( I,J ) * 100. / GRAV
*
 1100 CONTINUE
*
      DO 1200 I = 1, IMAX
         DO 1200 J = 1, JMAX
            GDTM ( I,J ) = GDPS ( I,J ) * 100. / GRAV
 1200 CONTINUE
*
      CALL HISTIN ( GDTM  , 'TM'  )
      CALL HISTIN ( GDKE  , 'KE'  )
      CALL HISTIN ( GDIE  , 'IE'  )
      CALL HISTIN ( GDPE  , 'PE'  )
      CALL HISTIN ( GDLE  , 'LE'  )
      CALL HISTIN ( GDTE  , 'TE'  )
      CALL HISTIN ( GDENS , 'ENS' )
*
      RETURN
      END
***********************************************************************
      SUBROUTINE DDIHRG      !"  ǽϤϿ 
*
*   [INTERNAL PARAM]
      INTEGER    ISTYPL
      DATA       ISTYPL / 1 /
*   [INTERNAL WORK]
      REAL       VMISS
*
      CALL GZDBGT ( 'MISS' , VMISS )
*
      CALL     HISTRG
     I       ( 'TM    ', 'total mass          ' ,'kg    ', 'ASFC',
     I           VMISS , VMISS , VMISS , VMISS , ISTYPL  ,
     I         'CON'   , '   ' , 0     , 0     , 'XYZ'   ,'(1PE12.3)' )
*
      CALL     HISTRG
     I       ( 'KE    ', 'kinetic energy      ' ,'J     ', 'ALEV',
     I           VMISS , VMISS , VMISS , VMISS , ISTYPL  ,
     I         'CON'   , '   ' , 0     , 0     , 'XYZ'   ,'(1PE12.3)' )
*
      CALL     HISTRG
     I       ( 'IE    ', 'internal energy      ' ,'J     ', 'ALEV',
     I           VMISS , VMISS , VMISS , VMISS , ISTYPL  ,
     I         'CON'   , '   ' , 0     , 0     , 'XYZ'   ,'(1PE12.3)' )
*
      CALL     HISTRG
     I       ( 'PE    ', 'potential energy     ' ,'J     ', 'ALEV',
     I           VMISS , VMISS , VMISS , VMISS , ISTYPL  ,
     I         'CON'   , '   ' , 0     , 0     , 'XYZ'   ,'(1PE12.3)' )
*
      CALL     HISTRG
     I       ( 'LE    ', 'latent energy        ' ,'J     ', 'ALEV',
     I           VMISS , VMISS , VMISS , VMISS , ISTYPL  ,
     I         'CON'   , '   ' , 0     , 0     , 'XYZ'   ,'(1PE12.3)' )
*
      CALL     HISTRG
     I       ( 'TE    ', 'total energy         ' ,'J     ', 'ALEV',
     I           VMISS , VMISS , VMISS , VMISS , ISTYPL  ,
     I         'CON'   , '   ' , 0     , 0     , 'XYZ'   ,'(1PE12.3)' )
*
      CALL     HISTRG
     I       ( 'ENS   ', 'enstrophy            ' ,'kg    ', 'ALEV',
     I           VMISS , VMISS , VMISS , VMISS , ISTYPL  ,
     I         'CON'   , '   ' , 0     , 0     , 'XYZ'   ,'(1PE12.3)' )
*
      RETURN
      END
***********************************************************************
      SUBROUTINE SPCTLD      !"  ڥȥ 
     I         ( WDATA , HTTL  , KDIMD , NMO   )
*
#ifdef SYS_IBMS
      INCLUDE (ZCDIM)                        !" ʻ, ȿ
#else
#include      "zcdim.F"                      !" ʻ, ȿ
#endif
*
*   [INPUT]
      INTEGER    KDIMD
      REAL       WDATA ( NMDIM, KDIMD )
      CHARACTER  HTTL  *(*)
      INTEGER    NMO   ( 2, 0:MMAX, 0:LMAX ) !" ڥȥź
*
*   [INTERNAL WORK]
      REAL       WAMP  ( 0:NMAX, KMAX+1 )
      LOGICAL    ODIAG
      INTEGER    JFLDIA, NCOLS, ISTR, IEND, IINT
      INTEGER    K,L,M,N
*
      CALL QDIAGP
     O     ( ODIAG , JFLDIA, NCOLS,
     O       ISTR  , IEND  , IINT ,
     I       KDIMD                  )
*
      IF ( .NOT. ODIAG )       RETURN
*
      CALL RESET ( WAMP, (NMAX+1)*KDIMD )
*
      DO 2100 K = 1, KDIMD
         DO 2110 N = 0 , NMAX
            DO 2120 M = 0 , MMAX, MINT
               L = N - M
               IF ( ( L .GE. 0 ).AND.( L .LE. LMAX ) ) THEN
                  WAMP ( N,K ) = WAMP ( N,K )
     &                         + WDATA( NMO(1,M,L),K ) ** 2
     &                         + WDATA( NMO(2,M,L),K ) ** 2
               ENDIF
 2120      CONTINUE
 2110   CONTINUE
 2100 CONTINUE
*
      WRITE ( JFLDIA, * ) '@@@@@@@@@@@@< SPECTRAL AMPLITUDE ', HTTL,
     &                    '>@@@@@@@@@@@@@'
*
      DO 3100 K = 1, KDIMD
         CALL PRINTD
     I       ( JFLDIA, '(1PE12.4)', WAMP  ,
     I         1     , NMAX+1 , 1     , K    ,
     I         NMAX+1, KDIMD  , NCOLS         )
 3100 CONTINUE
*
      RETURN
      END
