* PACKAGE P2VDFY  !" ʪ(2) ľȻ
*
***********************************************************************
      SUBROUTINE VDFCOF     !" ľȻ
     O         ( DFM   , DFH   , DFE   ,
     I           RIB   , DVDZ  , GDZM  ,
     W           RIF   , SHT   , SMT   , AML    )
*
*"     Ymamada Mellor, 1982
*
*   [PARAM] 
#ifdef SYS_IBMS
      INCLUDE   (ZCDIM)                      !" ʻ, ȿ
      INCLUDE   (ZCCOM)                      !" ɸʪ
#else
#include        "zcdim.F"                    !" ʻ, ȿ
#include        "zccom.F"                    !" ɸʪ
#endif
*
*   [OUTPUT] 
      REAL       DFM   ( IDIM*JDIM, KMAX+1 ) !" ͢
      REAL       DFH   ( IDIM*JDIM, KMAX+1 ) !" ͢
      REAL       DFE   ( IDIM*JDIM, KMAX+1 ) !" ͢
*
*   [INPUT] 
      REAL       RIB   ( IDIM*JDIM, KMAX )   !" Х륯ң
      REAL       DVDZ  ( IDIM*JDIM, KMAX )   !" d|v|/dz
      REAL       GDZM  ( IDIM*JDIM, KMAX )   !" 
*
*   [WORK] 
      REAL       RIF   ( IDIM*JDIM, KMAX )   !" եåң
      REAL       SHT   ( IDIM*JDIM, KMAX )   !" tilde(Sh)
      REAL       SMT   ( IDIM*JDIM, KMAX )   !" tilde(Sm)
      REAL       AML   ( IDIM*JDIM, KMAX )   !" Υ
*
*   [INTERNAL PARM] 
      REAL       AML0
      REAL       SHTMIN, SMTMIN
      REAL       DFMMIN, DFHMIN, DFEMIN
      REAL       DFMMAX, DFHMAX, DFEMAX
      DATA       AML0   /   300.   /         !" 纮Υ
      DATA       SHTMIN /     0.   /         !" tilde(Sh)Ǿ
      DATA       SMTMIN /     0.   /         !" tilde(Sm)Ǿ
      DATA       DFMMIN /    0.1   /         !" ȻǾ
      DATA       DFHMIN /    0.1   /         !" ԳȻǾ
      DATA       DFEMIN /    0.1   /         !" ȻǾ
      DATA       DFMMAX / 10000.   /         !" Ȼ
      DATA       DFHMAX / 10000.   /         !" ԳȻ
      DATA       DFEMAX / 10000.   /         !" Ȼ
      REAL       A1    , B1    , A2    , B2    , C1
      DATA       A1    , B1    , A2    , B2    , C1
     &         / 0.92  , 16.6  , 0.74  , 10.1  , 0.08   /
*
      NAMELIST  /NMVDFY/ AML0  , SHTMIN, SMTMIN,
     &                   DFMMIN, DFHMIN, DFEMIN,
     &                   DFMMAX, DFHMAX, DFEMAX,
     &                   A1    , B1    , A2    , B2    , C1
*
      LOGICAL    OFIRST
      DATA       OFIRST / .TRUE. /
      SAVE
*
*   [INTERNAL WORK] 
      INTEGER    IJ, K
      INTEGER    IFPAR, JFPAR
      REAL       ALP1, ALP2
      REAL       BET1, BET2, BET3, BET4
      REAL       GAM1, GAM2
      REAL       FAC1, FAC2, FAC3
      REAL       RIFC
*
*"         < 1.  >
*
      IF ( OFIRST ) THEN
         WRITE ( 6,* ) ' VERTICAL DIFF. COEF. - YM82 P2.1 DATE=90/11/19'
         OFIRST = .FALSE.
*
         CALL   REWNML ( IFPAR , JFPAR )
         READ   ( IFPAR, NMVDFY, END=1190 )
 1190    WRITE  ( JFPAR, NMVDFY )
*
         GAM1 = 1./3. - 2.*A1/B1
         GAM2 = B2/B1 + 6.*A1/B1
         ALP1 = 3.* A2 * GAM1
         ALP2 = 3.* A2 * ( GAM1 + GAM2 )
         BET1 = A1 * B1 * ( GAM1 - C1 )
         BET2 = A1 * ( B1 * ( GAM1 - C1 ) + 6.*A1 + 3.*A2 )
         BET3 = A2 * B1 * GAM1
         BET4 = A2 * ( B1 * ( GAM1 + GAM2 ) - 3.*A1 )
         FAC1 = BET1 / ( 2.* BET2 )
         FAC2 = BET4 / ( 2.* BET2 )
         FAC3 = 4.* BET2 * BET3 / ( 2.*BET2 )**2
         RIFC = GAM1 / ( GAM1 + GAM2 )
      ENDIF
*
*"         < 2. եåң >
*
      DO 2100 K = 1, KMAX
         DO 2110 IJ = 1, IDIM*JDIM
            RIF ( IJ,K ) = FAC1 + FAC2 * RIB( IJ,K )
     &                   - SQRT(  ( FAC1 + FAC2 * RIB( IJ,K ) )**2
     &                            - FAC3 * RIB( IJ,K )              )
 2110    CONTINUE
 2100 CONTINUE
*
*"         < 3. tilde(Sm), tilde(Sh) >
*
      DO 3100 K = 1, KMAX
         DO 3110 IJ = 1, IDIM*JDIM
            IF ( RIF ( IJ,K ) .LT. RIFC ) THEN
               SHT ( IJ,K ) =  ( ALP1 - ALP2 * RIF( IJ,K ) )
     &                        /( 1.   -        RIF( IJ,K ) )
               SMT ( IJ,K ) =  ( BET1 - BET2 * RIF( IJ,K ) )
     &                        /( BET3 - BET4 * RIF( IJ,K ) )
     &                        * SHT ( IJ,K )
               SHT ( IJ,K ) = MAX( SHT( IJ,K ), SHTMIN )
               SMT ( IJ,K ) = MAX( SMT( IJ,K ), SMTMIN )
            ELSE
               SHT ( IJ,K ) = SHTMIN
               SMT ( IJ,K ) = SMTMIN
            ENDIF
 3110    CONTINUE
 3100 CONTINUE

*
*"         < 4. Υ >
*
      DO 4200 K = 1, KMAX
         DO 4210 IJ = 1, IDIM*JDIM
            AML ( IJ,K ) = FKARM * GDZM( IJ,K )
     &                     / ( 1. + FKARM * GDZM( IJ,K ) / AML0 )
 4210    CONTINUE
 4200 CONTINUE
*
*"         < 5. Ȼ >
*
      DO 5100 K = 1, KMAX
         DO 5110 IJ = 1, IDIM*JDIM
            DFM ( IJ,K ) = AML ( IJ,K ) **2
     &                     * DVDZ( IJ,K )
     &                     * SQRT( B1* ( 1. - RIF( IJ,K ) )
     &                               * SMT( IJ,K )         )
     &                     * SMT ( IJ,K )
*
            DFH ( IJ,K ) = AML ( IJ,K ) **2
     &                     * DVDZ( IJ,K )
     &                     * SQRT( B1* ( 1. - RIF( IJ,K ) )
     &                               * SMT( IJ,K )         )
     &                     * SHT ( IJ,K )
*
            DFE ( IJ,K ) = DFH ( IJ,K )
*
 5110    CONTINUE
 5100 CONTINUE
*
      DO 5200 K = 1, KMAX
         DO 5210 IJ = 1, IDIM*JDIM
            DFM( IJ,K ) = MAX(  MIN( DFM( IJ,K ), DFMMAX ), DFMMIN  )
            DFH( IJ,K ) = MAX(  MIN( DFH( IJ,K ), DFHMAX ), DFHMIN  )
            DFE( IJ,K ) = MAX(  MIN( DFE( IJ,K ), DFEMAX ), DFEMIN  )
 5210    CONTINUE
 5200 CONTINUE
*
      DO 5300 IJ = 1, IDIM*JDIM
         DFM ( IJ,1 )      = 0.  
         DFH ( IJ,1 )      = 0.  
         DFE ( IJ,1 )      = 0.  
         DFM ( IJ,KMAX+1 ) = 0.  
         DFH ( IJ,KMAX+1 ) = 0.  
         DFE ( IJ,KMAX+1 ) = 0.  
 5300 CONTINUE
*
      RETURN
      END
