#
# uspk12.rb
#
# $Id$
#

require "numru/dcl"

include NumRu
include Math


nt = 51
nz = 21
zmin = 20.0
zmax = 50.0
tmax = 5.0
dz = (zmax-zmin)/(nz-1)
dt = tmax/(nt-1)
u = NArray.sfloat(nt, nz)

#-----------------------------------------------------------------------
for j in 0..nz-1
  z  = dz*j
  uz = exp(-0.2*z)*(z**0.5)
  for i in 0..nt-1
    t  = dt*i - 2*exp(-0.1*z)
    u[i,j] = uz*sin(3.0*t)
  end
end

#-----------------------------------------------------------------------
iws = (ARGV[0] || (puts ' WORKSTATION ID (I)  ? ;'; DCL::sgpwsn; gets)).to_i
DCL::gropn iws

DCL::grfrm

DCL::grswnd(0.0, tmax, zmin, zmax)
DCL::grsvpt(0.2, 0.8, 0.2, 0.8)
DCL::grstrn(1)
DCL::grstrf

DCL::ussttl('TIME', 'YEAR', 'HEIGHT', 'km')

DCL::usdaxs

DCL::udcntr(u)

DCL::grcls

