/*
 * Kylin-video
 *
 * Copyright (C) 2021, Tianjin KYLIN Information Technology Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * Authors: Liu Cong <liucong1@kylinos.cn>
 *
 */

#ifndef GLOBALSETUP_H
#define GLOBALSETUP_H

#include <QObject>
#include <QMap>

// 预设 pcie 设备
struct PciePredefined {
    int vid;
    int pid;
    int cid;
    int score;
    QString description;
};

// pcie 已有设备
struct PcieInfo {
    int vid;
    int pid;
    int cid;
};

class GlobalSetup : public QObject
{
    Q_OBJECT
public:
    enum HardwareDecodecType {
        DEFAULT_SOFTWARE = -1,
        AMD_VDPAU,
        JM7200_VDPAU,
        GP101_SOFTWARE,
        Sm768_SOFTWARE,
        Nvidia_VDPAU_COPY,
        OTHER_SOFTWARE
    };

    static GlobalSetup* getInstance();
    void reset();

    void clearChange();
    void flushChange();

    QPair<bool, bool> miniToTray;            // 缩小到托盘
    QPair<bool, bool> pauseWhenMini;         // 最小化时暂停
    QPair<bool, bool> keepStateWhenWakeup;   // 最小化时暂停
    QPair<bool, bool> canRunMultiple;        // 运行多个播放器

    QPair<bool, bool> fullScreenWhenPlay;    // 播放时自动全屏
    QPair<bool, bool> clearListWhenExit;     // 退出时清空列表
    QPair<bool, bool> playLastPos;           // 从上次停止的位置播放
    QPair<bool, bool> playRelationFile;      // 自动查找关联文件播放

    QPair<bool, bool> screenShotSaveToClip;  // 截图保存到剪切板（false：保存到文件）
    QPair<bool, bool> screenShotCurrentSize; // 截图为当前尺寸
    QPair<QString, QString> screenShotPath;  // 截图保存路径
    QPair<QString, QString> screenShotFormat;// 截图格式

    QPair<int, int> subFontSize;             // 字幕字体大小
    QPair<bool, bool> loadSameNameSub;       // 自动载入同名字幕
    QPair<bool, bool> loadAllSubInDir;       // 自动载入其他字幕
    QPair<QString, QString> subDir;          // 字幕载入目录
    QPair<QString, QString> subFontFamily;   // 字幕字体

    QPair<bool, bool> globalVolume;          // 全局音量
    QPair<bool, bool> standardVolume;        // 默认音量标准化
    QPair<QString, QString> audioOut;        // 声音输出选择 如果找不到的话选默认

    QPair<QString, QString> videoDecoder;    // 视频解码器
    QPair<QString, QString> videoOutput;     // 视频输出驱动
    QPair<int, int> videoDecodeThreads;      // 视频解码线程

    QPair<bool, bool> seamlessBrowsing;      // 无痕浏览
    QPair<int, int> audioChannel;            // 声道 0/1/2 | 立体/左/右

signals:

private:
    explicit GlobalSetup(QObject *parent = nullptr);
    static GlobalSetup* instance;

    QList<PciePredefined> predefinedList;
    QList<PcieInfo> pcieList;

private:
    void updatePredefinedList();
    void updatePcieList();
    HardwareDecodecType getHardwareDecodingType();
};

#endif // GLOBALSETUP_H
