/*
 * Kylin-video
 *
 * Copyright (C) 2021, Tianjin KYLIN Information Technology Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * Authors: Liu Cong <liucong1@kylinos.cn>
 *
 */

#ifndef PROGRESSBAR_H
#define PROGRESSBAR_H

#include <QWidget>

#include "slider.h"

#define DEFAULT_HEIGHT      4
#define SLIDER_SIDE_SIZE    12
#define SLIDER_MARK_HEIGHT  10
#define SLIDER_MARK_WIDTH   6

class ProgressBar : public QWidget
{
    Q_OBJECT
public:
    explicit ProgressBar(QWidget *parent = nullptr);

    void setRange(int min, int max);
    void setValue(int value);
    void setSlider(Slider *sl);
    void updateSliderPos();

    void addMark(int value, QString desc);
    void deleteMark(int value);
    void clearMark();

    int getValueBarWidth(){return m_valueBar->width();}

    void setBlackTheme();
    void setLightTheme();

signals:
    void valueChange(int);
    void sliderMoved(int);
    void mousePosChange(int);
    void mouseLeave();

private:
    Slider *m_slider;
    QWidget *m_valueBar,
            *m_widgetDock;
    int m_minValue,
        m_maxValue,
        m_currentValue,
        m_mouseValue;
    bool m_canChange;
    QList<FixedSlider*> m_markList;

    int w2v(int width);
    int v2w(int value);
    void updateMouseValue(int vb_x);

protected:
    void enterEvent(QEvent *e) override;
    void leaveEvent(QEvent *e) override;
    void resizeEvent(QResizeEvent *e) override;
    void mouseMoveEvent(QMouseEvent *e) override;
    void mousePressEvent(QMouseEvent *e) override;
    void mouseReleaseEvent(QMouseEvent *e) override;
};

#endif // PROGRESSBAR_H
