/*
 * Kylin-video
 *
 * Copyright (C) 2021, Tianjin KYLIN Information Technology Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * Authors: Liu Cong <liucong1@kylinos.cn>
 *
 */

#ifndef SUBTRACKS_H
#define SUBTRACKS_H

#include <QFileInfo>
#include <QList>

class QSettings;

class SubData
{

public:
    enum Type { None = -1, Vob = 0, Sub = 1, File = 2 };

    SubData() { _ID=-1; _lang=""; _name=""; _filename=""; _type = None; }
    ~SubData() {}

    void setType( Type t ) { _type = t; }
    void setID(int id) { _ID = id; }
    void setLang(QString lang) { _lang = lang; }
    void setName(QString name) { _name = name; }
    void setFilename(QString f) { _filename = f; }

    Type type() { return _type; }
    int ID() { return _ID; }
    QString lang() { return _lang; }
    QString name() { return _name; }
    QString filename() { return _filename; }

    QString displayName() {
        QString dname="";

        if (!_name.isEmpty()) {
            dname = _name;
            if (!_lang.isEmpty()) {
                dname += " ["+ _lang + "]";
            }
        }
        else
        if (!_lang.isEmpty()) {
            dname = _lang;
        }
        else
        if (!_filename.isEmpty()) {
            QFileInfo f(_filename);
            dname = f.fileName();
        }
        else
        dname = QString::number(_ID);

        return dname;
    }

protected:
    Type _type;
    int _ID;
    QString _lang;
    QString _name;
    QString _filename;
};

typedef QList <SubData> SubList;


class SubTracks
{
public:
    enum ParseResult { SubtitleUnchanged = 0, SubtitleAdded = 1, SubtitleChanged = 2 };

    SubTracks();
    ~SubTracks();

    void clear(){subs.clear();}
    int find(SubData::Type t, int ID);
    void add( SubData::Type t, int ID );

    bool changeLang( SubData::Type t, int ID, QString lang );
    bool changeName( SubData::Type t, int ID, QString name );
    bool changeFilename( SubData::Type t, int ID, QString filename );

    int numItems(){return subs.count();}
    bool existsItemAt(int n){return ((n >= 0) && (n < numItems()));}

    SubData itemAt(int n);
    SubData findItem( SubData::Type t, int ID );

    void save(QSettings * set, const QString & name);
    void load(QSettings * set, const QString & name);
protected:
    SubList subs;
    int index;
};

#endif // SUBTRACKS_H
