/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.mysqlx;

import com.mysql.cj.api.result.Row;
import com.mysql.cj.core.io.StatementExecuteOk;
import com.mysql.cj.core.result.BufferedRowList;
import com.mysql.cj.core.result.Field;
import com.mysql.cj.mysqlx.MysqlxError;
import com.mysql.cj.mysqlx.MysqlxSession;
import com.mysql.cj.mysqlx.io.ResultListener;
import com.mysql.cj.mysqlx.result.MysqlxRow;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;

public class ResultCreatingResultListener<RES_T>
implements ResultListener {
    private ArrayList<Field> metadata;
    private List<Row> rows = new ArrayList<Row>();
    private MysqlxSession.ResultCtor<? extends RES_T> resultCtor;
    private CompletableFuture<RES_T> future;

    public ResultCreatingResultListener(MysqlxSession.ResultCtor<? extends RES_T> resultCtor, CompletableFuture<RES_T> future) {
        this.resultCtor = resultCtor;
        this.future = future;
    }

    @Override
    public void onMetadata(ArrayList<Field> metadataFields) {
        this.metadata = metadataFields;
    }

    @Override
    public void onRow(MysqlxRow r2) {
        this.rows.add(r2);
    }

    @Override
    public void onComplete(StatementExecuteOk ok) {
        BufferedRowList rowList = new BufferedRowList(this.rows);
        Object result = ((BiFunction)this.resultCtor.apply(this.metadata)).apply(rowList, () -> ok);
        this.future.complete(result);
    }

    @Override
    public void onError(MysqlxError error) {
        this.future.completeExceptionally(error);
    }

    @Override
    public void onException(Throwable t) {
        this.future.completeExceptionally(t);
    }
}

