# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class WidgetEventTranslator(Object):
    r"""
    WidgetEventTranslator - map VTK events into widget events
    
    Superclass: Object
    
    WidgetEventTranslator maps VTK events (defined on Command) into
    widget events (defined in WidgetEvent.h). This class is typically
    used in combination with WidgetCallbackMapper, which is
    responsible for translating widget events into method callbacks, and
    then invoking the callbacks.
    
    This class can be used to define different mappings of VTK events
    into the widget events. Thus widgets can be reconfigured to use
    different event bindings.
    
    @sa
    WidgetEvent Command InteractorObserver
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkWidgetEventTranslator, obj, update, **traits)
    
    def get_translation(self, *args):
        """
        get_translation(self, VTKEvent:int) -> int
        C++: unsigned long get_translation(unsigned long VTKEvent)
        get_translation(self, VTKEvent:str) -> str
        C++: const char *get_translation(const char *VTKEvent)
        get_translation(self, VTKEvent:int, modifier:int, keyCode:str,
            repeatCount:int, keySym:str) -> int
        C++: unsigned long get_translation(unsigned long VTKEvent,
            int modifier, char keyCode, int repeatCount,
            const char *keySym)
        get_translation(self, VTKEvent:int, edata:EventData) -> int
        C++: unsigned long get_translation(unsigned long VTKEvent,
            EventData *edata)
        get_translation(self, VTKEvent:Event) -> int
        C++: unsigned long get_translation(Event *VTKEvent)
        Translate a VTK event into a widget event. If no event mapping is
        found, then the methods return WidgetEvent::NoEvent or a
        nullptr string.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetTranslation, *my_args)
        return ret

    def set_translation(self, *args):
        """
        set_translation(self, VTKEvent:int, widgetEvent:int) -> None
        C++: void set_translation(unsigned long VTKEvent,
            unsigned long widgetEvent)
        set_translation(self, VTKEvent:str, widgetEvent:str) -> None
        C++: void set_translation(const char *VTKEvent,
            const char *widgetEvent)
        set_translation(self, VTKEvent:int, modifier:int, keyCode:str,
            repeatCount:int, keySym:str, widgetEvent:int) -> None
        C++: void set_translation(unsigned long VTKEvent, int modifier,
            char keyCode, int repeatCount, const char *keySym,
            unsigned long widgetEvent)
        set_translation(self, VTKevent:Event, widgetEvent:int) -> None
        C++: void set_translation(Event *VTKevent,
            unsigned long widgetEvent)
        set_translation(self, VTKEvent:int, edata:EventData,
            widgetEvent:int) -> None
        C++: void set_translation(unsigned long VTKEvent,
            EventData *edata, unsigned long widgetEvent)
        Use these methods to create the translation from a VTK event to a
        widget event. Specifying WidgetEvent::NoEvent or an empty
        string for the (toEvent) erases the mapping for the event.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetTranslation, *my_args)
        return ret

    def add_events_to_interactor(self, *args):
        """
        add_events_to_interactor(self, __a:RenderWindowInteractor,
            __b:CallbackCommand, priority:float) -> None
        C++: void add_events_to_interactor(RenderWindowInteractor *,
            CallbackCommand *, float priority)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.AddEventsToInteractor, *my_args)
        return ret

    def add_events_to_parent(self, *args):
        """
        add_events_to_parent(self, __a:AbstractWidget,
            __b:CallbackCommand, priority:float) -> None
        C++: void add_events_to_parent(AbstractWidget *,
            CallbackCommand *, float priority)
        Add the events in the current translation table to the
        interactor.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.AddEventsToParent, *my_args)
        return ret

    def clear_events(self):
        """
        clear_events(self) -> None
        C++: void clear_events()
        Clear all events from the translator (i.e., no events will be
        translated).
        """
        ret = self._vtk_obj.ClearEvents()
        return ret
        

    def remove_translation(self, *args):
        """
        remove_translation(self, VTKEvent:int, modifier:int, keyCode:str,
            repeatCount:int, keySym:str) -> int
        C++: int remove_translation(unsigned long VTKEvent, int modifier,
            char keyCode, int repeatCount, const char *keySym)
        remove_translation(self, e:Event) -> int
        C++: int remove_translation(Event *e)
        remove_translation(self, e:EventData) -> int
        C++: int remove_translation(EventData *e)
        remove_translation(self, VTKEvent:int) -> int
        C++: int remove_translation(unsigned long VTKEvent)
        remove_translation(self, VTKEvent:str) -> int
        C++: int remove_translation(const char *VTKEvent)
        Remove translations for a binding. Returns the number of
        translations removed.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.RemoveTranslation, *my_args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(WidgetEventTranslator, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit WidgetEventTranslator properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], []),
            title='Edit WidgetEventTranslator properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit WidgetEventTranslator properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

