/*
 * Copyright (c) 2025 Dan Halbert for Adafruit Industries
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

// -----------------------------------------------------
// NOTE: THIS HEADER IS ALSO INCLUDED BY ASSEMBLER SO
//       SHOULD ONLY CONSIST OF PREPROCESSOR DIRECTIVES
// -----------------------------------------------------

// This header may be included by other board headers as "boards/adafruit_fruit_jam.h"

pico_board_cmake_set(PICO_PLATFORM, rp2350)

#ifndef _BOARDS_ADAFRUIT_FRUIT_JAM_H
#define _BOARDS_ADAFRUIT_FRUIT_JAM_H

// On some samples, the xosc can take longer to stabilize than is usual
#ifndef PICO_XOSC_STARTUP_DELAY_MULTIPLIER
#define PICO_XOSC_STARTUP_DELAY_MULTIPLIER 64
#endif

// For board detection
#define ADAFRUIT_FRUIT_JAM

// --- RP2350 VARIANT ---
// This means RP2350B.
#define PICO_RP2350A 0

// --- BOARD SPECIFIC ---
// On JST PH connector.
#define ADAFRUIT_FRUIT_JAM_A0_PIN 40

// A1-A5 and D6-D10 are on 2x16 socket header.
#define ADAFRUIT_FRUIT_JAM_A1_PIN 41
#define ADAFRUIT_FRUIT_JAM_A2_PIN 42
#define ADAFRUIT_FRUIT_JAM_A3_PIN 43
#define ADAFRUIT_FRUIT_JAM_A4_PIN 44
#define ADAFRUIT_FRUIT_JAM_A5_PIN 45

#define ADAFRUIT_FRUIT_JAM_D6_PIN 6
#define ADAFRUIT_FRUIT_JAM_D7_PIN 7
#define ADAFRUIT_FRUIT_JAM_D8_PIN 8
#define ADAFRUIT_FRUIT_JAM_D9_PIN 9
#define ADAFRUIT_FRUIT_JAM_D10_PIN 10

// Buttons
// Boot button is also known as Button 1.
#define ADAFRUIT_FRUIT_JAM_BOOT_BUTTON_PIN 0
#define ADAFRUIT_FRUIT_JAM_BUTTON1_PIN 0
#define ADAFRUIT_FRUIT_JAM_BUTTON2_PIN 4
#define ADAFRUIT_FRUIT_JAM_BUTTON3_PIN 5

// ESP32-C6 co-processor
#define ADAFRUIT_FRUIT_JAM_WIFI_SCK_PIN 30
#define ADAFRUIT_FRUIT_JAM_WIFI_MOSI_PIN 31
#define ADAFRUIT_FRUIT_JAM_WIFI_MISO_PIN 28
#define ADAFRUIT_FRUIT_JAM_WIFI_CS_PIN 46
#define ADAFRUIT_FRUIT_JAM_WIFI_ACK_PIN 3
#define ADAFRUIT_FRUIT_JAM_WIFI_RESET_PIN 22

// HSTX header
#define ADAFRUIT_FRUIT_JAM_DVI_CKN_PIN 12
#define ADAFRUIT_FRUIT_JAM_DVI_CKP_PIN 13
#define ADAFRUIT_FRUIT_JAM_DVI_D0N_PIN 14
#define ADAFRUIT_FRUIT_JAM_DVI_D0P_PIN 15
#define ADAFRUIT_FRUIT_JAM_DVI_D1N_PIN 16
#define ADAFRUIT_FRUIT_JAM_DVI_D1P_PIN 17
#define ADAFRUIT_FRUIT_JAM_DVI_D2N_PIN 18
#define ADAFRUIT_FRUIT_JAM_DVI_D2P_PIN 19

// Reset for ESP32-C6 and TLV320DAC3100
#define ADAFRUIT_FRUIT_JAM_PERIPH_RESET_PIN 22

#define ADAFRUIT_FRUIT_JAM_I2S_ESP_IRQ_PIN 23

// I2S to TLV320DAC3100
#define ADAFRUIT_FRUIT_JAM_I2S_DIN_PIN 24
#define ADAFRUIT_FRUIT_JAM_I2S_MCLK_PIN 25
#define ADAFRUIT_FRUIT_JAM_I2S_BCLK_PIN 26
#define ADAFRUIT_FRUIT_JAM_I2S_WS_PIN 27

// SD and SDIO
#define ADAFRUIT_FRUIT_JAM_SD_SCK_PIN 34
#define ADAFRUIT_FRUIT_JAM_SDIO_CLOCK_PIN 34

#define ADAFRUIT_FRUIT_JAM_SD_MOSI_PIN 35
#define ADAFRUIT_FRUIT_JAM_SDIO_COMMAND_PIN 35

#define ADAFRUIT_FRUIT_JAM_SD_MISO_PIN 36
#define ADAFRUIT_FRUIT_JAM_SDIO_DATA0_PIN 36

#define ADAFRUIT_FRUIT_JAM_SDIO_DATA1_PIN 37
#define ADAFRUIT_FRUIT_JAM_SDIO_DATA2_PIN 38

#define ADAFRUIT_FRUIT_JAM_SD_CS_PIN 39
#define ADAFRUIT_FRUIT_JAM_SDIO_DATA3_PIN 39

#define ADAFRUIT_FRUIT_JAM_SD_CARD_DETECT_PIN 33

#define ADAFRUIT_FRUIT_JAM_USB_HOST_DATA_PLUS_PIN 1
#define ADAFRUIT_FRUIT_JAM_USB_HOST_DATA_MINUS_PIN 2
#define ADAFRUIT_FRUIT_JAM_USB_HOST_5V_POWER_PIN 11

// --- UART ---
#ifndef PICO_DEFAULT_UART
#define PICO_DEFAULT_UART 1
#endif

#ifndef PICO_DEFAULT_UART_TX_PIN
#define PICO_DEFAULT_UART_TX_PIN 8
#endif

#ifndef PICO_DEFAULT_UART_RX_PIN
#define PICO_DEFAULT_UART_RX_PIN 9
#endif

// --- LED ---
#ifndef PICO_DEFAULT_LED_PIN
#define PICO_DEFAULT_LED_PIN 29
#endif

// --- RGB (NeoPixel) LED ---
#ifndef PICO_DEFAULT_WS2812_PIN
#define PICO_DEFAULT_WS2812_PIN 32
#endif

// --- I2C ---
#ifndef PICO_DEFAULT_I2C
#define PICO_DEFAULT_I2C 0
#endif
#ifndef PICO_DEFAULT_I2C_SDA_PIN
#define PICO_DEFAULT_I2C_SDA_PIN 20
#endif
#ifndef PICO_DEFAULT_I2C_SCL_PIN
#define PICO_DEFAULT_I2C_SCL_PIN 21
#endif

// --- SPI ---
// Default SPI is also the SPI for the SD card.
#ifndef PICO_DEFAULT_SPI
#define PICO_DEFAULT_SPI 0
#endif
#ifndef PICO_DEFAULT_SPI_SCK_PIN
#define PICO_DEFAULT_SPI_SCK_PIN ADAFRUIT_FRUIT_JAM_SD_SCK_PIN
#endif
#ifndef PICO_DEFAULT_SPI_TX_PIN
#define PICO_DEFAULT_SPI_TX_PIN ADAFRUIT_FRUIT_JAM_SD_MOSI_PIN
#endif
#ifndef PICO_DEFAULT_SPI_RX_PIN
#define PICO_DEFAULT_SPI_RX_PIN ADAFRUIT_FRUIT_JAM_SD_MISO_PIN
#endif

//------------- SD ------------
#ifndef PICO_SD_CARD_DETECT_PIN
#define PICO_SD_CARD_DETECT_PIN ADAFRUIT_FRUIT_JAM_SD_CARD_DETECT_PIN
#endif

#ifndef PICO_SD_CLK_PIN
#define PICO_SD_CLK_PIN ADAFRUIT_FRUIT_JAM_SDIO_CLOCK_PIN
#endif

#ifndef PICO_SD_CMD_PIN
#define PICO_SD_CMD_PIN ADAFRUIT_FRUIT_JAM_SDIO_COMMAND_PIN
#endif

#ifndef PICO_SD_DAT0_PIN
#define PICO_SD_DAT0_PIN ADAFRUIT_FRUIT_JAM_SDIO_DATA0_PIN
#endif

#ifndef PICO_SD_DAT_PIN_INCREMENT
#define PICO_SD_DAT_PIN_INCREMENT 1
#endif

#ifndef PICO_SD_DAT_PIN_COUNT
#define PICO_SD_DAT_PIN_COUNT 4
#endif

// --- I2S AUDIO (for pico-extras/src/rp2_common/pico_audio_i2s/)

#ifndef PICO_AUDIO_I2S_DATA_PIN
#define PICO_AUDIO_I2S_DATA_PIN ADAFRUIT_FRUIT_JAM_I2S_DIN_PIN
#endif

#ifndef PICO_AUDIO_I2S_CLOCK_PIN_BASE
#define PICO_AUDIO_I2S_CLOCK_PIN_BASE ADAFRUIT_FRUIT_JAM_I2S_BCLK_PIN
#endif

// --- PIO USB ---
#define PICO_DEFAULT_PIO_USB_DP_PIN ADAFRUIT_FRUIT_JAM_USB_HOST_DATA_PLUS_PIN

// --- FLASH ---
// Winbond W25Q128 (16MB) flash
#define PICO_BOOT_STAGE2_CHOOSE_W25Q080 1

#ifndef PICO_FLASH_SPI_CLKDIV
#define PICO_FLASH_SPI_CLKDIV 2
#endif

pico_board_cmake_set_default(PICO_FLASH_SIZE_BYTES, (16 * 1024 * 1024))
#ifndef PICO_FLASH_SIZE_BYTES
#define PICO_FLASH_SIZE_BYTES (16 * 1024 * 1024)
#endif

pico_board_cmake_set_default(PICO_RP2350_A2_SUPPORTED, 1)
#ifndef PICO_RP2350_A2_SUPPORTED
#define PICO_RP2350_A2_SUPPORTED 1
#endif

#endif
