use Test::More tests => 2;
use Dpkg::IPC;

my $pwd = `pwd`;
chdir 't/bin-links';
spawn( exec => ['dh_prep'], wait_child => 1 );
spawn(
    exec       => [ 'dh_auto_install', '--buildsystem=nodejs' ],
    wait_child => 1
);

$ENV{DEB_RULES_REQUIRES_ROOT} = 'no';
spawn( exec => [ 'dh_gencontrol' ], wait_child => 1 );
if ( ok( -e 'debian/foo/DEBIAN/control', 'control generated' ) ) {
    my $f;
    open $f, 'debian/foo/DEBIAN/control';
    ok( grep { /Depends: nodejs:any/ } <$f>, 'Depends nodejs:any' )
      or diag "control content\n" . `cat debian/foo/DEBIAN/control`;
}

spawn( exec => [ 'dh_auto_clean', '--buildsystem=nodejs' ], wait_child => 1 );
spawn( exec => ['dh_clean'],                                wait_child => 1 );
chdir $pwd;
