/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.nwdiag.next;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.nwdiag.next.NBar;
import net.sourceforge.plantuml.nwdiag.next.NBox;
import net.sourceforge.plantuml.nwdiag.next.NStage;
import net.sourceforge.plantuml.nwdiag.next.NTetris;

public class NPlayField {
    private final List<NStage> stages = new ArrayList<NStage>();
    private final List<NBar> bars = new ArrayList<NBar>();
    private final List<NBox> boxes = new ArrayList<NBox>();

    public NStage getStage(int num) {
        while (this.stages.size() <= num) {
            this.stages.add(new NStage(this.stages.size()));
        }
        return this.stages.get(num);
    }

    public NStage createNewStage() {
        return this.getStage(this.stages.size());
    }

    public void add(NBar bar) {
        if (bar.getParent() == null) {
            NBox single = new NBox();
            single.add(bar);
            bar.setParent(single);
            this.boxes.add(bar.getParent());
        } else if (!this.boxes.contains(bar.getParent())) {
            this.boxes.add(bar.getParent());
        }
    }

    public Map<NBar, Integer> doLayout() {
        NTetris<NBox> tetris = new NTetris<NBox>();
        for (NBox box : this.boxes) {
            tetris.add(box);
        }
        Map pos = tetris.getPositions();
        HashMap<NBar, Integer> result = new HashMap<NBar, Integer>();
        for (Map.Entry ent : pos.entrySet()) {
            NBox box = (NBox)ent.getKey();
            int boxPos = ent.getValue();
            Map<NBar, Integer> tmp = box.getPositions();
            for (Map.Entry<NBar, Integer> ent2 : tmp.entrySet()) {
                result.put(ent2.getKey(), boxPos + ent.getValue());
            }
        }
        return Collections.unmodifiableMap(result);
    }
}

