/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;

public class MinMaxMutable {
    private double maxX;
    private double maxY;
    private double minX;
    private double minY;

    public static MinMaxMutable getEmpty(boolean initToZero) {
        if (initToZero) {
            return new MinMaxMutable(0.0, 0.0, 0.0, 0.0);
        }
        return new MinMaxMutable(Double.MAX_VALUE, Double.MAX_VALUE, -1.7976931348623157E308, -1.7976931348623157E308);
    }

    public boolean isInfinity() {
        return this.minX == Double.MAX_VALUE;
    }

    public String toString() {
        return "X=" + this.minX + " " + this.maxX + " Y=" + this.minY + " " + this.maxY;
    }

    private MinMaxMutable(double minX, double minY, double maxX, double maxY) {
        if (Double.isNaN(minX)) {
            throw new IllegalArgumentException();
        }
        if (Double.isNaN(maxX)) {
            throw new IllegalArgumentException();
        }
        if (Double.isNaN(minY)) {
            throw new IllegalArgumentException();
        }
        if (Double.isNaN(maxY)) {
            throw new IllegalArgumentException();
        }
        this.minX = minX;
        this.minY = minY;
        this.maxX = maxX;
        this.maxY = maxY;
    }

    public void addPoint(double x, double y) {
        if (Double.isNaN(x)) {
            throw new IllegalArgumentException();
        }
        if (Double.isNaN(y)) {
            throw new IllegalArgumentException();
        }
        this.maxX = Math.max(x, this.maxX);
        this.maxY = Math.max(y, this.maxY);
        this.minX = Math.min(x, this.minX);
        this.minY = Math.min(y, this.minY);
    }

    public static MinMaxMutable fromMax(double maxX, double maxY) {
        if (Double.isNaN(maxX)) {
            throw new IllegalArgumentException();
        }
        if (Double.isNaN(maxY)) {
            throw new IllegalArgumentException();
        }
        MinMaxMutable result = MinMaxMutable.getEmpty(true);
        result.addPoint(maxX, maxY);
        return result;
    }

    public final double getMaxX() {
        return this.maxX;
    }

    public final double getMaxY() {
        return this.maxY;
    }

    public final double getMinX() {
        return this.minX;
    }

    public final double getMinY() {
        return this.minY;
    }

    public Dimension2D getDimension() {
        return new Dimension2DDouble(this.maxX - this.minX, this.maxY - this.minY);
    }
}

