#
# Copyright (C) 2013 eNovance SAS <licensing@enovance.com>
#
# Author: Emilien Macchi <emilien.macchi@enovance.com>
#
# Licensed under the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License. You may obtain
# a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.
#
# Unit tests for ironic::db::mysql
#

require 'spec_helper'

describe 'ironic::db::mysql' do

  let :pre_condition do
    'include mysql::server'
  end

  let :params do
    { :password => 'ironicpass' }
  end

  shared_examples_for 'ironic::db::mysql' do

    context 'with only required params' do
      it { is_expected.to contain_openstacklib__db__mysql('ironic').with(
        :user     => 'ironic',
        :password => 'ironicpass',
        :charset  => 'utf8',
        :collate  => 'utf8_general_ci',
      )}
    end

    context "overriding allowed_hosts param to array" do
      let :params do
        {
          :allowed_hosts => ['127.0.0.1','%']
        }
      end
    end

    context "overriding allowed_hosts param to string" do
      let :params do
        {
          :allowed_hosts  => '192.168.1.1'
        }
      end
    end

    context "overriding allowed_hosts param equals to host param " do
      let :params do
        {
          :allowed_hosts  => '127.0.0.1'
        }
      end
    end
  end

  on_supported_os({
    :supported_os => OSDefaults.get_supported_os
  }).each do |os,facts|
    context "on #{os}" do
      let (:facts) do
        facts.merge!(OSDefaults.get_facts())
      end

      it_behaves_like 'ironic::db::mysql'
    end
  end
end

