# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model
from msrest.exceptions import HttpOperationError


class ResponseBase(Model):
    """ResponseBase.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: Identifiable

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    """

    _validation = {
        '_type': {'required': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
    }

    _subtype_map = {
        '_type': {'Identifiable': 'Identifiable'}
    }

    def __init__(self, **kwargs):
        super(ResponseBase, self).__init__(**kwargs)
        self._type = None


class Identifiable(ResponseBase):
    """Defines the identity of a resource.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: Response

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
    }

    _subtype_map = {
        '_type': {'Response': 'Response'}
    }

    def __init__(self, **kwargs):
        super(Identifiable, self).__init__(**kwargs)
        self.id = None
        self._type = 'Identifiable'


class Response(Identifiable):
    """Defines a response. All schemas that could be returned at the root of a
    response should inherit from this.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: SearchResponse, Thing, Answer, ErrorResponse

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'web_search_url': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
    }

    _subtype_map = {
        '_type': {'SearchResponse': 'SearchResponse', 'Thing': 'Thing', 'Answer': 'Answer', 'ErrorResponse': 'ErrorResponse'}
    }

    def __init__(self, **kwargs):
        super(Response, self).__init__(**kwargs)
        self.web_search_url = None
        self._type = 'Response'


class Answer(Response):
    """Answer.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: Computation, SearchResultsAnswer

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar follow_up_queries:
    :vartype follow_up_queries:
     list[~azure.cognitiveservices.search.websearch.models.Query]
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'web_search_url': {'readonly': True},
        'follow_up_queries': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'follow_up_queries': {'key': 'followUpQueries', 'type': '[Query]'},
    }

    _subtype_map = {
        '_type': {'Computation': 'Computation', 'SearchResultsAnswer': 'SearchResultsAnswer'}
    }

    def __init__(self, **kwargs):
        super(Answer, self).__init__(**kwargs)
        self.follow_up_queries = None
        self._type = 'Answer'


class Thing(Response):
    """Thing.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: CreativeWork, Intangible

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar name: The name of the thing represented by this object.
    :vartype name: str
    :ivar url: The URL to get more information about the thing represented by
     this object.
    :vartype url: str
    :ivar image:
    :vartype image:
     ~azure.cognitiveservices.search.websearch.models.ImageObject
    :ivar description: A short description of the item.
    :vartype description: str
    :ivar bing_id: An ID that uniquely identifies this item.
    :vartype bing_id: str
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'web_search_url': {'readonly': True},
        'name': {'readonly': True},
        'url': {'readonly': True},
        'image': {'readonly': True},
        'description': {'readonly': True},
        'bing_id': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'image': {'key': 'image', 'type': 'ImageObject'},
        'description': {'key': 'description', 'type': 'str'},
        'bing_id': {'key': 'bingId', 'type': 'str'},
    }

    _subtype_map = {
        '_type': {'CreativeWork': 'CreativeWork', 'Intangible': 'Intangible'}
    }

    def __init__(self, **kwargs):
        super(Thing, self).__init__(**kwargs)
        self.name = None
        self.url = None
        self.image = None
        self.description = None
        self.bing_id = None
        self._type = 'Thing'


class CreativeWork(Thing):
    """CreativeWork.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: WebPage, MediaObject, Article

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar name: The name of the thing represented by this object.
    :vartype name: str
    :ivar url: The URL to get more information about the thing represented by
     this object.
    :vartype url: str
    :ivar image:
    :vartype image:
     ~azure.cognitiveservices.search.websearch.models.ImageObject
    :ivar description: A short description of the item.
    :vartype description: str
    :ivar bing_id: An ID that uniquely identifies this item.
    :vartype bing_id: str
    :ivar thumbnail_url: The URL to a thumbnail of the item.
    :vartype thumbnail_url: str
    :ivar provider: The source of the creative work.
    :vartype provider:
     list[~azure.cognitiveservices.search.websearch.models.Thing]
    :ivar text:
    :vartype text: str
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'web_search_url': {'readonly': True},
        'name': {'readonly': True},
        'url': {'readonly': True},
        'image': {'readonly': True},
        'description': {'readonly': True},
        'bing_id': {'readonly': True},
        'thumbnail_url': {'readonly': True},
        'provider': {'readonly': True},
        'text': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'image': {'key': 'image', 'type': 'ImageObject'},
        'description': {'key': 'description', 'type': 'str'},
        'bing_id': {'key': 'bingId', 'type': 'str'},
        'thumbnail_url': {'key': 'thumbnailUrl', 'type': 'str'},
        'provider': {'key': 'provider', 'type': '[Thing]'},
        'text': {'key': 'text', 'type': 'str'},
    }

    _subtype_map = {
        '_type': {'WebPage': 'WebPage', 'MediaObject': 'MediaObject', 'Article': 'Article'}
    }

    def __init__(self, **kwargs):
        super(CreativeWork, self).__init__(**kwargs)
        self.thumbnail_url = None
        self.provider = None
        self.text = None
        self._type = 'CreativeWork'


class Article(CreativeWork):
    """Article.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: NewsArticle

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar name: The name of the thing represented by this object.
    :vartype name: str
    :ivar url: The URL to get more information about the thing represented by
     this object.
    :vartype url: str
    :ivar image:
    :vartype image:
     ~azure.cognitiveservices.search.websearch.models.ImageObject
    :ivar description: A short description of the item.
    :vartype description: str
    :ivar bing_id: An ID that uniquely identifies this item.
    :vartype bing_id: str
    :ivar thumbnail_url: The URL to a thumbnail of the item.
    :vartype thumbnail_url: str
    :ivar provider: The source of the creative work.
    :vartype provider:
     list[~azure.cognitiveservices.search.websearch.models.Thing]
    :ivar text:
    :vartype text: str
    :ivar word_count: The number of words in the text of the Article.
    :vartype word_count: int
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'web_search_url': {'readonly': True},
        'name': {'readonly': True},
        'url': {'readonly': True},
        'image': {'readonly': True},
        'description': {'readonly': True},
        'bing_id': {'readonly': True},
        'thumbnail_url': {'readonly': True},
        'provider': {'readonly': True},
        'text': {'readonly': True},
        'word_count': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'image': {'key': 'image', 'type': 'ImageObject'},
        'description': {'key': 'description', 'type': 'str'},
        'bing_id': {'key': 'bingId', 'type': 'str'},
        'thumbnail_url': {'key': 'thumbnailUrl', 'type': 'str'},
        'provider': {'key': 'provider', 'type': '[Thing]'},
        'text': {'key': 'text', 'type': 'str'},
        'word_count': {'key': 'wordCount', 'type': 'int'},
    }

    _subtype_map = {
        '_type': {'NewsArticle': 'NewsArticle'}
    }

    def __init__(self, **kwargs):
        super(Article, self).__init__(**kwargs)
        self.word_count = None
        self._type = 'Article'


class Computation(Answer):
    """Defines an expression and its answer.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar follow_up_queries:
    :vartype follow_up_queries:
     list[~azure.cognitiveservices.search.websearch.models.Query]
    :param expression: Required. The math or conversion expression. If the
     query contains a request to convert units of measure (for example, meters
     to feet), this field contains the from units and value contains the to
     units. If the query contains a mathematical expression such as 2+2, this
     field contains the expression and value contains the answer. Note that
     mathematical expressions may be normalized. For example, if the query was
     sqrt(4^2+8^2), the normalized expression may be sqrt((4^2)+(8^2)). If the
     user's query is a math question and the textDecorations query parameter is
     set to true, the expression string may include formatting markers. For
     example, if the user's query is log(2), the normalized expression includes
     the subscript markers. For more information, see Hit Highlighting.
    :type expression: str
    :param value: Required. The expression's answer.
    :type value: str
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'web_search_url': {'readonly': True},
        'follow_up_queries': {'readonly': True},
        'expression': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'follow_up_queries': {'key': 'followUpQueries', 'type': '[Query]'},
        'expression': {'key': 'expression', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Computation, self).__init__(**kwargs)
        self.expression = kwargs.get('expression', None)
        self.value = kwargs.get('value', None)
        self._type = 'Computation'


class Error(Model):
    """Defines the error that occurred.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param code: Required. The error code that identifies the category of
     error. Possible values include: 'None', 'ServerError', 'InvalidRequest',
     'RateLimitExceeded', 'InvalidAuthorization', 'InsufficientAuthorization'.
     Default value: "None" .
    :type code: str or
     ~azure.cognitiveservices.search.websearch.models.ErrorCode
    :ivar sub_code: The error code that further helps to identify the error.
     Possible values include: 'UnexpectedError', 'ResourceError',
     'NotImplemented', 'ParameterMissing', 'ParameterInvalidValue',
     'HttpNotAllowed', 'Blocked', 'AuthorizationMissing',
     'AuthorizationRedundancy', 'AuthorizationDisabled', 'AuthorizationExpired'
    :vartype sub_code: str or
     ~azure.cognitiveservices.search.websearch.models.ErrorSubCode
    :param message: Required. A description of the error.
    :type message: str
    :ivar more_details: A description that provides additional information
     about the error.
    :vartype more_details: str
    :ivar parameter: The parameter in the request that caused the error.
    :vartype parameter: str
    :ivar value: The parameter's value in the request that was not valid.
    :vartype value: str
    """

    _validation = {
        'code': {'required': True},
        'sub_code': {'readonly': True},
        'message': {'required': True},
        'more_details': {'readonly': True},
        'parameter': {'readonly': True},
        'value': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'sub_code': {'key': 'subCode', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'more_details': {'key': 'moreDetails', 'type': 'str'},
        'parameter': {'key': 'parameter', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Error, self).__init__(**kwargs)
        self.code = kwargs.get('code', "None")
        self.sub_code = None
        self.message = kwargs.get('message', None)
        self.more_details = None
        self.parameter = None
        self.value = None


class ErrorResponse(Response):
    """The top-level response that represents a failed request.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :param errors: Required. A list of errors that describe the reasons why
     the request failed.
    :type errors: list[~azure.cognitiveservices.search.websearch.models.Error]
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'web_search_url': {'readonly': True},
        'errors': {'required': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'errors': {'key': 'errors', 'type': '[Error]'},
    }

    def __init__(self, **kwargs):
        super(ErrorResponse, self).__init__(**kwargs)
        self.errors = kwargs.get('errors', None)
        self._type = 'ErrorResponse'


class ErrorResponseException(HttpOperationError):
    """Server responsed with exception of type: 'ErrorResponse'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(ErrorResponseException, self).__init__(deserialize, response, 'ErrorResponse', *args)


class MediaObject(CreativeWork):
    """MediaObject.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ImageObject, VideoObject

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar name: The name of the thing represented by this object.
    :vartype name: str
    :ivar url: The URL to get more information about the thing represented by
     this object.
    :vartype url: str
    :ivar image:
    :vartype image:
     ~azure.cognitiveservices.search.websearch.models.ImageObject
    :ivar description: A short description of the item.
    :vartype description: str
    :ivar bing_id: An ID that uniquely identifies this item.
    :vartype bing_id: str
    :ivar thumbnail_url: The URL to a thumbnail of the item.
    :vartype thumbnail_url: str
    :ivar provider: The source of the creative work.
    :vartype provider:
     list[~azure.cognitiveservices.search.websearch.models.Thing]
    :ivar text:
    :vartype text: str
    :ivar content_url: Original URL to retrieve the source (file) for the
     media object (e.g the source URL for the image).
    :vartype content_url: str
    :ivar host_page_url: URL of the page that hosts the media object.
    :vartype host_page_url: str
    :ivar width: The width of the source media object, in pixels.
    :vartype width: int
    :ivar height: The height of the source media object, in pixels.
    :vartype height: int
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'web_search_url': {'readonly': True},
        'name': {'readonly': True},
        'url': {'readonly': True},
        'image': {'readonly': True},
        'description': {'readonly': True},
        'bing_id': {'readonly': True},
        'thumbnail_url': {'readonly': True},
        'provider': {'readonly': True},
        'text': {'readonly': True},
        'content_url': {'readonly': True},
        'host_page_url': {'readonly': True},
        'width': {'readonly': True},
        'height': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'image': {'key': 'image', 'type': 'ImageObject'},
        'description': {'key': 'description', 'type': 'str'},
        'bing_id': {'key': 'bingId', 'type': 'str'},
        'thumbnail_url': {'key': 'thumbnailUrl', 'type': 'str'},
        'provider': {'key': 'provider', 'type': '[Thing]'},
        'text': {'key': 'text', 'type': 'str'},
        'content_url': {'key': 'contentUrl', 'type': 'str'},
        'host_page_url': {'key': 'hostPageUrl', 'type': 'str'},
        'width': {'key': 'width', 'type': 'int'},
        'height': {'key': 'height', 'type': 'int'},
    }

    _subtype_map = {
        '_type': {'ImageObject': 'ImageObject', 'VideoObject': 'VideoObject'}
    }

    def __init__(self, **kwargs):
        super(MediaObject, self).__init__(**kwargs)
        self.content_url = None
        self.host_page_url = None
        self.width = None
        self.height = None
        self._type = 'MediaObject'


class ImageObject(MediaObject):
    """Defines an image.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar name: The name of the thing represented by this object.
    :vartype name: str
    :ivar url: The URL to get more information about the thing represented by
     this object.
    :vartype url: str
    :ivar image:
    :vartype image:
     ~azure.cognitiveservices.search.websearch.models.ImageObject
    :ivar description: A short description of the item.
    :vartype description: str
    :ivar bing_id: An ID that uniquely identifies this item.
    :vartype bing_id: str
    :ivar thumbnail_url: The URL to a thumbnail of the item.
    :vartype thumbnail_url: str
    :ivar provider: The source of the creative work.
    :vartype provider:
     list[~azure.cognitiveservices.search.websearch.models.Thing]
    :ivar text:
    :vartype text: str
    :ivar content_url: Original URL to retrieve the source (file) for the
     media object (e.g the source URL for the image).
    :vartype content_url: str
    :ivar host_page_url: URL of the page that hosts the media object.
    :vartype host_page_url: str
    :ivar width: The width of the source media object, in pixels.
    :vartype width: int
    :ivar height: The height of the source media object, in pixels.
    :vartype height: int
    :ivar thumbnail: The URL to a thumbnail of the image
    :vartype thumbnail:
     ~azure.cognitiveservices.search.websearch.models.ImageObject
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'web_search_url': {'readonly': True},
        'name': {'readonly': True},
        'url': {'readonly': True},
        'image': {'readonly': True},
        'description': {'readonly': True},
        'bing_id': {'readonly': True},
        'thumbnail_url': {'readonly': True},
        'provider': {'readonly': True},
        'text': {'readonly': True},
        'content_url': {'readonly': True},
        'host_page_url': {'readonly': True},
        'width': {'readonly': True},
        'height': {'readonly': True},
        'thumbnail': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'image': {'key': 'image', 'type': 'ImageObject'},
        'description': {'key': 'description', 'type': 'str'},
        'bing_id': {'key': 'bingId', 'type': 'str'},
        'thumbnail_url': {'key': 'thumbnailUrl', 'type': 'str'},
        'provider': {'key': 'provider', 'type': '[Thing]'},
        'text': {'key': 'text', 'type': 'str'},
        'content_url': {'key': 'contentUrl', 'type': 'str'},
        'host_page_url': {'key': 'hostPageUrl', 'type': 'str'},
        'width': {'key': 'width', 'type': 'int'},
        'height': {'key': 'height', 'type': 'int'},
        'thumbnail': {'key': 'thumbnail', 'type': 'ImageObject'},
    }

    def __init__(self, **kwargs):
        super(ImageObject, self).__init__(**kwargs)
        self.thumbnail = None
        self._type = 'ImageObject'


class SearchResultsAnswer(Answer):
    """SearchResultsAnswer.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: WebWebAnswer, Images, News,
    RelatedSearchesRelatedSearchAnswer, SpellSuggestions, TimeZone, Videos,
    Places

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar follow_up_queries:
    :vartype follow_up_queries:
     list[~azure.cognitiveservices.search.websearch.models.Query]
    :ivar query_context:
    :vartype query_context:
     ~azure.cognitiveservices.search.websearch.models.QueryContext
    :ivar total_estimated_matches: The estimated number of webpages that are
     relevant to the query. Use this number along with the count and offset
     query parameters to page the results.
    :vartype total_estimated_matches: long
    :ivar is_family_friendly:
    :vartype is_family_friendly: bool
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'web_search_url': {'readonly': True},
        'follow_up_queries': {'readonly': True},
        'query_context': {'readonly': True},
        'total_estimated_matches': {'readonly': True},
        'is_family_friendly': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'follow_up_queries': {'key': 'followUpQueries', 'type': '[Query]'},
        'query_context': {'key': 'queryContext', 'type': 'QueryContext'},
        'total_estimated_matches': {'key': 'totalEstimatedMatches', 'type': 'long'},
        'is_family_friendly': {'key': 'isFamilyFriendly', 'type': 'bool'},
    }

    _subtype_map = {
        '_type': {'Web/WebAnswer': 'WebWebAnswer', 'Images': 'Images', 'News': 'News', 'RelatedSearches/RelatedSearchAnswer': 'RelatedSearchesRelatedSearchAnswer', 'SpellSuggestions': 'SpellSuggestions', 'TimeZone': 'TimeZone', 'Videos': 'Videos', 'Places': 'Places'}
    }

    def __init__(self, **kwargs):
        super(SearchResultsAnswer, self).__init__(**kwargs)
        self.query_context = None
        self.total_estimated_matches = None
        self.is_family_friendly = None
        self._type = 'SearchResultsAnswer'


class Images(SearchResultsAnswer):
    """Defines an image answer.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar follow_up_queries:
    :vartype follow_up_queries:
     list[~azure.cognitiveservices.search.websearch.models.Query]
    :ivar query_context:
    :vartype query_context:
     ~azure.cognitiveservices.search.websearch.models.QueryContext
    :ivar total_estimated_matches: The estimated number of webpages that are
     relevant to the query. Use this number along with the count and offset
     query parameters to page the results.
    :vartype total_estimated_matches: long
    :ivar is_family_friendly:
    :vartype is_family_friendly: bool
    :ivar next_offset:
    :vartype next_offset: int
    :param value: Required. A list of image objects that are relevant to the
     query. If there are no results, the List is empty.
    :type value:
     list[~azure.cognitiveservices.search.websearch.models.ImageObject]
    :ivar query_expansions:
    :vartype query_expansions:
     list[~azure.cognitiveservices.search.websearch.models.Query]
    :ivar similar_terms:
    :vartype similar_terms:
     list[~azure.cognitiveservices.search.websearch.models.Query]
    :ivar related_searches:
    :vartype related_searches:
     list[~azure.cognitiveservices.search.websearch.models.Query]
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'web_search_url': {'readonly': True},
        'follow_up_queries': {'readonly': True},
        'query_context': {'readonly': True},
        'total_estimated_matches': {'readonly': True},
        'is_family_friendly': {'readonly': True},
        'next_offset': {'readonly': True},
        'value': {'required': True},
        'query_expansions': {'readonly': True},
        'similar_terms': {'readonly': True},
        'related_searches': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'follow_up_queries': {'key': 'followUpQueries', 'type': '[Query]'},
        'query_context': {'key': 'queryContext', 'type': 'QueryContext'},
        'total_estimated_matches': {'key': 'totalEstimatedMatches', 'type': 'long'},
        'is_family_friendly': {'key': 'isFamilyFriendly', 'type': 'bool'},
        'next_offset': {'key': 'nextOffset', 'type': 'int'},
        'value': {'key': 'value', 'type': '[ImageObject]'},
        'query_expansions': {'key': 'queryExpansions', 'type': '[Query]'},
        'similar_terms': {'key': 'similarTerms', 'type': '[Query]'},
        'related_searches': {'key': 'relatedSearches', 'type': '[Query]'},
    }

    def __init__(self, **kwargs):
        super(Images, self).__init__(**kwargs)
        self.next_offset = None
        self.value = kwargs.get('value', None)
        self.query_expansions = None
        self.similar_terms = None
        self.related_searches = None
        self._type = 'Images'


class Intangible(Thing):
    """Intangible.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: StructuredValue

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar name: The name of the thing represented by this object.
    :vartype name: str
    :ivar url: The URL to get more information about the thing represented by
     this object.
    :vartype url: str
    :ivar image:
    :vartype image:
     ~azure.cognitiveservices.search.websearch.models.ImageObject
    :ivar description: A short description of the item.
    :vartype description: str
    :ivar bing_id: An ID that uniquely identifies this item.
    :vartype bing_id: str
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'web_search_url': {'readonly': True},
        'name': {'readonly': True},
        'url': {'readonly': True},
        'image': {'readonly': True},
        'description': {'readonly': True},
        'bing_id': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'image': {'key': 'image', 'type': 'ImageObject'},
        'description': {'key': 'description', 'type': 'str'},
        'bing_id': {'key': 'bingId', 'type': 'str'},
    }

    _subtype_map = {
        '_type': {'StructuredValue': 'StructuredValue'}
    }

    def __init__(self, **kwargs):
        super(Intangible, self).__init__(**kwargs)
        self._type = 'Intangible'


class News(SearchResultsAnswer):
    """Defines a news answer.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar follow_up_queries:
    :vartype follow_up_queries:
     list[~azure.cognitiveservices.search.websearch.models.Query]
    :ivar query_context:
    :vartype query_context:
     ~azure.cognitiveservices.search.websearch.models.QueryContext
    :ivar total_estimated_matches: The estimated number of webpages that are
     relevant to the query. Use this number along with the count and offset
     query parameters to page the results.
    :vartype total_estimated_matches: long
    :ivar is_family_friendly:
    :vartype is_family_friendly: bool
    :param value: Required. An array of NewsArticle objects that contain
     information about news articles that are relevant to the query. If there
     are no results to return for the request, the array is empty.
    :type value:
     list[~azure.cognitiveservices.search.websearch.models.NewsArticle]
    :ivar location:
    :vartype location: str
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'web_search_url': {'readonly': True},
        'follow_up_queries': {'readonly': True},
        'query_context': {'readonly': True},
        'total_estimated_matches': {'readonly': True},
        'is_family_friendly': {'readonly': True},
        'value': {'required': True},
        'location': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'follow_up_queries': {'key': 'followUpQueries', 'type': '[Query]'},
        'query_context': {'key': 'queryContext', 'type': 'QueryContext'},
        'total_estimated_matches': {'key': 'totalEstimatedMatches', 'type': 'long'},
        'is_family_friendly': {'key': 'isFamilyFriendly', 'type': 'bool'},
        'value': {'key': 'value', 'type': '[NewsArticle]'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(News, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.location = None
        self._type = 'News'


class NewsArticle(Article):
    """Defines a news article.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar name: The name of the thing represented by this object.
    :vartype name: str
    :ivar url: The URL to get more information about the thing represented by
     this object.
    :vartype url: str
    :ivar image:
    :vartype image:
     ~azure.cognitiveservices.search.websearch.models.ImageObject
    :ivar description: A short description of the item.
    :vartype description: str
    :ivar bing_id: An ID that uniquely identifies this item.
    :vartype bing_id: str
    :ivar thumbnail_url: The URL to a thumbnail of the item.
    :vartype thumbnail_url: str
    :ivar provider: The source of the creative work.
    :vartype provider:
     list[~azure.cognitiveservices.search.websearch.models.Thing]
    :ivar text:
    :vartype text: str
    :ivar word_count: The number of words in the text of the Article.
    :vartype word_count: int
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'web_search_url': {'readonly': True},
        'name': {'readonly': True},
        'url': {'readonly': True},
        'image': {'readonly': True},
        'description': {'readonly': True},
        'bing_id': {'readonly': True},
        'thumbnail_url': {'readonly': True},
        'provider': {'readonly': True},
        'text': {'readonly': True},
        'word_count': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'image': {'key': 'image', 'type': 'ImageObject'},
        'description': {'key': 'description', 'type': 'str'},
        'bing_id': {'key': 'bingId', 'type': 'str'},
        'thumbnail_url': {'key': 'thumbnailUrl', 'type': 'str'},
        'provider': {'key': 'provider', 'type': '[Thing]'},
        'text': {'key': 'text', 'type': 'str'},
        'word_count': {'key': 'wordCount', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(NewsArticle, self).__init__(**kwargs)
        self._type = 'NewsArticle'


class Places(SearchResultsAnswer):
    """Defines a local entity answer.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar follow_up_queries:
    :vartype follow_up_queries:
     list[~azure.cognitiveservices.search.websearch.models.Query]
    :ivar query_context:
    :vartype query_context:
     ~azure.cognitiveservices.search.websearch.models.QueryContext
    :ivar total_estimated_matches: The estimated number of webpages that are
     relevant to the query. Use this number along with the count and offset
     query parameters to page the results.
    :vartype total_estimated_matches: long
    :ivar is_family_friendly:
    :vartype is_family_friendly: bool
    :param value: Required. A list of local entities, such as restaurants or
     hotels.
    :type value: list[~azure.cognitiveservices.search.websearch.models.Thing]
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'web_search_url': {'readonly': True},
        'follow_up_queries': {'readonly': True},
        'query_context': {'readonly': True},
        'total_estimated_matches': {'readonly': True},
        'is_family_friendly': {'readonly': True},
        'value': {'required': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'follow_up_queries': {'key': 'followUpQueries', 'type': '[Query]'},
        'query_context': {'key': 'queryContext', 'type': 'QueryContext'},
        'total_estimated_matches': {'key': 'totalEstimatedMatches', 'type': 'long'},
        'is_family_friendly': {'key': 'isFamilyFriendly', 'type': 'bool'},
        'value': {'key': 'value', 'type': '[Thing]'},
    }

    def __init__(self, **kwargs):
        super(Places, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self._type = 'Places'


class Query(Model):
    """Defines a search query.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param text: Required. The query string. Use this string as the query term
     in a new search request.
    :type text: str
    :ivar display_text: The display version of the query term. This version of
     the query term may contain special characters that highlight the search
     term found in the query string. The string contains the highlighting
     characters only if the query enabled hit highlighting
    :vartype display_text: str
    :ivar web_search_url: The URL that takes the user to the Bing search
     results page for the query.Only related search results include this field.
    :vartype web_search_url: str
    :ivar search_link:
    :vartype search_link: str
    :ivar thumbnail:
    :vartype thumbnail:
     ~azure.cognitiveservices.search.websearch.models.ImageObject
    """

    _validation = {
        'text': {'required': True},
        'display_text': {'readonly': True},
        'web_search_url': {'readonly': True},
        'search_link': {'readonly': True},
        'thumbnail': {'readonly': True},
    }

    _attribute_map = {
        'text': {'key': 'text', 'type': 'str'},
        'display_text': {'key': 'displayText', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'search_link': {'key': 'searchLink', 'type': 'str'},
        'thumbnail': {'key': 'thumbnail', 'type': 'ImageObject'},
    }

    def __init__(self, **kwargs):
        super(Query, self).__init__(**kwargs)
        self.text = kwargs.get('text', None)
        self.display_text = None
        self.web_search_url = None
        self.search_link = None
        self.thumbnail = None


class QueryContext(Model):
    """Defines the query context that Bing used for the request.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param original_query: Required. The query string as specified in the
     request.
    :type original_query: str
    :ivar altered_query: The query string used by Bing to perform the query.
     Bing uses the altered query string if the original query string contained
     spelling mistakes. For example, if the query string is "saling downwind",
     the altered query string will be "sailing downwind". This field is
     included only if the original query string contains a spelling mistake.
    :vartype altered_query: str
    :ivar alteration_override_query: The query string to use to force Bing to
     use the original string. For example, if the query string is "saling
     downwind", the override query string will be "+saling downwind". Remember
     to encode the query string which results in "%2Bsaling+downwind". This
     field is included only if the original query string contains a spelling
     mistake.
    :vartype alteration_override_query: str
    :ivar adult_intent: A Boolean value that indicates whether the specified
     query has adult intent. The value is true if the query has adult intent;
     otherwise, false.
    :vartype adult_intent: bool
    :ivar ask_user_for_location: A Boolean value that indicates whether Bing
     requires the user's location to provide accurate results. If you specified
     the user's location by using the X-MSEdge-ClientIP and X-Search-Location
     headers, you can ignore this field. For location aware queries, such as
     "today's weather" or "restaurants near me" that need the user's location
     to provide accurate results, this field is set to true. For location aware
     queries that include the location (for example, "Seattle weather"), this
     field is set to false. This field is also set to false for queries that
     are not location aware, such as "best sellers".
    :vartype ask_user_for_location: bool
    :ivar is_transactional:
    :vartype is_transactional: bool
    """

    _validation = {
        'original_query': {'required': True},
        'altered_query': {'readonly': True},
        'alteration_override_query': {'readonly': True},
        'adult_intent': {'readonly': True},
        'ask_user_for_location': {'readonly': True},
        'is_transactional': {'readonly': True},
    }

    _attribute_map = {
        'original_query': {'key': 'originalQuery', 'type': 'str'},
        'altered_query': {'key': 'alteredQuery', 'type': 'str'},
        'alteration_override_query': {'key': 'alterationOverrideQuery', 'type': 'str'},
        'adult_intent': {'key': 'adultIntent', 'type': 'bool'},
        'ask_user_for_location': {'key': 'askUserForLocation', 'type': 'bool'},
        'is_transactional': {'key': 'isTransactional', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(QueryContext, self).__init__(**kwargs)
        self.original_query = kwargs.get('original_query', None)
        self.altered_query = None
        self.alteration_override_query = None
        self.adult_intent = None
        self.ask_user_for_location = None
        self.is_transactional = None


class RankingRankingGroup(Model):
    """Defines a search results group, such as mainline.

    All required parameters must be populated in order to send to Azure.

    :param items: Required. A list of search result items to display in the
     group.
    :type items:
     list[~azure.cognitiveservices.search.websearch.models.RankingRankingItem]
    """

    _validation = {
        'items': {'required': True},
    }

    _attribute_map = {
        'items': {'key': 'items', 'type': '[RankingRankingItem]'},
    }

    def __init__(self, **kwargs):
        super(RankingRankingGroup, self).__init__(**kwargs)
        self.items = kwargs.get('items', None)


class RankingRankingItem(Model):
    """Defines a search result item to display.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param answer_type: Required. The answer that contains the item to
     display. Use the type to find the answer in the SearchResponse object. The
     type is the name of a SearchResponse field. Possible values include:
     'WebPages', 'Images', 'SpellSuggestions', 'News', 'RelatedSearches',
     'Videos', 'Computation', 'TimeZone'. Default value: "WebPages" .
    :type answer_type: str or
     ~azure.cognitiveservices.search.websearch.models.AnswerType
    :ivar result_index: A zero-based index of the item in the answer.If the
     item does not include this field, display all items in the answer. For
     example, display all news articles in the News answer.
    :vartype result_index: int
    :ivar value: The ID that identifies either an answer to display or an item
     of an answer to display. If the ID identifies an answer, display all items
     of the answer.
    :vartype value:
     ~azure.cognitiveservices.search.websearch.models.Identifiable
    :ivar html_index:
    :vartype html_index: int
    :ivar textual_index:
    :vartype textual_index: int
    :ivar screenshot_index:
    :vartype screenshot_index: int
    """

    _validation = {
        'answer_type': {'required': True},
        'result_index': {'readonly': True},
        'value': {'readonly': True},
        'html_index': {'readonly': True},
        'textual_index': {'readonly': True},
        'screenshot_index': {'readonly': True},
    }

    _attribute_map = {
        'answer_type': {'key': 'answerType', 'type': 'str'},
        'result_index': {'key': 'resultIndex', 'type': 'int'},
        'value': {'key': 'value', 'type': 'Identifiable'},
        'html_index': {'key': 'htmlIndex', 'type': 'int'},
        'textual_index': {'key': 'textualIndex', 'type': 'int'},
        'screenshot_index': {'key': 'screenshotIndex', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(RankingRankingItem, self).__init__(**kwargs)
        self.answer_type = kwargs.get('answer_type', "WebPages")
        self.result_index = None
        self.value = None
        self.html_index = None
        self.textual_index = None
        self.screenshot_index = None


class RankingRankingResponse(Model):
    """Defines where on the search results page content should be placed and in
    what order.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar pole: The search results that should be afforded the most visible
     treatment (for example, displayed above the mainline and sidebar).
    :vartype pole:
     ~azure.cognitiveservices.search.websearch.models.RankingRankingGroup
    :ivar mainline: The search results to display in the mainline.
    :vartype mainline:
     ~azure.cognitiveservices.search.websearch.models.RankingRankingGroup
    :ivar sidebar: The search results to display in the sidebar.
    :vartype sidebar:
     ~azure.cognitiveservices.search.websearch.models.RankingRankingGroup
    """

    _validation = {
        'pole': {'readonly': True},
        'mainline': {'readonly': True},
        'sidebar': {'readonly': True},
    }

    _attribute_map = {
        'pole': {'key': 'pole', 'type': 'RankingRankingGroup'},
        'mainline': {'key': 'mainline', 'type': 'RankingRankingGroup'},
        'sidebar': {'key': 'sidebar', 'type': 'RankingRankingGroup'},
    }

    def __init__(self, **kwargs):
        super(RankingRankingResponse, self).__init__(**kwargs)
        self.pole = None
        self.mainline = None
        self.sidebar = None


class RelatedSearchesRelatedSearchAnswer(SearchResultsAnswer):
    """Defines a list of related queries made by others.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar follow_up_queries:
    :vartype follow_up_queries:
     list[~azure.cognitiveservices.search.websearch.models.Query]
    :ivar query_context:
    :vartype query_context:
     ~azure.cognitiveservices.search.websearch.models.QueryContext
    :ivar total_estimated_matches: The estimated number of webpages that are
     relevant to the query. Use this number along with the count and offset
     query parameters to page the results.
    :vartype total_estimated_matches: long
    :ivar is_family_friendly:
    :vartype is_family_friendly: bool
    :param value: Required. A list of related queries that were made by
     others.
    :type value: list[~azure.cognitiveservices.search.websearch.models.Query]
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'web_search_url': {'readonly': True},
        'follow_up_queries': {'readonly': True},
        'query_context': {'readonly': True},
        'total_estimated_matches': {'readonly': True},
        'is_family_friendly': {'readonly': True},
        'value': {'required': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'follow_up_queries': {'key': 'followUpQueries', 'type': '[Query]'},
        'query_context': {'key': 'queryContext', 'type': 'QueryContext'},
        'total_estimated_matches': {'key': 'totalEstimatedMatches', 'type': 'long'},
        'is_family_friendly': {'key': 'isFamilyFriendly', 'type': 'bool'},
        'value': {'key': 'value', 'type': '[Query]'},
    }

    def __init__(self, **kwargs):
        super(RelatedSearchesRelatedSearchAnswer, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self._type = 'RelatedSearches/RelatedSearchAnswer'


class SearchResponse(Response):
    """Defines the top-level object that the response includes when the request
    succeeds.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar query_context: An object that contains the query string that Bing
     used for the request. This object contains the query string as entered by
     the user. It may also contain an altered query string that Bing used for
     the query if the query string contained a spelling mistake.
    :vartype query_context:
     ~azure.cognitiveservices.search.websearch.models.QueryContext
    :ivar web_pages: A list of webpages that are relevant to the search query.
    :vartype web_pages:
     ~azure.cognitiveservices.search.websearch.models.WebWebAnswer
    :ivar images: A list of images that are relevant to the search query.
    :vartype images: ~azure.cognitiveservices.search.websearch.models.Images
    :ivar news: A list of news articles that are relevant to the search query.
    :vartype news: ~azure.cognitiveservices.search.websearch.models.News
    :ivar related_searches: A list of related queries made by others.
    :vartype related_searches:
     ~azure.cognitiveservices.search.websearch.models.RelatedSearchesRelatedSearchAnswer
    :ivar spell_suggestions: The query string that likely represents the
     user's intent.
    :vartype spell_suggestions:
     ~azure.cognitiveservices.search.websearch.models.SpellSuggestions
    :ivar time_zone: The date and time of one or more geographic locations.
    :vartype time_zone:
     ~azure.cognitiveservices.search.websearch.models.TimeZone
    :ivar videos: A list of videos that are relevant to the search query.
    :vartype videos: ~azure.cognitiveservices.search.websearch.models.Videos
    :ivar computation: The answer to a math expression or units conversion
     expression.
    :vartype computation:
     ~azure.cognitiveservices.search.websearch.models.Computation
    :ivar ranking_response: The order that Bing suggests that you display the
     search results in.
    :vartype ranking_response:
     ~azure.cognitiveservices.search.websearch.models.RankingRankingResponse
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'web_search_url': {'readonly': True},
        'query_context': {'readonly': True},
        'web_pages': {'readonly': True},
        'images': {'readonly': True},
        'news': {'readonly': True},
        'related_searches': {'readonly': True},
        'spell_suggestions': {'readonly': True},
        'time_zone': {'readonly': True},
        'videos': {'readonly': True},
        'computation': {'readonly': True},
        'ranking_response': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'query_context': {'key': 'queryContext', 'type': 'QueryContext'},
        'web_pages': {'key': 'webPages', 'type': 'WebWebAnswer'},
        'images': {'key': 'images', 'type': 'Images'},
        'news': {'key': 'news', 'type': 'News'},
        'related_searches': {'key': 'relatedSearches', 'type': 'RelatedSearchesRelatedSearchAnswer'},
        'spell_suggestions': {'key': 'spellSuggestions', 'type': 'SpellSuggestions'},
        'time_zone': {'key': 'timeZone', 'type': 'TimeZone'},
        'videos': {'key': 'videos', 'type': 'Videos'},
        'computation': {'key': 'computation', 'type': 'Computation'},
        'ranking_response': {'key': 'rankingResponse', 'type': 'RankingRankingResponse'},
    }

    def __init__(self, **kwargs):
        super(SearchResponse, self).__init__(**kwargs)
        self.query_context = None
        self.web_pages = None
        self.images = None
        self.news = None
        self.related_searches = None
        self.spell_suggestions = None
        self.time_zone = None
        self.videos = None
        self.computation = None
        self.ranking_response = None
        self._type = 'SearchResponse'


class SpellSuggestions(SearchResultsAnswer):
    """Defines a suggested query string that likely represents the user's intent.
    The search results include this response if Bing determines that the user
    may have intended to search for something different. For example, if the
    user searches for alon brown, Bing may determine that the user likely
    intended to search for Alton Brown instead (based on past searches by
    others of Alon Brown).

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar follow_up_queries:
    :vartype follow_up_queries:
     list[~azure.cognitiveservices.search.websearch.models.Query]
    :ivar query_context:
    :vartype query_context:
     ~azure.cognitiveservices.search.websearch.models.QueryContext
    :ivar total_estimated_matches: The estimated number of webpages that are
     relevant to the query. Use this number along with the count and offset
     query parameters to page the results.
    :vartype total_estimated_matches: long
    :ivar is_family_friendly:
    :vartype is_family_friendly: bool
    :param value: Required. A list of suggested query strings that may
     represent the user's intention. The list contains only one Query object.
    :type value: list[~azure.cognitiveservices.search.websearch.models.Query]
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'web_search_url': {'readonly': True},
        'follow_up_queries': {'readonly': True},
        'query_context': {'readonly': True},
        'total_estimated_matches': {'readonly': True},
        'is_family_friendly': {'readonly': True},
        'value': {'required': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'follow_up_queries': {'key': 'followUpQueries', 'type': '[Query]'},
        'query_context': {'key': 'queryContext', 'type': 'QueryContext'},
        'total_estimated_matches': {'key': 'totalEstimatedMatches', 'type': 'long'},
        'is_family_friendly': {'key': 'isFamilyFriendly', 'type': 'bool'},
        'value': {'key': 'value', 'type': '[Query]'},
    }

    def __init__(self, **kwargs):
        super(SpellSuggestions, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self._type = 'SpellSuggestions'


class StructuredValue(Intangible):
    """StructuredValue.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar name: The name of the thing represented by this object.
    :vartype name: str
    :ivar url: The URL to get more information about the thing represented by
     this object.
    :vartype url: str
    :ivar image:
    :vartype image:
     ~azure.cognitiveservices.search.websearch.models.ImageObject
    :ivar description: A short description of the item.
    :vartype description: str
    :ivar bing_id: An ID that uniquely identifies this item.
    :vartype bing_id: str
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'web_search_url': {'readonly': True},
        'name': {'readonly': True},
        'url': {'readonly': True},
        'image': {'readonly': True},
        'description': {'readonly': True},
        'bing_id': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'image': {'key': 'image', 'type': 'ImageObject'},
        'description': {'key': 'description', 'type': 'str'},
        'bing_id': {'key': 'bingId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(StructuredValue, self).__init__(**kwargs)
        self._type = 'StructuredValue'


class TimeZone(SearchResultsAnswer):
    """Defines the data and time of one or more geographic locations.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar follow_up_queries:
    :vartype follow_up_queries:
     list[~azure.cognitiveservices.search.websearch.models.Query]
    :ivar query_context:
    :vartype query_context:
     ~azure.cognitiveservices.search.websearch.models.QueryContext
    :ivar total_estimated_matches: The estimated number of webpages that are
     relevant to the query. Use this number along with the count and offset
     query parameters to page the results.
    :vartype total_estimated_matches: long
    :ivar is_family_friendly:
    :vartype is_family_friendly: bool
    :param primary_city_time: Required. The data and time, in UTC, of the
     geographic location specified in the query. If the query specified a
     specific geographic location (for example, a city), this object contains
     the name of the geographic location and the current date and time of the
     location, in UTC. If the query specified a general geographic location,
     such as a state or country, this object contains the date and time of the
     primary city or state found in the specified state or country. If the
     location contains additional time zones, the otherCityTimes field contains
     the data and time of cities or states located in the other time zones.
    :type primary_city_time:
     ~azure.cognitiveservices.search.websearch.models.TimeZoneTimeZoneInformation
    :ivar other_city_times: A list of dates and times of nearby time zones.
    :vartype other_city_times:
     list[~azure.cognitiveservices.search.websearch.models.TimeZoneTimeZoneInformation]
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'web_search_url': {'readonly': True},
        'follow_up_queries': {'readonly': True},
        'query_context': {'readonly': True},
        'total_estimated_matches': {'readonly': True},
        'is_family_friendly': {'readonly': True},
        'primary_city_time': {'required': True},
        'other_city_times': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'follow_up_queries': {'key': 'followUpQueries', 'type': '[Query]'},
        'query_context': {'key': 'queryContext', 'type': 'QueryContext'},
        'total_estimated_matches': {'key': 'totalEstimatedMatches', 'type': 'long'},
        'is_family_friendly': {'key': 'isFamilyFriendly', 'type': 'bool'},
        'primary_city_time': {'key': 'primaryCityTime', 'type': 'TimeZoneTimeZoneInformation'},
        'other_city_times': {'key': 'otherCityTimes', 'type': '[TimeZoneTimeZoneInformation]'},
    }

    def __init__(self, **kwargs):
        super(TimeZone, self).__init__(**kwargs)
        self.primary_city_time = kwargs.get('primary_city_time', None)
        self.other_city_times = None
        self._type = 'TimeZone'


class TimeZoneTimeZoneInformation(Model):
    """Defines a date and time for a geographical location.

    All required parameters must be populated in order to send to Azure.

    :param location: Required. The name of the geographical location.For
     example, County; City; City, State; City, State, Country; or Time Zone.
    :type location: str
    :param time: Required. The data and time specified in the form,
     YYYY-MM-DDThh;mm:ss.ssssssZ.
    :type time: str
    :param utc_offset: Required. The offset from UTC. For example, UTC-7.
    :type utc_offset: str
    """

    _validation = {
        'location': {'required': True},
        'time': {'required': True},
        'utc_offset': {'required': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'time': {'key': 'time', 'type': 'str'},
        'utc_offset': {'key': 'utcOffset', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(TimeZoneTimeZoneInformation, self).__init__(**kwargs)
        self.location = kwargs.get('location', None)
        self.time = kwargs.get('time', None)
        self.utc_offset = kwargs.get('utc_offset', None)


class VideoObject(MediaObject):
    """Defines a video object that is relevant to the query.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar name: The name of the thing represented by this object.
    :vartype name: str
    :ivar url: The URL to get more information about the thing represented by
     this object.
    :vartype url: str
    :ivar image:
    :vartype image:
     ~azure.cognitiveservices.search.websearch.models.ImageObject
    :ivar description: A short description of the item.
    :vartype description: str
    :ivar bing_id: An ID that uniquely identifies this item.
    :vartype bing_id: str
    :ivar thumbnail_url: The URL to a thumbnail of the item.
    :vartype thumbnail_url: str
    :ivar provider: The source of the creative work.
    :vartype provider:
     list[~azure.cognitiveservices.search.websearch.models.Thing]
    :ivar text:
    :vartype text: str
    :ivar content_url: Original URL to retrieve the source (file) for the
     media object (e.g the source URL for the image).
    :vartype content_url: str
    :ivar host_page_url: URL of the page that hosts the media object.
    :vartype host_page_url: str
    :ivar width: The width of the source media object, in pixels.
    :vartype width: int
    :ivar height: The height of the source media object, in pixels.
    :vartype height: int
    :ivar motion_thumbnail_url:
    :vartype motion_thumbnail_url: str
    :ivar motion_thumbnail_id:
    :vartype motion_thumbnail_id: str
    :ivar embed_html:
    :vartype embed_html: str
    :ivar allow_https_embed:
    :vartype allow_https_embed: bool
    :ivar view_count:
    :vartype view_count: int
    :ivar thumbnail:
    :vartype thumbnail:
     ~azure.cognitiveservices.search.websearch.models.ImageObject
    :ivar video_id:
    :vartype video_id: str
    :ivar allow_mobile_embed:
    :vartype allow_mobile_embed: bool
    :ivar is_superfresh:
    :vartype is_superfresh: bool
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'web_search_url': {'readonly': True},
        'name': {'readonly': True},
        'url': {'readonly': True},
        'image': {'readonly': True},
        'description': {'readonly': True},
        'bing_id': {'readonly': True},
        'thumbnail_url': {'readonly': True},
        'provider': {'readonly': True},
        'text': {'readonly': True},
        'content_url': {'readonly': True},
        'host_page_url': {'readonly': True},
        'width': {'readonly': True},
        'height': {'readonly': True},
        'motion_thumbnail_url': {'readonly': True},
        'motion_thumbnail_id': {'readonly': True},
        'embed_html': {'readonly': True},
        'allow_https_embed': {'readonly': True},
        'view_count': {'readonly': True},
        'thumbnail': {'readonly': True},
        'video_id': {'readonly': True},
        'allow_mobile_embed': {'readonly': True},
        'is_superfresh': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'image': {'key': 'image', 'type': 'ImageObject'},
        'description': {'key': 'description', 'type': 'str'},
        'bing_id': {'key': 'bingId', 'type': 'str'},
        'thumbnail_url': {'key': 'thumbnailUrl', 'type': 'str'},
        'provider': {'key': 'provider', 'type': '[Thing]'},
        'text': {'key': 'text', 'type': 'str'},
        'content_url': {'key': 'contentUrl', 'type': 'str'},
        'host_page_url': {'key': 'hostPageUrl', 'type': 'str'},
        'width': {'key': 'width', 'type': 'int'},
        'height': {'key': 'height', 'type': 'int'},
        'motion_thumbnail_url': {'key': 'motionThumbnailUrl', 'type': 'str'},
        'motion_thumbnail_id': {'key': 'motionThumbnailId', 'type': 'str'},
        'embed_html': {'key': 'embedHtml', 'type': 'str'},
        'allow_https_embed': {'key': 'allowHttpsEmbed', 'type': 'bool'},
        'view_count': {'key': 'viewCount', 'type': 'int'},
        'thumbnail': {'key': 'thumbnail', 'type': 'ImageObject'},
        'video_id': {'key': 'videoId', 'type': 'str'},
        'allow_mobile_embed': {'key': 'allowMobileEmbed', 'type': 'bool'},
        'is_superfresh': {'key': 'isSuperfresh', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(VideoObject, self).__init__(**kwargs)
        self.motion_thumbnail_url = None
        self.motion_thumbnail_id = None
        self.embed_html = None
        self.allow_https_embed = None
        self.view_count = None
        self.thumbnail = None
        self.video_id = None
        self.allow_mobile_embed = None
        self.is_superfresh = None
        self._type = 'VideoObject'


class Videos(SearchResultsAnswer):
    """Defines a video answer.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar follow_up_queries:
    :vartype follow_up_queries:
     list[~azure.cognitiveservices.search.websearch.models.Query]
    :ivar query_context:
    :vartype query_context:
     ~azure.cognitiveservices.search.websearch.models.QueryContext
    :ivar total_estimated_matches: The estimated number of webpages that are
     relevant to the query. Use this number along with the count and offset
     query parameters to page the results.
    :vartype total_estimated_matches: long
    :ivar is_family_friendly:
    :vartype is_family_friendly: bool
    :param value: Required. A list of video objects that are relevant to the
     query.
    :type value:
     list[~azure.cognitiveservices.search.websearch.models.VideoObject]
    :ivar next_offset:
    :vartype next_offset: int
    :ivar query_expansions:
    :vartype query_expansions:
     list[~azure.cognitiveservices.search.websearch.models.Query]
    :ivar related_searches:
    :vartype related_searches:
     list[~azure.cognitiveservices.search.websearch.models.Query]
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'web_search_url': {'readonly': True},
        'follow_up_queries': {'readonly': True},
        'query_context': {'readonly': True},
        'total_estimated_matches': {'readonly': True},
        'is_family_friendly': {'readonly': True},
        'value': {'required': True},
        'next_offset': {'readonly': True},
        'query_expansions': {'readonly': True},
        'related_searches': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'follow_up_queries': {'key': 'followUpQueries', 'type': '[Query]'},
        'query_context': {'key': 'queryContext', 'type': 'QueryContext'},
        'total_estimated_matches': {'key': 'totalEstimatedMatches', 'type': 'long'},
        'is_family_friendly': {'key': 'isFamilyFriendly', 'type': 'bool'},
        'value': {'key': 'value', 'type': '[VideoObject]'},
        'next_offset': {'key': 'nextOffset', 'type': 'int'},
        'query_expansions': {'key': 'queryExpansions', 'type': '[Query]'},
        'related_searches': {'key': 'relatedSearches', 'type': '[Query]'},
    }

    def __init__(self, **kwargs):
        super(Videos, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_offset = None
        self.query_expansions = None
        self.related_searches = None
        self._type = 'Videos'


class WebMetaTag(Model):
    """Defines a webpage's metadata.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: The metadata.
    :vartype name: str
    :ivar content: The name of the metadata.
    :vartype content: str
    """

    _validation = {
        'name': {'readonly': True},
        'content': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'content': {'key': 'content', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(WebMetaTag, self).__init__(**kwargs)
        self.name = None
        self.content = None


class WebPage(CreativeWork):
    """Defines a webpage that is relevant to the query.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar name: The name of the thing represented by this object.
    :vartype name: str
    :ivar url: The URL to get more information about the thing represented by
     this object.
    :vartype url: str
    :ivar image:
    :vartype image:
     ~azure.cognitiveservices.search.websearch.models.ImageObject
    :ivar description: A short description of the item.
    :vartype description: str
    :ivar bing_id: An ID that uniquely identifies this item.
    :vartype bing_id: str
    :ivar thumbnail_url: The URL to a thumbnail of the item.
    :vartype thumbnail_url: str
    :ivar provider: The source of the creative work.
    :vartype provider:
     list[~azure.cognitiveservices.search.websearch.models.Thing]
    :ivar text:
    :vartype text: str
    :ivar display_url: The display URL of the webpage. The URL is meant for
     display purposes only and is not well formed.
    :vartype display_url: str
    :ivar snippet: A snippet of text from the webpage that describes its
     contents.
    :vartype snippet: str
    :ivar deep_links: A list of links to related content that Bing found in
     the website that contains this webpage. The Webpage object in this context
     includes only the name, url, urlPingSuffix, and snippet fields.
    :vartype deep_links:
     list[~azure.cognitiveservices.search.websearch.models.WebPage]
    :ivar date_last_crawled: The last time that Bing crawled the webpage. The
     date is in the form, YYYY-MM-DDTHH:MM:SS. For example,
     2015-04-13T05:23:39.
    :vartype date_last_crawled: str
    :ivar search_tags: A list of search tags that the webpage owner specified
     on the webpage. The API returns only indexed search tags. The name field
     of the MetaTag object contains the indexed search tag. Search tags begin
     with search.* (for example, search.assetId). The content field contains
     the tag's value.
    :vartype search_tags:
     list[~azure.cognitiveservices.search.websearch.models.WebMetaTag]
    :ivar primary_image_of_page:
    :vartype primary_image_of_page:
     ~azure.cognitiveservices.search.websearch.models.ImageObject
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'web_search_url': {'readonly': True},
        'name': {'readonly': True},
        'url': {'readonly': True},
        'image': {'readonly': True},
        'description': {'readonly': True},
        'bing_id': {'readonly': True},
        'thumbnail_url': {'readonly': True},
        'provider': {'readonly': True},
        'text': {'readonly': True},
        'display_url': {'readonly': True},
        'snippet': {'readonly': True},
        'deep_links': {'readonly': True},
        'date_last_crawled': {'readonly': True},
        'search_tags': {'readonly': True},
        'primary_image_of_page': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'image': {'key': 'image', 'type': 'ImageObject'},
        'description': {'key': 'description', 'type': 'str'},
        'bing_id': {'key': 'bingId', 'type': 'str'},
        'thumbnail_url': {'key': 'thumbnailUrl', 'type': 'str'},
        'provider': {'key': 'provider', 'type': '[Thing]'},
        'text': {'key': 'text', 'type': 'str'},
        'display_url': {'key': 'displayUrl', 'type': 'str'},
        'snippet': {'key': 'snippet', 'type': 'str'},
        'deep_links': {'key': 'deepLinks', 'type': '[WebPage]'},
        'date_last_crawled': {'key': 'dateLastCrawled', 'type': 'str'},
        'search_tags': {'key': 'searchTags', 'type': '[WebMetaTag]'},
        'primary_image_of_page': {'key': 'primaryImageOfPage', 'type': 'ImageObject'},
    }

    def __init__(self, **kwargs):
        super(WebPage, self).__init__(**kwargs)
        self.display_url = None
        self.snippet = None
        self.deep_links = None
        self.date_last_crawled = None
        self.search_tags = None
        self.primary_image_of_page = None
        self._type = 'WebPage'


class WebWebAnswer(SearchResultsAnswer):
    """Defines a list of relevant webpage links.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar follow_up_queries:
    :vartype follow_up_queries:
     list[~azure.cognitiveservices.search.websearch.models.Query]
    :ivar query_context:
    :vartype query_context:
     ~azure.cognitiveservices.search.websearch.models.QueryContext
    :ivar total_estimated_matches: The estimated number of webpages that are
     relevant to the query. Use this number along with the count and offset
     query parameters to page the results.
    :vartype total_estimated_matches: long
    :ivar is_family_friendly:
    :vartype is_family_friendly: bool
    :param value: Required. A list of webpages that are relevant to the query.
    :type value:
     list[~azure.cognitiveservices.search.websearch.models.WebPage]
    :ivar some_results_removed: A Boolean value that indicates whether the
     response excluded some results from the answer. If Bing excluded some
     results, the value is true.
    :vartype some_results_removed: bool
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'web_search_url': {'readonly': True},
        'follow_up_queries': {'readonly': True},
        'query_context': {'readonly': True},
        'total_estimated_matches': {'readonly': True},
        'is_family_friendly': {'readonly': True},
        'value': {'required': True},
        'some_results_removed': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'follow_up_queries': {'key': 'followUpQueries', 'type': '[Query]'},
        'query_context': {'key': 'queryContext', 'type': 'QueryContext'},
        'total_estimated_matches': {'key': 'totalEstimatedMatches', 'type': 'long'},
        'is_family_friendly': {'key': 'isFamilyFriendly', 'type': 'bool'},
        'value': {'key': 'value', 'type': '[WebPage]'},
        'some_results_removed': {'key': 'someResultsRemoved', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(WebWebAnswer, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.some_results_removed = None
        self._type = 'Web/WebAnswer'


class WebWebGrouping(Model):
    """WebWebGrouping.

    All required parameters must be populated in order to send to Azure.

    :param web_pages: Required.
    :type web_pages:
     list[~azure.cognitiveservices.search.websearch.models.WebPage]
    :param _type: Required. Constant filled by server.
    :type _type: str
    """

    _validation = {
        'web_pages': {'required': True},
        '_type': {'required': True},
    }

    _attribute_map = {
        'web_pages': {'key': 'webPages', 'type': '[WebPage]'},
        '_type': {'key': '_type', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(WebWebGrouping, self).__init__(**kwargs)
        self.web_pages = kwargs.get('web_pages', None)
        self._type = None
