"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright 2014 The Chromium Authors. All rights reserved.
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.

Logging information for Android "checkin" events (automatic, periodic
requests made by Android devices to the server).
"""

import builtins
import google.protobuf.descriptor
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _DeviceType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _DeviceTypeEnumTypeWrapper(
    google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_DeviceType.ValueType],
    builtins.type,
):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    DEVICE_ANDROID_OS: _DeviceType.ValueType  # 1
    """Android Device"""
    DEVICE_IOS_OS: _DeviceType.ValueType  # 2
    """Apple IOS device"""
    DEVICE_CHROME_BROWSER: _DeviceType.ValueType  # 3
    """Chrome browser - Not Chrome OS.  No hardware records."""
    DEVICE_CHROME_OS: _DeviceType.ValueType  # 4
    """Chrome OS"""

class DeviceType(_DeviceType, metaclass=_DeviceTypeEnumTypeWrapper):
    """enum values correspond to the type of device.
    Used in the AndroidCheckinProto and Device proto.
    """

DEVICE_ANDROID_OS: DeviceType.ValueType  # 1
"""Android Device"""
DEVICE_IOS_OS: DeviceType.ValueType  # 2
"""Apple IOS device"""
DEVICE_CHROME_BROWSER: DeviceType.ValueType  # 3
"""Chrome browser - Not Chrome OS.  No hardware records."""
DEVICE_CHROME_OS: DeviceType.ValueType  # 4
"""Chrome OS"""
global___DeviceType = DeviceType

@typing_extensions.final
class ChromeBuildProto(google.protobuf.message.Message):
    """Build characteristics unique to the Chrome browser, and Chrome OS"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Platform:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _PlatformEnumTypeWrapper(
        google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[
            ChromeBuildProto._Platform.ValueType
        ],
        builtins.type,
    ):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        PLATFORM_WIN: ChromeBuildProto._Platform.ValueType  # 1
        PLATFORM_MAC: ChromeBuildProto._Platform.ValueType  # 2
        PLATFORM_LINUX: ChromeBuildProto._Platform.ValueType  # 3
        PLATFORM_CROS: ChromeBuildProto._Platform.ValueType  # 4
        PLATFORM_IOS: ChromeBuildProto._Platform.ValueType  # 5
        PLATFORM_ANDROID: ChromeBuildProto._Platform.ValueType  # 6
        """Just a placeholder. Likely don't need it due to the presence of the
        Android GCM on phone/tablet devices.
        """

    class Platform(_Platform, metaclass=_PlatformEnumTypeWrapper): ...
    PLATFORM_WIN: ChromeBuildProto.Platform.ValueType  # 1
    PLATFORM_MAC: ChromeBuildProto.Platform.ValueType  # 2
    PLATFORM_LINUX: ChromeBuildProto.Platform.ValueType  # 3
    PLATFORM_CROS: ChromeBuildProto.Platform.ValueType  # 4
    PLATFORM_IOS: ChromeBuildProto.Platform.ValueType  # 5
    PLATFORM_ANDROID: ChromeBuildProto.Platform.ValueType  # 6
    """Just a placeholder. Likely don't need it due to the presence of the
    Android GCM on phone/tablet devices.
    """

    class _Channel:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ChannelEnumTypeWrapper(
        google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[
            ChromeBuildProto._Channel.ValueType
        ],
        builtins.type,
    ):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        CHANNEL_STABLE: ChromeBuildProto._Channel.ValueType  # 1
        CHANNEL_BETA: ChromeBuildProto._Channel.ValueType  # 2
        CHANNEL_DEV: ChromeBuildProto._Channel.ValueType  # 3
        CHANNEL_CANARY: ChromeBuildProto._Channel.ValueType  # 4
        CHANNEL_UNKNOWN: ChromeBuildProto._Channel.ValueType  # 5
        """for tip of tree or custom builds"""

    class Channel(_Channel, metaclass=_ChannelEnumTypeWrapper): ...
    CHANNEL_STABLE: ChromeBuildProto.Channel.ValueType  # 1
    CHANNEL_BETA: ChromeBuildProto.Channel.ValueType  # 2
    CHANNEL_DEV: ChromeBuildProto.Channel.ValueType  # 3
    CHANNEL_CANARY: ChromeBuildProto.Channel.ValueType  # 4
    CHANNEL_UNKNOWN: ChromeBuildProto.Channel.ValueType  # 5
    """for tip of tree or custom builds"""

    PLATFORM_FIELD_NUMBER: builtins.int
    CHROME_VERSION_FIELD_NUMBER: builtins.int
    CHANNEL_FIELD_NUMBER: builtins.int
    platform: global___ChromeBuildProto.Platform.ValueType
    """The platform of the device."""
    chrome_version: builtins.str
    """The Chrome instance's version."""
    channel: global___ChromeBuildProto.Channel.ValueType
    """The Channel (build type) of Chrome."""
    def __init__(
        self,
        *,
        platform: global___ChromeBuildProto.Platform.ValueType | None = ...,
        chrome_version: builtins.str | None = ...,
        channel: global___ChromeBuildProto.Channel.ValueType | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "channel",
            b"channel",
            "chrome_version",
            b"chrome_version",
            "platform",
            b"platform",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "channel",
            b"channel",
            "chrome_version",
            b"chrome_version",
            "platform",
            b"platform",
        ],
    ) -> None: ...

global___ChromeBuildProto = ChromeBuildProto

@typing_extensions.final
class AndroidCheckinProto(google.protobuf.message.Message):
    """Information sent by the device in a "checkin" request."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LAST_CHECKIN_MSEC_FIELD_NUMBER: builtins.int
    CELL_OPERATOR_FIELD_NUMBER: builtins.int
    SIM_OPERATOR_FIELD_NUMBER: builtins.int
    ROAMING_FIELD_NUMBER: builtins.int
    USER_NUMBER_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    CHROME_BUILD_FIELD_NUMBER: builtins.int
    last_checkin_msec: builtins.int
    """Miliseconds since the Unix epoch of the device's last successful checkin."""
    cell_operator: builtins.str
    """The current MCC+MNC of the mobile device's current cell."""
    sim_operator: builtins.str
    """The MCC+MNC of the SIM card (different from operator if the
    device is roaming, for instance).
    """
    roaming: builtins.str
    """The device's current roaming state (reported starting in eclair builds).
    Currently one of "{,not}mobile-{,not}roaming", if it is present at all.
    """
    user_number: builtins.int
    """For devices supporting multiple user profiles (which may be
    supported starting in jellybean), the ordinal number of the
    profile that is checking in.  This is 0 for the primary profile
    (which can't be changed without wiping the device), and 1,2,3,...
    for additional profiles (which can be added and deleted freely).
    """
    type: global___DeviceType.ValueType
    """Class of device.  Indicates the type of build proto
    (IosBuildProto/ChromeBuildProto/AndroidBuildProto)
    That is included in this proto
    """
    @property
    def chrome_build(self) -> global___ChromeBuildProto:
        """For devices running MCS on Chrome, build-specific characteristics
        of the browser.  There are no hardware aspects (except for ChromeOS).
        This will only be populated for Chrome builds/ChromeOS devices
        """
    def __init__(
        self,
        *,
        last_checkin_msec: builtins.int | None = ...,
        cell_operator: builtins.str | None = ...,
        sim_operator: builtins.str | None = ...,
        roaming: builtins.str | None = ...,
        user_number: builtins.int | None = ...,
        type: global___DeviceType.ValueType | None = ...,
        chrome_build: global___ChromeBuildProto | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "cell_operator",
            b"cell_operator",
            "chrome_build",
            b"chrome_build",
            "last_checkin_msec",
            b"last_checkin_msec",
            "roaming",
            b"roaming",
            "sim_operator",
            b"sim_operator",
            "type",
            b"type",
            "user_number",
            b"user_number",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "cell_operator",
            b"cell_operator",
            "chrome_build",
            b"chrome_build",
            "last_checkin_msec",
            b"last_checkin_msec",
            "roaming",
            b"roaming",
            "sim_operator",
            b"sim_operator",
            "type",
            b"type",
            "user_number",
            b"user_number",
        ],
    ) -> None: ...

global___AndroidCheckinProto = AndroidCheckinProto
