# colorlistGenerate.py
#
# The code in this file is part of Pyxplot
# <http://www.pyxplot.org.uk>
#
# Copyright (C) 2006-2012 Dominic Ford <coders@pyxplot.org.uk>
#               2008-2012 Ross Church
#
# $Id: colorlistGenerate.py 1261 2012-07-11 21:38:05Z dcf21 $
#
# Pyxplot is free software; you can redistribute it and/or modify it under the
# terms of the GNU General Public License as published by the Free Software
# Foundation; either version 2 of the License, or (at your option) any later
# version.
#
# You should have received a copy of the GNU General Public License along with
# Pyxplot; if not, write to the Free Software Foundation, Inc., 51 Franklin
# Street, Fifth Floor, Boston, MA  02110-1301, USA

# ----------------------------------------------------------------------------

color_list={
"greenYellow": [0.15, 0, 0.69, 0],
"yellow": [0, 0, 1, 0],
"goldenRod": [0, 0.10, 0.84, 0],
"dandelion": [0, 0.29, 0.84, 0],
"apricot": [0, 0.32, 0.52, 0],
"peach": [0, 0.50, 0.70, 0],
"melon": [0, 0.46, 0.50, 0],
"yellowOrange": [0, 0.42, 1, 0],
"orange": [0, 0.61, 0.87, 0],
"burntOrange": [0, 0.51, 1, 0],
"bitterSweet": [0, 0.75, 1, 0.24],
"redOrange": [0, 0.77, 0.87, 0],
"mahogany": [0, 0.85, 0.87, 0.35],
"maroon": [0, 0.87, 0.68, 0.32],
"brickRed": [0, 0.89, 0.94, 0.28],
"red": [0, 1, 1, 0],
"orangeRed": [0, 1, 0.50, 0],
"rubineRed": [0, 1, 0.13, 0],
"wildStrawberry": [0, 0.96, 0.39, 0],
"salmon": [0, 0.53, 0.38, 0],
"carnationPink": [0, 0.63, 0, 0],
"magenta": [0, 1, 0, 0],
"violetRed": [0, 0.81, 0, 0],
"rhodamine": [0, 0.82, 0, 0],
"mulberry": [0.34, 0.90, 0, 0.02],
"redViolet": [0.07, 0.90, 0, 0.34],
"fuchsia": [0.47, 0.91, 0, 0.08],
"lavender": [0, 0.48, 0, 0],
"thistle": [0.12, 0.59, 0, 0],
"orchid": [0.32, 0.64, 0, 0],
"darkOrchid": [0.40, 0.80, 0.20, 0],
"purple": [0.45, 0.86, 0, 0],
"plum": [0.50, 1, 0, 0],
"violet": [0.79, 0.88, 0, 0],
"royalPurple": [0.75, 0.90, 0, 0],
"blueViolet": [0.86, 0.91, 0, 0.04],
"periwinkle": [0.57, 0.55, 0, 0],
"cadetBlue": [0.62, 0.57, 0.23, 0],
"cornflowerBlue": [0.65, 0.13, 0, 0],
"midnightBlue": [0.98, 0.13, 0, 0.43],
"navyBlue": [0.94, 0.54, 0, 0],
"royalBlue": [1, 0.50, 0, 0],
"blue": [1, 1, 0, 0],
"cerulean": [0.94, 0.11, 0, 0],
"cyan": [1, 0, 0, 0],
"processBlue": [0.96, 0, 0, 0],
"skyBlue": [0.62, 0, 0.12, 0],
"turquoise": [0.85, 0, 0.20, 0],
"tealBlue": [0.86, 0, 0.34, 0.02],
"aquamarine": [0.82, 0, 0.30, 0],
"blueGreen": [0.85, 0, 0.33, 0],
"emerald": [1, 0, 0.50, 0],
"jungleGreen": [0.99, 0, 0.52, 0],
"seaGreen": [0.69, 0, 0.50, 0],
"green": [1, 0, 1, 0],
"forestGreen": [0.91, 0, 0.88, 0.12],
"pineGreen": [0.92, 0, 0.59, 0.25],
"limeGreen": [0.50, 0, 1, 0],
"yellowGreen": [0.44, 0, 0.74, 0],
"springGreen": [0.26, 0, 0.76, 0],
"oliveGreen": [0.64, 0, 0.95, 0.40],
"rawSienna": [0, 0.72, 1, 0.45],
"sepia": [0, 0.83, 1, 0.70],
"brown": [0, 0.81, 1, 0.60],
"tan": [0.14, 0.42, 0.56, 0],
"gray": [0, 0, 0, 0.50],
"grey": [0, 0, 0, 0.50],
"black": [0, 0, 0, 1],
"white": [0, 0, 0, 0],
"invisible": [-1, -1, -1, -1],
"null": [-1, -1, -1, -1],
"transparent": [-1, -1, -1, -1],
}

for greylevel in range(0,101):
 color_list["grey%02d"%greylevel] = [0, 0, 0, float(100-greylevel)/100]
 color_list["gray%02d"%greylevel] = [0, 0, 0, float(100-greylevel)/100]

color_names = color_list.keys()
color_names.sort()

# Write ppl_colors.h
output = open("src/settings/epsColors.h","w")
output.write("""// This file auto-generated by colorsGenerate.py

#ifndef _EPSCOLORS_H
#define _EPSCOLORS_H 1

""")

for i in range(len(color_names)): output.write("#define COLOR_%s %d\n"%(color_names[i].upper() , i+20000))
output.write("\n#ifndef _EPSCOLORS_C\n")
output.write("extern char  *SW_COLOR_STR[];\n")
output.write("extern int    SW_COLOR_DCL[];\n")
output.write("extern int    SW_COLOR_INT[];\n\n")
output.write("extern double SW_COLOR_CMYK_C[];\n")
output.write("extern double SW_COLOR_CMYK_M[];\n")
output.write("extern double SW_COLOR_CMYK_Y[];\n")
output.write("extern double SW_COLOR_CMYK_K[];\n")
output.write("#endif\n\n#endif\n")
output.close()

# Write ppl_colors.c
output = open("src/settings/epsColors.c","w")
output.write("""// This file auto-generated by colorsGenerate.py

#define _EPSCOLORS_C 1

#include "epsColors.h"

char  *SW_COLOR_STR[] = {""")
for i in range(len(color_names)): output.write(""" "%s" , """%color_names[i])
output.write("};\nint    SW_COLOR_DCL[] = {")
for i in range(len(color_names)): output.write(""" %d , """%len(color_names[i]))
output.write("};\nint    SW_COLOR_INT[] = {")
for i in range(len(color_names)): output.write(""" COLOR_%s , """%(color_names[i].upper()))
output.write("-1};\ndouble SW_COLOR_CMYK_C[] = {")
for i in range(len(color_names)): output.write(""" %f , """%(color_list[color_names[i]][0]))
output.write("};\ndouble SW_COLOR_CMYK_M[] = {")
for i in range(len(color_names)): output.write(""" %f , """%(color_list[color_names[i]][1]))
output.write("};\ndouble SW_COLOR_CMYK_Y[] = {")
for i in range(len(color_names)): output.write(""" %f , """%(color_list[color_names[i]][2]))
output.write("};\ndouble SW_COLOR_CMYK_K[] = {")
for i in range(len(color_names)): output.write(""" %f , """%(color_list[color_names[i]][3]))
output.write("};\n")

output.close()

