/*
 * Copyright (C) 2000-2023 the xine project
 *
 * This file is part of xine, a unix video player.
 *
 * xine is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * xine is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110, USA
 *
 */
#ifndef HAVE_XITK_FONT_H
#define HAVE_XITK_FONT_H

#define DEFAULT_FONT_FMT      "-*-helvetica-medium-r-*-*-%d-*-*-*-*-*-*-*"
#define DEFAULT_FONT_10       "-*-helvetica-medium-r-*-*-11-*-*-*-*-*-*-*"
#define DEFAULT_FONT_12       "-*-helvetica-medium-r-*-*-12-*-*-*-*-*-*-*"
#define DEFAULT_FONT_14       "-*-helvetica-medium-r-*-*-14-*-*-*-*-*-*-*"
#define DEFAULT_BOLD_FONT_FMT "-*-helvetica-bold-r-*-*-%d-*-*-*-*-*-*-*"
#define DEFAULT_BOLD_FONT_10  "-*-helvetica-bold-r-*-*-11-*-*-*-*-*-*-*"
#define DEFAULT_BOLD_FONT_12  "-*-helvetica-bold-r-*-*-12-*-*-*-*-*-*-*"
#define DEFAULT_BOLD_FONT_14  "-*-helvetica-bold-r-*-*-14-*-*-*-*-*-*-*"

/* no typo, want (18...20) -> 12. */
#define XITK_DEFAULT_FONT_NAME(_buf,_fmt,_widget_height) snprintf (_buf, sizeof (_buf), _fmt, _widget_height / 3 * 2)

typedef struct xitk_be_font_s xitk_font_t;

/** Font manipulations. */
typedef struct {
  int lbearing, rbearing, width, ascent, descent;
} xitk_font_textent_t;
xitk_font_t *xitk_font_load_font (xitk_t *xitk, const char *font);
void xitk_font_unload_font (xitk_font_t *xtfs);
void xitk_image_draw_string (xitk_image_t *img, xitk_font_t *xtfs, int x, int y, const char *text, size_t nbytes, int color);
/** nbytes == -1 for strlen (text) (next 3), return nbytes (next 1). */
size_t xitk_font_text_extent (xitk_font_t *xtfs, const char *text, int nbytes, xitk_font_textent_t *ext);
int xitk_font_text_width (xitk_font_t *xtfs, const char *text, int nbytes);
int xitk_font_text_height (xitk_font_t *xtfs, const char *text, int nbytes);

#endif /* HAVE_XITK_DEFAULT_FONT_H */
