#
# scpkt6.rb
#
# $Id$
#

require "numru/dcl"

include NumRu
include Math


nx = 37
ny = 37
xmin = 0
xmax = 360
ymin = 0
ymax = 180

alon = NArray.sfloat( nx)
alat = NArray.sfloat( ny)
p = NArray.sfloat( nx, ny)
xp = NArray.sfloat( 3)
yp = NArray.sfloat( 3)
zp = NArray.sfloat( 3)

#-- data ---
alon.indgen(xmin, (xmax-xmin)/(nx-1).to_f)
alat.indgen(ymin, (ymax-ymin)/(ny-1).to_f)
p.fill!(1.0)

#-- graph ---
iws = (ARGV[0] || (puts ' WORKSTATION ID (I)  ? ;'; DCL::sgpwsn; gets)).to_i

DCL::sgopn iws

DCL::sgfrm
DCL::sglset('LDEG', true)

#---------------- 3-D ------------------
DCL::scsorg(1.0, 0.0, 0.0, 0.0)
DCL::scstrn(3)
DCL::scstrf

DCL::scseye(-5.0, -3.0, 2.0)
DCL::scsobj(0.0, 0.0, 0.0)
DCL::scsprj

DCL::scspli(1)
DCL::scstnp(2999, 4999)

(ny-2).downto(0) do |j|
  (nx-2).downto(0) do |i|
    xp[0] = alon[i]
    yp[0] = alat[j]
    zp[0] = p[i,j]
    xp[1] = alon[i]
    yp[1] = alat[j+1]
    zp[1] = p[i,j+1]
    xp[2] = alon[i+1]
    yp[2] = alat[j+1]
    zp[2] = p[i+1,j+1]

    DCL::sctnu(zp, yp, xp)
    DCL::scplu(zp, yp, xp)

    xp[0] = alon[i+1]
    yp[0] = alat[j+1]
    zp[0] = p[i+1,j+1]
    xp[1] = alon[i+1]
    yp[1] = alat[j]
    zp[1] = p[i+1,j]
    xp[2] = alon[i]
    yp[2] = alat[j]
    zp[2] = p[i,j]

    DCL::sctnu(zp, yp, xp)
    DCL::scplu(zp, yp, xp)
  end
end

DCL::sgcls

