!----------------------------------------------------------------------
! Copyright (c) 2008-2013 SPMODEL Development Group. All rights reserved.
!----------------------------------------------------------------------
!ɽ  w_base_mpi_module
!
!  spml/w_base_mpi_module ⥸塼ϵ̾Ǥ 2 ήαư
!  ĴȡѤڥȥˡ MPI ˤäƿͷ׻뤿 
!  ⥸塼 w_mpi_module β⥸塼Ǥ, ڥȥ׻
!  Ū Fortran90 ؿ󶡤. 
!
!   ISPACK  SPPACK  SNPACK  Fortran77 ֥롼ƤǤ. 
!  ڥȥǡӳʻǡγǼˡѴξܤ׻ˡ
!  ĤƤ ISPACK/SNPACK,SPPACK Υޥ˥奢򻲾Ȥ줿.
!
!
!  2008/05/26  ݹ  w_base_module  MPI 
!      2010/01/07  ʿ  RDoc ѤΥɥȽ, 
!      2012/03/30  ݹ  Ƚ
!      2013/02/12  ݹ  w_StreamPotential2VectorMPI,  
!                            w_Vector2VorDivMPI Ƴ
!      2013/02/15  ݹ  w_VectorCosLat2VorDivMPI Ƴ
!      2013/02/23  ݹ  w_base_mpi_Finalize Ƴ
!
module w_base_mpi_module
  !
  ! w_base_mpi_module
  !
  !  spml/w_base_mpi_module ⥸塼ϵ̾Ǥ 2 ήαư
  !  ĴȡѤڥȥˡ MPI ˤäƿͷ׻뤿 
  !  ⥸塼 w_mpi_module β⥸塼Ǥ, ڥȥˡ
  !  Ūʤ Fortran90 ؿ󶡤. 
  !
  !   ISPACK  SPPACK  SNPACK  Fortran77 ֥롼ƤǤ. 
  !  ڥȥǡӳʻǡγǼˡѴξܤ׻ˡ
  !  ĤƤ ISPACK/SNPACK,SPPACK Υޥ˥奢򻲾Ȥ줿.
  !
  use dc_message
  use w_base_module, only : im, jm, nm, x_Lon

  implicit none

  integer               :: it(6)            ! Ѵ(ʬʻ)
  real(8), allocatable  :: t(:)             ! Ѵ(ʬʻ)
  integer, allocatable  :: ip(:)            ! Ѵ(ʬʻ)
  real(8), allocatable  :: p(:), r(:)       ! Ѵ(ʬʻ)
  integer, allocatable  :: ia(:)            ! Ѵ(ʬʻ)
  real(8), allocatable  :: a(:)             ! Ѵ(ʬʻ)
  real(8), allocatable  :: y(:)             ! Ѵ(ʬʻ)

  integer               :: jc               ! ʬѿ
  real(8), allocatable  :: yy(:,:)          ! Ѵ
  
  real(8), allocatable  :: q(:)             ! 
  real(8), allocatable  :: ww(:), ws(:)     ! 
  real(8), allocatable  :: w(:)             ! 

  real(8), allocatable  :: v_Lat(:),v_Lat_Weight(:)      ! ٷ

  real(8), allocatable  :: xv_Lon(:,:), xv_Lat(:,:)

  real(8), allocatable  :: xv_work(:,:)     ! w_xv,xv_w Ѵ

  integer               :: id=65, jd=33     ! xv_work 礭

  real(8), parameter    :: pi=3.1415926535897932385D0

  logical               :: w_base_initialize=.false.   ! եå

  private
  private im, jm, nm                          ! Intel Fortran к

  public it, t, y, ip, p, r, ia, a            ! ѴѺ
  public id, jd                               ! 礭
  public jc                                   ! ʬ־

  public w_base_mpi_Initial                   ! ֥롼
  public w_base_mpi_Finalize                  ! λ֥롼

  public v_Lat, v_Lat_Weight                  ! ʬʻҺɸŤ
  public xv_Lon, xv_Lat                       ! ʬʻҺɸ(im,jc)
  public xv_w, w_xv                           ! Ѵؿ
  public w_StreamPotential2VectorMPI          ! ήݥƥ󥷥뤫®پ׻
  public w_Vector2VorDivMPI                   ! ®پ줫鱲ȯ׻
  public w_VectorCosLat2VorDivMPI             ! ®پ줫鱲ȯ׻

  save it, t, y, ip, p, r, ia, a              ! Ѵ򵭲
  save jc                                     ! ʬʻ礭
  save id, jd                                 ! Ѵ礭
  save w_base_initialize                      ! ե饰

  contains
  !---------------  -----------------
    subroutine w_base_mpi_Initial
      !
      ! ڥȥѴγʻ, ȿꤹ.
      !
      ! ºݤλѤˤϾ̥֥롼 w_mpi_Initial Ѥ뤳.
      !
      integer :: iw, i, j

      allocate(t(im*2))                       ! Ѵ(ʬ)
      allocate(ip(((nm+1)/2+nm+1)*2))         ! Ѵ(ʬ)
      allocate(p(((nm+1)/2+nm+1)*jm))         ! Ѵ(ʬ)
      allocate(r(((nm+1)/2*2+3)*(nm/2+1)))    ! Ѵ(ʬ)
      allocate(ia((nm+1)*(nm+1)*4))           ! Ѵ(ʬ)
      allocate(a((nm+1)*(nm+1)*6))            ! Ѵ(ʬ)
      allocate(y(jm*2))                       ! Ѵ(ʬ)

      !  : ̥롼ˤä w_base_Initial ƤǤ뤳Ȥ
      call snmini(nm,im,jm,jc,it,t,y,ip,p,r,ia,a)

      if ( im/2*2 .eq. im ) then
         id = im+1 
      else
         id = im
      endif
      if ( jc/2*2 .eq. jc ) then
         jd = jc+1
      else
         jd = jc
      endif
      allocate(xv_work(id,jd))                ! Ѵ

      allocate(q(((nm+1)/2+nm+1)*jm))         ! 
 
      iw=max((nm+4)*(nm+3),jd*3*(nm+1),jd*im)
      allocate(ws(iw),ww(iw), w((nm+1)*(nm+1)))    ! 
      allocate(yy(jc/2,4))                         ! Ѵ

      allocate(v_Lat(jc),v_Lat_Weight(jc))             ! ʻɸǼ

      allocate(xv_Lon(0:im-1,jc),xv_Lat(0:im-1,jc))   ! ʻɸǼ

      yy = reshape(y(1:2*jc),(/jc/2,4/))

      do j=1,jc/2
         v_Lat(jc/2+j)   =  asin(yy(j,1))        ! ٺɸ
         v_Lat(jc/2-j+1) = -asin(yy(j,1))        ! ٺɸ
         v_Lat_Weight(jc/2+j)   = 2*yy(j,2)      ! ٽŤ(Gauss grid)
         v_Lat_Weight(jc/2-j+1) = 2*yy(j,2)      ! ٽŤ(Gauss grid)
      enddo
  
      do j=1,jc
         xv_Lon(:,j) = x_Lon
      enddo

      do i=0,im-1
         xv_Lat(i,:) = v_Lat
      enddo

      w_base_initialize = .true.

      call MessageNotify('M','w_base_mpi_initial',&
                         'w_base_mpi_module (2013/02/23) is initialized')
    end subroutine w_base_mpi_Initial

  !--------------- Ѵ(ʻʬ) -----------------

    function xv_w(w_data,ipow,iflag)
      !
      ! ڥȥǡʬʻҥǡѴ(1 ).
      !
      real(8)               :: xv_w(0:im-1,jc)
      !(out) ʻǡ

      real(8), intent(in)   :: w_data((nm+1)*(nm+1))
      !(in) ڥȥǡ

      integer, intent(in), optional  :: ipow      
      !(in) Ѥ 1/cos μ. ά 0. 

      integer, intent(in), optional  :: iflag
      !(in) Ѵμ
      !     0 : ̾Ѵ
      !     1 : ʬѤѴ
      !    -1 : ʬѤѴ
      !     2 : sinդѤѴ
      !     ά 0.
      !
      integer, parameter  :: ipow_default  = 0
      integer, parameter  :: iflag_default = 0

      integer ipval, ifval

      if (present(ipow)) then
         ipval = ipow
      else
         ipval = ipow_default
      endif

      if (present(iflag)) then
         ifval = iflag
      else
         ifval = iflag_default
      endif

      call snts2g(nm,im,id,jc,jd,1,w_data,xv_work,&
                  it,t,y,ip,p,r,ia,a,q,ws,ww,ipval,ifval)

      xv_w=xv_work(1:im,1:jc)

    end function xv_w

    function w_xv(xv_data,ipow,iflag)
      !
      ! ʻҥǡ饹ڥȥǡ()Ѵ(1 ).
      !
      real(8)               :: w_xv((nm+1)*(nm+1))
      !(out) ڥȥǡ

      real(8), intent(in)   :: xv_data(0:im-1,jc)
      !(in) ʻǡ

      integer, intent(in), optional  :: ipow
      !(in) ѴƱ˺Ѥ 1/cos μ. ά 0.

      integer, intent(in), optional  :: iflag
      ! Ѵμ
      !     0 : ̾Ѵ
      !     1 : ʬѤѴ
      !    -1 : ʬѤѴ
      !     2 : sinդѤѴ
      !   ά 0.


      integer, parameter  :: ipow_default  = 0    ! åǥե
      integer, parameter  :: iflag_default = 0    ! åǥե

      integer ipval, ifval

      if (present(ipow)) then
         ipval = ipow
      else
         ipval = ipow_default
      endif

      if (present(iflag)) then
         ifval = iflag
      else
         ifval = iflag_default
      endif

      xv_work(1:im,1:jc)=xv_data

      call sntgms(nm,im,id,jc,jd,1,xv_work,w_xv,&
                 it,t,y,ip,p,r,ia,a,q,ws,ww,ipval,ifval,w)

    end function w_xv

  !----------- ®, ١ȯ, ήݥƥ󥷥׻ -------------

    subroutine w_StreamPotential2VectorMPI(w_Psi, w_Chi, xv_U, xv_V)
      !
      ! ήݥƥ󥷥(ڥȥǡ)®پ(ʻҥǡ)
      ! ()Ѵ(1 , MPI)
      !
      ! ڥȥѴѤʬ׻뤿, Ѵ 2 Ǥ. 
      !
      !   u cos =      ߦ/ߦ - cosբߦ/ߦ, 
      !   v cos = cosբߦ/ߦ +      ߦ/ߦ 
      !
      real(8), intent(in)   :: w_Psi((nm+1)*(nm+1))
      !(in) ήؿ
      real(8), intent(in)   :: w_Chi((nm+1)*(nm+1))
      !(in) ®٥ݥƥ󥷥

      real(8), intent(out)   :: xv_U(0:im-1,1:jc)
      !(out) ®ٷʬ
      real(8), intent(out)   :: xv_V(0:im-1,1:jc)
      !(out) ®ٰʬ

      if ( .not. w_base_initialize ) then
         call MessageNotify('E','w_StreamPotential2VectorMPI',&
              'w_base_module not initialize yet.')
      endif
      !
      !   u cos = ߦ/ߦ - cosբߦ/ߦ η׻
      !
      xv_U = xv_w(w_Chi,ipow=1,iflag=-1) - xv_w(w_Psi,ipow=1,iflag=1) 
      !
      !   v cos = cosբߦ/ߦ + ߦ/ߦ η׻
      !
      xv_V = xv_w(w_Chi,ipow=1,iflag=1) + xv_w(w_Psi,ipow=1,iflag=-1) 

    end subroutine w_StreamPotential2VectorMPI

    subroutine w_Vector2VorDivMPI(xv_U, xv_V, w_Vor, w_Div)
      !
      ! ®پ(ʻҥǡ)鱲١ȯ(ڥȥǡ)
      ! ()Ѵ(1 , MPI)
      ! 
      ! ڥȥѴѤʬ׻뤿, Ѵ 2 Ǥ. 
      !
      !    = 1/cosբv/ߦ - 1/cos (u cos)/ߦ 
      !    D = 1/cosբu/ߦ + 1/cos (v cos)/ߦ
      !
      real(8), intent(in)   :: xv_U(0:im-1,1:jm)
      !(in) ®ٷʬ
      real(8), intent(in)   :: xv_V(0:im-1,1:jm)
      !(in) ®ٰʬ

      real(8), intent(out)   :: w_Vor((nm+1)*(nm+1))
      !(out) ήؿ
      real(8), intent(out)   :: w_Div((nm+1)*(nm+1))
      !(out) ®٥ݥƥ󥷥

      if ( .not. w_base_initialize ) then
         call MessageNotify('E','w_Vector2VorDivMPI',&
              'w_base_module not initialize yet.')
      endif

      !
      !    = 1/cosբv/ߦ - 1/cos (u cos)/ߦ 
      !
      w_Vor = w_xv(xv_V,ipow=1,iflag=-1) - w_xv(xv_U,ipow=1,iflag=1)
      !
      !    D = 1/cosբu/ߦ + 1/cos (v cos)/ߦ
      !
      w_Div = w_xv(xv_U,ipow=1,iflag=-1) + w_xv(xv_V,ipow=1,iflag=1)

    end subroutine w_Vector2VorDivMPI

    subroutine w_VectorCosLat2VorDivMPI(xv_UCosLat, xv_VCosLat, w_Vor, w_Div)
      !
      ! ®پ(ʻҥǡ)鱲١ȯ(ڥȥǡ)
      ! ()Ѵ(1 , MPI)
      ! 
      ! ڥȥѴѤʬ׻뤿, Ѵ 2 Ǥ. 
      !
      !    = 1/cosբv/ߦ - 1/cos (u cos)/ߦ 
      !    D = 1/cosբu/ߦ + 1/cos (v cos)/ߦ
      !
      real(8), intent(in)   :: xv_UCosLat(0:im-1,1:jm)
      !(in) ®ٷʬ * cos(lat)
      real(8), intent(in)   :: xv_VCosLat(0:im-1,1:jm)
      !(in) ®ٰʬ * cos(lat)

      real(8), intent(out)   :: w_Vor((nm+1)*(nm+1))
      !(out) ήؿ
      real(8), intent(out)   :: w_Div((nm+1)*(nm+1))
      !(out) ®٥ݥƥ󥷥

      if ( .not. w_base_initialize ) then
         call MessageNotify('E','w_VectorCosLat2VorDivMPI',&
              'w_base_module not initialize yet.')
      endif

      !
      !    = 1/cosբv/ߦ - 1/cos (u cos)/ߦ 
      !
      w_Vor =   w_xv(xv_VCosLat,ipow=2,iflag=-1) &
              - w_xv(xv_UCosLat,ipow=2,iflag=1)
      !
      !    D = 1/cosբu/ߦ + 1/cos (v cos)/ߦ
      !
      w_Div =   w_xv(xv_UCosLat,ipow=2,iflag=-1) &
              + w_xv(xv_VCosLat,ipow=2,iflag=1)

    end subroutine w_VectorCosLat2VorDivMPI

  !--------------- λ -----------------
    subroutine w_base_mpi_Finalize
      !
      ! ⥸塼νλ(դβ)򤪤ʤ. 
      !
      ! ºݤλѤˤϾ̥֥롼 w_Finalize Ѥ뤳.
      !
      if ( .not. w_base_initialize ) then
         call MessageNotify('W','w_base_mpi_Finalize',&
              'w_base_mpi_module not initialized yet')
         return
      endif

      deallocate(t)            ! Ѵ(ʬ)
      deallocate(ip)           ! Ѵ(ʬ)
      deallocate(p)            ! Ѵ(ʬ)
      deallocate(r)            ! Ѵ(ʬ)
      deallocate(ia)           ! Ѵ(ʬ)
      deallocate(a)            ! Ѵ(ʬ)
      deallocate(y)            ! Ѵ(ʬ)

      deallocate(xv_work)      ! Ѵ
      deallocate(q)            ! 
      deallocate(ws,ww,w)      ! 
      deallocate(yy)           ! Ѵ

      deallocate(v_Lat,v_Lat_Weight)   ! ʻɸǼ
      deallocate(xv_Lon,xv_Lat)        ! ʻɸǼ

      w_base_initialize = .false.

      call MessageNotify('M','w_base_mpi_Finalize',&
           'w_base_mpi_module (2013/02/23) is finalized')

    end subroutine w_base_mpi_Finalize

  end module w_base_mpi_module
